/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.BASHConfidenceSettings;
import com.sygate.scm.common.configobject.schema.BASHHighConfidence;
import com.sygate.scm.common.configobject.schema.BASHLowConfidence;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.util.BooleanWrapper;

public class BASHConfidenceObject
extends AbstractUIObject {
    private BASHConfidenceSettings confidenceSettings;
    public static final int LOG = 0;
    public static final int QUARANTINE = 1;
    public static final int DELETE = 2;
    public static final int DISABLED = 3;

    public BASHConfidenceObject() {
        this.confidenceSettings = this.getDefaultConfidence();
    }

    public BASHConfidenceObject(BASHConfidenceSettings confidence) {
        this.confidenceSettings = confidence != null ? confidence : this.getDefaultConfidence();
    }

    private BASHConfidenceSettings getDefaultConfidence() {
        BASHConfidenceSettings confidence = new BASHConfidenceSettings();
        BASHHighConfidence highConfidence = new BASHHighConfidence();
        highConfidence.setOptLockHighConfidenceAction(highConfidence.getDefLockHighConfidenceAction());
        highConfidence.setHighConfidenceAction(BASHHighConfidence.LOG);
        BASHLowConfidence lowConfidence = new BASHLowConfidence();
        lowConfidence.setLowConfidenceAction(BASHLowConfidence.LOG);
        lowConfidence.setOptLockLowConfidenceAction(lowConfidence.getDefLockLowConfidenceAction());
        lowConfidence.setOptEnableAggressiveMode(lowConfidence.getDefEnableAggressiveMode());
        lowConfidence.setOptLockAggressiveMode(lowConfidence.getDefLockAggressiveMode());
        confidence.setOptBASHHighConfidence(highConfidence);
        confidence.setOptBASHLowConfidence(lowConfidence);
        return confidence;
    }

    public void setConfidenceSettings(BASHConfidenceSettings confidence) {
        if (confidence != null) {
            this.confidenceSettings = confidence;
        }
    }

    public BASHHighConfidence getHighConfidenceSettings() {
        if (this.confidenceSettings != null) {
            return this.confidenceSettings.getOptBASHHighConfidence();
        }
        return null;
    }

    public void setHighConfidenceSettings(BASHHighConfidence highConfidence) {
        if (highConfidence != null && this.confidenceSettings != null) {
            this.confidenceSettings.setOptBASHHighConfidence(highConfidence);
        }
    }

    public BASHLowConfidence getLowConfidenceSettings() {
        if (this.confidenceSettings != null) {
            return this.confidenceSettings.getOptBASHLowConfidence();
        }
        return null;
    }

    public void setLowConfidenceSettings(BASHLowConfidence lowConfidence) {
        if (lowConfidence != null && this.confidenceSettings != null) {
            this.confidenceSettings.setOptBASHLowConfidence(lowConfidence);
        }
    }

    public Integer getLowConfidenceAction() {
        BASHLowConfidence lowConfidence;
        if (this.confidenceSettings != null && (lowConfidence = this.confidenceSettings.getOptBASHLowConfidence()) != null) {
            return lowConfidence.getLowConfidenceAction();
        }
        return null;
    }

    public void setLowConfidenceAction(int actionIndex) {
        if (this.confidenceSettings != null && this.confidenceSettings.getOptBASHLowConfidence() != null) {
            switch (actionIndex) {
                case 0: {
                    this.confidenceSettings.getOptBASHLowConfidence().setLowConfidenceAction(BASHLowConfidence.LOG);
                    break;
                }
                case 1: {
                    this.confidenceSettings.getOptBASHLowConfidence().setLowConfidenceAction(BASHLowConfidence.QUARANTINE);
                    break;
                }
                case 2: {
                    this.confidenceSettings.getOptBASHLowConfidence().setLowConfidenceAction(BASHLowConfidence.DELETE);
                    break;
                }
                case 3: {
                    this.confidenceSettings.getOptBASHLowConfidence().setLowConfidenceAction(BASHLowConfidence.DISABLED);
                    break;
                }
            }
        }
    }

    public Integer getHighConfidenceAction() {
        BASHHighConfidence highConfidence;
        if (this.confidenceSettings != null && (highConfidence = this.confidenceSettings.getOptBASHHighConfidence()) != null) {
            return highConfidence.getHighConfidenceAction();
        }
        return null;
    }

    public void setHighConfidenceAction(int actionIndex) {
        if (this.confidenceSettings != null && this.confidenceSettings.getOptBASHHighConfidence() != null) {
            switch (actionIndex) {
                case 0: {
                    this.confidenceSettings.getOptBASHHighConfidence().setHighConfidenceAction(BASHHighConfidence.LOG);
                    break;
                }
                case 1: {
                    this.confidenceSettings.getOptBASHHighConfidence().setHighConfidenceAction(BASHHighConfidence.QUARANTINE);
                    break;
                }
                case 2: {
                    this.confidenceSettings.getOptBASHHighConfidence().setHighConfidenceAction(BASHHighConfidence.DELETE);
                    break;
                }
            }
        }
    }

    public BooleanWrapper getEnableAggressiveMode() {
        BASHLowConfidence lowConfidence;
        if (this.confidenceSettings != null && (lowConfidence = this.confidenceSettings.getOptBASHLowConfidence()) != null) {
            Boolean value = lowConfidence.getOptEnableAggressiveMode() != null ? lowConfidence.getOptEnableAggressiveMode() : lowConfidence.getDefEnableAggressiveMode();
            return BooleanWrapper.getInstance((Boolean)value);
        }
        return BooleanWrapper.NULL_VALUE;
    }

    public void setEnableAggressiveMode(Boolean value) {
        BASHLowConfidence lowConfidence;
        if (this.confidenceSettings != null && value != null && (lowConfidence = this.confidenceSettings.getOptBASHLowConfidence()) != null) {
            lowConfidence.setOptEnableAggressiveMode(value);
        }
    }

    public BooleanWrapper getLockedAggressiveMode() {
        BASHLowConfidence lowConfidence;
        if (this.confidenceSettings != null && (lowConfidence = this.confidenceSettings.getOptBASHLowConfidence()) != null) {
            Boolean value = lowConfidence.getOptLockAggressiveMode() != null ? lowConfidence.getOptLockAggressiveMode() : lowConfidence.getDefLockAggressiveMode();
            return BooleanWrapper.getInstance((Boolean)value);
        }
        return BooleanWrapper.NULL_VALUE;
    }

    public void setLockedAggressiveMode(Boolean value) {
        BASHLowConfidence lowConfidence;
        if (this.confidenceSettings != null && value != null && (lowConfidence = this.confidenceSettings.getOptBASHLowConfidence()) != null) {
            lowConfidence.setOptLockAggressiveMode(value);
        }
    }

    public void setLockedHighConfidenceAction(Boolean value) {
        BASHHighConfidence highConfidence;
        if (this.confidenceSettings != null && value != null && (highConfidence = this.confidenceSettings.getOptBASHHighConfidence()) != null) {
            highConfidence.setOptLockHighConfidenceAction(value);
        }
    }

    public BooleanWrapper getLockedHighConfidenceAction() {
        BASHHighConfidence highConfidence;
        if (this.confidenceSettings != null && (highConfidence = this.confidenceSettings.getOptBASHHighConfidence()) != null) {
            Boolean value = highConfidence.getOptLockHighConfidenceAction() != null ? highConfidence.getOptLockHighConfidenceAction() : highConfidence.getDefLockHighConfidenceAction();
            return BooleanWrapper.getInstance((Boolean)value);
        }
        return BooleanWrapper.NULL_VALUE;
    }

    public void setLockedLowConfidenceAction(Boolean value) {
        BASHLowConfidence lowConfidence;
        if (this.confidenceSettings != null && value != null && (lowConfidence = this.confidenceSettings.getOptBASHLowConfidence()) != null) {
            lowConfidence.setOptLockLowConfidenceAction(value);
        }
    }

    public BooleanWrapper getLockedLowConfidenceAction() {
        BASHLowConfidence lowConfidence;
        if (this.confidenceSettings != null && (lowConfidence = this.confidenceSettings.getOptBASHLowConfidence()) != null) {
            Boolean value = lowConfidence.getOptLockLowConfidenceAction() != null ? lowConfidence.getOptLockLowConfidenceAction() : lowConfidence.getDefLockLowConfidenceAction();
            return BooleanWrapper.getInstance((Boolean)value);
        }
        return BooleanWrapper.NULL_VALUE;
    }

    public BASHConfidenceSettings getSchemaObject() {
        return this.confidenceSettings;
    }
}

