/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.BASHBPESettings;
import com.sygate.scm.console.logicobject.AbstractUIObject;

public class BASHBPESettingsObject
extends AbstractUIObject {
    private BASHBPESettings bpeSettings;
    public static final int IGNORE = 0;
    public static final int PROMPT = 1;
    public static final int BLOCK = 2;
    public static final int LOG = 3;

    public BASHBPESettingsObject() {
        this.bpeSettings = this.getDefaultBPESettings();
    }

    public BASHBPESettingsObject(BASHBPESettings settings) {
        this.bpeSettings = settings != null ? settings : this.getDefaultBPESettings();
    }

    private BASHBPESettings getDefaultBPESettings() {
        BASHBPESettings defBPEsettings = new BASHBPESettings();
        defBPEsettings.setHighConfidenceAction(BASHBPESettings.IGNORE);
        defBPEsettings.setOptLockHighConfidenceAction(defBPEsettings.getDefLockHighConfidenceAction());
        defBPEsettings.setLowConfidenceAction(BASHBPESettings.IGNORE);
        defBPEsettings.setOptLockLowConfidenceAction(defBPEsettings.getDefLockLowConfidenceAction());
        return defBPEsettings;
    }

    public Integer getLowConfidenceAction() {
        return this.bpeSettings.getLowConfidenceAction();
    }

    public Boolean getLockHighConfidenceAction() {
        return this.bpeSettings.getOptLockHighConfidenceAction() != null ? this.bpeSettings.getOptLockHighConfidenceAction() : this.bpeSettings.getDefLockHighConfidenceAction();
    }

    public Boolean getLockLowConfidenceAction() {
        return this.bpeSettings.getOptLockLowConfidenceAction() != null ? this.bpeSettings.getOptLockLowConfidenceAction() : this.bpeSettings.getDefLockLowConfidenceAction();
    }

    public void setLowConfidenceAction(int actionIndex) {
        switch (actionIndex) {
            case 0: {
                this.bpeSettings.setLowConfidenceAction(BASHBPESettings.IGNORE);
                break;
            }
            case 1: {
                this.bpeSettings.setLowConfidenceAction(BASHBPESettings.PROMPT);
                break;
            }
            case 2: {
                this.bpeSettings.setLowConfidenceAction(BASHBPESettings.BLOCK);
                break;
            }
            case 3: {
                this.bpeSettings.setLowConfidenceAction(BASHBPESettings.LOG);
                break;
            }
        }
    }

    public void setLockHighConfidenceAction(Boolean value) {
        if (value != null) {
            this.bpeSettings.setOptLockHighConfidenceAction(value);
        }
    }

    public void setBPEEnabled(boolean enabled) {
        this.bpeSettings.setOptEnabled(Boolean.valueOf(enabled));
    }

    public void setBPELocked(boolean locked) {
        this.bpeSettings.setOptLocked(Boolean.valueOf(locked));
    }

    public boolean isBPEEnabled() {
        if (this.bpeSettings.getOptEnabled() != null) {
            return this.bpeSettings.getOptEnabled();
        }
        return this.bpeSettings.getDefEnabled();
    }

    public boolean isBPELocked() {
        if (this.bpeSettings.getOptLocked() != null) {
            return this.bpeSettings.getOptLocked();
        }
        return this.bpeSettings.getDefLocked();
    }

    public void setHighConfidenceAction(int actionIndex) {
        switch (actionIndex) {
            case 0: {
                this.bpeSettings.setHighConfidenceAction(BASHBPESettings.IGNORE);
                break;
            }
            case 1: {
                this.bpeSettings.setHighConfidenceAction(BASHBPESettings.PROMPT);
                break;
            }
            case 2: {
                this.bpeSettings.setHighConfidenceAction(BASHBPESettings.BLOCK);
                break;
            }
            case 3: {
                this.bpeSettings.setHighConfidenceAction(BASHBPESettings.LOG);
                break;
            }
        }
    }

    public void setLockLowConfidenceAction(Boolean value) {
        if (value != null) {
            this.bpeSettings.setOptLockLowConfidenceAction(value);
        }
    }

    public BASHBPESettings getSchemaObject() {
        return this.bpeSettings;
    }

    public Integer getHighConfidenceAction() {
        return this.bpeSettings.getHighConfidenceAction();
    }
}

