/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AutoLocation;
import com.sygate.scm.common.configobject.schema.EnableAutoLocationSwitching;
import com.sygate.scm.common.configobject.schema.Location;
import com.sygate.scm.common.configobject.schema.LocationArray;
import com.sygate.scm.common.configobject.schema.LocationChangeNotification;
import com.sygate.scm.common.configobject.schema.RememberLastLocation;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.logicobject.PolicyLogEvent;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public class AutoLocationObject
extends AbstractUIObject {
    private AutoLocation _autoLocation;
    private List<LocationObject> locations = new ArrayList<LocationObject>();
    private LocationObject defaultLoc;
    private Map<String, TopLevelObject> newObjSet = new HashMap<String, TopLevelObject>();
    private Map<String, TopLevelObject> deletedObjSet = new HashMap<String, TopLevelObject>();
    private List<PolicyLogEvent> logList = new Vector<PolicyLogEvent>();

    public AutoLocationObject() {
    }

    public AutoLocationObject(AutoLocation auto) throws ConsoleException {
        this._autoLocation = auto;
        LocationArray locArrayObj = this._autoLocation.getLocationArray();
        String defLocationId = locArrayObj.getDefaultLocation();
        for (int i = 0; i < locArrayObj.getLocationCount(); ++i) {
            Location loc = locArrayObj.getLocation(i);
            boolean isDefault = PolicyHandler.isDefaultLocation(loc, defLocationId);
            LocationObject locObj = new LocationObject(loc, isDefault, false);
            this.locations.add(locObj);
            if (!isDefault) continue;
            this.defaultLoc = locObj;
        }
    }

    public void deleteLocation(LocationObject locObj) {
        locObj.delete();
        Map<String, TopLevelObject> deletedObj = locObj.getDeletedObj();
        PolicyHandler.dumpObjects(deletedObj, this.deletedObjSet);
        deletedObj.clear();
        this.locations.remove(locObj);
        this.addLog(1, MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AutoLocationObject.logDeleteALocation") + locObj.getName());
    }

    public LocationObject addANewLocation() throws Exception {
        String newLocName = this.getNewLocName();
        LocationObject newObj = new LocationObject(newLocName, this._autoLocation);
        this.addLocation(newObj);
        Map<String, TopLevelObject> newObjOfLoc = newObj.getNewObjSet();
        PolicyHandler.dumpObjects(newObjOfLoc, this.newObjSet);
        PolicyHandler.addNewOject(this.newObjSet.values());
        newObjOfLoc.clear();
        this.addLog(0, MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AutoLocationObject.logAddALocation") + newLocName);
        return newObj;
    }

    public LocationObject addANewLocation(String newLocName) throws Exception {
        if (!this.isNewNameValid(newLocName)) {
            return null;
        }
        LocationObject newObj = new LocationObject(newLocName, this._autoLocation);
        this.addLocation(newObj);
        Map<String, TopLevelObject> newObjOfLoc = newObj.getNewObjSet();
        PolicyHandler.dumpObjects(newObjOfLoc, this.newObjSet);
        PolicyHandler.addNewOject(newObjOfLoc.values());
        newObjOfLoc.clear();
        this.addLog(0, MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AutoLocationObject.logAddALocation") + newLocName);
        return newObj;
    }

    public void addANewLocation(LocationObject newLoc) {
        this.addLocation(newLoc);
        Map<String, TopLevelObject> newObjOfLoc = newLoc.getNewObjSet();
        PolicyHandler.dumpObjects(newObjOfLoc, this.newObjSet);
        PolicyHandler.addNewOject(newObjOfLoc.values());
        newObjOfLoc.clear();
        this.addLog(0, MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AutoLocationObject.logAddALocation") + newLoc.getName());
    }

    public void addANewLocation(LocationObject newLoc, boolean makeNewName) {
        if (makeNewName) {
            String newName = this.adjustName(newLoc.getName());
            newLoc.setName(newName);
        }
        this.addANewLocation(newLoc);
    }

    public void moveDownLoc(LocationObject locObj) {
        if (locObj == null) {
            return;
        }
        int index = this.locations.indexOf(locObj);
        LocationArray locArray = this._autoLocation.getLocationArray();
        if (index != -1 && index < locArray.getLocationCount() - 1) {
            Location curLoc = locArray.getLocation(index);
            locArray.removeLocation(curLoc);
            int i = locArray.getObsoleteItemCount();
            while (--i >= 0) {
                ObsoleteItem item = locArray.getObsoleteItem(i);
                if (!item.getDeletedI().equals(curLoc.getI())) continue;
                locArray.removeObsoleteItem(item);
                break;
            }
            locArray.addLocation(index + 1, curLoc);
            this.locations.remove(index);
            this.locations.add(index + 1, locObj);
            this.addLog(2, MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AutoLocationObject.logMoveDownALocation") + locObj.getName());
        }
    }

    public void moveUpLoc(LocationObject locObj) {
        if (locObj == null) {
            return;
        }
        int index = this.locations.indexOf(locObj);
        LocationArray locArray = this._autoLocation.getLocationArray();
        if (index != -1 && index > 0) {
            Location curLoc = locArray.getLocation(index);
            locArray.removeLocation(curLoc);
            int i = locArray.getObsoleteItemCount();
            while (--i >= 0) {
                ObsoleteItem item = locArray.getObsoleteItem(i);
                if (!item.getDeletedI().equals(curLoc.getI())) continue;
                locArray.removeObsoleteItem(item);
                break;
            }
            locArray.addLocation(index - 1, curLoc);
            this.locations.remove(index);
            this.locations.add(index - 1, locObj);
            this.addLog(2, MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AutoLocationObject.logMoveUpALocation") + locObj.getName());
        }
    }

    public void clearNewObjSet() {
        this.newObjSet.clear();
    }

    public void resortData() {
        for (LocationObject locObj : this.locations) {
            locObj.resortData();
        }
    }

    public void addLog(int eventId, String desc) {
        GUID owner = PolicyHandler.getOwnerOfObject((ConfigObject)this._autoLocation);
        this.logList.add(new PolicyLogEvent(eventId, owner.toString(), desc));
    }

    private void addLocation(LocationObject locObj) {
        Location loc = locObj.getLocationObject();
        LocationArray locArray = this._autoLocation.getLocationArray();
        locArray.addLocation(loc);
        this.locations.add(locObj);
    }

    private String adjustName(String name) {
        Integer number;
        TreeSet<Integer> numberList = new TreeSet<Integer>();
        for (LocationObject locObj : this.locations) {
            String curName = locObj.getName();
            if (!curName.startsWith((String)name)) continue;
            int pos = ((String)name).length();
            if (pos == curName.length()) {
                numberList.add(1);
                continue;
            }
            if (!curName.substring(pos, pos + 1).equals(" ")) continue;
            try {
                String numStr = curName.substring(pos + 1);
                int number2 = Integer.parseInt(numStr);
                numberList.add(number2);
            }
            catch (NumberFormatException fex) {
                LoggerUtilities.logException((Throwable)fex);
            }
        }
        int max = 0;
        Iterator iterator = numberList.iterator();
        while (iterator.hasNext() && max + 1 == (number = (Integer)iterator.next())) {
            ++max;
        }
        if (max > 0) {
            name = (String)name + " " + (max + 1);
        }
        return name;
    }

    public List<LocationObject> getLocations() {
        return this.locations;
    }

    public void setDefaultLocation(LocationObject loc) {
        if (this.defaultLoc != null) {
            this.defaultLoc.setDefaultLoc(false);
        }
        loc.setDefaultLoc(true);
        this.defaultLoc = loc;
        LocationArray locArray = this._autoLocation.getLocationArray();
        locArray.setDefaultLocation(loc.getId());
    }

    public AutoLocationObject getClone() throws ConsoleException {
        try {
            AutoLocation newAuto = (AutoLocation)PolicyHandler.getCopyOfObj((ConfigObject)this._autoLocation);
            AutoLocationObject newObj = new AutoLocationObject(newAuto);
            return newObj;
        }
        catch (ConsoleException cex) {
            throw cex;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public AutoLocation getAutoLocation() {
        return this._autoLocation;
    }

    public String getNewLocName() {
        String name = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AutoLocationObject.nameNewLocation");
        name = this.adjustName(name);
        return name;
    }

    public Integer getLocationCheckFrequency() {
        return this._autoLocation.getOptLocationCheckFrequency();
    }

    public boolean getEnableNotification() {
        LocationChangeNotification notify = this._autoLocation.getOptLocationChangeNotification();
        if (notify != null) {
            return notify.getOptEnable();
        }
        return false;
    }

    public String getNotificationMessage() {
        LocationChangeNotification notify = this._autoLocation.getOptLocationChangeNotification();
        if (notify != null) {
            return notify.getOptNotificationMessage();
        }
        return null;
    }

    public Integer getDefLocationCheckFrequency() {
        return this._autoLocation.getDefLocationCheckFrequency();
    }

    public void setLocationCheckFrequency(Integer frequency) {
        this._autoLocation.setOptLocationCheckFrequency(frequency);
    }

    public void setEnableNotification(boolean enableNotification) {
        LocationChangeNotification notify = this._autoLocation.getOptLocationChangeNotification();
        if (notify == null) {
            notify = new LocationChangeNotification();
        }
        notify.setOptEnable(Boolean.valueOf(enableNotification));
        this._autoLocation.setOptLocationChangeNotification(notify);
    }

    public void setNotificationMessage(String msg) {
        LocationChangeNotification notify = this._autoLocation.getOptLocationChangeNotification();
        if (notify == null) {
            notify = new LocationChangeNotification();
        }
        notify.setOptNotificationMessage(msg);
        this._autoLocation.setOptLocationChangeNotification(notify);
    }

    public String getCommandToRun() {
        return this._autoLocation.getOptCommandToRun();
    }

    public void setCommandToRun(String command) {
        this._autoLocation.setOptCommandToRun(command);
    }

    public boolean setLocNewName(LocationObject locObj, String newName) {
        if (this.isNewNameValid(locObj, newName)) {
            locObj.setName(newName);
            return true;
        }
        return false;
    }

    public boolean isNewNameValid(LocationObject locObj, String newName) {
        for (LocationObject curObj : this.locations) {
            if (curObj == locObj || !curObj.getName().equalsIgnoreCase(newName)) continue;
            return false;
        }
        return true;
    }

    public boolean isNewNameValid(String newName) {
        for (LocationObject curObj : this.locations) {
            if (!curObj.getName().equalsIgnoreCase(newName)) continue;
            return false;
        }
        return true;
    }

    public Map<String, TopLevelObject> getNewObjSet() {
        return this.newObjSet;
    }

    public LocationObject getLocation(String locId) {
        if (locId == null || locId.length() == 0) {
            return null;
        }
        for (LocationObject curLoc : this.locations) {
            if (!curLoc.getId().equals(locId)) continue;
            return curLoc;
        }
        return null;
    }

    public boolean isRememberLastLocation() {
        RememberLastLocation rememberLastLoc = this._autoLocation.getOptRememberLastLocation();
        if (rememberLastLoc != null) {
            int remember = rememberLastLoc.getContent();
            return remember != 0;
        }
        return true;
    }

    public boolean setRememberLastLocation(boolean toRemember) {
        boolean oldValue = this.isRememberLastLocation();
        if (oldValue == toRemember) {
            return false;
        }
        RememberLastLocation rememberLastLoc = this._autoLocation.getOptRememberLastLocation();
        if (rememberLastLoc == null) {
            rememberLastLoc = new RememberLastLocation();
            this._autoLocation.setOptRememberLastLocation(rememberLastLoc);
        }
        rememberLastLoc.setContent(toRemember ? Integer.valueOf(1) : Integer.valueOf(0));
        return true;
    }

    public boolean isEnableAutoLocationSwitch() {
        EnableAutoLocationSwitching rememberLastLoc = this._autoLocation.getOptEnableAutoLocationSwitching();
        if (rememberLastLoc != null) {
            int remember = rememberLastLoc.getContent();
            return remember != 0;
        }
        return true;
    }

    public boolean setEnableAutoLocationSwitch(boolean toRemember) {
        boolean oldValue = this.isEnableAutoLocationSwitch();
        if (oldValue == toRemember) {
            return false;
        }
        EnableAutoLocationSwitching rememberLastLoc = this._autoLocation.getOptEnableAutoLocationSwitching();
        if (rememberLastLoc == null) {
            rememberLastLoc = new EnableAutoLocationSwitching();
            this._autoLocation.setOptEnableAutoLocationSwitching(rememberLastLoc);
        }
        rememberLastLoc.setContent(toRemember ? Integer.valueOf(1) : Integer.valueOf(0));
        return true;
    }

    public Map<String, TopLevelObject> getDeletedObj() {
        return this.deletedObjSet;
    }

    public boolean isOtherLocationsDisconnectToServer(String thisLocId) {
        int count = 0;
        for (LocationObject curObj : this.locations) {
            if (curObj.getId().equals(thisLocId) || !curObj.isEnabled() || !curObj.isConnectToServer()) continue;
            ++count;
        }
        return count > 0;
    }

    public List<PolicyLogEvent> getLogList() {
        return this.logList;
    }

    public int getAutoLocationSize() {
        int count = 0;
        for (LocationObject locObj : this.locations) {
            if (!locObj.isEnabled() || locObj.getExcludedAutoLoc()) continue;
            ++count;
        }
        return count;
    }
}

