/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AppliedPolicyArray;
import com.sygate.scm.common.configobject.schema.FirewallRuleSystem;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.ObjInfo;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AppProtectionPolicyObject;
import com.sygate.scm.console.logicobject.FirewallPolicyObject;
import com.sygate.scm.console.logicobject.HidPolicyObject;
import com.sygate.scm.console.logicobject.HostIntegrityObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.MemPolicyObject;
import com.sygate.scm.console.logicobject.NtrPolicyObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PhysicalFileObject;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyLogEvent;
import com.sygate.scm.console.logicobject.PolicyReferenceObject;
import com.sygate.scm.console.logicobject.QuarantineFirewallObject;
import com.sygate.scm.console.logicobject.QuarantineOSPObject;
import com.sygate.scm.console.logicobject.TdadPolicyObject;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptivePolicyObject;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.QuarantineAdaptivePolicyObject;
import com.sygate.scm.console.ui.policy.av.logicobject.AvPolicyObject;
import com.sygate.scm.console.ui.policy.av.logicobject.QuarantineAvPolicyObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.dialog.PolicyType;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.QuarantineIdsPolicyObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.QuarantineLuPolicyObject;
import com.sygate.scm.console.ui.policy.mem.logicobject.QuarantineMemPolicyObject;
import com.sygate.scm.console.ui.policy.ntr.logicobject.QuarantineNtrPolicyObject;
import com.sygate.scm.console.ui.policy.override.logicobject.OverridePolicyObject;
import com.sygate.scm.console.ui.policy.override.logicobject.QuarantineOverridePolicyObject;
import com.sygate.scm.console.ui.policy.up.logicobject.QuarantineUpgradePolicyObject;
import com.sygate.scm.console.ui.policy.up.logicobject.UpgradePolicyObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.LoggerUtilities;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class AppliedPolicyObject
extends AbstractUIObject {
    private MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.logicobject.logicobject");
    String locName;
    AppliedPolicyArray policyArray;
    String ownerId;
    private Map<String, TopLevelObject> newObjSet = new HashMap<String, TopLevelObject>();
    private Map<String, TopLevelObject> changedObjSet = new HashMap<String, TopLevelObject>();
    private Map<String, TopLevelObject> deletedObjSet = new HashMap<String, TopLevelObject>();
    private List<PolicyLogEvent> logList = new Vector<PolicyLogEvent>();
    private PhysicalFileObject physicalFileObject;

    public AppliedPolicyObject(AppliedPolicyArray array, String locName, String ownerId) {
        this.policyArray = array;
        this.locName = locName;
        this.ownerId = ownerId;
    }

    public AppliedPolicyObject getClone() throws ConsoleException {
        AppliedPolicyArray newAddr = (AppliedPolicyArray)PolicyHandler.getCopyOfObj((ConfigObject)this.policyArray);
        AppliedPolicyObject newObj = new AppliedPolicyObject(newAddr, this.locName, this.ownerId);
        return newObj;
    }

    public PolicyInt getPolicy(PolicyInt policyObj) throws ConsoleException {
        if (policyObj == null) {
            return policyObj;
        }
        TopLevelObject schemaObj = this.getSchemaObjectOfPolicy(policyObj);
        if (schemaObj != null) {
            policyObj.setSchemaObj(schemaObj);
        }
        return policyObj;
    }

    public TopLevelObject getSchemaObjectOfPolicy(PolicyInt policyObj) throws ConsoleException {
        if (this.policyArray != null) {
            for (ObjReference objRef : this.policyArray.getObjReference()) {
                if (!objRef.getTargetType().equals(policyObj.getTargetType()) || !objRef.getName().equals(policyObj.getTargetName())) continue;
                return PolicyHandler.getObject(objRef.getTargetType(), objRef.getTargetId());
            }
        }
        return null;
    }

    public TopLevelObject getSchemaObjectOfPolicyFromDB(PolicyInt policyObj) throws ConsoleException {
        if (this.policyArray != null) {
            for (ObjReference objRef : this.policyArray.getObjReference()) {
                if (!objRef.getTargetType().equals(policyObj.getTargetType()) || !objRef.getName().equals(policyObj.getTargetName())) continue;
                return PolicyHandler.getObjectFromDB(objRef.getTargetType(), objRef.getTargetId());
            }
        }
        return null;
    }

    public boolean existType(String policyTargetName) {
        if (this.policyArray != null) {
            for (ObjReference objRef : this.policyArray.getObjReference()) {
                if (!objRef.getName().equals(policyTargetName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean existPolicy(PolicyInt policyObj) {
        if (this.policyArray != null) {
            for (ObjReference objRef : this.policyArray.getObjReference()) {
                if (!objRef.getTargetId().equals(policyObj.getId()) || !objRef.getName().equals(policyObj.getTargetName()) || !objRef.getTargetType().equals(policyObj.getTargetType())) continue;
                return true;
            }
        }
        return false;
    }

    public String getAppliedPolicyId(int applyType) throws ConsoleException {
        if (this.policyArray != null) {
            String objRefName = this.getObjRefName(applyType);
            for (ObjReference objRef : this.policyArray.getObjReference()) {
                if (!objRef.getName().equals(objRefName)) continue;
                return objRef.getTargetId();
            }
        }
        return null;
    }

    public boolean hasHostIntegrityPolicy() throws ConsoleException {
        return this.checkPolicyLinkExist(new HostIntegrityObject());
    }

    private boolean checkPolicyLinkExist(PolicyInt policyObj) {
        if (this.policyArray != null) {
            for (ObjReference objRef : this.policyArray.getObjReference()) {
                if (!objRef.getTargetType().equals(policyObj.getTargetType()) || !objRef.getName().equals(policyObj.getTargetName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkLocalPolicyLinkExist(PolicyInt policyObj) {
        if (this.policyArray != null) {
            for (ObjReference objRef : this.policyArray.getObjReference()) {
                if (!objRef.getTargetType().equals(policyObj.getTargetType()) || !objRef.getName().equals(policyObj.getLocalReferenceName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasFirewallPolicy() throws ConsoleException {
        return this.checkPolicyLinkExist(new FirewallPolicyObject());
    }

    public boolean hasInheritedFirewallPolicy() throws ConsoleException {
        FirewallPolicyObject policyObj = new FirewallPolicyObject();
        boolean hasFirewall = this.checkLocalPolicyLinkExist(policyObj);
        if (!hasFirewall) {
            return false;
        }
        FwFirewallPolicy fwPolicy = (FwFirewallPolicy)this.getLocalSchemaOfPolicyFromDB(policyObj);
        if (fwPolicy == null) {
            return false;
        }
        FirewallRuleSystem fwSystem = fwPolicy.getOptFirewallRuleSystem();
        if (fwSystem == null) {
            return false;
        }
        Boolean inherit = fwSystem.getOptMergeLocalAndParentRules();
        if (inherit == null) {
            inherit = fwSystem.getDefMergeLocalAndParentRules();
        }
        return inherit;
    }

    public String getLocName() {
        return this.locName;
    }

    public List<PolicyInt> getAllAppliedPolicyFromDB() throws ConsoleException {
        ArrayList<PolicyInt> allPolicy = new ArrayList<PolicyInt>();
        if (this.policyArray != null) {
            List<PolicyIntObjectBase> allObjs = this.getAllAppliedPolicyObjectList();
            for (PolicyInt policyInt : allObjs) {
                TopLevelObject schObj = this.getSchemaObjectOfPolicyFromDB(policyInt);
                if (schObj == null) continue;
                policyInt.setSchemaObj(schObj);
                boolean isLocal = this.isAppliedLocalPolicy(policyInt);
                policyInt.setLocalPolicy(isLocal);
                allPolicy.add(policyInt);
            }
        }
        return Collections.unmodifiableList(allPolicy);
    }

    public List<ObjInfoObject> getAllAppliedPolicyObjInfo() {
        ArrayList<ObjInfoObject> objInfoObjs = new ArrayList<ObjInfoObject>();
        if (this.policyArray != null) {
            HashMap<String, String> refs = new HashMap<String, String>();
            List<String> targetNames = this.getAllAppliedPolicyTargetNames();
            for (ObjReference objRef : this.policyArray.getObjReference()) {
                String targetName = objRef.getName();
                if (!targetNames.contains(targetName)) continue;
                refs.put(targetName, objRef.getTargetId());
            }
            if (!refs.isEmpty()) {
                try {
                    HashMap<String, ObjInfo> objInfos = DataobjectManager.getInstance().getMutipleObjectInfo(new ArrayList<String>(refs.values()));
                    for (Map.Entry ref : refs.entrySet()) {
                        String targetName = (String)ref.getKey();
                        String id = (String)ref.getValue();
                        ObjInfo info = objInfos.get(id);
                        if (info == null) continue;
                        objInfoObjs.add(new ObjInfoObject(this.isLocalAppliedPolicy(id, targetName), info, targetName));
                    }
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
        }
        return objInfoObjs;
    }

    public void addNewSharedPolicy(PolicyInt policy) {
        AppliedPolicyArray array = this.getPolicyArray();
        ObjReference objRef = this.getAppliedReferenceOfPolicy(policy);
        if (objRef == null) {
            objRef = new ObjReference();
            objRef.setTargetType(policy.getTargetType());
            objRef.setName(policy.getTargetName());
            array.addObjReference(objRef);
        }
        objRef.setTargetId(policy.getId());
        ObjReference locObjRef = this.getAppliedLocalReferenceOfPolicy(policy);
        if (locObjRef != null) {
            try {
                TopLevelObject localObj = PolicyHandler.getObject(locObjRef.getTargetType(), locObjRef.getTargetId());
                PolicyHandler.deleteObject(localObj, this.deletedObjSet, this.newObjSet, this.changedObjSet);
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            locObjRef.getParent().removeChild((AbstractSchema)locObjRef);
        }
        PolicyHandler.dumpObjects(policy.getNewObjSet(), this.newObjSet);
        PolicyHandler.dumpObjects(policy.getChangedObjSet(), this.changedObjSet);
        PolicyHandler.dumpObjects(policy.getDeletedObjSet(), this.deletedObjSet);
        policy.clearAllObjSets();
        String pattern = this.res.getString("AppliedPolicyObject.addPolicy");
        Object[] params = new Object[]{policy.getTypeDesc(), policy.getName(), this.locName};
        this.addLog(0, MessageFormat.format(pattern, params));
    }

    public void addNewLocalPolicy(PolicyInt policy) {
        AppliedPolicyArray array = this.getPolicyArray();
        ObjReference objRef2 = null;
        for (ObjReference objRef : array.getObjReference()) {
            if (!objRef.getName().equals(policy.getLocalReferenceName()) || !objRef.getTargetType().equals(policy.getTargetType())) continue;
            objRef2 = objRef;
            break;
        }
        if (objRef2 == null) {
            objRef2 = new ObjReference();
            objRef2.setTargetType(policy.getTargetType());
            objRef2.setName(policy.getLocalReferenceName());
            array.addObjReference(objRef2);
        }
        objRef2.setTargetId(policy.getId());
        GUID owner = PolicyHandler.getOwnerOfObject((ConfigObject)this.policyArray);
        policy.setOwnerId(owner.toString());
        PolicyHandler.dumpObjects(policy.getNewObjSet(), this.newObjSet);
        PolicyHandler.dumpObjects(policy.getChangedObjSet(), this.changedObjSet);
        PolicyHandler.dumpObjects(policy.getDeletedObjSet(), this.deletedObjSet);
        policy.clearAllObjSets();
        String pattern = this.res.getString("AppliedPolicyObject.addNonSharePolicy");
        Object[] params = new Object[]{policy.getTypeDesc(), policy.getName(), this.locName};
        this.addLog(0, MessageFormat.format(pattern, params));
        this.setPolicy(policy, false);
    }

    public AppliedPolicyArray getPolicyArray() {
        if (this.policyArray == null) {
            this.policyArray = new AppliedPolicyArray();
        }
        return this.policyArray;
    }

    public AppliedPolicyArray getAppliedPolicyArray() {
        return this.policyArray;
    }

    public Map<String, TopLevelObject> getNewObjSet() {
        return this.newObjSet;
    }

    public Map<String, TopLevelObject> getChangedObjSet() {
        return this.changedObjSet;
    }

    public Map<String, TopLevelObject> getDeletedObjSet() {
        return this.deletedObjSet;
    }

    public void clearAllObjSets() {
        this.newObjSet.clear();
        this.changedObjSet.clear();
        this.deletedObjSet.clear();
        this.logList.clear();
    }

    public TopLevelObject getLocalSchemaOfPolicy(PolicyInt policyObj) throws ConsoleException {
        if (this.policyArray != null) {
            for (ObjReference objRef : this.policyArray.getObjReference()) {
                if (!objRef.getTargetType().equals(policyObj.getTargetType()) || !objRef.getName().equals(policyObj.getLocalReferenceName())) continue;
                return PolicyHandler.getObject(objRef.getTargetType(), objRef.getTargetId());
            }
        }
        return null;
    }

    public TopLevelObject getLocalSchemaOfPolicyFromDB(PolicyInt policyObj) throws ConsoleException {
        if (this.policyArray != null) {
            for (ObjReference objRef : this.policyArray.getObjReference()) {
                if (!objRef.getTargetType().equals(policyObj.getTargetType()) || !objRef.getName().equals(policyObj.getLocalReferenceName())) continue;
                return PolicyHandler.getObjectFromDB(objRef.getTargetType(), objRef.getTargetId());
            }
        }
        return null;
    }

    public List<ObjReference> getAppliedReferenceList(PolicyInt policyObj) {
        ArrayList<ObjReference> result = new ArrayList<ObjReference>();
        if (this.policyArray != null) {
            for (ObjReference objRef : this.policyArray.getObjReference()) {
                if (!objRef.getTargetType().equals(policyObj.getTargetType()) || !objRef.getName().equals(policyObj.getTargetName())) continue;
                result.add(objRef);
            }
        }
        return result;
    }

    public ObjReference getAppliedReferenceOfPolicy(PolicyInt policyObj) {
        return this.getReferenceOfPolicy(policyObj.getTargetType(), policyObj.getTargetName());
    }

    private ObjReference getReferenceOfPolicy(String targetType, String targetName) {
        if (this.policyArray != null) {
            for (ObjReference objRef : this.policyArray.getObjReference()) {
                if (!objRef.getTargetType().equals(targetType) || !objRef.getName().equals(targetName)) continue;
                return objRef;
            }
        }
        return null;
    }

    public ObjReference getAppliedLocalReferenceOfPolicy(PolicyInt policyObj) {
        return this.getReferenceOfPolicy(policyObj.getTargetType(), policyObj.getLocalReferenceName());
    }

    public boolean switchToLocalPolicy(PolicyInt policyObj, TopLevelObject locPolicyObj) throws ConsoleException {
        ObjReference appliedObj = this.getAppliedReferenceOfPolicy(policyObj);
        String pattern = this.res.getString("AppliedPolicyObject.switchToLocal");
        Object[] params = new Object[]{policyObj.getTypeDesc()};
        if (appliedObj == null) {
            ObjReference newObj = new ObjReference();
            newObj.setName(policyObj.getTargetName());
            newObj.setTargetId(locPolicyObj.getId());
            newObj.setTargetType(policyObj.getTargetType());
            AppliedPolicyArray array = this.getPolicyArray();
            array.addObjReference(newObj);
            this.addLog(0, MessageFormat.format(pattern, params));
            return true;
        }
        if (appliedObj.getTargetId().equals(locPolicyObj.getId())) {
            return false;
        }
        appliedObj.setTargetId(locPolicyObj.getId());
        this.addLog(0, MessageFormat.format(pattern, params));
        return true;
    }

    public void setPolicy(PolicyInt newPolicy, boolean needLog) {
        List<ObjReference> list = this.getAppliedReferenceList(newPolicy);
        String pattern = "";
        ObjReference objRef = null;
        AppliedPolicyArray array = this.getPolicyArray();
        if (list.size() > 0) {
            int size = list.size();
            for (int i = size - 1; i >= 0; --i) {
                array.removeObjReference(list.get(i));
            }
            list.clear();
        }
        objRef = new ObjReference();
        objRef.setName(newPolicy.getTargetName());
        objRef.setTargetType(newPolicy.getTargetType());
        objRef.setTargetId(newPolicy.getId());
        array.addObjReference(objRef);
        pattern = LicenseObject.getInstance().isSBProduct() ? this.res.getString("AppliedPolicyObject.changeToPolicySB") : this.res.getString("AppliedPolicyObject.changeToPolicy");
        Object[] params = new Object[]{newPolicy.getTypeDesc(), newPolicy.getName(), this.locName};
        if (needLog) {
            this.addLog(0, MessageFormat.format(pattern, params));
        }
    }

    public void addDefaultQuarantinePolicies(PolicyInt newPolicy) {
        List<PolicyInt> defaultQPolicies = newPolicy.getDefaultQuarantinePolicies();
        if (defaultQPolicies != null) {
            for (PolicyInt policy : defaultQPolicies) {
                this.addNewLocalPolicy(policy);
            }
        }
    }

    public void removePolicy(PolicyInt policyObj, boolean isRemoveQuarantinePolicies) {
        List<PolicyInt> connectedPolicies;
        ObjReference locObjRef;
        ObjReference objRef = this.getAppliedReferenceOfPolicy(policyObj);
        if (objRef != null) {
            objRef.getParent().removeChild((AbstractSchema)objRef);
            String pattern = this.res.getString("AppliedPolicyObject.removePolicy");
            Object[] params = new Object[]{policyObj.getTypeDesc(), this.locName};
            this.addLog(0, MessageFormat.format(pattern, params));
        }
        if ((locObjRef = this.getAppliedLocalReferenceOfPolicy(policyObj)) != null) {
            try {
                TopLevelObject localObj = PolicyHandler.getObject(locObjRef.getTargetType(), locObjRef.getTargetId());
                PolicyHandler.deleteObject(localObj, this.deletedObjSet, this.newObjSet, this.changedObjSet);
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            locObjRef.getParent().removeChild((AbstractSchema)locObjRef);
        }
        if (isRemoveQuarantinePolicies && (connectedPolicies = policyObj.getQuarantinePolicyObjList()) != null) {
            for (PolicyInt connectedPolicy : connectedPolicies) {
                this.removePolicy(connectedPolicy, true);
            }
        }
    }

    public void removeLocalPolicy(PolicyInt policyObj, boolean isRemoveQuarantinePolicies) {
        List<PolicyInt> connectedPolicies;
        ObjReference locObjRef = this.getAppliedLocalReferenceOfPolicy(policyObj);
        if (locObjRef != null) {
            try {
                TopLevelObject localObj = PolicyHandler.getObject(locObjRef.getTargetType(), locObjRef.getTargetId());
                PolicyHandler.deleteObject(localObj, this.deletedObjSet, this.newObjSet, this.changedObjSet);
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            locObjRef.getParent().removeChild((AbstractSchema)locObjRef);
        }
        if (isRemoveQuarantinePolicies && (connectedPolicies = policyObj.getQuarantinePolicyObjList()) != null) {
            for (PolicyInt connectedPolicy : connectedPolicies) {
                this.removePolicy(connectedPolicy, true);
            }
        }
    }

    public boolean pastePolicy(PolicyReferenceObject object, boolean isQuarantine) throws GUICheckException {
        String appliedName;
        ObjReference objRef = object.getAppliedPolicy();
        AppliedPolicyArray array = this.getPolicyArray();
        String objType = objRef.getTargetType();
        ObjReference oldObjRef = this.getReferenceOfPolicy(objType, appliedName = PolicyType.getPolicyTargetNameFromPolicyTargetType(objType, isQuarantine));
        if (oldObjRef != null && oldObjRef.getTargetId().equals(objRef.getTargetId())) {
            return false;
        }
        if (oldObjRef == null) {
            oldObjRef = new ObjReference();
            oldObjRef.setTargetType(objType);
            oldObjRef.setName(appliedName);
            array.addObjReference(oldObjRef);
        }
        oldObjRef.setTargetId(objRef.getTargetId());
        ObjReference locRef = object.getLocalPolicy();
        if (locRef != null && !LicenseObject.getInstance().isSBProduct() && locRef.getTargetId().equals(objRef.getTargetId())) {
            String localRefName = PolicyType.getLocalPolicyTargetNameFromPolicyTargetType(objType, isQuarantine);
            ObjReference oldLocalRef = this.getReferenceOfPolicy(objType, localRefName);
            if (oldLocalRef == null) {
                oldLocalRef = new ObjReference();
                oldLocalRef.setTargetType(objType);
                oldLocalRef.setName(localRefName);
                array.addObjReference(oldLocalRef);
            } else {
                try {
                    TopLevelObject oldLocalPolicyObj = PolicyHandler.getObject(objType, oldLocalRef.getTargetId());
                    PolicyHandler.deleteObject(oldLocalPolicyObj, this.deletedObjSet, this.newObjSet, this.changedObjSet);
                }
                catch (ConsoleException cex) {
                    LoggerUtilities.logException((Throwable)cex);
                }
            }
            try {
                TopLevelObject localPolicyObj = PolicyHandler.getObject(locRef.getTargetType(), locRef.getTargetId());
                WashIDHandler washer = new WashIDHandler();
                HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
                try {
                    TopLevelObject newLoc = (TopLevelObject)washer.duplicateObject((ConfigObject)localPolicyObj, createdObj);
                    MetadataAttributes metadata = newLoc.getMetadataAttributes();
                    if (metadata == null) {
                        metadata = new MetadataAttributes();
                        newLoc.setMetadataAttributes(metadata);
                    }
                    metadata.setOwner(new GUID(this.ownerId));
                    this.newObjSet.put(newLoc.getId(), newLoc);
                    PolicyHandler.dumpObjects(createdObj, this.newObjSet);
                    oldLocalRef.setTargetId(newLoc.getId());
                    oldObjRef.setTargetId(newLoc.getId());
                }
                catch (Exception e1) {
                    throw new GUICheckException(e1.getMessage(), null);
                }
            }
            catch (ConsoleException ex) {
                throw new GUICheckException("Cannot find source object", null);
            }
        }
        return true;
    }

    public boolean isAppliedLocalPolicy(PolicyInt policy) {
        ObjReference objRefApplied = this.getAppliedReferenceOfPolicy(policy);
        ObjReference objRefLocal = this.getAppliedLocalReferenceOfPolicy(policy);
        return objRefLocal != null && objRefApplied != null && objRefApplied.getTargetId().equals(objRefLocal.getTargetId());
    }

    public void addLog(int eventId, String desc) {
        GUID owner = PolicyHandler.getOwnerOfObject((ConfigObject)this.policyArray);
        this.logList.add(new PolicyLogEvent(eventId, owner.toString(), desc));
    }

    public List<PolicyLogEvent> getLogList() {
        return this.logList;
    }

    public void setPhysicalFileObject(PhysicalFileObject obj) {
        this.physicalFileObject = obj;
    }

    public PhysicalFileObject getPhysicalFileObject() {
        return this.physicalFileObject;
    }

    public boolean hasSameTypePolicy(PolicyReferenceObject copiedPolicy, boolean isQuaratine) {
        String objName;
        ObjReference objRef = copiedPolicy.getAppliedPolicy();
        String objType = objRef.getTargetType();
        ObjReference oldObjRef = this.getReferenceOfPolicy(objType, objName = PolicyType.getPolicyTargetNameFromPolicyTargetType(objType, isQuaratine));
        return oldObjRef != null;
    }

    private String getObjRefName(int applyType) {
        switch (applyType) {
            case 134: {
                return "AvPolicyApplied";
            }
            case 43: {
                return "FirewallPolicyApplied";
            }
            case 56: {
                return "HostIntegrityApplied";
            }
            case 63: {
                return "OpAppProtectionPolicyApplied";
            }
            case 128: {
                return "PolicyOverrideApplied";
            }
            case 144: {
                return "LuPolicyApplied";
            }
            case 148: {
                return "LuContentPolicyApplied";
            }
            case 60: {
                return "ServerListApplied";
            }
            case 143: {
                return "IdsPolicyApplied";
            }
            case 169: {
                return "MemPolicyApplied";
            }
            case 306: {
                return "HidPolicyApplied";
            }
            case 308: {
                return "TdadPolicyApplied";
            }
            case 171: {
                return "NtrPolicyApplied";
            }
            case 309: {
                return "UpgradePolicyApplied";
            }
            case 313: {
                return "AdaptivePolicyApplied";
            }
            case 153: {
                return "QuarantineAvPolicyApplied";
            }
            case 154: {
                return "LocalAvQuarantinePolicy";
            }
            case 121: {
                return "QuarantineFWPolicyApplied";
            }
            case 122: {
                return "LocalFWQuarantinePolicy";
            }
            case 123: {
                return "QuarantineOSPPolicyApplied";
            }
            case 124: {
                return "LocalOSPQuarantinePolicy";
            }
            case 155: {
                return "QuarantineLuPolicyApplied";
            }
            case 156: {
                return "LocalLuQuarantinePolicy";
            }
            case 157: {
                return "QuarantineCePolicyApplied";
            }
            case 158: {
                return "LocalCeQuarantinePolicy";
            }
            case 161: {
                return "QuarantineIdsPolicyApplied";
            }
            case 162: {
                return "LocalIdsQuarantinePolicy";
            }
            case 173: {
                return "QuarantineNtrPolicyApplied";
            }
            case 174: {
                return "LocalNtrQuarantinePolicy";
            }
            case 312: {
                return "LocalUpgradeQuarantinePolicy";
            }
            case 315: {
                return "QuarantineAdaptivePolicyApplied";
            }
            case 316: {
                return "LocalAdaptiveQuarantinePolicy";
            }
        }
        return "IdsLibraryApplied";
    }

    private List<String> getAllAppliedPolicyTargetNames() {
        ArrayList<String> set = new ArrayList<String>();
        set.add("AvPolicyApplied");
        set.add("FirewallPolicyApplied");
        set.add("HostIntegrityApplied");
        set.add("OpAppProtectionPolicyApplied");
        set.add("PolicyOverrideApplied");
        set.add("LuPolicyApplied");
        set.add("IdsPolicyApplied");
        set.add("HidPolicyApplied");
        set.add("TdadPolicyApplied");
        set.add("MemPolicyApplied");
        set.add("NtrPolicyApplied");
        set.add("UpgradePolicyApplied");
        set.add("AdaptivePolicyApplied");
        set.add("QuarantineAvPolicyApplied");
        set.add("QuarantineFWPolicyApplied");
        set.add("QuarantineOSPPolicyApplied");
        set.add("QuarantineCePolicyApplied");
        set.add("QuarantineLuPolicyApplied");
        set.add("QuarantineIdsPolicyApplied");
        set.add("QuarantineMemPolicyApplied");
        set.add("QuarantineNtrPolicyApplied");
        set.add("QuarantineUpgradePolicyApplied");
        set.add("QuarantineAdaptivePolicyApplied");
        return set;
    }

    private boolean isLocalAppliedPolicy(String id, String targetName) {
        if (this.policyArray != null) {
            String localTargetName = this.getAppliedPolicyLocalTargetName(targetName);
            for (ObjReference objRef : this.policyArray.getObjReference()) {
                if (!objRef.getName().equals(localTargetName) || !objRef.getTargetId().equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    private String getAppliedPolicyLocalTargetName(String targetName) {
        if (targetName.equals("AvPolicyApplied")) {
            return "LocalAvPolicy";
        }
        if (targetName.equals("FirewallPolicyApplied")) {
            return "LocalFirewallPolicy";
        }
        if (targetName.equals("HostIntegrityApplied")) {
            return "LocalHostIntegrityPolicy";
        }
        if (targetName.equals("OpAppProtectionPolicyApplied")) {
            return "LocalOpAppProtectionPolicy";
        }
        if (targetName.equals("PolicyOverrideApplied")) {
            return "LocalPolicyOverride";
        }
        if (targetName.equals("LuPolicyApplied")) {
            return "LocalLuPolicy";
        }
        if (targetName.equals("IdsPolicyApplied")) {
            return "LocalIdsPolicy";
        }
        if (targetName.equals("HidPolicyApplied")) {
            return "LocalHidPolicy";
        }
        if (targetName.equals("TdadPolicyApplied")) {
            return "LocalTdadPolicy";
        }
        if (targetName.equals("MemPolicyApplied")) {
            return "LocalMemPolicy";
        }
        if (targetName.equals("NtrPolicyApplied")) {
            return "LocalNtrPolicy";
        }
        if (targetName.equals("UpgradePolicyApplied")) {
            return "LocalUpgradePolicy";
        }
        if (targetName.equals("AdaptivePolicyApplied")) {
            return "LocalAdaptivePolicy";
        }
        if (targetName.equals("QuarantineAvPolicyApplied")) {
            return "LocalAvQuarantinePolicy";
        }
        if (targetName.equals("QuarantineFWPolicyApplied")) {
            return "LocalFWQuarantinePolicy";
        }
        if (targetName.equals("QuarantineOSPPolicyApplied")) {
            return "LocalOSPQuarantinePolicy";
        }
        if (targetName.equals("QuarantineCePolicyApplied")) {
            return "LocalCeQuarantinePolicy";
        }
        if (targetName.equals("QuarantineLuPolicyApplied")) {
            return "LocalLuQuarantinePolicy";
        }
        if (targetName.equals("QuarantineIdsPolicyApplied")) {
            return "LocalIdsQuarantinePolicy";
        }
        if (targetName.equals("QuarantineMemPolicyApplied")) {
            return "LocalMemQuarantinePolicy";
        }
        if (targetName.equals("QuarantineNtrPolicyApplied")) {
            return "LocalNtrQuarantinePolicy";
        }
        if (targetName.equals("QuarantineUpgradePolicyApplied")) {
            return "LocalUpgradeQuarantinePolicy";
        }
        if (targetName.equals("QuarantineAdaptivePolicyApplied")) {
            return "LocalAdaptiveQuarantinePolicy";
        }
        return "";
    }

    private List<PolicyIntObjectBase> getAllAppliedPolicyObjectList() {
        ArrayList<PolicyIntObjectBase> set = new ArrayList<PolicyIntObjectBase>();
        set.add(new AvPolicyObject());
        set.add(new FirewallPolicyObject());
        set.add(new HostIntegrityObject());
        set.add(new AppProtectionPolicyObject());
        set.add(new OverridePolicyObject());
        set.add(new LiveUpdateObject());
        set.add(new IdsPolicyObject());
        set.add(new HidPolicyObject());
        set.add(new TdadPolicyObject());
        set.add(new MemPolicyObject());
        set.add(new NtrPolicyObject());
        set.add(new UpgradePolicyObject());
        set.add(new AdaptivePolicyObject());
        set.add(new QuarantineAvPolicyObject());
        set.add(new QuarantineFirewallObject());
        set.add(new QuarantineOSPObject());
        set.add(new QuarantineOverridePolicyObject());
        set.add(new QuarantineLuPolicyObject());
        set.add(new QuarantineIdsPolicyObject());
        set.add(new QuarantineMemPolicyObject());
        set.add(new QuarantineNtrPolicyObject());
        set.add(new QuarantineUpgradePolicyObject());
        set.add(new QuarantineAdaptivePolicyObject());
        return set;
    }
}

