/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.Executable;
import com.sygate.scm.common.configobject.table.SemApplication;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.LearnedApplicationObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import java.io.File;
import java.text.Format;
import java.text.SimpleDateFormat;

public class ApplicationObject
extends AbstractUIObject
implements TableRow {
    Executable _executable;

    public ApplicationObject(Executable exe) {
        this._executable = exe;
    }

    public ApplicationObject() {
        this._executable = new Executable();
    }

    public ApplicationObject(LearnedApplicationObject laObj) {
        SemApplication semApp = laObj.getSemApplication();
        this._executable = new Executable();
        String name = semApp.getApplicationName();
        String path = semApp.getOptApplicationPath();
        if (path != null && path.length() > 0) {
            this._executable.setOptFileName(path + name);
        } else {
            this._executable.setOptFileName(name);
        }
        String checksum = semApp.getChecksum();
        this._executable.setOptFileMd5Checksum(checksum);
        String checksumSHA2 = semApp.getOptSHA2();
        if (checksumSHA2 != null) {
            this._executable.setOptFileSHA256Checksum(checksumSHA2);
        }
        String desc = semApp.getOptAppDescription();
        this._executable.setOptFileDescription(desc);
        this._executable.setOptFileSize(semApp.getOptFileSize());
        this._executable.setOptVersion(semApp.getOptVersion());
        if (semApp.getOptLastModifyTime() != null) {
            this._executable.setOptFileLastModifiedDate(UIUtilities.formatDate(semApp.getOptLastModifyTime(), (Format)new SimpleDateFormat("MM/dd/yyyy")));
        }
    }

    public void delete() {
        this._executable.getParent().removeChild((AbstractSchema)this._executable);
    }

    public boolean getEnabled() {
        Boolean enable = this._executable.getOptEnable();
        if (enable != null) {
            return enable;
        }
        return true;
    }

    public boolean setEnabled(boolean newValue) {
        boolean oldValue = this.getEnabled();
        if (oldValue != newValue) {
            this._executable.setOptEnable(Boolean.valueOf(newValue));
            return true;
        }
        return false;
    }

    public String getFileName() {
        String str = this._executable.getOptFileName();
        if (str == null) {
            return "";
        }
        return str.replace('/', File.separatorChar);
    }

    public boolean setFileName(String newValue) {
        String oldValue = this.getFileName();
        if (PolicyHandler.compareTwoObject(oldValue, newValue) != 0) {
            if (newValue == null || newValue.trim().length() == 0) {
                this._executable.setOptFileName(null);
                return true;
            }
            this._executable.setOptFileName(newValue);
            return true;
        }
        return false;
    }

    public String getFileDescription() {
        String str = this._executable.getOptFileDescription();
        return str;
    }

    public boolean setFileDescription(String newValue) {
        String oldValue = this.getFileDescription();
        if (PolicyHandler.compareTwoObject(oldValue, newValue) != 0) {
            if (newValue == null || newValue.trim().length() == 0) {
                this._executable.setOptFileDescription(null);
                return true;
            }
            this._executable.setOptFileDescription(newValue);
            return true;
        }
        return false;
    }

    public String getVersion() {
        String str = this._executable.getOptVersion();
        return str;
    }

    public boolean setVersion(String newValue) {
        String oldValue = this.getVersion();
        if (PolicyHandler.compareTwoObject(oldValue, newValue) != 0) {
            if (newValue == null || newValue.trim().length() == 0) {
                this._executable.setOptVersion(null);
                return true;
            }
            this._executable.setOptVersion(newValue);
            return true;
        }
        return false;
    }

    public String getModifyDate() {
        String str = this._executable.getOptFileLastModifiedDate();
        return str;
    }

    public String getModifyDateDisplayString() {
        String old = this.getModifyDate();
        if (old == null || old.equals("")) {
            return old;
        }
        int index = old.lastIndexOf(47);
        String year = old.substring(index + 1);
        return index == -1 ? old : year + "/" + old.substring(0, index);
    }

    public boolean setModifyDate(String newValue) {
        String oldValue = this.getModifyDate();
        if (PolicyHandler.compareTwoObject(oldValue, newValue) != 0) {
            if (newValue == null || newValue.trim().length() == 0) {
                this._executable.setOptFileLastModifiedDate(null);
                return true;
            }
            this._executable.setOptFileLastModifiedDate(newValue);
            return true;
        }
        return false;
    }

    public String getMd5Checksum() {
        String str = this._executable.getOptFileMd5Checksum();
        return str;
    }

    public boolean setMd5Checksum(String newValue) {
        String oldValue = this.getMd5Checksum();
        if (PolicyHandler.compareTwoObject(oldValue, newValue) != 0) {
            if (newValue == null || newValue.trim().length() == 0) {
                this._executable.setOptFileMd5Checksum(null);
                return true;
            }
            this._executable.setOptFileMd5Checksum(newValue);
            return true;
        }
        return false;
    }

    public String getSHA2Checksum() {
        String str = this._executable.getOptFileSHA256Checksum();
        return str;
    }

    public boolean setSHA2Checksum(String newValue) {
        String oldValue = this.getSHA2Checksum();
        if (PolicyHandler.compareTwoObject(oldValue, newValue) != 0) {
            if (newValue == null || newValue.trim().length() == 0) {
                this._executable.setOptFileSHA256Checksum(null);
                return true;
            }
            this._executable.setOptFileSHA256Checksum(newValue);
            return true;
        }
        return false;
    }

    public long getSize() {
        if (this._executable.getOptFileSize() != null) {
            return this._executable.getOptFileSize();
        }
        return -1L;
    }

    public boolean setSize(long newValue) {
        long oldValue = this.getSize();
        if (oldValue != newValue) {
            Long value = null;
            if (newValue != -1L) {
                value = newValue;
            }
            this._executable.setOptFileSize(value);
            return true;
        }
        return false;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getEnabled();
            }
            case 1: {
                return this.getFileName();
            }
            case 2: {
                return this.getFileDescription();
            }
            case 3: {
                long size = this.getSize();
                size = size >= 0L ? size : 0L;
                return size;
            }
            case 4: {
                return this.getModifyDateDisplayString();
            }
            case 5: {
                return this.getMd5Checksum();
            }
        }
        return "";
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Long.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object value, int index) {
        switch (index) {
            case 0: {
                Boolean b = (Boolean)value;
                this.setEnabled(b);
                break;
            }
        }
    }

    public Executable getExecutable() {
        return this._executable;
    }

    public ApplicationObject getClone() throws ConsoleException {
        Executable newExe = (Executable)PolicyHandler.getCopyOfObj((ConfigObject)this._executable);
        return new ApplicationObject(newExe);
    }

    public void setApplication(ApplicationObject newObj) {
        this._executable = newObj.getExecutable();
    }
}

