/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.ObjInfo;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.RecycleBin;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SuspendedItem;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AppProtectionPolicyPool;
import com.sygate.scm.console.logicobject.FirewallPolicyPool;
import com.sygate.scm.console.logicobject.HostIntegrityPolicyPool;
import com.sygate.scm.console.logicobject.LiveUpdatePolicyPool;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyLogEvent;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.ServerListPool;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.ui.policy.adaptive.logicobject.AdaptivePolicyPoolObject;
import com.sygate.scm.console.ui.policy.av.logicobject.AdminDefinedScanPoolObject;
import com.sygate.scm.console.ui.policy.av.logicobject.AvPolicyPoolObject;
import com.sygate.scm.console.ui.policy.av.logicobject.LinuxAdminDefinedScanPoolObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MacAdminDefinedScanPoolObject;
import com.sygate.scm.console.ui.policy.av.logicobject.ScheduleScanPoolObject;
import com.sygate.scm.console.ui.policy.common.AppliablePolicy;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryPoolObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyPoolObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateContentPolicyPool;
import com.sygate.scm.console.ui.policy.mem.logicobject.MemPolicyPoolObject;
import com.sygate.scm.console.ui.policy.ntr.logicobject.NtrPolicyPoolObject;
import com.sygate.scm.console.ui.policy.override.logicobject.OverridePolicyPoolObject;
import com.sygate.scm.console.ui.policy.up.logicobject.UpgradePolicyPoolObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class AppliablePolicyPool
extends AbstractUIObject {
    protected SemDomain domain;
    protected List<PolicyLogEvent> logList = new Vector<PolicyLogEvent>();
    protected List<ObjInfoObject> objInfoList = new ArrayList<ObjInfoObject>();
    protected Map<String, TopLevelObject> newObjSet = new HashMap<String, TopLevelObject>();
    protected Map<String, TopLevelObject> updateObjSet = new HashMap<String, TopLevelObject>();
    protected Map<String, TopLevelObject> deletedObjSet = new HashMap<String, TopLevelObject>();
    protected ObjectPool domainObjPool;
    protected ConfigObject policyPool;
    protected int poolType;
    protected String policyStr;

    protected AppliablePolicyPool(SemDomain domain) {
        this.domain = domain;
    }

    protected AppliablePolicyPool(SemDomain domain, int poolType) {
        this.domain = domain;
        this.poolType = poolType;
        try {
            this.initialize();
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    protected String getPolicyStr(PolicyObjectBase policyObj) {
        return this.policyStr;
    }

    public void addPolicyObject(PolicyObjectBase policyObj) throws ConsoleException {
        this.addPolicyObject(policyObj, false);
    }

    public boolean submitActionsToPolicyLogs(PolicyObjectBase policyObj, String eventType) throws ConsoleException {
        Object[] args = new Object[]{this.getPolicyStr(policyObj), policyObj.getName()};
        if ("exported".equals(eventType)) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.exportPolicy");
            this.addLog(6, policyObj.getId(), MessageFormat.format(msg, args));
            PolicyHandler.updateLog(this.logList);
            return true;
        }
        if ("applied".equals(eventType)) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.assignPolicy");
            this.addLog(2, policyObj.getId(), MessageFormat.format(msg, args));
            PolicyHandler.updateLog(this.logList);
            return true;
        }
        if ("replaced".equals(eventType)) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.replacePolicy");
            this.addLog(2, policyObj.getId(), MessageFormat.format(msg, args));
            PolicyHandler.updateLog(this.logList);
            return true;
        }
        return false;
    }

    public void addPolicyObject(PolicyObjectBase policyObj, boolean isPasted) throws ConsoleException {
        this.addPolicyObject(policyObj, policyObj.getName());
        String msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.addPolicy");
        if (isPasted) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.pastePolicy");
        }
        Object[] args = new Object[]{this.getPolicyStr(policyObj), policyObj.getName()};
        this.addLog(0, policyObj.getId(), MessageFormat.format(msg, args));
        this.updatePolicyAndPhysicalFileAndLog(policyObj);
    }

    public boolean checkNewName(PolicyObjectBase policy, String name) {
        return this.checkNewName(policy.getId(), name);
    }

    public boolean checkNewName(TopLevelObject policy, String name) {
        return this.checkNewName(policy.getId(), name);
    }

    public boolean updatePolicyObject(PolicyObjectBase policyObj) throws ConsoleException {
        this.updateObjInfoList(policyObj);
        PolicyHandler.dumpObjects(policyObj.getChangedObjSet(), this.updateObjSet);
        PolicyHandler.dumpObjects(policyObj.getDeletedObjSet(), this.deletedObjSet);
        PolicyHandler.dumpObjects(policyObj.getNewObjSet(), this.newObjSet);
        policyObj.clearAllObjSets();
        if (policyObj.getSchemaObj().isDirty()) {
            this.updateObjSet.put(policyObj.getId(), policyObj.getSchemaObj());
        } else {
            this.updateObjSet.remove(policyObj.getId());
        }
        String msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.updatePolicy");
        Object[] args = new Object[]{this.getPolicyStr(policyObj), policyObj.getName()};
        this.addLog(2, policyObj.getId(), MessageFormat.format(msg, args));
        return this.updatePolicyAndPhysicalFileAndLog(policyObj);
    }

    public void deletePolicyObject(PolicyObjectBase policyObj) throws ConsoleException {
        if (this.isPolicyPoolNull()) {
            return;
        }
        this.deletePolicyObject(policyObj, policyObj.getRefTargetName());
        List<TopLevelObject> privateObjList = policyObj.getPrivateObjectList();
        if (privateObjList != null) {
            for (int i = 0; i < privateObjList.size(); ++i) {
                TopLevelObject obj = privateObjList.get(i);
                this.deletedObjSet.put(obj.getId(), obj);
            }
        }
        this.updateObjSet.put(this.domain.getId(), (TopLevelObject)this.domain);
        String msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.removePolicy");
        Object[] args = new Object[]{this.getPolicyStr(policyObj), policyObj.getName()};
        this.addLog(1, policyObj.getId(), MessageFormat.format(msg, args));
        this.updatePolicyAndLog();
    }

    protected boolean updatePolicy() throws ConsoleException {
        ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        PolicyHandler.addNewObject(this.newObjSet.values(), this.deletedObjSet, updateList);
        PolicyHandler.updateChangedObject(this.updateObjSet.values(), this.deletedObjSet, updateList);
        PolicyHandler.deleteDeletedObject(this.deletedObjSet.values(), updateList);
        if (updateList.size() > 0) {
            return this.updateChangedObject(updateList);
        }
        return false;
    }

    protected void updatePolicyAndLog() throws ConsoleException {
        if (this.updatePolicy()) {
            PolicyHandler.updateLog(this.logList);
        }
        this.clearAllObjectSets();
    }

    protected boolean updatePolicyAndPhysicalFileAndLog(PolicyObjectBase policyObj) throws ConsoleException {
        boolean updated = false;
        boolean policyUpdated = this.updatePolicy();
        boolean physicalFileUpdated = false;
        if (policyObj instanceof PolicyIntObjectBase) {
            physicalFileUpdated = PolicyHandler.updatePhysicalFiles(((PolicyIntObjectBase)policyObj).getPhysicalFileObject());
        }
        if (policyUpdated || physicalFileUpdated) {
            PolicyHandler.updateLog(this.logList);
            updated = true;
        }
        this.clearAllObjectSets();
        return updated;
    }

    protected abstract void addPolicyPoolReference(ConfigObject var1, ObjReference var2) throws ConsoleException;

    protected abstract Vector<ObjReference> getPolicyPoolReferences();

    protected abstract void createSemPolicyPool();

    protected void initialize() throws ConsoleException {
        this.initialize(this.poolType);
        this.clearObjectList();
        if (this.policyPool != null) {
            this.initObjInfo(this.poolType);
        }
    }

    protected ConfigObject initialize(int poolType) throws ConsoleException {
        this.domainObjPool = this.domain.getObjectPool();
        switch (poolType) {
            case 129: {
                this.policyPool = this.domainObjPool.getOptAdminDefinedScanPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.adminDefinedScan");
                break;
            }
            case 134: {
                this.policyPool = this.domainObjPool.getOptAvPolicyPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.avPolicy");
                break;
            }
            case 128: {
                this.policyPool = this.domainObjPool.getOptPolicyOverridePool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.overridePolicy");
                break;
            }
            case 309: {
                this.policyPool = this.domainObjPool.getOptUpgradePolicyPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.upgradePolicy");
                break;
            }
            case 135: {
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.gePolicy");
                break;
            }
            case 43: {
                this.policyPool = this.domainObjPool.getOptFwFirewallPolicyPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.fwPolicy");
                break;
            }
            case 56: {
                this.policyPool = this.domainObjPool.getOptHiHostIntegrityPolicyPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.hiPolicy");
                break;
            }
            case 63: {
                this.policyPool = this.domainObjPool.getOptOpAppProtectionPolicyPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.ospPolicy");
                break;
            }
            case 60: {
                this.policyPool = this.domainObjPool.getOptSemServerListPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.pmPolicy");
                break;
            }
            case 65: 
            case 143: {
                this.policyPool = this.domainObjPool.getOptFwIdsLibraryPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.idsPolicy");
                break;
            }
            case 144: {
                this.policyPool = this.domainObjPool.getOptLuPolicyPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.luPolicy");
                break;
            }
            case 148: {
                this.policyPool = this.domainObjPool.getOptLuContentPolicyPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.luContentPolicy");
                break;
            }
            case 400: {
                this.policyPool = this.domainObjPool.getOptMacAdminDefinedScanPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.macAdminDefinedScan");
                break;
            }
            case 406: {
                this.policyPool = this.domainObjPool.getOptLinuxAdminDefinedScanPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.linuxAdminDefinedScan");
                break;
            }
            case 169: {
                this.policyPool = this.domainObjPool.getOptMemPolicyPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.memPolicy");
                break;
            }
            case 171: {
                this.policyPool = this.domainObjPool.getOptNtrPolicyPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.ntrPolicy");
                break;
            }
            case 313: {
                this.policyPool = this.domainObjPool.getOptAdaptivePolicyPool();
                this.policyStr = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppliablePolicyPool.adaptivePolicy");
                break;
            }
        }
        return this.policyPool;
    }

    protected ObjInfoObject createInfoObject(int itemType, ObjInfo info, String id) {
        return new ObjInfoObject(itemType, info);
    }

    protected void addLog(int eventId, String ownerId, String desc) {
        this.logList.add(new PolicyLogEvent(eventId, ownerId, desc));
    }

    protected void updateObjInfoList(AppliablePolicy fwObj) {
        for (int i = 0; i < this.objInfoList.size(); ++i) {
            ObjInfoObject infoObj = this.objInfoList.get(i);
            if (!infoObj.getId().equals(fwObj.getId())) continue;
            infoObj.setName(fwObj.getName());
            infoObj.setDescription(fwObj.getDescription());
            break;
        }
    }

    protected void initObjInfo(int itemType) throws ConsoleException {
        ArrayList<String> ids = this.getObjReferenceIdArray(itemType);
        HashMap<String, ObjInfo> objInfos = DataobjectManager.getInstance().getMutipleObjectInfo(ids);
        for (int i = 0; i < ids.size(); ++i) {
            String id = ids.get(i);
            ObjInfo info = objInfos.get(id);
            if (info == null) continue;
            this.objInfoList.add(this.createInfoObject(itemType, info, id));
        }
    }

    protected void clearObjectList() {
        this.objInfoList.clear();
    }

    protected void addPolicyObject(PolicyObjectBase policyObj, String refName) throws ConsoleException {
        if (this.isPolicyPoolNull()) {
            this.createSemPolicyPool();
        }
        this.objInfoList.add(PolicyHelper.createObjInfoObject(policyObj));
        this.newObjSet.put(policyObj.getId(), policyObj.getSchemaObj());
        PolicyHandler.dumpObjects(policyObj.getNewObjSet(), this.newObjSet);
        PolicyHandler.dumpObjects(policyObj.getChangedObjSet(), this.updateObjSet);
        PolicyHandler.dumpObjects(policyObj.getDeletedObjSet(), this.deletedObjSet);
        policyObj.clearAllObjSets();
        ObjReference objRef = new ObjReference();
        objRef.setName(refName);
        objRef.setTargetType(policyObj.getTargetType());
        objRef.setTargetId(policyObj.getId());
        this.addPolicyPoolReference(this.policyPool, objRef);
        this.updateObjSet.put(this.domain.getId(), (TopLevelObject)this.domain);
    }

    protected void deletePolicyObject(PolicyObjectBase policyObj, String refName) {
        this.deletedObjSet.put(policyObj.getId(), policyObj.getSchemaObj());
        this.removeFromObjInfoList(policyObj);
        Vector<ObjReference> allRef = this.getPolicyPoolReferences(policyObj.getItemType());
        for (int i = 0; i < allRef.size(); ++i) {
            ObjReference ref = allRef.get(i);
            if (!ref.getTargetId().equals(policyObj.getId())) continue;
            ref.getParent().removeChild((AbstractSchema)ref);
            ObjReference objRef = new ObjReference();
            objRef.setTargetId(policyObj.getId());
            objRef.setTargetType(policyObj.getTargetType());
            objRef.setName(refName);
            RecycleBin bin = this.domainObjPool.getRecycleBin();
            SuspendedItem suspended = new SuspendedItem();
            suspended.setDeletedTime(Long.valueOf(new Date().getTime()));
            suspended.setOptWhoDeletedIt(DataobjectManager.getInstance().getCurrentAdministrator().getId());
            suspended.setObjReference(objRef);
            bin.addSuspendedItem(suspended);
        }
    }

    private void clearAllObjectSets() {
        this.newObjSet.clear();
        this.updateObjSet.clear();
        this.deletedObjSet.clear();
        this.logList.clear();
    }

    private boolean checkNewName(String id, String name) {
        for (int i = 0; i < this.objInfoList.size(); ++i) {
            ObjInfoObject objInfo = this.objInfoList.get(i);
            if (objInfo.getId().equals(id) || !objInfo.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    private boolean updateChangedObject(List<DataobjectManager.UpdateObjectEntry> updateList) throws ConsoleException {
        Map<String, Object> resultMap = DataobjectManager.getInstance().updateObject("Merge", updateList);
        SemDomain newDomain = (SemDomain)resultMap.get(this.domain.getId());
        if (newDomain != null) {
            this.domain = newDomain;
            this.initialize();
        } else {
            for (ObjInfoObject infoObj : this.objInfoList) {
                NamedObject schemaObj = (NamedObject)resultMap.get(infoObj.getId());
                if (schemaObj == null) continue;
                infoObj.setName(schemaObj.getName());
                infoObj.setDescription(schemaObj.getOptDescription());
            }
        }
        boolean policyUpdated = false;
        List changedIdList = (List)resultMap.get("KEY_CHANGED_IDSET");
        if (changedIdList != null && changedIdList.size() > 0) {
            policyUpdated = true;
        }
        return policyUpdated;
    }

    private void removeFromObjInfoList(AppliablePolicy fwObj) {
        for (int i = 0; i < this.objInfoList.size(); ++i) {
            if (!this.objInfoList.get(i).getId().equals(fwObj.getId())) continue;
            this.objInfoList.remove(i);
            break;
        }
    }

    public static AppliablePolicyPool getPolicyPoolObject(int type) throws ConsoleException {
        switch (type) {
            case 129: {
                return AdminDefinedScanPoolObject.getPolicyPool();
            }
            case 400: {
                return MacAdminDefinedScanPoolObject.getPolicyPool();
            }
            case 406: {
                return LinuxAdminDefinedScanPoolObject.getPolicyPool();
            }
            case 134: {
                return AvPolicyPoolObject.getPolicyPool();
            }
            case 128: {
                return OverridePolicyPoolObject.getPolicyPool();
            }
            case 309: {
                return UpgradePolicyPoolObject.getPolicyPool();
            }
            case 43: {
                return FirewallPolicyPool.getFirewallPolicyPool();
            }
            case 56: {
                return HostIntegrityPolicyPool.getHostIntegrityPolicyPool();
            }
            case 63: {
                return AppProtectionPolicyPool.getOpAppProtectionPolicyPool();
            }
            case 60: {
                return ServerListPool.getServerListPool();
            }
            case 144: {
                return LiveUpdatePolicyPool.getLiveUpatePolicyPool();
            }
            case 148: {
                return LiveUpdateContentPolicyPool.getPolicyPool();
            }
            case 401: {
                return ScheduleScanPoolObject.getPolicyPool();
            }
            case 65: {
                return IdsLibraryPoolObject.getIdsLibraryPoolObject();
            }
            case 169: {
                return MemPolicyPoolObject.getPolicyPool();
            }
            case 171: {
                return NtrPolicyPoolObject.getPolicyPool();
            }
            case 313: {
                return AdaptivePolicyPoolObject.getPolicyPool();
            }
        }
        return IdsPolicyPoolObject.getIdsPolicyPool();
    }

    public static HashMap<String, String> getObjInfoHashMap(int type) throws ConsoleException {
        AppliablePolicyPool pool = AppliablePolicyPool.getPolicyPoolObject(type);
        ObjInfoObject[] infoObj = pool.getInfoObjectList();
        HashMap<String, String> map = new HashMap<String, String>();
        if (infoObj != null) {
            for (int i = 0; i < infoObj.length; ++i) {
                map.put(infoObj[i].getId(), infoObj[i].getName());
            }
        }
        return map;
    }

    public ObjInfoObject[] getInfoObjectList() {
        return this.objInfoList.toArray(new ObjInfoObject[0]);
    }

    public List<String> getAllName() {
        ArrayList<String> names = new ArrayList<String>();
        ObjInfoObject[] objInfo = this.getInfoObjectList();
        for (int i = 0; i < objInfo.length; ++i) {
            names.add(objInfo[i].getName());
        }
        return names;
    }

    public List<String> getAllName(PolicyObjectBase policy) {
        return this.getAllName();
    }

    public List<String> getAllId() {
        ArrayList<String> list = new ArrayList<String>();
        for (ObjInfoObject infoObj : this.objInfoList) {
            list.add(infoObj.getId());
        }
        return list;
    }

    protected boolean isPolicyPoolNull() {
        boolean result = false;
        if (this.policyPool == null) {
            result = true;
        }
        return result;
    }

    protected ArrayList<String> getObjReferenceIdArray(Integer itemType) {
        ArrayList<String> ids = new ArrayList<String>();
        Vector<ObjReference> allRef = this.getPolicyPoolReferences(itemType);
        for (int i = 0; i < allRef.size(); ++i) {
            ObjReference ref = allRef.get(i);
            ids.add(ref.getTargetId());
        }
        return ids;
    }

    protected Vector<ObjReference> getPolicyPoolReferences(Integer itemType) {
        return this.getPolicyPoolReferences();
    }

    public Integer getPlatFormConstant(PolicyObjectBase policy) {
        return 0;
    }
}

