/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AppProtectionRuleSystem;
import com.sygate.scm.common.configobject.schema.AppProtectionSetting;
import com.sygate.scm.common.configobject.schema.EnforcedAppProtectionBlockArray;
import com.sygate.scm.common.configobject.schema.MacAppProtectionSetting;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.OpAppProtBlockEntity;
import com.sygate.scm.common.configobject.schema.OpAppProtTemplate;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicy;
import com.sygate.scm.common.configobject.schema.OpDevice;
import com.sygate.scm.common.configobject.schema.OpDevicePool;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.osprotect.IOpAppProtTemplateRetriever;
import com.sygate.scm.common.osprotect.SEP12SupportForADCPolicy;
import com.sygate.scm.common.osprotect.SEPMigrationBlockDetector;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.UsbDeviceHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.DeviceObject;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.explorer.osp.ConsoleOpAppProtTemplateRetriever;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AppProtectionPolicyObject
extends PolicyIntObjectBase
implements TableRow {
    private AppProtectionRuleSystem ruleSystem;

    public AppProtectionPolicyObject() {
    }

    public AppProtectionPolicyObject(PolicyIntObjectBase policyObject) {
        super(policyObject);
    }

    public AppProtectionPolicyObject(TopLevelObject policy) {
        super(policy);
        this.ruleSystem = ((OpAppProtectionPolicy)policy).getOptAppProtectionRuleSystem();
    }

    @Override
    public boolean getEnabled() {
        return Utility.getBooleanValue((Boolean)((OpAppProtectionPolicy)this.policy).getOptEnable(), (Boolean)((OpAppProtectionPolicy)this.policy).getDefEnable());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        ((OpAppProtectionPolicy)this.policy).setOptEnable(Boolean.valueOf(isEnabled));
    }

    @Override
    public String getCreator() {
        return ((OpAppProtectionPolicy)this.policy).getOptCreator();
    }

    @Override
    public void setCreator(String creator) {
        ((OpAppProtectionPolicy)this.policy).setOptCreator(creator);
    }

    @Override
    public int getItemType() {
        return 63;
    }

    @Override
    public void setSchemaObj(TopLevelObject policy) {
        super.setSchemaObj(policy);
        if (policy != null) {
            this.ruleSystem = ((OpAppProtectionPolicy)policy).getOptAppProtectionRuleSystem();
        }
    }

    @Override
    public String getLocalReferenceName() {
        return "LocalOpAppProtectionPolicy";
    }

    @Override
    public String getTargetName() {
        return "OpAppProtectionPolicyApplied";
    }

    @Override
    public String getTargetType() {
        return "OpAppProtectionPolicy";
    }

    @Override
    public String getRefTargetName() {
        return "SuspendedOpAppProtectionPolicyLink";
    }

    @Override
    public String getTypeDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AppProtectionPolicyObject.ospPolicyDescription");
    }

    public AppProtectionRuleSystem getOptAppProtectionRuleSystem() {
        return ((OpAppProtectionPolicy)this.policy).getOptAppProtectionRuleSystem();
    }

    public AppProtectionSetting getOptAppProtectionSetting() {
        return ((OpAppProtectionPolicy)this.policy).getAppProtectionSetting();
    }

    public MacAppProtectionSetting getOptMacAppProtectionSetting() {
        return ((OpAppProtectionPolicy)this.policy).getOptMacAppProtectionSetting();
    }

    public void setOptDescription(String description) {
        ((OpAppProtectionPolicy)this.policy).setOptDescription(description);
    }

    public void setOptAppProtectionRuleSystem(AppProtectionRuleSystem ruleSystem) {
        ((OpAppProtectionPolicy)this.policy).setOptAppProtectionRuleSystem(ruleSystem);
    }

    public void setOptAppProtectionSetting(AppProtectionSetting appProtectionSetting) {
        ((OpAppProtectionPolicy)this.policy).setAppProtectionSetting(appProtectionSetting);
    }

    public void createNewAppProtectionPolicy() {
        this.policy = this.createAppProtectionPolicy();
        this.ruleSystem = ((OpAppProtectionPolicy)this.policy).getOptAppProtectionRuleSystem();
        this.addNewObj(this.policy);
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getDescription();
            }
            case 2: {
                return "";
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public static AppProtectionPolicyObject importFile(Object[] objList) throws ConsoleException {
        return AppProtectionPolicyObject.importFile(objList, false);
    }

    public static AppProtectionPolicyObject importFile(Object[] objList, boolean addSEPMigrationExclusions) throws ConsoleException {
        if (objList.length == 0) {
            return null;
        }
        OpAppProtectionPolicy appPolicy = (OpAppProtectionPolicy)objList[0];
        HashMap<String, TopLevelObject> objMap = new HashMap<String, TopLevelObject>();
        if (objList.length > 1) {
            for (int i = 1; i < objList.length; ++i) {
                TopLevelObject tObj = (TopLevelObject)objList[i];
                objMap.put(tObj.getId(), tObj);
            }
        }
        Map<String, TopLevelObject> deviceMap = AppProtectionPolicyObject.getDeviceMap();
        HashMap<String, TopLevelObject> allNewObj = new HashMap<String, TopLevelObject>();
        HashMap<String, TopLevelObject> allChangedObj = new HashMap<String, TopLevelObject>();
        AppProtectionPolicyObject.washIdList(appPolicy, objMap, deviceMap, allNewObj, allChangedObj);
        AppProtectionPolicyObject appObject = new AppProtectionPolicyObject((TopLevelObject)appPolicy);
        appObject.addNewObj((TopLevelObject)appPolicy);
        PolicyHandler.dumpObjects(allNewObj, appObject.getNewObjSet());
        PolicyHandler.dumpObjects(allChangedObj, appObject.getChangedObjSet());
        boolean sep12Support = SEP12SupportForADCPolicy.upgradeOpAppProtectionPolicies((OpAppProtectionPolicy)appPolicy);
        ConsoleLogger.log("Add SEP 12 style settings, the result is " + sep12Support);
        LinkedHashMap<String, TopLevelObject> objReferencePool = new LinkedHashMap<String, TopLevelObject>();
        objReferencePool.putAll(allNewObj);
        objReferencePool.putAll(allChangedObj);
        ConsoleOpAppProtTemplateRetriever templateRetriever = new ConsoleOpAppProtTemplateRetriever(objReferencePool);
        GUID domainGUID = new GUID(DataobjectManager.getInstance().getLoginInformation().getOptDomainGUID());
        SEPMigrationBlockDetector blockDetector = new SEPMigrationBlockDetector(appPolicy, (IOpAppProtTemplateRetriever)templateRetriever, domainGUID);
        if (addSEPMigrationExclusions) {
            ConsoleLogger.log("Start add SEP migration exclusions");
            if (blockDetector.needExclusions()) {
                boolean added = blockDetector.addExclusions();
                ConsoleLogger.log("Add SEP migration exclusion result: " + added);
            }
            ConsoleLogger.log("End add SEP migration exclusions");
        }
        ConsoleLogger.log("Start to migrate ADC policy for Allow Clien Process Rule...");
        List list = blockDetector.migrateAllowClientProcessRules();
        if (list.size() > 0) {
            ConsoleLogger.log("Successed to migrate AC rule");
        } else {
            ConsoleLogger.log("No AC rule need to be migrated.");
        }
        ConsoleLogger.log("End to migrate ADC policy for Allow Clien Process Rule...");
        return appObject;
    }

    @Override
    protected PolicyObjectBase createPolicyObject(TopLevelObject policyObj) throws ConsoleException {
        if (!(policyObj instanceof OpAppProtectionPolicy)) {
            throw new ConsoleException(302645248, 32);
        }
        return new AppProtectionPolicyObject(policyObj);
    }

    private OpAppProtectionPolicy createAppProtectionPolicy() {
        OpAppProtectionPolicy policy = null;
        try {
            policy = PolicyHandler.getDefaultOSProtectionPolicy(this.getNewObjSet());
        }
        catch (Exception e) {
            policy = new OpAppProtectionPolicy();
            String GUIDString = new GUIDGenerator().getGUIDString();
            policy.setId(GUIDString);
            policy.setName("");
            policy.setOptCreator(AdminObject.retrieveCurrentAdminObject().getName());
            AppProtectionRuleSystem ruleSystem = new AppProtectionRuleSystem();
            policy.setOptAppProtectionRuleSystem(ruleSystem);
            AppProtectionSetting setting = new AppProtectionSetting();
            policy.setAppProtectionSetting(setting);
            MacAppProtectionSetting macsetting = new MacAppProtectionSetting();
            policy.setOptMacAppProtectionSetting(macsetting);
        }
        MetadataAttributes mAttr = new MetadataAttributes();
        if (policy != null) {
            policy.setMetadataAttributes(mAttr);
        }
        return policy;
    }

    private static Map<String, TopLevelObject> getDeviceMap() throws ConsoleException {
        HashMap<String, TopLevelObject> deviceMap = new HashMap<String, TopLevelObject>();
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", data.getLoginInformation().getOptDomainGUID());
        ObjectPool pool = domain.getObjectPool();
        OpDevicePool devicePool = pool.getOptOpDevicePool();
        if (devicePool != null) {
            for (ObjReference ref : devicePool.getObjReference()) {
                OpDevice device = data.getOpDevice(ref.getTargetId());
                deviceMap.put(device.getName(), (TopLevelObject)device);
            }
        }
        return deviceMap;
    }

    private static void washIdList(OpAppProtectionPolicy appPolicy, Map<String, TopLevelObject> objMap, Map<String, TopLevelObject> deviceMap, Map<String, TopLevelObject> newObjSet, Map<String, TopLevelObject> changedObjSet) throws ConsoleException {
        HashMap<String, String> changedIdMap = new HashMap<String, String>();
        AppProtectionPolicyObject.washId((ConfigObject)appPolicy, objMap, deviceMap, newObjSet, changedObjSet, changedIdMap);
    }

    private static void washId(ConfigObject obj, Map<String, TopLevelObject> objMap, Map<String, TopLevelObject> deviceMap, Map<String, TopLevelObject> newObjSet, Map<String, TopLevelObject> changedObjSet, Map<String, String> changedIdMap) throws ConsoleException {
        obj.init();
        try {
            Method method = obj.getClass().getMethod("getId", new Class[0]);
            String oldID = (String)method.invoke((Object)obj, new Object[0]);
            String newID = changedIdMap.get(oldID);
            if (newID != null) {
                return;
            }
            method = obj.getClass().getMethod("setId", String.class);
            newID = new GUIDGenerator().getGUIDString();
            method.invoke((Object)obj, newID);
            changedIdMap.put(oldID, newID);
        }
        catch (NoSuchMethodException method) {
        }
        catch (IllegalArgumentException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        if (obj instanceof ObjReference) {
            String adjustId;
            ObjReference ref = (ObjReference)obj;
            if (ref.getTargetType().equals("OpDevice")) {
                adjustId = AppProtectionPolicyObject.adjustOpDeviceId(ref.getTargetId(), objMap, deviceMap, newObjSet, changedObjSet, changedIdMap);
                ref.setTargetId(adjustId);
            } else if (ref.getTargetType().equals("OpAppProtTemplate")) {
                adjustId = AppProtectionPolicyObject.adjustOpTemplate(ref.getTargetId(), objMap, deviceMap, newObjSet, changedObjSet, changedIdMap);
                ref.setTargetId(adjustId);
            }
        }
        for (ConfigObject child : obj.getChildren()) {
            AppProtectionPolicyObject.washId(child, objMap, deviceMap, newObjSet, changedObjSet, changedIdMap);
        }
    }

    private static String adjustOpTemplate(String templateId, Map<String, TopLevelObject> objMap, Map<String, TopLevelObject> deviceMap, Map<String, TopLevelObject> newObjSet, Map<String, TopLevelObject> changedObjSet, Map<String, String> changedIdMap) throws ConsoleException {
        String newId = changedIdMap.get(templateId);
        if (newId != null) {
            return newId;
        }
        OpAppProtTemplate template = (OpAppProtTemplate)objMap.get(templateId);
        if (template == null) {
            throw new ConsoleException(new Exception("Cannot find OpAppProtTemplate. Corruptted policy."));
        }
        String refId = template.getOptRefId();
        if (refId == null) {
            template.setOptRefId(template.getId());
            AppProtectionPolicyObject.washId((ConfigObject)template, objMap, deviceMap, newObjSet, changedObjSet, changedIdMap);
            newObjSet.put(template.getId(), (TopLevelObject)template);
            return template.getId();
        }
        TopLevelObject[] allPossibleObjs = GUIManager.getObjectListByRefId(refId);
        if (allPossibleObjs != null && allPossibleObjs.length > 0) {
            changedIdMap.put(templateId, allPossibleObjs[0].getId());
            return allPossibleObjs[0].getId();
        }
        AppProtectionPolicyObject.washId((ConfigObject)template, objMap, deviceMap, newObjSet, changedObjSet, changedIdMap);
        newObjSet.put(template.getId(), (TopLevelObject)template);
        return template.getId();
    }

    private static String adjustOpDeviceId(String deviceId, Map<String, TopLevelObject> objMap, Map<String, TopLevelObject> deviceMap, Map<String, TopLevelObject> newObjSet, Map<String, TopLevelObject> changedObjSet, Map<String, String> changedIdMap) throws ConsoleException {
        String newId = changedIdMap.get(deviceId);
        if (newId != null) {
            return newId;
        }
        OpDevice device = (OpDevice)objMap.get(deviceId);
        if (device == null) {
            throw new ConsoleException(new Exception("Cannot find OpDevice. Corruptted policy."));
        }
        String classId = device.getOptDeviceClassGuid();
        String instanceId = device.getOptDeviceInstanceId();
        OpDevice inSystemDevice = null;
        DeviceObject inSystemdeviceObject = null;
        try {
            inSystemdeviceObject = instanceId == null || "".equals(instanceId) ? UsbDeviceHandler.getDeviceByClassId(classId) : UsbDeviceHandler.getDeviceByInstanceId(instanceId);
        }
        catch (Exception e) {
            throw new ConsoleException(e);
        }
        if (inSystemdeviceObject != null) {
            inSystemDevice = inSystemdeviceObject.getDevice();
        }
        if (inSystemDevice != null) {
            return inSystemDevice.getId();
        }
        AppProtectionPolicyObject.washId((ConfigObject)device, objMap, deviceMap, newObjSet, changedObjSet, changedIdMap);
        newObjSet.put(device.getId(), (TopLevelObject)device);
        AppProtectionPolicyObject.addDevice(device, changedObjSet);
        return device.getId();
    }

    private static void addDevice(OpDevice device, Map<String, TopLevelObject> changedObjSet) throws ConsoleException {
        ObjectPool pool;
        OpDevicePool devicePool;
        DataobjectManager data = DataobjectManager.getInstance();
        String domainId = data.getLoginInformation().getOptDomainGUID();
        SemDomain domain = (SemDomain)changedObjSet.get(domainId);
        if (domain == null) {
            domain = (SemDomain)data.getObjectByGUID("SemDomain", domainId);
            domain = (SemDomain)PolicyHandler.getCopyOfObj((ConfigObject)domain);
            changedObjSet.put(domainId, (TopLevelObject)domain);
        }
        if ((devicePool = (pool = domain.getObjectPool()).getOptOpDevicePool()) == null) {
            devicePool = new OpDevicePool();
            pool.setOptOpDevicePool(devicePool);
        }
        ObjReference ref = new ObjReference();
        ref.setTargetId(device.getId());
        ref.setTargetType("OpDevice");
        ref.setName("OpDeviceLink");
        devicePool.addObjReference(ref);
    }

    public void addTemplate(String templateId, Integer mode) {
        EnforcedAppProtectionBlockArray enforcedBlockArray;
        OpAppProtBlockEntity ospBlockEntity = new OpAppProtBlockEntity();
        ospBlockEntity.setOptMode(mode);
        ObjReference objRef = new ObjReference();
        objRef.setName("AppProtTemplateLink");
        objRef.setTargetType("OpAppProtTemplate");
        objRef.setTargetId(templateId);
        ospBlockEntity.setOptObjReference(objRef);
        ospBlockEntity.setOptOpAppProtectionBlock(null);
        if (this.ruleSystem == null) {
            this.ruleSystem = new AppProtectionRuleSystem();
            ((OpAppProtectionPolicy)this.policy).setOptAppProtectionRuleSystem(this.ruleSystem);
        }
        if ((enforcedBlockArray = this.ruleSystem.getOptEnforcedAppProtectionBlockArray()) == null) {
            enforcedBlockArray = new EnforcedAppProtectionBlockArray();
            this.ruleSystem.setOptEnforcedAppProtectionBlockArray(enforcedBlockArray);
        }
        enforcedBlockArray.addOpAppProtBlockEntity(ospBlockEntity);
    }

    public AppProtectionPolicyObject getClone() {
        return new AppProtectionPolicyObject((TopLevelObject)this.policy.clone());
    }
}

