/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.AppAuthenticationProtection;
import com.sygate.scm.common.configobject.schema.ExcludedAppArray;
import com.sygate.scm.common.configobject.schema.Executable;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.ApplicationObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import java.util.ArrayList;
import java.util.Vector;

public class AppAuthenticationObject
extends AbstractUIObject {
    public static final int ASK = 0;
    public static final int ALLOW = 1;
    public static final int BLOCK = 2;
    public static final int UNKNOWN = 3;
    AppAuthenticationProtection _appAuthentication;

    public AppAuthenticationObject(AppAuthenticationProtection appAuthen) {
        this._appAuthentication = appAuthen;
    }

    public void clearAllApplications() {
        if (this._appAuthentication != null) {
            ExcludedAppArray array = this._appAuthentication.getExcludedAppArray();
            Vector allApp = array.getExecutable();
            for (int i = 0; i < allApp.size(); ++i) {
                Executable exe = (Executable)allApp.get(i);
                exe.getParent().removeChild((AbstractSchema)exe);
            }
        }
    }

    public void addApplication(ApplicationObject newApp) {
        if (this._appAuthentication == null) {
            this.createAppAuthentication();
        }
        ExcludedAppArray array = this._appAuthentication.getExcludedAppArray();
        array.addExecutable(newApp.getExecutable());
    }

    private void createAppAuthentication() {
        this._appAuthentication = new AppAuthenticationProtection();
        this._appAuthentication.setAction(AppAuthenticationProtection.ASK);
        ExcludedAppArray array = new ExcludedAppArray();
        this._appAuthentication.setExcludedAppArray(array);
    }

    private static Integer getActionString(int action) {
        switch (action) {
            case 0: {
                return AppAuthenticationProtection.ASK;
            }
            case 1: {
                return AppAuthenticationProtection.ALLOW;
            }
            case 2: {
                return AppAuthenticationProtection.DISALLOW;
            }
        }
        return AppAuthenticationProtection.ASK;
    }

    public boolean getEnabled() {
        if (this._appAuthentication != null) {
            Boolean enable = this._appAuthentication.getOptEnable();
            if (enable != null) {
                return this._appAuthentication.getOptEnable();
            }
            return this._appAuthentication.getDefEnable();
        }
        return false;
    }

    public boolean setEnable(boolean enabled) {
        boolean oldValue = this.getEnabled();
        if (oldValue != enabled) {
            if (this._appAuthentication == null) {
                this.createAppAuthentication();
            }
            this._appAuthentication.setOptEnable(Boolean.valueOf(enabled));
            return true;
        }
        return false;
    }

    public int getAction() {
        if (this._appAuthentication != null) {
            Integer action = this._appAuthentication.getAction();
            if (action.equals(AppAuthenticationProtection.ASK)) {
                return 0;
            }
            if (action.equals(AppAuthenticationProtection.ALLOW)) {
                return 1;
            }
            if (action.equals(AppAuthenticationProtection.DISALLOW)) {
                return 2;
            }
            return 3;
        }
        return 3;
    }

    public boolean setAction(int action) {
        int oldValue = this.getAction();
        if (oldValue != action) {
            if (this._appAuthentication == null) {
                this.createAppAuthentication();
            }
            this._appAuthentication.setAction(AppAuthenticationObject.getActionString(action));
            return true;
        }
        return false;
    }

    public String getAdditionalText() {
        if (this._appAuthentication != null) {
            String text = this._appAuthentication.getOptAdditionalText();
            return text == null ? "" : text;
        }
        return "";
    }

    public boolean setAdditionalText(String newTxt) {
        if (newTxt == null) {
            return false;
        }
        String oldValue = this.getAdditionalText();
        if (!oldValue.equals(newTxt)) {
            if (this._appAuthentication == null) {
                this.createAppAuthentication();
            }
            this._appAuthentication.setOptAdditionalText(newTxt);
            return true;
        }
        return false;
    }

    public boolean getAllowNew() {
        Boolean allow;
        if (this._appAuthentication != null && (allow = this._appAuthentication.getOptAllowNewDll()) != null) {
            return allow;
        }
        return false;
    }

    public boolean setAllowNew(boolean newValue) {
        boolean oldValue = this.getAllowNew();
        if (oldValue != newValue) {
            if (this._appAuthentication == null) {
                this.createAppAuthentication();
            }
            this._appAuthentication.setOptAllowNewDll(Boolean.valueOf(newValue));
            return true;
        }
        return false;
    }

    public boolean getAllowKnownNew() {
        Boolean allowKnow;
        if (this._appAuthentication != null && (allowKnow = this._appAuthentication.getOptAllowKnownNewDll()) != null) {
            return allowKnow;
        }
        return false;
    }

    public boolean setAllowKnownNew(boolean newValue) {
        boolean oldValue = this.getAllowKnownNew();
        if (oldValue != newValue) {
            if (this._appAuthentication == null) {
                this.createAppAuthentication();
            }
            this._appAuthentication.setOptAllowKnownNewDll(Boolean.valueOf(newValue));
            return true;
        }
        return false;
    }

    public boolean getAllowChange() {
        Boolean allowChange;
        if (this._appAuthentication != null && (allowChange = this._appAuthentication.getOptAllowDllChange()) != null) {
            return allowChange;
        }
        return false;
    }

    public boolean setAllowChange(boolean newValue) {
        boolean oldValue = this.getAllowChange();
        if (oldValue != newValue) {
            if (this._appAuthentication == null) {
                this.createAppAuthentication();
            }
            this._appAuthentication.setOptAllowDllChange(Boolean.valueOf(newValue));
            return true;
        }
        return false;
    }

    public ApplicationObject[] getApplications() {
        ArrayList<ApplicationObject> appObjs = new ArrayList<ApplicationObject>();
        if (this._appAuthentication != null) {
            ExcludedAppArray array = this._appAuthentication.getExcludedAppArray();
            Vector allApp = array.getExecutable();
            for (int i = 0; i < allApp.size(); ++i) {
                ApplicationObject appObj = new ApplicationObject((Executable)allApp.get(i));
                appObjs.add(appObj);
            }
        }
        return appObjs.toArray(new ApplicationObject[0]);
    }

    public AppAuthenticationProtection getAppAuthenticationProtection() {
        return this._appAuthentication;
    }

    public void setApplicationObject(int index, ApplicationObject newAppObj) {
        if (this._appAuthentication == null) {
            return;
        }
        ExcludedAppArray array = this._appAuthentication.getExcludedAppArray();
        array.setExecutable(index, newAppObj.getExecutable());
    }

    public boolean isApplicationExist(ApplicationObject appObj) {
        if (this._appAuthentication == null) {
            return false;
        }
        ExcludedAppArray array = this._appAuthentication.getExcludedAppArray();
        return PolicyHandler.isApplicationExisted(array, appObj.getExecutable());
    }

    public boolean isShowAppAuthentication() {
        LicenseObject licenseObj = LicenseObject.getInstance();
        return licenseObj.isFirewallPolicy() || this.getEnabled();
    }
}

