/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.AlRegistry;
import com.sygate.scm.common.configobject.schema.CmsConnection;
import com.sygate.scm.common.configobject.schema.DhcpServerAddress;
import com.sygate.scm.common.configobject.schema.DnsHost;
import com.sygate.scm.common.configobject.schema.DnsResolve;
import com.sygate.scm.common.configobject.schema.DnsResult;
import com.sygate.scm.common.configobject.schema.DnsServerAddress;
import com.sygate.scm.common.configobject.schema.DomainName;
import com.sygate.scm.common.configobject.schema.EthernetExclusionCondition;
import com.sygate.scm.common.configobject.schema.FileExists;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroup;
import com.sygate.scm.common.configobject.schema.GatewayAddress;
import com.sygate.scm.common.configobject.schema.ICMPRequest;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import com.sygate.scm.common.configobject.schema.Ipv6Range;
import com.sygate.scm.common.configobject.schema.Ipv6SubNet;
import com.sygate.scm.common.configobject.schema.LocalHostAddress;
import com.sygate.scm.common.configobject.schema.LocalHostName;
import com.sygate.scm.common.configobject.schema.LocationCriteriaCondition;
import com.sygate.scm.common.configobject.schema.MacAddress;
import com.sygate.scm.common.configobject.schema.NICDescription;
import com.sygate.scm.common.configobject.schema.NetworkConnection;
import com.sygate.scm.common.configobject.schema.OS;
import com.sygate.scm.common.configobject.schema.OSVersion;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.RegistryData;
import com.sygate.scm.common.configobject.schema.RegistryKey;
import com.sygate.scm.common.configobject.schema.RegistryValue;
import com.sygate.scm.common.configobject.schema.RemoteDeviceCommunication;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.configobject.schema.TpmDevice;
import com.sygate.scm.common.configobject.schema.UserName;
import com.sygate.scm.common.configobject.schema.WinsServerAddress;
import com.sygate.scm.common.configobject.schema.WirelessSSID;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AddressObject;
import com.sygate.scm.console.logicobject.CountableInt;
import com.sygate.scm.console.logicobject.DeletableObjInt;
import com.sygate.scm.console.logicobject.ICMPReqUtils;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.util.ConsoleAssertion;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class AlSignatureOrObject
extends AbstractUIObject
implements DeletableObjInt,
CountableInt,
CopitableObject {
    public static final String MATCH_ALL = "MATCH_ALL_HOST_ADDR";
    public static final String MATCH_ANY = "MATCH_ANY_HOST_ADDR";
    public static final String PPTP = "PPTP";
    public static final String VPN = "VPN";
    public static final String ALL = "ALL";
    public static final String ETHERNET = "ETHERNET";
    public static final String DUN = "DUN";
    public static final String VP_CISCO3000 = "VP_CISCO3000";
    public static final String VP_SAFENET = "VP_SAFENET";
    public static final String VP_CHECKPOINT = "VP_CHECKPOINT";
    public static final String VP_NETSCREEN = "VP_NETSCREEN";
    public static final String VP_ENTERASYS_AURO = "VP_ENTERASYS_AURO";
    public static final String VP_NORTEL = "VP_NORTEL";
    public static final String VP_AVENTAIL_SSLVPN = "VP_AVENTAIL_SSLVPN";
    public static final String VP_ALCATEL = "VP_ALCATEL";
    public static final String VP_JUNIPER_SSL = "VP_JUNIPER_SSL";
    public static final String MATCH_ALL_LOCAL_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAllIPOfAgentAreListedBelow");
    public static final String MATCH_ANY_LOCAL_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentHasOneOfIPListedBelow");
    public static final String NO_MATCH_ALL_LOCAL_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentDoesNotHaveAnyAddressListedBelow");
    public static final String MATCH_ALL_WINS_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAllWINSServerIPsListedBelow");
    public static final String MATCH_ANY_WINS_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfWINSServerIPsIsOneOfAddressBelow");
    public static final String NO_MATCH_ALL_WINS_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAnyWINSServerIPsAreNotAddressBelow");
    public static final String MATCH_ALL_DNS_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAllDNSServerIPListedBelow");
    public static final String MATCH_ANY_DNS_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfDNSServerIPsOneOfAddressBelow");
    public static final String NO_MATCH_ALL_DNS_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAnyDNSServerIPNotAddressBelow");
    public static final String GATEWAY_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfGatewayMatchesBelow");
    public static final String NO_GATEWAY_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfNoGatewayMatchesBelow");
    public static final String DHCP_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfDHCPMatchesBelow");
    public static final String NO_DHCP_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfNoDHCPMatchesBelow");
    public static final String CMS_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descHostConnectToPolicyManager");
    public static final String CMS_NOT_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descHostNotConnectToPolicyManager");
    public static final String DNSRESOLVE_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descDNSLookupFindsRightIP");
    public static final String NO_DNSRESOLVE_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descDNSLookupNotFindRightIP");
    public static final String WIRELESS_SSID_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentUseOneOfWirelessSSID");
    public static final String NO_WIRELESS_SSID_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentNotUseWirelessSSID");
    public static final String NIC_DESCRIPTION_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentUseOneNICDescBelow");
    public static final String NO_NIC_DESCRIPTION_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentNotUseNICDescBelow");
    public static final String REMOTE_DEVICE_COMM_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfRemoteDeviceNameIs");
    public static final String DOMAIN_NAME_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentUseOneDomainNameBelow");
    public static final String NO_DOMAIN_NAME_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentNotUseNomainNameBelow");
    public static final String LOCAL_HOST_NAME_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentUseOneLocalHostNameBelow");
    public static final String NO_LOCAL_HOST_NAME_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentNotUseLocalHostNameBelow");
    public static final String USER_NAME_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentUseOneUserNameBelow");
    public static final String NO_USER_NAME_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentNotUseUserNameBelow");
    public static final String FILE_EXISTS_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentUseOneFileExistsBelow");
    public static final String NO_FILE_EXISTS_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentNotUseFileExistsBelow");
    public static final String OS_VERSION_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentUseOneOSVersionBelow");
    public static final String NO_OS_VERSION_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descIfAgentNotUseOSVersionBelow");
    public static final String OS_VERSION_ARCH_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureObject.OSVersion.Arch");
    public static final String OS_VERSION_INVALID_ARCH_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureObject.OSVersion.InvalidArch");
    public static final String OS_VERSION_NAME_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureObject.OSVersion.OSName");
    public static final String OS_VERSION_BUILD_NUMBER_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureObject.OSVersion.BuildNumber");
    public static final String ALL_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbAnyNetworking");
    public static final String PPTP_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbMicroPPTPVPN");
    public static final String DUN_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbDialupNetworking");
    public static final String VP_CISCO3000_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbCISCOVPN");
    public static final String VP_SAFENET_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbSafeNetSoftRemoteVPN");
    public static final String VP_CHECKPOINT_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbCheckPointVPN1");
    public static final String VP_NETSCREEN_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbNetScreenRemoteVPN");
    public static final String VP_ENTERASYS_AURO_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbEnterasysAuroreanVPN");
    public static final String VP_NORTEL_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbNortelContivityVPN");
    public static final String VP_AVENTAIL_SSLVPN_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbAventailSSLVPN");
    public static final String VP_JUNIPER_SSLVPN_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbJuniperSSLVPN");
    public static final String VP_ALCATEL_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbAlcatelVPN");
    public static final String ETHERNET_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbEthernet");
    public static final String WIRELESS_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbWireless");
    public static final String TPM_IBM_TOKEN = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbIBMTPMToken");
    public static final String TPM_HP_TOKEN = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmbHPTPMToken");
    public static final String TPM_ANY_TOKEN = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.cmdAnyTPMToken");
    public static final String NOT = "[NOT] ";
    public static final String ICMP_REQ_PING_ANY_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.pinganyhost");
    public static final String ICMP_REQ_PING_ALL_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.pingallhost");
    public static final String ICMP_REQ_NOT_PING_ANY_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.notpinganyhost");
    public static final String ICMP_REQ_NOT_PING_ALL_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.notpingallhost");
    public static final int TYPE_LOCALHOST = 0;
    public static final int TYPE_GATEWAY = 1;
    public static final int TYPE_WINS = 2;
    public static final int TYPE_DNS = 3;
    public static final int TYPE_DHCP = 4;
    public static final int TYPE_NETWORK = 5;
    public static final int TYPE_CMS = 6;
    public static final int TYPE_HI = 7;
    public static final int TYPE_TPM = 8;
    public static final int TYPE_DNSRESOLVE = 9;
    public static final int TYPE_REGISTRY = 10;
    public static final int TYPE_WIRELESS_SSID = 11;
    public static final int TYPE_NIC_DESC = 12;
    public static final int TYPE_REMOTE_DEVICE_COMM = 13;
    public static final int TYPE_DOMAIN_NAME = 14;
    public static final int TYPE_ICMP_PING = 15;
    public static final int TYPE_LOCAL_HOST_NAME = 16;
    public static final int TYPE_USER_NAME = 17;
    public static final int TYPE_FILE_EXISTS = 18;
    public static final int TYPE_OS_VERSION = 19;
    static Map<Integer, String> VPNTypeDescMap = new HashMap<Integer, String>();
    static Map<String, Integer> VPNDescTypeMap = new HashMap<String, Integer>();
    static Map<Integer, String> TPMTypeDescMap = new HashMap<Integer, String>();
    private int addressType;
    private ConfigObject _orCondition;
    private int nodeNumber = 0;
    private Integer operator = 0;

    public static Map<Integer, String> getVPNTypeDescMap() {
        return VPNTypeDescMap;
    }

    public static Map<String, Integer> getVPNDescTypeMap() {
        return VPNDescTypeMap;
    }

    public static Map<Integer, String> getTPMTypeDescap() {
        return TPMTypeDescMap;
    }

    public AlSignatureOrObject() {
    }

    public AlSignatureOrObject(int type, ConfigObject object) {
        this.addressType = type;
        this._orCondition = object;
    }

    public AlSignatureOrObject(int type) {
        this.addressType = type;
        this.recreateObject(type);
    }

    public void addAddress(AddressObject newAddr) {
        block0 : switch (this.addressType) {
            case 0: {
                LocalHostAddress local = (LocalHostAddress)this._orCondition;
                switch (newAddr.getType()) {
                    case 0: {
                        local.addIpAddress((IpAddress)newAddr.getObject());
                        break block0;
                    }
                    case 1: {
                        local.addIpRange((IpRange)newAddr.getObject());
                        break block0;
                    }
                    case 2: {
                        local.addSubNet((SubNet)newAddr.getObject());
                        break block0;
                    }
                    case 5: {
                        FwNetworkHostGroup group = newAddr.getHostGroup();
                        ObjReference ref = new ObjReference();
                        ref.setName("HostGroup");
                        ref.setTargetId(group.getId());
                        ref.setOptEnable(Boolean.TRUE);
                        ref.setTargetType("FwNetworkHostGroup");
                        local.addObjReference(ref);
                        break block0;
                    }
                    case 7: {
                        local.addIpv6Address((Ipv6Address)newAddr.getObject());
                        break block0;
                    }
                    case 9: {
                        local.addIpv6SubNet((Ipv6SubNet)newAddr.getObject());
                        break block0;
                    }
                    case 8: {
                        local.addIpv6Range((Ipv6Range)newAddr.getObject());
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                WinsServerAddress wins = (WinsServerAddress)this._orCondition;
                switch (newAddr.getType()) {
                    case 0: {
                        wins.addIpAddress((IpAddress)newAddr.getObject());
                        break block0;
                    }
                    case 1: {
                        wins.addIpRange((IpRange)newAddr.getObject());
                        break block0;
                    }
                    case 2: {
                        wins.addSubNet((SubNet)newAddr.getObject());
                        break block0;
                    }
                    case 5: {
                        FwNetworkHostGroup group = newAddr.getHostGroup();
                        ObjReference ref = new ObjReference();
                        ref.setName("HostGroup");
                        ref.setTargetId(group.getId());
                        ref.setOptEnable(Boolean.TRUE);
                        ref.setTargetType("FwNetworkHostGroup");
                        wins.addObjReference(ref);
                        break block0;
                    }
                    case 7: {
                        wins.addIpv6Address((Ipv6Address)newAddr.getObject());
                        break block0;
                    }
                    case 9: {
                        wins.addIpv6SubNet((Ipv6SubNet)newAddr.getObject());
                        break block0;
                    }
                    case 8: {
                        wins.addIpv6Range((Ipv6Range)newAddr.getObject());
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                DnsServerAddress dns = (DnsServerAddress)this._orCondition;
                switch (newAddr.getType()) {
                    case 0: {
                        dns.addIpAddress((IpAddress)newAddr.getObject());
                        break block0;
                    }
                    case 1: {
                        dns.addIpRange((IpRange)newAddr.getObject());
                        break block0;
                    }
                    case 2: {
                        dns.addSubNet((SubNet)newAddr.getObject());
                        break block0;
                    }
                    case 5: {
                        FwNetworkHostGroup group = newAddr.getHostGroup();
                        ObjReference ref = new ObjReference();
                        ref.setName("HostGroup");
                        ref.setTargetId(group.getId());
                        ref.setOptEnable(Boolean.TRUE);
                        ref.setTargetType("FwNetworkHostGroup");
                        dns.addObjReference(ref);
                        break block0;
                    }
                    case 7: {
                        dns.addIpv6Address((Ipv6Address)newAddr.getObject());
                        break block0;
                    }
                    case 9: {
                        dns.addIpv6SubNet((Ipv6SubNet)newAddr.getObject());
                        break block0;
                    }
                    case 8: {
                        dns.addIpv6Range((Ipv6Range)newAddr.getObject());
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                DhcpServerAddress dhcp = (DhcpServerAddress)this._orCondition;
                switch (newAddr.getType()) {
                    case 0: {
                        dhcp.addIpAddress((IpAddress)newAddr.getObject());
                        break block0;
                    }
                    case 1: {
                        dhcp.addIpRange((IpRange)newAddr.getObject());
                        break block0;
                    }
                    case 2: {
                        dhcp.addSubNet((SubNet)newAddr.getObject());
                        break block0;
                    }
                    case 3: {
                        dhcp.addMacAddress((MacAddress)newAddr.getObject());
                        break block0;
                    }
                    case 5: {
                        FwNetworkHostGroup group = newAddr.getHostGroup();
                        ObjReference ref = new ObjReference();
                        ref.setName("HostGroup");
                        ref.setTargetId(group.getId());
                        ref.setOptEnable(Boolean.TRUE);
                        ref.setTargetType("FwNetworkHostGroup");
                        dhcp.addObjReference(ref);
                        break block0;
                    }
                    case 7: {
                        dhcp.addIpv6Address((Ipv6Address)newAddr.getObject());
                        break block0;
                    }
                    case 9: {
                        dhcp.addIpv6SubNet((Ipv6SubNet)newAddr.getObject());
                        break block0;
                    }
                    case 8: {
                        dhcp.addIpv6Range((Ipv6Range)newAddr.getObject());
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                GatewayAddress gateway = (GatewayAddress)this._orCondition;
                switch (newAddr.getType()) {
                    case 0: {
                        gateway.addIpAddress((IpAddress)newAddr.getObject());
                        break block0;
                    }
                    case 7: {
                        gateway.addIpv6Address((Ipv6Address)newAddr.getObject());
                        break block0;
                    }
                    case 1: {
                        gateway.addIpRange((IpRange)newAddr.getObject());
                        break block0;
                    }
                    case 8: {
                        gateway.addIpv6Range((Ipv6Range)newAddr.getObject());
                        break block0;
                    }
                    case 2: {
                        gateway.addSubNet((SubNet)newAddr.getObject());
                        break block0;
                    }
                    case 9: {
                        gateway.addIpv6SubNet((Ipv6SubNet)newAddr.getObject());
                        break block0;
                    }
                    case 3: {
                        gateway.addMacAddress((MacAddress)newAddr.getObject());
                        break block0;
                    }
                    case 5: {
                        FwNetworkHostGroup group = newAddr.getHostGroup();
                        ObjReference ref = new ObjReference();
                        ref.setName("HostGroup");
                        ref.setTargetId(group.getId());
                        ref.setOptEnable(Boolean.TRUE);
                        ref.setTargetType("FwNetworkHostGroup");
                        gateway.addObjReference(ref);
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                DnsResolve dnsResolve = (DnsResolve)this._orCondition;
                switch (newAddr.getType()) {
                    case 0: {
                        DnsResult result = new DnsResult();
                        result.setDnsName(newAddr.getName());
                        result.setOptIpAddress(((IpAddress)newAddr.getObject()).getContent());
                        dnsResolve.addDnsResult(result);
                        break block0;
                    }
                    case 7: {
                        DnsResult ipv6Result = new DnsResult();
                        ipv6Result.setDnsName(newAddr.getName());
                        ipv6Result.setOptIpv6Address(((Ipv6Address)newAddr.getObject()).getContent());
                        dnsResolve.addDnsResult(ipv6Result);
                        break block0;
                    }
                }
                break;
            }
            case 10: {
                break;
            }
            case 15: {
                ICMPRequest req = (ICMPRequest)this._orCondition;
                switch (newAddr.getType()) {
                    case 0: {
                        req.addIpAddress((IpAddress)newAddr.getObject());
                        break block0;
                    }
                    case 7: {
                        req.addIpv6Address((Ipv6Address)newAddr.getObject());
                        break block0;
                    }
                    case 6: {
                        req.addDnsHost((DnsHost)newAddr.getObject());
                        break block0;
                    }
                    case 5: {
                        FwNetworkHostGroup group = newAddr.getHostGroup();
                        ObjReference ref = new ObjReference();
                        ref.setName("HostGroup");
                        ref.setTargetId(group.getId());
                        ref.setOptEnable(Boolean.TRUE);
                        ref.setTargetType("FwNetworkHostGroup");
                        req.addObjReference(ref);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void addLocationCriteriaConditions(LocationCriteriaCondition[] newConditions) {
        for (int index = 0; index < newConditions.length; ++index) {
            this.addLocationCriteriaCondition(newConditions[index]);
        }
    }

    public void addOSs(OS[] newConditions) {
        for (int index = 0; index < newConditions.length; ++index) {
            this.addOS(newConditions[index]);
        }
    }

    public void addLocationCriteriaCondition(LocationCriteriaCondition newCondition) {
        switch (this.addressType) {
            case 11: {
                WirelessSSID wirelessSSID = (WirelessSSID)this._orCondition;
                wirelessSSID.addLocationCriteriaCondition(newCondition);
                break;
            }
            case 12: {
                NICDescription nicDescription = (NICDescription)this._orCondition;
                nicDescription.addLocationCriteriaCondition(newCondition);
                break;
            }
            case 14: {
                DomainName domainName = (DomainName)this._orCondition;
                domainName.addLocationCriteriaCondition(newCondition);
                break;
            }
            case 16: {
                LocalHostName localHostName = (LocalHostName)this._orCondition;
                localHostName.addLocationCriteriaCondition(newCondition);
                break;
            }
            case 17: {
                UserName userName = (UserName)this._orCondition;
                userName.addLocationCriteriaCondition(newCondition);
                break;
            }
            case 18: {
                FileExists fileExists = (FileExists)this._orCondition;
                fileExists.addLocationCriteriaCondition(newCondition);
                break;
            }
        }
    }

    public void addOS(OS newCondition) {
        if (this.addressType == 19) {
            OSVersion osVersion = (OSVersion)this._orCondition;
            osVersion.addOS(newCondition);
        }
    }

    public void replaceAddress(AddressObject oldObj, AddressObject newObj) {
        if (oldObj != newObj) {
            if (oldObj.getType() != newObj.getType()) {
                oldObj.delete();
                this.addAddress(newObj);
            } else {
                block0 : switch (this.addressType) {
                    case 0: {
                        LocalHostAddress local = (LocalHostAddress)this._orCondition;
                        switch (newObj.getType()) {
                            case 0: {
                                int index = local.getIpAddress().indexOf(oldObj.getObject());
                                local.setIpAddress(index, (IpAddress)newObj.getObject());
                                break block0;
                            }
                            case 1: {
                                int index = local.getIpRange().indexOf(oldObj.getObject());
                                local.setIpRange(index, (IpRange)newObj.getObject());
                                break block0;
                            }
                            case 2: {
                                int index = local.getSubNet().indexOf(oldObj.getObject());
                                local.setSubNet(index, (SubNet)newObj.getObject());
                                break block0;
                            }
                            case 5: {
                                int index = local.getObjReference().indexOf(oldObj.getObject());
                                local.setObjReference(index, (ObjReference)newObj.getObject());
                                break block0;
                            }
                        }
                        break;
                    }
                    case 2: {
                        WinsServerAddress wins = (WinsServerAddress)this._orCondition;
                        switch (newObj.getType()) {
                            case 0: {
                                int index = wins.getIpAddress().indexOf(oldObj.getObject());
                                wins.setIpAddress(index, (IpAddress)newObj.getObject());
                                break block0;
                            }
                            case 1: {
                                int index = wins.getIpRange().indexOf(oldObj.getObject());
                                wins.setIpRange(index, (IpRange)newObj.getObject());
                                break block0;
                            }
                            case 2: {
                                int index = wins.getSubNet().indexOf(oldObj.getObject());
                                wins.setSubNet(index, (SubNet)newObj.getObject());
                                break block0;
                            }
                            case 5: {
                                int index = wins.getObjReference().indexOf(oldObj.getObject());
                                wins.setObjReference(index, (ObjReference)newObj.getObject());
                                break block0;
                            }
                        }
                        break;
                    }
                    case 3: {
                        DnsServerAddress dns = (DnsServerAddress)this._orCondition;
                        switch (newObj.getType()) {
                            case 0: {
                                int index = dns.getIpAddress().indexOf(oldObj.getObject());
                                dns.setIpAddress(index, (IpAddress)newObj.getObject());
                                break block0;
                            }
                            case 1: {
                                int index = dns.getIpRange().indexOf(oldObj.getObject());
                                dns.setIpRange(index, (IpRange)newObj.getObject());
                                break block0;
                            }
                            case 2: {
                                int index = dns.getSubNet().indexOf(oldObj.getObject());
                                dns.setSubNet(index, (SubNet)newObj.getObject());
                                break block0;
                            }
                            case 5: {
                                int index = dns.getObjReference().indexOf(oldObj.getObject());
                                dns.setObjReference(index, (ObjReference)newObj.getObject());
                                break block0;
                            }
                        }
                        break;
                    }
                    case 4: {
                        DhcpServerAddress dhcp = (DhcpServerAddress)this._orCondition;
                        switch (newObj.getType()) {
                            case 0: {
                                int index = dhcp.getIpAddress().indexOf(oldObj.getObject());
                                dhcp.setIpAddress(index, (IpAddress)newObj.getObject());
                                break block0;
                            }
                            case 1: {
                                int index = dhcp.getIpRange().indexOf(oldObj.getObject());
                                dhcp.setIpRange(index, (IpRange)newObj.getObject());
                                break block0;
                            }
                            case 2: {
                                int index = dhcp.getSubNet().indexOf(oldObj.getObject());
                                dhcp.setSubNet(index, (SubNet)newObj.getObject());
                                break block0;
                            }
                            case 3: {
                                int index = dhcp.getMacAddress().indexOf(oldObj.getObject());
                                dhcp.setMacAddress(index, (MacAddress)newObj.getObject());
                                break block0;
                            }
                            case 5: {
                                int index = dhcp.getObjReference().indexOf(oldObj.getObject());
                                dhcp.setObjReference(index, (ObjReference)newObj.getObject());
                                break block0;
                            }
                        }
                        break;
                    }
                    case 1: {
                        GatewayAddress gateway = (GatewayAddress)this._orCondition;
                        switch (newObj.getType()) {
                            case 0: {
                                int index = gateway.getIpAddress().indexOf(oldObj.getObject());
                                gateway.setIpAddress(index, (IpAddress)newObj.getObject());
                                break block0;
                            }
                            case 1: {
                                int index = gateway.getIpRange().indexOf(oldObj.getObject());
                                gateway.setIpRange(index, (IpRange)newObj.getObject());
                                break block0;
                            }
                            case 2: {
                                int index = gateway.getSubNet().indexOf(oldObj.getObject());
                                gateway.setSubNet(index, (SubNet)newObj.getObject());
                                break block0;
                            }
                            case 3: {
                                int index = gateway.getMacAddress().indexOf(oldObj.getObject());
                                gateway.setMacAddress(index, (MacAddress)newObj.getObject());
                                break block0;
                            }
                            case 5: {
                                int index = gateway.getObjReference().indexOf(oldObj.getObject());
                                gateway.setObjReference(index, (ObjReference)newObj.getObject());
                                break block0;
                            }
                        }
                        break;
                    }
                    case 9: {
                        DnsResolve dnsResolve = (DnsResolve)this._orCondition;
                        switch (newObj.getType()) {
                            case 0: {
                                int index = dnsResolve.getDnsResult().indexOf(oldObj.getObject());
                                DnsResult result = new DnsResult();
                                result.setDnsName(newObj.getName());
                                result.setOptIpAddress(((IpAddress)newObj.getObject()).getContent());
                                dnsResolve.setDnsResult(index, result);
                                break block0;
                            }
                            case 7: {
                                int index = dnsResolve.getDnsResult().indexOf(oldObj.getObject());
                                DnsResult ipv6Result = new DnsResult();
                                ipv6Result.setDnsName(newObj.getName());
                                ipv6Result.setOptIpv6Address(((Ipv6Address)newObj.getObject()).getContent());
                                dnsResolve.setDnsResult(index, ipv6Result);
                                break block0;
                            }
                        }
                        break;
                    }
                    case 10: {
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void delete() {
        this._orCondition.getParent().removeChild((AbstractSchema)this._orCondition);
    }

    public void replace(AddressObject oldObj, AddressObject newObj) {
        if (oldObj != newObj) {
            this.addAddress(newObj);
        }
    }

    public void addEthernetExclusionConditions(EthernetExclusionCondition[] newConditions) {
        for (int index = 0; index < newConditions.length; ++index) {
            this.addEthernetExclusionCondition(newConditions[index]);
        }
    }

    public void addEthernetExclusionCondition(EthernetExclusionCondition newCondition) {
        if (this.addressType == 5) {
            NetworkConnection network = (NetworkConnection)this._orCondition;
            network.addEthernetExclusionCondition(newCondition);
        }
    }

    public void clearAllAddress() {
        AddressObject[] allAddress = this.getAddress();
        for (int i = 0; i < allAddress.length; ++i) {
            allAddress[i].delete();
        }
    }

    private void recreateObject(int type) {
        this.addressType = type;
        this.operator = 0;
        switch (type) {
            case 0: {
                this._orCondition = new LocalHostAddress();
                ((LocalHostAddress)this._orCondition).setOptMode(LocalHostAddress.MATCH_ANY_HOST_ADDR);
                ((LocalHostAddress)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 1: {
                this._orCondition = new GatewayAddress();
                ((GatewayAddress)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 2: {
                this._orCondition = new WinsServerAddress();
                ((WinsServerAddress)this._orCondition).setOptMode(WinsServerAddress.MATCH_ANY_HOST_ADDR);
                ((WinsServerAddress)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 3: {
                this._orCondition = new DnsServerAddress();
                ((DnsServerAddress)this._orCondition).setOptMode(DnsServerAddress.MATCH_ANY_HOST_ADDR);
                ((DnsServerAddress)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 4: {
                this._orCondition = new DhcpServerAddress();
                ((DhcpServerAddress)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 5: {
                this._orCondition = new NetworkConnection();
                NetworkConnection net = (NetworkConnection)this._orCondition;
                net.setOptConnectionStatus(Long.valueOf(1L));
                net.setOptNetworkInterfaceType(NetworkConnection.DUN);
                ((NetworkConnection)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 6: {
                this._orCondition = new CmsConnection();
                ((CmsConnection)this._orCondition).setConnectionStatus(Long.valueOf(1L));
                ((CmsConnection)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 8: {
                this._orCondition = new TpmDevice();
                ((TpmDevice)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 9: {
                this._orCondition = new DnsResolve();
                ((DnsResolve)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 10: {
                this._orCondition = new AlRegistry();
                AlRegistry registry = (AlRegistry)this._orCondition;
                RegistryKey rKey = new RegistryKey();
                rKey.setOptOperator(RegistryKey.EXIST);
                rKey.setKeyName("");
                registry.setOptRegistryKey(rKey);
                break;
            }
            case 11: {
                this._orCondition = new WirelessSSID();
                ((WirelessSSID)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 12: {
                this._orCondition = new NICDescription();
                ((NICDescription)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 13: {
                this._orCondition = new RemoteDeviceCommunication();
                break;
            }
            case 14: {
                this._orCondition = new DomainName();
                ((DomainName)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 15: {
                this._orCondition = new ICMPRequest();
                ((ICMPRequest)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 16: {
                this._orCondition = new LocalHostName();
                ((LocalHostName)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 17: {
                this._orCondition = new UserName();
                ((UserName)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 18: {
                this._orCondition = new FileExists();
                ((FileExists)this._orCondition).setOptOperator(this.operator);
                break;
            }
            case 19: {
                this._orCondition = new OSVersion();
                ((OSVersion)this._orCondition).setOptOperator(this.operator);
                break;
            }
        }
    }

    private String formatLocalHost() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ");
        LocalHostAddress _localHostAddress = (LocalHostAddress)this._orCondition;
        Integer operator = _localHostAddress.getOptOperator();
        if (operator == null) {
            operator = _localHostAddress.getDefOperator();
        }
        if (LocalHostAddress.NOT_EQUAL.equals(operator)) {
            buffer.append(NO_MATCH_ALL_LOCAL_DESC);
        } else {
            Integer mode = _localHostAddress.getOptMode();
            if (mode == null || mode.equals(LocalHostAddress.MATCH_ALL_HOST_ADDR)) {
                buffer.append(MATCH_ALL_LOCAL_DESC);
            } else {
                buffer.append(MATCH_ANY_LOCAL_DESC);
            }
        }
        AddressObject[] allAddress = this.getAddress();
        for (int i = 0; i < allAddress.length; ++i) {
            buffer.append("<br>&nbsp;&nbsp;&nbsp; ");
            buffer.append(allAddress[i].getContent());
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatWINS() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ");
        WinsServerAddress _localHostAddress = (WinsServerAddress)this._orCondition;
        if (WinsServerAddress.NOT_EQUAL.equals(_localHostAddress.getOptOperator())) {
            buffer.append(NO_MATCH_ALL_WINS_DESC);
        } else {
            Integer mode = _localHostAddress.getOptMode();
            if (mode == null || mode.equals(WinsServerAddress.MATCH_ALL_HOST_ADDR)) {
                buffer.append(MATCH_ALL_WINS_DESC);
            } else {
                buffer.append(MATCH_ANY_WINS_DESC);
            }
        }
        AddressObject[] allAddress = this.getAddress();
        for (int i = 0; i < allAddress.length; ++i) {
            buffer.append("<br>&nbsp;&nbsp;&nbsp; ");
            buffer.append(allAddress[i].getContent());
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatDNS() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ");
        DnsServerAddress _localHostAddress = (DnsServerAddress)this._orCondition;
        if (DnsServerAddress.NOT_EQUAL.equals(_localHostAddress.getOptOperator())) {
            buffer.append(NO_MATCH_ALL_DNS_DESC);
        } else {
            Integer mode = _localHostAddress.getOptMode();
            if (mode == null || mode.equals(DnsServerAddress.MATCH_ALL_HOST_ADDR)) {
                buffer.append(MATCH_ALL_DNS_DESC);
            } else {
                buffer.append(MATCH_ANY_DNS_DESC);
            }
        }
        AddressObject[] allAddress = this.getAddress();
        for (int i = 0; i < allAddress.length; ++i) {
            buffer.append("<br>&nbsp;&nbsp;&nbsp; ");
            buffer.append(allAddress[i].getContent());
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatGateway() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ");
        GatewayAddress _localHostAddress = (GatewayAddress)this._orCondition;
        if (GatewayAddress.NOT_EQUAL.equals(_localHostAddress.getOptOperator())) {
            buffer.append(NO_GATEWAY_DESC);
        } else {
            buffer.append(GATEWAY_DESC);
        }
        AddressObject[] allAddress = this.getAddress();
        for (int i = 0; i < allAddress.length; ++i) {
            buffer.append("<br>&nbsp;&nbsp;&nbsp; ");
            buffer.append(allAddress[i].getContent());
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatDHCP() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ");
        DhcpServerAddress _localHostAddress = (DhcpServerAddress)this._orCondition;
        if (DhcpServerAddress.NOT_EQUAL.equals(_localHostAddress.getOptOperator())) {
            buffer.append(NO_DHCP_DESC);
        } else {
            buffer.append(DHCP_DESC);
        }
        AddressObject[] allAddress = this.getAddress();
        for (int i = 0; i < allAddress.length; ++i) {
            buffer.append("<br>&nbsp;&nbsp;&nbsp; ");
            buffer.append(allAddress[i].getContent());
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatDNSRESOLVE() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ");
        DnsResolve _localHostAddress = (DnsResolve)this._orCondition;
        AddressObject[] allAddress = this.getAddress();
        for (int i = 0; i < allAddress.length; ++i) {
            if (i == 0) {
                Object[] args = new Object[]{allAddress[i].getName()};
                if (DnsResolve.NOT_EQUAL.equals(_localHostAddress.getOptOperator())) {
                    buffer.append(MessageFormat.format(NO_DNSRESOLVE_DESC, args));
                } else {
                    buffer.append(MessageFormat.format(DNSRESOLVE_DESC, args));
                }
            }
            buffer.append("<br>&nbsp;&nbsp;&nbsp; ");
            buffer.append(allAddress[i].getContent());
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatREGISTRY() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ");
        AlRegistry _localHostAddress = (AlRegistry)this._orCondition;
        RegistryKey regKey = _localHostAddress.getOptRegistryKey();
        if (regKey != null) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.RegistryKey"));
            String name = regKey.getKeyName();
            buffer.append(" [HKEY_LOCAL_MACHINE\\" + name + "]");
            Integer operator = regKey.getOptOperator();
            if (operator == null) {
                operator = regKey.getDefOperator();
            }
            if (RegistryKey.EXIST.equals(operator)) {
                buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.Exists"));
            } else {
                buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.DoesNotExist"));
            }
        } else {
            RegistryValue regValue = _localHostAddress.getOptRegistryValue();
            if (regValue != null) {
                buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.RegistryKeyName"));
                String name = regValue.getValueName();
                buffer.append(" [HKEY_LOCAL_MACHINE\\" + name + "]");
                Integer operator = regValue.getOptOperator();
                if (operator == null) {
                    operator = regValue.getDefOperator();
                }
                if (RegistryValue.EXIST.equals(operator)) {
                    buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.Exists"));
                } else {
                    buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.DoesNotExist"));
                }
            } else {
                RegistryData regData = _localHostAddress.getOptRegistryData();
                if (regData != null) {
                    buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.RegistryValue"));
                    String dataName = regData.getDataName();
                    buffer.append(" [HKEY_LOCAL_MACHINE\\" + dataName);
                    Integer operator = regData.getOptOperator();
                    if (operator == null) {
                        operator = regData.getDefOperator();
                    }
                    if (RegistryData.EQUAL.equals(operator)) {
                        buffer.append(" = ");
                    } else {
                        buffer.append(" != ");
                    }
                    String value = regData.getDataValue();
                    buffer.append(value);
                    buffer.append("]");
                } else {
                    buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.RegistryKeyType"));
                }
            }
        }
        AddressObject[] allAddress = this.getAddress();
        for (int i = 0; i < allAddress.length; ++i) {
            buffer.append("<br>&nbsp;&nbsp;&nbsp; ");
            buffer.append(allAddress[i].getContent());
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    private static void removeAllChildrean(ConfigObject parent) {
        Vector childrean = parent.getChildren();
        for (ConfigObject cObj : childrean) {
            parent.removeChild((AbstractSchema)cObj);
        }
    }

    private String formatWirelessSSID() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ");
        WirelessSSID wirelessSSID = (WirelessSSID)this._orCondition;
        if (WirelessSSID.NOT_EQUAL.equals(wirelessSSID.getOptOperator())) {
            buffer.append(NO_WIRELESS_SSID_DESC);
        } else {
            buffer.append(WIRELESS_SSID_DESC);
        }
        buffer.append(this.formatLocationCriteriaConditions());
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatNICDescription() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ");
        NICDescription nicDescription = (NICDescription)this._orCondition;
        if (NICDescription.NOT_EQUAL.equals(nicDescription.getOptOperator())) {
            buffer.append(NO_NIC_DESCRIPTION_DESC);
        } else {
            buffer.append(NIC_DESCRIPTION_DESC);
        }
        buffer.append(this.formatLocationCriteriaConditions());
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatRemoteDeviceComm() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ").append(REMOTE_DEVICE_COMM_DESC);
        RemoteDeviceCommunication remoteDeviceComm = (RemoteDeviceCommunication)this._orCondition;
        buffer.append(remoteDeviceComm.getDeviceName());
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatICMPRequest() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        ICMPRequest req = (ICMPRequest)this._orCondition;
        int rdStatus = ICMPReqUtils.getRdButtonStatus(req.getOptOperator(), req.getOptMode());
        switch (rdStatus) {
            case 0: {
                buffer.append(" ").append(ICMP_REQ_PING_ANY_DESC);
                break;
            }
            case 1: {
                buffer.append(" ").append(ICMP_REQ_PING_ALL_DESC);
                break;
            }
            case 2: {
                buffer.append(" ").append(ICMP_REQ_NOT_PING_ANY_DESC);
                break;
            }
            case 3: {
                buffer.append(" ").append(ICMP_REQ_NOT_PING_ALL_DESC);
                break;
            }
        }
        AddressObject[] allAddress = this.getAddress();
        for (int i = 0; i < allAddress.length; ++i) {
            buffer.append("<br>&nbsp;&nbsp;&nbsp; ");
            buffer.append(allAddress[i].getContent());
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatDomainName() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ");
        DomainName domainName = (DomainName)this._orCondition;
        if (DomainName.NOT_EQUAL.equals(domainName.getOptOperator())) {
            buffer.append(NO_DOMAIN_NAME_DESC);
        } else {
            buffer.append(DOMAIN_NAME_DESC);
        }
        buffer.append(this.formatLocationCriteriaConditions());
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatLocalHostName() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ");
        LocalHostName localHostName = (LocalHostName)this._orCondition;
        if (LocalHostName.NOT_EQUAL.equals(localHostName.getOptOperator())) {
            buffer.append(NO_LOCAL_HOST_NAME_DESC);
        } else {
            buffer.append(LOCAL_HOST_NAME_DESC);
        }
        buffer.append(this.formatLocationCriteriaConditions());
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatUserName() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ");
        UserName userName = (UserName)this._orCondition;
        if (UserName.NOT_EQUAL.equals(userName.getOptOperator())) {
            buffer.append(NO_USER_NAME_DESC);
        } else {
            buffer.append(USER_NAME_DESC);
        }
        buffer.append(this.formatLocationCriteriaConditions());
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatFileExists() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ");
        FileExists fileExists = (FileExists)this._orCondition;
        if (FileExists.NOT_EQUAL.equals(fileExists.getOptOperator())) {
            buffer.append(NO_FILE_EXISTS_DESC);
        } else {
            buffer.append(FILE_EXISTS_DESC);
        }
        buffer.append(this.formatLocationCriteriaConditions());
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatOSVersion() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.nodeNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR"));
        }
        buffer.append(" ");
        OSVersion osVersion = (OSVersion)this._orCondition;
        if (OSVersion.NOT_EQUAL.equals(osVersion.getOptOperator())) {
            buffer.append(NO_OS_VERSION_DESC);
        } else {
            buffer.append(OS_VERSION_DESC);
        }
        buffer.append(this.formatOSs());
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatLocationCriteriaConditions() {
        StringBuffer buffer = new StringBuffer();
        LocationCriteriaCondition[] allConditions = this.getLocationCriteriaConditions();
        for (int index = 0; index < allConditions.length; ++index) {
            buffer.append("<br>&nbsp;&nbsp;&nbsp;");
            buffer.append(allConditions[index].getCondition());
        }
        return buffer.toString();
    }

    private String formatOSs() {
        StringBuffer buffer = new StringBuffer();
        OS[] allConditions = this.getOSs();
        for (int index = 0; index < allConditions.length; ++index) {
            buffer.append("<br>&nbsp;&nbsp;&nbsp;");
            if (allConditions[index].getOptName() != null) {
                buffer.append(OS_VERSION_NAME_DESC);
                buffer.append(allConditions[index].getOptName());
            }
            buffer.append("&nbsp;");
            buffer.append(OS_VERSION_ARCH_DESC);
            try {
                buffer.append(allConditions[index].getOptArchValue());
            }
            catch (ValidationException e) {
                buffer.append(OS_VERSION_INVALID_ARCH_DESC);
            }
            if (allConditions[index].getOptBuildNumber() == null) continue;
            buffer.append("&nbsp;");
            buffer.append(OS_VERSION_BUILD_NUMBER_DESC);
            buffer.append(allConditions[index].getOptBuildNumber());
        }
        return buffer.toString();
    }

    private String formatEthernetExclusionConditions() {
        StringBuffer buffer = new StringBuffer();
        NetworkConnection networkConnection = (NetworkConnection)this._orCondition;
        EthernetExclusionCondition[] allConditions = networkConnection.getEthernetExclusionCondition().toArray(new EthernetExclusionCondition[0]);
        for (int index = 0; index < allConditions.length; ++index) {
            buffer.append("<br>&nbsp;&nbsp;&nbsp;");
            buffer.append(allConditions[index].getCondition());
        }
        return buffer.toString();
    }

    public String toString() {
        String not = "";
        switch (this.addressType) {
            case 0: {
                return this.formatLocalHost();
            }
            case 2: {
                return this.formatWINS();
            }
            case 3: {
                return this.formatDNS();
            }
            case 1: {
                return this.formatGateway();
            }
            case 4: {
                return this.formatDHCP();
            }
            case 5: {
                String exclusionConditions;
                Object desc = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.WhenHost");
                NetworkConnection network = (NetworkConnection)this._orCondition;
                desc = NetworkConnection.NOT_EQUAL.equals(network.getOptOperator()) ? (String)desc + MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.DoesNotUse") : (String)desc + MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.Uses");
                desc = (String)desc + VPNTypeDescMap.get(network.getOptNetworkInterfaceType());
                if (network.getOptNetworkInterfaceType() != null && network.getOptNetworkInterfaceType().equals(NetworkConnection.ETHERNET) && (exclusionConditions = this.formatEthernetExclusionConditions()).length() > 0) {
                    desc = (String)desc + MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.descTheFollowingIsTheExclusionNICList") + exclusionConditions;
                }
                if (this.nodeNumber > 0) {
                    desc = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR") + (String)desc;
                }
                return "<html>" + (String)desc + "</html>";
            }
            case 6: {
                CmsConnection cms = (CmsConnection)this._orCondition;
                not = "";
                if (CmsConnection.NOT_EQUAL.equals(cms.getOptOperator())) {
                    not = NOT;
                }
                long isConnect = cms.getConnectionStatus();
                String desc = this.nodeNumber > 0 ? (isConnect == 1L ? MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR") + not + CMS_DESC : MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR") + CMS_NOT_DESC) : (isConnect == 1L ? " " + not + CMS_DESC : " " + not + CMS_NOT_DESC);
                return "<html>" + desc + "</html>";
            }
            case 8: {
                Object tpmDesc = null;
                TpmDevice tpmDevice = (TpmDevice)this._orCondition;
                not = "";
                tpmDesc = TpmDevice.NOT_EQUAL.equals(tpmDevice.getOptOperator()) ? MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.WhenHostDoesNotUse") : MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.WhenHostUses");
                tpmDesc = (String)tpmDesc + TPMTypeDescMap.get(tpmDevice.getOptType());
                if (this.nodeNumber > 0) {
                    tpmDesc = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.OR") + (String)tpmDesc;
                }
                return "<html>" + (String)tpmDesc + "</html>";
            }
            case 9: {
                return this.formatDNSRESOLVE();
            }
            case 10: {
                return this.formatREGISTRY();
            }
            case 11: {
                return this.formatWirelessSSID();
            }
            case 12: {
                return this.formatNICDescription();
            }
            case 13: {
                return this.formatRemoteDeviceComm();
            }
            case 14: {
                return this.formatDomainName();
            }
            case 15: {
                return this.formatICMPRequest();
            }
            case 16: {
                return this.formatLocalHostName();
            }
            case 17: {
                return this.formatUserName();
            }
            case 18: {
                return this.formatFileExists();
            }
            case 19: {
                return this.formatOSVersion();
            }
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureOrObject.UnknownCondition");
    }

    public int getType() {
        return this.addressType;
    }

    public void setType(int newType) {
        if (this.addressType != newType) {
            this.recreateObject(newType);
        }
    }

    public void setOperator(Integer operator) {
        this.operator = operator;
        switch (this.addressType) {
            case 0: {
                LocalHostAddress local = (LocalHostAddress)this._orCondition;
                local.setOptOperator(operator);
                break;
            }
            case 2: {
                WinsServerAddress wins = (WinsServerAddress)this._orCondition;
                wins.setOptOperator(operator);
                break;
            }
            case 3: {
                DnsServerAddress dns = (DnsServerAddress)this._orCondition;
                dns.setOptOperator(operator);
                break;
            }
            case 4: {
                DhcpServerAddress dhcp = (DhcpServerAddress)this._orCondition;
                dhcp.setOptOperator(operator);
                break;
            }
            case 1: {
                GatewayAddress gateway = (GatewayAddress)this._orCondition;
                gateway.setOptOperator(operator);
                break;
            }
            case 9: {
                DnsResolve dnsResolve = (DnsResolve)this._orCondition;
                dnsResolve.setOptOperator(operator);
                break;
            }
            case 5: {
                NetworkConnection network = (NetworkConnection)this._orCondition;
                network.setOptOperator(operator);
                break;
            }
            case 6: {
                CmsConnection cms = (CmsConnection)this._orCondition;
                cms.setOptOperator(operator);
                break;
            }
            case 8: {
                TpmDevice tpm = (TpmDevice)this._orCondition;
                tpm.setOptOperator(operator);
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                WirelessSSID wirelessSSID = (WirelessSSID)this._orCondition;
                wirelessSSID.setOptOperator(operator);
                break;
            }
            case 12: {
                NICDescription nicDescription = (NICDescription)this._orCondition;
                nicDescription.setOptOperator(operator);
                break;
            }
            case 14: {
                DomainName domainName = (DomainName)this._orCondition;
                domainName.setOptOperator(operator);
                break;
            }
            case 15: {
                ICMPRequest req = (ICMPRequest)this._orCondition;
                req.setOptOperator(operator);
                break;
            }
            case 16: {
                LocalHostName localHostName = (LocalHostName)this._orCondition;
                localHostName.setOptOperator(operator);
                break;
            }
            case 17: {
                UserName userName = (UserName)this._orCondition;
                userName.setOptOperator(operator);
                break;
            }
            case 18: {
                FileExists fileExists = (FileExists)this._orCondition;
                fileExists.setOptOperator(operator);
                break;
            }
            case 19: {
                OSVersion osVersion = (OSVersion)this._orCondition;
                osVersion.setOptOperator(operator);
                break;
            }
        }
    }

    public Integer getOperator() {
        Integer operator = 0;
        switch (this.addressType) {
            case 0: {
                LocalHostAddress local = (LocalHostAddress)this._orCondition;
                if (local.getOptOperator() == null) break;
                operator = local.getOptOperator();
                break;
            }
            case 2: {
                WinsServerAddress wins = (WinsServerAddress)this._orCondition;
                if (wins.getOptOperator() == null) break;
                operator = wins.getOptOperator();
                break;
            }
            case 3: {
                DnsServerAddress dns = (DnsServerAddress)this._orCondition;
                if (dns.getOptOperator() == null) break;
                operator = dns.getOptOperator();
                break;
            }
            case 4: {
                DhcpServerAddress dhcp = (DhcpServerAddress)this._orCondition;
                if (dhcp.getOptOperator() == null) break;
                operator = dhcp.getOptOperator();
                break;
            }
            case 1: {
                GatewayAddress gateway = (GatewayAddress)this._orCondition;
                if (gateway.getOptOperator() == null) break;
                operator = gateway.getOptOperator();
                break;
            }
            case 9: {
                DnsResolve dnsResolve = (DnsResolve)this._orCondition;
                if (dnsResolve.getOptOperator() == null) break;
                operator = dnsResolve.getOptOperator();
                break;
            }
            case 5: {
                NetworkConnection network = (NetworkConnection)this._orCondition;
                if (network.getOptOperator() == null) break;
                operator = network.getOptOperator();
                break;
            }
            case 6: {
                CmsConnection cms = (CmsConnection)this._orCondition;
                if (cms.getOptOperator() == null) break;
                operator = cms.getOptOperator();
                break;
            }
            case 8: {
                TpmDevice tpm = (TpmDevice)this._orCondition;
                if (tpm.getOptOperator() == null) break;
                operator = tpm.getOptOperator();
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                WirelessSSID wirelessSSID = (WirelessSSID)this._orCondition;
                if (wirelessSSID.getOptOperator() == null) break;
                operator = wirelessSSID.getOptOperator();
                break;
            }
            case 12: {
                NICDescription nicDescription = (NICDescription)this._orCondition;
                if (nicDescription.getOptOperator() == null) break;
                operator = nicDescription.getOptOperator();
                break;
            }
            case 14: {
                DomainName domainName = (DomainName)this._orCondition;
                if (domainName.getOptOperator() == null) break;
                operator = domainName.getOptOperator();
                break;
            }
            case 15: {
                ICMPRequest req = (ICMPRequest)this._orCondition;
                if (req.getOptOperator() == null) break;
                operator = req.getOptOperator();
                break;
            }
            case 16: {
                LocalHostName localHostName = (LocalHostName)this._orCondition;
                if (localHostName.getOptOperator() == null) break;
                operator = localHostName.getOptOperator();
                break;
            }
            case 17: {
                UserName userName = (UserName)this._orCondition;
                if (userName.getOptOperator() == null) break;
                operator = userName.getOptOperator();
                break;
            }
            case 18: {
                FileExists fileExists = (FileExists)this._orCondition;
                if (fileExists.getOptOperator() == null) break;
                operator = fileExists.getOptOperator();
                break;
            }
            case 19: {
                OSVersion osVersion = (OSVersion)this._orCondition;
                if (osVersion.getOptOperator() == null) break;
                operator = osVersion.getOptOperator();
                break;
            }
        }
        return operator;
    }

    public ConfigObject getObject() {
        return this._orCondition;
    }

    public LocationCriteriaCondition[] getLocationCriteriaConditions() {
        LocationCriteriaCondition[] conditions = null;
        switch (this.addressType) {
            case 11: {
                WirelessSSID wirelessSSID = (WirelessSSID)this._orCondition;
                conditions = wirelessSSID.getLocationCriteriaCondition().toArray(new LocationCriteriaCondition[0]);
                break;
            }
            case 12: {
                NICDescription nicDescription = (NICDescription)this._orCondition;
                conditions = nicDescription.getLocationCriteriaCondition().toArray(new LocationCriteriaCondition[0]);
                break;
            }
            case 14: {
                DomainName domainName = (DomainName)this._orCondition;
                conditions = domainName.getLocationCriteriaCondition().toArray(new LocationCriteriaCondition[0]);
                break;
            }
            case 16: {
                LocalHostName localHostName = (LocalHostName)this._orCondition;
                conditions = localHostName.getLocationCriteriaCondition().toArray(new LocationCriteriaCondition[0]);
                break;
            }
            case 17: {
                UserName userName = (UserName)this._orCondition;
                conditions = userName.getLocationCriteriaCondition().toArray(new LocationCriteriaCondition[0]);
                break;
            }
            case 18: {
                FileExists fileExists = (FileExists)this._orCondition;
                conditions = fileExists.getLocationCriteriaCondition().toArray(new LocationCriteriaCondition[0]);
                break;
            }
        }
        return conditions;
    }

    public OS[] getOSs() {
        OS[] conditions = null;
        if (this.addressType == 19) {
            OSVersion osVersion = (OSVersion)this._orCondition;
            conditions = osVersion.getOS().toArray(new OS[0]);
        }
        return conditions;
    }

    public void setLocationCriteriaConditions(LocationCriteriaCondition[] conditions) {
        switch (this.addressType) {
            case 11: {
                WirelessSSID wirelessSSID = (WirelessSSID)this._orCondition;
                wirelessSSID.clear();
                break;
            }
            case 12: {
                NICDescription nicDescription = (NICDescription)this._orCondition;
                nicDescription.clear();
                break;
            }
            case 14: {
                DomainName domainName = (DomainName)this._orCondition;
                domainName.clear();
                break;
            }
            case 16: {
                LocalHostName localHostName = (LocalHostName)this._orCondition;
                localHostName.clear();
                break;
            }
            case 17: {
                UserName userName = (UserName)this._orCondition;
                userName.clear();
                break;
            }
            case 18: {
                FileExists fileExists = (FileExists)this._orCondition;
                fileExists.clear();
                break;
            }
            case 19: {
                OSVersion osVersion = (OSVersion)this._orCondition;
                osVersion.clear();
                break;
            }
        }
        this.addLocationCriteriaConditions(conditions);
    }

    public void setOSs(OS[] conditions) {
        if (this.addressType == 19) {
            OSVersion osVersion = (OSVersion)this._orCondition;
            osVersion.clear();
        }
        this.addOSs(conditions);
    }

    public String getRemoteDeviceCommName() {
        return ((RemoteDeviceCommunication)this._orCondition).getDeviceName();
    }

    public void setRemoteDeviceCommName(String deviceName) {
        ((RemoteDeviceCommunication)this._orCondition).setDeviceName(deviceName);
    }

    public AddressObject[] getAddress() {
        DataobjectManager manager = DataobjectManager.getInstance();
        ArrayList<AddressObject> allAddress = new ArrayList<AddressObject>();
        switch (this.addressType) {
            case 0: {
                LocalHostAddress local = (LocalHostAddress)this._orCondition;
                for (IpAddress ipAddress : local.getIpAddress()) {
                    allAddress.add(new AddressObject(0, (ConfigObject)ipAddress));
                }
                for (Ipv6Address ipv6Address : local.getIpv6Address()) {
                    allAddress.add(new AddressObject(7, (ConfigObject)ipv6Address));
                }
                for (IpRange ipRange : local.getIpRange()) {
                    allAddress.add(new AddressObject(1, (ConfigObject)ipRange));
                }
                for (Ipv6Range ipv6Range : local.getIpv6Range()) {
                    allAddress.add(new AddressObject(8, (ConfigObject)ipv6Range));
                }
                for (SubNet subNet : local.getSubNet()) {
                    allAddress.add(new AddressObject(2, (ConfigObject)subNet));
                }
                for (Ipv6SubNet ipv6SubNet : local.getIpv6SubNet()) {
                    allAddress.add(new AddressObject(9, (ConfigObject)ipv6SubNet));
                }
                for (ObjReference ref : local.getObjReference()) {
                    try {
                        FwNetworkHostGroup hostgroup = manager.getFwNetworkHostGroup(ref.getTargetId());
                        allAddress.add(new AddressObject(5, (ConfigObject)hostgroup));
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                break;
            }
            case 2: {
                WinsServerAddress wins = (WinsServerAddress)this._orCondition;
                for (IpAddress ipAddress : wins.getIpAddress()) {
                    allAddress.add(new AddressObject(0, (ConfigObject)ipAddress));
                }
                for (Ipv6Address ipv6Address : wins.getIpv6Address()) {
                    allAddress.add(new AddressObject(7, (ConfigObject)ipv6Address));
                }
                for (IpRange ipRange : wins.getIpRange()) {
                    allAddress.add(new AddressObject(1, (ConfigObject)ipRange));
                }
                for (Ipv6Range ipv6Range : wins.getIpv6Range()) {
                    allAddress.add(new AddressObject(8, (ConfigObject)ipv6Range));
                }
                for (SubNet subNet : wins.getSubNet()) {
                    allAddress.add(new AddressObject(2, (ConfigObject)subNet));
                }
                for (Ipv6SubNet ipv6SubNet : wins.getIpv6SubNet()) {
                    allAddress.add(new AddressObject(9, (ConfigObject)ipv6SubNet));
                }
                for (ObjReference ref : wins.getObjReference()) {
                    try {
                        FwNetworkHostGroup hostgroup = manager.getFwNetworkHostGroup(ref.getTargetId());
                        allAddress.add(new AddressObject(5, (ConfigObject)hostgroup));
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                break;
            }
            case 3: {
                DnsServerAddress dns = (DnsServerAddress)this._orCondition;
                for (IpAddress ipAddress : dns.getIpAddress()) {
                    allAddress.add(new AddressObject(0, (ConfigObject)ipAddress));
                }
                for (Ipv6Address ipv6Address : dns.getIpv6Address()) {
                    allAddress.add(new AddressObject(7, (ConfigObject)ipv6Address));
                }
                for (IpRange ipRange : dns.getIpRange()) {
                    allAddress.add(new AddressObject(1, (ConfigObject)ipRange));
                }
                for (Ipv6Range ipv6Range : dns.getIpv6Range()) {
                    allAddress.add(new AddressObject(8, (ConfigObject)ipv6Range));
                }
                for (SubNet subNet : dns.getSubNet()) {
                    allAddress.add(new AddressObject(2, (ConfigObject)subNet));
                }
                for (Ipv6SubNet ipv6SubNet : dns.getIpv6SubNet()) {
                    allAddress.add(new AddressObject(9, (ConfigObject)ipv6SubNet));
                }
                for (ObjReference ref : dns.getObjReference()) {
                    try {
                        FwNetworkHostGroup hostgroup = manager.getFwNetworkHostGroup(ref.getTargetId());
                        allAddress.add(new AddressObject(5, (ConfigObject)hostgroup));
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                break;
            }
            case 4: {
                DhcpServerAddress dhcp = (DhcpServerAddress)this._orCondition;
                for (IpAddress ipAddress : dhcp.getIpAddress()) {
                    allAddress.add(new AddressObject(0, (ConfigObject)ipAddress));
                }
                for (Ipv6Address ipv6Address : dhcp.getIpv6Address()) {
                    allAddress.add(new AddressObject(7, (ConfigObject)ipv6Address));
                }
                for (IpRange ipRange : dhcp.getIpRange()) {
                    allAddress.add(new AddressObject(1, (ConfigObject)ipRange));
                }
                for (Ipv6Range ipv6Range : dhcp.getIpv6Range()) {
                    allAddress.add(new AddressObject(8, (ConfigObject)ipv6Range));
                }
                for (SubNet subNet : dhcp.getSubNet()) {
                    allAddress.add(new AddressObject(2, (ConfigObject)subNet));
                }
                for (Ipv6SubNet ipv6SubNet : dhcp.getIpv6SubNet()) {
                    allAddress.add(new AddressObject(9, (ConfigObject)ipv6SubNet));
                }
                for (MacAddress macAddress : dhcp.getMacAddress()) {
                    allAddress.add(new AddressObject(3, (ConfigObject)macAddress));
                }
                for (ObjReference ref : dhcp.getObjReference()) {
                    try {
                        FwNetworkHostGroup hostgroup = manager.getFwNetworkHostGroup(ref.getTargetId());
                        allAddress.add(new AddressObject(5, (ConfigObject)hostgroup));
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                break;
            }
            case 1: {
                GatewayAddress gateway = (GatewayAddress)this._orCondition;
                for (IpAddress ipAddress : gateway.getIpAddress()) {
                    allAddress.add(new AddressObject(0, (ConfigObject)ipAddress));
                }
                for (Ipv6Address ipv6Address : gateway.getIpv6Address()) {
                    allAddress.add(new AddressObject(7, (ConfigObject)ipv6Address));
                }
                for (IpRange ipRange : gateway.getIpRange()) {
                    allAddress.add(new AddressObject(1, (ConfigObject)ipRange));
                }
                for (Ipv6Range ipv6Range : gateway.getIpv6Range()) {
                    allAddress.add(new AddressObject(8, (ConfigObject)ipv6Range));
                }
                for (SubNet subNet : gateway.getSubNet()) {
                    allAddress.add(new AddressObject(2, (ConfigObject)subNet));
                }
                for (Ipv6SubNet ipv6SubNet : gateway.getIpv6SubNet()) {
                    allAddress.add(new AddressObject(9, (ConfigObject)ipv6SubNet));
                }
                for (MacAddress macAddress : gateway.getMacAddress()) {
                    allAddress.add(new AddressObject(3, (ConfigObject)macAddress));
                }
                for (ObjReference ref : gateway.getObjReference()) {
                    try {
                        FwNetworkHostGroup hostgroup = manager.getFwNetworkHostGroup(ref.getTargetId());
                        allAddress.add(new AddressObject(5, (ConfigObject)hostgroup));
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                break;
            }
            case 9: {
                DnsResolve dnsResolve = (DnsResolve)this._orCondition;
                for (DnsResult dnsResult : dnsResolve.getDnsResult()) {
                    String ipv6AddString;
                    String ipAddString = dnsResult.getOptIpAddress();
                    if (ipAddString != null && ipAddString.length() > 0) {
                        IpAddress ipAdd = new IpAddress();
                        ipAdd.setContent(ipAddString);
                        AddressObject addObj = new AddressObject(0, (ConfigObject)ipAdd);
                        addObj.setName(dnsResult.getDnsName());
                        allAddress.add(addObj);
                    }
                    if ((ipv6AddString = dnsResult.getOptIpv6Address()) == null || ipv6AddString.length() <= 0) continue;
                    Ipv6Address ipv6Add = new Ipv6Address();
                    ipv6Add.setContent(ipv6AddString);
                    AddressObject ipv6AddObj = new AddressObject(7, (ConfigObject)ipv6Add);
                    ipv6AddObj.setName(dnsResult.getDnsName());
                    allAddress.add(ipv6AddObj);
                }
                break;
            }
            case 10: {
                break;
            }
            case 15: {
                ICMPRequest req = (ICMPRequest)this._orCondition;
                for (IpAddress ipAddress : req.getIpAddress()) {
                    allAddress.add(new AddressObject(0, (ConfigObject)ipAddress));
                }
                for (Ipv6Address ipv6Address : req.getIpv6Address()) {
                    allAddress.add(new AddressObject(7, (ConfigObject)ipv6Address));
                }
                for (DnsHost dnsHost : req.getDnsHost()) {
                    allAddress.add(new AddressObject(6, (ConfigObject)dnsHost));
                }
                for (ObjReference ref : req.getObjReference()) {
                    try {
                        FwNetworkHostGroup hostgroup = manager.getFwNetworkHostGroup(ref.getTargetId());
                        allAddress.add(new AddressObject(5, (ConfigObject)hostgroup));
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                break;
            }
        }
        return allAddress.toArray(new AddressObject[0]);
    }

    public AlSignatureOrObject getClone() throws ConsoleException {
        ConfigObject newObj = PolicyHandler.getCopyOfObj(this._orCondition);
        return new AlSignatureOrObject(this.addressType, newObj);
    }

    public void setICMPReqMode(Integer mode) {
        ConsoleAssertion.runAssert(this.addressType != 15, "It is not ICMP Ping Address. " + this.addressType);
        ICMPRequest req = (ICMPRequest)this._orCondition;
        req.setOptMode(mode);
    }

    public Integer getICMPReqMode() {
        ConsoleAssertion.runAssert(this.addressType != 15, "It is not ICMP Ping Address. " + this.addressType);
        ICMPRequest req = (ICMPRequest)this._orCondition;
        return req.getOptMode();
    }

    public void setLocalHostMode(Integer mode) {
        ConsoleAssertion.runAssert(this.addressType != 0, "It is not Local Host Address. " + this.addressType);
        LocalHostAddress _localHostAddress = (LocalHostAddress)this._orCondition;
        _localHostAddress.setOptMode(mode);
    }

    public Integer getLocalHostMode() {
        ConsoleAssertion.runAssert(this.addressType != 0, "It is not Local Host Address. " + this.addressType);
        LocalHostAddress _localHostAddress = (LocalHostAddress)this._orCondition;
        return _localHostAddress.getOptMode();
    }

    public void setWinsAddressMode(Integer mode) {
        ConsoleAssertion.runAssert(this.addressType != 2, "It is not WINS Server Address. " + this.addressType);
        WinsServerAddress _localHostAddress = (WinsServerAddress)this._orCondition;
        _localHostAddress.setOptMode(mode);
    }

    public Integer getWinsAddressMode() {
        ConsoleAssertion.runAssert(this.addressType != 2, "It is not WINS Server Address. " + this.addressType);
        WinsServerAddress _localHostAddress = (WinsServerAddress)this._orCondition;
        return _localHostAddress.getOptMode();
    }

    public void setDnsAddressMode(Integer mode) {
        ConsoleAssertion.runAssert(this.addressType != 3, "It is not DNS Server Address. " + this.addressType);
        DnsServerAddress _localHostAddress = (DnsServerAddress)this._orCondition;
        _localHostAddress.setOptMode(mode);
    }

    public Integer getDnsAddressMode() {
        ConsoleAssertion.runAssert(this.addressType != 3, "It is not DNS Server Address. " + this.addressType);
        DnsServerAddress _localHostAddress = (DnsServerAddress)this._orCondition;
        return _localHostAddress.getOptMode();
    }

    public void setNetworkType(String newType) {
        ConsoleAssertion.runAssert(this.addressType != 5, "It is not Network connection type: " + this.addressType);
        NetworkConnection network = (NetworkConnection)this._orCondition;
        Integer vpn = VPNDescTypeMap.get(newType);
        network.setOptNetworkInterfaceType(vpn);
    }

    public Integer getNetworkType() {
        ConsoleAssertion.runAssert(this.addressType != 5, "It is not Network connection type: " + this.addressType);
        NetworkConnection network = (NetworkConnection)this._orCondition;
        return network.getOptNetworkInterfaceType();
    }

    public EthernetExclusionCondition[] getEthernetExclusionConditions() {
        EthernetExclusionCondition[] conditions = null;
        if (this.addressType == 5) {
            NetworkConnection network = (NetworkConnection)this._orCondition;
            conditions = network.getEthernetExclusionCondition().toArray(new EthernetExclusionCondition[0]);
        }
        return conditions;
    }

    public void setEthernetExclusionConditions(EthernetExclusionCondition[] conditions) {
        if (this.addressType == 5) {
            NetworkConnection network = (NetworkConnection)this._orCondition;
            network.clear();
            this.addEthernetExclusionConditions(conditions);
        }
    }

    public void setCmsType(boolean connect) {
        ConsoleAssertion.runAssert(this.addressType != 6, "It is not Cms connection type: " + this.addressType);
        CmsConnection cms = (CmsConnection)this._orCondition;
        cms.setConnectionStatus(connect ? Long.valueOf(1L) : Long.valueOf(0L));
    }

    public boolean getCmsType() {
        ConsoleAssertion.runAssert(this.addressType != 6, "It is not Cms connection type: " + this.addressType);
        CmsConnection cms = (CmsConnection)this._orCondition;
        return cms.getConnectionStatus() == 1L;
    }

    public void setTpmType(Integer newType) {
        ConsoleAssertion.runAssert(this.addressType != 8, "It is not Trusted Plateform Module type: " + this.addressType);
        TpmDevice tpmDevice = (TpmDevice)this._orCondition;
        tpmDevice.setOptType(newType);
    }

    public Integer getTpmType() {
        ConsoleAssertion.runAssert(this.addressType != 8, "It is not Trusted Plateform Module type: " + this.addressType);
        TpmDevice tpmDevice = (TpmDevice)this._orCondition;
        return tpmDevice.getOptType();
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        try {
            WashIDHandler washer = new WashIDHandler();
            HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
            ConfigObject newObj = washer.duplicateObject(this._orCondition, createdObj);
            AlSignatureOrObject orObj = new AlSignatureOrObject(this.addressType, newObj);
            return orObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public void setNewAddresses(List<AddressObject> addresslist) {
        switch (this.addressType) {
            case 0: {
                LocalHostAddress local = (LocalHostAddress)this._orCondition;
                AlSignatureOrObject.removeAllChildrean((ConfigObject)local);
                break;
            }
            case 2: {
                WinsServerAddress wins = (WinsServerAddress)this._orCondition;
                AlSignatureOrObject.removeAllChildrean((ConfigObject)wins);
                break;
            }
            case 3: {
                DnsServerAddress dns = (DnsServerAddress)this._orCondition;
                AlSignatureOrObject.removeAllChildrean((ConfigObject)dns);
                break;
            }
            case 4: {
                DhcpServerAddress dhcp = (DhcpServerAddress)this._orCondition;
                AlSignatureOrObject.removeAllChildrean((ConfigObject)dhcp);
                break;
            }
            case 1: {
                GatewayAddress gateway = (GatewayAddress)this._orCondition;
                AlSignatureOrObject.removeAllChildrean((ConfigObject)gateway);
                break;
            }
            case 8: {
                TpmDevice tpmDevice = (TpmDevice)this._orCondition;
                AlSignatureOrObject.removeAllChildrean((ConfigObject)tpmDevice);
                break;
            }
            case 9: {
                DnsResolve dnsResolve = (DnsResolve)this._orCondition;
                AlSignatureOrObject.removeAllChildrean((ConfigObject)dnsResolve);
                break;
            }
            case 10: {
                break;
            }
            case 15: {
                ICMPRequest req = (ICMPRequest)this._orCondition;
                AlSignatureOrObject.removeAllChildrean((ConfigObject)req);
                break;
            }
        }
        for (AddressObject newAddr : addresslist) {
            this.addAddress(newAddr);
        }
    }

    @Override
    public void setCountNumber(int newCnt) {
        this.nodeNumber = newCnt;
    }

    public Object[] getRegistryData() {
        RegistryData regData;
        RegistryValue regValue;
        ConsoleAssertion.runAssert(this.addressType != 10, "It is not Registry Key type: " + this.addressType);
        Object[] ret = new Object[5];
        AlRegistry registry = (AlRegistry)this._orCondition;
        RegistryKey regKey = registry.getOptRegistryKey();
        if (regKey != null) {
            ret[0] = 0;
            Integer operator = regKey.getOptOperator();
            if (operator == null) {
                operator = regKey.getDefOperator();
            }
            ret[1] = RegistryKey.EXIST.equals(operator) ? Integer.valueOf(0) : Integer.valueOf(1);
            ret[2] = regKey.getKeyName();
        }
        if ((regValue = registry.getOptRegistryValue()) != null) {
            ret[0] = 1;
            Integer operator = regValue.getOptOperator();
            if (operator == null) {
                operator = regValue.getDefOperator();
            }
            ret[1] = RegistryValue.EXIST.equals(operator) ? Integer.valueOf(0) : Integer.valueOf(1);
            ret[2] = regValue.getValueName();
        }
        if ((regData = registry.getOptRegistryData()) != null) {
            ret[0] = 2;
            Integer operator = regData.getOptOperator();
            if (operator == null) {
                operator = regData.getDefOperator();
            }
            ret[1] = RegistryData.EQUAL.equals(operator) ? Integer.valueOf(0) : Integer.valueOf(1);
            ret[2] = regData.getDataName();
            Integer type = regData.getDataType();
            ret[3] = RegistryData.REG_SZ.equals(type) ? Integer.valueOf(0) : (RegistryData.REG_DWORD.equals(type) ? Integer.valueOf(1) : Integer.valueOf(2));
            ret[4] = regData.getDataValue();
        }
        return ret;
    }

    public void setRegistryData(Object[] ret) {
        ConsoleAssertion.runAssert(this.addressType != 10, "It is not Registry Key type: " + this.addressType);
        AlRegistry registry = (AlRegistry)this._orCondition;
        if (ret.length != 5) {
            return;
        }
        Integer type = (Integer)ret[0];
        int i_type = type;
        if (i_type == 0) {
            Integer operator;
            RegistryKey regKey = registry.getOptRegistryKey();
            if (regKey == null) {
                regKey = new RegistryKey();
                registry.setOptRegistryKey(regKey);
                registry.setOptRegistryData(null);
                registry.setOptRegistryValue(null);
            }
            if ((operator = (Integer)ret[1]) == 0) {
                regKey.setOptOperator(RegistryKey.EXIST);
            } else {
                regKey.setOptOperator(RegistryKey.NOT_EXIST);
            }
            String keyName = (String)ret[2];
            regKey.setKeyName(keyName);
        } else if (i_type == 1) {
            Integer operator;
            RegistryValue regValue = registry.getOptRegistryValue();
            if (regValue == null) {
                regValue = new RegistryValue();
                registry.setOptRegistryValue(regValue);
                registry.setOptRegistryKey(null);
                registry.setOptRegistryData(null);
            }
            if ((operator = (Integer)ret[1]) == 0) {
                regValue.setOptOperator(RegistryValue.EXIST);
            } else {
                regValue.setOptOperator(RegistryValue.NOT_EXIST);
            }
            String valueName = (String)ret[2];
            regValue.setValueName(valueName);
        } else if (i_type == 2) {
            Integer operator;
            RegistryData regData = registry.getOptRegistryData();
            if (regData == null) {
                regData = new RegistryData();
                registry.setOptRegistryData(regData);
                registry.setOptRegistryKey(null);
                registry.setOptRegistryValue(null);
            }
            if ((operator = (Integer)ret[1]) == 0) {
                regData.setOptOperator(RegistryData.EQUAL);
            } else {
                regData.setOptOperator(RegistryData.NOT_EQUAL);
            }
            String valueName = (String)ret[2];
            regData.setDataName(valueName);
            Integer valueType = (Integer)ret[3];
            if (valueType == 0) {
                regData.setDataType(RegistryData.REG_SZ);
            } else if (valueType == 1) {
                regData.setDataType(RegistryData.REG_DWORD);
            } else {
                regData.setDataType(RegistryData.REG_BINARY);
            }
            String value = (String)ret[4];
            regData.setDataValue(value);
        }
    }

    static {
        VPNTypeDescMap.put(NetworkConnection.ALL, ALL_DESC);
        VPNTypeDescMap.put(NetworkConnection.PPTP, PPTP_DESC);
        VPNTypeDescMap.put(NetworkConnection.DUN, DUN_DESC);
        VPNTypeDescMap.put(NetworkConnection.VP_CISCO3000, VP_CISCO3000_DESC);
        VPNTypeDescMap.put(NetworkConnection.VP_CHECKPOINT, VP_CHECKPOINT_DESC);
        VPNTypeDescMap.put(NetworkConnection.VP_NETSCREEN, VP_NETSCREEN_DESC);
        VPNTypeDescMap.put(NetworkConnection.VP_NORTEL, VP_NORTEL_DESC);
        VPNTypeDescMap.put(NetworkConnection.VP_ENTERASYS_AURO, VP_ENTERASYS_AURO_DESC);
        VPNTypeDescMap.put(NetworkConnection.VP_SAFENET, VP_SAFENET_DESC);
        VPNTypeDescMap.put(NetworkConnection.VP_AVENTAIL_SSLVPN, VP_AVENTAIL_SSLVPN_DESC);
        VPNTypeDescMap.put(NetworkConnection.VP_ALCATEL, VP_ALCATEL_DESC);
        VPNTypeDescMap.put(NetworkConnection.ETHERNET, ETHERNET_DESC);
        VPNTypeDescMap.put(NetworkConnection.WLAN, WIRELESS_DESC);
        VPNTypeDescMap.put(NetworkConnection.VP_JUNIPER_SSL, VP_JUNIPER_SSLVPN_DESC);
        VPNDescTypeMap.put(ALL_DESC, NetworkConnection.ALL);
        VPNDescTypeMap.put(PPTP_DESC, NetworkConnection.PPTP);
        VPNDescTypeMap.put(DUN_DESC, NetworkConnection.DUN);
        VPNDescTypeMap.put(VP_CISCO3000_DESC, NetworkConnection.VP_CISCO3000);
        VPNDescTypeMap.put(VP_CHECKPOINT_DESC, NetworkConnection.VP_CHECKPOINT);
        VPNDescTypeMap.put(VP_NETSCREEN_DESC, NetworkConnection.VP_NETSCREEN);
        VPNDescTypeMap.put(VP_NORTEL_DESC, NetworkConnection.VP_NORTEL);
        VPNDescTypeMap.put(VP_ENTERASYS_AURO_DESC, NetworkConnection.VP_ENTERASYS_AURO);
        VPNDescTypeMap.put(VP_SAFENET_DESC, NetworkConnection.VP_SAFENET);
        VPNDescTypeMap.put(VP_AVENTAIL_SSLVPN_DESC, NetworkConnection.VP_AVENTAIL_SSLVPN);
        VPNDescTypeMap.put(VP_ALCATEL_DESC, NetworkConnection.VP_ALCATEL);
        VPNDescTypeMap.put(ETHERNET_DESC, NetworkConnection.ETHERNET);
        VPNDescTypeMap.put(WIRELESS_DESC, NetworkConnection.WLAN);
        VPNDescTypeMap.put(VP_JUNIPER_SSLVPN_DESC, NetworkConnection.VP_JUNIPER_SSL);
        TPMTypeDescMap.put(TpmDevice.IBM_TPM_TOKEN, TPM_IBM_TOKEN);
        TPMTypeDescMap.put(TpmDevice.HP_TPM_TOKEN, TPM_HP_TOKEN);
        TPMTypeDescMap.put(null, TPM_ANY_TOKEN);
    }
}

