/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AlHostIntegrity;
import com.sygate.scm.common.configobject.schema.AlRegistry;
import com.sygate.scm.common.configobject.schema.AlSignature;
import com.sygate.scm.common.configobject.schema.CmsConnection;
import com.sygate.scm.common.configobject.schema.DhcpServerAddress;
import com.sygate.scm.common.configobject.schema.DnsResolve;
import com.sygate.scm.common.configobject.schema.DnsServerAddress;
import com.sygate.scm.common.configobject.schema.DomainName;
import com.sygate.scm.common.configobject.schema.FileExists;
import com.sygate.scm.common.configobject.schema.GatewayAddress;
import com.sygate.scm.common.configobject.schema.ICMPRequest;
import com.sygate.scm.common.configobject.schema.LocalHostAddress;
import com.sygate.scm.common.configobject.schema.LocalHostName;
import com.sygate.scm.common.configobject.schema.NICDescription;
import com.sygate.scm.common.configobject.schema.NetworkConnection;
import com.sygate.scm.common.configobject.schema.OSVersion;
import com.sygate.scm.common.configobject.schema.RemoteDeviceCommunication;
import com.sygate.scm.common.configobject.schema.TpmDevice;
import com.sygate.scm.common.configobject.schema.UserName;
import com.sygate.scm.common.configobject.schema.WinsServerAddress;
import com.sygate.scm.common.configobject.schema.WirelessSSID;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AlSignatureOrObject;
import com.sygate.scm.console.logicobject.CountableInt;
import com.sygate.scm.console.logicobject.DeletableObjInt;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.util.ConsoleException;
import java.util.HashMap;
import java.util.Vector;

public class AlSignatureObject
extends AbstractUIObject
implements DeletableObjInt,
CopitableObject,
CountableInt {
    public static final byte HAS_NETWORK = 1;
    public static final byte HAS_CMS = 2;
    public static final byte HAS_TPM = 4;
    private AlSignature _alsignature;
    private boolean isFirst;
    private int cntNumber;

    public AlSignatureObject() {
    }

    public AlSignatureObject(AlSignature alsignature, boolean first) {
        this._alsignature = alsignature;
        this.isFirst = first;
    }

    public AlSignatureObject(boolean first) {
        this._alsignature = new AlSignature();
        this.isFirst = first;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("<html>");
        if (this.cntNumber > 0) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureObject.AND"));
        }
        buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AlSignatureObject.Condition"));
        buffer.append(this.cntNumber + 1);
        buffer.append("</html>");
        return buffer.toString();
    }

    public AlSignatureOrObject[] getICMPReqAddress() {
        Vector icmpRequests = this._alsignature.getICMPRequest();
        AlSignatureOrObject[] reqAddrObjs = new AlSignatureOrObject[icmpRequests.size()];
        for (int i = 0; i < reqAddrObjs.length; ++i) {
            reqAddrObjs[i] = new AlSignatureOrObject(15, (ConfigObject)icmpRequests.get(i));
        }
        return reqAddrObjs;
    }

    public AlSignatureOrObject[] getGatewayAddress() {
        Vector locAddrList = this._alsignature.getGatewayAddress();
        AlSignatureOrObject[] locAddrObjs = new AlSignatureOrObject[locAddrList.size()];
        for (int i = 0; i < locAddrObjs.length; ++i) {
            locAddrObjs[i] = new AlSignatureOrObject(1, (ConfigObject)locAddrList.get(i));
        }
        return locAddrObjs;
    }

    public AlSignatureOrObject[] getLocalHostAddress() {
        Vector locAddrList = this._alsignature.getLocalHostAddress();
        AlSignatureOrObject[] locAddrObjs = new AlSignatureOrObject[locAddrList.size()];
        for (int i = 0; i < locAddrObjs.length; ++i) {
            locAddrObjs[i] = new AlSignatureOrObject(0, (ConfigObject)locAddrList.get(i));
        }
        return locAddrObjs;
    }

    public AlSignatureOrObject[] getWinsAddress() {
        Vector locAddrList = this._alsignature.getWinsServerAddress();
        AlSignatureOrObject[] locAddrObjs = new AlSignatureOrObject[locAddrList.size()];
        for (int i = 0; i < locAddrObjs.length; ++i) {
            locAddrObjs[i] = new AlSignatureOrObject(2, (ConfigObject)locAddrList.get(i));
        }
        return locAddrObjs;
    }

    public AlSignatureOrObject[] getDnsAddress() {
        Vector locAddrList = this._alsignature.getDnsServerAddress();
        AlSignatureOrObject[] locAddrObjs = new AlSignatureOrObject[locAddrList.size()];
        for (int i = 0; i < locAddrObjs.length; ++i) {
            locAddrObjs[i] = new AlSignatureOrObject(3, (ConfigObject)locAddrList.get(i));
        }
        return locAddrObjs;
    }

    public AlSignatureOrObject[] getDhcpAddress() {
        Vector locAddrList = this._alsignature.getDhcpServerAddress();
        AlSignatureOrObject[] locAddrObjs = new AlSignatureOrObject[locAddrList.size()];
        for (int i = 0; i < locAddrObjs.length; ++i) {
            locAddrObjs[i] = new AlSignatureOrObject(4, (ConfigObject)locAddrList.get(i));
        }
        return locAddrObjs;
    }

    public AlSignatureOrObject[] getNetworkCondition() {
        Vector networkList = this._alsignature.getNetworkConnection();
        AlSignatureOrObject[] networkObjs = new AlSignatureOrObject[networkList.size()];
        for (int i = 0; i < networkObjs.length; ++i) {
            networkObjs[i] = new AlSignatureOrObject(5, (ConfigObject)networkList.get(i));
        }
        return networkObjs;
    }

    public AlSignatureOrObject getCmsCondition() {
        CmsConnection connection = this._alsignature.getOptCmsConnection();
        if (connection != null) {
            return new AlSignatureOrObject(6, (ConfigObject)connection);
        }
        return null;
    }

    public AlSignatureOrObject[] getTpmDevice() {
        Vector tpmList = this._alsignature.getTpmDevice();
        AlSignatureOrObject[] tpmObjs = new AlSignatureOrObject[tpmList.size()];
        for (int i = 0; i < tpmObjs.length; ++i) {
            tpmObjs[i] = new AlSignatureOrObject(8, (ConfigObject)tpmList.get(i));
        }
        return tpmObjs;
    }

    public AlSignatureOrObject[] getDnsResolve() {
        Vector dnsResolveList = this._alsignature.getDnsResolve();
        AlSignatureOrObject[] dnsResolveObjs = new AlSignatureOrObject[dnsResolveList.size()];
        for (int i = 0; i < dnsResolveObjs.length; ++i) {
            dnsResolveObjs[i] = new AlSignatureOrObject(9, (ConfigObject)dnsResolveList.get(i));
        }
        return dnsResolveObjs;
    }

    public AlSignatureOrObject[] getAlRegistry() {
        Vector registryList = this._alsignature.getAlRegistry();
        AlSignatureOrObject[] registryObjs = new AlSignatureOrObject[registryList.size()];
        for (int i = 0; i < registryObjs.length; ++i) {
            registryObjs[i] = new AlSignatureOrObject(10, (ConfigObject)registryList.get(i));
        }
        return registryObjs;
    }

    public AlSignatureOrObject[] getWirelessSSID() {
        Vector wirelessSSIDList = this._alsignature.getWirelessSSID();
        AlSignatureOrObject[] wirelessSSIDObjs = new AlSignatureOrObject[wirelessSSIDList.size()];
        for (int i = 0; i < wirelessSSIDObjs.length; ++i) {
            wirelessSSIDObjs[i] = new AlSignatureOrObject(11, (ConfigObject)wirelessSSIDList.get(i));
        }
        return wirelessSSIDObjs;
    }

    public AlSignatureOrObject[] getNICDescription() {
        Vector nicDescriptionList = this._alsignature.getNICDescription();
        AlSignatureOrObject[] nicDescriptionObjs = new AlSignatureOrObject[nicDescriptionList.size()];
        for (int i = 0; i < nicDescriptionObjs.length; ++i) {
            nicDescriptionObjs[i] = new AlSignatureOrObject(12, (ConfigObject)nicDescriptionList.get(i));
        }
        return nicDescriptionObjs;
    }

    public AlSignatureOrObject[] getRemoteDeviceComm() {
        Vector remoteDeviceCommList = this._alsignature.getRemoteDeviceCommunication();
        AlSignatureOrObject[] remoteDeviceCommObjs = new AlSignatureOrObject[remoteDeviceCommList.size()];
        for (int i = 0; i < remoteDeviceCommObjs.length; ++i) {
            remoteDeviceCommObjs[i] = new AlSignatureOrObject(13, (ConfigObject)remoteDeviceCommList.get(i));
        }
        return remoteDeviceCommObjs;
    }

    public AlSignatureOrObject[] getDomainName() {
        Vector domainNameList = this._alsignature.getDomainName();
        AlSignatureOrObject[] domainNameObjs = new AlSignatureOrObject[domainNameList.size()];
        for (int i = 0; i < domainNameObjs.length; ++i) {
            domainNameObjs[i] = new AlSignatureOrObject(14, (ConfigObject)domainNameList.get(i));
        }
        return domainNameObjs;
    }

    public AlSignatureOrObject[] getLocalHostName() {
        Vector localHostNameList = this._alsignature.getLocalHostName();
        AlSignatureOrObject[] localHostNameObjs = new AlSignatureOrObject[localHostNameList.size()];
        for (int i = 0; i < localHostNameObjs.length; ++i) {
            localHostNameObjs[i] = new AlSignatureOrObject(16, (ConfigObject)localHostNameList.get(i));
        }
        return localHostNameObjs;
    }

    public AlSignatureOrObject[] getUserName() {
        Vector userNameList = this._alsignature.getUserName();
        AlSignatureOrObject[] userNameObjs = new AlSignatureOrObject[userNameList.size()];
        for (int i = 0; i < userNameObjs.length; ++i) {
            userNameObjs[i] = new AlSignatureOrObject(17, (ConfigObject)userNameList.get(i));
        }
        return userNameObjs;
    }

    public AlSignatureOrObject[] getFileExists() {
        Vector fileExistsList = this._alsignature.getFileExists();
        AlSignatureOrObject[] fileExistsObjs = new AlSignatureOrObject[fileExistsList.size()];
        for (int i = 0; i < fileExistsObjs.length; ++i) {
            fileExistsObjs[i] = new AlSignatureOrObject(18, (ConfigObject)fileExistsList.get(i));
        }
        return fileExistsObjs;
    }

    public AlSignatureOrObject[] getOSVersion() {
        Vector osVersionList = this._alsignature.getOSVersion();
        AlSignatureOrObject[] osVersionObjs = new AlSignatureOrObject[osVersionList.size()];
        for (int i = 0; i < osVersionObjs.length; ++i) {
            osVersionObjs[i] = new AlSignatureOrObject(19, (ConfigObject)osVersionList.get(i));
        }
        return osVersionObjs;
    }

    public AlSignature getAlSignature() {
        return this._alsignature;
    }

    @Override
    public void delete() {
        this._alsignature.getParent().removeChild((AbstractSchema)this._alsignature);
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public void setToFirst() {
        this.isFirst = true;
    }

    public void addAnCondition(AlSignatureOrObject newObj) {
        switch (newObj.getType()) {
            case 0: {
                this._alsignature.addLocalHostAddress((LocalHostAddress)newObj.getObject());
                break;
            }
            case 2: {
                this._alsignature.addWinsServerAddress((WinsServerAddress)newObj.getObject());
                break;
            }
            case 3: {
                this._alsignature.addDnsServerAddress((DnsServerAddress)newObj.getObject());
                break;
            }
            case 4: {
                this._alsignature.addDhcpServerAddress((DhcpServerAddress)newObj.getObject());
                break;
            }
            case 1: {
                this._alsignature.addGatewayAddress((GatewayAddress)newObj.getObject());
                break;
            }
            case 5: {
                this._alsignature.addNetworkConnection((NetworkConnection)newObj.getObject());
                break;
            }
            case 6: {
                this._alsignature.setOptCmsConnection((CmsConnection)newObj.getObject());
                break;
            }
            case 7: {
                this._alsignature.setOptAlHostIntegrity((AlHostIntegrity)newObj.getObject());
                break;
            }
            case 8: {
                this._alsignature.addTpmDevice((TpmDevice)newObj.getObject());
                break;
            }
            case 9: {
                this._alsignature.addDnsResolve((DnsResolve)newObj.getObject());
                break;
            }
            case 10: {
                this._alsignature.addAlRegistry((AlRegistry)newObj.getObject());
                break;
            }
            case 11: {
                this._alsignature.addWirelessSSID((WirelessSSID)newObj.getObject());
                break;
            }
            case 12: {
                this._alsignature.addNICDescription((NICDescription)newObj.getObject());
                break;
            }
            case 13: {
                this._alsignature.addRemoteDeviceCommunication((RemoteDeviceCommunication)newObj.getObject());
                break;
            }
            case 14: {
                this._alsignature.addDomainName((DomainName)newObj.getObject());
                break;
            }
            case 16: {
                this._alsignature.addLocalHostName((LocalHostName)newObj.getObject());
                break;
            }
            case 17: {
                this._alsignature.addUserName((UserName)newObj.getObject());
                break;
            }
            case 18: {
                this._alsignature.addFileExists((FileExists)newObj.getObject());
                break;
            }
            case 19: {
                this._alsignature.addOSVersion((OSVersion)newObj.getObject());
                break;
            }
            case 15: {
                this._alsignature.addICMPRequest((ICMPRequest)newObj.getObject());
                break;
            }
        }
    }

    public void removeAnCondition(AlSignatureOrObject newObj) {
        switch (newObj.getType()) {
            case 0: {
                this._alsignature.removeLocalHostAddress((LocalHostAddress)newObj.getObject());
                break;
            }
            case 2: {
                this._alsignature.removeWinsServerAddress((WinsServerAddress)newObj.getObject());
                break;
            }
            case 3: {
                this._alsignature.removeDnsServerAddress((DnsServerAddress)newObj.getObject());
                break;
            }
            case 4: {
                this._alsignature.removeDhcpServerAddress((DhcpServerAddress)newObj.getObject());
                break;
            }
            case 1: {
                this._alsignature.removeGatewayAddress((GatewayAddress)newObj.getObject());
                break;
            }
            case 5: {
                this._alsignature.removeNetworkConnection((NetworkConnection)newObj.getObject());
                break;
            }
            case 6: {
                this._alsignature.setOptCmsConnection(null);
                break;
            }
            case 7: {
                this._alsignature.setOptAlHostIntegrity(null);
                break;
            }
            case 8: {
                this._alsignature.removeTpmDevice((TpmDevice)newObj.getObject());
                break;
            }
            case 9: {
                this._alsignature.removeDnsResolve((DnsResolve)newObj.getObject());
                break;
            }
            case 10: {
                this._alsignature.removeAlRegistry((AlRegistry)newObj.getObject());
                break;
            }
            case 11: {
                this._alsignature.removeWirelessSSID((WirelessSSID)newObj.getObject());
                break;
            }
            case 12: {
                this._alsignature.removeNICDescription((NICDescription)newObj.getObject());
                break;
            }
            case 13: {
                this._alsignature.removeRemoteDeviceCommunication((RemoteDeviceCommunication)newObj.getObject());
                break;
            }
            case 14: {
                this._alsignature.removeDomainName((DomainName)newObj.getObject());
                break;
            }
            case 16: {
                this._alsignature.removeLocalHostName((LocalHostName)newObj.getObject());
                break;
            }
            case 17: {
                this._alsignature.removeUserName((UserName)newObj.getObject());
                break;
            }
            case 18: {
                this._alsignature.removeFileExists((FileExists)newObj.getObject());
                break;
            }
            case 19: {
                this._alsignature.removeOSVersion((OSVersion)newObj.getObject());
                break;
            }
            case 15: {
                this._alsignature.removeICMPRequest((ICMPRequest)newObj.getObject());
                break;
            }
        }
    }

    public void replace(AlSignatureOrObject oldObj, AlSignatureOrObject newObj) {
        if (oldObj != newObj) {
            if (oldObj.getType() != newObj.getType()) {
                oldObj.delete();
                this.addAnCondition(newObj);
            } else {
                switch (oldObj.getType()) {
                    case 0: {
                        int index = this._alsignature.getLocalHostAddress().indexOf(oldObj.getObject());
                        this._alsignature.setLocalHostAddress(index, (LocalHostAddress)newObj.getObject());
                        break;
                    }
                    case 2: {
                        int index = this._alsignature.getWinsServerAddress().indexOf(oldObj.getObject());
                        this._alsignature.setWinsServerAddress(index, (WinsServerAddress)newObj.getObject());
                        break;
                    }
                    case 3: {
                        int index = this._alsignature.getDnsServerAddress().indexOf(oldObj.getObject());
                        this._alsignature.setDnsServerAddress(index, (DnsServerAddress)newObj.getObject());
                        break;
                    }
                    case 4: {
                        int index = this._alsignature.getDhcpServerAddress().indexOf(oldObj.getObject());
                        this._alsignature.setDhcpServerAddress(index, (DhcpServerAddress)newObj.getObject());
                        break;
                    }
                    case 1: {
                        int index = this._alsignature.getGatewayAddress().indexOf(oldObj.getObject());
                        this._alsignature.setGatewayAddress(index, (GatewayAddress)newObj.getObject());
                        break;
                    }
                    case 5: {
                        int index = this._alsignature.getNetworkConnection().indexOf(oldObj.getObject());
                        this._alsignature.setNetworkConnection(index, (NetworkConnection)newObj.getObject());
                        break;
                    }
                    case 6: {
                        this._alsignature.setOptCmsConnection((CmsConnection)newObj.getObject());
                        break;
                    }
                    case 7: {
                        this._alsignature.setOptAlHostIntegrity((AlHostIntegrity)newObj.getObject());
                        break;
                    }
                    case 8: {
                        int index = this._alsignature.getTpmDevice().indexOf(oldObj.getObject());
                        this._alsignature.setTpmDevice(index, (TpmDevice)newObj.getObject());
                        break;
                    }
                    case 9: {
                        int index = this._alsignature.getDnsResolve().indexOf(oldObj.getObject());
                        this._alsignature.setDnsResolve(index, (DnsResolve)newObj.getObject());
                        break;
                    }
                    case 10: {
                        int index = this._alsignature.getAlRegistry().indexOf(oldObj.getObject());
                        this._alsignature.setAlRegistry(index, (AlRegistry)newObj.getObject());
                        break;
                    }
                    case 11: {
                        int index = this._alsignature.getWirelessSSID().indexOf(oldObj.getObject());
                        this._alsignature.setWirelessSSID(index, (WirelessSSID)newObj.getObject());
                        break;
                    }
                    case 12: {
                        int index = this._alsignature.getNICDescription().indexOf(oldObj.getObject());
                        this._alsignature.setNICDescription(index, (NICDescription)newObj.getObject());
                        break;
                    }
                    case 13: {
                        int index = this._alsignature.getRemoteDeviceCommunication().indexOf(oldObj.getObject());
                        this._alsignature.setRemoteDeviceCommunication(index, (RemoteDeviceCommunication)newObj.getObject());
                        break;
                    }
                    case 14: {
                        int index = this._alsignature.getDomainName().indexOf(oldObj.getObject());
                        this._alsignature.setDomainName(index, (DomainName)newObj.getObject());
                        break;
                    }
                    case 16: {
                        int index = this._alsignature.getLocalHostName().indexOf(oldObj.getObject());
                        this._alsignature.setLocalHostName(index, (LocalHostName)newObj.getObject());
                        break;
                    }
                    case 17: {
                        int index = this._alsignature.getUserName().indexOf(oldObj.getObject());
                        this._alsignature.setUserName(index, (UserName)newObj.getObject());
                        break;
                    }
                    case 18: {
                        int index = this._alsignature.getFileExists().indexOf(oldObj.getObject());
                        this._alsignature.setFileExists(index, (FileExists)newObj.getObject());
                        break;
                    }
                    case 19: {
                        int index = this._alsignature.getOSVersion().indexOf(oldObj.getObject());
                        this._alsignature.setOSVersion(index, (OSVersion)newObj.getObject());
                        break;
                    }
                    case 15: {
                        int index = this._alsignature.getICMPRequest().indexOf(oldObj.getObject());
                        this._alsignature.setICMPRequest(index, (ICMPRequest)newObj.getObject());
                    }
                }
            }
        }
    }

    public int getSigleConditionStatus() {
        int flag = 0;
        CmsConnection cms = this._alsignature.getOptCmsConnection();
        if (cms != null) {
            flag |= 2;
        }
        return flag;
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        try {
            WashIDHandler washer = new WashIDHandler();
            HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
            AlSignature newAl = (AlSignature)washer.duplicateObject((ConfigObject)this._alsignature, createdObj);
            AlSignatureObject newObj = new AlSignatureObject(newAl, false);
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    @Override
    public void setCountNumber(int newCnt) {
        this.cntNumber = newCnt;
    }
}

