/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.table.SemAgent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.Icon;

public class AgentObject
extends AbstractUIObject
implements TableRow {
    private SemAgent agent;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.monitoring.monitoring");
    private DateFormat utcDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final int TYPE = 0;

    public AgentObject(SemAgent agent) {
        this.agent = agent;
    }

    public boolean isValid() {
        return this.agent != null;
    }

    public SemAgent getSemAgent() {
        return this.agent;
    }

    public String getId() {
        return this.getAgentId();
    }

    public String getComputerId() {
        if (this.agent == null || this.agent.getAgentId() == null) {
            return "";
        }
        return this.agent.getOptComputerId();
    }

    public void setComputerId(String string) {
        if (this.agent != null) {
            this.agent.setOptComputerId(string);
        }
    }

    public String getAgentId() {
        if (this.agent == null || this.agent.getAgentId() == null) {
            return "";
        }
        return this.agent.getAgentId();
    }

    public void setAgentId(String string) {
        if (this.agent != null) {
            this.agent.setAgentId(string);
        }
    }

    public String getAgentType() {
        if (this.agent == null || this.agent.getOptAgentType() == null) {
            return "";
        }
        return this.agent.getOptAgentType();
    }

    public String getAgentTypeDisplayString() {
        String type = this.getAgentType();
        if (type == null || type.length() < 1) {
            return "";
        }
        int t = 0;
        try {
            t = Integer.parseInt(type);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        String str = SoftwarePackageObject.getTypeDisplayString(t);
        if (str == null || str.length() < 1) {
            return type;
        }
        return str;
    }

    public String getSoftwareVersion() {
        if (this.agent == null || this.agent.getOptAgentVersion() == null) {
            return "";
        }
        return this.agent.getOptAgentVersion();
    }

    public String getProfileVersion() {
        if (this.agent == null || this.agent.getOptProfileVersion() == null) {
            return "";
        }
        return this.agent.getOptProfileVersion();
    }

    public String getProfileSerialNo() {
        if (this.agent == null || this.agent.getOptProfileSerialNo() == null) {
            return "";
        }
        return this.agent.getOptProfileSerialNo();
    }

    public String getProfileDisplayString() {
        String sn = this.getProfileSerialNo();
        if (sn == null || sn.length() < 1) {
            sn = "";
        }
        return sn;
    }

    public String getIdsVersion() {
        if (this.agent == null || this.agent.getOptIdsVersion() == null) {
            return "";
        }
        return this.agent.getOptIdsVersion();
    }

    public String getIdsSerialNo() {
        if (this.agent == null || this.agent.getOptIdsSerialNo() == null) {
            return "";
        }
        return this.agent.getOptIdsSerialNo();
    }

    public String getIdsDisplayString() {
        String sn = this.getIdsSerialNo();
        if (sn == null || sn.length() < 1) {
            sn = "";
        }
        return sn;
    }

    public int getHeartbeat() {
        return 0;
    }

    public String getAgentVersion() {
        if (this.agent == null || this.agent.getOptAgentVersion() == null) {
            return "";
        }
        return this.agent.getOptAgentVersion();
    }

    public int getStatus() {
        if (this.agent == null || this.agent.getOptStatus() == null) {
            return 0;
        }
        return this.agent.getOptStatus();
    }

    public boolean isOnline() {
        return this.getStatus() == 1;
    }

    public boolean isOffline() {
        return this.getStatus() == 0;
    }

    public long getLastUpdateTime() {
        if (this.agent == null || this.agent.getOptLastUpdateTime() == null) {
            return -1L;
        }
        return this.agent.getOptLastUpdateTime();
    }

    public String getLastUpdateTimeDisplayString() {
        long time = this.getLastUpdateTime();
        if (time < 1L) {
            return "";
        }
        return Utility.getLongDateTimeString((long)time, null);
    }

    public String getLastServerId() {
        if (this.agent == null || this.agent.getOptLastServerId() == null) {
            return "";
        }
        return this.agent.getOptLastServerId();
    }

    public String getLastSiteId() {
        if (this.agent == null || this.agent.getOptLastSiteId() == null) {
            return "";
        }
        return this.agent.getOptLastSiteId();
    }

    public String getPepStatus() {
        int techStatus = 127;
        if (this.agent != null && this.agent.getOptPepStatus() != null) {
            techStatus = this.agent.getOptPepStatus();
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "TECH_STATUS_" + techStatus);
    }

    public String getLBStatus() {
        int lbStatus = 127;
        if (this.agent != null && this.agent.getOptLBStatus() != null) {
            lbStatus = this.agent.getOptLBStatus();
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "LB_STATUS_" + lbStatus);
    }

    public String getHidStatus() {
        int hidStatus = 127;
        if (this.agent != null && this.agent.getOptHidStatus() != null) {
            hidStatus = this.agent.getOptHidStatus();
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "TECH_STATUS_" + hidStatus);
    }

    public String getWtrStatus() {
        int status = 127;
        if (this.agent != null && this.agent.getOptNtrStatus() != null) {
            status = this.agent.getOptNtrStatus();
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "TECH_STATUS_" + status);
    }

    public String getWtrMessage() {
        String status = "";
        if (this.agent != null && this.agent.getOptNtrMessage() != null) {
            status = this.agent.getOptNtrMessage();
        }
        return status;
    }

    public String getTdadStatus() {
        int status = 127;
        if (this.agent != null && this.agent.getOptTdadStatus() != null) {
            status = this.agent.getOptTdadStatus();
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "TECH_STATUS_" + status);
    }

    public String getUrlOnOffStatus() {
        int urlOnOffStatus = 127;
        if (this.agent != null && this.agent.getOptUrlOnOff() != null) {
            urlOnOffStatus = this.agent.getOptUrlOnOff();
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "TECH_STATUS_" + urlOnOffStatus);
    }

    public String getCidsBrowserIEOnOffStatus() {
        int cidsBrowserIEOnOffStatus = 127;
        if (this.agent != null && this.agent.getOptCidsBrowserIEOnOff() != null) {
            cidsBrowserIEOnOffStatus = this.agent.getOptCidsBrowserIEOnOff();
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "TECH_STATUS_" + cidsBrowserIEOnOffStatus);
    }

    public String getCidsBrowserFFOnOffStatus() {
        int cidsBrowserFFOnOffStatus = 127;
        if (this.agent != null && this.agent.getOptCidsBrowserFFOnOff() != null) {
            cidsBrowserFFOnOffStatus = this.agent.getOptCidsBrowserFFOnOff();
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "TECH_STATUS_" + cidsBrowserFFOnOffStatus);
    }

    public String getCidsBrowserChromeOnOffStatus() {
        int cidsBrowserChromeOnOffStatus = 127;
        if (this.agent != null && this.agent.getOptCidsBrowserChromeOnOff() != null) {
            cidsBrowserChromeOnOffStatus = this.agent.getOptCidsBrowserChromeOnOff();
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "TECH_STATUS_" + cidsBrowserChromeOnOffStatus);
    }

    public boolean isIpsServerSigOn() {
        int status = 127;
        if (this.agent != null && this.agent.getOptIpsServerSig() != null) {
            status = this.agent.getOptIpsServerSig();
        }
        return status == 1;
    }

    public String getIpsOobStatus() {
        int status = 127;
        if (this.agent != null && this.agent.getOptIpsOob() != null) {
            status = this.agent.getOptIpsOob();
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "TECH_STATUS_" + status);
    }

    public String getFreeMemoryDisplayString() {
        if (this.agent == null || this.agent.getOptFreeMemory() == null) {
            return "";
        }
        long size = this.agent.getOptFreeMemory();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        String str = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.DecimalMBFollowedByBytes"), nf.format((double)size / 1048576.0), nf.format(size));
        return str;
    }

    public String getFreeHardDriveDisplayString() {
        if (this.agent == null || this.agent.getOptFreeHardDrive() == null) {
            return "";
        }
        long size = this.agent.getOptFreeHardDrive();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        String str = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.DecimalMBFollowedByBytes"), nf.format((double)size / 1048576.0), nf.format(size));
        return str;
    }

    public int getTimeZoneOffset() {
        return this.agent.getOptTimezone();
    }

    public String getUserInfoFullName() {
        if (this.agent == null || this.agent.getOptFullName() == null) {
            return "";
        }
        return this.agent.getOptFullName();
    }

    public String getUserInfoEmail() {
        if (this.agent == null || this.agent.getOptEmail() == null) {
            return "";
        }
        return this.agent.getOptEmail();
    }

    public String getUserInfoJobTitle() {
        if (this.agent == null || this.agent.getOptJobTitle() == null) {
            return "";
        }
        return this.agent.getOptJobTitle();
    }

    public String getUserInfoDepartment() {
        if (this.agent == null || this.agent.getOptDepartment() == null) {
            return "";
        }
        return this.agent.getOptDepartment();
    }

    public String getUserInfoEmployeeNumber() {
        if (this.agent == null || this.agent.getOptEmployeeNumber() == null) {
            return "";
        }
        return this.agent.getOptEmployeeNumber();
    }

    public String getUserInfoEmploymentStatus() {
        if (this.agent == null || this.agent.getOptEmploymentStatus() == null) {
            return "";
        }
        return this.agent.getOptEmploymentStatus();
    }

    public String getUserInfoOfficePhone() {
        if (this.agent == null || this.agent.getOptOfficePhone() == null) {
            return "";
        }
        return this.agent.getOptOfficePhone();
    }

    public String getUserInfoMobilePhone() {
        if (this.agent == null || this.agent.getOptMobilePhone() == null) {
            return "";
        }
        return this.agent.getOptMobilePhone();
    }

    public String getUserInfoHomePhone() {
        if (this.agent == null || this.agent.getOptHomePhone() == null) {
            return "";
        }
        return this.agent.getOptHomePhone();
    }

    public Integer getAgentVersionMajor() {
        if (this.agent == null) {
            return 0;
        }
        return this.agent.getOptAgentVersionMajor();
    }

    public Integer getAgentVersionMinor() {
        if (this.agent == null) {
            return 0;
        }
        return this.agent.getOptAgentVersionMinor();
    }

    public boolean isPostAmberClient() {
        int major = this.getAgentVersionMajor();
        int minor = this.getAgentVersionMinor();
        if (major > 12) {
            return true;
        }
        return major == 12 && minor >= 1;
    }

    public Icon getOnlineIcon() {
        return ConsoleMain.computerOnIcon;
    }

    public Icon getOfflineIcon() {
        return ConsoleMain.computerIcon;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return new JLabelData(this.getAgentTypeDisplayString(), this.isOnline() ? this.getOnlineIcon() : this.getOfflineIcon());
            }
        }
        return null;
    }

    public Class<JLabelData> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return JLabelData.class;
            }
        }
        return null;
    }

    public String getHIStatusString() {
        String hiStatusStr = "";
        if (this.agent == null || this.agent.getOptHiStatus() == null) {
            return hiStatusStr;
        }
        int hiStatus = this.agent.getOptHiStatus();
        switch (hiStatus) {
            case 0: {
                hiStatusStr = MSG_RES.getString("TableCriteriaList.tcFail");
                break;
            }
            case 1: {
                hiStatusStr = MSG_RES.getString("TableCriteriaList.tcSuccess");
                break;
            }
            case 2: {
                hiStatusStr = MSG_RES.getString("TableCriteriaList.tcPending");
                break;
            }
            case 3: {
                hiStatusStr = MSG_RES.getString("TableCriteriaList.tcDisabled");
                break;
            }
            case 4: {
                hiStatusStr = MSG_RES.getString("TableCriteriaList.tcIgnore");
                break;
            }
            default: {
                hiStatusStr = "";
            }
        }
        return hiStatusStr;
    }

    public String getHIReasonCodeDescription() {
        String hiReasonCodeDesc = "";
        if (this.agent == null || this.agent.getOptHiReasoncode() == null) {
            return hiReasonCodeDesc;
        }
        int hiReasonCode = this.agent.getOptHiReasoncode();
        switch (hiReasonCode) {
            case 0: {
                hiReasonCodeDesc = MSG_RES.getString("TableCriteriaList.tcPass");
                break;
            }
            case 101: {
                hiReasonCodeDesc = MSG_RES.getString("TableCriteriaList.tcAVOutOfDate");
                break;
            }
            case 102: {
                hiReasonCodeDesc = MSG_RES.getString("TableCriteriaList.tcAVNotRunning");
                break;
            }
            case 103: {
                hiReasonCodeDesc = MSG_RES.getString("TableCriteriaList.tcScriptFailed");
                break;
            }
            case 104: {
                hiReasonCodeDesc = MSG_RES.getString("TableCriteriaList.tcCheckIncomplete");
                break;
            }
            case 105: {
                hiReasonCodeDesc = MSG_RES.getString("TableCriteriaList.tcCheckDisabled");
                break;
            }
            case 106: {
                hiReasonCodeDesc = MSG_RES.getString("TableCriteriaList.tcContentNotAvailable");
                break;
            }
            case 107: {
                hiReasonCodeDesc = MSG_RES.getString("TableCriteriaList.tcContentTampered");
                break;
            }
            case 108: {
                hiReasonCodeDesc = MSG_RES.getString("TableCriteriaList.tcCheckFailed");
                break;
            }
            case 109: {
                hiReasonCodeDesc = MSG_RES.getString("TableCriteriaList.tcQuarantinedByAdministrator");
                break;
            }
            case 127: {
                hiReasonCodeDesc = MSG_RES.getString("TableCriteriaList.tcLocationChanged");
                break;
            }
            default: {
                hiReasonCodeDesc = MSG_RES.getString("TableCriteriaList.tcUnknownReason");
            }
        }
        return hiReasonCodeDesc;
    }

    public String getAcStatus() {
        int status = 127;
        if (this.agent != null) {
            status = this.agent.getOptAcOnOff();
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "TECH_STATUS_" + status);
    }

    public String getDcStatus() {
        int status = 127;
        if (this.agent != null) {
            status = this.agent.getOptDcOnOff();
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "TECH_STATUS_" + status);
    }

    public long getLastScanTime() {
        if (this.agent == null || this.agent.getOptLastScanTime() == null) {
            return -1L;
        }
        return this.agent.getOptLastScanTime();
    }

    public String getLastScanTimeDisplayString() {
        long time = this.getLastScanTime();
        if (time < 1L) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ClientTechnologyObject.notScanned");
        }
        return Utility.getLongDateTimeString((long)time, null);
    }

    public String getLastScanCompleted() {
        if (this.agent == null || this.agent.getOptLastScanCompletedTime() == null) {
            return null;
        }
        return this.agent.getOptLastScanCompletedTime();
    }

    public String getLastScanCompletedTimeDisplayString() {
        long lastScanStartedTime = this.getLastScanTime();
        if (lastScanStartedTime < 1L) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ClientTechnologyObject.notScanned");
        }
        String lastScanCompletedTime = this.getLastScanCompleted();
        if (lastScanCompletedTime == null || lastScanCompletedTime.startsWith("1970") || lastScanCompletedTime.startsWith("1969")) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AgentObject.inProgress");
        }
        this.utcDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = null;
        try {
            date = this.utcDateFormat.parse(lastScanCompletedTime);
        }
        catch (ParseException e) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AgentObject.notAbleToCompute");
        }
        long lastScanCompletedTimeLongValue = date.getTime();
        return Utility.getLongDateTimeString((long)lastScanCompletedTimeLongValue, null);
    }
}

