/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.schema.AdministratorState;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LoginConfigObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.PasswordExpirationCheckUtil;
import com.sygate.scm.util.Utility;

public class AdminStateObject {
    private static final LicenseObject LIC_OBJ = LicenseObject.getInstance();
    private AdministratorState adminState = null;
    private LoginConfigObject loginConfigObject = null;
    private SemAdministrator admin = null;

    public AdminStateObject(AdministratorState adminState, SemAdministrator admin) {
        this.adminState = adminState;
        this.admin = admin;
    }

    public AdminStateObject() {
    }

    public static int getDefaultPasswordAgeDays() {
        return PasswordExpirationCheckUtil.getDefaultPasswordAgeDays((boolean)LIC_OBJ.isSEPSBProduct());
    }

    public static AdminStateObject retrieveAdminStateObject(SemAdministrator admin) throws ConsoleException {
        AdminStateObject state = new AdminStateObject(AdminStateObject.retrieveAdministratorState(admin.getId()), admin);
        return state;
    }

    public static AdministratorState retrieveAdministratorState(String id) throws ConsoleException {
        return DataobjectManager.getInstance().getAdministratorState(id);
    }

    public static AdministratorState createAdminState(SemAdministrator admin) {
        if (admin == null) {
            return null;
        }
        AdministratorState state = new AdministratorState();
        GUIDGenerator guidGenerator = new GUIDGenerator();
        state.setId(guidGenerator.getGUIDString());
        state.setOwnerId(admin.getId());
        state.setOptFailedLoginAttemptNumber(Integer.valueOf(0));
        state.setOptLastLoginTime(Long.valueOf(0L));
        state.setOptLastLogoffTime(Long.valueOf(0L));
        state.setOptLockStatus(AdministratorState.UNLOCKED);
        state.setOptLockTime(Long.valueOf(0L));
        state.setOptOnlineStatus(AdministratorState.OFFLINE);
        state.setOptLastPasswordChangeTime(Long.valueOf(TimeUtil.getServerTime()));
        return state;
    }

    public AdministratorState getAdministratorState() {
        return this.adminState;
    }

    public boolean isValid() {
        return this.adminState != null;
    }

    public Integer getNotifyLatestSepNews() {
        if (this.adminState == null || this.adminState.getOptNotifyLatestSepNews() == null) {
            return AdministratorState.NOT_READ;
        }
        return this.adminState.getOptNotifyLatestSepNews();
    }

    public void setNotifyLatestSepNews(Integer status) {
        if (status == null || this.adminState == null) {
            return;
        }
        this.adminState.setOptNotifyLatestSepNews(status);
    }

    public int getRandomPasswordStatus() {
        if (this.adminState == null || this.adminState.getOptRandomPasswordStatus() == null) {
            return AdministratorState.INACTIVE;
        }
        return this.adminState.getOptRandomPasswordStatus();
    }

    public void setRandomPasswordStatus(Integer status) {
        if (status == null || this.adminState == null) {
            return;
        }
        this.adminState.setOptRandomPasswordStatus(status);
    }

    public int getPasswordStatus() {
        if (this.adminState == null || this.adminState.getOptPasswordStatus() == null) {
            return AdministratorState.ACTIVE;
        }
        return this.adminState.getOptPasswordStatus();
    }

    public void setPasswordStatus(Integer status) {
        if (status == null || this.adminState == null) {
            return;
        }
        this.adminState.setOptPasswordStatus(status);
    }

    public int getOnlineStatus() {
        if (this.adminState == null || this.adminState.getOptOnlineStatus() == null) {
            return AdministratorState.OFFLINE;
        }
        return this.adminState.getOptOnlineStatus();
    }

    public boolean isOnline() {
        return this.getOnlineStatus() == AdministratorState.ONLINE.intValue();
    }

    public boolean isOffline() {
        return this.getOnlineStatus() == AdministratorState.OFFLINE.intValue();
    }

    public void setOffline() {
        if (this.adminState == null || this.adminState.getOptOnlineStatus() == null) {
            return;
        }
        this.adminState.setOptLastLogoffTime(Long.valueOf(TimeUtil.getServerTime()));
        this.adminState.setOptOnlineStatus(AdministratorState.OFFLINE);
    }

    public String getOnlineStatusDisplayString() {
        if (this.adminState == null) {
            return "";
        }
        return this.isOnline() ? MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminStateObject.statusOnline") : MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminStateObject.statusOffline");
    }

    public boolean setLocked(boolean locked) {
        if (this.adminState == null) {
            return false;
        }
        this.adminState.setOptLockStatus(locked ? AdministratorState.LOCKED : AdministratorState.UNLOCKED);
        return true;
    }

    public int getLockStatus() {
        if (this.adminState == null || this.adminState.getOptLockStatus() == null) {
            return AdministratorState.UNLOCKED;
        }
        int status = this.adminState.getOptLockStatus();
        if (this.loginConfigObject != null && status == AdministratorState.LOCKED && this.getFailedLoginAttemptNumber() > 0) {
            long lockTime = this.getLockTime();
            long unlockTime = lockTime + (long)this.loginConfigObject.getLockTime() * 1000L;
            if (lockTime > 0L && unlockTime <= TimeUtil.getServerTime()) {
                this.resetLockTime(true);
                this.setLocked(false);
                status = this.adminState.getOptLockStatus();
                try {
                    DataobjectManager.getInstance().updateAdministratorState(this.adminState, 4080);
                }
                catch (ConsoleException ex) {
                    System.out.println("getLockStatus()>> Update Admin State: Exception... state id=" + this.adminState.getId() + ", owner id=" + this.adminState.getOwnerId());
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
        }
        return status;
    }

    public boolean isLocked() {
        return this.getLockStatus() == AdministratorState.LOCKED.intValue();
    }

    public boolean isUnlocked() {
        return this.getLockStatus() == AdministratorState.UNLOCKED.intValue();
    }

    public String getLockStatusDisplayString() {
        if (this.adminState == null) {
            return "";
        }
        return this.isLocked() ? MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminStateObject.statusLocked") : MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminStateObject.statusNotLocked");
    }

    public long getLockTime() {
        if (this.adminState == null || this.adminState.getOptLockTime() == null) {
            return -1L;
        }
        return this.adminState.getOptLockTime();
    }

    public String getLockTimeDisplayString() {
        if (this.adminState == null) {
            return "";
        }
        long time = this.getLockTime();
        if (time < 1L) {
            return "";
        }
        return Utility.getLongDateTimeString((long)time, null);
    }

    public boolean setLockTime(long time) {
        if (this.adminState == null) {
            return false;
        }
        this.adminState.setOptLockTime(Long.valueOf(time));
        return true;
    }

    public boolean setLockTime() {
        return this.setLockTime(TimeUtil.getServerTime());
    }

    public String getId() {
        return this.adminState != null ? this.adminState.getId() : "";
    }

    public String getOwnerId() {
        return this.adminState != null ? this.adminState.getOwnerId() : "";
    }

    public String getLastLoginIpAddress() {
        if (this.adminState == null || this.adminState.getOptLastLoginIpAddress() == null) {
            return "";
        }
        return this.adminState.getOptLastLoginIpAddress();
    }

    public long getLastLoginTime() {
        if (this.adminState == null || this.adminState.getOptLastLoginTime() == null) {
            return -1L;
        }
        return this.adminState.getOptLastLoginTime();
    }

    public long getLastCheckpointTime() {
        if (this.adminState == null || this.adminState.getOptLastCheckpointTime() == null) {
            return -1L;
        }
        return this.adminState.getOptLastCheckpointTime();
    }

    public long getLastLogoffTime() {
        if (this.adminState == null || this.adminState.getOptLastLogoffTime() == null) {
            return -1L;
        }
        return this.adminState.getOptLastLogoffTime();
    }

    public String getLastLoginTimeDisplayString() {
        if (this.adminState == null) {
            return "";
        }
        long time = this.getLastLoginTime();
        if (time < 1L) {
            return "";
        }
        return Utility.getLongDateTimeString((long)time, null);
    }

    public String getLastCheckpointTimeDisplayString() {
        if (this.adminState == null) {
            return "";
        }
        long time = this.getLastCheckpointTime();
        if (time < 1L) {
            return "";
        }
        return Utility.getLongDateTimeString((long)time, null);
    }

    public String getLastLogoffTimeDisplayString() {
        if (this.adminState == null) {
            return "";
        }
        long time = this.getLastLogoffTime();
        if (time < 1L) {
            return "";
        }
        return Utility.getLongDateTimeString((long)time, null);
    }

    public int getFailedLoginAttemptNumber() {
        if (this.adminState == null || this.adminState.getOptFailedLoginAttemptNumber() == null) {
            return -1;
        }
        return this.adminState.getOptFailedLoginAttemptNumber();
    }

    public String getFailedLoginAttemptNumberDisplayString() {
        if (this.adminState == null || this.adminState.getOptFailedLoginAttemptNumber() == null) {
            return "0";
        }
        return this.adminState.getOptFailedLoginAttemptNumber().toString();
    }

    public boolean resetLockTime(boolean delete_lock_time) {
        if (this.adminState == null) {
            return false;
        }
        if (delete_lock_time) {
            this.adminState.setOptLockTime(Long.valueOf(0L));
        }
        return true;
    }

    public boolean setFailedLoginAttemptNumber(int count) {
        if (this.adminState == null) {
            return false;
        }
        this.adminState.setOptFailedLoginAttemptNumber(Integer.valueOf(count));
        return true;
    }

    public boolean hasLastPasswordChangeTime() {
        return this.getLastPasswordChangeTime() > 0L;
    }

    public long getLastPasswordChangeTime() {
        if (this.adminState == null || this.adminState.getOptLastPasswordChangeTime() == null) {
            return 0L;
        }
        return this.adminState.getOptLastPasswordChangeTime();
    }

    public String getLastPasswordChangeTimeDisplayString() {
        if (this.adminState == null) {
            return "";
        }
        long time = this.getLastPasswordChangeTime();
        if (time < 1L) {
            return "";
        }
        return Utility.getLongDateTimeString((long)time, null);
    }

    public boolean setLastPasswordChangeTime(long time) {
        if (this.adminState == null) {
            return false;
        }
        this.adminState.setOptLastPasswordChangeTime(Long.valueOf(time));
        return true;
    }

    public boolean setLastPasswordChangeTime() {
        return this.setLastPasswordChangeTime(TimeUtil.getServerTime());
    }

    public boolean isPasswordExpired() {
        return PasswordExpirationCheckUtil.isPasswordExpired((SemAdministrator)this.admin, (AdministratorState)this.adminState, (boolean)LIC_OBJ.isSEPSBProduct());
    }

    public boolean isPasswordNeverExpires() {
        return PasswordExpirationCheckUtil.isPasswordNeverExpires((SemAdministrator)this.admin);
    }

    public String getPasswordExpirationDisplayString() {
        return this.isPasswordExpired() ? "True" : "False";
    }

    public long getPasswordElapsedTime() {
        return PasswordExpirationCheckUtil.getPasswordElapsedTime((AdministratorState)this.adminState);
    }

    public String getPasswordElapsedTimeDisplayString() {
        long elapsedTime = this.getPasswordElapsedTime();
        if (elapsedTime < 0L) {
            return "";
        }
        return Utility.getTimeDurationString((long)elapsedTime);
    }

    public long getPasswordDuration() {
        return PasswordExpirationCheckUtil.getPasswordDuration((SemAdministrator)this.admin, (AdministratorState)this.adminState, (boolean)LIC_OBJ.isSEPSBProduct());
    }

    public String getPasswordDurationDisplayString() {
        long elapsedTime = this.getPasswordDuration();
        if (elapsedTime < 0L) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminStateObject.statusExpired");
        }
        return Utility.getTimeDurationString((long)elapsedTime);
    }

    public void setLoginConfig(LoginConfigObject loginConfigObject) {
        this.loginConfigObject = loginConfigObject;
    }

    public void print() {
        AdminStateObject.print(this);
    }

    public static void print(AdminStateObject state) {
        if (state == null) {
            System.out.println("==== AdminStateObject is null!");
            return;
        }
        System.out.println("================================================");
        System.out.println("==== Admin State Properties: Begin");
        System.out.println("valid=" + state.isValid());
        System.out.println("id=" + state.getId());
        System.out.println("owner id=" + state.getOwnerId());
        System.out.println("online status=" + state.getOnlineStatus());
        System.out.println("lock status=" + state.getLockStatus());
        System.out.println("lock time=" + state.getLockTime() + " (" + state.getLockTimeDisplayString() + ")");
        System.out.println("last login ip=" + state.getLastLoginIpAddress());
        System.out.println("last login time=" + state.getLastLoginTime() + " (" + state.getLastLoginTimeDisplayString() + ")");
        System.out.println("last checkpoint time=" + state.getLastCheckpointTime() + " (" + state.getLastCheckpointTimeDisplayString() + ")");
        System.out.println("last logoff time=" + state.getLastLogoffTime() + " (" + state.getLastLogoffTimeDisplayString() + ")");
        System.out.println("failed login attempt number=" + state.getFailedLoginAttemptNumber());
        System.out.println("last password change time=" + state.getLastPasswordChangeTime() + " (" + state.getLastPasswordChangeTimeDisplayString() + ")");
        System.out.println("password elapsed time=" + state.getPasswordElapsedTime() + " (" + state.getPasswordElapsedTimeDisplayString() + ")");
        System.out.println("password duration=" + state.getPasswordDuration() + " (" + state.getPasswordDurationDisplayString() + ")");
        System.out.println("password expired=" + state.isPasswordExpired());
        System.out.println("==== Admin State Properties: End");
        System.out.println("================================================");
    }
}

