/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.acl.AdminPrivilege;
import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.rpc.SemLoginInfo;
import com.sygate.scm.common.configobject.schema.PrivilegeValue;
import com.sygate.scm.common.configobject.schema.SemAdminPrivilege;
import com.sygate.scm.common.configobject.schema.ServerPrivilege;
import com.sygate.scm.common.configobject.schema.ServerPrivilegeSet;
import com.sygate.scm.common.configobject.schema.SitePrivilege;
import com.sygate.scm.common.configobject.schema.SitePrivilegeSet;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.admin.dlg.PolicyTypeRightsPanel;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.IntegerRange;
import com.sygate.scm.util.IntegerSet;
import java.util.ArrayList;

public class AdminPrivilegeObject {
    private AdminPrivilege adminPrivilege;

    private AdminPrivilegeObject(SemAdminPrivilege privilege) {
        this.adminPrivilege = AdminPrivilege.newInstance((SemAdminPrivilege)privilege);
    }

    private AdminPrivilegeObject(AdminPrivilege adminPrivilege) {
        this.adminPrivilege = adminPrivilege;
    }

    public static AdminPrivilegeObject newInstance(SemAdminPrivilege privilege) {
        return new AdminPrivilegeObject(privilege);
    }

    public static AdminPrivilegeObject newInstanceForDomainAdmin() {
        return new AdminPrivilegeObject(AdminPrivilege.newDomainAdminPrivilege());
    }

    public static AdminPrivilegeObject newInstanceForLimitedAdmin() {
        return new AdminPrivilegeObject(AdminPrivilege.newLimitedAdminPrivilege());
    }

    public static AdminPrivilegeObject getCurrentAdminPrivilegeObject() {
        return AdminObject.retrieveCurrentAdminObject().getAdminPrivilege();
    }

    public static SemAdminPrivilege createDomainAdminPrivilege() {
        return AdminPrivilege.createDomainAdminPrivilege();
    }

    public void grantTypeOfLimitedAdminPrivilege() {
        AdminPrivilege.grantTypeOfLimitedAdminPrivilege((SemAdminPrivilege)this.getSemAdminPrivilege());
    }

    public static SemAdminPrivilege createLimitedAdminPrivilege() {
        return AdminPrivilege.createLimitedAdminPrivilege();
    }

    public static boolean isCurrentAdminHasPolicyTypePrivilege(String policyType) {
        AdminObject admin = AdminObject.retrieveCurrentAdminObject();
        if (admin == null || admin.isSysAdmin() || admin.isDomainSysAdmin()) {
            return true;
        }
        if (AdminPrivilegeObject.isCurrentAdminHasPolicyPrivilege()) {
            return AdminPrivilegeObject.isHasPolicyTypePrivilege(admin.getAdminPrivilege(), policyType);
        }
        return false;
    }

    public static boolean isCurrentAdminHasAllPoliciesTypesPrivilege() {
        String[] policiesTypes = ConstantValue.getAllPoliciesTypesWithoutSnac();
        int size = policiesTypes.length;
        for (int i = 0; i < size; ++i) {
            if (AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege(policiesTypes[i])) continue;
            return false;
        }
        return LicenseObject.getInstance().isSAVOnlyProduct() || LicenseObject.getInstance().isSBProduct() || AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x28");
    }

    public static boolean isHasPolicyTypePrivilege(AdminPrivilegeObject adminPrivilegeObject, String policyType) {
        if (adminPrivilegeObject == null || policyType == null || policyType.trim().length() == 0) {
            return false;
        }
        if (policyType.equals("0x22") || policyType.equals("0x23") || policyType.equals("0x24") || policyType.equals("0x25") || policyType.equals("0x26") || policyType.equals("0x27") || policyType.equals("0x28") || policyType.equals("0x30") || policyType.equals("0x29") || policyType.equals("0x31") || policyType.equals("0x32")) {
            IntegerSet is = adminPrivilegeObject.getDisallowedPaneIntegerSet();
            return !is.contains(policyType, 16);
        }
        return false;
    }

    public static boolean isCurrentAdminHasReportPrivilege() {
        AuthorizationManager manager = AuthorizationManager.getInstance();
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        return manager.checkPermission(context, (Permission)AuthorizationManager.TopLevelPermission.VIEW_REPORTS);
    }

    public static boolean isCurrentAdminHasPolicyPrivilege() {
        AuthorizationManager manager = AuthorizationManager.getInstance();
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        return manager.checkPermission(context, (Permission)AuthorizationManager.TopLevelPermission.MANAGE_POLICIES);
    }

    public static boolean isCurrentAdminHasComputerUserPrivilege() {
        AuthorizationManager manager = AuthorizationManager.getInstance();
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        return manager.checkPermission(context, (Permission)AuthorizationManager.TopLevelPermission.MANAGE_GROUPS);
    }

    public static boolean isCurrentAdminHasClientPanelPrivilege() {
        PrivilegeContext context;
        AuthorizationManager manager = AuthorizationManager.getInstance();
        return !manager.checkPermission(context = DataobjectManager.getInstance().getCurrentPrivilegeContext(), (Permission)AuthorizationManager.SpecialPermission.ALL_GROUP_NO_ACCESS);
    }

    public static boolean hasCommandPrivilege(String commandType) {
        AdminObject adminObject = AdminObject.retrieveCurrentAdminObject();
        return AdminPrivilegeObject.hasCommandPrivilege(adminObject, commandType);
    }

    protected static boolean hasCommandPrivilege(AdminObject adminObject, String commandType) {
        IntegerSet is;
        IntegerSet allowedPane;
        boolean allowed = false;
        allowed = !AdminPrivilegeObject.validCommandType(commandType) ? false : ((adminObject.isSysAdmin() || adminObject.isDomainSysAdmin()) && adminObject.getName() != null ? true : (adminObject.getAdminPrivilege() == null ? false : (!(allowedPane = adminObject.getAdminPrivilege().getAllowedPaneIntegerSet()).contains("0x10", 16) && !allowedPane.contains("0x30", 16) && adminObject.getName() != null ? false : ("0xF3".equalsIgnoreCase(commandType) ? AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF1") && AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF2") : !(is = adminObject.getAdminPrivilege().getDisallowedCommandSet()).contains(commandType, 16)))));
        boolean isSnacOnlyProduct = LicenseObject.getInstance().isSNACOnlyProduct();
        if (isSnacOnlyProduct && (commandType.equalsIgnoreCase("0xF1") || commandType.equalsIgnoreCase("0xF3") || commandType.equalsIgnoreCase("0xF5") || commandType.equalsIgnoreCase("0xF6") || commandType.equalsIgnoreCase("0xF7") || commandType.equalsIgnoreCase("0xF9") || commandType.equalsIgnoreCase("0xFA") || commandType.equalsIgnoreCase("0xF10") || commandType.equalsIgnoreCase("0xF8") || commandType.equalsIgnoreCase("0xF12") || commandType.equalsIgnoreCase("0xF15") || commandType.equalsIgnoreCase("0xF16"))) {
            allowed = false;
        }
        if ((commandType.equalsIgnoreCase("0xF15") || commandType.equalsIgnoreCase("0xF16")) && !ScmProperties.isDeceptionEnabled()) {
            allowed = false;
        }
        return allowed;
    }

    public static boolean hasCommandPrivilege(AdminObject adminObject) {
        boolean allowed = AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF1") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF2") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF4") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF5") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF11") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF6") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF7") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF9") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xFA") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF8") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF10") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF12") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF15") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF16");
        return allowed;
    }

    public boolean getCommandPrivilege(String commandType) {
        boolean allowed = false;
        if (!AdminPrivilegeObject.validCommandType(commandType)) {
            allowed = false;
        } else if (this.hasPrivilege()) {
            IntegerSet set = this.getDisallowedCommandSet();
            allowed = !set.contains(commandType, 16);
        }
        boolean isSnacOnlyProduct = LicenseObject.getInstance().isSNACOnlyProduct();
        if (isSnacOnlyProduct && (commandType.equalsIgnoreCase("0xF1") || commandType.equalsIgnoreCase("0xF3") || commandType.equalsIgnoreCase("0xF5") || commandType.equalsIgnoreCase("0xF6") || commandType.equalsIgnoreCase("0xF7") || commandType.equalsIgnoreCase("0xF9") || commandType.equalsIgnoreCase("0xFA") || commandType.equalsIgnoreCase("0xF10") || commandType.equalsIgnoreCase("0xF8") || commandType.equalsIgnoreCase("0xF11") || commandType.equalsIgnoreCase("0xF12") || commandType.equalsIgnoreCase("0xF15") || commandType.equalsIgnoreCase("0xF16"))) {
            allowed = false;
        }
        return allowed;
    }

    public static boolean validCommandType(String commandType) {
        boolean valid = commandType == null || commandType.trim().length() <= 0 ? false : commandType.equalsIgnoreCase("0xF1") || commandType.equalsIgnoreCase("0xF2") || commandType.equalsIgnoreCase("0xF3") || commandType.equalsIgnoreCase("0xF4") || commandType.equalsIgnoreCase("0xF5") || commandType.equalsIgnoreCase("0xF6") || commandType.equalsIgnoreCase("0xF7") || commandType.equalsIgnoreCase("0xF9") || commandType.equalsIgnoreCase("0xFA") || commandType.equalsIgnoreCase("0xF10") || commandType.equalsIgnoreCase("0xF8") || commandType.equalsIgnoreCase("0xF11") || commandType.equalsIgnoreCase("0xF12") || commandType.equalsIgnoreCase("0xF15") || commandType.equalsIgnoreCase("0xF16");
        return valid;
    }

    public void setCommandPrivilege(String commandType, boolean hasRight) {
        if (!AdminPrivilegeObject.validCommandType(commandType)) {
            return;
        }
        if (this.hasPrivilege()) {
            IntegerSet set = this.getDisallowedCommandSet();
            if (hasRight) {
                if (set.contains(commandType, 16)) {
                    set.delete(new IntegerRange(commandType, 16));
                }
            } else if (!set.contains(commandType, 16)) {
                set.add(commandType, 16);
            }
            this.adminPrivilege.setOptDisallowedCommand(set.toString());
        }
    }

    public void setAllCommandPrivilege(boolean hasRight) {
        if (this.hasPrivilege()) {
            this.setCommandPrivilege("0xF1", hasRight);
            this.setCommandPrivilege("0xF2", hasRight);
            this.setCommandPrivilege("0xF4", hasRight);
            this.setCommandPrivilege("0xF5", hasRight);
            this.setCommandPrivilege("0xF6", hasRight);
            this.setCommandPrivilege("0xF7", hasRight);
            this.setCommandPrivilege("0xF9", hasRight);
            this.setCommandPrivilege("0xFA", hasRight);
            this.setCommandPrivilege("0xF8", hasRight);
            this.setCommandPrivilege("0xF10", hasRight);
            this.setCommandPrivilege("0xF11", hasRight);
            this.setCommandPrivilege("0xF12", hasRight);
            this.setCommandPrivilege("0xF15", hasRight);
            this.setCommandPrivilege("0xF16", hasRight);
        }
    }

    public void setDefaultCommandPrivilege() {
        if (this.hasPrivilege()) {
            boolean isSnacOnlyProduct = LicenseObject.getInstance().isSNACOnlyProduct();
            if (isSnacOnlyProduct) {
                this.setCommandPrivilege("0xF1", false);
                this.setCommandPrivilege("0xF5", false);
                this.setCommandPrivilege("0xF6", false);
                this.setCommandPrivilege("0xF7", false);
                this.setCommandPrivilege("0xF9", false);
                this.setCommandPrivilege("0xFA", false);
                this.setCommandPrivilege("0xF8", false);
                this.setCommandPrivilege("0xF10", false);
                this.setCommandPrivilege("0xF11", false);
                this.setCommandPrivilege("0xF12", false);
                this.setCommandPrivilege("0xF15", false);
                this.setCommandPrivilege("0xF16", false);
            } else {
                this.setCommandPrivilege("0xF1", true);
                this.setCommandPrivilege("0xF5", true);
                this.setCommandPrivilege("0xF6", true);
                this.setCommandPrivilege("0xF7", true);
                this.setCommandPrivilege("0xF9", true);
                this.setCommandPrivilege("0xFA", true);
                this.setCommandPrivilege("0xF8", true);
                this.setCommandPrivilege("0xF10", true);
                this.setCommandPrivilege("0xF11", true);
                this.setCommandPrivilege("0xF12", true);
                this.setCommandPrivilege("0xF2", true);
                this.setCommandPrivilege("0xF4", false);
                this.setCommandPrivilege("0xF15", true);
                this.setCommandPrivilege("0xF16", true);
            }
        }
    }

    public void resetCommandRightsWhenNoGroupReportRights() {
        IntegerSet allowedPane;
        if (this.hasPrivilege() && !(allowedPane = this.getAllowedPaneIntegerSet()).contains("0x10", 16) && !allowedPane.contains("0x30", 16)) {
            this.setAllCommandPrivilege(false);
        }
    }

    public static boolean isCurrentAdminHasRightToImportADOU() {
        AdminObject curAdminObj = new AdminObject(DataobjectManager.getInstance().getCurrentAdministrator());
        return curAdminObj.isSysAdmin() || curAdminObj.isDomainSysAdmin();
    }

    public static int isCurrentAdminHasRightToLocalSPCServer(String serverId) {
        if (!AdminPrivilegeObject.isCurrentAdminHasSitePrivilege()) {
            return 1;
        }
        return AdminPrivilegeObject.hasAccessRightToLocalSPCServer(AdminObject.retrieveCurrentAdminObject(), serverId);
    }

    private static int hasAccessRightToLocalSPCServer(AdminObject adminObject, String serverId) {
        PrivilegeValue privilegeValue;
        SitePrivilege sitePrivilege;
        if (adminObject == null || serverId == null) {
            return 1;
        }
        if (adminObject.isSysAdmin()) {
            return 0;
        }
        AdminPrivilegeObject privilegeObj = adminObject.getAdminPrivilege();
        if (privilegeObj != null && (sitePrivilege = privilegeObj.getSitePrivilegeById(DataobjectManager.getInstance().getLoginInformation().getSiteGUID())) != null && sitePrivilege.getOptPrivilegeValue() != null && (privilegeValue = sitePrivilege.getOptPrivilegeValue()) != null && privilegeValue.getOptPrivilege() != null) {
            ServerPrivilegeSet serverPrivilegeSet;
            if (privilegeValue.getOptPrivilege() == 0) {
                return 0;
            }
            if (privilegeValue.getOptPrivilege() == 2 && (serverPrivilegeSet = sitePrivilege.getOptServerPrivilegeSet()) != null) {
                if (serverPrivilegeSet.getOptPrivilegeValue() != null && serverPrivilegeSet.getOptPrivilegeValue().getOptPrivilege() != null) {
                    return serverPrivilegeSet.getOptPrivilegeValue().getOptPrivilege();
                }
                int count = serverPrivilegeSet.getServerPrivilegeCount();
                for (int j = 0; j < count; ++j) {
                    ServerPrivilege serverPrivilege = serverPrivilegeSet.getServerPrivilege(j);
                    if (serverPrivilege == null || serverPrivilege.getRefServerId() == null || !serverId.equalsIgnoreCase(serverPrivilege.getRefServerId())) continue;
                    if (serverPrivilege.getOptPrivilegeValue() != null && serverPrivilege.getOptPrivilegeValue().getOptPrivilege() != null) {
                        return serverPrivilege.getOptPrivilegeValue().getOptPrivilege();
                    }
                    return 1;
                }
            }
        }
        return 1;
    }

    public static int isCurrentAdminHasRightToLocalSite() {
        if (!AdminPrivilegeObject.isCurrentAdminHasSitePrivilege()) {
            return 1;
        }
        SemLoginInfo semLoginInfo = DataobjectManager.getInstance().getLoginInformation();
        if (semLoginInfo == null) {
            return 1;
        }
        return AdminPrivilegeObject.hasAccessRightToLocalSite(AdminObject.retrieveCurrentAdminObject(), semLoginInfo.getSiteGUID());
    }

    private static int hasAccessRightToLocalSite(AdminObject adminObject, String siteId) {
        SitePrivilegeSet sitePrivilegeSet;
        if (adminObject == null || siteId == null) {
            return 1;
        }
        if (adminObject.isSysAdmin()) {
            return 0;
        }
        AdminPrivilegeObject privilegeObj = adminObject.getAdminPrivilege();
        if (privilegeObj != null && (sitePrivilegeSet = privilegeObj.getSitePrivilegeSet()) != null) {
            int siteCount = sitePrivilegeSet.getSitePrivilegeCount();
            for (int i = 0; i < siteCount; ++i) {
                PrivilegeValue privilegeValue;
                SitePrivilege sitePrivilege = sitePrivilegeSet.getSitePrivilege(i);
                if (sitePrivilege == null || sitePrivilege.getOptPrivilegeValue() == null || !siteId.equalsIgnoreCase(sitePrivilege.getRefSiteId()) || (privilegeValue = sitePrivilege.getOptPrivilegeValue()) == null || privilegeValue.getOptPrivilege() == null) continue;
                return privilegeValue.getOptPrivilege();
            }
        }
        return 1;
    }

    public static boolean hasClientCommandPrivilege() {
        AdminObject adminObject = AdminObject.retrieveCurrentAdminObject();
        return AdminPrivilegeObject.checkCommandPrivilege(adminObject);
    }

    public static boolean hasClientCommandPrivilege(AdminObject adminObject) {
        boolean hasPrivilege = false;
        hasPrivilege = adminObject == null ? AdminPrivilegeObject.hasClientCommandPrivilege() : AdminPrivilegeObject.checkCommandPrivilege(adminObject);
        return hasPrivilege;
    }

    private static boolean checkCommandPrivilege(AdminObject adminObject) {
        boolean allowed = AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF1") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF2") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF4") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF5") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF11") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF6") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF7") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF9") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xFA") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF10") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF12") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF15") || AdminPrivilegeObject.hasCommandPrivilege(adminObject, "0xF16");
        return allowed;
    }

    private static Integer getOptCurrentAdminPackagePrivilege() {
        AdminObject admin = AdminObject.retrieveCurrentAdminObject();
        if (admin == null || admin.isSysAdmin() || admin.isDomainSysAdmin()) {
            return null;
        }
        AdminPrivilegeObject privilegeObj = admin.getAdminPrivilege();
        if (privilegeObj != null) {
            return privilegeObj.getPackagePrivilege();
        }
        return null;
    }

    public static Integer getCurrentAdminPackagePrivilege() {
        Integer packagePrivilege = AdminPrivilegeObject.getOptCurrentAdminPackagePrivilege();
        if (packagePrivilege != null) {
            return packagePrivilege;
        }
        return SemAdminPrivilege.FULL_ACCESS;
    }

    public static boolean isCurrentAdminHasPackagePrivilege() {
        if (LicenseObject.getInstance().isSBProduct()) {
            return true;
        }
        AuthorizationManager manager = AuthorizationManager.getInstance();
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        return manager.checkPermission(context, (Permission)AuthorizationManager.TopLevelPermission.MANAGE_PACKAGES);
    }

    public static boolean isCurrentAdminHasFullAccessPackagePrivilege() {
        if (LicenseObject.getInstance().isSBProduct()) {
            return true;
        }
        Integer packagePrivilege = AdminPrivilegeObject.getCurrentAdminPackagePrivilege();
        return packagePrivilege != null && SemAdminPrivilege.FULL_ACCESS.intValue() == packagePrivilege.intValue();
    }

    private static boolean isCurrentAdminHasSitePrivilege() {
        AuthorizationManager manager = AuthorizationManager.getInstance();
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        return manager.checkPermission(context, (Permission)AuthorizationManager.TopLevelPermission.MANAGE_SITES);
    }

    public static ArrayList<String> getAllowedPolictTypes(AdminPrivilegeObject privilegeObj) {
        ArrayList<String> allowedPolictTypes = null;
        String[] types = PolicyTypeRightsPanel.getPolicyprivilegetypes();
        for (int i = 0; i < types.length; ++i) {
            boolean disallowed;
            boolean bl = disallowed = !AdminPrivilegeObject.isHasPolicyTypePrivilege(privilegeObj, types[i]);
            if (disallowed) continue;
            if (null == allowedPolictTypes) {
                allowedPolictTypes = new ArrayList<String>();
            }
            allowedPolictTypes.add(types[i]);
        }
        return allowedPolictTypes;
    }

    public SemAdminPrivilege getSemAdminPrivilege() {
        return this.adminPrivilege.getSemAdminPrivilege();
    }

    public ArrayList<String> getAllowedClientGroupList() {
        return (ArrayList)this.adminPrivilege.getAllowedClientGroupList();
    }

    public String getAllowedComputer() {
        return this.adminPrivilege.getAllowedComputer();
    }

    public String getAllowedIP() {
        return this.adminPrivilege.getAllowedIP();
    }

    public String getAllowedLegacyDomain() {
        return this.adminPrivilege.getAllowedLegacyDomain();
    }

    public String getAllowedLegacyGroup() {
        return this.adminPrivilege.getAllowedLegacyGroup();
    }

    public String getAllowedLegacyServer() {
        return this.adminPrivilege.getAllowedLegacyServer();
    }

    public IntegerSet getAllowedPaneIntegerSet() {
        return this.adminPrivilege.getAllowedPaneIntegerSet();
    }

    public ArrayList<String> getDisallowedClientGroupList() {
        return (ArrayList)this.adminPrivilege.getDisallowedClientGroupList();
    }

    public IntegerSet getDisallowedCommandSet() {
        return this.adminPrivilege.getDisallowedCommandSet();
    }

    public String getDisallowedFeature() {
        return this.adminPrivilege.getDisallowedFeature();
    }

    public IntegerSet getDisallowedPaneIntegerSet() {
        return this.adminPrivilege.getDisallowedPaneIntegerSet();
    }

    public int getGroupConstraint(String groupId, int parentConstraint) {
        int i;
        ArrayList<String> listAllowed = this.getAllowedClientGroupList();
        ArrayList<String> listDisallowed = this.getDisallowedClientGroupList();
        ArrayList<String> listReadOnly = this.getReadOnlyClientGroupList();
        if (listAllowed != null) {
            for (i = 0; i < listAllowed.size(); ++i) {
                if (!groupId.equals(listAllowed.get(i))) continue;
                return 0;
            }
        }
        if (listDisallowed != null) {
            for (i = 0; i < listDisallowed.size(); ++i) {
                if (!groupId.equals(listDisallowed.get(i))) continue;
                return 1;
            }
        }
        if (listReadOnly != null) {
            for (i = 0; i < listReadOnly.size(); ++i) {
                if (!groupId.equals(listReadOnly.get(i))) continue;
                return 2;
            }
        }
        return parentConstraint;
    }

    public Integer getPackagePrivilege() {
        return this.adminPrivilege.getPackagePrivilege();
    }

    public ArrayList<String> getReadOnlyClientGroupList() {
        return (ArrayList)this.adminPrivilege.getReadOnlyClientGroupList();
    }

    public SitePrivilege getSitePrivilegeById(String siteId) {
        return this.adminPrivilege.getSitePrivilegeById(siteId);
    }

    public SitePrivilegeSet getSitePrivilegeSet() {
        return this.adminPrivilege.getSitePrivilegeSet();
    }

    public boolean hasAccessRightToGroup(String groupId, boolean isParentAccessible, boolean excludeReadOnly) {
        return this.adminPrivilege.hasAccessRightToGroup(groupId, isParentAccessible, excludeReadOnly);
    }

    public boolean hasAccessRightToGroup(String groupId, boolean isParentAccessible) {
        return this.adminPrivilege.hasAccessRightToGroup(groupId, isParentAccessible);
    }

    public boolean hasExecuteCommandRights() {
        return this.adminPrivilege.hasExecuteCommandRights();
    }

    public boolean hasPrivilege() {
        return this.adminPrivilege.hasPrivilege();
    }

    public boolean isDomainAdminPrivilege() {
        return this.adminPrivilege.isDomainAdminPrivilege();
    }

    public void setAllowedClientGroupList(ArrayList<String> fullAccessList) {
        this.adminPrivilege.setAllowedClientGroupList(fullAccessList);
    }

    public void setAllowedComputer(String wildcard) {
        this.adminPrivilege.setAllowedComputer(wildcard);
    }

    public void setAllowedIP(String wildcard) {
        this.adminPrivilege.setAllowedIP(wildcard);
    }

    public void setAllowedLegacyDomain(String wildcard) {
        this.adminPrivilege.setAllowedLegacyDomain(wildcard);
    }

    public void setAllowedLegacyGroup(String wildcard) {
        this.adminPrivilege.setAllowedLegacyGroup(wildcard);
    }

    public void setAllowedLegacyServer(String wildcard) {
        this.adminPrivilege.setAllowedLegacyServer(wildcard);
    }

    public void setAllowedPane(String pane) {
        this.adminPrivilege.setAllowedPane(pane);
    }

    public void setDisallowedClientGroupList(ArrayList<String> noAccessList) {
        this.adminPrivilege.setDisallowedClientGroupList(noAccessList);
    }

    public void setDisallowedFeature(String feature) {
        this.adminPrivilege.setDisallowedFeature(feature);
    }

    public void setReadOnlyClientGroupList(ArrayList<String> readOnlyAccessList) {
        this.adminPrivilege.setReadOnlyClientGroupList(readOnlyAccessList);
    }

    public boolean getAllowReadOnlyRunCommands() {
        Boolean allowed = this.adminPrivilege.getSemAdminPrivilege().getOptAllowReadOnlyRunCommands();
        return allowed != null ? allowed : this.adminPrivilege.getSemAdminPrivilege().getDefAllowReadOnlyRunCommands();
    }

    public void setAllowReadOnlyRunCommands(boolean allowed) {
        this.adminPrivilege.getSemAdminPrivilege().setOptAllowReadOnlyRunCommands(Boolean.valueOf(allowed));
    }

    public static boolean canRunCommandsForReadOnlyGroup() {
        AdminObject adminObj = AdminObject.retrieveCurrentAdminObject();
        if (adminObj != null && adminObj.isLimitedAdmin()) {
            return adminObj.getAdminPrivilege().getAllowReadOnlyRunCommands() && AdminPrivilegeObject.hasClientCommandPrivilege(adminObj);
        }
        return false;
    }
}

