/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.AdminPreference;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.TablePreference;
import com.sygate.scm.console.logicobject.TablePreferenceObject;
import java.util.Vector;

public class AdminPreferenceObject {
    private AdminPreference preference;

    public AdminPreferenceObject(AdminPreference pref) {
        this.preference = pref;
    }

    public static AdminPreferenceObject newInstance(SemAdministrator admin) {
        AdminPreference pref = admin.getOptAdminPreference();
        if (pref == null) {
            pref = new AdminPreference();
            TablePreference tp = new TablePreference();
            pref.addTablePreference(tp);
            admin.setOptAdminPreference(pref);
        }
        return new AdminPreferenceObject(pref);
    }

    public Vector<TablePreferenceObject> getAllTablePreferenceObjects() {
        Vector<TablePreferenceObject> list = new Vector<TablePreferenceObject>(0, 10);
        Vector v = this.preference.getTablePreference();
        if (v == null || v.size() < 1) {
            TablePreferenceObject tpo = TablePreferenceObject.newInstance(this.preference);
            list.add(tpo);
        } else {
            for (TablePreference tablePreference : v) {
                TablePreferenceObject tpo = new TablePreferenceObject(tablePreference);
                list.add(tpo);
            }
        }
        return list;
    }

    public TablePreferenceObject getTablePreferenceObject(TablePreference tp) {
        TablePreferenceObject tpo;
        Vector<TablePreferenceObject> v = this.getAllTablePreferenceObjects();
        if (v == null || v.isEmpty()) {
            tpo = TablePreferenceObject.newInstance(this.preference);
        } else {
            tpo = new TablePreferenceObject(tp);
            if (!v.contains(tpo)) {
                tpo = TablePreferenceObject.newInstance(this.preference);
            }
        }
        return tpo;
    }

    public void addTablePreference(TablePreference tp) {
        int count = this.preference.getTablePreferenceCount();
        boolean found = false;
        if (count < 1) {
            this.preference.addTablePreference(tp);
        } else {
            for (int i = 0; i < count; ++i) {
                TablePreference tpref = this.preference.getTablePreference(i);
                if (!tpref.equals((Object)tp)) continue;
                found = true;
                this.preference.setTablePreference(i, tp);
            }
            if (!found) {
                this.preference.addTablePreference(tp);
            }
        }
    }

    public boolean setColumnAndSizeSequence(String tableName, String[] colOrderAndSize) {
        if (tableName == null || tableName.length() == 0) {
            return false;
        }
        if (colOrderAndSize == null || colOrderAndSize.length < 2) {
            return false;
        }
        boolean changed = false;
        Vector v = this.preference.getTablePreference();
        String colString = colOrderAndSize[0];
        String sizeString = colOrderAndSize[1];
        if (colString == null || sizeString == null) {
            return false;
        }
        int size = v.size();
        if (size == 0) {
            TablePreference tablePref = new TablePreference();
            tablePref.setOptTableName(tableName);
            tablePref.setOptModalColumnSeq(colString);
            tablePref.setOptTableColumnSizeSeq(sizeString);
            this.preference.addTablePreference(tablePref);
            changed = true;
        } else {
            boolean found = false;
            int target = -1;
            for (int i = 0; i < v.size(); ++i) {
                TablePreference tp = (TablePreference)v.elementAt(i);
                if (tp.getOptTableName() == null || tp.getOptTableName().length() == 0) {
                    target = i;
                    continue;
                }
                if (!tp.getOptTableName().equalsIgnoreCase(tableName)) continue;
                found = true;
                if (colString.equalsIgnoreCase(tp.getOptModalColumnSeq()) && sizeString.equalsIgnoreCase(tp.getOptTableColumnSizeSeq())) continue;
                tp.setOptModalColumnSeq(colString);
                tp.setOptTableColumnSizeSeq(sizeString);
                changed = true;
                break;
            }
            if (!found) {
                if (target >= 0) {
                    TablePreference tp = (TablePreference)v.elementAt(target);
                    tp.setOptTableName(tableName);
                    tp.setOptModalColumnSeq(colString);
                    tp.setOptTableColumnSizeSeq(sizeString);
                } else {
                    TablePreference tp = new TablePreference();
                    tp.setOptTableName(tableName);
                    tp.setOptModalColumnSeq(colString);
                    tp.setOptTableColumnSizeSeq(sizeString);
                    this.preference.addTablePreference(tp);
                }
                changed = true;
            }
        }
        return changed;
    }

    public String[] getColumnAndSizeSequence(String tableName) {
        String[] ret2str = new String[]{null, null};
        Vector v = this.preference.getTablePreference();
        if (v.size() > 0 && tableName != null) {
            String colString = null;
            for (TablePreference tp : v) {
                if (tp.getOptTableName() == null || tp.getOptTableName().length() == 0 || !tp.getOptTableName().equalsIgnoreCase(tableName)) continue;
                colString = tp.getOptModalColumnSeq();
                if (colString != null && colString.length() > 0) {
                    ret2str[0] = colString;
                }
                if ((colString = tp.getOptTableColumnSizeSeq()) == null || colString.length() <= 0) break;
                ret2str[1] = colString;
                break;
            }
        }
        return ret2str;
    }

    public String getClientViewName() {
        return this.preference.getOptClientView();
    }

    public void setClientViewName(String name) {
        this.preference.setOptClientView(name);
    }

    public void setAdminPreference(AdminPreference pref) {
        this.preference = pref;
    }

    public AdminPreference getAdminPreference() {
        return this.preference;
    }
}

