/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.schema.AdminContext;
import com.sygate.scm.common.configobject.schema.AdminPayload;
import com.sygate.scm.common.configobject.schema.AdminPreference;
import com.sygate.scm.common.configobject.schema.AllowedClientGroup;
import com.sygate.scm.common.configobject.schema.DisallowedClientGroup;
import com.sygate.scm.common.configobject.schema.GroupId;
import com.sygate.scm.common.configobject.schema.LoginConfig;
import com.sygate.scm.common.configobject.schema.ReadOnlyClientGroup;
import com.sygate.scm.common.configobject.schema.SemAdminNotification;
import com.sygate.scm.common.configobject.schema.SemAdminPrivilege;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SysAdministratorArray;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.AdminUtils;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminNotificationObject;
import com.sygate.scm.console.logicobject.AdminPreferenceObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.AdminStateObject;
import com.sygate.scm.console.logicobject.DomainObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LoginConfigObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.IntegerSet;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;

public class AdminObject
extends AbstractUIObject
implements TreeItem {
    private static final int NEVER_EXPIRING_PWD_AGE = -1;
    private static final long FIRST_LOGIN_IN_INDICATOR = -1L;
    public static final int ADMINNAME_MINLENGTH = 1;
    public static final int ADMINNAME_MAXLENGTH = 64;
    public static final String ADMINNAME_CONSTRAINT = "/\\\\[]:;|=,+*?<>";
    private static final String EMPTY_STRING = "";
    private AdminContext adminContext = null;
    private SemAdministrator semAdmin;
    private AdminType adminType;
    private boolean nameDirty = false;

    public AdminObject(SemAdministrator semAdmin) {
        this.semAdmin = semAdmin;
        if (semAdmin != null && !AdminUtils.isSysAdmin((SemAdministrator)semAdmin)) {
            this.adminContext = (AdminContext)semAdmin.getParent();
        }
        this.initAdminType();
    }

    public AdminObject(AdminContext adminContext) {
        this.adminContext = adminContext;
        if (adminContext != null) {
            this.semAdmin = adminContext.getSemAdministrator();
        }
        this.initAdminType();
    }

    public static AdminObject retrieveCurrentAdminObject() {
        return AdminObject.retrieveCurrentAdminObject(false);
    }

    public static AdminObject retrieveCurrentAdminObject(boolean refreshWithDB) {
        SemAdministrator admin = DataobjectManager.getInstance().getCurrentAdministrator(refreshWithDB);
        if (admin == null) {
            admin = DataobjectManager.getInstance().getCurrentAdministrator(true);
        }
        return new AdminObject(admin);
    }

    public static AdminObject createAdminObject() {
        AdminContext adminContext = new AdminContext();
        SemAdministrator semAdmin = new SemAdministrator();
        adminContext.setSemAdministrator(semAdmin);
        semAdmin.setId(new GUIDGenerator().getGUIDString());
        semAdmin.setOptEnable(Boolean.TRUE);
        AdminPayload adminPayload = new AdminPayload();
        semAdmin.setAdminPayload(adminPayload);
        SemAdminNotification semAdminNotification = new SemAdminNotification();
        adminPayload.setOptSemAdminNotification(semAdminNotification);
        AdminNotificationObject adminNotificationObj = new AdminNotificationObject(semAdminNotification);
        adminNotificationObj.setLoginNotification(true, true, null);
        adminNotificationObj.setSystemNotification(true, AdminNotificationObject.getSysEventAll());
        adminNotificationObj.setAllAlertUseSameGroup(true);
        return new AdminObject(semAdmin);
    }

    public void update() throws ConsoleException {
        this.update(false);
    }

    public void update(boolean deleteAccessToken) throws ConsoleException {
        if (this.semAdmin == null) {
            return;
        }
        AdminHandler.updateAdmin(this, deleteAccessToken);
    }

    public AdminStateObject retrieveState() throws ConsoleException {
        if (this.semAdmin == null) {
            return new AdminStateObject();
        }
        return AdminStateObject.retrieveAdminStateObject(this.semAdmin);
    }

    public void initLoginConfig() {
        AdminPayload adminPayLoad = this.getAminPayLoad();
        if (adminPayLoad == null) {
            return;
        }
        adminPayLoad.setOptLoginConfig(new LoginConfig());
    }

    public void setAdminType(AdminType adminType) {
        this.adminType = adminType;
    }

    public void setAdminLoggedIn(boolean hasAdminLoggedIn) {
        if (this.semAdmin == null) {
            return;
        }
        this.semAdmin.setOptHasAdminLoggedIn(Boolean.valueOf(hasAdminLoggedIn));
    }

    public void setDisabledCIWReminder(boolean disableCIWReminder) {
        if (this.semAdmin != null) {
            this.semAdmin.setOptDisableCIWReminder(Boolean.valueOf(disableCIWReminder));
        }
    }

    public void setDisableCopyPolicyReminder(boolean disableCopyPolicyReminder) {
        if (this.semAdmin != null) {
            this.semAdmin.setOptDisableCopyPolicyReminder(Boolean.valueOf(disableCopyPolicyReminder));
        }
    }

    private void initAdminType() {
        if (this.isSysAdmin()) {
            this.setAdminType(AdminType.SYS_ADMIN);
        } else if (this.isDomainSysAdmin()) {
            this.setAdminType(AdminType.DOMAIN_ADMIN);
        } else {
            this.setAdminType(AdminType.LIMITED_ADMIN);
        }
    }

    public boolean isNull() {
        return false;
    }

    public AdminType getAdminType() {
        return this.adminType;
    }

    public boolean hasAdminLoggedIn() {
        if (this.semAdmin == null) {
            return false;
        }
        if (this.semAdmin.getOptHasAdminLoggedIn() == null) {
            return false;
        }
        return this.semAdmin.getOptHasAdminLoggedIn();
    }

    public boolean getDisabledCIWReminder() {
        if (this.semAdmin != null && this.semAdmin.getOptDisableCIWReminder() != null) {
            return this.semAdmin.getOptDisableCIWReminder();
        }
        return false;
    }

    public boolean isDisableCopyPolicyReminder() {
        if (this.semAdmin == null) {
            return new SemAdministrator().getDefDisableCopyPolicyReminder();
        }
        if (this.semAdmin.getOptDisableCopyPolicyReminder() == null) {
            return this.semAdmin.getDefDisableCopyPolicyReminder();
        }
        return this.semAdmin.getOptDisableCopyPolicyReminder();
    }

    public boolean isSysAdmin() {
        return AdminUtils.isSysAdmin((SemAdministrator)this.semAdmin);
    }

    public boolean isDomainSysAdmin() {
        return AdminUtils.isDomainAdmin((SemAdministrator)this.semAdmin);
    }

    public boolean isLimitedAdmin() {
        return AdminUtils.isLimitedAdmin((SemAdministrator)this.semAdmin);
    }

    public AdminContext getAdminContext() {
        return this.adminContext;
    }

    public String getAdminName() {
        return this.semAdmin == null ? null : this.semAdmin.getName();
    }

    public SemAdministrator getSemAdmin() {
        return this.semAdmin;
    }

    public String getPassword() {
        if (this.semAdmin == null) {
            return null;
        }
        return this.semAdmin.getOptPasswordHash();
    }

    public String getFullName() {
        String fullname = this.semAdmin.getOptFullName();
        return fullname == null ? EMPTY_STRING : fullname;
    }

    public String getEmail() {
        String email = this.semAdmin.getOptEmailAddress();
        return email == null ? EMPTY_STRING : email;
    }

    public Integer getAuthenticationMethod() {
        Integer type = this.semAdmin.getOptAuthenticationMethod();
        if (type == null) {
            type = SemAdministrator.DEFAULT;
        }
        return type;
    }

    public void setAdminName(String adminName) {
        if (this.semAdmin == null || adminName == null) {
            return;
        }
        this.setNameDirty(adminName);
        this.semAdmin.setName(adminName.trim());
    }

    public void setPassword(String password) {
        if (this.semAdmin == null || password == null) {
            password = EMPTY_STRING;
        }
        if (this.semAdmin != null) {
            this.semAdmin.setOptPasswordHash(password.trim());
        }
    }

    public void setFullName(String fullName) {
        if (this.semAdmin == null || fullName == null) {
            return;
        }
        this.semAdmin.setOptFullName(fullName.trim());
    }

    public void setEmail(String email) {
        if (this.semAdmin == null || email == null) {
            return;
        }
        this.semAdmin.setOptEmailAddress(email.trim());
    }

    public boolean hasChanged() {
        return this.adminContext.isDirty();
    }

    public void reset() {
        this.adminContext.setClean();
    }

    public String toString() {
        return this.getAdminName();
    }

    public String getAdminId() {
        if (this.semAdmin != null) {
            return this.semAdmin.getId();
        }
        if (this.adminContext != null && this.adminContext.getSemAdministrator() != null) {
            return this.adminContext.getSemAdministrator().getId();
        }
        return null;
    }

    @Override
    public String getId() {
        return this.semAdmin.getId();
    }

    @Override
    public String getName() {
        return this.getAdminName();
    }

    @Override
    public int getItemType() {
        if (this.isSysAdmin()) {
            return 20;
        }
        if (this.isDomainSysAdmin()) {
            return 140;
        }
        return 141;
    }

    public void setName(String value) {
        this.setAdminName(value);
    }

    public boolean isEqualPassword(String clearTextPwd) {
        boolean retVal = false;
        String pwdHash = this.semAdmin.getOptPasswordHash();
        if (pwdHash != null) {
            if (pwdHash.startsWith("03")) {
                retVal = Utility.isEqualPKDBF2Hash((String)clearTextPwd, (String)pwdHash);
            } else if (pwdHash.startsWith("02")) {
                retVal = Utility.isEqualPKDBF2HashWithMD5Seed((String)clearTextPwd, (String)pwdHash);
            } else if (pwdHash.startsWith("01")) {
                retVal = Utility.isEqualPKDBF2HashwithSHA1Seed((String)this.getName(), (String)clearTextPwd, (String)pwdHash);
            }
        }
        return retVal;
    }

    public long getCreationTime() {
        return this.semAdmin != null ? this.semAdmin.getCreationTime() : -1L;
    }

    public String getCreationTimeDisplayString() {
        if (this.semAdmin == null) {
            return EMPTY_STRING;
        }
        long time = this.getCreationTime();
        if (time < 1L) {
            return EMPTY_STRING;
        }
        return Utility.getLongDateTimeString((long)time, null);
    }

    public boolean setCreationTime(long time) {
        if (this.semAdmin == null) {
            return false;
        }
        this.semAdmin.setCreationTime(Long.valueOf(time));
        return true;
    }

    public boolean setCreationTime() {
        return this.setCreationTime(TimeUtil.getServerTime());
    }

    public String getDomainId() {
        if (this.semAdmin == null) {
            return null;
        }
        AbstractSchema parent = this.semAdmin.getParent();
        if (parent == null || parent instanceof SysAdministratorArray) {
            return Manager.getCurrentDomainId();
        }
        while (parent != null) {
            if (parent instanceof AdminContext) {
                return Manager.getCurrentDomainId();
            }
            parent = parent.getParent();
        }
        System.out.println("AdminObject>> getDomainId: Error-> Failed to get Domain ID. admin=" + this.semAdmin.getName() + ", " + this.semAdmin.getId());
        return null;
    }

    public DomainObject getDomain() {
        String domainId = this.getDomainId();
        if (domainId == null || domainId.length() == 0) {
            return null;
        }
        try {
            SemDomain semDomain = (SemDomain)DataobjectManager.getInstance().getObjectByGUID("SemDomain", domainId);
            return new DomainObject(semDomain);
        }
        catch (Exception ex) {
            System.out.println("AdminObject>> getDomain: Error-> Failed to get Domain. domain id=" + domainId + ". admin=" + this.semAdmin.getName() + ", " + this.semAdmin.getId());
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    public LoginConfigObject getLoginConfig(boolean check_domain_if_nonexist) {
        if (this.semAdmin == null) {
            return new LoginConfigObject();
        }
        AdminPayload adminPayLoad = this.semAdmin.getAdminPayload();
        if (adminPayLoad == null) {
            System.out.println("AdminObject>> getLoginConfig: Error-> failed to retrieve AminPayLoad.  admin=" + this.semAdmin.getName() + ", " + this.semAdmin.getId());
            return new LoginConfigObject();
        }
        LoginConfig loginConfig = adminPayLoad.getOptLoginConfig();
        if (loginConfig == null && check_domain_if_nonexist) {
            DomainObject domain = this.getDomain();
            if (domain == null) {
                return new LoginConfigObject();
            }
            loginConfig = domain.getLoginConfig();
        }
        return new LoginConfigObject(loginConfig);
    }

    public AdminPrivilegeObject getAdminPrivilege() {
        SemAdminPrivilege privilege = this.adminContext == null ? null : this.adminContext.getSemAdminPrivilege();
        return AdminPrivilegeObject.newInstance(privilege);
    }

    public void setAdminPrivilege(SemAdminPrivilege privilege) {
        if (this.adminContext == null) {
            return;
        }
        this.adminContext.setSemAdminPrivilege(privilege);
    }

    public void setSemAdmin(SemAdministrator semAdmin) {
        if (this.adminContext != null) {
            this.adminContext.setSemAdministrator(semAdmin);
        }
        this.semAdmin = semAdmin;
    }

    public boolean isValid() {
        return this.semAdmin != null;
    }

    public boolean isEnabled() {
        if (this.semAdmin == null) {
            return true;
        }
        if (this.semAdmin.getOptEnable() == null) {
            return this.semAdmin.getDefEnable();
        }
        return this.semAdmin.getOptEnable();
    }

    public String getEnabledDisplayString() {
        return this.isEnabled() ? MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminObject.msgEnabled") : MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminObject.msgDisabled");
    }

    public void setEnabled(boolean enabled) {
        if (this.semAdmin == null) {
            return;
        }
        this.semAdmin.setOptEnable(Boolean.valueOf(enabled));
    }

    public void setEnabled(AdminPrivilegeObject privObj) {
        IntegerSet set = privObj.getAllowedPaneIntegerSet();
        this.setEnabled(!set.isEmpty());
    }

    public AdminNotificationObject getAdminNotification() {
        AdminPayload adminPayLoad = this.semAdmin.getAdminPayload();
        if (adminPayLoad == null) {
            System.out.println("AdminObject>> getSemAdminNotification: Error-> failed to retrieve AdminPayload.  admin=" + this.semAdmin.getName() + ", " + this.semAdmin.getId());
            return null;
        }
        SemAdminNotification semAdminNotification = adminPayLoad.getOptSemAdminNotification();
        if (semAdminNotification == null) {
            semAdminNotification = new SemAdminNotification();
            adminPayLoad.setOptSemAdminNotification(semAdminNotification);
        }
        return new AdminNotificationObject(semAdminNotification);
    }

    public AdminPayload getAminPayLoad() {
        if (!this.isValid()) {
            return null;
        }
        AdminPayload adminPayLoad = this.semAdmin.getAdminPayload();
        if (adminPayLoad == null) {
            System.out.println("AdminObject>> getAminPayLoad: Error-> failed to retrieve AdminPayload.  admin=" + this.semAdmin.getName() + ", " + this.semAdmin.getId());
            return null;
        }
        return adminPayLoad;
    }

    public boolean needNotifyMtnLicenseExpiration() {
        if (!this.isSysAdmin()) {
            return false;
        }
        AdminPayload adminPayLoad = this.getAminPayLoad();
        if (adminPayLoad == null) {
            return true;
        }
        Boolean noNotify = adminPayLoad.getOptDoNotNotifyMtnLicenseExpiration();
        if (noNotify == null) {
            noNotify = adminPayLoad.getDefDoNotNotifyMtnLicenseExpiration();
        }
        return noNotify == false;
    }

    public void setNotifyMtnLicenseExpiration(boolean notify) {
        if (!this.isValid()) {
            return;
        }
        AdminPayload adminPayLoad = this.semAdmin.getAdminPayload();
        adminPayLoad.setOptDoNotNotifyMtnLicenseExpiration(Boolean.valueOf(!notify));
    }

    public boolean setLoginConfigProps(boolean isEmailAlertWhenFailureEnabled, int attemptThresholdBeforeAlert, boolean doesLockAccountUponAlert, int lockTimeInMinutes) {
        boolean modified = false;
        LoginConfigObject loginConfig = this.getLoginConfig(false);
        if (loginConfig.isValid()) {
            if (loginConfig.setProps(isEmailAlertWhenFailureEnabled, attemptThresholdBeforeAlert, doesLockAccountUponAlert, lockTimeInMinutes)) {
                modified = true;
            }
        } else {
            loginConfig.newInstance(isEmailAlertWhenFailureEnabled, attemptThresholdBeforeAlert, doesLockAccountUponAlert, lockTimeInMinutes);
            AdminPayload adminPayLoad = this.getAminPayLoad();
            if (adminPayLoad == null) {
                return false;
            }
            adminPayLoad.setOptLoginConfig(loginConfig.getLoginConfig());
            modified = true;
        }
        return modified;
    }

    public boolean hasGroupAccessRight() {
        int i;
        GroupObject groupGlobal;
        if (this.semAdmin == null) {
            return true;
        }
        if (this.adminContext == null) {
            return true;
        }
        SemAdminPrivilege semAdminPrivilege = this.adminContext.getSemAdminPrivilege();
        if (semAdminPrivilege == null) {
            return true;
        }
        AllowedClientGroup listAllowedGroups = semAdminPrivilege.getAllowedClientGroup();
        if (listAllowedGroups != null && listAllowedGroups.getGroupIdCount() > 0) {
            return true;
        }
        DisallowedClientGroup listDisallowedGroups = semAdminPrivilege.getOptDisallowedClientGroup();
        ReadOnlyClientGroup listReadOnlyClientGroups = semAdminPrivilege.getOptReadOnlyClientGroup();
        DomainObject domain = this.getDomain();
        if (domain == null) {
            return true;
        }
        try {
            groupGlobal = GroupHandler.getRootGroupObject(domain.getGroupTreeId());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return true;
        }
        if (groupGlobal == null) {
            return false;
        }
        if (listDisallowedGroups != null) {
            for (i = 0; i < listDisallowedGroups.getGroupIdCount(); ++i) {
                GroupId disallowedGroupId = listDisallowedGroups.getGroupId(i);
                String disallowedId = disallowedGroupId.getOptContent();
                if (disallowedId == null || disallowedId.length() < 1 || !disallowedId.equals(groupGlobal.getId())) continue;
                return false;
            }
        }
        if (listReadOnlyClientGroups != null) {
            for (i = 0; i < listReadOnlyClientGroups.getGroupIdCount(); ++i) {
                GroupId readOnlyGroupId = listReadOnlyClientGroups.getGroupId(i);
                String readOnlyId = readOnlyGroupId.getOptContent();
                if (readOnlyId == null || readOnlyId.length() < 1 || !readOnlyId.equals(groupGlobal.getId())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasGroupFullAccessRight() {
        SemAdminPrivilege privilege = this.adminContext == null ? null : this.adminContext.getSemAdminPrivilege();
        AuthorizationManager manager = AuthorizationManager.getInstance();
        PrivilegeContext context = PrivilegeContext.newInstance((SemAdminPrivilege)privilege);
        return manager.checkPermission(context, (Permission)AuthorizationManager.SpecialPermission.ONE_GROUP_FULL_ACCESS);
    }

    public boolean setSemAdminNotification(boolean sameGroupMinotorAllGroup, ArrayList<String> listSameGroupNotification, boolean isSecurityAlertNotification, boolean isSecurityAlertNotificationMonitorAllGroups, ArrayList<String> listSecurityAlertNotification, boolean isLearnedAppNotification, boolean isLearnedAppNotificationMonitorAllGroups, ArrayList<String> listLearnedAppNotification, boolean isClientGroupChangeNotification, boolean isClientGroupChangeNotificationMonitorAllGroups, ArrayList<String> listClientGroupChangeNotification, int messageFlowControlMode, int messageFlowControlDelay, boolean isAllAlertUseSameGroup, boolean isSendToSpecificRecipient, String to, String cc) {
        return this.setSemAdminNotification(false, false, false, false, null, false, null, sameGroupMinotorAllGroup, listSameGroupNotification, isSecurityAlertNotification, isSecurityAlertNotificationMonitorAllGroups, listSecurityAlertNotification, isLearnedAppNotification, isLearnedAppNotificationMonitorAllGroups, listLearnedAppNotification, isClientGroupChangeNotification, isClientGroupChangeNotificationMonitorAllGroups, listClientGroupChangeNotification, messageFlowControlMode, messageFlowControlDelay, isAllAlertUseSameGroup, isSendToSpecificRecipient, to, cc);
    }

    public boolean setSemAdminNotification(boolean isDailyReport, boolean isWeeklyReport, boolean isAuthFailureNotification, boolean isLoginNotificationMonitorAllDomains, ArrayList<String> listAuthFailureNotification, boolean isSysEventNotification, String listSysEvent, boolean sameGroupMonitorAllGroup, ArrayList<String> listSameGroupNotification, boolean isSecurityAlertNotification, boolean isSecurityAlertNotificationMonitorAllGroups, ArrayList<String> listSecurityAlertNotification, boolean isLearnedAppNotification, boolean isLearnedAppNotificationMonitorAllGroups, ArrayList<String> listLearnedAppNotification, boolean isClientGroupChangeNotification, boolean isClientGroupChangeNotificationMonitorAllGroups, ArrayList<String> listClientGroupChangeNotification, int messageFlowControlMode, int messageFlowControlDelay, boolean isAllAlertUseSameGroup, boolean isSendToSpecificRecipient, String to, String cc) {
        AdminNotificationObject adminNotification = this.getAdminNotification();
        if (adminNotification == null) {
            return false;
        }
        boolean modified = false;
        if (!adminNotification.isValid()) {
            adminNotification.newInstance(this);
            modified = true;
        }
        if (Manager.isSystemAdmin(this.semAdmin)) {
            modified |= adminNotification.setLoginNotification(isAuthFailureNotification, isLoginNotificationMonitorAllDomains, listAuthFailureNotification);
            modified |= adminNotification.setSystemNotification(isSysEventNotification, listSysEvent);
        }
        modified |= adminNotification.setDailyReportSubscription(isDailyReport);
        modified |= adminNotification.setWeeklyReportSubscription(isWeeklyReport);
        modified |= adminNotification.setSecurityAlertNotification(isSecurityAlertNotification, isSecurityAlertNotificationMonitorAllGroups, listSecurityAlertNotification);
        modified |= adminNotification.setLearnedAppNotification(isLearnedAppNotification, isLearnedAppNotificationMonitorAllGroups, listLearnedAppNotification);
        modified |= adminNotification.setClientGroupChangeNotification(isClientGroupChangeNotification, isClientGroupChangeNotificationMonitorAllGroups, listClientGroupChangeNotification);
        modified |= adminNotification.setMessageFlowControl(messageFlowControlMode, messageFlowControlDelay);
        modified |= adminNotification.setAllAlertUseSameGroup(isAllAlertUseSameGroup);
        modified |= adminNotification.setMonitorAllGroup(sameGroupMonitorAllGroup);
        modified |= adminNotification.setAllAlertUseSameGroupNotificationList(listSameGroupNotification);
        return modified |= adminNotification.setSendToSpecificRecipient(isSendToSpecificRecipient, to, cc);
    }

    public AdminPreferenceObject getAdminPreferenceObject() {
        if (this.semAdmin == null) {
            return null;
        }
        AdminPreference pref = this.semAdmin.getOptAdminPreference();
        if (pref == null) {
            return AdminPreferenceObject.newInstance(this.semAdmin);
        }
        return new AdminPreferenceObject(pref);
    }

    public void setAdminPreferenceObject(AdminPreferenceObject pref) {
        if (pref != null && this.semAdmin != null) {
            this.semAdmin.setOptAdminPreference(pref.getAdminPreference());
        }
    }

    public boolean isAdminAdminFirstLogin() throws ConsoleException {
        return "admin".equalsIgnoreCase(this.getAdminName()) && this.retrieveState().getLastLogoffTime() == -1L;
    }

    public boolean isNameDirty() {
        return this.nameDirty;
    }

    public void setNameDirty(boolean nameDirty) {
        this.nameDirty = nameDirty;
    }

    public void setNameDirty(String newName) {
        if (newName == null) {
            return;
        }
        if (!newName.equalsIgnoreCase(this.getName())) {
            this.setNameDirty(true);
        }
    }

    public boolean hasNeverExpiringPwd() {
        return this.getPasswordAge() < 0;
    }

    public int getPasswordAge() {
        if (this.semAdmin.getOptPasswordAge() != null) {
            return this.semAdmin.getOptPasswordAge();
        }
        return this.semAdmin.getDefPasswordAge();
    }

    public boolean setPasswordAge(Integer age) {
        if (this.isEquals(this.semAdmin.getOptPasswordAge(), age)) {
            return false;
        }
        this.semAdmin.setOptPasswordAge(age);
        return true;
    }

    private boolean isEquals(Integer value1, Integer value2) {
        if (value1 == null) {
            return value2 == null;
        }
        return value1.equals(value2);
    }

    public boolean setNeverExpiringPwd() {
        if (this.hasNeverExpiringPwd()) {
            return false;
        }
        this.semAdmin.setOptPasswordAge(Integer.valueOf(-1));
        return true;
    }

    public String getAdminViewedVersion() {
        return this.semAdmin == null ? null : this.semAdmin.getOptLastViewedVersion();
    }

    public void setAdminViewedVersion(String version) {
        if (null == this.semAdmin) {
            return;
        }
        this.semAdmin.setOptLastViewedVersion(version);
    }

    public static enum AdminType {
        SYS_ADMIN,
        DOMAIN_ADMIN,
        LIMITED_ADMIN;

    }
}

