/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.AdminPayload;
import com.sygate.scm.common.configobject.schema.ClientGroupChangeNotification;
import com.sygate.scm.common.configobject.schema.DomainId;
import com.sygate.scm.common.configobject.schema.GroupId;
import com.sygate.scm.common.configobject.schema.LearnedAppNotification;
import com.sygate.scm.common.configobject.schema.LoginNotification;
import com.sygate.scm.common.configobject.schema.MessageFlowControl;
import com.sygate.scm.common.configobject.schema.ReportSubscription;
import com.sygate.scm.common.configobject.schema.SecurityAlertNotification;
import com.sygate.scm.common.configobject.schema.SemAdminNotification;
import com.sygate.scm.common.configobject.schema.SystemNotification;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.IntegerSet;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;

public class AdminNotificationObject {
    public static final String MSGFLOWCONTROL_AUTO = "AUTO";
    public static final String MSGFLOWCONTROL_MANUAL = "MANUAL";
    public static final String[] FMSGFLOWCONTROL_DELAY_LABEL = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminNotificationObject.lb10Mins"), MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminNotificationObject.lb20Mins"), MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminNotificationObject.lb30Mins"), MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminNotificationObject.lb1Hour"), MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminNotificationObject.lb15Hours"), MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminNotificationObject.lb2Hours"), MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminNotificationObject.lb3Hours"), MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminNotificationObject.lb5Hours"), MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminNotificationObject.lb10Hours")};
    public static final int[] FMSGFLOWCONTROL_DELAY_VALUE = new int[]{600, 1200, 1800, 3600, 5400, 7200, 10800, 18000, 36000};
    private SemAdminNotification semAdminNotification = null;

    public AdminNotificationObject(SemAdminNotification semAdminNotification) {
        this.semAdminNotification = semAdminNotification;
    }

    public boolean newInstance(AdminObject admin) {
        AdminPayload adminPayLoad = admin.getSemAdmin().getAdminPayload();
        if (adminPayLoad == null) {
            System.out.println("AdminNotificationObject>> newInstance: Error-> failed to retrieve AdminPayload.  admin=" + admin.getName() + ", " + admin.getId());
            return false;
        }
        this.semAdminNotification = new SemAdminNotification();
        adminPayLoad.setOptSemAdminNotification(this.semAdminNotification);
        return true;
    }

    public static String getSysEventAll() {
        return AdminNotificationObject.getSysEventServer() + "," + AdminNotificationObject.getSysEventEnforce() + "," + AdminNotificationObject.getSysEventReplication() + "," + AdminNotificationObject.getSysEventBackup() + "," + AdminNotificationObject.getSysEventSystem();
    }

    public static String getSysEventServer() {
        return "0x101,0x102,0x103,0x104,0x105,0x106,0x107,0x108,0x109,0x10a,0x10b,0x10c,0x10d,0x10f";
    }

    public static String getSysEventEnforce() {
        return "0x200";
    }

    public static String getSysEventReplication() {
        return "0x302,0x303,0x305,0x306,0x307,0x309,0x30c,0x30d";
    }

    public static String getSysEventBackup() {
        return "0x401,0x402,0x403,0x404,0x405,0x406";
    }

    public static String getSysEventSystem() {
        return "0x501,0x502,0x503,0x504,0x505";
    }

    public SemAdminNotification getSemAdminNotification() {
        return this.semAdminNotification;
    }

    public boolean isValid() {
        return this.semAdminNotification != null;
    }

    public boolean isLoginNotificationMonitorAllDomains() {
        if (this.semAdminNotification == null) {
            return true;
        }
        LoginNotification loginNotification = this.semAdminNotification.getOptLoginNotification();
        if (loginNotification == null) {
            return true;
        }
        return loginNotification.getOptMonitorAllDomains();
    }

    public boolean setLoginNotification(boolean isLoginNotification, boolean isMonitorAllDomains, ArrayList<String> list) {
        if (this.semAdminNotification == null) {
            return false;
        }
        boolean modified = false;
        LoginNotification loginNotification = this.semAdminNotification.getOptLoginNotification();
        if (loginNotification == null) {
            loginNotification = new LoginNotification();
            this.semAdminNotification.setOptLoginNotification(loginNotification);
            modified = true;
        } else {
            for (DomainId id : loginNotification.getDomainId()) {
                if (id == null) continue;
                id.getParent().removeChild((AbstractSchema)id);
                loginNotification.removeDomainId(id);
            }
        }
        loginNotification.setOptEnabled(Boolean.valueOf(isLoginNotification));
        loginNotification.setOptMonitorAllDomains(Boolean.valueOf(isMonitorAllDomains));
        if (!isMonitorAllDomains) {
            for (int i = 0; i < list.size(); ++i) {
                String strId = list.get(i);
                if (strId == null || strId.length() == 0) continue;
                DomainId id = new DomainId();
                id.setContent(strId);
                loginNotification.addDomainId(id);
            }
        }
        modified = true;
        return modified;
    }

    public boolean setDailyReportSubscription(boolean daily) {
        if (this.semAdminNotification == null) {
            return false;
        }
        if (this.semAdminNotification.getOptReportSubscription() == null) {
            this.semAdminNotification.setOptReportSubscription(new ReportSubscription());
        }
        this.semAdminNotification.getOptReportSubscription().setOptSubscribeToDailyReport(Boolean.valueOf(daily));
        return true;
    }

    public boolean isDailyReportEnabled() {
        if (this.semAdminNotification == null) {
            return false;
        }
        if (this.semAdminNotification.getOptReportSubscription() == null) {
            return false;
        }
        return this.semAdminNotification.getOptReportSubscription().getOptSubscribeToDailyReport();
    }

    public boolean setWeeklyReportSubscription(boolean weekly) {
        if (this.semAdminNotification == null) {
            return false;
        }
        if (this.semAdminNotification.getOptReportSubscription() == null) {
            this.semAdminNotification.setOptReportSubscription(new ReportSubscription());
        }
        this.semAdminNotification.getOptReportSubscription().setOptSubscribeToWeeklyReport(Boolean.valueOf(weekly));
        return true;
    }

    public boolean isWeeklyReportEnabled() {
        if (this.semAdminNotification == null) {
            return false;
        }
        if (this.semAdminNotification.getOptReportSubscription() == null) {
            return false;
        }
        return this.semAdminNotification.getOptReportSubscription().getOptSubscribeToWeeklyReport();
    }

    public boolean isLoginNotificationEnabled() {
        if (this.semAdminNotification == null) {
            return false;
        }
        LoginNotification loginNotification = this.semAdminNotification.getOptLoginNotification();
        if (loginNotification == null) {
            return false;
        }
        if (loginNotification.getOptEnabled() == null) {
            return loginNotification.getDefEnabled();
        }
        return loginNotification.getOptEnabled();
    }

    public String[] getLoginNotificationDomains() {
        if (this.semAdminNotification == null) {
            return new String[0];
        }
        LoginNotification loginNotification = this.semAdminNotification.getOptLoginNotification();
        if (loginNotification == null) {
            return new String[0];
        }
        int count = loginNotification.getDomainIdCount();
        String[] list = new String[count];
        for (int i = 0; i < count; ++i) {
            String id_str;
            DomainId id = loginNotification.getDomainId(i);
            list[i] = id == null ? "" : ((id_str = id.getContent()) == null || id_str.length() == 0 ? "" : id_str);
        }
        return list;
    }

    public ArrayList<String> getLoginNotificationList() {
        if (this.semAdminNotification == null) {
            return new ArrayList<String>(0);
        }
        LoginNotification loginNotification = this.semAdminNotification.getOptLoginNotification();
        if (loginNotification == null) {
            return new ArrayList<String>(0);
        }
        int count = loginNotification.getDomainIdCount();
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String id_str;
            DomainId id = loginNotification.getDomainId(i);
            if (id == null || (id_str = id.getContent()) == null || id_str.length() == 0) continue;
            list.add(id_str);
        }
        return list;
    }

    public boolean setSystemNotification(boolean isSystemNotification, String value) {
        if (this.semAdminNotification == null) {
            return false;
        }
        boolean modified = false;
        SystemNotification systemNotification = this.semAdminNotification.getOptSystemNotification();
        if (systemNotification == null) {
            systemNotification = new SystemNotification();
            this.semAdminNotification.setOptSystemNotification(systemNotification);
            modified = true;
        }
        systemNotification.setOptEnabled(Boolean.valueOf(isSystemNotification));
        systemNotification.setEventList(value);
        modified = true;
        return modified;
    }

    public boolean isSystemNotificationEnabled() {
        if (this.semAdminNotification == null) {
            return false;
        }
        SystemNotification systemNotification = this.semAdminNotification.getOptSystemNotification();
        if (systemNotification == null) {
            return false;
        }
        if (systemNotification.getOptEnabled() == null) {
            return systemNotification.getDefEnabled();
        }
        return systemNotification.getOptEnabled();
    }

    public String getSystemNotificationEventList() {
        if (this.semAdminNotification == null) {
            return "";
        }
        SystemNotification systemNotification = this.semAdminNotification.getOptSystemNotification();
        if (systemNotification == null) {
            return "";
        }
        return systemNotification.getEventList();
    }

    public IntegerSet getSystemNotificationEvents() {
        IntegerSet is = new IntegerSet();
        String events = this.getSystemNotificationEventList();
        if (events == null || events.length() == 0) {
            return is;
        }
        try {
            is.init(events, 16);
        }
        catch (BadFormatException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return is;
    }

    public boolean isSecurityAlertNotificationMonitorAllGroups() {
        if (this.semAdminNotification == null) {
            return true;
        }
        SecurityAlertNotification securityAlertNotification = this.semAdminNotification.getOptSecurityAlertNotification();
        if (securityAlertNotification == null || securityAlertNotification.getOptMonitorAllGroups() == null) {
            return true;
        }
        return securityAlertNotification.getOptMonitorAllGroups();
    }

    public boolean setSecurityAlertNotification(boolean isSecurityAlertNotification, boolean isMonitorAllGroups, ArrayList<String> list) {
        if (this.semAdminNotification == null) {
            return false;
        }
        boolean modified = false;
        SecurityAlertNotification securityAlertNotification = this.semAdminNotification.getOptSecurityAlertNotification();
        if (securityAlertNotification == null) {
            securityAlertNotification = new SecurityAlertNotification();
            this.semAdminNotification.setOptSecurityAlertNotification(securityAlertNotification);
            modified = true;
        } else {
            for (GroupId id : securityAlertNotification.getGroupId()) {
                if (id == null) continue;
                id.getParent().removeChild((AbstractSchema)id);
                securityAlertNotification.removeGroupId(id);
            }
        }
        securityAlertNotification.setOptEnabled(Boolean.valueOf(isSecurityAlertNotification));
        securityAlertNotification.setOptMonitorAllGroups(Boolean.valueOf(isMonitorAllGroups));
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String strId = list.get(i);
                if (strId == null || strId.length() == 0) continue;
                GroupId id = new GroupId();
                id.setOptContent(strId);
                securityAlertNotification.addGroupId(id);
            }
        }
        modified = true;
        return modified;
    }

    public boolean isSecurityAlertNotificationEnabled() {
        if (this.semAdminNotification == null) {
            return false;
        }
        SecurityAlertNotification securityAlertNotification = this.semAdminNotification.getOptSecurityAlertNotification();
        if (securityAlertNotification == null) {
            return false;
        }
        if (securityAlertNotification.getOptEnabled() == null) {
            return securityAlertNotification.getDefEnabled();
        }
        return securityAlertNotification.getOptEnabled();
    }

    public String[] getSecurityAlertNotificationGroups() {
        if (this.semAdminNotification == null) {
            return new String[0];
        }
        SecurityAlertNotification securityAlertNotification = this.semAdminNotification.getOptSecurityAlertNotification();
        if (securityAlertNotification == null) {
            return new String[0];
        }
        int count = securityAlertNotification.getGroupIdCount();
        String[] list = new String[count];
        for (int i = 0; i < count; ++i) {
            String gid_str;
            GroupId gid = securityAlertNotification.getGroupId(i);
            list[i] = gid == null ? "" : ((gid_str = gid.getOptContent()) == null || gid_str.length() == 0 ? "" : gid_str);
        }
        return list;
    }

    public ArrayList<String> getSecurityAlertNotificationList() {
        if (this.semAdminNotification == null) {
            return new ArrayList<String>(0);
        }
        SecurityAlertNotification securityAlertNotification = this.semAdminNotification.getOptSecurityAlertNotification();
        if (securityAlertNotification == null) {
            return new ArrayList<String>(0);
        }
        int count = securityAlertNotification.getGroupIdCount();
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String gid_str;
            GroupId gid = securityAlertNotification.getGroupId(i);
            if (gid == null || (gid_str = gid.getOptContent()) == null || gid_str.length() == 0) continue;
            list.add(gid_str);
        }
        return list;
    }

    public boolean isLearnedAppNotificationMonitorAllGroups() {
        if (this.semAdminNotification == null) {
            return true;
        }
        LearnedAppNotification learnedAppNotification = this.semAdminNotification.getOptLearnedAppNotification();
        if (learnedAppNotification == null || learnedAppNotification.getOptMonitorAllGroups() == null) {
            return true;
        }
        return learnedAppNotification.getOptMonitorAllGroups();
    }

    public boolean setLearnedAppNotification(boolean isLearnedAppNotification, boolean isMonitorAllGroups, ArrayList<String> list) {
        if (this.semAdminNotification == null) {
            return false;
        }
        boolean modified = false;
        LearnedAppNotification learnedAppNotification = this.semAdminNotification.getOptLearnedAppNotification();
        if (learnedAppNotification == null) {
            learnedAppNotification = new LearnedAppNotification();
            this.semAdminNotification.setOptLearnedAppNotification(learnedAppNotification);
            modified = true;
        } else {
            for (GroupId id : learnedAppNotification.getGroupId()) {
                if (id == null) continue;
                id.getParent().removeChild((AbstractSchema)id);
                learnedAppNotification.removeGroupId(id);
            }
        }
        learnedAppNotification.setOptEnabled(Boolean.valueOf(isLearnedAppNotification));
        learnedAppNotification.setOptMonitorAllGroups(Boolean.valueOf(isMonitorAllGroups));
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String strId = list.get(i);
                if (strId == null || strId.length() == 0) continue;
                GroupId id = new GroupId();
                id.setOptContent(strId);
                learnedAppNotification.addGroupId(id);
            }
        }
        modified = true;
        return modified;
    }

    public boolean isLearnedAppNotificationEnabled() {
        if (this.semAdminNotification == null) {
            return false;
        }
        LearnedAppNotification learnedAppNotification = this.semAdminNotification.getOptLearnedAppNotification();
        if (learnedAppNotification == null) {
            return false;
        }
        if (learnedAppNotification.getOptEnabled() == null) {
            return learnedAppNotification.getDefEnabled();
        }
        return learnedAppNotification.getOptEnabled();
    }

    public String[] getLearnedAppNotificationGroups() {
        if (this.semAdminNotification == null) {
            return new String[0];
        }
        LearnedAppNotification learnedAppNotification = this.semAdminNotification.getOptLearnedAppNotification();
        if (learnedAppNotification == null) {
            return new String[0];
        }
        int count = learnedAppNotification.getGroupIdCount();
        String[] list = new String[count];
        for (int i = 0; i < count; ++i) {
            String gid_str;
            GroupId gid = learnedAppNotification.getGroupId(i);
            list[i] = gid == null ? "" : ((gid_str = gid.getOptContent()) == null || gid_str.length() == 0 ? "" : gid_str);
        }
        return list;
    }

    public ArrayList<String> getLearnedAppNotificationList() {
        if (this.semAdminNotification == null) {
            return new ArrayList<String>(0);
        }
        LearnedAppNotification learnedAppNotification = this.semAdminNotification.getOptLearnedAppNotification();
        if (learnedAppNotification == null) {
            return new ArrayList<String>(0);
        }
        int count = learnedAppNotification.getGroupIdCount();
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String gid_str;
            GroupId gid = learnedAppNotification.getGroupId(i);
            if (gid == null || (gid_str = gid.getOptContent()) == null || gid_str.length() == 0) continue;
            list.add(gid_str);
        }
        return list;
    }

    public boolean isClientGroupChangeNotificationMonitorAllGroups() {
        if (this.semAdminNotification == null) {
            return true;
        }
        ClientGroupChangeNotification clientGroupChangeNotification = this.semAdminNotification.getOptClientGroupChangeNotification();
        if (clientGroupChangeNotification == null || clientGroupChangeNotification.getOptMonitorAllGroups() == null) {
            return true;
        }
        return clientGroupChangeNotification.getOptMonitorAllGroups();
    }

    public boolean setClientGroupChangeNotification(boolean isClientGroupChangeNotification, boolean isMonitorAllGroups, ArrayList<String> list) {
        if (this.semAdminNotification == null) {
            return false;
        }
        boolean modified = false;
        ClientGroupChangeNotification clientGroupChangeNotification = this.semAdminNotification.getOptClientGroupChangeNotification();
        if (clientGroupChangeNotification == null) {
            clientGroupChangeNotification = new ClientGroupChangeNotification();
            this.semAdminNotification.setOptClientGroupChangeNotification(clientGroupChangeNotification);
            modified = true;
        } else {
            for (GroupId id : clientGroupChangeNotification.getGroupId()) {
                if (id == null) continue;
                id.getParent().removeChild((AbstractSchema)id);
                clientGroupChangeNotification.removeGroupId(id);
            }
        }
        clientGroupChangeNotification.setOptEnabled(Boolean.valueOf(isClientGroupChangeNotification));
        clientGroupChangeNotification.setOptMonitorAllGroups(Boolean.valueOf(isMonitorAllGroups));
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String strId = list.get(i);
                if (strId == null || strId.length() == 0) continue;
                GroupId id = new GroupId();
                id.setOptContent(strId);
                clientGroupChangeNotification.addGroupId(id);
            }
        }
        modified = true;
        return modified;
    }

    public boolean isClientGroupChangeNotificationEnabled() {
        if (this.semAdminNotification == null) {
            return false;
        }
        ClientGroupChangeNotification clientGroupChangeNotification = this.semAdminNotification.getOptClientGroupChangeNotification();
        if (clientGroupChangeNotification == null) {
            return false;
        }
        if (clientGroupChangeNotification.getOptEnabled() == null) {
            return clientGroupChangeNotification.getDefEnabled();
        }
        return clientGroupChangeNotification.getOptEnabled();
    }

    public String[] getClientGroupChangeNotificationGroups() {
        if (this.semAdminNotification == null) {
            return new String[0];
        }
        ClientGroupChangeNotification clientGroupChangeNotification = this.semAdminNotification.getOptClientGroupChangeNotification();
        if (clientGroupChangeNotification == null) {
            return new String[0];
        }
        int count = clientGroupChangeNotification.getGroupIdCount();
        String[] list = new String[count];
        for (int i = 0; i < count; ++i) {
            String gid_str;
            GroupId gid = clientGroupChangeNotification.getGroupId(i);
            list[i] = gid == null ? "" : ((gid_str = gid.getOptContent()) == null || gid_str.length() == 0 ? "" : gid_str);
        }
        return list;
    }

    public ArrayList<String> getClientGroupChangeNotificationList() {
        if (this.semAdminNotification == null) {
            return new ArrayList<String>(0);
        }
        ClientGroupChangeNotification clientGroupChangeNotification = this.semAdminNotification.getOptClientGroupChangeNotification();
        if (clientGroupChangeNotification == null) {
            return new ArrayList<String>(0);
        }
        int count = clientGroupChangeNotification.getGroupIdCount();
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String gid_str;
            GroupId gid = clientGroupChangeNotification.getGroupId(i);
            if (gid == null || (gid_str = gid.getOptContent()) == null || gid_str.length() == 0) continue;
            list.add(gid_str);
        }
        return list;
    }

    public boolean isMessageFlowControlAuto() {
        return MessageFlowControl.AUTO.intValue() == this.getMessageFlowControlMode();
    }

    public int getMessageFlowControlMode() {
        if (this.semAdminNotification == null) {
            return MessageFlowControl.AUTO;
        }
        MessageFlowControl messageFlowControl = this.semAdminNotification.getOptMessageFlowControl();
        if (messageFlowControl == null) {
            return MessageFlowControl.AUTO;
        }
        return messageFlowControl.getMode();
    }

    public boolean setMessageFlowControl(int mode, int delay) {
        if (this.semAdminNotification == null) {
            return false;
        }
        boolean modified = false;
        MessageFlowControl messageFlowControl = this.semAdminNotification.getOptMessageFlowControl();
        if (messageFlowControl == null) {
            messageFlowControl = new MessageFlowControl();
            messageFlowControl.setMode(MessageFlowControl.AUTO);
            messageFlowControl.setOptMessageDelay(messageFlowControl.getDefMessageDelay());
            this.semAdminNotification.setOptMessageFlowControl(messageFlowControl);
            modified = true;
        }
        if (mode != messageFlowControl.getMode()) {
            messageFlowControl.setMode(Integer.valueOf(mode));
            modified = true;
        }
        if (messageFlowControl.getOptMessageDelay() == null || delay != messageFlowControl.getOptMessageDelay()) {
            messageFlowControl.setOptMessageDelay(Integer.valueOf(delay));
            modified = true;
        }
        return modified;
    }

    public int getMessageFlowControlDelay() {
        if (this.semAdminNotification == null) {
            return 3600;
        }
        MessageFlowControl messageFlowControl = this.semAdminNotification.getOptMessageFlowControl();
        if (messageFlowControl == null || messageFlowControl.getOptMessageDelay() == null) {
            return 3600;
        }
        return messageFlowControl.getOptMessageDelay();
    }

    public boolean setAllAlertUseSameGroup(boolean isAllAlertUseSameGroup) {
        if (this.semAdminNotification == null) {
            return false;
        }
        if (this.semAdminNotification.getOptAllAlertUseSameGroup() != null && this.semAdminNotification.getOptAllAlertUseSameGroup() == isAllAlertUseSameGroup) {
            return false;
        }
        this.semAdminNotification.setOptAllAlertUseSameGroup(Boolean.valueOf(isAllAlertUseSameGroup));
        return true;
    }

    public boolean doesAllAlertUseSameGroup() {
        if (this.semAdminNotification == null || this.semAdminNotification.getOptAllAlertUseSameGroup() == null) {
            return false;
        }
        return this.semAdminNotification.getOptAllAlertUseSameGroup();
    }

    public boolean setMonitorAllGroup(boolean isMonitorAllGroup) {
        if (this.semAdminNotification == null) {
            return false;
        }
        Boolean monitorAllGroup = this.semAdminNotification.getOptMonitorAllGroups();
        if (monitorAllGroup != null && monitorAllGroup == isMonitorAllGroup) {
            return false;
        }
        this.semAdminNotification.setOptMonitorAllGroups(Boolean.valueOf(isMonitorAllGroup));
        return true;
    }

    public boolean isMonitorAllGroup() {
        if (this.semAdminNotification == null || this.semAdminNotification.getOptMonitorAllGroups() == null) {
            return true;
        }
        return this.semAdminNotification.getOptMonitorAllGroups();
    }

    public boolean setAllAlertUseSameGroupNotificationList(ArrayList<String> list) {
        if (this.semAdminNotification == null) {
            return false;
        }
        for (GroupId id : this.semAdminNotification.getGroupId()) {
            if (id == null) continue;
            id.getParent().removeChild((AbstractSchema)id);
            this.semAdminNotification.removeGroupId(id);
        }
        for (int i = 0; i < list.size(); ++i) {
            String strId = list.get(i);
            if (strId == null || strId.length() == 0) continue;
            GroupId id = new GroupId();
            id.setOptContent(strId);
            this.semAdminNotification.addGroupId(id);
        }
        return true;
    }

    public String[] getAllAlertUseSameGroupNotificationGroups() {
        if (this.semAdminNotification == null) {
            return new String[0];
        }
        int count = this.semAdminNotification.getGroupIdCount();
        String[] list = new String[count];
        for (int i = 0; i < count; ++i) {
            String gid_str;
            GroupId gid = this.semAdminNotification.getGroupId(i);
            list[i] = gid == null ? "" : ((gid_str = gid.getOptContent()) == null || gid_str.length() == 0 ? "" : gid_str);
        }
        return list;
    }

    public ArrayList<String> getAllAlertUseSameGroupNotificationList() {
        if (this.semAdminNotification == null) {
            return new ArrayList<String>(0);
        }
        int count = this.semAdminNotification.getGroupIdCount();
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String gid_str;
            GroupId gid = this.semAdminNotification.getGroupId(i);
            if (gid == null || (gid_str = gid.getOptContent()) == null || gid_str.length() == 0) continue;
            list.add(gid_str);
        }
        return list;
    }

    public boolean setSendToSpecificRecipient(boolean isSendToSpecificRecipient, String to, String cc) {
        if (this.semAdminNotification == null) {
            return false;
        }
        boolean modified = false;
        if (this.semAdminNotification.getOptSendToSpecificRecipient() == null || this.semAdminNotification.getOptSendToSpecificRecipient() != isSendToSpecificRecipient) {
            this.semAdminNotification.setOptSendToSpecificRecipient(Boolean.valueOf(isSendToSpecificRecipient));
            modified = true;
        }
        if (to != null && !to.equals(this.semAdminNotification.getOptSpecificToAddress())) {
            this.semAdminNotification.setOptSpecificToAddress(to);
            modified = true;
        }
        if (cc != null && !cc.equals(this.semAdminNotification.getOptSpecificCcAddress())) {
            this.semAdminNotification.setOptSpecificCcAddress(cc);
            modified = true;
        }
        return modified;
    }

    public boolean doesSendToSpecificRecipient() {
        if (this.semAdminNotification == null || this.semAdminNotification.getOptSendToSpecificRecipient() == null) {
            return false;
        }
        return this.semAdminNotification.getOptSendToSpecificRecipient();
    }

    public String getSpecificCcAddress() {
        if (this.semAdminNotification == null) {
            return "";
        }
        return this.semAdminNotification.getOptSpecificCcAddress();
    }

    public String getSpecificToAddress() {
        if (this.semAdminNotification == null) {
            return "";
        }
        return this.semAdminNotification.getOptSpecificToAddress();
    }
}

