/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.DnsHost;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroup;
import com.sygate.scm.common.configobject.schema.HostName;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import com.sygate.scm.common.configobject.schema.Ipv6Range;
import com.sygate.scm.common.configobject.schema.Ipv6SubNet;
import com.sygate.scm.common.configobject.schema.MacAddress;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleAssertion;
import com.sygate.scm.console.util.ConsoleException;

public class AddressObject
extends AbstractUIObject
implements TableRow {
    public static final int TYPE_IP = 0;
    public static final int TYPE_IPRANGE = 1;
    public static final int TYPE_SUBNET = 2;
    public static final int TYPE_MAC = 3;
    public static final int TYPE_HOSTNAME = 4;
    public static final int TYPE_HOST_GROUP = 5;
    public static final int TYPE_ICMP_HOST = 6;
    public static final int TYPE_IPV6_IP = 7;
    public static final int TYPE_IPV6_IPRANGE = 8;
    public static final int TYPE_IPV6_SUBNET = 9;
    private ConfigObject _address;
    private int addressType;
    private String Name = null;

    public AddressObject() {
    }

    public AddressObject(int type, ConfigObject obj) {
        this.addressType = type;
        this._address = obj;
    }

    public AddressObject(int type) {
        this.addressType = type;
        switch (this.addressType) {
            case 0: {
                this._address = new IpAddress();
                break;
            }
            case 1: {
                this._address = new IpRange();
                break;
            }
            case 2: {
                this._address = new SubNet();
                break;
            }
            case 3: {
                this._address = new MacAddress();
                break;
            }
            case 4: {
                this._address = new HostName();
                break;
            }
            case 5: {
                this._address = new FwNetworkHostGroup();
                break;
            }
            case 6: {
                this._address = new DnsHost();
                break;
            }
            case 7: {
                this._address = new Ipv6Address();
                break;
            }
            case 8: {
                this._address = new Ipv6Range();
                break;
            }
            case 9: {
                this._address = new Ipv6SubNet();
                break;
            }
            default: {
                ConsoleAssertion.runAssert(true, "Wrong type:" + this.addressType);
            }
        }
    }

    public int getType() {
        return this.addressType;
    }

    public String getTypeDesc() {
        switch (this.addressType) {
            case 0: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AddressObject.tableIPAddress");
            }
            case 1: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AddressObject.tableIPRange");
            }
            case 2: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AddressObject.tableSubNet");
            }
            case 3: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AddressObject.tableMACAddress");
            }
            case 4: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AddressObject.tableHostName");
            }
            case 5: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AddressObject.tableHostGroup");
            }
            case 6: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AddressOjbect.ICMPHostName");
            }
            case 7: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AddressObject.tableIPv6Address");
            }
            case 8: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AddressObject.tableIPv6IPRange");
            }
            case 9: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AddressObject.tableIPv6SubNet");
            }
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AddressObject.tableUnknown");
    }

    public void setType(int newType) {
        if (this.addressType != newType) {
            this.addressType = newType;
            switch (this.addressType) {
                case 0: {
                    this._address = new IpAddress();
                    break;
                }
                case 1: {
                    this._address = new IpRange();
                    break;
                }
                case 2: {
                    this._address = new SubNet();
                    break;
                }
                case 3: {
                    this._address = new MacAddress();
                    break;
                }
                case 4: {
                    this._address = new HostName();
                    break;
                }
                case 5: {
                    this._address = new FwNetworkHostGroup();
                    break;
                }
                case 6: {
                    this._address = new DnsHost();
                    break;
                }
                case 7: {
                    this._address = new Ipv6Address();
                    break;
                }
                case 8: {
                    this._address = new Ipv6Range();
                    break;
                }
                case 9: {
                    this._address = new Ipv6SubNet();
                    break;
                }
                default: {
                    ConsoleAssertion.runAssert(true, "Wrong type:" + this.addressType);
                }
            }
        }
    }

    public String getContent() {
        switch (this.addressType) {
            case 0: {
                IpAddress ip = (IpAddress)this._address;
                return ip.getContent();
            }
            case 1: {
                IpRange range = (IpRange)this._address;
                return range.getStart() + " -- " + range.getEnd();
            }
            case 2: {
                SubNet subnet = (SubNet)this._address;
                return "IP:" + subnet.getNetAddr() + "; Mask:" + subnet.getNetMask();
            }
            case 3: {
                MacAddress mac = (MacAddress)this._address;
                return mac.getContent();
            }
            case 4: {
                HostName hostname = (HostName)this._address;
                return hostname.getContent();
            }
            case 5: {
                FwNetworkHostGroup hostgroup = (FwNetworkHostGroup)this._address;
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AddressObject.hostGroupName") + hostgroup.getName();
            }
            case 6: {
                DnsHost host = (DnsHost)this._address;
                return host.getContent();
            }
            case 7: {
                Ipv6Address ipv6Address = (Ipv6Address)this._address;
                return ipv6Address.getContent();
            }
            case 8: {
                Ipv6Range ipv6Range = (Ipv6Range)this._address;
                return ipv6Range.getStart() + " -- " + ipv6Range.getEnd();
            }
            case 9: {
                Ipv6SubNet ipv6SubNet = (Ipv6SubNet)this._address;
                return ipv6SubNet.getContent();
            }
        }
        return "Unknown";
    }

    public String getICMPHostName() {
        String name;
        if (this.addressType == 6 && !Utilities.isStrNullOrEmpty(name = ((DnsHost)this._address).getContent())) {
            return name;
        }
        return "";
    }

    public void setICMPHostName(String hostName) {
        if (this.addressType == 6) {
            DnsHost host = (DnsHost)this._address;
            host.setContent(hostName);
        }
    }

    public String getIP() {
        if (this.addressType == 0) {
            String ip = ((IpAddress)this._address).getContent();
            return ip == null ? "" : ip;
        }
        if (this.addressType == 7) {
            String ip = ((Ipv6Address)this._address).getContent();
            return ip == null ? "" : ip;
        }
        return "";
    }

    public String getHostName() {
        if (this.addressType == 4) {
            String hostname = ((HostName)this._address).getContent();
            return hostname == null ? "" : hostname;
        }
        return "";
    }

    public String getMACAddress() {
        if (this.addressType == 3) {
            String ip = ((MacAddress)this._address).getContent();
            return ip == null ? "" : ip;
        }
        return "";
    }

    public FwNetworkHostGroup getHostGroup() {
        if (this.addressType == 5) {
            return (FwNetworkHostGroup)this._address;
        }
        return null;
    }

    public String getName() {
        return this.Name;
    }

    public ConfigObject getObject() {
        return this._address;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getTypeDesc();
            }
            case 1: {
                return this.getContent();
            }
            case 2: {
                return this.getName();
            }
        }
        return "";
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    public void setName(String Name) {
        this.Name = Name;
    }

    public void setIPAddress(String ip) {
        if (this.addressType == 0) {
            IpAddress ipAddr = (IpAddress)this._address;
            ipAddr.setContent(ip);
        } else if (this.addressType == 7) {
            Ipv6Address ipv6Address = (Ipv6Address)this._address;
            ipv6Address.setContent(ip);
        }
    }

    public void setHostName(String hostname) {
        if (this.addressType == 4) {
            HostName hostName = (HostName)this._address;
            hostName.setContent(hostname);
        }
    }

    public void setHostGroup(FwNetworkHostGroup group) {
        if (this.addressType == 5) {
            this._address = group;
        }
    }

    public void setMACAddress(String mac) {
        if (this.addressType == 3) {
            MacAddress ipAddr = (MacAddress)this._address;
            ipAddr.setContent(mac);
        }
    }

    public String getStartIP() {
        if (this.addressType == 1) {
            IpRange ipRange = (IpRange)this._address;
            String startIP = ipRange.getStart();
            return startIP;
        }
        if (this.addressType == 8) {
            return ((Ipv6Range)this._address).getStart();
        }
        return "";
    }

    public String getEndIP() {
        if (this.addressType == 1) {
            IpRange ipRange = (IpRange)this._address;
            String endIP = ipRange.getEnd();
            return endIP;
        }
        if (this.addressType == 8) {
            return ((Ipv6Range)this._address).getEnd();
        }
        return "";
    }

    public void setStartIP(String newStart) {
        if (this.addressType == 1) {
            IpRange ipRange = (IpRange)this._address;
            ipRange.setStart(newStart);
        } else if (this.addressType == 8) {
            ((Ipv6Range)this._address).setStart(newStart);
        }
    }

    public void setEndIP(String newEnd) {
        if (this.addressType == 1) {
            IpRange ipRange = (IpRange)this._address;
            ipRange.setEnd(newEnd);
        } else if (this.addressType == 8) {
            ((Ipv6Range)this._address).setEnd(newEnd);
        }
    }

    public String getNetAddr() {
        if (this.addressType == 2) {
            SubNet subnet = (SubNet)this._address;
            String netAddr = subnet.getNetAddr();
            return netAddr;
        }
        if (this.addressType == 9) {
            return ((Ipv6SubNet)this._address).getContent();
        }
        return "";
    }

    public String getNetMask() {
        if (this.addressType == 2) {
            SubNet subnet = (SubNet)this._address;
            String netMask = subnet.getNetMask();
            return netMask;
        }
        return "";
    }

    public void setNetAddr(String networkAddress) {
        if (this.addressType == 2) {
            SubNet subnet = (SubNet)this._address;
            subnet.setNetAddr(networkAddress);
        } else if (this.addressType == 9) {
            ((Ipv6SubNet)this._address).setContent(networkAddress);
        } else {
            ConsoleAssertion.runAssert(true, "Is it SubNet Type:" + this.addressType);
        }
    }

    public void setNetMask(String newEnd) {
        if (this.addressType == 2) {
            SubNet subnet = (SubNet)this._address;
            subnet.setNetMask(newEnd);
        } else {
            ConsoleAssertion.runAssert(true, "Is it SubNet Type:" + this.addressType);
        }
    }

    public AddressObject getClone() throws ConsoleException {
        ConfigObject newAddr = PolicyHandler.getCopyOfObj(this._address);
        AddressObject newObj = new AddressObject(this.addressType, newAddr);
        return newObj;
    }

    public void delete() {
        if (this._address != null) {
            this._address.getParent().removeChild((AbstractSchema)this._address);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("<html>");
        buffer.append("&nbsp;&nbsp;");
        buffer.append(this.getContent());
        buffer.append("</html>");
        return buffer.toString();
    }
}

