/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.help;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.console.handler.LicenseHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseChainObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.MainFrame;
import com.sygate.scm.console.ui.policy.override.logicobject.KnownSecurityUIObject;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.URLUtility;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Cursor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;

public class HelpUtil {
    public static final String CED_URL = "https://ced.broadcom.com/entt?product=sep^&version={0}^&language={1}^&module=console^&error={2}^&build=%2A";
    static final int HELP_UTIL_LOOKUP_MIN = 1;
    public static final Integer HELP_UTIL_URL_contactSupportUrl = 1;
    public static final Integer HELP_UTIL_URL_peerToPeerDiscussionUrl = 2;
    public static final Integer HELP_UTIL_URL_SYMANTEC = 3;
    public static final Integer HELP_UTIL_URL_tourEE = 4;
    public static final Integer HELP_UTIL_URL_footer3LinkURL = 5;
    public static final Integer HELP_UTIL_URL_moreInfoLinkURL = 6;
    public static final Integer HELP_UTIL_URL_SEPNEWSURL = 7;
    public static final Integer HELP_UTIL_URL_showNewFeaturesUrl = 8;
    public static final Integer HELP_UTIL_URL_WSSEntrustInstallCertHelpUrl = 9;
    static final int HELP_UTIL_LOOKUP_MAX = 9;
    private static final MessageResources MSG_RES = MessageResources.getInstance();
    private static final String MSG_RES_FILENAME = "com.sygate.scm.console.help.help";
    private static final Map<Integer, String> map = new HashMap<Integer, String>();

    public static String getCEDHelpUrl(String token) {
        return MessageFormat.format(CED_URL, Env.getSemCedVersion(), Utility.getLanguage(), token);
    }

    public static void showCEDHelpOrErrDlg(String token) {
        try {
            HelpUtil.showURL(HelpUtil.getCEDHelpUrl(token));
        }
        catch (Exception e) {
            HelpUtil.showErrDlg();
        }
    }

    public static void showHelpOrErrDlg(String token) {
        try {
            HelpUtil.showHelp(token);
        }
        catch (Exception ex) {
            HelpUtil.showErrDlg();
        }
    }

    private static void showErrDlg() {
        JOptionPane.showMessageDialog(null, MSG_RES.getString(MSG_RES_FILENAME, "HelpUtil.url.err.text"), MSG_RES.getString(MSG_RES_FILENAME, "HelpUtil.url.err.title"), 0);
    }

    public static void showHelp(String token) {
        HelpUtil.showHelpURL(com.sygate.scm.common.help.HelpUtil.getHelpUrl((String)token));
    }

    public static void showKnownSecurityUIObject(KnownSecurityUIObject rowObject) throws URISyntaxException {
        URI uri = rowObject.getUrl().toURI();
        System.out.println(uri.toString());
        HelpUtil.showURL(uri.toString());
    }

    public static void showPurchaseDynamicLink() {
        String url = HelpUtil.generatePurchaseDynamicLink();
        if (url != null) {
            HelpUtil.showURL(url);
        }
    }

    static String generatePurchaseDynamicLink() {
        String url = LicenseHandler.getPurchaseDynamicLink();
        return url;
    }

    public static void showLicenseRenewal(LicenseChainObject licenses) {
        if (licenses == null) {
            throw new IllegalArgumentException("parameter was null");
        }
        String displayUrl = licenses.getRenewalURL().replaceAll("&", "^&");
        if (displayUrl != null) {
            HelpUtil.showURL(displayUrl);
        }
    }

    public static void showDownloadSupportTool() {
        String url = HelpUtil.generateDownloadSupportToolUrl();
        if (url != null) {
            HelpUtil.showURL(url);
        }
    }

    static String generateDownloadSupportToolUrl() {
        Object[] obj = new Object[]{Env.getSemCedVersion(), Utility.getLanguage()};
        return MessageFormat.format(MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help.downloadSupportToolUrl"), obj);
    }

    public static void showPurchaseAdditionalLicenses() {
        String link = HelpUtil.generatePurchaseAdditionalLicenses();
        if (link != null) {
            HelpUtil.showURL(link);
        }
    }

    static String generatePurchaseAdditionalLicenses() {
        String url = LicenseHandler.getPurchaseDynamicLink();
        String link = Utilities.getLocalizedMessage("LicenseStatusPanel.purchaseLicenseEE", new Object[]{url});
        if (LicenseObject.getInstance().isSBProduct()) {
            link = Utilities.getLocalizedMessage("LicenseStatusPanel.purchaseLicenseSBE", new Object[]{url});
        }
        link = link.replaceAll("&", "^&");
        return link;
    }

    public static void showRemotePushHelp() {
        String urlString = HelpUtil.generateRemotePushHelp();
        if (urlString != null) {
            HelpUtil.showURL(urlString);
        }
    }

    static String generateRemotePushHelp() {
        Object[] obj = new Object[]{ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage()};
        String urlString = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "InstallMethodsPanel.remotePushHelpUrl"), obj);
        return urlString;
    }

    public static void showPurchaseAction() {
        String url = HelpUtil.generatePurchaseAction();
        if (url != null) {
            HelpUtil.showURL(url);
        }
    }

    static String generatePurchaseAction() {
        String url = LicenseHandler.getPurchaseDynamicLink();
        url = Utilities.getLocalizedMessage("LicenseHelpPanel.trial.footer1LinkURLEE", new Object[]{url});
        if (LicenseObject.getInstance().isSBProduct()) {
            url = Utilities.getLocalizedMessage("LicenseHelpPanel.trial.footer1LinkURL", new Object[]{url});
        }
        url = url.replaceAll("&", "^&");
        return url;
    }

    public static void showHelpURL(Integer lookup) {
        if (lookup == null || lookup < 1 || lookup > 9) {
            throw new IllegalArgumentException("help lookup value is null or out of range!");
        }
        Manager.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        HelpUtil.showURL(map.get(lookup));
        Manager.getFrame().setCursor(Cursor.getDefaultCursor());
    }

    public static void showURL(HyperlinkEvent e) {
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            ClientAgent.getCurrentInstance().openInNewTab(e.getURL().toString());
            return;
        }
        Utility.showURL((String)e.getURL().toString());
    }

    public static void showURL(Integer lookup) {
        String url = HelpUtil.generateURL(lookup);
        if (url != null) {
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                ClientAgent.getCurrentInstance().openInNewTab(url.trim().replace("^", ""));
                return;
            }
            Utility.showURL((String)url);
        }
    }

    static String generateURL(Integer lookup) {
        if (lookup == null || lookup < 1 || lookup > 9) {
            throw new IllegalArgumentException("help lookup value is null or out of range!");
        }
        String url = map.get(lookup);
        return url;
    }

    public static String getContentSensitiveHelpToken(Component component) {
        Component view;
        if (component instanceof ContentSensitiveHelpPage) {
            return ((ContentSensitiveHelpPage)((Object)component)).getContentSensitiveHelpToken();
        }
        if (component instanceof JScrollPane && (view = ((JScrollPane)component).getViewport().getView()) instanceof ContentSensitiveHelpPage) {
            return ((ContentSensitiveHelpPage)((Object)view)).getContentSensitiveHelpToken();
        }
        return null;
    }

    private static void showURL(String url) {
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            ClientAgent.getCurrentInstance().openInNewTab(url.trim().replace("^", ""));
            return;
        }
        if (url != null) {
            Utility.showURL((String)url);
        }
    }

    private static void showHelpURL(String url) {
        MainFrame frame = Manager.getFrame();
        if (null != frame) {
            frame.setCursor(Cursor.getPredefinedCursor(3));
        }
        url = url.trim();
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            ClientAgent.getCurrentInstance().openInNewTab(url);
            return;
        }
        try {
            int urlRet = URLUtility.browseURI((String)url);
            if (urlRet == 1 || urlRet == 3 || urlRet == 2) {
                String[] cmd = new String[]{"cmd", "/c", "start", url.replace("&", "^&")};
                Runtime.getRuntime().exec(cmd);
            }
        }
        catch (IOException e) {
            ConsoleLogger.log(e);
        }
        if (null != frame) {
            frame.setCursor(Cursor.getDefaultCursor());
        }
    }

    static {
        Object[] obj = new Object[]{Env.getSemCedVersion(), Utility.getLanguage()};
        String strUrl = MessageFormat.format(MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help.contactSupportUrl"), obj);
        map.put(HELP_UTIL_URL_contactSupportUrl, strUrl);
        map.put(HELP_UTIL_URL_peerToPeerDiscussionUrl, MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help.peerToPeerDiscussionUrl"));
        map.put(HELP_UTIL_URL_SYMANTEC, "http://www.symantec.com");
        String localizedSepEEtourUrl = MessageFormat.format(MSG_RES.getString("com.sygate.scm.console.ui.ui", "QuickStartDialog.tourEEURL"), obj);
        System.out.println("Localized SEP Tour EE url = " + localizedSepEEtourUrl);
        map.put(HELP_UTIL_URL_tourEE, localizedSepEEtourUrl);
        map.put(HELP_UTIL_URL_footer3LinkURL, MSG_RES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "LicenseActivationSelectionPanel.footer3LinkURL"));
        map.put(HELP_UTIL_URL_moreInfoLinkURL, MSG_RES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "LicenseActivationFinishedPanel.moreInfoLinkURL"));
        String localizedSepNewsUrl = MessageFormat.format(MSG_RES.getString("com.sygate.scm.util.util", "SepNews.SupportURL"), obj);
        System.out.println("Localized SEP News url = " + localizedSepNewsUrl);
        map.put(HELP_UTIL_URL_SEPNEWSURL, localizedSepNewsUrl);
        System.out.println("Retrieved language = " + Utility.getLanguage());
        String showNewFeatureUrl = HelpUtil.getCEDHelpUrl("whats_new");
        map.put(HELP_UTIL_URL_showNewFeaturesUrl, showNewFeatureUrl);
        String showWSSEntrustInstallCertHelpUrl = MessageFormat.format(MSG_RES.getString("com.sygate.scm.console.ui.policy.ntr.ntr", "NTRSettingsPanel.checkbox.InstallCertificate.kb"), obj);
        map.put(HELP_UTIL_URL_WSSEntrustInstallCertHelpUrl, showWSSEntrustInstallCertHelpUrl);
    }
}

