/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler.admin;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.SchemaHelper;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AdministratorState;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SysAdministratorArray;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.admin.AbstractAdminHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.AdminStateObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.StringUtilities;
import java.text.MessageFormat;

public class SysAdminHandler
extends AbstractAdminHandler {
    protected SysAdminHandler() {
    }

    @Override
    public boolean checkExistence(String adminName) throws ConsoleException {
        if (StringUtilities.isEmpty((String)adminName)) {
            return false;
        }
        DataobjectManager dataobjectManager = DataobjectManager.getInstance();
        return dataobjectManager.isAdminInUse(adminName, false);
    }

    @Override
    void createAdministrator(AdminObject adminObj, AdminPrivilegeObject adminPrivilege) throws ConsoleException {
        if (this.checkExistence(adminObj.getName())) {
            throw new ConsoleException(-2097086464, 12);
        }
        DataobjectManager data = DataobjectManager.getInstance();
        SysAdministratorArray adminArray = data.getSysAdministratorArray();
        adminArray.addSemAdministrator(adminObj.getSemAdmin());
        AdministratorState state = AdminStateObject.createAdminState(adminObj.getSemAdmin());
        try {
            data.updateObject("Merge", (TopLevelObject)adminArray);
            data.addAdministratorState(state);
        }
        catch (ConsoleException ex) {
            if (!ex.needRelogin()) {
                AdminHandler.refreshConfigRoot();
            }
            throw ex;
        }
    }

    @Override
    String getLogDescriptionForAdding(AdminObject adminObj) {
        return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "AdminHandler.SysAdminAdded"), adminObj.getName());
    }

    @Override
    public SemAdministrator updatePassword(AdminObject adminObj, String newPassword, AbstractAdminHandler.ActionType type, boolean persistNow) throws ConsoleException {
        adminObj.setPassword(newPassword);
        if (type == AbstractAdminHandler.ActionType.UPDATE) {
            AdminHandler.logEventForAdminChangingPwd(adminObj);
            AdminHandler.setAdminLastPasswordChangeTime(adminObj);
            AdminHandler.deleteAccessToken(adminObj.getAdminId());
        }
        return persistNow ? AdminHandler.updateAdmin(adminObj) : null;
    }

    @Override
    public SemAdministrator retrieveAdmin(String adminId, String domainId) throws ConsoleException {
        SysAdministratorArray adminArray = DataobjectManager.getInstance().getSysAdministratorArray();
        return SchemaHelper.getSystemAdminById((SysAdministratorArray)adminArray, (String)adminId);
    }

    @Override
    SemAdministrator editAdministrator(AdminObject adminObj, boolean deleteAccessToken) throws ConsoleException {
        SemAdministrator currentAdmin = adminObj.getSemAdmin();
        DataobjectManager data = DataobjectManager.getInstance();
        SysAdministratorArray adminArray = data.getSysAdministratorArray();
        for (int i = 0; i < adminArray.getSemAdministratorCount(); ++i) {
            SemAdministrator admin = adminArray.getSemAdministrator(i);
            if (!admin.getId().equals(currentAdmin.getId())) continue;
            adminArray.setChild(i, (AbstractSchema)currentAdmin);
            data.updateObject("Merge", (TopLevelObject)adminArray);
            if (admin.getOptPasswordAge() == null) {
                admin.setOptPasswordAge(admin.getDefPasswordAge());
            }
            if (!currentAdmin.hasSameValues((AbstractSchema)admin)) {
                ConsoleLogger.log("Administrator Schema are different except _t, _v and ObsoleteItem, schema 1: " + currentAdmin.toString() + ", schema 2: " + admin.toString());
                if (deleteAccessToken) {
                    AdminHandler.deleteAccessToken(adminObj.getAdminId());
                }
            }
            return currentAdmin;
        }
        return null;
    }
}

