/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler.admin;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.schema.AdminContext;
import com.sygate.scm.common.configobject.schema.AdministratorState;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.admin.DomainAdminHandler;
import com.sygate.scm.console.handler.admin.LimitedAdminHandler;
import com.sygate.scm.console.handler.admin.SysAdminHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.AdminStateObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.ConsoleSystemException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.StringUtilities;

public abstract class AbstractAdminHandler {
    private static final SysAdminHandler sysAdminHandler = new SysAdminHandler();
    private static final DomainAdminHandler domainAdminHandler = new DomainAdminHandler();
    private static final LimitedAdminHandler limitedAdminHandler = new LimitedAdminHandler();

    public static AbstractAdminHandler getInstance(AdminObject adminObj) {
        if (adminObj == null) {
            throw new IllegalArgumentException("The parameter AdminObject can not be null!");
        }
        return AbstractAdminHandler.getInstance(adminObj.getAdminType());
    }

    public static AbstractAdminHandler getInstance(AdminObject.AdminType type) {
        switch (type) {
            case SYS_ADMIN: {
                return sysAdminHandler;
            }
            case DOMAIN_ADMIN: {
                return domainAdminHandler;
            }
            case LIMITED_ADMIN: {
                return limitedAdminHandler;
            }
        }
        throw new ConsoleSystemException("Cannot get instance of admin type: " + type);
    }

    public static AbstractAdminHandler getSystemAdminHandler() {
        return sysAdminHandler;
    }

    public static AbstractAdminHandler getDomainAdminHandler() {
        return domainAdminHandler;
    }

    public static AbstractAdminHandler getLimitedAdminHandler() {
        return limitedAdminHandler;
    }

    public void addAdministrator(AdminObject adminObj, AdminPrivilegeObject adminPrivilege) throws ConsoleException {
        adminObj.setCreationTime(TimeUtil.getServerTime());
        this.createAdministrator(adminObj, adminPrivilege);
        ConsoleLogger.logAdminEvent(4104, this.getLogDescriptionForAdding(adminObj));
    }

    public SemAdministrator updateAdministrator(AdminObject adminObj, boolean deleteAccessToken) throws ConsoleException {
        if (adminObj == null) {
            return null;
        }
        if (adminObj.isNameDirty() && this.checkExistence(adminObj.getName())) {
            throw new ConsoleException(-2097086464, 12);
        }
        return this.editAdministrator(adminObj, deleteAccessToken);
    }

    abstract String getLogDescriptionForAdding(AdminObject var1);

    abstract void createAdministrator(AdminObject var1, AdminPrivilegeObject var2) throws ConsoleException;

    abstract SemAdministrator editAdministrator(AdminObject var1, boolean var2) throws ConsoleException;

    public abstract SemAdministrator retrieveAdmin(String var1, String var2) throws ConsoleException;

    public abstract SemAdministrator updatePassword(AdminObject var1, String var2, ActionType var3, boolean var4) throws ConsoleException;

    public boolean checkExistence(String adminName) throws ConsoleException {
        if (StringUtilities.isEmpty((String)adminName)) {
            return false;
        }
        DataobjectManager dataobjectManager = DataobjectManager.getInstance();
        return dataobjectManager.isAdminInUse(adminName);
    }

    void createNonSysAdministrator(AdminObject adminObj, AdminPrivilegeObject adminPrivilege) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        adminObj.setEnabled(adminPrivilege);
        if (this.checkExistence(adminObj.getName())) {
            throw new ConsoleException(-2097086464, 12);
        }
        AdminContext newAdminContext = new AdminContext();
        newAdminContext.setId(GUIDGenerator.getInstance().getGUIDString());
        newAdminContext.setSemAdministrator(adminObj.getSemAdmin());
        newAdminContext.setSemAdminPrivilege(adminPrivilege.getSemAdminPrivilege());
        AdministratorState state = AdminStateObject.createAdminState(adminObj.getSemAdmin());
        try {
            data.addAdminContext(newAdminContext);
            data.addAdministratorState(state);
        }
        catch (ConsoleException ex) {
            if (!ex.needRelogin()) {
                AdminHandler.refreshDomain(Manager.getCurrentDomainId());
            }
            throw ex;
        }
    }

    SemAdministrator editNonSysAdministrator(AdminObject adminObj) throws ConsoleException {
        AdminContext adminContext = adminObj.getAdminContext();
        DataobjectManager data = DataobjectManager.getInstance();
        AdminContext result = data.updateAdminContext(adminContext);
        return result == null ? null : result.getSemAdministrator();
    }

    void updatePasswordForNonSystemAdmin(AdminObject adminObj, String newPassword, ActionType type) throws ConsoleException {
        switch (type) {
            case CREATE: {
                adminObj.setPassword(newPassword);
                break;
            }
            case UPDATE: {
                AdminHandler.updateAdministratorPassword(adminObj.getAdminContext().getId(), newPassword);
                AdminHandler.logEventForAdminChangingPwd(adminObj);
                this.editNonSysAdministrator(adminObj);
                break;
            }
            default: {
                throw new UnsupportedOperationException("The parameter type is in inconsistant state! : " + type);
            }
        }
    }

    public static enum ActionType {
        CREATE,
        UPDATE;

    }
}

