/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.schema.ComputerImage;
import com.sygate.scm.common.configobject.schema.ComputerImagePool;
import com.sygate.scm.common.configobject.schema.ComputerLockdownProtection;
import com.sygate.scm.common.configobject.schema.Inheritance;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.configobject.schema.SemAgentPolicy;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SemGroupPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServerLogHandler;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.ComputerLockdownProtectionObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LockdownExceptionObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.logicobject.WhiteListObject;
import com.sygate.scm.console.ui.monitoring.logviewer.AgentBehaviorLogAdapter;
import com.sygate.scm.console.ui.policy.explorer.whitelist.AddWhiteListWizard;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListPanel;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.systemlockdown.FingerprintListHashValues;
import com.sygate.scm.util.systemlockdown.FingerprintListHelper;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class WhiteListHandler
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(WhiteListHandler.class.getName());
    private static final int LOCKDOWN_MAXLOGSIZE = 20000;
    private static final String AUTOMATION_ID_WHITE_LIST_PANEL = "WhiteListPanel";
    private static WhiteListPanel whiteListPanel;
    private static final Object lockObj;

    public static JPanel getComponent(TreeItem treeItem) {
        if (treeItem.getItemType() == 91 && whiteListPanel == null) {
            whiteListPanel = new WhiteListPanel();
        }
        whiteListPanel.refresh();
        UIUtilities.setName(whiteListPanel, "policyPage", UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_WHITE_LIST_PANEL);
        return whiteListPanel;
    }

    public static ArrayList<ComputerImage> getComputerImagesFromPool() throws ConsoleException {
        return WhiteListHandler.getComputerImages(false);
    }

    public static ArrayList<ComputerImage> getComputerImagesFromDB() throws ConsoleException {
        return WhiteListHandler.getComputerImages(true);
    }

    private static ArrayList<ComputerImage> getComputerImages(boolean isFromDB) throws ConsoleException {
        ArrayList<ComputerImage> list = new ArrayList<ComputerImage>();
        SemDomain domain = AdminHandler.retrieveCurrentDomain(false);
        ObjectPool pool = domain.getObjectPool();
        ComputerImagePool poolImages = pool.getOptComputerImagePool();
        if (poolImages == null) {
            return list;
        }
        for (int i = 0; i < poolImages.getObjReferenceCount(); ++i) {
            ObjReference ref = poolImages.getObjReference(i);
            ComputerImage image = (ComputerImage)DataobjectManager.getInstance().getObjectByGUID("ComputerImage", ref.getTargetId(), isFromDB);
            if (image == null) continue;
            list.add(image);
        }
        return list;
    }

    public static Map<String, ComputerImage> getComputerImagesByIds(List<String> lstIds) throws ConsoleException {
        HashMap<String, ComputerImage> mapCI = new HashMap<String, ComputerImage>();
        if (lstIds != null && lstIds.size() > 0) {
            SemDomain domain = AdminHandler.retrieveCurrentDomain(false);
            ObjectPool pool = domain.getObjectPool();
            ComputerImagePool poolImages = pool.getOptComputerImagePool();
            if (poolImages == null) {
                logger.log(Level.INFO, "WhiteListHandler>> getComputerImageByName: Done! Pool is null!");
                return mapCI;
            }
            DataobjectManager data = DataobjectManager.getInstance();
            logger.log(Level.INFO, "WhiteListHandler>> getComputerImageByName: size={0}", poolImages.getObjReferenceCount());
            for (int i = 0; i < poolImages.getObjReferenceCount(); ++i) {
                ComputerImage image;
                ObjReference ref = poolImages.getObjReference(i);
                if (!lstIds.contains(ref.getTargetId()) || (image = data.getComputerImage(ref.getTargetId())) == null) continue;
                mapCI.put(image.getId(), image);
            }
        }
        return mapCI;
    }

    public static ComputerImage getComputerImageByName(String name) throws ConsoleException {
        if (name == null || name.length() < 1) {
            return null;
        }
        SemDomain domain = AdminHandler.retrieveCurrentDomain(false);
        ObjectPool pool = domain.getObjectPool();
        ComputerImagePool poolImages = pool.getOptComputerImagePool();
        if (poolImages == null) {
            logger.log(Level.INFO, "WhiteListHandler>> getComputerImageByName: Done! Pool is null!");
            return null;
        }
        DataobjectManager data = DataobjectManager.getInstance();
        logger.log(Level.INFO, "WhiteListHandler>> getComputerImageByName: size={0}", poolImages.getObjReferenceCount());
        for (int i = 0; i < poolImages.getObjReferenceCount(); ++i) {
            ObjReference ref = poolImages.getObjReference(i);
            try {
                ComputerImage image = data.getComputerImage(ref.getTargetId());
                if (image == null || !image.getName().equals(name)) continue;
                logger.log(Level.INFO, "WhiteListHandler>> getComputerImageByName: Found! image id={0}, name={1}", new Object[]{image.getId(), image.getName()});
                return image;
            }
            catch (ConsoleException ex) {
                if (!ex.needRelogin()) continue;
                throw ex;
            }
        }
        return null;
    }

    public static int getComputerImagesCountFromPool() throws Exception {
        SemDomain domain = AdminHandler.retrieveCurrentDomain(false);
        ObjectPool pool = domain.getObjectPool();
        ComputerImagePool poolImages = pool.getOptComputerImagePool();
        if (poolImages == null) {
            return 0;
        }
        return poolImages.getObjReferenceCount();
    }

    public static boolean canDelete(WhiteListObject whitelist) {
        if (whitelist == null) {
            return true;
        }
        try {
            MessageResources msgRes = MessageResources.getInstance();
            GroupObject group = WhiteListHandler.retrieveFirstGroupWithWhitelistId(whitelist.getId());
            if (group != null) {
                whitelist.setGroup(group);
                MultiLineMsgBox.show(Manager.getFrame(), msgRes.getString("com.sygate.scm.console.handler.handler", "WhiteListHandler.title.Warning"), MessageFormat.format(msgRes.getString("com.sygate.scm.console.handler.handler", "WhiteListHandler.CannotDeleteFileFingerprint"), whitelist.getName(), group.getFullGroupPath()), 50, 2, -1);
                return false;
            }
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return true;
    }

    public static void deleteWhiteList(WhiteListObject wlObj) throws ConsoleException {
        logger.log(Level.INFO, "WhiteListHandler>> deleteWhiteLists: Begin...");
        SemDomain domain = AdminHandler.retrieveCurrentDomain(false);
        ObjectPool pool = domain.getObjectPool();
        ComputerImagePool poolImages = pool.getOptComputerImagePool();
        if (poolImages == null || poolImages.getObjReferenceCount() < 1) {
            logger.log(Level.INFO, "WhiteListHandler>> deleteWhiteLists: Warning-> ComputerImagePool is empty!");
        } else {
            ComputerImage image = wlObj.getImage();
            WhiteListHandler.removeWhiteListLinkFromPool(poolImages, image);
            logger.log(Level.INFO, "WhiteListHandler>> deleteWhiteLists: Updating domain...");
            ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
            updateList.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)image, 2));
            updateList.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)domain, 0));
            DataobjectManager.getInstance().updateObject("Merge", updateList);
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "WhiteListHandler.Delete.Description");
            Object[] obj = new Object[]{image.getName()};
            desc = MessageFormat.format(desc, obj);
            ConsoleLogger.logPolicyEvent(1, image.getId(), desc, null);
        }
        logger.log(Level.INFO, "WhiteListHandler>> deleteWhiteLists: Done!");
    }

    private static GroupObject retrieveFirstGroupWithWhitelistId(String whiteListId) throws ConsoleException {
        GroupObject startGroup = GroupHandler.getRootGroupObject();
        return WhiteListHandler.retrieveFirstGroupWithWhitelistId(startGroup, whiteListId);
    }

    private static GroupObject retrieveFirstGroupWithWhitelistId(GroupObject startGroup, String whiteListId) throws ConsoleException {
        if (whiteListId == null || whiteListId.length() < 1) {
            return null;
        }
        ComputerLockdownProtectionObject lockdownObj = WhiteListHandler.retrieveLockdownFromGroup(startGroup);
        if (lockdownObj != null && lockdownObj.getWhiteListById(whiteListId) != null) {
            return startGroup;
        }
        Vector<SemClientGroup> groups = startGroup.getChildrenGroups();
        if (groups == null) {
            return null;
        }
        for (int i = 0; i < groups.size(); ++i) {
            SemClientGroup group = groups.get(i);
            GroupObject g = WhiteListHandler.retrieveFirstGroupWithWhitelistId(new GroupObject(group), whiteListId);
            if (g == null) continue;
            return g;
        }
        return null;
    }

    private static ComputerLockdownProtectionObject retrieveLockdownFromGroup(GroupObject startGroup) throws ConsoleException {
        SemGroupPolicy groupPolicy = SoftwarePackageHandler.getGroupPolicy(startGroup);
        if (groupPolicy == null) {
            return null;
        }
        if (Inheritance.USE_PARENT.equals(groupPolicy.getInheritance().getMode())) {
            return null;
        }
        SemAgentPolicy agentPolicy = SoftwarePackageHandler.getAgentPolicy(groupPolicy);
        if (agentPolicy == null) {
            return null;
        }
        ComputerLockdownProtection lockdown = agentPolicy.getOptComputerLockdownProtection();
        if (lockdown == null) {
            return null;
        }
        ComputerLockdownProtectionObject lockdownObj = new ComputerLockdownProtectionObject(lockdown);
        return lockdownObj;
    }

    public static void deletePhysicalFile(PhysicalFile file) throws ConsoleException {
        if (file == null) {
            return;
        }
        DataobjectManager manager = DataobjectManager.getInstance();
        logger.log(Level.INFO, "WhiteListHandler>> deletePhysicalFile: Deleting PhysicalFile id={0}...", file.getId());
        try {
            manager.deletePhysicalFile(file);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            if (ex.needRelogin()) {
                throw ex;
            }
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        String id = file.getObjReference().getTargetId();
        logger.log(Level.INFO, "WhiteListHandler>> deletePhysicalFile: Deleting binary data id={0}...", id);
        try {
            GUIManager.deleteFile(id);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            if (ex.needRelogin()) {
                throw ex;
            }
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private static boolean removeWhiteListLinkFromPool(ComputerImagePool pool, ComputerImage image) {
        if (pool == null || image == null) {
            return true;
        }
        for (int i = 0; i < pool.getObjReferenceCount(); ++i) {
            ObjReference ref = pool.getObjReference(i);
            if (!ref.getTargetId().equals(image.getId())) continue;
            logger.log(Level.INFO, "WhiteListHandler>> removeWhiteListLinkFromPool: removing a link of ComputerImage id={0}, name={1}...", new Object[]{image.getId(), image.getName()});
            pool.removeObjReference(ref);
            return true;
        }
        return false;
    }

    public static void updateWhiteList(WhiteListObject whitelist) throws Exception {
        DataobjectManager manager = DataobjectManager.getInstance();
        ComputerImage image = whitelist.getImage();
        image.validate();
        image.setOptUpdateTime(Long.valueOf(TimeUtil.getServerTime()));
        manager.updateObject("Merge", (TopLevelObject)image);
        logger.log(Level.INFO, "WhiteListHandler>> updateWhiteList: updated ComputerImage id={0}, name={1}", new Object[]{image.getId(), image.getName()});
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "WhiteListHandler.Edit.Description");
        Object[] obj = new Object[]{image.getName()};
        desc = MessageFormat.format(desc, obj);
        ConsoleLogger.logPolicyEvent(2, image.getId(), desc, null);
    }

    public static void addWhiteList(WhiteListObject whitelist) throws Exception {
        ArrayList<DataobjectManager.UpdateObjectEntry> listObjs = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        DataobjectManager manager = DataobjectManager.getInstance();
        ComputerImage image = whitelist.getImage();
        image.setOptCreator(AdminObject.retrieveCurrentAdminObject().getName());
        image.validate();
        listObjs.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)image, 1));
        SemDomain domain = AdminHandler.retrieveCurrentDomain(false);
        ObjectPool pool = domain.getObjectPool();
        ComputerImagePool poolImages = pool.getOptComputerImagePool();
        if (poolImages == null) {
            poolImages = new ComputerImagePool();
            pool.setOptComputerImagePool(poolImages);
        }
        ObjReference ref = new ObjReference();
        ref.setName("ImportedComputerImageLink");
        ref.setTargetType("ComputerImage");
        ref.setTargetId(image.getId());
        poolImages.addObjReference(ref);
        listObjs.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)domain, 0));
        manager.updateObject("Merge", listObjs);
        logger.log(Level.INFO, "WhiteListHandler>> addWhiteList: Added ComputerImage id={0}, name={1} into SemDomain id={2}, name={3}", new Object[]{image.getId(), image.getName(), domain.getId(), domain.getName()});
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "WhiteListHandler.Add.Description");
        Object[] obj = new Object[]{image.getName()};
        desc = MessageFormat.format(desc, obj);
        ConsoleLogger.logPolicyEvent(0, image.getId(), desc, null);
    }

    public static byte[] getChecksumeFile(WhiteListObject whitelist, boolean master) throws ConsoleException {
        if (whitelist == null || !whitelist.isValid()) {
            logger.log(Level.INFO, "WhiteListHandler>> getChecksumeFile: Error-> whitelist is invalid!");
            return null;
        }
        PhysicalFile file = whitelist.getPhysicalFile(master);
        if (file == null) {
            logger.log(Level.INFO, "WhiteListHandler>> getChecksumeFile: no file in whitelist id={0}, name={1}, master={2}", new Object[]{whitelist.getId(), whitelist.getName(), master});
            return master ? null : new byte[]{};
        }
        long size = file.getFileSize();
        String id = file.getObjReference().getTargetId();
        byte[] data = null;
        try {
            data = WhiteListHandler.getChecksumeFile(id, size);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            if (ex.needRelogin()) {
                throw ex;
            }
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getChecksumeFile(String id, long size) throws ConsoleException {
        ByteArrayOutputStream bos;
        block14: {
            BufferedInputStream bis;
            InputStream is;
            block13: {
                bos = null;
                is = null;
                bis = null;
                is = GUIManager.getFile(id);
                if (is != null) break block13;
                byte[] byArray = null;
                IOUtilities.closeInputStream((InputStream)is);
                IOUtilities.closeInputStream(bis);
                IOUtilities.closeOutputStream(bos);
                return byArray;
            }
            try {
                bis = new BufferedInputStream(is);
                bos = size <= 0L ? new ByteArrayOutputStream() : new ByteArrayOutputStream((int)size);
                int iBufferSize = 1024;
                byte[] buffer = new byte[iBufferSize];
                Object object = lockObj;
                synchronized (object) {
                    int bytesRead;
                    while ((bytesRead = bis.read(buffer)) != -1) {
                        bos.write(buffer, 0, bytesRead);
                    }
                }
            }
            catch (Throwable e) {
                try {
                    LoggerUtilities.logException((Throwable)e);
                    break block14;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtilities.closeInputStream((InputStream)is);
                    IOUtilities.closeInputStream(bis);
                    IOUtilities.closeOutputStream(bos);
                }
            }
            IOUtilities.closeInputStream((InputStream)is);
            IOUtilities.closeInputStream((InputStream)bis);
            IOUtilities.closeOutputStream((OutputStream)bos);
        }
        if (bos == null) {
            return null;
        }
        byte[] bytes = bos.toByteArray();
        if (bytes == null || bytes.length < 1) {
            logger.log(Level.INFO, "WhiteListHandler>> getChecksumeFile: Error-> Failed to read file: id={0}, input size={1}", new Object[]{id, size});
        } else {
            logger.log(Level.INFO, "WhiteListHandler>> getChecksumeFile: size={0}, input size={1}", new Object[]{bytes.length, size});
        }
        return bytes;
    }

    public static FingerprintListHashValues readFingerprintListFromFile(String fileName) throws FingerprintListException {
        try {
            return FingerprintListHelper.readFingerprintListFromFile((Path)Paths.get(fileName, new String[0]));
        }
        catch (FingerprintListException ex) {
            logger.log(Level.SEVERE, "WhitsListHandler >> readFingerprintListFromFile Error!");
            throw ex;
        }
    }

    public static boolean processFingerprintListFile(String importedFileName, String generatedFileName, WhiteListObject whiteListObject) {
        try {
            FingerprintListHashValues hashValues = FingerprintListHelper.readFingerprintListFromFile((Path)Paths.get(importedFileName, new String[0]));
            if (hashValues.isEmpty()) {
                return false;
            }
            if (whiteListObject != null && whiteListObject.getImage() != null) {
                whiteListObject.getImage().setOptHashCount(Integer.valueOf(hashValues.getHashCount()));
                whiteListObject.getImage().setOptLegacyHashCount(Integer.valueOf(hashValues.getLegacyHashCount()));
            }
            return WhiteListHandler.saveFingerprintListAsFile(hashValues, generatedFileName, whiteListObject);
        }
        catch (FingerprintListException exc) {
            logger.log(Level.SEVERE, "WhiteListHandler >> processFingerprintListFile, Error:", exc);
            return false;
        }
    }

    public static boolean saveFingerprintListAsFile(FingerprintListHashValues hashValues, String fileName, WhiteListObject whiteListObject) {
        if (hashValues == null || hashValues.isEmpty()) {
            logger.severe("WhiteListHandler>> saveChecksumList: Error-> list is empty!");
            return false;
        }
        if (fileName == null || fileName.length() < 1) {
            logger.severe("WhiteListHandler>> saveChecksumList: Error-> file name is null!");
            return false;
        }
        if (whiteListObject != null && whiteListObject.getImage() != null) {
            whiteListObject.getImage().setOptHashCount(Integer.valueOf(hashValues.getHashCount()));
            whiteListObject.getImage().setOptLegacyHashCount(Integer.valueOf(hashValues.getLegacyHashCount()));
        }
        try {
            FingerprintListHelper.writeFingerprintListToDbBinaryFile((FingerprintListHashValues)hashValues, (Path)Paths.get(fileName, new String[0]));
        }
        catch (IOException exc) {
            logger.log(Level.SEVERE, "saveFingerprintListAsFile Error: ", exc);
            return false;
        }
        return true;
    }

    public static boolean readFingerprintListFromBytes(byte[] data, FingerprintListHashValues hashValues) {
        if (hashValues == null) {
            logger.severe("WhiteListHandler >> readFingerprintListFromBytes, hashValues cannot be null");
            return false;
        }
        if (data == null || data.length < 1) {
            logger.severe("WhiteListHandler >> readFingerprintListFromBytes, data is empty");
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(true);
        try {
            FingerprintListHelper.readFingerprintListFromStream((byte[])data).getAllHashValues().forEach(hashValue -> {
                try {
                    hashValues.addHashValue(hashValue);
                }
                catch (FingerprintListException e) {
                    result.set(false);
                }
            });
        }
        catch (FingerprintListException exc) {
            logger.log(Level.SEVERE, "WhiteListHandler >> readFingerprintListFromBytes Error: ", exc);
            result.set(false);
        }
        return result.get();
    }

    public static ArrayList<LockdownExceptionObject> getExceptionList(long beginTime, String[] groupId) throws ConsoleException {
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER_3", (String)"1");
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"LONG", (String)String.valueOf(beginTime));
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN", (String)"true");
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID_LIST", (String)WhiteListHandler.buildIdList(groupId, false));
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_2", (String)"true");
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ORDER_BY", (String)"true");
        AgentBehaviorLogAdapter logAdapter = (AgentBehaviorLogAdapter)ServerLogHandler.getServerLogData(rpc, 4, 0, 20000);
        List<List<Object>> listData = logAdapter.getLogData();
        ArrayList<LockdownExceptionObject> list = new ArrayList<LockdownExceptionObject>(listData.size());
        for (int i = 0; i < listData.size(); ++i) {
            list.add(new LockdownExceptionObject(listData.get(i)));
        }
        return list;
    }

    public static int getExceptionCount(long beginTime, String[] groupId) throws ConsoleException {
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"LONG", (String)String.valueOf(beginTime));
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID_LIST", (String)WhiteListHandler.buildIdList(groupId, false));
        return ServerLogHandler.getRowCount(rpc, 4);
    }

    private static String buildIdList(String[] groupId, boolean hasQuote) {
        String quote = hasQuote ? "'" : "";
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < groupId.length; ++i) {
            buffer.append("," + quote + groupId[i] + quote);
        }
        return buffer.substring(1);
    }

    public static boolean addWhiteList() {
        AddWhiteListWizard wizard = new AddWhiteListWizard();
        wizard.dispose();
        return true;
    }

    static {
        lockObj = new Object();
    }
}

