/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SoApplicationContainer;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXException;

public class WashIDHandler
extends AbstractHandler {
    private Map<String, String> washedIdPool = new HashMap<String, String>();
    private Map<String, String> washedIdReversePool = new HashMap<String, String>();
    private Set<ConfigObject> washedObjPool = new HashSet<ConfigObject>();
    private Set<ConfigObject> washedItemPool = new HashSet<ConfigObject>();
    private static final Set<String> setOfClassesWithNoSetIdMethod = new HashSet<String>();
    static int count = 1;

    public ConfigObject duplicateObject(ConfigObject obj, Map<String, TopLevelObject> newObjSet) throws ValidationException, IOException, SAXException, ConsoleException {
        this.washedIdPool.clear();
        this.washedObjPool.clear();
        this.washedItemPool.clear();
        ConfigObject newObj = this.duplicateObject(obj);
        newObj = this.replaceReferenceId(newObj, newObjSet);
        return newObj;
    }

    private ConfigObject duplicateObject(ConfigObject obj) throws ConsoleException {
        ConfigObject newObj = PolicyHandler.getCopyOfObj(obj);
        this.reinitializeObject(newObj);
        this.washedObjPool.add(newObj);
        return newObj;
    }

    private void reinitializeObject(ConfigObject obj) throws ConsoleException {
        String containerName;
        String referId;
        TopLevelObject referredObj;
        ObjReference refer;
        String targetType;
        if (this.washedItemPool.contains(obj)) {
            return;
        }
        this.washedItemPool.add(obj);
        obj.init();
        String className = obj.getClass().getName();
        if (!setOfClassesWithNoSetIdMethod.contains(className)) {
            try {
                try {
                    Method method = obj.getClass().getMethod("getId", new Class[0]);
                    String oldID = (String)method.invoke((Object)obj, new Object[0]);
                    String newID = this.washedIdPool.get(oldID);
                    if (newID != null) {
                        return;
                    }
                    method = obj.getClass().getMethod("setId", String.class);
                    newID = new GUIDGenerator().getGUIDString();
                    method.invoke((Object)obj, newID);
                    this.washedIdPool.put(oldID, newID);
                    this.washedIdReversePool.put(newID, oldID);
                }
                catch (NoSuchMethodException noex) {
                    setOfClassesWithNoSetIdMethod.add(obj.getClass().getName());
                }
            }
            catch (InvocationTargetException ite) {
                LoggerUtilities.logException((Throwable)ite);
            }
            catch (IllegalAccessException iae) {
                LoggerUtilities.logException((Throwable)iae);
            }
        }
        if (obj instanceof ObjReference && !(targetType = (refer = (ObjReference)obj).getTargetType()).equals("ExPhysicalFileStream") && !targetType.equals("DefaultServerList") && (referredObj = PolicyHandler.getObjectWithoutCopy(targetType, referId = refer.getTargetId())).isPrivateObject()) {
            String newId = this.washedIdPool.get(referId);
            if (newId != null) {
                refer.setTargetId(newId);
            } else {
                TopLevelObject newReferObj = (TopLevelObject)this.duplicateObject((ConfigObject)referredObj);
                newId = this.washedIdPool.get(referId);
                refer.setTargetId(newId);
                MetadataAttributes mAttr = newReferObj.getMetadataAttributes();
                String oldOwnerId = mAttr.getOwner().toString();
                String newOwnerId = this.washedIdPool.get(oldOwnerId);
                if (newOwnerId == null) {
                    newOwnerId = oldOwnerId;
                }
                mAttr.setOwner(new GUID(newOwnerId));
            }
        }
        if (obj instanceof UnknownContent) {
            UnknownContent unknown = (UnknownContent)obj;
            try {
                ConfigObject subObj = (ConfigObject)AbstractSchema.readXML((byte[])unknown.getContent());
                this.reinitializeObject(subObj);
                unknown.setConent(subObj.getBytes());
            }
            catch (SAXException e) {
                LoggerUtilities.logException((Throwable)e);
                throw new ConsoleException(e);
            }
            catch (IOException e) {
                LoggerUtilities.logException((Throwable)e);
                throw new ConsoleException(e);
            }
            catch (ValidationException e) {
                LoggerUtilities.logException((Throwable)e);
                throw new ConsoleException(e);
            }
        }
        if (obj instanceof SoApplicationContainer && (containerName = ((SoApplicationContainer)obj).getOptContainerName()) != null && containerName.equals("PREDEFINED")) {
            ((SoApplicationContainer)obj).setOptContainerName("USER_DEFINED");
        }
        for (AbstractSchema child : obj.getChildren()) {
            try {
                this.reinitializeObject((ConfigObject)child);
            }
            catch (Throwable th) {
                try {
                    ConsoleLogger.log("WashIDHandler> reinitializeObject>> Error while processing ConfigObject. This could be due to broken-link issue. Exception: " + th.getMessage() + " \n ConfigObject: " + (ConfigObject)child);
                    ConsoleLogger.log(th);
                }
                catch (Exception ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
                throw th;
            }
        }
    }

    private ConfigObject replaceReferenceId(ConfigObject curObj, Map<String, TopLevelObject> newObjSet) throws ValidationException, IOException, SAXException {
        ConfigObject newObj = null;
        for (ConfigObject oneObj : this.washedObjPool) {
            String xmlString = oneObj.getString();
            for (Map.Entry<String, String> oneEntry : this.washedIdPool.entrySet()) {
                String oldId = oneEntry.getKey();
                String newId = oneEntry.getValue();
                xmlString = xmlString.replaceAll(oldId, newId);
            }
            if (curObj == oneObj) {
                newObj = (ConfigObject)AbstractSchema.readXML((String)xmlString);
                if (!(oneObj instanceof TopLevelObject)) continue;
                MetadataAttributes mAttr = ((TopLevelObject)oneObj).getMetadataAttributes();
                ((TopLevelObject)newObj).setMetadataAttributes(mAttr);
                continue;
            }
            TopLevelObject addedObj = (TopLevelObject)AbstractSchema.readXML((String)xmlString);
            MetadataAttributes mAttr = ((TopLevelObject)oneObj).getMetadataAttributes();
            addedObj.setMetadataAttributes(mAttr);
            String oldID = this.washedIdReversePool.get(addedObj.getId());
            newObjSet.put(oldID, addedObj);
            PolicyHandler.newObjectPool.put(addedObj.getId(), addedObj);
        }
        return newObj;
    }
}

