/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.console.logicobject.UserObject;
import com.sygate.scm.util.LoggerUtilities;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class UserSaxHandler
extends DefaultHandler {
    boolean showAll = true;
    boolean fromLdap = true;
    ArrayList<UserObject> list = new ArrayList();
    int countUsers = 0;
    String domainName = null;
    private int totalResultSetCount = -1;

    public UserSaxHandler(boolean showAll, boolean fromLdap) {
        this.showAll = showAll;
        this.fromLdap = fromLdap;
    }

    public int getTotalCount() {
        return this.countUsers;
    }

    public int getTotalResultSetCount() {
        return this.totalResultSetCount == -1 ? this.countUsers : this.totalResultSetCount;
    }

    public List<UserObject> parse(InputStream is) throws Throwable {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader parser = saxParser.getXMLReader();
        parser.setFeature("http://xml.org/sax/features/external-general-entities", false);
        parser.setContentHandler(this);
        parser.parse(new InputSource(is));
        return this.list;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes att) throws SAXException {
        UserObject userObj = null;
        userObj = this.fromLdap ? this.getUserObjectFromLdap(qualifiedName, att) : this.getUserObjectFromDomain(qualifiedName, att);
        if (userObj == null) {
            String sTotalResultSetCount;
            if (qualifiedName.equalsIgnoreCase("OrganizationalUnit") && (sTotalResultSetCount = att.getValue("TotalResultSetCount")) != null) {
                try {
                    this.totalResultSetCount = Integer.parseInt(sTotalResultSetCount);
                }
                catch (NumberFormatException ignore) {
                    LoggerUtilities.logException((Throwable)ignore);
                }
            }
            return;
        }
        if (!this.showAll && userObj.hasGroupId()) {
            return;
        }
        this.list.add(userObj);
    }

    private UserObject getUserObjectFromLdap(String qualifiedName, Attributes att) {
        if (qualifiedName.equalsIgnoreCase("User")) {
            ++this.countUsers;
        } else {
            return null;
        }
        UserObject userObj = new UserObject();
        userObj.setImportMode(2);
        int count = att.getLength();
        for (int i = 0; i < count; ++i) {
            String attributeName = att.getLocalName(i);
            if (attributeName == null) continue;
            String attributeValue = att.getValue(i);
            if (attributeName.equalsIgnoreCase("Guid")) {
                userObj.setOuGuid(attributeValue);
                continue;
            }
            if (attributeName.equalsIgnoreCase("DomainName")) {
                userObj.setDomainName(attributeValue);
                continue;
            }
            if (attributeName.equalsIgnoreCase("FullName")) {
                userObj.setFullName(attributeValue);
                continue;
            }
            if (attributeName.equalsIgnoreCase("Name")) {
                userObj.setName(attributeValue);
                continue;
            }
            if (!attributeName.equalsIgnoreCase("GroupId")) continue;
            userObj.setGroupId(attributeValue);
        }
        return userObj;
    }

    private UserObject getUserObjectFromDomain(String qualifiedName, Attributes att) {
        if (qualifiedName.equalsIgnoreCase("DomainUser")) {
            ++this.countUsers;
        } else {
            if (qualifiedName.equalsIgnoreCase("Domain")) {
                int count = att.getLength();
                for (int i = 0; i < count; ++i) {
                    String value;
                    String name = att.getLocalName(i);
                    if (name == null || !name.equalsIgnoreCase("name")) continue;
                    this.domainName = value = att.getValue(i);
                    break;
                }
                return null;
            }
            return null;
        }
        UserObject userObj = new UserObject();
        userObj.setImportMode(1);
        int count = att.getLength();
        for (int i = 0; i < count; ++i) {
            String name = att.getLocalName(i);
            if (name == null) continue;
            String value = att.getValue(i);
            if (name.equalsIgnoreCase("FullName")) {
                userObj.setFullName(value);
                continue;
            }
            if (name.equalsIgnoreCase("ID")) {
                userObj.setName(value);
                continue;
            }
            if (!name.equalsIgnoreCase("GroupId")) continue;
            userObj.setGroupId(value);
        }
        userObj.setDomainName(this.domainName);
        return userObj;
    }
}

