/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AppProtectionSetting;
import com.sygate.scm.common.configobject.schema.ExtendedOpDevice;
import com.sygate.scm.common.configobject.schema.MacAppProtectionSetting;
import com.sygate.scm.common.configobject.schema.MacOpBlockedDeviceList;
import com.sygate.scm.common.configobject.schema.MacOpDeviceBlocker;
import com.sygate.scm.common.configobject.schema.MacOpExcludedDeviceList;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicy;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicyPool;
import com.sygate.scm.common.configobject.schema.OpBlockedDeviceClassArray;
import com.sygate.scm.common.configobject.schema.OpDevice;
import com.sygate.scm.common.configobject.schema.OpDeviceBlocker;
import com.sygate.scm.common.configobject.schema.OpDevicePool;
import com.sygate.scm.common.configobject.schema.OpExcludedDeviceArray;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.logicobject.DeviceObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class UsbDeviceHandler
extends AbstractHandler {
    public static boolean deleteDevices(DeviceObject dvObj) throws Exception {
        System.out.println("DeviceHandler>> deleteDevices");
        boolean found = false;
        SemDomain domain = AdminHandler.retrieveCurrentDomain(false);
        ObjectPool pool = domain.getObjectPool();
        OpDevicePool poolDevices = pool.getOptOpDevicePool();
        if (poolDevices == null || poolDevices.getObjReferenceCount() < 1) {
            System.out.println("DeviceHandler>> deleteDevices: Warning-> OpDevicePool is empty!");
        } else {
            OpDevice device = dvObj.getDevice();
            for (int j = 0; j < poolDevices.getObjReferenceCount(); ++j) {
                ObjReference ref = poolDevices.getObjReference(j);
                if (!ref.getTargetId().equals(device.getId())) continue;
                System.out.println("DeviceHandler>> deleteDevices: Wremoving a link of OpDevice id=" + device.getId() + ", name=" + device.getName() + "...");
                poolDevices.removeObjReference(ref);
                found = true;
                break;
            }
            if (found) {
                System.out.println("DeviceHandler>> deleteDevices: Updating domain...");
                DataobjectManager.getInstance().updateSemDomain("Merge", domain);
            }
        }
        ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        updateList.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)dvObj.getDevice(), 2));
        DataobjectManager.getInstance().updateObject("Merge", updateList);
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "UsbDeviceHandler.Delete.Description");
        Object[] obj = new Object[]{dvObj.getName()};
        desc = MessageFormat.format(desc, obj);
        ConsoleLogger.logPolicyEvent(1, dvObj.getId(), desc, null);
        System.out.println("DeviceHandler>> deleteDevices: Done!");
        return found;
    }

    public static void addDevice(DeviceObject deviceObject) throws Exception {
        ArrayList<DataobjectManager.UpdateObjectEntry> listObjs = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        DataobjectManager manager = DataobjectManager.getInstance();
        OpDevice opDevice = deviceObject.getDevice();
        opDevice.validate();
        listObjs.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)opDevice, 1));
        SemDomain domain = AdminHandler.retrieveCurrentDomain(false);
        ObjectPool pool = domain.getObjectPool();
        OpDevicePool poolOpDevice = pool.getOptOpDevicePool();
        if (poolOpDevice == null) {
            poolOpDevice = new OpDevicePool();
            pool.setOptOpDevicePool(poolOpDevice);
        }
        ObjReference ref = new ObjReference();
        ref.setName("OpDevice link");
        ref.setTargetType("OpDevice");
        ref.setTargetId(opDevice.getId());
        poolOpDevice.addObjReference(ref);
        listObjs.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)domain, 0));
        manager.updateObject("Merge", listObjs);
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "UsbDeviceHandler.Add.Description");
        Object[] obj = new Object[]{opDevice.getName()};
        desc = MessageFormat.format(desc, obj);
        ConsoleLogger.logPolicyEvent(0, opDevice.getId(), desc, null);
    }

    public static ArrayList<DeviceObject> refreshDevices(List<DeviceObject> listDevices) throws Exception {
        if (listDevices == null || listDevices.size() < 1) {
            return null;
        }
        ArrayList<DeviceObject> list = new ArrayList<DeviceObject>();
        DataobjectManager data = DataobjectManager.getInstance();
        for (DeviceObject device : listDevices) {
            DeviceObject newDevice;
            block6: {
                newDevice = null;
                try {
                    OpDevice opDevice = data.getOpDevice(device.getId());
                    if (opDevice != null) {
                        newDevice = new DeviceObject(opDevice);
                    }
                }
                catch (ConsoleException ex) {
                    if (!ex.needRelogin()) break block6;
                    throw ex;
                }
            }
            if (newDevice != null) {
                list.add(newDevice);
                continue;
            }
            list.add(device);
        }
        return list;
    }

    public static void updateDevice(DeviceObject deviceObject) throws Exception {
        DataobjectManager manager = DataobjectManager.getInstance();
        OpDevice opDevice = deviceObject.getDevice();
        opDevice.validate();
        manager.updateObject("Merge", (TopLevelObject)opDevice);
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "UsbDeviceHandler.Edit.Description");
        Object[] obj = new Object[]{opDevice.getName()};
        desc = MessageFormat.format(desc, obj);
        ConsoleLogger.logPolicyEvent(2, opDevice.getId(), desc, null);
        System.out.println("DeviceHandler>> updateDevice: updated ComputerImage id=" + opDevice.getId() + ", name=" + opDevice.getName());
    }

    private static DeviceObject getDevice(String value, boolean isName, boolean isInsanceId) throws Exception {
        if (value == null || value.length() < 1) {
            return null;
        }
        SemDomain domain = AdminHandler.retrieveCurrentDomain(false);
        ObjectPool pool = domain.getObjectPool();
        OpDevicePool poolDevices = pool.getOptOpDevicePool();
        if (poolDevices == null) {
            System.out.println("DeviceHandler>> getDevice: Done! Pool is null!");
            return null;
        }
        DataobjectManager data = DataobjectManager.getInstance();
        System.out.println("DeviceHandler>> getDevice: size=" + poolDevices.getObjReferenceCount());
        for (int i = 0; i < poolDevices.getObjReferenceCount(); ++i) {
            ObjReference ref = poolDevices.getObjReference(i);
            try {
                OpDevice opDevice = data.getOpDevice(ref.getTargetId());
                if (opDevice == null || !(isName && opDevice.getName().equals(value) || isInsanceId && value.equals(opDevice.getOptDeviceInstanceId())) && (isInsanceId || !value.equals(opDevice.getOptDeviceClassGuid()))) continue;
                System.out.println("DeviceHandler>> getDevice: Found! opDevice id=" + opDevice.getId() + ", name=" + opDevice.getName() + ", classID=" + opDevice.getOptDeviceClassGuid());
                return new DeviceObject(opDevice);
            }
            catch (ConsoleException ex) {
                if (!ex.needRelogin()) continue;
                throw ex;
            }
        }
        return null;
    }

    public static boolean canDelete(DeviceObject device) {
        if (device == null || !device.isValid()) {
            return true;
        }
        try {
            DataobjectManager data = DataobjectManager.getInstance();
            SemDomain domain = AdminHandler.retrieveCurrentDomain(false);
            ObjectPool pool = domain.getObjectPool();
            OpAppProtectionPolicyPool poolAppProtectionPolicy = pool.getOptOpAppProtectionPolicyPool();
            if (poolAppProtectionPolicy == null || poolAppProtectionPolicy.getObjReferenceCount() < 1) {
                return true;
            }
            for (int i = 0; i < poolAppProtectionPolicy.getObjReferenceCount(); ++i) {
                OpExcludedDeviceArray allowedDevices;
                ObjReference ref = poolAppProtectionPolicy.getObjReference(i);
                OpAppProtectionPolicy policy = data.getOpAppProtectionPolicy(ref.getTargetId());
                AppProtectionSetting setting = policy.getAppProtectionSetting();
                OpDeviceBlocker deviceBloker = setting.getOptOpDeviceBlocker();
                if (deviceBloker == null) continue;
                OpBlockedDeviceClassArray blockedDevices = deviceBloker.getOptOpBlockedDeviceClassArray();
                if (blockedDevices != null && blockedDevices.getObjReferenceCount() > 0) {
                    for (int j = 0; j < blockedDevices.getObjReferenceCount(); ++j) {
                        ObjReference refBlocked = blockedDevices.getObjReference(j);
                        if (!refBlocked.getTargetId().equals(device.getId())) continue;
                        return false;
                    }
                }
                if ((allowedDevices = deviceBloker.getOptOpExcludedDeviceArray()) == null || allowedDevices.getObjReferenceCount() <= 0) continue;
                for (int j = 0; j < allowedDevices.getObjReferenceCount(); ++j) {
                    ObjReference refAllowed = allowedDevices.getObjReference(j);
                    if (!refAllowed.getTargetId().equals(device.getId())) continue;
                    return false;
                }
            }
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return true;
    }

    public static ArrayList<OpDevice> getAllDevicesFromPool() throws ConsoleException {
        return UsbDeviceHandler.getPooledDevicesByPlatform(null);
    }

    public static ArrayList<OpDevice> getPooledDevicesByPlatform(Integer platform) throws ConsoleException {
        ArrayList<OpDevice> list = new ArrayList<OpDevice>();
        SemDomain domain = AdminHandler.retrieveCurrentDomain(false);
        ObjectPool pool = domain.getObjectPool();
        OpDevicePool poolDevices = pool.getOptOpDevicePool();
        if (poolDevices == null) {
            ConsoleLogger.log("DeviceHandler>> getPooledDevicesByPlatform: Done! Pool is null!");
            return list;
        }
        DataobjectManager data = DataobjectManager.getInstance();
        for (int i = 0; i < poolDevices.getObjReferenceCount(); ++i) {
            ObjReference ref = poolDevices.getObjReference(i);
            try {
                OpDevice opDevice = data.getOpDevice(ref.getTargetId());
                if (opDevice == null) continue;
                Integer osType = opDevice.getOptPlatform();
                if (osType == null) {
                    osType = opDevice.getDefPlatform();
                }
                if (platform != null && !platform.equals(osType)) continue;
                list.add(opDevice);
                continue;
            }
            catch (ConsoleException ex) {
                if (!ex.needRelogin()) continue;
                throw ex;
            }
        }
        return list;
    }

    public static boolean hasDeviceInPool(String name) throws Exception {
        return UsbDeviceHandler.getDeviceByName(name) != null;
    }

    public static boolean hasDeviceClassIdInPool(String classId) throws Exception {
        return UsbDeviceHandler.getDeviceByClassId(classId) != null;
    }

    public static boolean hasDeviceInstanceIdInPool(String instanceId) throws Exception {
        return UsbDeviceHandler.getDeviceByInstanceId(instanceId) != null;
    }

    public static DeviceObject getDeviceByName(String name) throws Exception {
        ArrayList<OpDevice> list = UsbDeviceHandler.getPooledDevicesByPlatform(OpDevice.WINDOWS);
        for (OpDevice device : list) {
            if (!device.getName().equals(name)) continue;
            return new DeviceObject(device);
        }
        return null;
    }

    public static DeviceObject getMacDeviceByName(String name) throws Exception {
        ArrayList<OpDevice> list = UsbDeviceHandler.getPooledDevicesByPlatform(OpDevice.MAC);
        for (OpDevice device : list) {
            if (!device.getName().equals(name)) continue;
            return new DeviceObject(device);
        }
        return null;
    }

    public static DeviceObject getDeviceByClassId(String classId) throws Exception {
        return UsbDeviceHandler.getDevice(classId, false, false);
    }

    public static DeviceObject getDeviceByInstanceId(String instanceId) throws Exception {
        return UsbDeviceHandler.getDevice(instanceId, false, true);
    }

    public static Hashtable<String, ArrayList<DeviceObject>> getDevicesFromOSProtecteionPolicy(OpAppProtectionPolicy policy, int retrieveMode) throws Exception {
        OpExcludedDeviceArray allowedDevices;
        OpDevice opDevice;
        ObjReference ref;
        int j;
        int count;
        OpBlockedDeviceClassArray blockedDevices;
        if (policy == null) {
            return null;
        }
        AppProtectionSetting setting = policy.getAppProtectionSetting();
        OpDeviceBlocker deviceBloker = setting.getOptOpDeviceBlocker();
        if (deviceBloker == null) {
            return null;
        }
        DataobjectManager data = DataobjectManager.getInstance();
        Hashtable<String, ArrayList<DeviceObject>> table = null;
        if ((retrieveMode == 0 || retrieveMode == 1) && (blockedDevices = deviceBloker.getOptOpBlockedDeviceClassArray()) != null && blockedDevices.getObjReferenceCount() > 0) {
            count = blockedDevices.getObjReferenceCount();
            ArrayList<DeviceObject> listBlockedDevices = new ArrayList<DeviceObject>(count);
            for (j = 0; j < count; ++j) {
                ref = blockedDevices.getObjReference(j);
                opDevice = data.getOpDevice(ref.getTargetId());
                listBlockedDevices.add(new DeviceObject(opDevice));
            }
            if (listBlockedDevices != null && listBlockedDevices.size() > 0) {
                if (table == null) {
                    table = new Hashtable<String, ArrayList<DeviceObject>>(2);
                }
                table.put("BLOCK", listBlockedDevices);
            }
        }
        if ((retrieveMode == 0 || retrieveMode == 2) && (allowedDevices = deviceBloker.getOptOpExcludedDeviceArray()) != null && allowedDevices.getObjReferenceCount() > 0) {
            count = allowedDevices.getObjReferenceCount();
            ArrayList<DeviceObject> listAllowedDevices = new ArrayList<DeviceObject>(count);
            for (j = 0; j < count; ++j) {
                ref = allowedDevices.getObjReference(j);
                opDevice = data.getOpDevice(ref.getTargetId());
                listAllowedDevices.add(new DeviceObject(opDevice));
            }
            if (listAllowedDevices != null && listAllowedDevices.size() > 0) {
                if (table == null) {
                    table = new Hashtable(2);
                }
                table.put("ALLOW", listAllowedDevices);
            }
        }
        return table;
    }

    public static List<DeviceObject> getMacBlockList(MacAppProtectionSetting settings) throws ConsoleException {
        ArrayList<DeviceObject> retList = new ArrayList<DeviceObject>();
        if (settings == null) {
            return retList;
        }
        MacOpDeviceBlocker deviceBloker = settings.getOptMacOpDeviceBlocker();
        if (deviceBloker == null) {
            return retList;
        }
        DataobjectManager data = DataobjectManager.getInstance();
        MacOpBlockedDeviceList blockedDevices = deviceBloker.getOptMacOpBlockedDeviceList();
        if (blockedDevices != null) {
            for (ExtendedOpDevice device : blockedDevices.getExtendedOpDevice()) {
                ObjReference ref = device.getObjReference();
                OpDevice opDevice = data.getOpDevice(ref.getTargetId());
                DeviceObject item = new DeviceObject(opDevice);
                item.setDeviceModel(device.getOptModel());
                item.setDeviceVendor(device.getOptVendor());
                item.setSerialNumber(device.getOptSerialNumber());
                retList.add(item);
            }
        }
        return retList;
    }

    public static List<DeviceObject> getMacBlockExceptionList(MacAppProtectionSetting settings) throws ConsoleException {
        ArrayList<DeviceObject> retList = new ArrayList<DeviceObject>();
        if (settings == null) {
            return retList;
        }
        MacOpDeviceBlocker deviceBloker = settings.getOptMacOpDeviceBlocker();
        if (deviceBloker == null) {
            return retList;
        }
        DataobjectManager data = DataobjectManager.getInstance();
        MacOpExcludedDeviceList allowedDevices = deviceBloker.getOptMacOpExcludedDeviceList();
        if (allowedDevices != null) {
            for (ExtendedOpDevice device : allowedDevices.getExtendedOpDevice()) {
                ObjReference ref = device.getObjReference();
                OpDevice opDevice = data.getOpDevice(ref.getTargetId());
                DeviceObject item = new DeviceObject(opDevice);
                item.setPermission(device.getOptPermission());
                item.setDeviceModel(device.getOptModel());
                item.setDeviceVendor(device.getOptVendor());
                item.setSerialNumber(device.getOptSerialNumber());
                retList.add(item);
            }
        }
        return retList;
    }
}

