/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.action.DownloadFiles;
import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.rpc.SemLoginInfo;
import com.sygate.scm.common.configobject.schema.AppliedImage;
import com.sygate.scm.common.configobject.schema.AppliedImageArray;
import com.sygate.scm.common.configobject.schema.AutoUpgradeContentOption;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.CommunicationOption;
import com.sygate.scm.common.configobject.schema.ComputerImage;
import com.sygate.scm.common.configobject.schema.ComputerLockdownProtection;
import com.sygate.scm.common.configobject.schema.DeploymentNotification;
import com.sygate.scm.common.configobject.schema.DeploymentSchedule;
import com.sygate.scm.common.configobject.schema.DeploymentSnooze;
import com.sygate.scm.common.configobject.schema.GlobalObjectPool;
import com.sygate.scm.common.configobject.schema.Inheritance;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.LockdownSet;
import com.sygate.scm.common.configobject.schema.LuDownloadedContentArray;
import com.sygate.scm.common.configobject.schema.LuDownloadedContentPool;
import com.sygate.scm.common.configobject.schema.LuPackageContent;
import com.sygate.scm.common.configobject.schema.LuRegistration;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.PackageInfo;
import com.sygate.scm.common.configobject.schema.PackageLuInfo;
import com.sygate.scm.common.configobject.schema.PackageSource;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.configobject.schema.RecycleBin;
import com.sygate.scm.common.configobject.schema.SecurityFixContentInfo;
import com.sygate.scm.common.configobject.schema.SemAgentPolicy;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SemGroupPolicy;
import com.sygate.scm.common.configobject.schema.SemServerBlock;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.configobject.schema.SemServerListPool;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SemSiteArray;
import com.sygate.scm.common.configobject.schema.SoftwareDeploymentEntity;
import com.sygate.scm.common.configobject.schema.SoftwareDeploymentPolicy;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.configobject.schema.SoftwarePackagePool;
import com.sygate.scm.common.configobject.schema.SuspendedItem;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.util.ClientPackageUtils;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.CommunicationObject;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.RecycleBinObject;
import com.sygate.scm.console.logicobject.SecurityFixContentInfoObject;
import com.sygate.scm.console.logicobject.ServerListObject;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.logicobject.SoftwareDeploymentEntityObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.logicobject.WhiteListObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationFeatureObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationSettingObject;
import com.sygate.scm.console.ui.client.ExportPackageSettings;
import com.sygate.scm.console.ui.client.ExportPackageWorker;
import com.sygate.scm.console.ui.client.PackageWorker;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.AutoUpgradeUtils;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.DeterministicIdWasher;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.ZipUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;

public class SoftwarePackageHandler
extends AbstractHandler {
    public static final int RETRIEVAL_MODE_ALL = 0;
    public static final int RETRIEVAL_MODE_CURRENT = 1;
    public static final int RETRIEVAL_MODE_RECYCLEBIN = 2;
    public static final int SUCCESSFUL = 1;
    public static final int INVALID_CHECKSUM = 2;
    public static final int FAIL_CREATE_PACKAGE = 3;
    public static final int PACKAGE_NONRELEASED = 5;
    public static final int SEPM_INTERNAL_ERROR = 6;
    public static final int CONNECTION_FAILED = 7;
    public static final int PACKAGE_UNZIP_FAILED = 8;
    public static final int PACKAGE_CANCELLED = 9;
    public static final String KEY_NAME_PACKAGE = "PACKAGE";
    public static final String KEY_NAME_ENTITY = "ENTITY";
    private static MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.ui.admin.dlg.admindialog");

    public static int unzipPackage(String zipFile, String destFolder) {
        File folder = new File(destFolder);
        if (folder.exists()) {
            if (folder.isFile()) {
                Utility.delete((File)folder);
            } else {
                Utility.deleteDir((String)destFolder);
            }
            if (!folder.mkdirs()) {
                return 8;
            }
        }
        try {
            if (!ZipUtil.unzipFile((String)zipFile, (String)destFolder)) {
                return 8;
            }
        }
        catch (Exception e) {
            return 8;
        }
        return 1;
    }

    public static void delPackage(RecycleBinObject pobj) throws ConsoleException {
        SoftwarePackage sp = pobj.getSoftwarePackage();
        if (sp == null) {
            return;
        }
        RecycleBin rb = SoftwarePackageHandler.getRecycleBin();
        if (rb == null) {
            return;
        }
        int len = rb.getSuspendedItemCount();
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            SuspendedItem item = rb.getSuspendedItem(i);
            ObjReference obj = item.getObjReference();
            if (!obj.getTargetId().equals(sp.getId())) continue;
            obj.getParent().removeChild((AbstractSchema)obj);
            item.getParent().removeChild((AbstractSchema)item);
            SoftwarePackageHandler.recycleBinUpdated();
            ConsoleLogger.logAdminEvent(12290);
            break;
        }
    }

    public static void delPackage(CurrentPackageObject cobj) throws ConsoleException {
        ConsoleLogger.log("SoftwarePackageHandler>> delPackage: Begin...");
        TimeCounter counter = new TimeCounter();
        counter.start();
        ArrayList<DataobjectManager.UpdateObjectEntry> listObjs = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        SoftwarePackage sp = cobj.getSoftwarePackage();
        if (sp == null || (sp = DataobjectManager.getInstance().getSoftwarePackage(sp.getId())) == null) {
            return;
        }
        DataobjectManager data = DataobjectManager.getInstance();
        sp.setOptSuspended(Boolean.TRUE);
        listObjs.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)sp, 0));
        data.updateObject("Merge", listObjs);
        String packagePhysicalFileId = null;
        PackageInfo pi = sp.getPackageInfo();
        for (int i = 0; i < pi.getObjReferenceCount(); ++i) {
            ObjReference obj = pi.getObjReference(i);
            if (!obj.getTargetType().equals("PhysicalFile") || !obj.getName().equals("PackageFileLink")) continue;
            packagePhysicalFileId = obj.getTargetId();
            break;
        }
        ConsoleLogger.log("SoftwarePackageHandler>> delPackage: packagePhysicalFileId: " + packagePhysicalFileId);
        TopLevelObject binaryFileObj = DataobjectManager.getInstance().getObjectByGUID("PhysicalFile", packagePhysicalFileId);
        PhysicalFile packagePhysicalFile = (PhysicalFile)binaryFileObj;
        if (packagePhysicalFile == null) {
            return;
        }
        String idPackageBinary = packagePhysicalFile.getObjReference().getTargetId();
        ConsoleLogger.log("SoftwarePackageHandler>> delPackage: idPackageBinary: " + idPackageBinary);
        if (Boolean.TRUE.equals(sp.getPackageInfo().getOptSecurityFixPackage())) {
            ConsoleLogger.log("SoftwarePackageHandler>> delPackage Security Fix Package! All contents will be cleanned later by PackageTask!");
        } else {
            GUIManager.deleteFile(idPackageBinary);
        }
        String msg = res.getString("SoftwarePackageHandler.PackageDeleted");
        Object[] obj = new Object[]{sp.getName()};
        msg = MessageFormat.format(msg, obj);
        ConsoleLogger.logAdminEvent(12290, msg);
        ConsoleLogger.log("SoftwarePackageHandler>> delPackage: Done! elapsed time=" + counter.getDuration() + " (" + counter.getDuration() / 1000L + "s)");
    }

    public static boolean addPackage(CurrentPackageObject currentPackage, String physicalFileName) throws ConsoleException {
        return SoftwarePackageHandler.addPackage(currentPackage, physicalFileName, false);
    }

    public static boolean addPackage(CurrentPackageObject pobj, String physicalFileName, boolean isAutomation) throws ConsoleException {
        ConsoleLogger.log("SoftwarePackageHandler>> addPackage: Begin...");
        SoftwarePackage sp = pobj.getSoftwarePackage();
        DataobjectManager data = DataobjectManager.getInstance();
        if (sp == null) {
            return false;
        }
        if (SoftwarePackageHandler.isPackageExisted(sp)) {
            if (isAutomation) {
                throw new ConsoleException("Package is already existed!");
            }
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.packageExists"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.error"), 0);
            return false;
        }
        boolean serverTempDirCleanUpRequired = false;
        try {
            if (pobj.getPackagePlatformString().equals("WIN32BIT") || pobj.getPackagePlatformString().equals("WIN64BIT")) {
                ConsoleLogger.log("CreateNewPackageWorker>> doAddPackage>> Win Package: " + pobj.toString());
                PackageLuInfo luInfo = pobj.getSoftwarePackage().getPackageInfo().getOptPackageLuInfo();
                if (luInfo == null) {
                    throw new ConsoleException("CreateNewPackageWorker>> doAddPackage>> Win Package: Security Fix: missing PackageLuInfo");
                }
                LuRegistration luSFReg = LuUtility.getSFContentLuRegistration(pobj.getPackagePlatformString(), luInfo.getServerVersion(), luInfo.getServerLanguage());
                if (luSFReg != null && luSFReg.getOptLuClientRegistration() != null) {
                    ClientPackageUtils.SetAidIni setAidIni = new ClientPackageUtils.SetAidIni(physicalFileName);
                    ClientPackageUtils.SetupIni setupIni = new ClientPackageUtils.SetupIni(physicalFileName);
                    ConsoleLogger.log("CreateNewPackageWorker>> doAddPackage: Security Fix: uploading package to server...");
                    GUIManager.uploadBinaryFileToDir(physicalFileName, Paths.get(physicalFileName, new String[0]).toFile().getName(), null, true);
                    serverTempDirCleanUpRequired = true;
                    ConsoleLogger.log("CreateNewPackageWorker>> doAddPackage: Security Fix: sending process LU content request...");
                    GUIManager.processLUContent(ConstantValue.TEMP_PACKAGE_RELATIVE_PATH + File.separator + Paths.get(physicalFileName, new String[0]).toFile().getName() + ".decompress", luSFReg.getLuServerRegistration().getMoniker(), luSFReg.getOptLuClientRegistration().getMoniker(), luInfo.getSequenceNumber(), luInfo.getOptSequenceTag(), luSFReg.getLuServerRegistration().getProduct(), luSFReg.getLuServerRegistration().getVersion(), luSFReg.getLuServerRegistration().getLanguage(), pobj.getPackageName(), pobj.getDescription());
                    SoftwarePackage pkgSaved = SoftwarePackageHandler.getSecurityFixSoftwarePackageByPVL(setAidIni);
                    if (pkgSaved == null) {
                        throw new ConsoleException("Cannot find the new updated Security Fix package!");
                    }
                    pobj.setSoftwarePackage(pkgSaved);
                    String msg = res.getString("SoftwarePackageHandler.NewPackageWithBuildNumberImported");
                    Object[] obj = new Object[]{pkgSaved.getName(), setupIni.getProductVersion()};
                    msg = MessageFormat.format(msg, obj);
                    ConsoleLogger.logAdminEvent(12289, msg);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new ConsoleException(exc);
        }
        finally {
            if (serverTempDirCleanUpRequired) {
                try {
                    GUIManager.cleanUpTempPackageFolderCDW();
                }
                catch (ConsoleException ex) {
                    ConsoleLogger.log("CreateNewPackageWorker>> doAddPackage: Security Fix: Failed to clean up server temp packageg folder");
                }
            }
        }
        String newBinaryFileID = Utility.generateBinaryFileID((SoftwarePackage)sp);
        GUIManager.deleteSoftwarePackageBeforeAdd(newBinaryFileID);
        TimeCounter counter = new TimeCounter();
        counter.start();
        String binaryFileID = Utility.generateBinaryFileID((SoftwarePackage)sp);
        PhysicalFile physicalFile = SoftwarePackageHandler.addPhysicalFile(pobj.getPackageName(), physicalFileName, binaryFileID, "ClientPackageFile");
        sp.setCreationTime(Long.valueOf(TimeUtil.getServerTime()));
        ObjReference objFile = new ObjReference();
        objFile.setTargetId(physicalFile.getId());
        objFile.setTargetType("PhysicalFile");
        objFile.setOptDescription("PhysicalFile");
        objFile.setOptEnable(Boolean.TRUE);
        objFile.setName("PackageFileLink");
        PackageInfo _pi = sp.getPackageInfo();
        _pi.addObjReference(objFile);
        _pi.setCreationTime(sp.getCreationTime());
        _pi.setLastModifiedTime(sp.getCreationTime());
        String platformType = _pi.getOptPlatformType();
        if ("WIN32BIT".equals(platformType) || "WIN64BIT".equals(platformType)) {
            PackageUtil.setPackageSizeToPackageInfo((PackageInfo)_pi, (String)physicalFileName);
        } else {
            _pi.setSize(physicalFile.getFileSize());
        }
        if (pobj.getImportServerList() != null) {
            String serverListId = pobj.getImportServerList().getId();
            CommunicationOption communicationOption = SoftwarePackageObject.newCommunicationOption(serverListId);
            sp.setOptCommunicationOption(communicationOption);
        }
        DeterministicIdWasher.resetSoftwarePackageIDs((SoftwarePackage)sp);
        boolean rootChanged = false;
        SemConfigRoot configRoot = data.getSemConfigRoot();
        GlobalObjectPool globalObjPool = configRoot.getOptGlobalObjectPool();
        if (globalObjPool == null) {
            globalObjPool = new GlobalObjectPool();
            configRoot.setOptGlobalObjectPool(globalObjPool);
            rootChanged = true;
        }
        LuDownloadedContentPool downloadedCntPool = globalObjPool.getOptLuDownloadedContentPool();
        LuDownloadedContentArray luContentArray = null;
        if (downloadedCntPool == null) {
            downloadedCntPool = new LuDownloadedContentPool();
            globalObjPool.setOptLuDownloadedContentPool(downloadedCntPool);
            luContentArray = new LuDownloadedContentArray();
            String luContentArrayID = Utility.calculateHash((String)"B655E64D0A320801000000E164041B79luArray");
            luContentArray.setId(luContentArrayID);
            luContentArray.setName("LuDownloadedContentArray");
            luContentArray = data.addLuDownloadedContentArray(luContentArray);
            ObjReference cntArrayObj = new ObjReference();
            cntArrayObj.setName(luContentArray.getName());
            cntArrayObj.setTargetId(luContentArrayID);
            cntArrayObj.setTargetType(luContentArray.getObjectTypeName());
            downloadedCntPool.setObjReference(cntArrayObj);
            rootChanged = true;
        } else {
            ObjReference objRef = downloadedCntPool.getObjReference();
            String cntArrayId = objRef.getTargetId();
            luContentArray = data.getLuDownloadedContentArray(cntArrayId);
            if (luContentArray == null) {
                throw new ConsoleException(0x16010000, 54);
            }
        }
        DataobjectManager dataMgr = DataobjectManager.getInstance();
        SoftwarePackageHandler.removePackageFromLuArray(luContentArray, sp.getId());
        LuPackageContent pkgContent = new LuPackageContent();
        ObjReference spRef = new ObjReference();
        spRef.setTargetId(sp.getId());
        spRef.setTargetType("SoftwarePackage");
        spRef.setOptDescription("SoftwarePackage");
        spRef.setOptEnable(Boolean.TRUE);
        spRef.setName("SoftwarePackageLink");
        pkgContent.setObjReference(spRef);
        PackageLuInfo luInfo = _pi.getOptPackageLuInfo();
        if (luInfo == null) {
            throw new ConsoleException(-535298048, 146);
        }
        pkgContent.setOptClientMoniker(luInfo.getClientMoniker());
        pkgContent.setServerMoniker(luInfo.getServerMoniker());
        pkgContent.setSequenceNum(luInfo.getSequenceNumber());
        pkgContent.setOptSequenceTag(luInfo.getOptSequenceTag());
        pkgContent.setServerVersion(luInfo.getServerVersion());
        pkgContent.setServerProduct(luInfo.getServerProduct());
        pkgContent.setServerLanguage(luInfo.getServerLanguage());
        DeterministicIdWasher.resetConsistantIDs((ConfigObject)pkgContent, (String)(luInfo.getClientMoniker() + luInfo.getSequenceNumber()));
        luContentArray.addLuPackageContent(pkgContent);
        dataMgr.updateLuDownloadedContentArray("Merge", luContentArray);
        if (rootChanged) {
            dataMgr.updateSemConfigRoot("Merge", configRoot);
        }
        SoftwarePackageHandler.deleteObjectBeforeAdd((TopLevelObject)sp);
        dataMgr.addObject((TopLevelObject)sp, true, true);
        sp = SoftwarePackageHandler.retrieveSoftwarePackage(sp.getId());
        pobj.setSoftwarePackage(sp);
        String msg = res.getString("SoftwarePackageHandler.NewPackageImported");
        Object[] obj = new Object[]{sp.getName()};
        msg = MessageFormat.format(msg, obj);
        ConsoleLogger.logAdminEvent(12289, msg);
        counter.stop();
        ConsoleLogger.log("SoftwarePackageHandler>> addPackage: Done! elapsed time=" + counter.getDuration() + " (" + counter.getDuration() / 1000L + "s)");
        return true;
    }

    public static PhysicalFile addPhysicalFile(String name, String physicalFileName, String physicalFileBinaryDataId, String fileType) throws ConsoleException {
        return SoftwarePackageHandler.addPhysicalFile(name, physicalFileName, physicalFileBinaryDataId, fileType, false);
    }

    public static PhysicalFile addPhysicalFile(String name, String physicalFileName, String physicalFileBinaryDataId, String fileType, boolean isWhiteList) throws ConsoleException {
        ConsoleLogger.log("SoftwarePackageHandler>> addPhysicalFile: Begin...");
        TimeCounter counter = new TimeCounter();
        String physicalFileId = Utility.calculateHash((String)(physicalFileBinaryDataId + "PhysicalFile"));
        counter.start();
        ConsoleLogger.log("\tBegin to add PhysicalFile Data (remote): " + physicalFileBinaryDataId + ", " + physicalFileName);
        String checksum = GUIManager.addFile(physicalFileBinaryDataId, physicalFileName, fileType);
        counter.stop();
        PhysicalFile pf = SoftwarePackageHandler.createSemPhysicalFile(physicalFileId, physicalFileBinaryDataId, physicalFileName, isWhiteList ? "WhiteListFile" : "ClientPackageFile", name, checksum);
        DataobjectManager data = DataobjectManager.getInstance();
        ConsoleLogger.log("\tDone with adding PhysicalFile Data (remote): id=" + physicalFileBinaryDataId + ", name=" + pf.getName() + ", elapsed time=" + counter.toString());
        DeterministicIdWasher.resetPhysicalFileIDs((PhysicalFile)pf);
        counter.start();
        ConsoleLogger.log("\tBegin to add PhysicalFile XML (remote): " + pf.getId() + ", " + pf.getName());
        SoftwarePackageHandler.deleteObjectBeforeAdd((TopLevelObject)pf);
        data.addObject((TopLevelObject)pf, !isWhiteList, true);
        counter.stop();
        ConsoleLogger.log("\tDone with adding PhysicalFile XML (remote): id=" + pf.getId() + ", name=" + pf.getName() + ", elapsed time=" + counter.toString());
        ConsoleLogger.log("SoftwarePackageHandler>> addPhysicalFile: Done!");
        return pf;
    }

    public static void updatePackage(CurrentPackageObject pobj) throws ConsoleException {
        SoftwarePackage sp = pobj.getSoftwarePackage();
        if (sp == null) {
            return;
        }
        sp.getPackageInfo().setLastModifiedTime(Long.valueOf(TimeUtil.getServerTime()));
        DataobjectManager data = DataobjectManager.getInstance();
        data.updateObject("Merge", (TopLevelObject)sp);
    }

    public static void deleteSoftwareDeploymentEntity(GroupObject group, SoftwareDeploymentEntity entity) throws ConsoleException {
        if (entity == null) {
            return;
        }
        SoftwareDeploymentPolicy policy = SoftwarePackageHandler.getSoftwareDeploymentPolicy(group);
        if (policy == null) {
            return;
        }
        SoftwarePackageHandler.deleteSoftwareDeploymentEntity(policy, entity);
    }

    public static void deleteSoftwareDeploymentEntity(SoftwareDeploymentPolicy policy, SoftwareDeploymentEntity entity) throws ConsoleException {
        SoftwarePackageHandler.deleteSoftwareDeploymentEntityWithoutSave(policy, entity);
        DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)policy);
    }

    public static void deleteSoftwareDeploymentEntityWithoutSave(SoftwareDeploymentPolicy policy, SoftwareDeploymentEntity entity) throws ConsoleException {
        DataobjectManager manager;
        ClientInstallationSettingObject sOldInstallSettingObject;
        ObjReference objCIRef;
        DataobjectManager manager2;
        ClientInstallationFeatureObject sOldObject;
        if (entity == null || policy == null) {
            return;
        }
        Vector entities = policy.getSoftwareDeploymentEntity();
        for (int i = 0; i < entities.size(); ++i) {
            SoftwareDeploymentEntity currentEntity = (SoftwareDeploymentEntity)entities.get(i);
            if (!currentEntity.getI().equals(entity.getI())) continue;
            entity = currentEntity;
            break;
        }
        policy.removeSoftwareDeploymentEntity(entity);
        ObjReference objCIFRef = entity.getObjReferenceByType("ClientInstallationFeatures");
        if (objCIFRef != null && !(sOldObject = new ClientInstallationFeatureObject((manager2 = DataobjectManager.getInstance()).getClientInstallationFeatures(objCIFRef.getTargetId()))).isSystemObject()) {
            sOldObject.decRefCount();
            manager2.updateClientInstallationFeatures("Merge", sOldObject.getClientInstallationFeatures());
        }
        if ((objCIRef = entity.getObjReferenceByType("ClientInstallationSettings")) != null && !(sOldInstallSettingObject = new ClientInstallationSettingObject((manager = DataobjectManager.getInstance()).getClientInstallationSettings(objCIRef.getTargetId()))).isSystemObject()) {
            sOldInstallSettingObject.decRefCount();
            manager.updateClientInstallationSettings("Merge", sOldInstallSettingObject.getClientInstallationSettings());
        }
    }

    public static void deleteSoftwareDeploymentEntity(GroupObject group, String packageId) throws ConsoleException {
        if (packageId == null || packageId.length() < 1) {
            return;
        }
        SoftwareDeploymentPolicy policy = SoftwarePackageHandler.getSoftwareDeploymentPolicy(group);
        if (policy == null) {
            return;
        }
        int entityCount = policy.getSoftwareDeploymentEntityCount();
        if (entityCount < 1) {
            return;
        }
        for (int i = 0; i < entityCount; ++i) {
            ObjReference or;
            SoftwareDeploymentEntity entity = policy.getSoftwareDeploymentEntity(i);
            if (entity == null || !(or = entity.getObjReferenceByTypeAndName("SoftwarePackage", "TargetSoftwarePackageLink")).getTargetId().equals(packageId)) continue;
            SoftwarePackageHandler.deleteSoftwareDeploymentEntity(policy, entity);
            return;
        }
    }

    public static ArrayList<String> retrieveGroupsWithForceDeployment(ArrayList<String> listGroupIds, String packageId, String platform, String language) throws ConsoleException {
        if (listGroupIds == null) {
            return null;
        }
        ArrayList<String> listGroupObjs = new ArrayList<String>(listGroupIds.size());
        for (int i = 0; i < listGroupIds.size(); ++i) {
            GroupObject groupObj = GroupHandler.getGroupById(listGroupIds.get(i));
            SoftwareDeploymentEntity entity = SoftwarePackageHandler.retrieveSoftwareDeploymentEntityWithFroceDeployment(groupObj);
            if (entity == null) continue;
            String currentPackageId = entity.getObjReferenceByTypeAndName("SoftwarePackage", "TargetSoftwarePackageLink").getTargetId();
            if (packageId != null && packageId.equals(currentPackageId)) continue;
            SoftwarePackage softwarePackage = SoftwarePackageHandler.getSoftwarePackage(currentPackageId, true);
            PackageInfo packageInfo = softwarePackage.getPackageInfo();
            String currentPlatform = packageInfo.getOptPlatformType();
            if (currentPlatform == null) {
                currentPlatform = packageInfo.getDefPlatformType();
            }
            String currentLanguage = packageInfo.getOptLanuage();
            if (!currentPlatform.equals(platform) || language != null && !language.equals(currentLanguage) || language == null && currentLanguage != null) continue;
            listGroupObjs.add(GroupHandler.getGroupFullPath(groupObj));
        }
        return listGroupObjs;
    }

    public static SoftwareDeploymentEntity retrieveSoftwareDeploymentEntityWithFroceDeployment(GroupObject groupObj) throws ConsoleException {
        SoftwareDeploymentPolicy policy = SoftwarePackageHandler.getSoftwareDeploymentPolicy(groupObj);
        if (policy == null) {
            return null;
        }
        return SoftwarePackageHandler.retrieveSoftwareDeploymentEntityWithFroceDeployment(policy);
    }

    public static SoftwareDeploymentEntity retrieveSoftwareDeploymentEntityWithFroceDeployment(SoftwareDeploymentPolicy policy) {
        if (policy == null) {
            return null;
        }
        int entityCount = policy.getSoftwareDeploymentEntityCount();
        if (entityCount < 1) {
            return null;
        }
        for (int i = 0; i < entityCount; ++i) {
            SoftwareDeploymentEntity entity = policy.getSoftwareDeploymentEntity(i);
            if (entity == null || entity.getOptForceDeployment() == null || !entity.getOptForceDeployment().booleanValue()) continue;
            return entity;
        }
        return null;
    }

    public static SoftwareDeploymentEntity retrieveSoftwareDeploymentEntityWithAutoUpgradeToEnglisg(GroupObject groupObj) throws ConsoleException {
        SoftwareDeploymentPolicy policy = SoftwarePackageHandler.getSoftwareDeploymentPolicy(groupObj);
        if (policy == null) {
            return null;
        }
        return SoftwarePackageHandler.retrieveSoftwareDeploymentEntityWithAutoUpgradeToEnglish(policy);
    }

    public static SoftwareDeploymentEntity retrieveSoftwareDeploymentEntityWithAutoUpgradeToEnglish(SoftwareDeploymentPolicy policy) {
        if (policy == null) {
            return null;
        }
        int entityCount = policy.getSoftwareDeploymentEntityCount();
        if (entityCount < 1) {
            return null;
        }
        for (int i = 0; i < entityCount; ++i) {
            SoftwareDeploymentEntity entity = policy.getSoftwareDeploymentEntity(i);
            if (entity == null || entity.getOptAutoUpgradeToEnglish() == null || !entity.getOptAutoUpgradeToEnglish().booleanValue()) continue;
            return entity;
        }
        return null;
    }

    public static void removePackageFromLuArray(LuDownloadedContentArray luContentArray, String softwarePackageId) throws ConsoleException {
        if (softwarePackageId == null || luContentArray == null) {
            return;
        }
        int pkgCount = luContentArray.getLuPackageContentCount();
        for (int i = pkgCount - 1; i >= 0; --i) {
            ObjReference obj;
            LuPackageContent pkgContent = luContentArray.getLuPackageContent(i);
            if (pkgContent == null || (obj = pkgContent.getObjReference()) == null || !obj.getTargetId().equals(softwarePackageId)) continue;
            luContentArray.removeLuPackageContent(pkgContent);
            luContentArray.removeObsoleteItem(new ObsoleteItem(pkgContent.getI()));
        }
    }

    public static boolean movePackage(RecycleBinObject pobj) throws ConsoleException {
        SoftwarePackage sp = pobj.getSoftwarePackage();
        if (sp == null) {
            return false;
        }
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", Manager.getCurrentDomainId());
        ObjectPool pool = domain.getObjectPool();
        if (pool == null) {
            return false;
        }
        RecycleBin rb = SoftwarePackageHandler.getRecycleBin();
        if (rb == null) {
            return false;
        }
        int len = rb.getSuspendedItemCount();
        if (len == 0) {
            return false;
        }
        ObjReference removeObj = null;
        for (int i = 0; i < len; ++i) {
            SuspendedItem item = rb.getSuspendedItem(i);
            ObjReference obj = item.getObjReference();
            if (!obj.getTargetType().equals("SoftwarePackage") || !obj.getTargetId().equals(sp.getId())) continue;
            obj.getParent().removeChild((AbstractSchema)obj);
            item.getParent().removeChild((AbstractSchema)item);
            removeObj = obj;
            break;
        }
        if (removeObj == null) {
            return false;
        }
        SoftwarePackagePool spPool = pool.getOptSoftwarePackagePool();
        if (spPool == null) {
            spPool = new SoftwarePackagePool();
            pool.setOptSoftwarePackagePool(spPool);
        }
        spPool.addObjReference(removeObj);
        data.updateObject("Ask", (TopLevelObject)domain);
        ConsoleLogger.logAdminEvent(12293);
        return true;
    }

    public static ArrayList<String> retrieveEmptyDefaultServerListGroups(ArrayList<GroupObject> listGroupObjs) throws ConsoleException {
        ArrayList<SemServerList> listDefaultServerLists = SoftwarePackageHandler.getAllDefaultServerLists();
        return SoftwarePackageHandler.retrieveEmptyDefaultServerListGroups(listGroupObjs, listDefaultServerLists);
    }

    public static SemServerList retrieveGroupServerList(GroupObject groupObj) throws ConsoleException {
        GroupPolicyObject groupPolicy = PolicyHandler.getGroupPolicyByGroup(groupObj);
        CommunicationObject co = groupPolicy.getCommunicationObject();
        ServerListObject serverListObj = co.getServerList();
        SemServerList serverList = null;
        serverList = serverListObj.getSemServerList();
        if (serverList == null) {
            ConsoleLogger.log("SoftrwarePackageHandler>> retrieveGroupServerList: Error-> failed to retrieve server list in the communication setting from group " + groupObj.getName());
            return null;
        }
        return serverList;
    }

    public static ArrayList<WhiteListObject> retrieveWhiteListObjsFromGroup(GroupObject groupObj) throws ConsoleException {
        SemAgentPolicy agentPolicy = PolicyHandler.getSemAgentPolicyByGroup(groupObj);
        ComputerLockdownProtection lockdown = agentPolicy.getOptComputerLockdownProtection();
        if (lockdown == null) {
            return null;
        }
        if (!(lockdown.getOptEnable() == null ? lockdown.getDefEnable() : lockdown.getOptEnable()).booleanValue()) {
            return null;
        }
        LockdownSet set = lockdown.getOptLockdownSet();
        if (set == null) {
            return null;
        }
        AppliedImageArray array = set.getOptAppliedImageArray();
        if (array == null || array.getAppliedImageCount() < 1) {
            return null;
        }
        ArrayList<WhiteListObject> list = new ArrayList<WhiteListObject>(array.getAppliedImageCount());
        for (int i = 0; i < array.getAppliedImageCount(); ++i) {
            AppliedImage image = array.getAppliedImage(i);
            ComputerImage ci = DataobjectManager.getInstance().getComputerImage(image.getObjReference().getTargetId());
            WhiteListObject whitelist = new WhiteListObject(ci);
            list.add(whitelist);
        }
        return list;
    }

    public static PhysicalFile createSemPhysicalFile(String physicalFileId, String physicalFileBinaryDataId, String physicalFielName, String name, String description, String checksume) throws ConsoleException {
        try {
            PhysicalFile spf = new PhysicalFile();
            spf.setId(physicalFileId);
            spf.setFileLastModifiedTime(Long.valueOf(TimeUtil.getServerTime()));
            spf.setCreationTime(Long.valueOf(TimeUtil.getServerTime()));
            spf.setName(name);
            spf.setFileName(physicalFielName);
            spf.setOptDescription(description);
            spf.setFileChecksum(checksume);
            spf.setFileSize(Long.valueOf(Utility.getFileSize((String)physicalFielName)));
            ObjReference obj = new ObjReference();
            obj.setName("LinkToFileContent");
            obj.setTargetType("ExPhysicalFileStream");
            obj.setTargetId(physicalFileBinaryDataId);
            spf.setObjReference(obj);
            return spf;
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }

    public static void updateSoftwareDeploymentEntity(SoftwareDeploymentEntity entity) throws ConsoleException {
        if (entity == null) {
            return;
        }
        SoftwareDeploymentPolicy policy = (SoftwareDeploymentPolicy)entity.getParent();
        if (policy == null) {
            return;
        }
        DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)policy);
    }

    public static SoftwareDeploymentPolicy addSoftwareDeploymentEntity(SoftwareDeploymentPolicy policy, SoftwareDeploymentEntity entity) throws ConsoleException {
        SoftwarePackageHandler.addSoftwareDeploymentEntityWithoutSave(policy, entity);
        return (SoftwareDeploymentPolicy)DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)policy);
    }

    public static void addSoftwareDeploymentEntityWithoutSave(SoftwareDeploymentPolicy policy, SoftwareDeploymentEntity entity) throws ConsoleException {
        if (policy == null || entity == null) {
            return;
        }
        String packageId = entity.getObjReferenceByTypeAndName("SoftwarePackage", "TargetSoftwarePackageLink").getTargetId();
        int entityCount = policy.getSoftwareDeploymentEntityCount();
        int index = -1;
        if (entityCount > 0) {
            SoftwarePackage newSoftwarePackage = DataobjectManager.getInstance().getSoftwarePackage(packageId);
            PackageInfo newPackageInfo = newSoftwarePackage.getPackageInfo();
            String newPlatformType = newPackageInfo.getOptPlatformType();
            if (newPlatformType == null) {
                newPlatformType = newPackageInfo.getDefPlatformType();
            }
            String newLanguage = newPackageInfo.getOptLanuage();
            String newProductType = AutoUpgradeUtils.getPackageClientTypeValue((SoftwarePackage)newSoftwarePackage);
            for (int i = 0; i < entityCount; ++i) {
                boolean isExistingPackage;
                SoftwareDeploymentEntity e = policy.getSoftwareDeploymentEntity(i);
                if (e == null) continue;
                SoftwarePackage sp = SoftwarePackageHandler.getSoftwarePackageFromDeploymentEntity(e, true);
                PackageInfo existPI = sp.getPackageInfo();
                String existType = existPI.getOptPlatformType();
                if (existType == null) {
                    existType = existPI.getDefPlatformType();
                }
                String existLan = existPI.getOptLanuage();
                String existProductType = AutoUpgradeUtils.getPackageClientTypeValue((SoftwarePackage)sp);
                boolean bl = isExistingPackage = newPlatformType.equals(existType) && !StringUtilities.isEmpty((String)newLanguage) && newLanguage.equals(existLan) && newProductType.equals(existProductType);
                if (!sp.getId().equals(packageId) && !isExistingPackage) continue;
                index = i;
                policy.removeSoftwareDeploymentEntity(e);
                break;
            }
        }
        if (index > -1) {
            policy.addSoftwareDeploymentEntity(index, entity);
        } else {
            policy.addSoftwareDeploymentEntity(entity);
        }
    }

    public static SoftwareDeploymentPolicy createSoftwareDeploymentPolicy(GroupObject groupObject) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        String softwareDeploymentPolicyId = new GUIDGenerator().getGUIDString();
        SoftwareDeploymentPolicy softwareDeploymentPolicy = new SoftwareDeploymentPolicy();
        softwareDeploymentPolicy.setId(softwareDeploymentPolicyId);
        softwareDeploymentPolicy.setName("SoftwareDeploymentPolicy");
        data.addObject((TopLevelObject)softwareDeploymentPolicy);
        softwareDeploymentPolicy = (SoftwareDeploymentPolicy)data.getObjectByGUID("SoftwareDeploymentPolicy", softwareDeploymentPolicyId);
        SemGroupPolicy semGroupPolicy = SoftwarePackageHandler.getGroupPolicy(groupObject);
        ObjReference ref = new ObjReference();
        ref.setTargetId(softwareDeploymentPolicyId);
        ref.setTargetType("SoftwareDeploymentPolicy");
        ref.setOptDescription("SoftwareDeploymentPolicy");
        ref.setOptEnable(Boolean.TRUE);
        ref.setName("SoftwareDeploymentPolicyLink");
        semGroupPolicy.addObjReference(ref);
        data.updateObject("Merge", (TopLevelObject)semGroupPolicy);
        return softwareDeploymentPolicy;
    }

    public static void addSoftwareDeploymentPolicy(GroupObject groupObject, String packageId, ClientInstallationFeatures cifo, Integer sourceServer, String externalUrl, DeploymentSchedule deploymentSchedule, boolean forceDeployment, boolean autoUpgradeToEnglish, String platformType, String language, DeploymentNotification deploymentNotification, DeploymentSnooze deploymentSnooze, RebootOptions rebootOptions, ClientInstallationSettingObject cis, AutoUpgradeContentOption contentOption, SecurityFixContentInfoObject securityFix) throws ConsoleException {
        if (groupObject == null || groupObject.getSemClientGroup() == null) {
            ConsoleLogger.log("SoftwarePackageHandler>> addSoftwareDeploymentPolicy: Error-> group is invalid!");
            throw new ConsoleException(0x16010000, 54);
        }
        ConsoleLogger.log("SoftwarePackageHandler>> addSoftwareDeploymentPolicy: group id=" + groupObject.getId() + ", name=" + groupObject.getName() + ", packageId=" + packageId + ", sourceServer=" + sourceServer + ", externalUrl=" + externalUrl + ", forceDeployment=" + forceDeployment);
        DataobjectManager data = DataobjectManager.getInstance();
        SoftwareDeploymentEntity softwareDeploymentEntity = null;
        SoftwareDeploymentPolicy softwareDeploymentPolicy = null;
        String softwareDeploymentPolicyId = new GUIDGenerator().getGUIDString();
        PackageSource packageSource = null;
        SemClientGroup semClientGroup = groupObject.getSemClientGroup();
        String groupPolicyId = semClientGroup.getObjReference().getTargetId();
        SemGroupPolicy semGroupPolicy = (SemGroupPolicy)data.getObjectByGUID("SemGroupPolicy", groupPolicyId);
        ObjReference ref = Manager.getFirstObjReferenceByTargetType(semGroupPolicy.getObjReference(), "SoftwareDeploymentPolicy");
        if (ref == null) {
            softwareDeploymentPolicy = new SoftwareDeploymentPolicy();
            softwareDeploymentPolicy.setId(softwareDeploymentPolicyId);
            softwareDeploymentPolicy.setName("SoftwareDeploymentPolicy");
            data.addObject((TopLevelObject)softwareDeploymentPolicy);
            softwareDeploymentPolicy = (SoftwareDeploymentPolicy)data.getObjectByGUID("SoftwareDeploymentPolicy", softwareDeploymentPolicy.getId());
            ref = new ObjReference();
            ref.setTargetId(softwareDeploymentPolicyId);
            ref.setTargetType("SoftwareDeploymentPolicy");
            ref.setOptDescription("SoftwareDeploymentPolicy");
            ref.setOptEnable(Boolean.TRUE);
            ref.setName("SoftwareDeploymentPolicyLink");
            semGroupPolicy.addObjReference(ref);
            data.updateObject("Merge", (TopLevelObject)semGroupPolicy);
        } else {
            softwareDeploymentPolicyId = ref.getTargetId();
            softwareDeploymentPolicy = (SoftwareDeploymentPolicy)DataobjectManager.getInstance().getObjectByGUID("SoftwareDeploymentPolicy", softwareDeploymentPolicyId);
            int entityCount = softwareDeploymentPolicy.getSoftwareDeploymentEntityCount();
            if (entityCount > 0) {
                for (int i = 0; i < entityCount; ++i) {
                    boolean forceDeployment2;
                    PackageInfo pi;
                    SoftwarePackage sp;
                    boolean autoUpgradeToEnglish2;
                    SoftwareDeploymentEntity entity = softwareDeploymentPolicy.getSoftwareDeploymentEntity(i);
                    if (entity == null) continue;
                    ObjReference or = entity.getObjReferenceByTypeAndName("SoftwarePackage", "TargetSoftwarePackageLink");
                    if (or.getTargetId().equals(packageId)) {
                        softwareDeploymentEntity = entity;
                        ConsoleLogger.log("SoftwarePackageHandler>> addSoftwareDeploymentPolicy: found existing softwareDeploymentEntity! deployment policy name=" + softwareDeploymentPolicy.getName() + ", package id=" + or.getTargetId());
                        if (forceDeployment) continue;
                        break;
                    }
                    if (autoUpgradeToEnglish && (autoUpgradeToEnglish2 = (entity.getOptAutoUpgradeToEnglish() == null ? entity.getDefAutoUpgradeToEnglish() : entity.getOptAutoUpgradeToEnglish()).booleanValue())) {
                        sp = SoftwarePackageHandler.getSoftwarePackage(or.getTargetId(), true);
                        pi = sp.getPackageInfo();
                        String lan = pi.getOptLanuage();
                        if (language != null && lan.equals("en_us")) {
                            ConsoleLogger.log("SoftwarePackageHandler>> addSoftwareDeploymentPolicy: disable force deployment in softwareDeploymentEntity! deployment policy name=" + softwareDeploymentPolicy.getName() + ", package id=" + or.getTargetId());
                            entity.setOptAutoUpgradeToEnglish(Boolean.TRUE);
                        }
                    }
                    if (!forceDeployment || !(forceDeployment2 = (entity.getOptForceDeployment() == null ? entity.getDefForceDeployment() : entity.getOptForceDeployment()).booleanValue())) continue;
                    sp = SoftwarePackageHandler.getSoftwarePackage(or.getTargetId(), true);
                    pi = sp.getPackageInfo();
                    String type = pi.getOptPlatformType();
                    if (type == null) {
                        type = pi.getDefPlatformType();
                    }
                    String lan = pi.getOptLanuage();
                    if (!platformType.equals(type) || language == null || !language.equals(lan)) continue;
                    ConsoleLogger.log("SoftwarePackageHandler>> addSoftwareDeploymentPolicy: disable force deployment in softwareDeploymentEntity! deployment policy name=" + softwareDeploymentPolicy.getName() + ", package id=" + or.getTargetId());
                    entity.setOptForceDeployment(Boolean.FALSE);
                }
            }
        }
        if (softwareDeploymentEntity == null) {
            softwareDeploymentEntity = SoftwareDeploymentEntityObject.newInstance(packageId);
            softwareDeploymentPolicy.addSoftwareDeploymentEntity(softwareDeploymentEntity);
        }
        softwareDeploymentEntity.setOptDeploymentSchedule(deploymentSchedule);
        softwareDeploymentEntity.setOptForceDeployment(Boolean.valueOf(forceDeployment));
        softwareDeploymentEntity.setOptAutoUpgradeToEnglish(Boolean.valueOf(autoUpgradeToEnglish));
        softwareDeploymentEntity.setOptDeploymentNotification(deploymentNotification);
        softwareDeploymentEntity.setOptDeploymentSnooze(deploymentSnooze);
        softwareDeploymentEntity.setOptAutoUpgradeContentOption(contentOption);
        packageSource = softwareDeploymentEntity.getPackageSource();
        packageSource.setSourceServer(sourceServer);
        packageSource.setOptPackageSourceExternalUrl(externalUrl);
        SoftwarePackage sp = SoftwarePackageHandler.retrieveSoftwarePackage(packageId);
        int packageType = sp.getPackageInfo().getType();
        if (ClientInstallationFeatureObject.hasCustomizedFeatures(packageType)) {
            ClientInstallationFeatureObject sOldObject;
            ObjReference objCIFRef = softwareDeploymentEntity.getObjReferenceByTypeAndName("ClientInstallationFeatures", "TargetSoftwarePackageLink");
            boolean needUpdateFeatureRef = false;
            ClientInstallationFeatureObject sObj = new ClientInstallationFeatureObject(cifo);
            if (objCIFRef == null) {
                objCIFRef = new ObjReference();
                objCIFRef.setTargetType("ClientInstallationFeatures");
                objCIFRef.setName("TargetSoftwarePackageLink");
                objCIFRef.setTargetId(cifo.getId());
                softwareDeploymentEntity.addObjReference(objCIFRef);
                needUpdateFeatureRef = true;
            } else if (!objCIFRef.getTargetId().equalsIgnoreCase(sObj.getId())) {
                sOldObject = new ClientInstallationFeatureObject(data.getClientInstallationFeatures(objCIFRef.getTargetId()));
                if (!sOldObject.isSystemObject()) {
                    sOldObject.decRefCount();
                    data.updateClientInstallationFeatures("Merge", sOldObject.getClientInstallationFeatures());
                }
                objCIFRef.setTargetId(cifo.getId());
                needUpdateFeatureRef = true;
            }
            if (!sObj.isSystemObject() && needUpdateFeatureRef) {
                sOldObject = new ClientInstallationFeatureObject(data.getClientInstallationFeatures(sObj.getId()));
                sOldObject.incRefCount();
                data.updateClientInstallationFeatures("Merge", sOldObject.getClientInstallationFeatures());
            }
        }
        ObjReference objCISRef = softwareDeploymentEntity.getObjReferenceByType("ClientInstallationSettings");
        boolean needUpdateSettingRef = false;
        if (objCISRef == null) {
            objCISRef = new ObjReference();
            objCISRef.setTargetType("ClientInstallationSettings");
            objCISRef.setName("TargetClientInstallationSettingsLink");
            objCISRef.setTargetId(cis.getId());
            softwareDeploymentEntity.addObjReference(objCISRef);
            needUpdateSettingRef = true;
        } else if (!objCISRef.getTargetId().equalsIgnoreCase(cis.getId())) {
            ClientInstallationSettingObject iOldObject = new ClientInstallationSettingObject(data.getClientInstallationSettings(objCISRef.getTargetId()));
            if (!iOldObject.isSystemObject()) {
                iOldObject.decRefCount();
                data.updateClientInstallationSettings("Merge", iOldObject.getClientInstallationSettings());
            }
            objCISRef.setTargetId(cis.getId());
            needUpdateSettingRef = true;
        }
        if (!cis.isSystemObject() && needUpdateSettingRef) {
            ClientInstallationSettingObject iOldObject = new ClientInstallationSettingObject(data.getClientInstallationSettings(cis.getId()));
            iOldObject.incRefCount();
            data.updateClientInstallationSettings("Merge", iOldObject.getClientInstallationSettings());
        }
        if (securityFix != null) {
            softwareDeploymentEntity.setOptSecurityFixContentInfo(securityFix.getSecurityFixContentInfo());
            ConsoleLogger.log("Security Fix Content package, build number: " + securityFix.getSecurityFixContentInfo().getProductBuildNum() + ", PackageChecksum: " + securityFix.getSecurityFixContentInfo().getPackageChecksum());
        }
        data.updateObject("Merge", (TopLevelObject)softwareDeploymentPolicy);
    }

    public static SoftwareDeploymentPolicy retrieveOrCreateSoftwareDeploymentPolicy(GroupObject groupObj) throws ConsoleException {
        SoftwareDeploymentPolicy policy = SoftwarePackageHandler.getSoftwareDeploymentPolicy(groupObj);
        if (policy == null) {
            policy = SoftwarePackageHandler.createSoftwareDeploymentPolicy(groupObj);
        }
        return policy;
    }

    public static void copySoftwareSoftwareDeploymentEntities(GroupObject groupSource, GroupObject groupTarget) throws ConsoleException {
        SoftwareDeploymentPolicy policySource = SoftwarePackageHandler.getSoftwareDeploymentPolicy(groupSource);
        if (policySource == null) {
            return;
        }
        int count = policySource.getSoftwareDeploymentEntityCount();
        if (count == 0) {
            return;
        }
        SoftwareDeploymentPolicy policyTarget = SoftwarePackageHandler.retrieveOrCreateSoftwareDeploymentPolicy(groupTarget);
        if (policyTarget == null) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            SoftwareDeploymentEntity entity = policySource.getSoftwareDeploymentEntity(i);
            SoftwareDeploymentEntityObject entityObj = new SoftwareDeploymentEntityObject(entity, null);
            SoftwareDeploymentEntity entityCopy = (SoftwareDeploymentEntity)entityObj.cloneEntity();
            if (entityCopy == null) continue;
            policyTarget = SoftwarePackageHandler.addSoftwareDeploymentEntity(policyTarget, entityCopy);
        }
        DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)policyTarget);
    }

    public static SoftwarePackage retrieveSoftwarePackage(String id) throws ConsoleException {
        return (SoftwarePackage)DataobjectManager.getInstance().getObjectByGUID("SoftwarePackage", id);
    }

    public static SoftwarePackage retrieveSoftwarePackageByName(String name) throws ConsoleException {
        if (name == null || name.length() < 1) {
            return null;
        }
        ArrayList<SoftwarePackage> list = SoftwarePackageHandler.getSoftwarePackages(1);
        for (int i = 0; i < list.size(); ++i) {
            SoftwarePackage sp = list.get(i);
            if (!sp.getName().equals(name)) continue;
            return sp;
        }
        return null;
    }

    public static void recycleBinUpdated() throws ConsoleException {
        DataobjectManager dataMgr = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)dataMgr.getObjectByGUID("SemDomain", Manager.getCurrentDomainId(), false);
        dataMgr.updateObject("Merge", (TopLevelObject)domain);
    }

    public static byte[][] retrieveGroupProfile(PackageWorker worker, String id, int packageType) {
        byte[][] data = null;
        long startCounter = System.currentTimeMillis();
        long sleepMsec = 30000L;
        int attempt = 1;
        int maxRetry = 6;
        boolean isReadyMsg = false;
        do {
            try {
                if (worker.isCanceled()) {
                    return null;
                }
                ConsoleLogger.log("check if group profile created: attempt: " + attempt);
                data = SoftwarePackageHandler.getAgentPolicyFiles(id, packageType);
                if (data != null && data.length >= 1 && data[0] != null && data[0].length > 0) {
                    break;
                }
            }
            catch (Exception ex) {
                ConsoleLogger.log("check for group profile failed. ignore error... ");
                LoggerUtilities.logException((Throwable)ex);
            }
            ++attempt;
            try {
                if (worker.isCanceled()) {
                    ConsoleLogger.log("User cancelled wait....");
                    return null;
                }
                if (!isReadyMsg) {
                    worker.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "SoftwarePackageHandler.waitingForGroupProfile"), false, true, 0);
                    isReadyMsg = true;
                }
                ConsoleLogger.log("Sleeing for sec: " + sleepMsec);
                Thread.sleep(sleepMsec);
            }
            catch (Exception e) {
                LoggerUtilities.logException((Throwable)e);
            }
            ConsoleLogger.log("total sleep time till now: (msec) " + (System.currentTimeMillis() - startCounter));
        } while (attempt <= maxRetry);
        return data;
    }

    private static int downloadPackage(String url, String checksum, File fPackage) {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            try {
                bis = new BufferedInputStream(GUIManager.downloadFile(url, 1));
                bos = new BufferedOutputStream(new FileOutputStream(fPackage.getAbsolutePath() + "_"));
                byte[] buffer = new byte[8192];
                int len = 0;
                while ((len = bis.read(buffer, 0, 8192)) != -1) {
                    bos.write(buffer, 0, len);
                }
                bos.flush();
            }
            catch (IOException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtilities.closeOutputStream(bos);
                    IOUtilities.closeInputStream(bis);
                    throw throwable;
                }
            }
            IOUtilities.closeOutputStream((OutputStream)bos);
            IOUtilities.closeInputStream((InputStream)bis);
            File tFile = new File(fPackage + "_");
            if (tFile.renameTo(fPackage)) {
                return 1;
            }
            if (fPackage.exists()) {
                return 1;
            }
            return 3;
        }
        catch (Throwable e) {
            LoggerUtilities.logException((Throwable)e);
            ConsoleLogger.log("ErrorMsg-> " + e.getMessage());
            return 7;
        }
    }

    private static ArrayList<String> retrieveEmptyDefaultServerListGroups(ArrayList<GroupObject> listGroupObjs, ArrayList<SemServerList> listDefaultServerLists) throws ConsoleException {
        if (listGroupObjs == null) {
            return null;
        }
        ArrayList<String> listEmptyGroups = new ArrayList<String>(listGroupObjs.size());
        for (int i = 0; i < listGroupObjs.size(); ++i) {
            GroupObject groupObj = listGroupObjs.get(i);
            SemServerList serverList = SoftwarePackageHandler.retrieveGroupServerList(groupObj);
            if (!SoftwarePackageHandler.isEmptyDefaultServerList(serverList, listDefaultServerLists)) continue;
            listEmptyGroups.add(GroupHandler.getGroupFullPath(groupObj));
        }
        return listEmptyGroups;
    }

    private static Hashtable<String, ConfigObject> getSoftwarePackageAndDeploymentEntityByPackageType(SoftwareDeploymentPolicy policy, int packageType, String platform, String language) throws ConsoleException {
        if (policy == null) {
            return null;
        }
        int entityCount = policy.getSoftwareDeploymentEntityCount();
        if (entityCount < 1) {
            return null;
        }
        for (int i = 0; i < entityCount; ++i) {
            SoftwarePackage sp;
            SoftwareDeploymentEntity entity = policy.getSoftwareDeploymentEntity(i);
            if (entity == null || (sp = SoftwarePackageHandler.getSoftwarePackageFromDeploymentEntity(entity, true)) == null) continue;
            PackageInfo packageInfo = sp.getPackageInfo();
            String currentPlatform = packageInfo.getOptPlatformType();
            if (currentPlatform == null) {
                currentPlatform = packageInfo.getDefPlatformType();
            }
            String currentLanguage = packageInfo.getOptLanuage();
            if (sp.getPackageInfo().getType() != packageType || !currentPlatform.equals(platform) || (language == null || !language.equals(currentLanguage)) && (language != null || currentLanguage != null)) continue;
            Hashtable<String, ConfigObject> table = new Hashtable<String, ConfigObject>();
            table.put(KEY_NAME_PACKAGE, (ConfigObject)sp);
            table.put(KEY_NAME_ENTITY, (ConfigObject)entity);
            return table;
        }
        return null;
    }

    private static int getNumberFromAgentPolicyFilesInputStream(InputStream is, char separator) throws Exception {
        int bytesRead;
        byte[] onebyte = new byte[1];
        StringBuffer strBuffer = new StringBuffer();
        while ((bytesRead = is.read(onebyte)) >= 0 && (char)onebyte[0] != separator) {
            strBuffer.append((char)onebyte[0]);
        }
        ConsoleLogger.log("SoftwarePackageHandler>> getNumberFromAgentPolicyFilesInputStream: str=" + strBuffer.toString());
        int number = 0;
        try {
            number = Integer.parseInt(strBuffer.toString());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        ConsoleLogger.log("SoftwarePackageHandler>> getNumberFromAgentPolicyFilesInputStream: number=" + number);
        return number;
    }

    private static int getFileCountFromAgentPolicyFilesInputStream(InputStream is, char separator) throws Exception {
        return SoftwarePackageHandler.getNumberFromAgentPolicyFilesInputStream(is, separator);
    }

    private static byte[] getFileFromAgentPolicyFilesInputStream(InputStream is, char separator) throws Exception {
        int size = SoftwarePackageHandler.getNumberFromAgentPolicyFilesInputStream(is, separator);
        if (size < 1) {
            return null;
        }
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
        try {
            int bytesRead;
            int iBufferSize = size;
            byte[] buffer = new byte[iBufferSize];
            int totalReadSize = 0;
            while ((bytesRead = is.read(buffer, 0, iBufferSize)) != -1) {
                bos.write(buffer, 0, bytesRead);
                if ((totalReadSize += bytesRead) >= size) break;
                iBufferSize = size - totalReadSize;
            }
            bytes = bos.toByteArray();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception exception) {}
        }
        return bytes;
    }

    private static void filterUnAutoUpgradablePackages(ArrayList<CurrentPackageObject> listPO) {
        if (null != listPO && listPO.size() > 0) {
            Iterator<CurrentPackageObject> iter = listPO.iterator();
            CurrentPackageObject cpo = null;
            SoftwarePackage sp = null;
            while (iter.hasNext()) {
                cpo = iter.next();
                sp = cpo.getSoftwarePackage();
                if (PackageUtil.isPackageAutoUpgradable((SoftwarePackage)sp)) continue;
                iter.remove();
            }
        }
    }

    private static void filterUnRemoteInstallablePackages(ArrayList<CurrentPackageObject> listPO) {
        if (null != listPO && listPO.size() > 0) {
            Iterator<CurrentPackageObject> iter = listPO.iterator();
            CurrentPackageObject cpo = null;
            SoftwarePackage sp = null;
            while (iter.hasNext()) {
                cpo = iter.next();
                sp = cpo.getSoftwarePackage();
                if (PackageUtil.isPackageRemoteInstallable((SoftwarePackage)sp)) continue;
                iter.remove();
            }
        }
    }

    public static ArrayList<CurrentPackageObject> getCurrentSoftwarePackages() throws ConsoleException {
        return new ArrayList<CurrentPackageObject>(GUIManager.getCurrentSoftwarePackages().stream().map(CurrentPackageObject::new).collect(Collectors.toList()));
    }

    public static ArrayList<CurrentPackageObject> getUnAssignedCurrentSoftwarePackages(ArrayList<String> listDeployedPackageIds) throws ConsoleException {
        ArrayList<SoftwarePackage> list = SoftwarePackageHandler.getSoftwarePackages(1);
        ArrayList<CurrentPackageObject> listCurrentObjects = new ArrayList<CurrentPackageObject>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            SoftwarePackage sp = list.get(i);
            if (!PackageUtil.isPackageAutoUpgradable((SoftwarePackage)sp)) continue;
            boolean found = false;
            if (listDeployedPackageIds != null) {
                for (int j = 0; j < listDeployedPackageIds.size(); ++j) {
                    String id = listDeployedPackageIds.get(j);
                    if (!sp.getId().equals(id)) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            CurrentPackageObject cpo = new CurrentPackageObject(sp);
            listCurrentObjects.add(cpo);
        }
        return listCurrentObjects;
    }

    public static ArrayList<SoftwarePackage> getSoftwarePackages(int retrievalMode) throws ConsoleException {
        ArrayList<SoftwarePackage> list = new ArrayList<SoftwarePackage>();
        DataobjectManager data = DataobjectManager.getInstance();
        LuDownloadedContentArray luContentArray = LuUtility.getLuDownloadedContentArray();
        if (luContentArray == null) {
            return list;
        }
        if (retrievalMode == 0 || retrievalMode == 1) {
            int pkgCount = luContentArray.getLuPackageContentCount();
            for (int i = 0; i < pkgCount; ++i) {
                SoftwarePackage sp;
                ObjReference objRef;
                LuPackageContent pkgContent = luContentArray.getLuPackageContent(i);
                if (pkgContent == null || (objRef = pkgContent.getObjReference()) == null || GUIManager.isSoftwarePackageBroken(objRef.getTargetId()) || (sp = (SoftwarePackage)data.getObjectByGUID("SoftwarePackage", objRef.getTargetId())) == null) continue;
                Boolean suspended = sp.getOptSuspended();
                if (suspended == null) {
                    suspended = sp.getDefSuspended();
                }
                if (suspended.booleanValue() || retrievalMode == 1 && !SoftwarePackageHandler.isBinaryFileExists(sp)) continue;
                list.add(sp);
            }
        }
        if (retrievalMode == 0 || retrievalMode == 2) {
            RecycleBin rb = SoftwarePackageHandler.getRecycleBin();
            if (rb == null) {
                return list;
            }
            int len = rb.getSuspendedItemCount();
            if (len == 0) {
                return list;
            }
            for (int i = 0; i < len; ++i) {
                SuspendedItem item = rb.getSuspendedItem(i);
                ObjReference obj = item.getObjReference();
                if (!obj.getTargetType().equals("SoftwarePackage")) continue;
                SoftwarePackage sp = (SoftwarePackage)data.getObjectByGUID("SoftwarePackage", obj.getTargetId());
                if (retrievalMode == 2 && !SoftwarePackageHandler.isBinaryFileExists(sp)) continue;
                list.add(sp);
            }
        }
        return PackageUtil.sortPackageListByVersionAndOsType(list);
    }

    public static String getPackageCacheFolder(ExportPackageSettings settings) {
        String tempDir = settings.getExportedDir();
        String packageFolder = tempDir + File.separator + "packages";
        File dirPackages = new File(packageFolder);
        if (!dirPackages.exists() && !dirPackages.mkdirs()) {
            ConsoleLogger.log(" fail to create the package folder");
        }
        return packageFolder;
    }

    public static int getFileByChecksum(String checksum, boolean singleFile, boolean forced, ExportPackageWorker worker) {
        String packageFolder;
        String strFolder;
        File fFolder;
        InstallationOption installationOptions;
        if (checksum == null) {
            return 2;
        }
        boolean downRequired = false;
        boolean doCopyAppRemover = false;
        ClientInstallationSettingObject installSettings = worker.getSettings().getInstallSettings();
        if (installSettings != null && (installationOptions = installSettings.getInstallationOption()) != null) {
            Boolean optAppRemover = installationOptions.getOptEnableCompetitiveUninstall();
            boolean bl = doCopyAppRemover = optAppRemover != null && optAppRemover != false;
        }
        if (doCopyAppRemover) {
            ConsoleLogger.log(Utility.getPerformanceLog((String)"custom deployment", (String)"TPAR download", (boolean)true));
            int appresult = SoftwarePackageHandler.getAppRemoverZip(forced, worker);
            ConsoleLogger.log(Utility.getPerformanceLog((String)"custom deployment", (String)("TPAR download " + appresult), (boolean)false));
        }
        if (!(fFolder = new File(strFolder = (packageFolder = SoftwarePackageHandler.getPackageCacheFolder(worker.getSettings())) + File.separator + checksum)).exists()) {
            if (!fFolder.mkdirs()) {
                return 3;
            }
            downRequired = true;
        }
        String strPackage = strFolder + File.separator + "FULL.ZIP";
        File fPackage = new File(strPackage);
        if (forced || !fPackage.exists()) {
            downRequired = true;
        }
        if (downRequired) {
            ConsoleLogger.log(Utility.getPerformanceLog((String)"custom deployment", (String)("download package file " + checksum), (boolean)true));
            String pURL = DownloadFiles.PACKAGE_CACHE_FULL_PATH + File.separator + checksum + File.separator + "FULL.ZIP";
            int result = SoftwarePackageHandler.downloadPackage(pURL, checksum, fPackage);
            if (result != 1) {
                Utility.deleteDir((String)strFolder);
                return result;
            }
            ConsoleLogger.log(Utility.getPerformanceLog((String)"custom deployment", (String)("download package file " + checksum), (boolean)false));
            if (!singleFile) {
                ConsoleLogger.log(Utility.getPerformanceLog((String)"custom deployment", (String)("unzip the package file " + checksum), (boolean)true));
                String unzippedFolder = strFolder + File.separator + "FULL";
                int ret = SoftwarePackageHandler.unzipPackage(strPackage, unzippedFolder + "_");
                if (ret != 1) {
                    ConsoleLogger.log("Failed to unzip the full.zip!");
                    Utility.deleteDir((String)strFolder);
                } else {
                    boolean bret = IOUtilities.renameFile((File)new File(unzippedFolder + "_"), (File)new File(unzippedFolder), (boolean)true);
                    if (!bret) {
                        ConsoleLogger.log("Failed to rename the unzipped folder to " + unzippedFolder);
                        ret = 8;
                    } else {
                        ret = 1;
                    }
                }
                ConsoleLogger.log(Utility.getPerformanceLog((String)"custom deployment", (String)("unzip the package file " + checksum), (boolean)false));
                return ret;
            }
            return 1;
        }
        return 1;
    }

    public static int getAppRemoverZip(boolean forced, ExportPackageWorker worker) {
        int returnValue = 1;
        boolean downRequired = false;
        String packageFolder = SoftwarePackageHandler.getPackageCacheFolder(worker.getSettings());
        String appRemoverFolder = packageFolder + File.separator + "TPAR";
        try {
            File fFolder = new File(appRemoverFolder);
            if (!fFolder.exists()) {
                if (!fFolder.mkdirs()) {
                    return 3;
                }
                downRequired = true;
            }
        }
        catch (Exception e) {
            return 3;
        }
        String strAppRemoverPackage = appRemoverFolder + File.separator + "TPAR.ZIP";
        File fAppRemoverPackage = new File(strAppRemoverPackage);
        if (forced || !fAppRemoverPackage.exists()) {
            downRequired = true;
        }
        if (downRequired) {
            String appRemoverURL = DownloadFiles.APP_REMOVER_PATH + File.separator + "TPAR.ZIP";
            int appRemoverresult = SoftwarePackageHandler.downloadPackage(appRemoverURL, "", fAppRemoverPackage);
            if (appRemoverresult != 1) {
                ConsoleLogger.log(Utility.getPerformanceLog((String)"custom deployment", (String)"Unable to download the TPAR", (boolean)false));
                returnValue = appRemoverresult;
            } else {
                ConsoleLogger.log("download the TPAR finished");
                returnValue = 1;
            }
        }
        return returnValue;
    }

    public static boolean isBinaryFileExists(SoftwarePackage sp) throws ConsoleException {
        PhysicalFile packagePhysicalFile;
        String packagePhysicalFileId = null;
        PackageInfo pi = sp.getPackageInfo();
        if (pi == null) {
            return false;
        }
        for (int i = 0; i < pi.getObjReferenceCount(); ++i) {
            ObjReference obj = pi.getObjReference(i);
            if (!obj.getTargetType().equals("PhysicalFile") || !obj.getName().equals("PackageFileLink")) continue;
            packagePhysicalFileId = obj.getTargetId();
            break;
        }
        if ((packagePhysicalFile = (PhysicalFile)DataobjectManager.getInstance().getObjectByGUID("PhysicalFile", packagePhysicalFileId)) == null) {
            return false;
        }
        String idPackageBinary = packagePhysicalFile.getObjReference().getTargetId();
        return GUIManager.isBinaryFileExists(idPackageBinary);
    }

    public static boolean isPackageExisted(SoftwarePackage sp) throws ConsoleException {
        ObjReference objRef;
        String cntArrayId;
        LuDownloadedContentPool downloadedCntPool;
        boolean bExisted = false;
        if (sp == null) {
            return bExisted;
        }
        String newBinaryFileID = Utility.generateBinaryFileID((SoftwarePackage)sp);
        ConsoleLogger.log("isPackageExisted>> newBinaryFileID: " + newBinaryFileID);
        PackageLuInfo luInfo = sp.getPackageInfo().getOptPackageLuInfo();
        if (luInfo == null) {
            return bExisted;
        }
        String newClientMoniker = luInfo.getClientMoniker();
        String newSeqNo = luInfo.getSequenceNumber();
        if (newClientMoniker == null || newSeqNo == null) {
            return false;
        }
        PackageInfo pgInfo = sp.getPackageInfo();
        ConsoleLogger.log("isPackageExisted>> ClientMoniker: " + newClientMoniker + ", Version: " + pgInfo.getVersion() + ", ProductBuildNum: " + pgInfo.getOptProductBuildNum() + ", PVL-P: " + luInfo.getServerProduct() + ", PVL-V: " + luInfo.getServerVersion() + ", PVL-L: " + luInfo.getServerLanguage());
        DataobjectManager data = DataobjectManager.getInstance();
        SemConfigRoot configRoot = data.getSemConfigRoot();
        GlobalObjectPool luGlobalPool = configRoot.getOptGlobalObjectPool();
        LuDownloadedContentArray luContentArray = null;
        if (luGlobalPool != null && (downloadedCntPool = luGlobalPool.getOptLuDownloadedContentPool()) != null && (luContentArray = data.getLuDownloadedContentArray(cntArrayId = (objRef = downloadedCntPool.getObjReference()).getTargetId())) != null) {
            for (int i = 0; i < luContentArray.getLuPackageContentCount(); ++i) {
                String existBinaryFileID;
                LuPackageContent luPkgContent = luContentArray.getLuPackageContent(i);
                ConsoleLogger.log("isPackageExisted>> LuPackageContent, ServerProduct: " + luPkgContent.getServerProduct() + ", Version: " + luPkgContent.getServerVersion() + ", ServerLanguage: " + luPkgContent.getServerLanguage());
                ObjReference luPkgRef = luPkgContent.getObjReference();
                if (GUIManager.isSoftwarePackageBroken(luPkgRef.getTargetId())) {
                    ConsoleLogger.log("isPackageExisted>> is broken, skip!");
                    continue;
                }
                SoftwarePackage existingPkg = data.getSoftwarePackage(luPkgRef.getTargetId());
                if (existingPkg == null) {
                    ConsoleLogger.log("isPackageExisted>> Didn't find SoftwarePackage, ID: " + luPkgRef.getTargetId());
                    continue;
                }
                boolean suspened = Utility.getBooleanValue((Boolean)existingPkg.getOptSuspended(), (Boolean)existingPkg.getDefSuspended());
                if (suspened) {
                    ConsoleLogger.log("isPackageExisted>> SoftwarePackage is suspened!");
                    continue;
                }
                if (luPkgContent.getServerProduct().equalsIgnoreCase(luInfo.getServerProduct()) && luPkgContent.getServerVersion().equalsIgnoreCase(luInfo.getServerVersion()) && luPkgContent.getServerLanguage().equalsIgnoreCase(luInfo.getServerLanguage()) && luPkgContent.getServerMoniker().equalsIgnoreCase(luInfo.getServerMoniker())) {
                    ConsoleLogger.log("isPackageExisted>> SoftwarePackage has same PVL!");
                    for (SecurityFixContentInfo securityInfo : luPkgContent.getSecurityFixContentInfo()) {
                        ConsoleLogger.log("isPackageExisted>> checking, SecurityFixContentInfo: " + securityInfo.toString());
                        if (!securityInfo.getProductBuildNum().equalsIgnoreCase(pgInfo.getVersion()) && !securityInfo.getProductBuildNum().equalsIgnoreCase(pgInfo.getOptProductBuildNum())) continue;
                        ConsoleLogger.log("isPackageExisted>> found the package in SecurityFixContentInfo: " + securityInfo.toString());
                        bExisted = true;
                        break;
                    }
                }
                if (bExisted || !newBinaryFileID.equalsIgnoreCase(existBinaryFileID = Utility.generateBinaryFileID((SoftwarePackage)existingPkg))) continue;
                ConsoleLogger.log("isPackageExisted>> found the package by existBinaryFileID: " + existBinaryFileID);
                bExisted = true;
                break;
            }
        }
        ConsoleLogger.log("isPackageExisted>> Result: " + bExisted);
        return bExisted;
    }

    public static boolean hasCurrentPackage() throws ConsoleException {
        LuDownloadedContentArray luContentArray = LuUtility.getLuDownloadedContentArray();
        if (luContentArray == null) {
            return false;
        }
        return luContentArray.getLuPackageContentCount() > 0;
    }

    public static boolean isPackageNameExisting(String packageName) throws ConsoleException {
        ArrayList<SoftwarePackage> list = SoftwarePackageHandler.getSoftwarePackages(0);
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            SoftwarePackage sp = list.get(i);
            if (!sp.getName().equals(packageName)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<RecycleBinObject> getRecycleBinPackages() throws ConsoleException {
        ArrayList<SoftwarePackage> list = SoftwarePackageHandler.getSoftwarePackages(2);
        ArrayList<RecycleBinObject> listRecycleBinObjects = new ArrayList<RecycleBinObject>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            SoftwarePackage sp = list.get(i);
            RecycleBinObject rbo = new RecycleBinObject(sp);
            listRecycleBinObjects.add(rbo);
        }
        return listRecycleBinObjects;
    }

    public static String getPhysicalFileBinaryDataId(PhysicalFile pf) {
        if (pf == null) {
            return null;
        }
        return pf.getObjReference().getTargetId();
    }

    public static SoftwareDeploymentEntity getSoftwareDeploymentEntityByPackageId(SoftwareDeploymentPolicy policy, String packageId) {
        if (policy == null || packageId == null || packageId.length() < 1) {
            return null;
        }
        int entityCount = policy.getSoftwareDeploymentEntityCount();
        if (entityCount < 1) {
            return null;
        }
        for (int i = 0; i < entityCount; ++i) {
            ObjReference or;
            SoftwareDeploymentEntity entity = policy.getSoftwareDeploymentEntity(i);
            if (entity == null || !(or = entity.getObjReferenceByTypeAndName("SoftwarePackage", "TargetSoftwarePackageLink")).getTargetId().equals(packageId)) continue;
            return entity;
        }
        return null;
    }

    public static Hashtable<String, ConfigObject> getSoftwarePackageAndDeploymentEntityByPackageType(GroupObject groupObj, int packageType, String platform, String language) throws ConsoleException {
        SoftwareDeploymentPolicy policy = SoftwarePackageHandler.getSoftwareDeploymentPolicy(groupObj);
        if (policy == null) {
            return null;
        }
        return SoftwarePackageHandler.getSoftwarePackageAndDeploymentEntityByPackageType(policy, packageType, platform, language);
    }

    public static ArrayList<SemServerList> getServerList(boolean includeDefaultServerList) throws ConsoleException {
        DataobjectManager data;
        SemDomain domain;
        ObjectPool pool;
        ArrayList<SemServerList> list = new ArrayList<SemServerList>();
        if (includeDefaultServerList) {
            SoftwarePackageHandler.getAllDefaultServerLists(list);
        }
        if ((pool = (domain = (SemDomain)(data = DataobjectManager.getInstance()).getObjectByGUID("SemDomain", Manager.getCurrentDomainId())).getObjectPool()) == null) {
            return list;
        }
        SemServerListPool ssPool = pool.getOptSemServerListPool();
        if (ssPool == null) {
            return list;
        }
        int len = ssPool.getObjReferenceCount();
        if (len == 0) {
            return list;
        }
        for (int i = 0; i < len; ++i) {
            ObjReference obj = ssPool.getObjReference(i);
            SemServerList sp = null;
            try {
                sp = (SemServerList)data.getObjectByGUID("SemServerList", obj.getTargetId());
            }
            catch (ConsoleException e) {
                ConsoleLogger.log(e);
            }
            if (sp == null) continue;
            list.add(sp);
        }
        return list;
    }

    public static ArrayList<SemServerList> getAllDefaultServerLists() throws ConsoleException {
        ArrayList<SemServerList> list = new ArrayList<SemServerList>();
        SoftwarePackageHandler.getAllDefaultServerLists(list);
        return list;
    }

    public static void getAllDefaultServerLists(ArrayList<SemServerList> list) throws ConsoleException {
        if (list == null) {
            return;
        }
        DataobjectManager data = DataobjectManager.getInstance();
        SemConfigRoot configRoot = data.getSemConfigRoot();
        SemSiteArray siteArray = configRoot.getSemSiteArray();
        for (int i = 0; i < siteArray.getObjReferenceCount(); ++i) {
            boolean suspended;
            ObjReference objReference = siteArray.getObjReference(i);
            SemSite semSite = (SemSite)data.getObjectByGUID("SemSite", objReference.getTargetId());
            if (semSite == null || (suspended = (semSite.getOptSuspended() == null ? semSite.getDefSuspended() : semSite.getOptSuspended()).booleanValue())) continue;
            try {
                SemServerList defaultServerList = GUIManager.getDefaultServerList(semSite.getId());
                if (defaultServerList == null) continue;
                if (Manager.isLocalSite(semSite.getId())) {
                    list.add(0, defaultServerList);
                    continue;
                }
                list.add(defaultServerList);
                continue;
            }
            catch (Throwable ex) {
                throw new ConsoleException(ex);
            }
        }
    }

    public static boolean isEmptyDefaultServerList(SemServerList serverList, ArrayList<SemServerList> listDefaultServerLists) throws ConsoleException {
        ArrayList<SemServerList> defaultServerLists;
        if (serverList == null) {
            return false;
        }
        if (serverList.getSemServerBlockCount() > 0) {
            for (int i = 0; i < serverList.getSemServerBlockCount(); ++i) {
                SemServerBlock block = serverList.getSemServerBlock(i);
                if (block.getHostAddressCount() <= 0) continue;
                return false;
            }
        }
        if ((defaultServerLists = listDefaultServerLists) == null || defaultServerLists.size() < 1) {
            defaultServerLists = SoftwarePackageHandler.getAllDefaultServerLists();
        }
        for (int i = 0; i < defaultServerLists.size(); ++i) {
            SemServerList list = defaultServerLists.get(i);
            if (!serverList.getId().equals(list.getId())) continue;
            ConsoleLogger.log("SoftrwarePackageHandler>> isEmptyDefaultServerList: selected server list is default and empty! name=" + serverList.getName());
            return true;
        }
        return false;
    }

    public static SoftwarePackage getSoftwarePackageFromDeploymentEntity(SoftwareDeploymentEntity entity, boolean includeCache) throws ConsoleException {
        if (entity == null) {
            return null;
        }
        ObjReference or = entity.getObjReferenceByTypeAndName("SoftwarePackage", "TargetSoftwarePackageLink");
        return SoftwarePackageHandler.getSoftwarePackage(or.getTargetId(), includeCache);
    }

    public static int getSoftwareDeploymentEntityCount(GroupObject groupObject) throws ConsoleException {
        SoftwareDeploymentPolicy policy = SoftwarePackageHandler.getSoftwareDeploymentPolicy(groupObject);
        if (policy == null) {
            return 0;
        }
        return policy.getSoftwareDeploymentEntityCount();
    }

    public static SoftwareDeploymentPolicy getSoftwareDeploymentPolicy(GroupObject groupObject) throws ConsoleException {
        if (groupObject == null || groupObject.getSemClientGroup() == null) {
            return null;
        }
        return SoftwarePackageHandler.getSoftwareDeploymentPolicy(SoftwarePackageHandler.getGroupPolicy(groupObject));
    }

    public static SoftwareDeploymentPolicy getSoftwareDeploymentPolicy(SemGroupPolicy semGroupPolicy) throws ConsoleException {
        if (semGroupPolicy == null) {
            return null;
        }
        ObjReference ref = Manager.getFirstObjReferenceByTargetType(semGroupPolicy.getObjReference(), "SoftwareDeploymentPolicy");
        if (ref == null) {
            return null;
        }
        return (SoftwareDeploymentPolicy)DataobjectManager.getInstance().getObjectByGUID("SoftwareDeploymentPolicy", ref.getTargetId());
    }

    public static SoftwarePackage getSoftwarePackageFromSiteReplicaitonCache(SoftwareDeploymentEntity entity) throws ConsoleException {
        ObjReference ref = entity.getObjReferenceByTypeAndName("SoftwarePackage", "TargetSoftwarePackageLink");
        return SoftwarePackageHandler.getSoftwarePackageFromSiteReplicaitonCache(ref.getTargetId());
    }

    public static SemAgentPolicy getAgentPolicy(SemGroupPolicy groupPolicy) throws ConsoleException {
        if (groupPolicy == null) {
            return null;
        }
        ObjReference ref = Manager.getFirstObjReferenceByTargetType(groupPolicy.getObjReference(), "SemAgentPolicy");
        if (ref == null) {
            return null;
        }
        return (SemAgentPolicy)DataobjectManager.getInstance().getObjectByGUID("SemAgentPolicy", ref.getTargetId());
    }

    public static SemGroupPolicy getGroupPolicy(GroupObject groupObject) throws ConsoleException {
        SemClientGroup semClientGroup = groupObject.getSemClientGroup();
        String groupPolicyId = semClientGroup.getObjReference().getTargetId();
        SemGroupPolicy policy = null;
        try {
            policy = (SemGroupPolicy)DataobjectManager.getInstance().getObjectByGUID("SemGroupPolicy", groupPolicyId);
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log("SoftwarePackageHandler>> getGroupPolicy: ConsoleException... group id=" + groupObject.getId() + ", policy id=" + groupPolicyId);
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        return policy;
    }

    public static boolean isPolicyInheritance(SemGroupPolicy policy) throws ConsoleException {
        if (policy == null) {
            return false;
        }
        Inheritance ih = policy.getInheritance();
        return ih.getMode().equals(Inheritance.USE_PARENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFile(String id, long size) throws ConsoleException {
        BufferedOutputStream bos;
        BufferedInputStream bis;
        InputStream is;
        String tempFile;
        block7: {
            tempFile = Utility.getTempDir() + File.separator + Utility.getGUIDString();
            is = null;
            bis = null;
            bos = null;
            bos = new BufferedOutputStream(new FileOutputStream(tempFile));
            is = GUIManager.getFile(id);
            if (is != null) break block7;
            String string = null;
            IOUtilities.closeInputStream((InputStream)is);
            IOUtilities.closeInputStream(bis);
            IOUtilities.closeOutputStream((OutputStream)bos);
            return string;
        }
        try {
            int bytesRead;
            bis = new BufferedInputStream(is);
            int iBufferSize = 1024;
            byte[] buffer = new byte[iBufferSize];
            while ((bytesRead = bis.read(buffer)) != -1) {
                ((OutputStream)bos).write(buffer, 0, bytesRead);
            }
            ((OutputStream)bos).flush();
        }
        catch (Exception e) {
            try {
                ConsoleLogger.log("SoftwarePackageHandler>> getFile: Error-> Failed to read file: id=" + id + ", input size=" + size);
                LoggerUtilities.logException((Throwable)e);
                tempFile = null;
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(is);
                IOUtilities.closeInputStream(bis);
                IOUtilities.closeOutputStream((OutputStream)bos);
                throw throwable;
            }
            IOUtilities.closeInputStream((InputStream)is);
            IOUtilities.closeInputStream(bis);
            IOUtilities.closeOutputStream((OutputStream)bos);
        }
        IOUtilities.closeInputStream((InputStream)is);
        IOUtilities.closeInputStream((InputStream)bis);
        IOUtilities.closeOutputStream((OutputStream)bos);
        if (tempFile != null) {
            ConsoleLogger.log("SoftwarePackageHandler>> getFile: size=" + new File(tempFile).length() + ", input size=" + size);
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[][] getAgentPolicyFiles(String id, int packageType) throws ConsoleException {
        InputStream is = null;
        BufferedInputStream bis = null;
        byte[][] data = null;
        int count = 0;
        try {
            is = GUIManager.getAgentPolicyFiles(id, packageType);
            bis = new BufferedInputStream(is);
            InputStream inputStream = is;
            synchronized (inputStream) {
                char separator = '|';
                count = SoftwarePackageHandler.getFileCountFromAgentPolicyFilesInputStream(bis, separator);
                if (count > 0) {
                    data = new byte[count][];
                    for (int i = 0; i < count; ++i) {
                        data[i] = SoftwarePackageHandler.getFileFromAgentPolicyFilesInputStream(bis, separator);
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                LoggerUtilities.logException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream((InputStream)is);
                IOUtilities.closeInputStream(bis);
                throw throwable;
            }
            IOUtilities.closeInputStream((InputStream)is);
            IOUtilities.closeInputStream((InputStream)bis);
        }
        IOUtilities.closeInputStream((InputStream)is);
        IOUtilities.closeInputStream((InputStream)bis);
        if (data == null || count < 1) {
            ConsoleLogger.log("SoftwarePackageHandler>> getAgentPolicyFiles: NO FILE for " + id + "!");
            return null;
        }
        return data;
    }

    public static RecycleBin getRecycleBin() throws ConsoleException {
        DataobjectManager dataMgr = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)dataMgr.getObjectByGUID("SemDomain", Manager.getCurrentDomainId(), false);
        ObjectPool pool = domain.getObjectPool();
        if (pool == null) {
            return null;
        }
        return pool.getRecycleBin();
    }

    public static String getZipFile(String infoFile) {
        String filePath;
        String fileName;
        String datFile;
        if (infoFile == null) {
            return null;
        }
        if (infoFile.endsWith(ConstantValue.getSupportedpackagefiletypesByIndex((int)1))) {
            return infoFile;
        }
        File packageFile = new File(infoFile);
        if (packageFile.exists() && new File(datFile = (fileName = (filePath = packageFile.getAbsolutePath()).substring(0, filePath.lastIndexOf(46))) + ConstantValue.getSupportedpackagefiletypesByIndex((int)2)).exists()) {
            return datFile;
        }
        return null;
    }

    public static boolean isPackageOfCorrectFileType(String fileName) {
        boolean result = false;
        if (fileName == null || fileName.trim().length() == 0) {
            return result;
        }
        for (String ext : ConstantValue.getSupportedpackagefiletypes()) {
            if (!fileName.endsWith(ext)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static SoftwarePackage getSoftwarePackageFromSiteReplicaitonCache(String id) throws ConsoleException {
        SemLoginInfo loginInfo = DataobjectManager.getInstance().getLoginInformation();
        String siteId = loginInfo.getSiteGUID();
        SemSite site = (SemSite)DataobjectManager.getInstance().getObjectByGUID("SemSite", siteId);
        return new SiteObject(site).getsoftwarePackageFromCache(id);
    }

    public static SoftwarePackage getSoftwarePackage(String id, boolean includeCache) throws ConsoleException {
        Object sp = null;
        try {
            sp = DataobjectManager.getInstance().getSoftwarePackage(id);
        }
        catch (ConsoleException ignore) {
            if (ignore.getErrorCode() == 0x16010000) {
                sp = includeCache ? SoftwarePackageHandler.getSoftwarePackageFromSiteReplicaitonCache(id) : null;
            }
            throw ignore;
        }
        return sp;
    }

    public static ArrayList<CurrentPackageObject> getAutoUpgradableCurrentSoftwarePackages() throws ConsoleException {
        ArrayList<CurrentPackageObject> listPO = SoftwarePackageHandler.getCurrentSoftwarePackages();
        SoftwarePackageHandler.filterUnAutoUpgradablePackages(listPO);
        return listPO;
    }

    public static ArrayList<CurrentPackageObject> getRemoteInstallableCurrentSoftwarePackages() throws ConsoleException {
        ArrayList<CurrentPackageObject> listPO = SoftwarePackageHandler.getCurrentSoftwarePackages();
        SoftwarePackageHandler.filterUnRemoteInstallablePackages(listPO);
        return listPO;
    }

    public static List<CurrentPackageObject> removeODCPackages(List<CurrentPackageObject> allPackages) {
        ArrayList<CurrentPackageObject> retList = new ArrayList<CurrentPackageObject>();
        for (int i = allPackages.size() - 1; i >= 0; --i) {
            CurrentPackageObject pkgObj = allPackages.get(i);
            int packageType = pkgObj.getPackageType();
            if (packageType == 300 || packageType == 301) continue;
            retList.add(pkgObj);
        }
        Collections.reverse(retList);
        return retList;
    }

    public static int getSylinkDrop(String packageFolder, String platform) {
        int returnValue = 1;
        boolean downRequired = false;
        String sylinkdropFolder = packageFolder;
        try {
            File fFolder = new File(sylinkdropFolder);
            if (!fFolder.exists()) {
                if (!fFolder.mkdirs()) {
                    return 3;
                }
                downRequired = true;
            }
        }
        catch (Exception e) {
            return 3;
        }
        String strSylinkdropexe = sylinkdropFolder + File.separator + PackageUtil.getSylinkDropExeName((String)platform);
        File fSylinkdropexe = new File(strSylinkdropexe);
        if (!fSylinkdropexe.exists()) {
            downRequired = true;
        }
        if (downRequired) {
            String sylinkdropURL = PackageUtil.getSylinkDropExePath((String)platform);
            int sylinkdropResult = SoftwarePackageHandler.downloadPackage(sylinkdropURL, "", fSylinkdropexe);
            if (sylinkdropResult != 1) {
                ConsoleLogger.log(Utility.getPerformanceLog((String)"custom deployment", (String)"Unable to download the Sylinkdrop", (boolean)false));
                returnValue = sylinkdropResult;
            } else {
                ConsoleLogger.log("download the Sylinkdrop finished");
                returnValue = 1;
            }
        }
        return returnValue;
    }

    private static void deleteObjectBeforeAdd(TopLevelObject obj) throws ConsoleException {
        block3: {
            try {
                DataobjectManager dataobjectManager = DataobjectManager.getInstance();
                TopLevelObject physicalFileDB = dataobjectManager.getObjectByGUID(obj.getObjectTypeName(), obj.getId(), true);
                if (physicalFileDB != null) {
                    ConsoleLogger.log("\tDeleting TopLevelObject: id=" + obj.getId() + ", type=" + obj.getObjectTypeName());
                    dataobjectManager.deleteObject(obj);
                }
            }
            catch (ConsoleException exc) {
                if (exc.getErrorCode() == 0x16010000) break block3;
                throw exc;
            }
        }
    }

    public static SoftwarePackage getSecurityFixSoftwarePackageByPVL(ClientPackageUtils.SetAidIni setAidIni) throws ConsoleException {
        SoftwarePackage softwarePackage = null;
        if ("WIN32BIT".equalsIgnoreCase(setAidIni.getPlatformType()) || "WIN64BIT".equalsIgnoreCase(setAidIni.getPlatformType())) {
            ConsoleLogger.log("SoftwarePackageHandler>> getSecurityFixSoftwarePackageByPVL>> Checking if Security Fix PVL exists for PlatformType: " + setAidIni.getPlatformType() + ", ServerVersion:" + setAidIni.getServerVersion() + ", ServerLanguage: " + setAidIni.getServerLanguage());
            LuRegistration luSFReg = LuUtility.getSFContentLuRegistration(setAidIni.getPlatformType(), setAidIni.getServerVersion(), setAidIni.getServerLanguage());
            if (luSFReg != null && luSFReg.getOptLuClientRegistration() != null) {
                ConsoleLogger.log("SoftwarePackageHandler>> getSecurityFixSoftwarePackageByPVL>> Found LuRegistration from Catalog for the PVL!");
                DataobjectManager manager = DataobjectManager.getInstance();
                LuDownloadedContentArray luDownloadedContentArray = LuUtility.getLuDownloadedContentArray(true);
                if (luDownloadedContentArray != null) {
                    for (LuPackageContent pkgContent : luDownloadedContentArray.getLuPackageContent()) {
                        if (!pkgContent.getServerMoniker().equalsIgnoreCase(setAidIni.getServerMoniker()) || !pkgContent.getServerProduct().equalsIgnoreCase(setAidIni.getServerProduct()) || !pkgContent.getServerVersion().equalsIgnoreCase(setAidIni.getServerVersion()) || !pkgContent.getServerLanguage().equalsIgnoreCase(setAidIni.getServerLanguage())) continue;
                        ConsoleLogger.log("SoftwarePackageHandler>> getSecurityFixSoftwarePackageByPVL>> found target LuPackageContent: " + pkgContent.toString());
                        softwarePackage = (SoftwarePackage)manager.getObjectByGUID("SoftwarePackage", pkgContent.getObjReference().getTargetId(), true);
                        if (softwarePackage == null) {
                            throw new ConsoleException("Cannot find SoftwarePackage for ID: " + pkgContent.getObjReference().getTargetId());
                        }
                        ConsoleLogger.log("SoftwarePackageHandler>> getSecurityFixSoftwarePackageByPVL>> Found target SoftwarePackage, PakageName: " + softwarePackage.getName() + ", ID: " + softwarePackage.getId());
                        break;
                    }
                }
            } else {
                ConsoleLogger.log("SoftwarePackageHandler>> getSecurityFixSoftwarePackageByPVL>> Didn't find LuRegistration from Catalog for the PVL!");
            }
        }
        return softwarePackage;
    }
}

