/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.FwNetworkServiceGroup;
import com.sygate.scm.common.configobject.schema.FwNetworkServicePool;
import com.sygate.scm.common.configobject.schema.FwProtocolContainer;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.RecycleBin;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SuspendedItem;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.ConfigObjectUtils;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyApplyHelper;
import com.sygate.scm.console.ui.policy.explorer.ste.ServiceTypePanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.ServiceDialog;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolContainerObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;

public class ServiceTypeHandler {
    private static ArrayList<ProtocolContainerObject> protocolContainers = new ArrayList();
    private static ServiceTypePanel serviceTypePanel;
    private static ServiceTypeHandler instance;
    private MessageResources msgRes = MessageResources.getInstance();

    private ServiceTypeHandler() {
    }

    public void addService(JTable table) {
        FwProtocolContainer protocolContainer = new FwProtocolContainer();
        FwNetworkServiceGroup serviceGroup = new FwNetworkServiceGroup();
        String guiIDString = new GUIDGenerator().getGUIDString();
        serviceGroup.setId(guiIDString);
        ProtocolContainerObject newContainerObject = new ProtocolContainerObject(protocolContainer, serviceGroup);
        try {
            ServiceDialog dlg = new ServiceDialog(newContainerObject);
            if (dlg.isOk()) {
                ProtocolContainerObject service = dlg.getProtocolContainerObject();
                serviceGroup.setName(service.getName());
                this.addService(service);
            }
            dlg.dispose();
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), this.msgRes.getString("com.sygate.scm.console.handler.handler", "ServiceTypeHandler.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
        catch (Exception exception) {
            LoggerUtilities.logException((Throwable)exception);
            System.err.println("Policy Library Explorer : Error adding Network Service");
        }
    }

    public void editService(JTable table) {
        int index = table.getSelectedRow();
        if (index == -1) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.msgRes.getString("com.sygate.scm.console.handler.handler", "ServiceTypeHandler.SelectServiceToEdit"));
            return;
        }
        try {
            SortableTableModel model = (SortableTableModel)table.getModel();
            ProtocolContainerObject oldPcObj = (ProtocolContainerObject)model.getRow(index);
            FwProtocolContainer pcContainer = (FwProtocolContainer)PolicyHandler.getCopyOfObj((ConfigObject)oldPcObj.getProtocolContainer());
            FwNetworkServiceGroup nsGroup = (FwNetworkServiceGroup)PolicyHandler.getCopyOfObj((ConfigObject)oldPcObj.getServiceGroup());
            ProtocolContainerObject protocolContainerObject = new ProtocolContainerObject(pcContainer, nsGroup);
            ServiceDialog dlg = new ServiceDialog(protocolContainerObject, true);
            if (dlg.isOk()) {
                ProtocolContainerObject newContainerObject = dlg.getProtocolContainerObject();
                FwNetworkServiceGroup serviceGroup = newContainerObject.getServiceGroup();
                serviceGroup.setName(newContainerObject.getName());
                serviceGroup.setFwProtocolContainer(newContainerObject.getProtocolContainer());
                if (!ConfigObjectUtils.isEqualObj((Object)serviceGroup, (Object)oldPcObj.getServiceGroup())) {
                    this.updateService(index, newContainerObject);
                }
            }
            dlg.dispose();
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), this.msgRes.getString("com.sygate.scm.console.handler.handler", "ServiceTypeHandler.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
        catch (Exception exception) {
            LoggerUtilities.logException((Throwable)exception);
            System.err.println("Policy Library Explorer : Error updating Network Service");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteService(JTable table) {
        int index = table.getSelectedRow();
        if (index == -1) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.msgRes.getString("com.sygate.scm.console.handler.handler", "ServiceTypeHandler.error.SelectRowBeforeDeleteService"));
            return;
        }
        String message = this.msgRes.getString("com.sygate.scm.console.handler.handler", "ServiceTypeHandler.ConfirmDeleteService");
        int result = UIUtilities.confirmYesNoOptionDialog(message, this.msgRes.getString("com.sygate.scm.console.handler.handler", "ServiceTypeHandler.title.DeleteService"));
        if (result != 0) return;
        try {
            SortableTableModel model = (SortableTableModel)table.getModel();
            ProtocolContainerObject pcObject = (ProtocolContainerObject)model.getRow(index);
            if (!this.deleteService(pcObject)) return;
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), this.msgRes.getString("com.sygate.scm.console.handler.handler", "ServiceTypeHandler.title.DeleteService"), 0);
            Manager.getFrame().showLoginPanel();
            return;
        }
        catch (Exception exception) {
            LoggerUtilities.logException((Throwable)exception);
            System.err.println("Policy Library Explorer : Error deleting Network Service");
        }
    }

    private void addService(ProtocolContainerObject newObject) throws ConsoleException {
        SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
        ObjectPool objectPool = currentDomain.getObjectPool();
        FwNetworkServicePool networkServicePool = objectPool.getOptFwNetworkServicePool();
        if (networkServicePool == null) {
            networkServicePool = new FwNetworkServicePool();
            objectPool.setOptFwNetworkServicePool(networkServicePool);
        }
        FwNetworkServiceGroup serviceGroup = newObject.getServiceGroup();
        serviceGroup.addChild((AbstractSchema)newObject.getProtocolContainer());
        String id = serviceGroup.getId();
        String type = serviceGroup.getObjectTypeName();
        ObjReference ref = new ObjReference();
        ref.setTargetId(id);
        ref.setTargetType(type);
        ref.setName(newObject.getName());
        networkServicePool.addObjReference(ref);
        ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)serviceGroup, 1);
        updateList.add(entry);
        entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)currentDomain, 0);
        updateList.add(entry);
        Map<String, Object> resultTable = DataobjectManager.getInstance().updateObject("Merge", updateList);
        serviceGroup = (FwNetworkServiceGroup)resultTable.get(id);
        newObject.setServiceGroup(serviceGroup);
        protocolContainers.add(newObject);
        String desc = new StringBuffer().append(this.msgRes.getString("com.sygate.scm.console.handler.handler", "ServiceTypeHandler.title.AddService")).append("[").append(newObject.getName()).append("]").toString();
        ConsoleLogger.logPolicyEvent(0, newObject.getServiceGroup().getId(), desc, null);
    }

    private void updateService(int index, ProtocolContainerObject newObject) throws ConsoleException {
        FwNetworkServiceGroup svcGroup = newObject.getServiceGroup();
        svcGroup = (FwNetworkServiceGroup)this.updateObject(svcGroup);
        newObject.setServiceGroup(svcGroup);
        protocolContainers.set(index, newObject);
        String desc = new StringBuffer().append(this.msgRes.getString("com.sygate.scm.console.handler.handler", "ServiceTypeHandler.title.EditService")).append("[").append(newObject.getName()).append("]").toString();
        ConsoleLogger.logPolicyEvent(2, newObject.getServiceGroup().getId(), desc, null);
    }

    private boolean deleteService(ProtocolContainerObject pcObj) throws ConsoleException {
        if (PolicyApplyHelper.isNetworkServiceInUse(pcObj)) {
            return false;
        }
        SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
        ObjectPool objectPool = currentDomain.getObjectPool();
        FwNetworkServicePool networkServicePool = objectPool.getOptFwNetworkServicePool();
        FwNetworkServiceGroup svcGroup = pcObj.getServiceGroup();
        Vector objReferences = networkServicePool.getObjReference();
        int referenceCount = objReferences.size();
        for (int i = 0; i < referenceCount; ++i) {
            ObjReference groupReference = (ObjReference)objReferences.get(i);
            String id = groupReference.getTargetId();
            if (!svcGroup.getId().equals(id)) continue;
            groupReference.getParent().removeChild((AbstractSchema)groupReference);
            String deletedObjTypeName = svcGroup.getObjectTypeName();
            ObjReference objRef = new ObjReference();
            objRef.setTargetId(id);
            objRef.setTargetType(deletedObjTypeName);
            objRef.setName("Suspended" + deletedObjTypeName + "Link");
            RecycleBin bin = objectPool.getRecycleBin();
            SuspendedItem suspended = new SuspendedItem();
            suspended.setDeletedTime(Long.valueOf(new Date().getTime()));
            suspended.setOptWhoDeletedIt(DataobjectManager.getInstance().getCurrentAdministrator().getId());
            suspended.setObjReference(objRef);
            bin.addSuspendedItem(suspended);
            this.updateObject(currentDomain);
            break;
        }
        ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        updateList.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)svcGroup, 2));
        DataobjectManager.getInstance().updateObject("Merge", updateList);
        protocolContainers.remove(pcObj);
        String desc = new StringBuffer().append(this.msgRes.getString("com.sygate.scm.console.handler.handler", "ServiceTypeHandler.title.DeleteService")).append("[").append(pcObj.getName()).append("]").toString();
        ConsoleLogger.logPolicyEvent(1, pcObj.getServiceGroup().getId(), desc, null);
        return true;
    }

    private TopLevelObject updateObject(Object newObj) throws ConsoleException {
        TopLevelObject resultObj = null;
        if (newObj instanceof TopLevelObject) {
            TopLevelObject topLevelObj = (TopLevelObject)newObj;
            resultObj = DataobjectManager.getInstance().updateObject("Merge", topLevelObj);
        }
        return resultObj;
    }

    public static ServiceTypeHandler getInstance() {
        if (null == instance) {
            instance = new ServiceTypeHandler();
        }
        return instance;
    }

    public ArrayList<ProtocolContainerObject> getServices() throws ConsoleException {
        if (protocolContainers.size() == 0) {
            return this.getServicesFromDB();
        }
        return protocolContainers;
    }

    public ArrayList<ProtocolContainerObject> getServicesFromDB() throws ConsoleException {
        Vector objReferences;
        int referenceCount;
        protocolContainers.clear();
        SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
        ObjectPool objectPool = currentDomain.getObjectPool();
        FwNetworkServicePool networkServicePool = objectPool.getOptFwNetworkServicePool();
        if (networkServicePool != null && (referenceCount = (objReferences = networkServicePool.getObjReference()).size()) > 0) {
            ArrayList<String> idList = new ArrayList<String>(referenceCount);
            for (int i = 0; i < referenceCount; ++i) {
                ObjReference objReference = (ObjReference)objReferences.get(i);
                idList.add(objReference.getTargetId());
            }
            List<TopLevelObject> retList = DataobjectManager.getInstance().getMutipleObjectById(idList);
            for (TopLevelObject obj : retList) {
                if (obj == null) continue;
                FwNetworkServiceGroup serviceGroup = (FwNetworkServiceGroup)obj;
                FwProtocolContainer protocolContainer = serviceGroup.getFwProtocolContainer();
                protocolContainer.setOptContainerName(serviceGroup.getOptDisplayName() == null ? serviceGroup.getName() : serviceGroup.getOptDisplayName());
                ProtocolContainerObject containerObject = new ProtocolContainerObject(protocolContainer, serviceGroup);
                containerObject.setReadOnly(true);
                protocolContainers.add(containerObject);
            }
        }
        Collections.sort(protocolContainers);
        return protocolContainers;
    }

    public JPanel getComponent(TreeItem treeItem) {
        if (treeItem.getItemType() == 62 && serviceTypePanel == null) {
            serviceTypePanel = new ServiceTypePanel();
        }
        serviceTypePanel.refresh();
        return serviceTypePanel;
    }
}

