/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.table.AgentBehaviorLog;
import com.sygate.scm.common.configobject.table.AgentPacketLog;
import com.sygate.scm.common.configobject.table.AgentSecurityLog;
import com.sygate.scm.common.configobject.table.AgentSystemLog;
import com.sygate.scm.common.configobject.table.AgentTrafficLog;
import com.sygate.scm.common.configobject.table.EnforcerClientLog;
import com.sygate.scm.common.configobject.table.EnforcerSystemLog;
import com.sygate.scm.common.configobject.table.EnforcerTrafficLog;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.common.configobject.table.ServerAdminLog;
import com.sygate.scm.common.configobject.table.ServerClientLog;
import com.sygate.scm.common.configobject.table.ServerEnforcerLog;
import com.sygate.scm.common.configobject.table.ServerPolicyLog;
import com.sygate.scm.common.configobject.table.ServerSystemLog;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.monitoring.logviewer.AgentBehaviorLogAdapter;
import com.sygate.scm.console.ui.monitoring.logviewer.AgentPacketLogAdapter;
import com.sygate.scm.console.ui.monitoring.logviewer.AgentSecurityLogAdapter;
import com.sygate.scm.console.ui.monitoring.logviewer.AgentSystemLogAdapter;
import com.sygate.scm.console.ui.monitoring.logviewer.AgentTrafficLogAdapter;
import com.sygate.scm.console.ui.monitoring.logviewer.EnforcerClientLogAdapter;
import com.sygate.scm.console.ui.monitoring.logviewer.EnforcerSystemLogAdapter;
import com.sygate.scm.console.ui.monitoring.logviewer.EnforcerTrafficLogAdapter;
import com.sygate.scm.console.ui.monitoring.logviewer.LogAdapter;
import com.sygate.scm.console.ui.monitoring.logviewer.ServerAdminLogAdapter;
import com.sygate.scm.console.ui.monitoring.logviewer.ServerClientLogAdapter;
import com.sygate.scm.console.ui.monitoring.logviewer.ServerEnforcerLogAdapter;
import com.sygate.scm.console.ui.monitoring.logviewer.ServerPolicyLogAdapter;
import com.sygate.scm.console.ui.monitoring.logviewer.ServerSystemLogAdapter;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ServerLogHandler
extends AbstractHandler {
    public static final String AGENT_PACKET_LOG = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ServerLogHandler.AgentPacketLog");
    public static final String AGENT_SECURITY_LOG = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ServerLogHandler.AgentSecurityLog");
    public static final String AGENT_SYSTEM_LOG = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ServerLogHandler.AgentSystemLog");
    public static final String AGENT_TRAFFIC_LOG = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ServerLogHandler.AgentTrafficLog");
    public static final String AGENT_BEHAVIOR_LOG = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ServerLogHandler.AgentBehaviourLog");
    public static final String ENFORCER_CLIENT_LOG = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ServerLogHandler.EnforcerClientLog");
    public static final String ENFORCER_SYSTEM_LOG = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ServerLogHandler.EnforcerSystemLog");
    public static final String ENFORCER_TRAFFIC_LOG = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ServerLogHandler.EnforcerTrafficLog");
    public static final String SERVER_ADMIN_LOG = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ServerLogHandler.ServerAdminLog");
    public static final String SERVER_CLIENT_LOG = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ServerLogHandler.ServerClientLog");
    public static final String SERVER_ENFORCER_LOG = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ServerLogHandler.ServerEnforcerLog");
    public static final String SERVER_POLICY_LOG = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ServerLogHandler.ServerPolicyLog");
    public static final String SERVER_SYSTEM_LOG = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ServerLogHandler.ServerSystemLog");
    private static final int TYPE_NO_TYPE_LOG = -1;

    public static LogAdapter getServerLogData(RpcData rpc, int logType, int start, int count) throws ConsoleException {
        if (logType != -1) {
            return ServerLogHandler.getLogAdapter(rpc, logType, start, count);
        }
        return ServerLogHandler.getLogAdapter();
    }

    public static LogAdapter getServerLogDataForTest(RpcData rpc, int logType, int start, int count) throws ConsoleException {
        if (logType != -1) {
            return ServerLogHandler.getLogAdapterForTest(rpc, logType, start, count);
        }
        return ServerLogHandler.getLogAdapter();
    }

    public static LogAdapter getServerLogExportData(String logType, int start, int count, String queryTable, String queryFilter, boolean ascendingOrder) throws ConsoleException {
        return null;
    }

    public static int getRowCount(RpcData rpc, int logType) throws ConsoleException {
        String objType;
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(logType));
        String domainId = ServerLogHandler.getDomainGUID(logType);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN", (String)Boolean.toString(domainId != null));
        if (domainId != null) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"DOMAIN_ID", (String)domainId);
        }
        if ((objType = ServerLogHandler.getLogViewObjectType(logType)) != null) {
            SemTable table = GUIManager.getRecord(570, rpc, objType, 0, 1);
            return ServerLogHandler.getLogCount(logType, table);
        }
        return 0;
    }

    public static LogAdapter getServerSystemLogAdapter(RpcData rpc, int start, int count) throws ConsoleException {
        String type;
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(12));
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER_2", (String)String.valueOf(count));
        String domainId = ServerLogHandler.getDomainGUID(12);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_1", (String)Boolean.toString(domainId != null));
        if (domainId != null) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"DOMAIN_ID", (String)domainId);
        }
        if ((type = ServerLogHandler.getLogViewObjectType(12)) != null) {
            SemTable table = GUIManager.getRecordPerf(550, rpc, type, start, count);
            return ServerLogHandler.getLogAdapter(12, table);
        }
        return null;
    }

    private static LogAdapter getLogAdapter(RpcData rpc, int logType, int start, int count) throws ConsoleException {
        String type;
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(logType));
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER_2", (String)String.valueOf(count));
        String domainId = ServerLogHandler.getDomainGUID(logType);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_1", (String)Boolean.toString(domainId != null));
        if (domainId != null) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"DOMAIN_ID", (String)domainId);
        }
        if ((type = ServerLogHandler.getLogViewObjectType(logType)) != null) {
            SemTable table = GUIManager.getRecord(550, rpc, type, start, count);
            return ServerLogHandler.getLogAdapter(logType, table);
        }
        return null;
    }

    private static LogAdapter getLogAdapterForTest(RpcData rpc, int logType, int start, int count) throws ConsoleException {
        String type;
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(logType));
        String domainId = ServerLogHandler.getDomainGUID(logType);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_1", (String)Boolean.toString(domainId != null));
        if (domainId != null) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"DOMAIN_ID", (String)domainId);
        }
        if ((type = ServerLogHandler.getLogViewObjectType(logType)) != null) {
            SemTable table = GUIManager.getRecord(560, rpc, type, start, count);
            return ServerLogHandler.getLogAdapter(logType, table);
        }
        return null;
    }

    private static LogAdapter getLogAdapter(int logType, SemTable table) {
        if (table != null) {
            switch (logType) {
                case 0: {
                    return new AgentPacketLogAdapter(table.getAgentPacketLog());
                }
                case 1: {
                    return new AgentSecurityLogAdapter(table.getAgentSecurityLog());
                }
                case 2: {
                    return new AgentSystemLogAdapter(table.getAgentSystemLog());
                }
                case 3: {
                    return new AgentTrafficLogAdapter(table.getAgentTrafficLog());
                }
                case 4: {
                    return new AgentBehaviorLogAdapter(table.getAgentBehaviorLog());
                }
                case 5: {
                    return new EnforcerClientLogAdapter(table.getEnforcerClientLog());
                }
                case 6: {
                    return new EnforcerSystemLogAdapter(table.getEnforcerSystemLog());
                }
                case 7: {
                    return new EnforcerTrafficLogAdapter(table.getEnforcerTrafficLog());
                }
                case 8: {
                    return new ServerAdminLogAdapter(table.getServerAdminLog());
                }
                case 9: {
                    return new ServerClientLogAdapter(table.getServerClientLog());
                }
                case 10: {
                    return new ServerEnforcerLogAdapter(table.getServerEnforcerLog());
                }
                case 11: {
                    return new ServerPolicyLogAdapter(table.getServerPolicyLog());
                }
                case 12: {
                    return new ServerSystemLogAdapter(table.getServerSystemLog());
                }
            }
        }
        return null;
    }

    private static int getLogCount(int logType, SemTable table) {
        if (table != null) {
            switch (logType) {
                case 0: {
                    AgentPacketLog agentPacket = table.getAgentPacketLog(0);
                    if (agentPacket == null) break;
                    return agentPacket.getEventId();
                }
                case 1: {
                    AgentSecurityLog agentSecurity = table.getAgentSecurityLog(0);
                    if (agentSecurity == null) break;
                    return agentSecurity.getEventId();
                }
                case 2: {
                    AgentSystemLog agentSystem = table.getAgentSystemLog(0);
                    if (agentSystem == null) break;
                    return agentSystem.getEventId();
                }
                case 3: {
                    AgentTrafficLog agentTraffic = table.getAgentTrafficLog(0);
                    if (agentTraffic == null) break;
                    return agentTraffic.getEventId();
                }
                case 4: {
                    AgentBehaviorLog agentBehavior = table.getAgentBehaviorLog(0);
                    if (agentBehavior == null) break;
                    return agentBehavior.getEventId();
                }
                case 5: {
                    EnforcerClientLog enforcerClient = table.getEnforcerClientLog(0);
                    if (enforcerClient == null) break;
                    return enforcerClient.getUSN().intValue();
                }
                case 6: {
                    EnforcerSystemLog enforcerSystem = table.getEnforcerSystemLog(0);
                    if (enforcerSystem == null) break;
                    return enforcerSystem.getUSN().intValue();
                }
                case 7: {
                    EnforcerTrafficLog enforcerTraffic = table.getEnforcerTrafficLog(0);
                    if (enforcerTraffic == null) break;
                    return enforcerTraffic.getUSN().intValue();
                }
                case 8: {
                    ServerAdminLog serverAdmin = table.getServerAdminLog(0);
                    if (serverAdmin == null) break;
                    return serverAdmin.getEventId();
                }
                case 9: {
                    ServerClientLog serverClient = table.getServerClientLog(0);
                    if (serverClient == null) break;
                    return serverClient.getEventId();
                }
                case 10: {
                    ServerEnforcerLog serverEnforcer = table.getServerEnforcerLog(0);
                    if (serverEnforcer == null) break;
                    return serverEnforcer.getEventId();
                }
                case 11: {
                    ServerPolicyLog serverPolicy = table.getServerPolicyLog(0);
                    if (serverPolicy == null) break;
                    return serverPolicy.getEventId();
                }
                case 12: {
                    ServerSystemLog serverSystem = table.getServerSystemLog(0);
                    if (serverSystem == null) break;
                    return serverSystem.getEventId();
                }
            }
        }
        return 0;
    }

    private static String getLogViewObjectType(int logType) {
        switch (logType) {
            case 0: {
                return "AgentPacketLog";
            }
            case 1: {
                return "AgentSecurityLog";
            }
            case 2: {
                return "AgentSystemLog";
            }
            case 3: {
                return "AgentTrafficLog";
            }
            case 4: {
                return "AgentBehaviorLog";
            }
            case 5: {
                return "EnforcerClientLog";
            }
            case 6: {
                return "EnforcerSystemLog";
            }
            case 7: {
                return "EnforcerTrafficLog";
            }
            case 8: {
                return "ServerAdminLog";
            }
            case 9: {
                return "ServerClientLog";
            }
            case 10: {
                return "ServerEnforcerLog";
            }
            case 11: {
                return "ServerPolicyLog";
            }
            case 12: {
                return "ServerSystemLog";
            }
        }
        return null;
    }

    private static String getDomainGUID(int logType) {
        if (logType == 12) {
            return null;
        }
        SemAdministrator currentAdmin = DataobjectManager.getInstance().getCurrentAdministrator();
        if (!Manager.isSystemAdmin(currentAdmin)) {
            return DataobjectManager.getInstance().getLoginInformation().getOptDomainGUID();
        }
        return null;
    }

    private static LogAdapter getLogAdapter() {
        return new LogAdapter(){
            String[] columnNames = new String[0];

            @Override
            public String[] getColumnNames() {
                return this.columnNames;
            }

            @Override
            public Object getValueAt(int row, int column) {
                return "";
            }

            @Override
            public int getRowCount() {
                return 0;
            }

            @Override
            public List<List<Object>> getLogData() {
                return new ArrayList<List<Object>>();
            }

            @Override
            public void setViewType(int viewType) {
            }

            @Override
            public Object[] getExportLogData(boolean isColumnNames, boolean isFirstRow) {
                return null;
            }
        };
    }

    public static List<ServerPolicyLog> getServerPolicyLog(boolean policyPool, int start, int count, List<String> ownerIdList) throws ConsoleException {
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID_LIST", (String)ServerLogHandler.buildIdList(ownerIdList));
        SemDomain domain = DataobjectManager.getInstance().getCurrentSemDomain();
        String domainId = "";
        if (domain != null) {
            domainId = domain.getId();
        }
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"DOMAIN_ID", (String)domainId);
        int sqlQuryCons = 551;
        if (policyPool) {
            sqlQuryCons = 552;
        }
        SemTable table = GUIManager.getRecord(sqlQuryCons, rpc, "ServerPolicyLog", start, count);
        Vector rows = new Vector();
        if (table != null) {
            rows = table.getServerPolicyLog();
        }
        return rows;
    }

    private static String buildIdList(List<String> groupId) {
        StringBuilder buffer = new StringBuilder();
        for (String id : groupId) {
            buffer.append("," + id);
        }
        return buffer.substring(1);
    }
}

