/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.rpc.NameValuePair;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.rpc.SemLoginInfo;
import com.sygate.scm.common.configobject.schema.DefServerListFlag;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.NetworkACL;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.configobject.schema.Replication;
import com.sygate.scm.common.configobject.schema.ReplicationPartnerArray;
import com.sygate.scm.common.configobject.schema.ReplicationPartnership;
import com.sygate.scm.common.configobject.schema.ReplicationState;
import com.sygate.scm.common.configobject.schema.Reporting;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemServerState;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SemSiteArray;
import com.sygate.scm.common.configobject.schema.ServerArray;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.CertificateDlg;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.ContainerObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.Partner;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.NetworkUtils;
import com.sygate.scm.util.Utility;
import java.io.ByteArrayInputStream;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class ServerHandler
extends AbstractHandler {
    public static TreeModel getServerTree() throws ConsoleException {
        MessageResources msgRes = MessageResources.getInstance();
        ContainerObject serverMgr = new ContainerObject(4, msgRes.getString("com.sygate.scm.console.handler.handler", "ServerHandler.tree.Servers"));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(serverMgr);
        DefaultMutableTreeNode localSiteNode = null;
        ContainerObject remoteSites = new ContainerObject(19, msgRes.getString("com.sygate.scm.console.handler.handler", "ServerHandler.tree.RemoteSites"));
        DefaultMutableTreeNode remoteSitesNode = new DefaultMutableTreeNode(remoteSites);
        DataobjectManager data = DataobjectManager.getInstance();
        SemConfigRoot configRoot = data.getSemConfigRoot();
        SemSiteArray siteArray = configRoot.getSemSiteArray();
        for (int i = 0; i < siteArray.getObjReferenceCount(); ++i) {
            ObjReference objReference = siteArray.getObjReference(i);
            SemSite semSite = (SemSite)data.getObjectByGUID("SemSite", objReference.getTargetId(), true);
            SiteObject site = new SiteObject(semSite);
            if (Manager.isLocalSite(site.getId())) {
                site.setDisplayName(MessageFormat.format(msgRes.getString("com.sygate.scm.console.handler.handler", "ServerHandler.tree.LocalSite"), site.getName()));
                localSiteNode = site.getSiteNode();
                continue;
            }
            if (site.isSuspended()) continue;
            remoteSitesNode.add(site.getSiteNode());
        }
        if (localSiteNode == null) {
            throw new ConsoleException(-1576927232, 94);
        }
        if (LicenseObject.getInstance().isSBProduct()) {
            Object localServer = ((DefaultMutableTreeNode)localSiteNode.getChildAt(0)).getUserObject();
            for (int i = 0; i < localSiteNode.getChildCount(); ++i) {
                String serverId;
                Object obj = ((DefaultMutableTreeNode)localSiteNode.getChildAt(i)).getUserObject();
                if (!(obj instanceof ServerObject) || !Manager.isLocalServer(serverId = ((ServerObject)obj).getId())) continue;
                localServer = obj;
                break;
            }
            root = new DefaultMutableTreeNode(localServer);
        } else {
            root.add(localSiteNode);
        }
        if (remoteSitesNode.getChildCount() > 0) {
            root.add(remoteSitesNode);
        }
        return new DefaultTreeModel(root);
    }

    public static ServerObject getSBServer() throws ConsoleException {
        TreeModel servers = ServerHandler.getServerTree();
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        nodes.add((DefaultMutableTreeNode)servers.getRoot());
        while (nodes.size() > 0) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.get(0);
            nodes.remove(0);
            if (node.getUserObject() != null && node.getUserObject() instanceof ServerObject) {
                return (ServerObject)node.getUserObject();
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                nodes.add(0, (DefaultMutableTreeNode)node.getChildAt(i));
            }
        }
        return null;
    }

    public static ServerObject getSBServerByGUID(String serverGUID) throws ConsoleException {
        if (serverGUID == null || "".equals(serverGUID)) {
            return null;
        }
        TreeModel servers = ServerHandler.getServerTree();
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        nodes.add((DefaultMutableTreeNode)servers.getRoot());
        while (nodes.size() > 0) {
            ServerObject server;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.get(0);
            nodes.remove(0);
            if (node.getUserObject() != null && node.getUserObject() instanceof ServerObject && (server = (ServerObject)node.getUserObject()).getId().equals(serverGUID)) {
                return server;
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                nodes.add((DefaultMutableTreeNode)node.getChildAt(i));
            }
        }
        return null;
    }

    public static boolean delServer(ServerObject server) throws ConsoleException {
        Integer status;
        SemServerState serverState;
        SemServer semServer;
        DataobjectManager data;
        MessageResources msgRes;
        block8: {
            msgRes = MessageResources.getInstance();
            data = DataobjectManager.getInstance();
            semServer = server.getSemServer();
            String guidString = semServer.getId();
            serverState = null;
            try {
                serverState = data.getSemServerState(guidString);
            }
            catch (ConsoleException ex) {
                if (!ex.needRelogin()) break block8;
                throw ex;
            }
        }
        if (serverState != null && SemServerState.ONLINE.equals(status = serverState.getOptStatus()) && serverState.getOptLastCheckpointTime() != null) {
            long lastCheckpoint = serverState.getOptLastCheckpointTime();
            long currentTime = TimeUtil.getServerTime();
            if (currentTime - lastCheckpoint <= 180000L) {
                JOptionPane.showMessageDialog(Manager.getFrame(), msgRes.getString("com.sygate.scm.console.handler.handler", "ServerHandler.error.CannotDeleteOnlineServer"), msgRes.getString("com.sygate.scm.console.handler.handler", "ServerHandler.title.ServerOnline"), 0);
                return false;
            }
        }
        ArrayList inUseDirectoryServer = new ArrayList();
        Optional.ofNullable(semServer.getOptDirectoryServerIntegration()).ifPresent(dsIntegration -> dsIntegration.getDirectoryServer().stream().filter(ds -> ServerHandler.isDirectoryServerInUse(ds.getOptGuid(), false)).forEach(ds -> inUseDirectoryServer.add(ds.getName())));
        if (!inUseDirectoryServer.isEmpty() && 0 != JOptionPane.showOptionDialog(Manager.getFrame(), new DescriptionTextArea(msgRes.getString("com.sygate.scm.console.handler.handler", "ServerHandler.delServer.ServerInUsing")), msgRes.getString("com.sygate.scm.console.handler.handler", "ServerHandler.title.ConfirmDel"), 0, 3, null, null, null)) {
            return false;
        }
        semServer.getParent().removeChild((AbstractSchema)semServer);
        SemSite semSite = server.getParentSite();
        ServerHandler.updateReportServer(semSite, server.getName());
        data.updateObject("Merge", (TopLevelObject)semSite);
        String id = Utility.calculateHash((String)semSite.getId());
        try {
            DefServerListFlag flag = data.getDefServerListFlag(id, true, true);
            flag.setId(id);
            data.updateDefServerListFlag("Overwrite", flag);
        }
        catch (ConsoleException exc) {
            if (exc.getErrorCode() != 0x16010000) {
                throw exc;
            }
            DefServerListFlag flag = new DefServerListFlag();
            flag.setId(id);
            data.addObject((TopLevelObject)flag, false, true);
        }
        return true;
    }

    private static void updateReportServer(SemSite site, String serverName) {
        Reporting rep = site.getOptReporting();
        if (rep == null) {
            return;
        }
        StringBuilder reportServers = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(rep.getReportingServer(), ";");
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken();
            if (name.equals(serverName)) continue;
            reportServers.append(";" + name);
        }
        rep.setReportingServer(reportServers.substring(1));
    }

    public static void deleteSite(SiteObject siteObject) throws ConsoleException {
        block4: {
            Vector<DataobjectManager.UpdateObjectEntry> vector = new Vector<DataobjectManager.UpdateObjectEntry>();
            SemSite semSite = siteObject.getSemSite();
            DataobjectManager data = DataobjectManager.getInstance();
            SemConfigRoot root = data.getSemConfigRoot();
            SemSiteArray siteArray = root.getSemSiteArray();
            int siteCount = siteArray.getObjReferenceCount();
            for (int siteIndex = 0; siteIndex < siteCount; ++siteIndex) {
                ObjReference reference = siteArray.getObjReference(siteIndex);
                String targetguid = reference.getTargetId();
                String targetType = reference.getTargetType();
                if (targetguid == null || targetType == null || !targetType.equals("SemSite")) continue;
                SemSite thisSite = (SemSite)data.getObjectByGUID(targetType, targetguid);
                boolean updateSite = false;
                ReplicationPartnerArray array = thisSite.getReplication().getReplicationPartnerArray();
                int partnerCount = array.getReplicationPartnershipCount();
                for (int partnerIndex = 0; partnerIndex < partnerCount; ++partnerIndex) {
                    ReplicationPartnership partnership = array.getReplicationPartnership(partnerIndex);
                    String partnerSiteName = partnership.getPartnerSiteName();
                    if (partnerSiteName == null || !partnerSiteName.equals(semSite.getName())) continue;
                    partnership.setOptEnable(Boolean.FALSE);
                    updateSite = true;
                }
                if (!updateSite) continue;
                DataobjectManager.UpdateObjectEntry thisSiteEntry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)thisSite, 0);
                vector.add(thisSiteEntry);
            }
            semSite.setOptSuspended(Boolean.TRUE);
            DataobjectManager.UpdateObjectEntry semSiteEntry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)semSite, 0);
            vector.add(semSiteEntry);
            data.updateObject("Merge", vector);
            try {
                DefServerListFlag flag = data.getDefServerListFlag(Utility.calculateHash((String)semSite.getId()), true, true);
                data.deleteDefServerListFlag(flag);
            }
            catch (ConsoleException e) {
                if (e.getErrorCode() == 0x16010000) break block4;
                throw e;
            }
        }
        ServerHandler.refreshReplicationPartnerOnServer(siteObject.getName());
    }

    public static HashMap<String, Object> getRemoteSiteName(String contactServer, String port, String adminName, String password) throws ConsoleException {
        String str;
        RpcData data = new RpcData();
        Utility.addPairToRpcData((RpcData)data, (String)"action", (String)"preRegister");
        Utility.addPairToRpcData((RpcData)data, (String)"contactServer", (String)contactServer);
        Utility.addPairToRpcData((RpcData)data, (String)"port", (String)port);
        Utility.addPairToRpcData((RpcData)data, (String)"adminName", (String)adminName);
        Utility.addPairToRpcData((RpcData)data, (String)"password", (String)password);
        RpcData ret = (RpcData)GUIManager.sendCommand("Replication", (AbstractSchema)data);
        String certStr = null;
        String remoteSiteName = Utility.getValueFromRpcData((RpcData)ret, (String)"siteName");
        if (ret != null && ret.getNameValuePairCount() > 0 && ("MismatchCertificate".equalsIgnoreCase(remoteSiteName) || "UpgradedFrom5xCertificate".equalsIgnoreCase(remoteSiteName))) {
            X509Certificate cert = null;
            str = Utility.getValueFromRpcData((RpcData)ret, (String)"remoteCertificate");
            System.out.println("ServerHandler>> getRemoteCertificate: Certificate str=" + str);
            try {
                byte[] buf = Utility.toByteArray((String)str);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(buf));
            }
            catch (CertificateException ex) {
                System.out.println("CertificateException : " + ex.getMessage());
            }
            if (cert != null) {
                CertificateDlg dlg = new CertificateDlg((JFrame)Manager.getFrame(), cert, CustomLookAndFeel.TITLE_LOGO_ICON);
                if (dlg.isOk()) {
                    System.out.println("Certificate is trusted");
                    Utility.addPairToRpcData((RpcData)data, (String)"servercert", (String)str);
                    certStr = str;
                    try {
                        ret = (RpcData)GUIManager.sendCommand("Replication", (AbstractSchema)data);
                        remoteSiteName = Utility.getValueFromRpcData((RpcData)ret, (String)"siteName");
                    }
                    catch (ConsoleException ce) {
                        System.out.println("ConsoleException : " + ce.getMessage());
                        throw ce;
                    }
                } else {
                    System.out.println("Certificate is not trusted");
                    dlg.dispose();
                    return null;
                }
                dlg.dispose();
            }
        }
        HashMap<String, Object> htData = new HashMap<String, Object>(2);
        if (ret != null) {
            htData.put("RemoteSiteName", remoteSiteName);
            if (!"MismatchCertificate".equalsIgnoreCase(remoteSiteName) && !"Local site's semsite object doesn't exist in remote site".equalsIgnoreCase(remoteSiteName)) {
                try {
                    str = Utility.getValueFromRpcData((RpcData)ret, (String)"remoteReplicationPartnerShip");
                    System.out.println("ServerHandler>> getRemoteSiteName: ReplicationPartnership str=" + str);
                    if (str != null) {
                        ReplicationPartnership partnerShip = (ReplicationPartnership)AbstractSchema.readXML((String)str);
                        htData.put("remoteReplicationPartnerShip", partnerShip);
                    }
                }
                catch (Throwable ex) {
                    System.out.println("ServerHandler>> getRemoteSiteName: Error-> failed to get ReplicationPartnership...");
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
        }
        htData.put("ServerCertificateStr", certStr);
        htData.put("CLOUD_ENROLLED", Utility.getValueFromRpcData((RpcData)ret, (String)"CLOUD_ENROLLED".toString()));
        if (ret != null) {
            htData.put("dbVersion", Utility.getValueFromRpcData((RpcData)ret, (String)"dbVersion"));
        }
        return htData;
    }

    public static Partner addPartner(String partnerSiteName, String contactServer, String port, String adminName, String password, boolean isAutoSchedule, int frequency, String startTime, String endTime, String hourlyRepeat, int dayOfWeek, boolean replicateLogsToPartner, boolean replicateLogsFromPartner, boolean replicateClientPackages, boolean replicateLuContents, String servercert, boolean isPartnerDbRestored) throws ConsoleException {
        RpcData data = new RpcData();
        Utility.addPairToRpcData((RpcData)data, (String)"action", (String)"register");
        Utility.addPairToRpcData((RpcData)data, (String)"contactServer", (String)contactServer);
        Utility.addPairToRpcData((RpcData)data, (String)"port", (String)port);
        Utility.addPairToRpcData((RpcData)data, (String)"adminName", (String)adminName);
        Utility.addPairToRpcData((RpcData)data, (String)"password", (String)password);
        Utility.addPairToRpcData((RpcData)data, (String)"isAutoSchedule", (String)(isAutoSchedule ? "1" : "0"));
        Utility.addPairToRpcData((RpcData)data, (String)"frequency", (String)("" + frequency));
        Utility.addPairToRpcData((RpcData)data, (String)"startTime", (String)startTime);
        Utility.addPairToRpcData((RpcData)data, (String)"dayOfWeek", (String)("" + dayOfWeek));
        if (endTime != null) {
            Utility.addPairToRpcData((RpcData)data, (String)"endTime", (String)endTime);
        }
        if (hourlyRepeat != null) {
            Utility.addPairToRpcData((RpcData)data, (String)"hourlyRepeat", (String)hourlyRepeat);
        }
        Utility.addPairToRpcData((RpcData)data, (String)"replicateLogsToPartner", (String)(replicateLogsToPartner ? "1" : "0"));
        Utility.addPairToRpcData((RpcData)data, (String)"replicateLogsFromPartner", (String)(replicateLogsFromPartner ? "1" : "0"));
        Utility.addPairToRpcData((RpcData)data, (String)"replicateClientPackages", (String)(replicateClientPackages ? "1" : "0"));
        Utility.addPairToRpcData((RpcData)data, (String)"replicateLuContents", (String)(replicateLuContents ? "1" : "0"));
        Utility.addPairToRpcData((RpcData)data, (String)"isPartnerDbRestored", (String)(isPartnerDbRestored ? "1" : "0"));
        if (servercert != null) {
            Utility.addPairToRpcData((RpcData)data, (String)"servercert", (String)servercert);
        }
        RpcData ret = (RpcData)GUIManager.sendCommand("Replication", (AbstractSchema)data);
        ServerHandler.refreshReplicationPartnerOnServer(partnerSiteName);
        NameValuePair pair = ret.getNameValuePair(0);
        String partnerName = pair.getOptValue();
        DataobjectManager manager = DataobjectManager.getInstance();
        SemSite semSite = (SemSite)manager.getObjectByGUID("SemSite", manager.getLoginInformation().getSiteGUID(), true);
        Replication replication = semSite.getReplication();
        ReplicationPartnerArray partnerArray = replication.getReplicationPartnerArray();
        for (int i = 0; i < partnerArray.getReplicationPartnershipCount(); ++i) {
            ReplicationPartnership partnerShip = partnerArray.getReplicationPartnership(i);
            if (!partnerName.equals(partnerShip.getPartnerSiteName())) continue;
            SemSite sitePartner = ServerHandler.retrieveSite(partnerName);
            if (sitePartner != null) {
                sitePartner.setOptSuspended(Boolean.FALSE);
                Replication rPartner = sitePartner.getReplication();
                ReplicationPartnerArray rPartnerArray = rPartner.getReplicationPartnerArray();
                for (int j = 0; j < rPartnerArray.getReplicationPartnershipCount(); ++j) {
                    ReplicationPartnership rPartnerShip = rPartnerArray.getReplicationPartnership(j);
                    if (!semSite.getName().equals(rPartnerShip.getPartnerSiteName())) continue;
                    rPartnerShip.setOptEnable(Boolean.TRUE);
                    break;
                }
                manager.updateObject("Merge", (TopLevelObject)sitePartner);
            }
            return new Partner(partnerShip, semSite.getId());
        }
        return null;
    }

    public static Partner addPartner(String partnerSiteName, String contactServer, String port, String adminName, String password, boolean isAutoSchedule, int frequency, String startTime, int dayOfWeek, boolean replicateLogsToPartner, boolean replicateLogsFromPartner, boolean replicateClientPackages, boolean replicateLuContents, String servercert, boolean isPartnerDbRestored) throws ConsoleException {
        return ServerHandler.addPartner(partnerSiteName, contactServer, port, adminName, password, isAutoSchedule, frequency, startTime, null, null, dayOfWeek, replicateLogsToPartner, replicateLogsFromPartner, replicateClientPackages, replicateLuContents, servercert, isPartnerDbRestored);
    }

    public static SemSite retrieveSite(String siteName) throws ConsoleException {
        if (siteName == null || siteName.length() < 1) {
            return null;
        }
        DataobjectManager data = DataobjectManager.getInstance();
        SemConfigRoot configRoot = data.getSemConfigRoot();
        SemSiteArray siteArray = configRoot.getSemSiteArray();
        for (int i = 0; i < siteArray.getObjReferenceCount(); ++i) {
            ObjReference objReference = siteArray.getObjReference(i);
            SemSite semSite = (SemSite)data.getObjectByGUID("SemSite", objReference.getTargetId());
            if (!semSite.getName().equals(siteName)) continue;
            return semSite;
        }
        return null;
    }

    public static void delPartner(Partner partner) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        ReplicationPartnership partnership = partner.getReplicationPartnership();
        partnership.setOptEnable(Boolean.FALSE);
        SemSite semSite = partner.getSemSite();
        data.updateObject("Merge", (TopLevelObject)semSite);
        ServerHandler.refreshReplicationPartnerOnServer(partnership.getPartnerSiteName());
    }

    private static void refreshReplicationPartnerOnServer(String remoteSiteName) throws ConsoleException {
        RpcData data = new RpcData();
        Utility.addPairToRpcData((RpcData)data, (String)"action", (String)"refresh");
        if (remoteSiteName == null || remoteSiteName.length() <= 0) {
            System.out.println("ServerHandler>> refreshReplicationPartnerOnServer: Error-> no remote site name!");
            throw new ConsoleException(303366144, 9);
        }
        Utility.addPairToRpcData((RpcData)data, (String)"remoteSiteName", (String)remoteSiteName);
        GUIManager.sendCommand("Replication", (AbstractSchema)data);
    }

    public static void updatePartner(Partner remotePartner, boolean replicateLogsToRemotePartner, boolean updateUSNforClientPackages, boolean updateUSNforLuContents) throws ConsoleException {
        ServerHandler.updatePartner(remotePartner, replicateLogsToRemotePartner, updateUSNforClientPackages, updateUSNforLuContents, false);
    }

    public static void updatePartner(Partner remotePartner, boolean replicateLogsToRemotePartner, boolean updateUSNforClientPackages, boolean updateUSNforLuContents, boolean updateUSNforReport) throws ConsoleException {
        if (updateUSNforClientPackages || updateUSNforLuContents) {
            ServerHandler.updateUSN(updateUSNforClientPackages, updateUSNforLuContents);
        }
        if (updateUSNforReport) {
            ServerHandler.updateUSNforReport(updateUSNforReport);
        }
        DataobjectManager data = DataobjectManager.getInstance();
        SemSite localSite = remotePartner.getSemSite();
        SemSite remoteSite = ServerHandler.retrieveSite(remotePartner.getName());
        Partner localPartner = ServerHandler.getPartner(remoteSite, localSite.getName());
        if (localPartner == null) {
            System.out.println("ServerHandler>> updatePartner: Error-> ReplicationPartnership is NOT found!");
        } else {
            localPartner.copySchedule(remotePartner, replicateLogsToRemotePartner);
            data.updateObject("Merge", (TopLevelObject)remoteSite);
        }
        data.updateObject("Merge", (TopLevelObject)localSite);
        ServerHandler.refreshReplicationPartnerOnServer(remotePartner.getName());
    }

    private static void updateUSN(boolean updateUSNforClientPackages, boolean updateUSNforLuContents) throws ConsoleException {
        RpcData data = new RpcData();
        Utility.addPairToRpcData((RpcData)data, (String)"action", (String)"updateUSN");
        Utility.addPairToRpcData((RpcData)data, (String)"updateUSNforClientPackages", (String)(updateUSNforClientPackages ? "1" : "0"));
        Utility.addPairToRpcData((RpcData)data, (String)"updateUSNforLuContents", (String)(updateUSNforLuContents ? "1" : "0"));
        GUIManager.sendCommand("Replication", (AbstractSchema)data);
    }

    private static void updateUSNforReport(boolean updateUSNforReport) throws ConsoleException {
        RpcData data = new RpcData();
        Utility.addPairToRpcData((RpcData)data, (String)"action", (String)"updateUSNforReport");
        Utility.addPairToRpcData((RpcData)data, (String)"updateUSNforReport", (String)(updateUSNforReport ? "1" : "0"));
        GUIManager.sendCommand("Replication", (AbstractSchema)data);
    }

    public static Partner getPartner(SemSite site, String remoteSiteName) {
        Replication replication = site.getReplication();
        ReplicationPartnerArray partners = replication.getReplicationPartnerArray();
        Vector v = partners.getReplicationPartnership();
        for (ReplicationPartnership partner : v) {
            if (!partner.getPartnerSiteName().equals(remoteSiteName)) continue;
            return new Partner(partner, site.getId());
        }
        return null;
    }

    public static void updateDatabase(SemSite semSite) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        data.updateObject("Merge", (TopLevelObject)semSite);
    }

    public static void replicateNow(Partner partner) throws ConsoleException {
        RpcData data = new RpcData();
        Utility.addPairToRpcData((RpcData)data, (String)"action", (String)"replicateNow");
        Utility.addPairToRpcData((RpcData)data, (String)"siteName", (String)partner.getPartnerSiteName());
        Utility.addPairToRpcData((RpcData)data, (String)"twoWay", (String)"true");
        GUIManager.sendCommand("Replication", (AbstractSchema)data);
    }

    public static void cancelReplicate(Partner partner) throws ConsoleException {
        RpcData data = new RpcData();
        Utility.addPairToRpcData((RpcData)data, (String)"action", (String)"cancelReplicate");
        Utility.addPairToRpcData((RpcData)data, (String)"siteName", (String)partner.getPartnerSiteName());
        Utility.addPairToRpcData((RpcData)data, (String)"twoWay", (String)"false");
        GUIManager.sendCommand("Replication", (AbstractSchema)data);
    }

    public static void updateSite(SiteObject siteObj) throws ConsoleException {
        if (siteObj == null) {
            return;
        }
        SemSite semSite = siteObj.getSemSite();
        if (semSite == null) {
            return;
        }
        DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)semSite);
    }

    public static ArrayList<String> getServerNameList(SemSite semSite) throws ConsoleException {
        if (semSite == null) {
            return null;
        }
        ArrayList<String> listServer = new ArrayList<String>();
        ServerArray serverArray = semSite.getServerArray();
        for (int i = 0; i < serverArray.getSemServerCount(); ++i) {
            SemServer server = serverArray.getSemServer(i);
            listServer.add(server.getName());
        }
        return listServer;
    }

    public static ReplicationState getLocalReplicationState(Partner partner) throws ConsoleException {
        ServerArray sa;
        String remoteSiteName = partner.getName();
        DataobjectManager data = DataobjectManager.getInstance();
        String serverID = null;
        SemSite localSite = data.getSemSite(data.getLoginInformation().getSiteGUID());
        if (localSite != null && (sa = localSite.getServerArray()) != null) {
            serverID = sa.getSemServer(0).getId();
        }
        if (serverID == null) {
            ConsoleLogger.log("Failed to get primary replication server's SemServerState.Use current login server ID.");
            serverID = data.getLoginInformation().getServerGUID();
        }
        SemServerState serverState = data.getSemServerState(serverID);
        for (ReplicationState state : serverState.getReplicationState()) {
            if (state == null || state.getOptReplicatorClientSourceSiteId() == null || state.getOptReplicatorClientSourceSiteId().trim().length() == 0 || state.getOptReplicatorClientSourceSiteName() == null || !state.getOptReplicatorClientSourceSiteName().equals(remoteSiteName)) continue;
            return state;
        }
        return null;
    }

    public static boolean isCurrentConsoleAllowedAccess(boolean blockAccess, NetworkACL acl, String consoleLoginIp) {
        int j;
        if (blockAccess && acl.getSubNetCount() == 0 && acl.getIpAddressCount() == 0) {
            return true;
        }
        Set localIPAdresses = NetworkUtils.getAllLocalIPAddress((boolean)false, (boolean)true);
        String sepmServer = Env.getSEM_SERVER();
        String browserMachineIp = null;
        try {
            if (Utility.isValidIPAddr((String)sepmServer)) {
                sepmServer = Utility.getDecompressedIpv6Addr((String)sepmServer);
                if (AjaxSwingCommonUtil.isAjaxSwingRunning() ? sepmServer.equalsIgnoreCase(browserMachineIp = Utility.getDecompressedIpv6Addr((String)AjaxSwingUtil.getRemoteHostIPAddr())) || localIPAdresses.contains(sepmServer.toLowerCase()) && localIPAdresses.contains(browserMachineIp.toLowerCase()) : localIPAdresses.contains(sepmServer.toLowerCase())) {
                    return true;
                }
            } else {
                String sepmServerMachine;
                String localMachineName = "";
                if (AjaxSwingCommonUtil.isAjaxSwingRunning() ? (sepmServerMachine = Utility.getDecompressedIpv6Addr((String)InetAddress.getByName(sepmServer).getHostAddress())).equalsIgnoreCase(browserMachineIp = Utility.getDecompressedIpv6Addr((String)AjaxSwingUtil.getRemoteHostIPAddr())) || localIPAdresses.contains(sepmServerMachine.toLowerCase()) && localIPAdresses.contains(browserMachineIp.toLowerCase()) : (localMachineName = InetAddress.getLocalHost().getHostName()).equalsIgnoreCase(sepmServer) || sepmServer.equalsIgnoreCase("localhost")) {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            return true;
        }
        consoleLoginIp = Utility.getDecompressedIpv6Addr((String)consoleLoginIp);
        for (j = 0; j < acl.getIpAddressCount(); ++j) {
            IpAddress ipAddress = acl.getIpAddress(j);
            String ipFromAcl = Utility.getDecompressedIpv6Addr((String)ipAddress.getContent()).toLowerCase();
            if (browserMachineIp != null) {
                if (blockAccess && browserMachineIp.equalsIgnoreCase(ipFromAcl)) {
                    return false;
                }
                if (blockAccess || !browserMachineIp.equalsIgnoreCase(ipFromAcl)) continue;
                return true;
            }
            if (blockAccess && consoleLoginIp.equalsIgnoreCase(ipFromAcl)) {
                return false;
            }
            if (blockAccess || !consoleLoginIp.equalsIgnoreCase(ipFromAcl)) continue;
            return true;
        }
        for (j = 0; j < acl.getSubNetCount(); ++j) {
            SubNet subnet = acl.getSubNet(j);
            String network = subnet.getNetAddr();
            String mask = subnet.getNetMask();
            if (browserMachineIp != null) {
                if (blockAccess && Utility.isSameSubnet((String)browserMachineIp, (String)network, (String)mask)) {
                    return false;
                }
                if (blockAccess || !Utility.isSameSubnet((String)browserMachineIp, (String)network, (String)mask)) continue;
                return true;
            }
            if (blockAccess && Utility.isSameSubnet((String)consoleLoginIp, (String)network, (String)mask)) {
                return false;
            }
            if (blockAccess || !Utility.isSameSubnet((String)consoleLoginIp, (String)network, (String)mask)) continue;
            return true;
        }
        return blockAccess;
    }

    public static boolean isCurrentConsoleAllowedAccess(NetworkACL acl) {
        boolean blockAccess;
        String consoleLoginIp = null;
        SemLoginInfo loginInfo = DataobjectManager.getInstance().getLoginInformation();
        if (loginInfo != null) {
            consoleLoginIp = loginInfo.getClientIP();
        }
        if (consoleLoginIp == null || consoleLoginIp.trim().length() == 0) {
            try {
                consoleLoginIp = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        boolean bl = blockAccess = acl.getDefaultMode().intValue() == NetworkACL.GRANT_ALL.intValue();
        if (consoleLoginIp != null) {
            return ServerHandler.isCurrentConsoleAllowedAccess(blockAccess, acl, consoleLoginIp);
        }
        return false;
    }

    public static boolean isDirectoryServerInUse(String serverId, boolean isOnlyCheckAdmin) {
        boolean isInUse = true;
        try {
            isInUse = DataobjectManager.getInstance().isDirectoryServerInUse(serverId, isOnlyCheckAdmin);
        }
        catch (ConsoleException ignore) {
            LoggerUtilities.logException((Throwable)ignore);
        }
        return isInUse;
    }

    public static PhysicalFile createSemPhysicalFile(String physicalFileId, String physicalFileBinaryDataId, String physicalFileName, String name, String checksume) {
        PhysicalFile spf = new PhysicalFile();
        spf.setId(physicalFileId);
        spf.setFileLastModifiedTime(Long.valueOf(TimeUtil.getServerTime()));
        spf.setCreationTime(Long.valueOf(TimeUtil.getServerTime()));
        spf.setName(name);
        spf.setFileName(physicalFileName);
        spf.setFileChecksum(checksume);
        spf.setFileSize(Long.valueOf(Utility.getFileSize((String)physicalFileName)));
        ObjReference obj = new ObjReference();
        obj.setName("LinkToFileContent");
        obj.setTargetType("ExPhysicalFileStream");
        obj.setTargetId(physicalFileBinaryDataId);
        spf.setObjReference(obj);
        return spf;
    }
}

