/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.SemClientAgentHandler;
import com.sygate.scm.console.handler.SemClientHandler;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.UserObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;

public class SemUserHandler
extends AbstractHandler {
    public static int getGroupUserCount(String groupId) throws ConsoleException {
        return SemClientHandler.getCountByGroupId(groupId, 0);
    }

    public static ArrayList<ClientObject> getUserList(String groupId, boolean showOnlineStatus, int nStart, int nCount, String orderIds) throws ConsoleException {
        ArrayList<ClientObject> v = SemClientHandler.getListByGroupId(groupId, 0, nStart, nCount, orderIds);
        return v;
    }

    public static int getGroupUserCountByOS(String groupId, int platformFilter, boolean newClientsFilter, int view, boolean isOfflineNPVDIClient) throws ConsoleException {
        return SemClientAgentHandler.getCountByGroupIdAndOS(groupId, platformFilter, newClientsFilter, 0, view, isOfflineNPVDIClient);
    }

    public static UserObject getUser(String userName, String domainName, int pinned) throws ConsoleException {
        if (userName == null || userName.length() < 1 || domainName == null || domainName.length() < 1) {
            return null;
        }
        return (UserObject)SemClientHandler.getClient(userName, domainName, 0, pinned);
    }

    public static String getGroupFromUser(String userName, String domainName, int pinned, boolean group_fullpath) throws ConsoleException {
        return SemClientHandler.getGroupFromClient(userName, domainName, 0, pinned, group_fullpath);
    }

    public static ArrayList<ClientObject> findUser(int sqlType, RpcData rpc, int nStart, int nCount) throws ConsoleException {
        return SemClientHandler.findClients(sqlType, rpc, 0, nStart, nCount);
    }

    public static ArrayList<ClientObject> findUserCompositeInfo(RpcData rpc, int nStart, int nCount, boolean isForExport) throws ConsoleException {
        return SemClientAgentHandler.findClients(rpc, 0, nStart, nCount, isForExport);
    }

    public static int findUserCount(RpcData rpc) throws ConsoleException {
        return SemClientHandler.getCountForFindClients(rpc, 0);
    }

    public static ArrayList<ClientObject> getUserList(String userName, String userDomainName, String hardwareKey, int groupISOU) throws ConsoleException {
        boolean isDbUppercase = DataobjectManager.getInstance().getLoginInformation().getOptDbUpperCase();
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN", (String)String.valueOf(isDbUppercase));
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"NAME", (String)userName);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"DOMAIN_NAME", (String)userDomainName);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"HW_KEY", (String)hardwareKey);
        if (groupISOU == 1 || groupISOU == 0) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER_1", (String)String.valueOf(groupISOU));
        }
        return SemClientHandler.findClients(806, rpc, 0, 0, 1);
    }
}

