/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.table.SemComputer;
import com.sygate.scm.common.configobject.table.SemComputerNic;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.HostIpObject;
import com.sygate.scm.console.logicobject.HostObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.List;

public class SemHostHandler
extends AbstractHandler {
    public static HostObject retrieveHostObject(ClientObject client) throws ConsoleException {
        return SemHostHandler.retrieveHostObject(client, true);
    }

    public static HostObject retrieveHostObject(ClientObject client, boolean checkLogonUser) throws ConsoleException {
        String computerId = client.getComputerId();
        if (!checkLogonUser) {
            return SemHostHandler.retrieveHostObjectByComputerId(computerId);
        }
        String userName = client.getUserName_Same_As_In_DB();
        String userDomainName = client.getUserDomainName_Same_As_In_DB();
        return SemHostHandler.retrieveHostObject(computerId, userName, userDomainName);
    }

    private static HostObject retrieveHostObject(String computerId, String userName, String userDomainName) throws ConsoleException {
        if (computerId == null || computerId.length() < 1 || userName == null || userName.length() < 1 || userDomainName == null || userDomainName.length() < 1) {
            return null;
        }
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)computerId);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"NAME", (String)userName);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"DOMAIN_NAME", (String)userDomainName);
        return SemHostHandler.retrieveHostObject(1101, rpc);
    }

    static HostObject retrieveHostObjectByComputerId(String computerId) throws ConsoleException {
        if (StringUtilities.isEmpty((String)computerId)) {
            return null;
        }
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)computerId);
        HostObject host = SemHostHandler.retrieveHostObject(1102, rpc);
        if (host != null) {
            host.setNicIpList(SemHostHandler.retrieveHostNicObject(1800, rpc));
        }
        return host;
    }

    static HostObject retrieveHostObject(int sqlType, RpcData rpc) throws ConsoleException {
        try {
            SemTable aTable = GUIManager.getRecord(sqlType, rpc, "SemComputer", 0, 1);
            if (aTable.getSemComputerCount() < 1) {
                return null;
            }
            SemComputer c = aTable.getSemComputer(0);
            return new HostObject(c);
        }
        catch (ConsoleException ex) {
            if (ex.getErrorCode() != 302645248) {
                throw ex;
            }
            return null;
        }
    }

    static List<HostIpObject> retrieveHostNicObject(int sqlType, RpcData rpc) throws ConsoleException {
        ArrayList<HostIpObject> list;
        block4: {
            list = new ArrayList<HostIpObject>();
            try {
                SemTable aTable = GUIManager.getRecord(sqlType, rpc, "SemComputerNic", 0, Integer.MAX_VALUE);
                if (aTable.getSemComputerNicCount() < 1) {
                    return null;
                }
                for (SemComputerNic nicIp : aTable.getSemComputerNic()) {
                    HostIpObject ip = new HostIpObject(Utility.getIpAddressLiteral((byte[])nicIp.getOptIpAddr()), nicIp.getOptMacAddr(), Utility.getIpAddressLiteral((byte[])nicIp.getOptGateway()), 4 == nicIp.getOptIpAddr().length ? Utility.convertCidrToNetmask((int)nicIp.getOptSubnetMask()) : nicIp.getOptSubnetMask().toString());
                    if (!ip.isValid()) continue;
                    list.add(ip);
                }
            }
            catch (ConsoleException ex) {
                if (ex.getErrorCode() == 302645248) break block4;
                throw ex;
            }
        }
        return list;
    }
}

