/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.table.SemClient;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.common.configobject.table.SemTableColumnHeader;
import com.sygate.scm.common.configobject.table.SemTableRow;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SemClientAgentHandler;
import com.sygate.scm.console.handler.SemClientHandler;
import com.sygate.scm.console.logicobject.ClientDefaultViewObject;
import com.sygate.scm.console.logicobject.ClientDefaultViewUserObject;
import com.sygate.scm.console.logicobject.ClientNetworkInformationObject;
import com.sygate.scm.console.logicobject.ClientNetworkInformationUserObject;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.ClientStatusObject;
import com.sygate.scm.console.logicobject.ClientStatusUserObject;
import com.sygate.scm.console.logicobject.ClientSystemObject;
import com.sygate.scm.console.logicobject.ClientSystemUserObject;
import com.sygate.scm.console.logicobject.ClientTechnology;
import com.sygate.scm.console.logicobject.ClientTechnologyObject;
import com.sygate.scm.console.logicobject.ClientTechnologyUserObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.OperatingSystemObject;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.IdsUtility;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class SemComputerHandler
extends AbstractHandler {
    public static final int QUERY_GROUP_BATCH = 5000;
    public static final int QUERY_ID_BATCH = 200;
    private static final LicenseObject LIC_OBJ = LicenseObject.getInstance();

    public static int getGroupComputerCount(String groupId) throws ConsoleException {
        return SemClientHandler.getCountByGroupId(groupId, 1);
    }

    public static int getGroupComputerCountByOS(String groupId, int platformFilter, boolean newClientsFilter, int view, boolean isOfflineNPVDIClient) throws ConsoleException {
        return SemClientAgentHandler.getCountByGroupIdAndOS(groupId, platformFilter, newClientsFilter, 1, view, isOfflineNPVDIClient);
    }

    public static ArrayList<ClientObject> getComputerList(String groupId, int nStart, int nCount, String orderIds) throws ConsoleException {
        ArrayList<ClientObject> v = SemClientHandler.getListByGroupId(groupId, 1, nStart, nCount, orderIds);
        return v;
    }

    private static final HashMap<String, ClientObject> getClientObjectHashMap(int clientId, SemTable semTable, int policyMode, String groupId) throws ConsoleException {
        int rows = semTable.getSemTableRowCount();
        if (rows <= 0) {
            return new HashMap<String, ClientObject>(0);
        }
        if (rows <= 2000) {
            return SemComputerHandler.getClientObjectHashMap(clientId, semTable);
        }
        TimeCounter counter = new TimeCounter();
        HashMap<String, ClientObject> myMap = new HashMap<String, ClientObject>(rows);
        HashSet<String> clientIdList = new HashSet<String>(rows);
        for (int i = 0; i < rows; ++i) {
            String clientIdStr = semTable.getSemTableRow(i).getSemTableValue(clientId).getValue();
            clientIdList.add(clientIdStr);
        }
        int total = SemClientHandler.getCountByGroupId(groupId, policyMode);
        int start = 0;
        int bnum = total / 5000 + (total % 5000 == 0 ? 0 : 1);
        for (int i = 0; i < bnum; ++i) {
            int count = i == bnum - 1 ? total - i * 5000 : 5000;
            ArrayList<ClientObject> clientObjectList = SemClientHandler.getListByGroupId(groupId, policyMode, start, count, null);
            int n = clientObjectList.size();
            for (int j = 0; j < n; ++j) {
                ClientObject sc = (ClientObject)clientObjectList.get(j);
                if (!clientIdList.contains(sc.getClientId())) continue;
                myMap.put(sc.getClientId(), sc);
            }
            start += count;
            if (myMap.size() == rows) break;
        }
        ConsoleLogger.log("SemComputerHandler>>getClientObjectHashMap>>getListByGroupId>>" + counter.toString());
        if (myMap.size() != rows) {
            ConsoleLogger.log("SemComputerHandler.getClientObjectHashMap required = " + rows + ", mapvalue=" + myMap.size());
        }
        return myMap;
    }

    private static final HashMap<String, ClientObject> getClientObjectHashMap(int clientId, SemTable semTable) throws ConsoleException {
        TimeCounter counter = new TimeCounter();
        int rows = semTable == null ? 0 : semTable.getSemTableRowCount();
        HashMap<String, ClientObject> myMap = new HashMap<String, ClientObject>(rows);
        ArrayList<String> clientIdList = new ArrayList<String>(rows);
        for (int i = 0; i < rows; ++i) {
            String clientIdStr = semTable.getSemTableRow(i).getSemTableValue(clientId).getValue();
            clientIdList.add(clientIdStr);
        }
        int start = 0;
        int bnum = rows / 200 + (rows % 200 == 0 ? 0 : 1);
        for (int i = 0; i < bnum; ++i) {
            int count = i == bnum - 1 ? rows - i * 200 : 200;
            List<ClientObject> clientObjectList = SemClientHandler.getClientsByIds(clientIdList.subList(start, start + count), 0, count);
            int n = clientObjectList.size();
            for (int j = 0; j < n; ++j) {
                ClientObject sc = clientObjectList.get(j);
                myMap.put(sc.getClientId(), sc);
            }
            start += count;
        }
        ConsoleLogger.log("SemComputerHandler>>getClientObjectHashMap>>getClientsByIds>>" + counter.toString());
        return myMap;
    }

    public static final Collection<ClientObject> getComputerList(String groupId, int nStart, int nCount, String sortColKey, int viewIndex, int mode, boolean isAscending, RpcData rpc) throws ConsoleException {
        try {
            HashMap<String, ClientObject> myMap;
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(mode));
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"GROUP_ID", (String)groupId);
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN", (String)String.valueOf(isAscending));
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER_1", (String)String.valueOf(viewIndex));
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"STRING", (String)String.valueOf(sortColKey));
            int rowsToGet = nStart + nCount + nCount;
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER_3", (String)String.valueOf(rowsToGet));
            SemTable semtable = viewIndex == 4 ? SemComputerHandler.prepareTableRows(602, rpc, nStart, nCount) : (viewIndex == 2 ? SemComputerHandler.prepareTableRows(603, rpc, nStart, nCount) : (viewIndex == 3 ? SemComputerHandler.prepareTableRows(604, rpc, nStart, nCount) : (viewIndex == 1 ? SemComputerHandler.prepareTableRows(1100, rpc, nStart, nCount) : (LIC_OBJ.isSEPSBProduct() ? SemComputerHandler.prepareTableRows(809, rpc, nStart, nCount) : SemComputerHandler.prepareTableRows(810, rpc, nStart, nCount)))));
            int rows = semtable.getSemTableRowCount();
            LinkedHashMap<String, ClientObject> v = new LinkedHashMap<String, ClientObject>(rows);
            if (viewIndex == 4) {
                myMap = SemComputerHandler.getClientObjectHashMap(11, semtable, mode, groupId);
                for (int i = 0; i < rows; ++i) {
                    String i18nOSKey;
                    String osEnglish;
                    long rOSType;
                    String rOSTypeStr;
                    ClientObject co;
                    SemTableRow row = semtable.getSemTableRow(i);
                    ClientObject clo = myMap.get(row.getSemTableValue(11).getValue());
                    SemClient myClient = null;
                    if (clo != null) {
                        myClient = clo.getSemClient();
                    }
                    if (clo != null && clo.getPolicyMode() == 0) {
                        co = new ClientSystemUserObject(myClient);
                        co.setComputerName(row.getSemTableValue(0).getValue());
                        ((ClientSystemUserObject)co).setComputerIp(row.getSemTableValue(3).getValue());
                        co.setUserName(row.getSemTableValue(2).getValue());
                        rOSTypeStr = row.getSemTableValue(4).getValue();
                        rOSType = Utility.parseLong((String)rOSTypeStr, (long)0L);
                        if (rOSType > 0L) {
                            ((ClientSystemUserObject)co).getAgent().setOptROsType(Long.valueOf(rOSType));
                        }
                        ((ClientSystemUserObject)co).setServicePack(row.getSemTableValue(5).getValue());
                        ((ClientSystemUserObject)co).setFreeMemory(row.getSemTableValue(6).getValue());
                        ((ClientSystemUserObject)co).setFreeDisk(row.getSemTableValue(7).getValue());
                        ((ClientSystemUserObject)co).setDiskTotal(row.getSemTableValue(8).getValue());
                        co.setGroupId(groupId);
                        ((ClientSystemUserObject)co).setAgentGroupName(row.getSemTableValue(9).getValue());
                        co.setComputerId(row.getSemTableValue(10).getValue());
                        co.setClientId(row.getSemTableValue(11).getValue());
                        co.setComputerDomainName(row.getSemTableValue(12).getValue());
                        co.setUserDomainName(row.getSemTableValue(13).getValue());
                        ((ClientSystemUserObject)co).setAgentDomainId(Manager.getCurrentDomainId());
                        ((ClientSystemUserObject)co).getAgent().setTimeStamp(Long.valueOf(Utility.getNumberString((String)row.getSemTableValue(14).getValue())));
                        myClient.setUSN(Long.valueOf(Utility.getNumberString((String)row.getSemTableValue(15).getValue())));
                        myClient.setDeleted(Integer.valueOf(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(16).getValue()))));
                        myClient.setOptComputerId(row.getSemTableValue(10).getValue());
                        myClient.setClientId(row.getSemTableValue(11).getValue());
                        myClient.setOptGroupId(groupId);
                        co.setOnlineStatusEx(clo.getOnlineStatusEx());
                        co.setDeployStatus(Utility.parseInt((String)row.getSemTableValue(23).getValue(), (int)0));
                        co.setDeployMessage(row.getSemTableValue(24).getValue());
                        co.setDeployTargetVersion(row.getSemTableValue(25).getValue());
                        co.setDeployRunningVersion(row.getSemTableValue(26).getValue());
                        co.setDeployTimestamp(Utility.parseLong((String)row.getSemTableValue(27).getValue(), (long)0L));
                        osEnglish = row.getSemTableValue(28).getValue();
                        i18nOSKey = row.getSemTableValue(30).getValue();
                        co.setOperatingSystemObject(new OperatingSystemObject(i18nOSKey, osEnglish));
                        ((ClientSystemUserObject)co).setAgentVersionMajor(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(29).getValue())));
                        co.setPowerEraserPendingAlertCount(SemComputerHandler.getPowerEraserPendingAlerts(semtable, row));
                        co.setInfected(SemComputerHandler.getInfected(semtable, row));
                        co.setInstallType(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(38).getValue())));
                        v.put(clo.getClientId(), co);
                        continue;
                    }
                    if (clo == null || clo.getPolicyMode() != 1) continue;
                    co = new ClientSystemObject(clo.getSemClient());
                    co.setComputerName(row.getSemTableValue(0).getValue());
                    ((ClientSystemObject)co).setComputerIp(row.getSemTableValue(3).getValue());
                    co.setUserName(row.getSemTableValue(2).getValue());
                    rOSTypeStr = row.getSemTableValue(4).getValue();
                    rOSType = Utility.parseLong((String)rOSTypeStr, (long)0L);
                    if (rOSType > 0L) {
                        ((ClientSystemObject)co).getAgent().setOptROsType(Long.valueOf(rOSType));
                    }
                    ((ClientSystemObject)co).setServicePack(row.getSemTableValue(5).getValue());
                    ((ClientSystemObject)co).setFreeMemory(row.getSemTableValue(6).getValue());
                    ((ClientSystemObject)co).setFreeDisk(row.getSemTableValue(7).getValue());
                    ((ClientSystemObject)co).setDiskTotal(row.getSemTableValue(8).getValue());
                    co.setGroupId(groupId);
                    ((ClientSystemObject)co).setAgentGroupName(row.getSemTableValue(9).getValue());
                    co.setComputerId(row.getSemTableValue(10).getValue());
                    co.setClientId(row.getSemTableValue(11).getValue());
                    co.setComputerDomainName(row.getSemTableValue(12).getValue());
                    co.setUserDomainName(row.getSemTableValue(13).getValue());
                    ((ClientSystemObject)co).setAgentDomainId(Manager.getCurrentDomainId());
                    co.setClientPlatform(Integer.parseInt(row.getSemTableValue(22).getValue()));
                    ((ClientSystemObject)co).getAgent().setTimeStamp(Long.valueOf(row.getSemTableValue(14).getValue()));
                    myClient.setUSN(Long.valueOf(row.getSemTableValue(15).getValue()));
                    co.getSemClient().setDeleted(Integer.valueOf(row.getSemTableValue(16).getValue()));
                    myClient.setOptComputerId(row.getSemTableValue(10).getValue());
                    myClient.setClientId(row.getSemTableValue(11).getValue());
                    myClient.setOptGroupId(groupId);
                    co.setOnlineStatusEx(clo.getOnlineStatusEx());
                    co.setDeployStatus(Utility.parseInt((String)row.getSemTableValue(23).getValue(), (int)0));
                    co.setDeployMessage(row.getSemTableValue(24).getValue());
                    co.setDeployTargetVersion(row.getSemTableValue(25).getValue());
                    co.setDeployRunningVersion(row.getSemTableValue(26).getValue());
                    co.setDeployTimestamp(Utility.parseLong((String)row.getSemTableValue(27).getValue(), (long)0L));
                    osEnglish = row.getSemTableValue(28).getValue();
                    i18nOSKey = row.getSemTableValue(30).getValue();
                    co.setOperatingSystemObject(new OperatingSystemObject(i18nOSKey, osEnglish));
                    ((ClientSystemObject)co).setAgentVersionMajor(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(29).getValue())));
                    co.setPowerEraserPendingAlertCount(SemComputerHandler.getPowerEraserPendingAlerts(semtable, row));
                    co.setInfected(SemComputerHandler.getInfected(semtable, row));
                    co.setInstallType(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(38).getValue())));
                    v.put(clo.getClientId(), co);
                }
            } else if (viewIndex == 2) {
                SemComputerHandler.clientViewProtection(groupId, mode, semtable, rows, v);
            } else if (viewIndex == 3) {
                myMap = SemComputerHandler.getClientObjectHashMap(10, semtable, mode, groupId);
                for (int i = 0; i < rows; ++i) {
                    ClientObject co;
                    SemTableRow row = semtable.getSemTableRow(i);
                    ClientObject clo = myMap.get(row.getSemTableValue(10).getValue());
                    SemClient myClient = null;
                    if (clo != null) {
                        myClient = clo.getSemClient();
                    }
                    if (clo != null && clo.getPolicyMode() == 0) {
                        co = new ClientNetworkInformationUserObject(clo.getSemClient());
                        co.setComputerName(row.getSemTableValue(0).getValue());
                        co.setUserName(row.getSemTableValue(2).getValue());
                        ((ClientNetworkInformationUserObject)co).setComputerIp(row.getSemTableValue(3).getValue());
                        ((ClientNetworkInformationUserObject)co).setDnsServer(row.getSemTableValue(4).getValue());
                        ((ClientNetworkInformationUserObject)co).setWinsServer(row.getSemTableValue(5).getValue());
                        ((ClientNetworkInformationUserObject)co).setMacAddress(row.getSemTableValue(6).getValue());
                        ((ClientNetworkInformationUserObject)co).setGateways(row.getSemTableValue(7).getValue());
                        co.setGroupId(groupId);
                        ((ClientNetworkInformationUserObject)co).setAgentGroupName(row.getSemTableValue(8).getValue());
                        co.setComputerId(row.getSemTableValue(9).getValue());
                        co.setClientId(row.getSemTableValue(10).getValue());
                        co.setComputerDomainName(row.getSemTableValue(11).getValue());
                        co.setUserDomainName(row.getSemTableValue(12).getValue());
                        ((ClientNetworkInformationUserObject)co).setAgentDomainId(Manager.getCurrentDomainId());
                        ((ClientNetworkInformationUserObject)co).setDnsServer2(row.getSemTableValue(19).getValue());
                        ((ClientNetworkInformationUserObject)co).setWinsServer2(row.getSemTableValue(20).getValue());
                        ((ClientNetworkInformationUserObject)co).getAgent().setTimeStamp(Long.valueOf(row.getSemTableValue(13).getValue()));
                        myClient.setUSN(Long.valueOf(row.getSemTableValue(14).getValue()));
                        myClient.setDeleted(Integer.valueOf(row.getSemTableValue(15).getValue()));
                        myClient.setOptComputerId(row.getSemTableValue(9).getValue());
                        myClient.setClientId(row.getSemTableValue(10).getValue());
                        myClient.setOptGroupId(groupId);
                        co.setDeployStatus(Utility.parseInt((String)row.getSemTableValue(23).getValue(), (int)0));
                        co.setDeployMessage(row.getSemTableValue(24).getValue());
                        co.setDeployTargetVersion(row.getSemTableValue(25).getValue());
                        co.setDeployRunningVersion(row.getSemTableValue(26).getValue());
                        co.setDeployTimestamp(Utility.parseLong((String)row.getSemTableValue(27).getValue(), (long)0L));
                        ((ClientNetworkInformationUserObject)co).setAgentVersionMajor(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(29).getValue())));
                        co.setOnlineStatusEx(clo.getOnlineStatusEx());
                        co.setPowerEraserPendingAlertCount(SemComputerHandler.getPowerEraserPendingAlerts(semtable, row));
                        co.setInfected(SemComputerHandler.getInfected(semtable, row));
                        co.setInstallType(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(38).getValue())));
                        v.put(clo.getClientId(), co);
                        continue;
                    }
                    if (clo == null || clo.getPolicyMode() != 1) continue;
                    co = new ClientNetworkInformationObject(myClient);
                    co.setComputerName(row.getSemTableValue(0).getValue());
                    ((ClientNetworkInformationObject)co).setComputerIp(row.getSemTableValue(3).getValue());
                    co.setUserName(row.getSemTableValue(2).getValue());
                    ((ClientNetworkInformationObject)co).setDnsServer(row.getSemTableValue(4).getValue());
                    ((ClientNetworkInformationObject)co).setWinsServer(row.getSemTableValue(5).getValue());
                    ((ClientNetworkInformationObject)co).setMacAddress(row.getSemTableValue(6).getValue());
                    ((ClientNetworkInformationObject)co).setGateways(row.getSemTableValue(7).getValue());
                    co.setGroupId(groupId);
                    ((ClientNetworkInformationObject)co).setAgentGroupName(row.getSemTableValue(8).getValue());
                    co.setComputerId(row.getSemTableValue(9).getValue());
                    co.setClientId(row.getSemTableValue(10).getValue());
                    co.setComputerDomainName(row.getSemTableValue(11).getValue());
                    co.setUserDomainName(row.getSemTableValue(12).getValue());
                    ((ClientNetworkInformationObject)co).setAgentDomainId(Manager.getCurrentDomainId());
                    ((ClientNetworkInformationObject)co).setDnsServer2(row.getSemTableValue(19).getValue());
                    ((ClientNetworkInformationObject)co).setWinsServer2(row.getSemTableValue(20).getValue());
                    co.setClientPlatform(Integer.parseInt(row.getSemTableValue(28).getValue()));
                    ((ClientNetworkInformationObject)co).getAgent().setTimeStamp(Long.valueOf(row.getSemTableValue(13).getValue()));
                    myClient.setUSN(Long.valueOf(row.getSemTableValue(14).getValue()));
                    myClient.setDeleted(Integer.valueOf(row.getSemTableValue(15).getValue()));
                    myClient.setOptComputerId(row.getSemTableValue(9).getValue());
                    myClient.setClientId(row.getSemTableValue(10).getValue());
                    myClient.setOptGroupId(groupId);
                    co.setOnlineStatusEx(clo.getOnlineStatusEx());
                    co.setDeployStatus(Utility.parseInt((String)row.getSemTableValue(23).getValue(), (int)0));
                    co.setDeployMessage(row.getSemTableValue(24).getValue());
                    co.setDeployTargetVersion(row.getSemTableValue(25).getValue());
                    co.setDeployRunningVersion(row.getSemTableValue(26).getValue());
                    co.setDeployTimestamp(Utility.parseLong((String)row.getSemTableValue(27).getValue(), (long)0L));
                    ((ClientNetworkInformationObject)co).setAgentVersionMajor(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(29).getValue())));
                    co.setPowerEraserPendingAlertCount(SemComputerHandler.getPowerEraserPendingAlerts(semtable, row));
                    co.setInfected(SemComputerHandler.getInfected(semtable, row));
                    co.setInstallType(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(38).getValue())));
                    v.put(clo.getClientId(), co);
                }
            } else if (viewIndex == 1) {
                myMap = SemComputerHandler.getClientObjectHashMap(9, semtable, mode, groupId);
                for (int i = 0; i < rows; ++i) {
                    long rOSType;
                    String agentVersion;
                    ClientObject co;
                    SemTableRow row = semtable.getSemTableRow(i);
                    ClientObject clo = null;
                    clo = myMap.get(row.getSemTableValue(9).getValue());
                    SemClient myClient = null;
                    if (clo != null) {
                        myClient = clo.getSemClient();
                    }
                    if (clo != null && clo.getPolicyMode() == 0) {
                        co = new ClientStatusUserObject(myClient);
                        co.setComputerName(row.getSemTableValue(0).getValue());
                        ((ClientStatusUserObject)co).setComputerIp(row.getSemTableValue(2).getValue());
                        co.setUserName(row.getSemTableValue(1).getValue());
                        agentVersion = row.getSemTableValue(3).getValue();
                        if (agentVersion != null && agentVersion.trim().isEmpty()) {
                            agentVersion = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "SemComputerHandler.ClientVersionUnavailable");
                        }
                        ((ClientStatusUserObject)co).setAgentVersion(agentVersion);
                        ((ClientStatusUserObject)co).setAgentLastCheckin(Long.parseLong(Utility.getNumberString((String)row.getSemTableValue(4).getValue())));
                        ((ClientStatusUserObject)co).setRebootRequired(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(5).getValue())));
                        ((ClientStatusUserObject)co).setPolicySerialNumber(row.getSemTableValue(6).getValue());
                        co.setGroupId(groupId);
                        ((ClientStatusUserObject)co).setAgentGroupName(row.getSemTableValue(7).getValue());
                        co.setComputerId(row.getSemTableValue(8).getValue());
                        co.setClientId(row.getSemTableValue(9).getValue());
                        co.setComputerDomainName(row.getSemTableValue(10).getValue());
                        co.setUserDomainName(row.getSemTableValue(11).getValue());
                        ((ClientStatusUserObject)co).setAgentDomainId(Manager.getCurrentDomainId());
                        myClient.setOptComputerId(row.getSemTableValue(8).getValue());
                        myClient.setClientId(row.getSemTableValue(9).getValue());
                        myClient.setOptGroupId(groupId);
                        ((ClientStatusUserObject)co).getAgent().setTimeStamp(Long.valueOf(Utility.getNumberString((String)row.getSemTableValue(13).getValue())));
                        myClient.setUSN(Long.valueOf(Utility.getNumberString((String)row.getSemTableValue(14).getValue())));
                        myClient.setDeleted(Integer.valueOf(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(15).getValue()))));
                        co.setOnlineStatusEx(clo.getOnlineStatusEx());
                        ((ClientStatusUserObject)co).setRebootReason(SemComputerHandler.getFormattedRebootReason(row.getSemTableValue(26).getValue()));
                        co.setDeployStatus(Utility.parseInt((String)row.getSemTableValue(27).getValue(), (int)0));
                        co.setDeployMessage(row.getSemTableValue(28).getValue());
                        co.setDeployTargetVersion(row.getSemTableValue(29).getValue());
                        co.setDeployRunningVersion(row.getSemTableValue(30).getValue());
                        co.setDeployTimestamp(Utility.parseLong((String)row.getSemTableValue(31).getValue(), (long)0L));
                        rOSType = Utility.parseLong((String)row.getSemTableValue(32).getValue(), (long)0L);
                        if (rOSType > 0L) {
                            ((ClientStatusUserObject)co).getAgent().setOptROsType(Long.valueOf(rOSType));
                        }
                        ((ClientStatusUserObject)co).setClientOperationSystem(row.getSemTableValue(33).getValue());
                        ((ClientStatusUserObject)co).setClientOSServicePack(row.getSemTableValue(34).getValue());
                        ((ClientStatusUserObject)co).setAgentVersionMajor(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(35).getValue())));
                        co.setPowerEraserPendingAlertCount(SemComputerHandler.getPowerEraserPendingAlerts(semtable, row));
                        co.setInfected(SemComputerHandler.getInfected(semtable, row));
                        co.setInstallType(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(42).getValue())));
                        v.put(clo.getClientId(), co);
                        continue;
                    }
                    if (clo == null || clo.getPolicyMode() != 1) continue;
                    co = new ClientStatusObject(myClient);
                    co.setComputerName(row.getSemTableValue(0).getValue());
                    ((ClientStatusObject)co).setComputerIp(row.getSemTableValue(2).getValue());
                    co.setUserName(row.getSemTableValue(1).getValue());
                    agentVersion = row.getSemTableValue(3).getValue();
                    if (agentVersion != null && agentVersion.trim().isEmpty()) {
                        agentVersion = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "SemComputerHandler.ClientVersionUnavailable");
                    }
                    ((ClientStatusObject)co).setAgentVersion(agentVersion);
                    ((ClientStatusObject)co).setAgentLastCheckin(Long.parseLong(Utility.getNumberString((String)row.getSemTableValue(4).getValue())));
                    ((ClientStatusObject)co).setRebootRequired(Utility.parseInt((String)row.getSemTableValue(5).getValue(), (int)0));
                    ((ClientStatusObject)co).setPolicySerialNumber(row.getSemTableValue(6).getValue());
                    co.setGroupId(groupId);
                    ((ClientStatusObject)co).setAgentGroupName(row.getSemTableValue(7).getValue());
                    co.setComputerId(row.getSemTableValue(8).getValue());
                    co.setClientId(row.getSemTableValue(9).getValue());
                    co.setComputerDomainName(row.getSemTableValue(10).getValue());
                    co.setUserDomainName(row.getSemTableValue(11).getValue());
                    ((ClientStatusObject)co).setAgentDomainId(Manager.getCurrentDomainId());
                    myClient.setOptComputerId(row.getSemTableValue(8).getValue());
                    myClient.setOptGroupId(groupId);
                    co.setClientPlatform(Integer.parseInt(row.getSemTableValue(25).getValue()));
                    ((ClientStatusObject)co).getAgent().setTimeStamp(Long.valueOf(Utility.getNumberString((String)row.getSemTableValue(13).getValue())));
                    myClient.setUSN(Long.valueOf(Utility.getNumberString((String)row.getSemTableValue(14).getValue())));
                    myClient.setDeleted(Integer.valueOf(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(15).getValue()))));
                    co.setOnlineStatusEx(clo.getOnlineStatusEx());
                    ((ClientStatusObject)co).setRebootReason(SemComputerHandler.getFormattedRebootReason(row.getSemTableValue(26).getValue()));
                    ((ClientStatusObject)co).setDeployStatus(Utility.parseInt((String)row.getSemTableValue(27).getValue(), (int)0));
                    co.setDeployMessage(row.getSemTableValue(28).getValue());
                    co.setDeployTargetVersion(row.getSemTableValue(29).getValue());
                    co.setDeployRunningVersion(row.getSemTableValue(30).getValue());
                    co.setDeployTimestamp(Utility.parseLong((String)row.getSemTableValue(31).getValue(), (long)0L));
                    rOSType = Utility.parseLong((String)row.getSemTableValue(32).getValue(), (long)0L);
                    if (rOSType > 0L) {
                        ((ClientStatusObject)co).getAgent().setOptROsType(Long.valueOf(rOSType));
                    }
                    ((ClientStatusObject)co).setClientOperationSystem(row.getSemTableValue(33).getValue());
                    ((ClientStatusObject)co).setClientOSServicePack(row.getSemTableValue(34).getValue());
                    ((ClientStatusObject)co).setAgentVersionMajor(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(35).getValue())));
                    co.setPowerEraserPendingAlertCount(SemComputerHandler.getPowerEraserPendingAlerts(semtable, row));
                    co.setInfected(SemComputerHandler.getInfected(semtable, row));
                    co.setInstallType(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(42).getValue())));
                    v.put(clo.getClientId(), co);
                }
            } else {
                myMap = SemComputerHandler.getClientObjectHashMap(13, semtable, mode, groupId);
                for (int i = 0; i < rows; ++i) {
                    String tempStr;
                    ClientObject co;
                    SemTableRow row = semtable.getSemTableRow(i);
                    ClientObject clo = myMap.get(row.getSemTableValue(13).getValue());
                    if (clo != null && clo.getPolicyMode() == 0) {
                        co = new ClientDefaultViewUserObject(clo.getSemClient());
                        co.setComputerName(row.getSemTableValue(1).getValue());
                        co.setUserName(row.getSemTableValue(2).getValue());
                        tempStr = row.getSemTableValue(3).getValue();
                        ((ClientDefaultViewUserObject)co).setAgentLastCheckin(Long.parseLong(Utilities.isStrNullOrEmpty(tempStr) ? "0" : tempStr));
                        ((ClientDefaultViewUserObject)co).setVirusDefinition(row.getSemTableValue(4).getValue());
                        ((ClientDefaultViewUserObject)co).setPolicySerialNumber(row.getSemTableValue(5).getValue());
                        ((ClientDefaultViewUserObject)co).setLastScanTime(row.getSemTableValue(6).getValue());
                        tempStr = row.getSemTableValue(7).getValue();
                        ((ClientDefaultViewUserObject)co).setAVStatus(Integer.parseInt(Utilities.isStrNullOrEmpty(tempStr) ? "0" : tempStr));
                        tempStr = row.getSemTableValue(8).getValue();
                        ((ClientDefaultViewUserObject)co).setFirewallStatus(Integer.parseInt(Utilities.isStrNullOrEmpty(tempStr) ? "0" : tempStr));
                        tempStr = row.getSemTableValue(9).getValue();
                        ((ClientDefaultViewUserObject)co).setRebootRequired(Integer.parseInt(Utilities.isStrNullOrEmpty(tempStr) ? "0" : tempStr));
                        co.setOnlineStatusEx(clo.getOnlineStatusEx());
                        co.setClientId(row.getSemTableValue(13).getValue());
                        co.setGroupId(groupId);
                        co.setComputerId(row.getSemTableValue(19).getValue());
                        co.setComputerDomainName(row.getSemTableValue(18).getValue());
                        co.setUserDomainName(row.getSemTableValue(17).getValue());
                        ((ClientDefaultViewUserObject)co).getAgent().setTimeStamp(Long.valueOf(Utility.getNumberString((String)row.getSemTableValue(20).getValue())));
                        ((ClientDefaultViewUserObject)co).getAgent().setUSN(Long.valueOf(Utility.getNumberString((String)row.getSemTableValue(21).getValue())));
                        ((ClientDefaultViewUserObject)co).getAgent().setDeleted(Integer.valueOf(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(22).getValue()))));
                        ((ClientDefaultViewUserObject)co).setRebootReason(SemComputerHandler.getFormattedRebootReason(row.getSemTableValue(26).getValue()));
                        co.setDeployStatus(Utility.parseInt((String)row.getSemTableValue(27).getValue(), (int)0));
                        co.setDeployMessage(row.getSemTableValue(28).getValue());
                        co.setDeployTargetVersion(row.getSemTableValue(29).getValue());
                        co.setDeployRunningVersion(row.getSemTableValue(30).getValue());
                        co.setDeployTimestamp(Utility.parseLong((String)row.getSemTableValue(31).getValue(), (long)0L));
                        ((ClientDefaultViewUserObject)co).setAgentVersionMajor(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(32).getValue())));
                        co.setDescription(row.getSemTableValue(33).getValue());
                        co.setPowerEraserPendingAlertCount(SemComputerHandler.getPowerEraserPendingAlerts(semtable, row));
                        co.setInfected(SemComputerHandler.getInfected(semtable, row));
                        co.setInstallType(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(40).getValue())));
                        ((ClientDefaultViewUserObject)co).setLbStatus(Utility.parseInt((String)row.getSemTableValue(41).getValue(), (int)-1));
                        ((ClientDefaultViewUserObject)co).setAmlavDefinition(row.getSemTableValue(42).getValue());
                        v.put(clo.getClientId(), co);
                        continue;
                    }
                    if (clo == null || clo.getPolicyMode() != 1) continue;
                    co = new ClientDefaultViewObject(clo.getSemClient());
                    co.setComputerName(row.getSemTableValue(1).getValue());
                    co.setUserName(row.getSemTableValue(2).getValue());
                    tempStr = row.getSemTableValue(3).getValue();
                    ((ClientDefaultViewObject)co).setAgentLastCheckin(Long.parseLong(Utilities.isStrNullOrEmpty(tempStr) ? "0" : tempStr));
                    ((ClientDefaultViewObject)co).setVirusDefinition(row.getSemTableValue(4).getValue());
                    ((ClientDefaultViewObject)co).setPolicySerialNumber(row.getSemTableValue(5).getValue());
                    ((ClientDefaultViewObject)co).setLastScanTime(row.getSemTableValue(6).getValue());
                    tempStr = row.getSemTableValue(7).getValue();
                    ((ClientDefaultViewObject)co).setAVStatus(Integer.parseInt(Utilities.isStrNullOrEmpty(tempStr) ? "0" : tempStr));
                    tempStr = row.getSemTableValue(8).getValue();
                    ((ClientDefaultViewObject)co).setFirewallStatus(Integer.parseInt(Utilities.isStrNullOrEmpty(tempStr) ? "0" : tempStr));
                    tempStr = row.getSemTableValue(9).getValue();
                    ((ClientDefaultViewObject)co).setRebootRequired(Integer.parseInt(Utilities.isStrNullOrEmpty(tempStr) ? "0" : tempStr));
                    co.setClientPlatform(Utility.parseInt((String)row.getSemTableValue(25).getValue(), (int)0));
                    co.setOnlineStatusEx(clo.getOnlineStatusEx());
                    co.setClientId(row.getSemTableValue(13).getValue());
                    co.setGroupId(groupId);
                    co.setComputerId(row.getSemTableValue(19).getValue());
                    co.setUserDomainName(row.getSemTableValue(17).getValue());
                    co.setComputerDomainName(row.getSemTableValue(18).getValue());
                    ((ClientDefaultViewObject)co).setRebootReason(SemComputerHandler.getFormattedRebootReason(row.getSemTableValue(26).getValue()));
                    co.setDeployStatus(Utility.parseInt((String)row.getSemTableValue(27).getValue(), (int)0));
                    co.setDeployMessage(row.getSemTableValue(28).getValue());
                    co.setDeployTargetVersion(row.getSemTableValue(29).getValue());
                    co.setDeployRunningVersion(row.getSemTableValue(30).getValue());
                    co.setDeployTimestamp(Utility.parseLong((String)row.getSemTableValue(31).getValue(), (long)0L));
                    ((ClientDefaultViewObject)co).setAgentVersionMajor(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(32).getValue())));
                    co.setDescription(row.getSemTableValue(33).getValue());
                    co.setPowerEraserPendingAlertCount(SemComputerHandler.getPowerEraserPendingAlerts(semtable, row));
                    co.setInfected(SemComputerHandler.getInfected(semtable, row));
                    co.setInstallType(Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(40).getValue())));
                    ((ClientDefaultViewObject)co).setLbStatus(Utility.parseInt((String)row.getSemTableValue(41).getValue(), (int)-1));
                    ((ClientDefaultViewObject)co).setAmlavDefinition(row.getSemTableValue(42).getValue());
                    v.put(clo.getClientId(), co);
                }
            }
            Collection<ClientObject> vCollection = v.values();
            return vCollection;
        }
        catch (RuntimeException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }

    private static void clientViewProtection(String groupId, int mode, SemTable semtable, int rows, LinkedHashMap<String, ClientObject> v) throws ConsoleException {
        ArrayList<ProtectionView> listAgentObject = new ArrayList<ProtectionView>();
        HashMap<String, ClientObject> myMap = SemComputerHandler.getClientObjectHashMap(16, semtable, mode, groupId);
        for (int i = 0; i < rows; ++i) {
            SemTableRow row = semtable.getSemTableRow(i);
            ClientObject clo = myMap.get(row.getSemTableValue(16).getValue());
            ClientObject ct = null;
            if (clo == null) continue;
            ct = clo.getPolicyMode() == 0 ? new ClientTechnologyUserObject(clo.getSemClient()) : new ClientTechnologyObject(clo.getSemClient());
            ct.setObject(row, groupId, SemComputerHandler.getPowerEraserPendingAlerts(semtable, row), SemComputerHandler.getInfected(semtable, row), clo.getOnlineStatusEx());
            v.put(clo.getClientId(), ct);
            String agentId = ct.getAgent().getAgentId();
            if (agentId == null || agentId.isEmpty()) continue;
            listAgentObject.add(new ProtectionView(agentId, (ClientTechnology)((Object)ct)));
        }
        SemComputerHandler.setAgentContent(listAgentObject);
    }

    private static Integer getInfected(SemTable semtable, SemTableRow row) {
        Integer result = 0;
        int index = SemComputerHandler.getColumnIndexInSemTable(semtable, "INFECTED");
        if (index >= 0) {
            result = Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(index).getValue()));
        }
        return result;
    }

    private static Integer getPowerEraserPendingAlerts(SemTable semtable, SemTableRow row) {
        Integer result = 0;
        int index = SemComputerHandler.getColumnIndexInSemTable(semtable, "POWERERASER_PENDING_ALERTS");
        if (index >= 0) {
            result = Integer.parseInt(Utility.getNumberString((String)row.getSemTableValue(index).getValue()));
        }
        return result;
    }

    private static int getColumnIndexInSemTable(SemTable semtable, String columnName) {
        Vector headeList = semtable.getOptSemTableHeader().getSemTableColumnHeader();
        for (int i = 0; i < headeList.size(); ++i) {
            SemTableColumnHeader header = (SemTableColumnHeader)headeList.get(i);
            if (!columnName.equalsIgnoreCase(header.getColumnName())) continue;
            return i;
        }
        return -1;
    }

    private static SemTable prepareTableRows(int sqlType, RpcData rpc, int nStart, int nCount) throws ConsoleException {
        if (nStart < 0 || nCount <= 0) {
            return new SemTable();
        }
        TimeCounter counter = new TimeCounter();
        SemTable semtable = new SemTable();
        int start = nStart;
        int bnum = nCount / 5000 + (nCount % 5000 == 0 ? 0 : 1);
        for (int i = 0; i < bnum; ++i) {
            int count = i == bnum - 1 ? nCount - i * 5000 : 5000;
            SemTable table = GUIManager.getSemTable(sqlType, rpc, start, count);
            int rows = 0;
            if (table != null) {
                rows = table.getSemTableRowCount();
                semtable.setOptSemTableHeader(table.getOptSemTableHeader());
                for (int j = 0; j < rows; ++j) {
                    semtable.addSemTableRow(table.getSemTableRow(j));
                }
            }
            if (rows < 5000) break;
            start += count;
        }
        ConsoleLogger.log("SemComputerHandler>>prepareTableRows>>" + counter.toString());
        return semtable;
    }

    public static boolean retrieveGUPStatusByComputerId(String computerId) throws ConsoleException {
        if (computerId == null || computerId.trim().length() < 1) {
            return false;
        }
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)computerId);
        try {
            SemTable aTable = GUIManager.getSemTable(301, rpc, 0, 1);
            return aTable.getSemTableRowCount() >= 1;
        }
        catch (ConsoleException ex) {
            if (ex.getErrorCode() != 302645248) {
                throw ex;
            }
            return false;
        }
    }

    public static ArrayList<ClientObject> findComputer(int sqlType, RpcData rpc, int nStart, int nCount) throws ConsoleException {
        return SemClientHandler.findClients(sqlType, rpc, 1, nStart, nCount);
    }

    public static ArrayList<ClientObject> findComputerCompositeInfo(RpcData rpc, int nStart, int nCount, boolean isForExport) throws ConsoleException {
        return SemClientAgentHandler.findClients(rpc, 1, nStart, nCount, isForExport);
    }

    public static int findComputerCount(RpcData rpc) throws ConsoleException {
        return SemClientHandler.getCountForFindClients(rpc, 1);
    }

    public static String getGroupFromComputer(String computerName, String domainName, int pinned, boolean group_fullpath) throws ConsoleException {
        return SemClientHandler.getGroupFromClient(computerName, domainName, 1, pinned, group_fullpath);
    }

    public static String getGroupFromComputerEx(String computerName, String domainName, String hardwareKey, int pinned, boolean group_fullpath, int groupISOU) throws ConsoleException {
        return SemClientHandler.getGroupFromComputerEx(computerName, domainName, hardwareKey, pinned, group_fullpath, groupISOU);
    }

    private static String getRes(String key) {
        return SemComputerHandler.getRes("SemComputerHandler.", key);
    }

    private static String getRes(String component, String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", component + key);
    }

    private static String getComponentName(String component_type) {
        String returnVal = SemComputerHandler.getRes("COMPONENT_" + component_type.toUpperCase());
        return returnVal;
    }

    public static final String getFormattedRebootReason(String dbRebootReason) {
        if (dbRebootReason == null || "".equals(dbRebootReason)) {
            return "";
        }
        MessageFormat form = new MessageFormat(SemComputerHandler.getRes("FORMAT_REBOOT_REASON"));
        StringBuffer formattedReason = new StringBuffer(";");
        StringTokenizer st = new StringTokenizer(dbRebootReason, ";");
        while (st.hasMoreElements()) {
            String aReason = st.nextToken();
            if ("".equals(aReason.trim())) continue;
            StringTokenizer st2 = new StringTokenizer(aReason, "=");
            String numberOfAReason = st2.nextToken();
            String arg0 = SemComputerHandler.getComponentName(numberOfAReason);
            String arg1 = SemComputerHandler.getRes("DBDATA_REBOOT_REASON_" + st2.nextToken());
            Object[] args = new Object[]{arg0, arg1};
            formattedReason.append(" " + form.format(args));
        }
        return formattedReason.toString();
    }

    public static final String getSortOrder(int viewIndex, int column) {
        String sortorder = "INVALID_SORT";
        if (viewIndex == 4) {
            switch (column) {
                case 0: {
                    sortorder = " FLEXIBLE_COL_2 ";
                    break;
                }
                case 1: {
                    sortorder = " SA.STATUS ";
                    break;
                }
                case 2: {
                    sortorder = " FLEXIBLE_COL_1 ";
                    break;
                }
                case 3: {
                    sortorder = " I.IP_ADDR1 ";
                    break;
                }
                case 4: {
                    sortorder = " I.OPERATION_SYSTEM ";
                    break;
                }
                case 5: {
                    sortorder = " I.SERVICE_PACK ";
                    break;
                }
                case 6: {
                    sortorder = " SA.FREE_MEM ";
                    break;
                }
                case 7: {
                    sortorder = " SA.FREE_DISK ";
                    break;
                }
                case 8: {
                    sortorder = " I.DISK_TOTAL ";
                    break;
                }
                default: {
                    sortorder = " FLEXIBLE_COL_2 ";
                    break;
                }
            }
        } else if (viewIndex == 2) {
            switch (column) {
                case 0: {
                    sortorder = " FLEXIBLE_COL_2 ";
                    break;
                }
                case 1: {
                    sortorder = " SA.STATUS ";
                    break;
                }
                case 2: {
                    sortorder = " FLEXIBLE_COL_1 ";
                    break;
                }
                case 3: {
                    sortorder = " I.IP_ADDR1 ";
                    break;
                }
                case 4: {
                    sortorder = " SA.LAST_SCAN_TIME ";
                    break;
                }
                case 5: {
                    sortorder = " SA.AP_ONOFF ";
                    break;
                }
                case 6: {
                    sortorder = " SA.FIREWALL_ONOFF ";
                    break;
                }
                case 7: {
                    sortorder = " VIRUS_DEF ";
                    break;
                }
                case 8: {
                    sortorder = " SA.DA_ONOFF ";
                    break;
                }
                case 9: {
                    sortorder = " SA.CIDS_DRV_ONOFF ";
                    break;
                }
                case 10: {
                    sortorder = " SA.CIDS_BROWSER_IE_ONOFF ";
                    break;
                }
                case 11: {
                    sortorder = " SA.AC_ONOFF ";
                    break;
                }
                case 12: {
                    sortorder = " SA.DC_ONOFF ";
                    break;
                }
                default: {
                    sortorder = " FLEXIBLE_COL_2 ";
                    break;
                }
            }
        } else if (viewIndex == 1) {
            switch (column) {
                case 0: {
                    sortorder = " FLEXIBLE_COL_2 ";
                    break;
                }
                case 1: {
                    sortorder = " SA.STATUS ";
                    break;
                }
                case 2: {
                    sortorder = " FLEXIBLE_COL_1 ";
                    break;
                }
                case 3: {
                    sortorder = " I.IP_ADDR1 ";
                    break;
                }
                case 4: {
                    sortorder = " SA.AGENT_VERSION ";
                    break;
                }
                case 5: {
                    sortorder = " SA.LAST_UPDATE_TIME ";
                    break;
                }
                case 6: {
                    sortorder = " SA.REBOOT_REQUIRED ";
                    break;
                }
                case 7: {
                    sortorder = " SA.PROFILE_SERIAL_NO ";
                    break;
                }
                default: {
                    sortorder = " FLEXIBLE_COL_2 ";
                    break;
                }
            }
        } else if (viewIndex == 3) {
            switch (column) {
                case 0: {
                    sortorder = " FLEXIBLE_COL_2 ";
                    break;
                }
                case 1: {
                    sortorder = " SA.STATUS ";
                    break;
                }
                case 2: {
                    sortorder = " FLEXIBLE_COL_1 ";
                    break;
                }
                case 3: {
                    sortorder = " SL.USER_NAME ";
                    break;
                }
                case 4: {
                    sortorder = " I.DNS_SERVER1 ";
                    break;
                }
                case 5: {
                    sortorder = " I.WINS_SERVER1 ";
                    break;
                }
                case 6: {
                    sortorder = " I.MAC_ADDR1 ";
                    break;
                }
                case 7: {
                    sortorder = " I.GATEWAY1 ";
                    break;
                }
                default: {
                    sortorder = " FLEXIBLE_COL_2 ";
                    break;
                }
            }
        } else {
            switch (column) {
                case 0: {
                    sortorder = " FLEXIBLE_COL_2 ";
                    break;
                }
                case 1: {
                    sortorder = " ONLINE_STATUS ";
                    break;
                }
                case 2: {
                    sortorder = " FLEXIBLE_COL_1 ";
                    break;
                }
                case 3: {
                    sortorder = " SA.LAST_UPDATE_TIME ";
                    break;
                }
                case 4: {
                    sortorder = " VIRUS_DEF ";
                    break;
                }
                case 5: {
                    sortorder = " SA.PROFILE_SERIAL_NO ";
                    break;
                }
                case 6: {
                    sortorder = " SA.LAST_SCAN_TIME ";
                    break;
                }
                case 7: {
                    sortorder = " SA.AP_ONOFF ";
                    break;
                }
                case 8: {
                    sortorder = " SA.FIREWALL_ONOFF ";
                    break;
                }
                case 9: {
                    sortorder = " SA.REBOOT_REQUIRED ";
                    break;
                }
                default: {
                    sortorder = " SA.STATUS ";
                }
            }
        }
        return sortorder;
    }

    private static SemTable getAgentContent(List<String> agentIds) throws ConsoleException {
        if (agentIds == null || agentIds.size() < 1) {
            return new SemTable();
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < agentIds.size(); ++i) {
            buf.append("," + agentIds.get(i));
        }
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID_LIST", (String)buf.substring(1));
        return GUIManager.getSemTable(606, rpc, 0, -1, true);
    }

    private static void setAgentContent(List<ProtectionView> listAgentObject) throws ConsoleException {
        ArrayList<String> agentIds = new ArrayList<String>();
        ListIterator<ProtectionView> agentIterator = listAgentObject.listIterator();
        while (agentIterator.hasNext()) {
            agentIds.add(agentIterator.next().getAgentId());
        }
        int size = listAgentObject.size();
        int start = 0;
        int bnum = size / 200 + (size % 200 == 0 ? 0 : 1);
        for (int i = 0; i < bnum; ++i) {
            int count = i == bnum - 1 ? size - i * 200 : 200;
            SemTable agentContent = SemComputerHandler.getAgentContent(agentIds.subList(start, start + count));
            int rowCount = agentContent.getSemTableRowCount();
            for (int j = 0; j < rowCount; ++j) {
                SemTableRow row = agentContent.getSemTableRow(j);
                String agentId = row.getSemTableValue(0).getValue();
                String patternType = row.getSemTableValue(1).getValue();
                String version = row.getSemTableValue(2).getValue();
                for (int k = 0; k < listAgentObject.size(); ++k) {
                    if (!agentId.equals(listAgentObject.get(k).getAgentId())) continue;
                    SemComputerHandler.updateEachAgent(listAgentObject.get(k).getCt(), row, patternType, version);
                }
            }
            start += count;
        }
    }

    private static void updateEachAgent(ClientTechnology co, SemTableRow row, String patternType, String version) {
        if (patternType.equals("DEUCE_SIG")) {
            String minorVersion;
            String fwOnOff = row.getSemTableValue(3).getValue();
            String cidsOnOff = row.getSemTableValue(4).getValue();
            String majorVersion = row.getSemTableValue(5).getValue();
            if (IdsUtility.isIPSInstalled((String)majorVersion, (String)(minorVersion = row.getSemTableValue(6).getValue()), (String)fwOnOff, (String)cidsOnOff)) {
                co.setIpsDef(version);
            }
        } else if (patternType.equals("SYKNAPPS_CAL")) {
            co.setSyKnCalDef(version);
        } else if (patternType.equals("SYKNAPPS_WHITELIST")) {
            co.setSyKnWlDef(version);
        } else if (patternType.equals("BASH_CONTENT")) {
            co.setBashDef(version);
        } else if (patternType.equals("SYMANTEC_WHITELIST")) {
            co.setMrCleanDef(version);
        } else if (patternType.equals("ADVML_AV")) {
            co.setAdvmlAVDef(version);
        } else if (patternType.equals("EDR_DEFS")) {
            co.setEDRDef(version);
        } else if (patternType.equals("WTR_DEFS")) {
            co.setWtrDef(version);
        } else if (patternType.equals("TDAD_CONTENT")) {
            co.setTdadDef(version);
        }
    }

    public static class ProtectionView {
        private String agentId;
        private ClientTechnology ct;

        public ProtectionView(String agentId, ClientTechnology ct) {
            this.agentId = agentId;
            this.ct = ct;
        }

        public String getAgentId() {
            return this.agentId;
        }

        public ClientTechnology getCt() {
            return this.ct;
        }
    }
}

