/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.rpc.NameValuePair;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.table.SemClient;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SemAgentHandler;
import com.sygate.scm.console.logicobject.AgentObject;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.ComputerObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.UserObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class SemClientHandler
extends AbstractHandler {
    public static final int IOS_INSTALL_FAILURE = 302469120;
    public static final int IOS_ERROR_NO_SPACE = 302469121;
    public static final int IOS_ERROR_LAUNCH_CONDITION = 302469122;
    public static final int IOS_ERROR_CONSUMER_FOUND = 302469123;
    public static final int IOS_ERROR_REBOOT_PENDING = 302469124;
    public static final int IOS_ERROR_LEGACY_EE = 302469125;
    public static final int IOS_ERROR_NON_ELEVATED = 302469126;
    public static final int IOS_ERROR_INCOMPATIBLE_OS = 302469127;
    public static final int IOS_INSTALL_REBOOT_PENDING = 302456833;
    public static final int IOS_ERROR_PACKAGE_CORRUPT = 302469129;
    public static final int IOS_ERROR_CLEANWIPE_FAILED = 302469130;
    public static final int IOS_CLEANWIPE_REBOOT = 302469131;
    public static final int IOS_ERROR_APPREMOVER_FAILED = 302469132;
    public static final int CLOUD_MANAGED_MARKER = 302469133;
    public static final int STATUS_OFFLINE = 0;
    public static final int STATUS_ONLINE = 1;
    public static final int STATUS_ONLINE_REMOTESERVER = 2;
    public static final int STATUS_ONLINE_REMOTESITE = 3;
    public static final int STATUS_OFFLINE_REMOTESITE = 4;

    private static ArrayList<ClientObject> get(String selectFields, String whereClause, int nStart, int nCount) throws ConsoleException {
        ArrayList<ClientObject> v;
        block5: {
            v = new ArrayList<ClientObject>();
            if (selectFields == null || selectFields.length() < 1) {
                return v;
            }
            try {
                RpcData rpc = new RpcData();
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)Manager.getCurrentDomainId());
                SemTable aTable = GUIManager.getRecord(901, rpc, "SemClient", nStart, nCount);
                for (int i = 0; i < aTable.getSemClientCount(); ++i) {
                    SemClient c = aTable.getSemClient(i);
                    if (c.getOptPolicyMode() == 0) {
                        v.add(new UserObject(c));
                    }
                    if (c.getOptPolicyMode() != 1) continue;
                    v.add(new ComputerObject(c));
                }
            }
            catch (ConsoleException ex) {
                if (ex.getErrorCode() == 302645248) break block5;
                throw ex;
            }
        }
        return v;
    }

    public static ArrayList<ClientObject> get(String whereClause, int nStart, int nCount) throws ConsoleException {
        String selectFields = "CLIENT_ID, DOMAIN_ID, GROUP_ID, GROUP_IS_OU, OU_GUID,POLICY_MODE,COMPUTER_ID, HARDWARE_KEY, COMPUTER_NAME, COMPUTER_DOMAIN_NAME, DESCRIPTION, USER_NAME,FULL_NAME, USER_DOMAIN_NAME, HASH, PIN_MARK, EXTRA_FEATURE, CREATOR, CREATION_TIME, USN, TIME_STAMP, DELETED";
        return SemClientHandler.get(selectFields, whereClause, nStart, nCount);
    }

    public static ArrayList<ClientObject> get(int sqlType, RpcData rpc, int nStart, int nCount) throws ConsoleException {
        ArrayList<ClientObject> v;
        block4: {
            v = new ArrayList<ClientObject>();
            try {
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)Manager.getCurrentDomainId());
                SemTable aTable = GUIManager.getRecord(sqlType, rpc, "SemClient", nStart, nCount);
                for (int i = 0; i < aTable.getSemClientCount(); ++i) {
                    SemClient c = aTable.getSemClient(i);
                    if (c.getOptPolicyMode() == 0) {
                        v.add(new UserObject(c));
                    }
                    if (c.getOptPolicyMode() != 1) continue;
                    v.add(new ComputerObject(c));
                }
            }
            catch (ConsoleException ex) {
                if (ex.getErrorCode() == 302645248) break block4;
                throw ex;
            }
        }
        return v;
    }

    private static ClientObject getClient(int sqlType, RpcData rpc) throws ConsoleException {
        ArrayList<ClientObject> v = SemClientHandler.get(sqlType, rpc, 0, 1);
        ClientObject client = null;
        if (v != null && v.size() > 0) {
            client = v.get(0);
        }
        return client;
    }

    private static int getCount(int sqlType, RpcData rpc) throws ConsoleException {
        ArrayList<ClientObject> list = SemClientHandler.get(sqlType, rpc, 0, 1);
        if (list == null || list.size() < 1) {
            return 0;
        }
        ClientObject client = list.get(0);
        String string = client.getClientId();
        string = string == null ? "0" : string.trim();
        int nCount = 0;
        try {
            nCount = Integer.parseInt(string);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            nCount = 0;
        }
        return nCount;
    }

    public static int getCountByGroupId(String groupId, int policyMode) throws ConsoleException {
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"GROUP_ID", (String)groupId);
        boolean hasPolicyMode = policyMode > -1 && policyMode < 2;
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_1", (String)String.valueOf(hasPolicyMode));
        if (hasPolicyMode) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(policyMode));
        }
        return SemClientHandler.getCount(1001, rpc);
    }

    public static ArrayList<ClientObject> getListByGroupId(String groupId, int policyMode, int nStart, int nCount, String orderIds) throws ConsoleException {
        TimeCounter counter = new TimeCounter();
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"GROUP_ID", (String)groupId);
        boolean hasPolicyMode = policyMode > -1 && policyMode < 2;
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_1", (String)String.valueOf(hasPolicyMode));
        if (hasPolicyMode) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(policyMode));
        }
        boolean hasOrder = orderIds != null && orderIds.length() > 0;
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN", (String)String.valueOf(hasOrder));
        if (hasOrder) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"TABLE_COLUMN", (String)orderIds);
        }
        ArrayList<ClientObject> list = SemClientHandler.get(901, rpc, nStart, nCount);
        System.out.println("SemClientHandler>> getListByGroupId: done query... group=" + groupId + ", policyMode=" + policyMode + ", " + counter.toStringEx2(true));
        counter.start();
        SemClientHandler.getClientOnlineList(list);
        System.out.println("SemClientHandler>> getListByGroupId: done online status... group=" + groupId + ", policyMode=" + policyMode + ", " + counter.toStringEx2(true));
        return list;
    }

    public static void addClient(ClientObject clientObj) throws ConsoleException {
        if (clientObj == null || clientObj.getId() == null) {
            return;
        }
        SemTable aTable = new SemTable();
        SemClient client = clientObj.getSemClient();
        aTable.addSemClient(client);
        GUIManager.addRecord(aTable, "SemClient");
    }

    public static void addClients(ArrayList<ClientObject> listClients) throws ConsoleException {
        int len;
        int n = len = listClients == null ? 0 : listClients.size();
        if (len == 0) {
            return;
        }
        SemTable aTable = new SemTable();
        for (int i = 0; i < len; ++i) {
            ClientObject client = listClients.get(i);
            if (client == null || client.getId() == null) continue;
            SemClient c = client.getSemClient();
            aTable.addSemClient(c);
        }
        GUIManager.addRecord(aTable, "SemClient");
    }

    public static List<ClientObject> getClientsByIds(List<String> clientIds, int nStart, int nCount) throws ConsoleException {
        if (clientIds == null || clientIds.size() < 1) {
            return new ArrayList<ClientObject>();
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < clientIds.size(); ++i) {
            buf.append("," + clientIds.get(i));
        }
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID_LIST", (String)buf.substring(1));
        ArrayList<ClientObject> list = SemClientHandler.get(808, rpc, nStart, nCount);
        SemClientHandler.getClientOnlineList(list);
        return list;
    }

    public static ClientObject getClientById(String clientId) throws ConsoleException {
        if (clientId == null || clientId.length() < 1) {
            return null;
        }
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"CLIENT_ID", (String)clientId);
        return SemClientHandler.getClient(801, rpc);
    }

    public static ClientObject getClient(String name, String domainName, int policyMode, int pinned) throws ConsoleException {
        return SemClientHandler.getClientEx(name, domainName, policyMode, pinned, null);
    }

    private static ClientObject getClientEx(String name, String domainName, int policyMode, int pinned, String computerID) throws ConsoleException {
        if (name == null || name.length() < 1 || domainName == null || domainName.length() < 1) {
            return null;
        }
        if (policyMode != 0 && policyMode != 1) {
            return null;
        }
        boolean isDbUppercase = DataobjectManager.getInstance().getLoginInformation().getOptDbUpperCase();
        boolean hasComputerID = computerID != null && computerID.length() > 0;
        boolean hasPinned = pinned > -1;
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN", (String)String.valueOf(isDbUppercase));
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(policyMode));
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"NAME", (String)name);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"DOMAIN_NAME", (String)domainName);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_1", (String)String.valueOf(hasComputerID));
        if (hasComputerID) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"COMPUTER_ID", (String)computerID);
        }
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_2", (String)String.valueOf(hasPinned));
        if (hasPinned) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"PIN_INTEGER", (String)String.valueOf(pinned));
        }
        ClientObject obj = SemClientHandler.getClient(802, rpc);
        if (policyMode == 0 && obj instanceof ComputerObject) {
            System.out.println("SemClientHandler>> getClient: Error-> return wrong type!");
            return null;
        }
        if (policyMode == 1 && obj instanceof UserObject) {
            System.out.println("SemClientHandler>> getClient: Error-> return wrong type!");
            return null;
        }
        return obj;
    }

    public static ClientObject getComputerEx(String name, String domainName, String hardwareKey, int pinned, int groupISOU) throws ConsoleException {
        ClientObject obj;
        if (name == null || name.length() < 1 || domainName == null || domainName.length() < 1) {
            return null;
        }
        boolean isDbUppercase = DataobjectManager.getInstance().getLoginInformation().getOptDbUpperCase();
        boolean hasHwKey = hardwareKey != null && hardwareKey.length() > 0;
        boolean hasPinned = pinned > -1;
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN", (String)String.valueOf(isDbUppercase));
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"NAME", (String)name);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"DOMAIN_NAME", (String)domainName);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_1", (String)String.valueOf(hasHwKey));
        if (hasHwKey) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"HW_KEY", (String)hardwareKey);
        }
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_2", (String)String.valueOf(hasPinned));
        if (hasPinned) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"PIN_INTEGER", (String)String.valueOf(pinned));
        }
        if (groupISOU == 1 || groupISOU == 0) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(groupISOU));
        }
        if ((obj = SemClientHandler.getClient(803, rpc)) == null) {
            return null;
        }
        if (obj instanceof UserObject) {
            System.out.println("SemClientHandler>> getComputerEx: Error-> return wrong type!");
            return null;
        }
        return obj;
    }

    public static String getGroupFromClientEx(String name, String domainName, int policyMode, int pinned, boolean group_fullpath, String computerID) throws ConsoleException {
        ClientObject o = SemClientHandler.getClientEx(name, domainName, policyMode, pinned, computerID);
        if (o == null) {
            return null;
        }
        if (!group_fullpath) {
            return o.getGroupId();
        }
        String groupPath = GroupHandler.getGroupFullPath(o.getGroupId());
        return groupPath != null && groupPath.length() > 0 ? groupPath : null;
    }

    public static String getGroupFromClient(String name, String domainName, int policyMode, int pinned, boolean group_fullpath) throws ConsoleException {
        return SemClientHandler.getGroupFromClientEx(name, domainName, policyMode, pinned, group_fullpath, null);
    }

    public static String getGroupFromComputerEx(String name, String domainName, String hardwareKey, int pinned, boolean group_fullpath, int groupISOU) throws ConsoleException {
        ClientObject o = SemClientHandler.getComputerEx(name, domainName, hardwareKey, pinned, groupISOU);
        if (o == null) {
            return null;
        }
        if (!group_fullpath) {
            return o.getGroupId();
        }
        String groupPath = GroupHandler.getGroupFullPath(o.getGroupId());
        return groupPath != null && groupPath.length() > 0 ? groupPath : null;
    }

    public static void update(ClientObject client) throws ConsoleException {
        if (client == null || client.getId() == null) {
            return;
        }
        SemTable aTable = new SemTable();
        SemClient o = client.getSemClient();
        aTable.addSemClient(o);
        GUIManager.updateRecord(aTable, "SemClient");
    }

    public static void copyClient(ClientObject client, GroupObject newGroup, boolean pinned) throws ConsoleException {
        if (client == null || newGroup == null) {
            return;
        }
        ClientObject copyClient = client.cloneClient(pinned);
        if (copyClient == null || !copyClient.isValid()) {
            return;
        }
        copyClient.setGroupId(newGroup.getId());
        copyClient.setGroupOu(false);
        SemClientHandler.addClient(copyClient);
        switch (copyClient.getPolicyMode()) {
            case 0: {
                ConsoleLogger.logAdminEvent(8201, null, copyClient.getClientId());
                break;
            }
            case 1: {
                ConsoleLogger.logAdminEvent(8207, null, copyClient.getClientId());
                break;
            }
        }
    }

    public static void moveGroup(ClientObject client, GroupObject newGroup) throws ConsoleException {
        if (client == null || newGroup == null) {
            return;
        }
        String eventDescription = client.getName() + " is Moved from \"" + client.getGroupObject().getName() + "\" to \"" + newGroup.getName() + "\"";
        client.setGroupId(newGroup.getId());
        SemClientHandler.update(client);
        ConsoleLogger.logAdminEvent(0 == client.getPolicyMode() ? 8200 : 8206, eventDescription, client.getClientId());
    }

    public static void delete(String clientId) throws ConsoleException {
        ClientObject client;
        if (clientId != null && clientId.length() != 0 && (client = SemClientHandler.getClientById(clientId)) != null) {
            SemClientHandler.delete(client);
        }
    }

    public static void delete(ClientObject client) throws ConsoleException {
        if (client == null) {
            return;
        }
        String clientId = client.getId();
        if (clientId == null) {
            return;
        }
        SemTable aTable = new SemTable();
        aTable.addSemClient(client.getSemClient());
        GUIManager.deleteRecord(aTable, "SemClient");
        switch (client.getPolicyMode()) {
            case 0: {
                ConsoleLogger.logAdminEvent(8199, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "SemClientHandler.UserDeleted"), client.getUserName()), client.getClientId());
                break;
            }
            case 1: {
                ConsoleLogger.logAdminEvent(8205, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "SemClientHandler.ComputerDeleted"), client.getComputerName()), client.getClientId());
                break;
            }
        }
    }

    public static ArrayList<ClientObject> findClients(int sqlType, RpcData rpc, int policyMode, int nStart, int nCount) throws ConsoleException {
        boolean hasPolicyMode = policyMode > -1;
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_1", (String)String.valueOf(hasPolicyMode));
        if (hasPolicyMode) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(policyMode));
        }
        ArrayList<ClientObject> clients = SemClientHandler.get(sqlType, rpc, nStart, nCount);
        SemClientHandler.getClientOnlineList(clients);
        return clients;
    }

    public static int getCountForFindClients(RpcData rpc, int policyMode) throws ConsoleException {
        boolean hasPolicyMode = policyMode > -1;
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_1", (String)String.valueOf(hasPolicyMode));
        if (hasPolicyMode) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(policyMode));
        }
        return SemClientHandler.getCount(1000, rpc);
    }

    public static int getClientOnlineStatus(ClientObject client) throws ConsoleException {
        int onlineStatus;
        block11: {
            onlineStatus = 0;
            if (client == null || client.getComputerId() == null) {
                return 0;
            }
            try {
                RpcData rpc = new RpcData();
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)client.getClientId());
                String lastSiteId = "";
                String lastServerId = "";
                SemTable aTable = GUIManager.getSemTable(804, rpc, 0, Integer.MAX_VALUE);
                if (aTable != null && aTable.getSemTableRowCount() > 0) {
                    String groupIdClient = aTable.getSemTableRow(0).getSemTableValue(0).getValue();
                    String groupIdAgent = aTable.getSemTableRow(0).getSemTableValue(1).getValue();
                    String clientIdAgent = aTable.getSemTableRow(0).getSemTableValue(2).getValue();
                    String policyMode = aTable.getSemTableRow(0).getSemTableValue(3).getValue();
                    String computerId = aTable.getSemTableRow(0).getSemTableValue(4).getValue();
                    lastSiteId = aTable.getSemTableRow(0).getSemTableValue(5).getValue();
                    lastServerId = aTable.getSemTableRow(0).getSemTableValue(6).getValue();
                    String string = clientIdAgent = clientIdAgent == null ? "" : clientIdAgent.trim();
                    if (clientIdAgent.length() > 0) {
                        if (clientIdAgent.equals(client.getClientId())) {
                            onlineStatus = 1;
                        }
                    } else if (groupIdClient.equals(groupIdAgent)) {
                        if (Integer.parseInt(policyMode) == 1) {
                            onlineStatus = 1;
                        } else {
                            RpcData rpc1 = new RpcData();
                            Utility.addSqlParameterToRpcData((RpcData)rpc1, (String)"COMPUTER_ID", (String)computerId);
                            Utility.addSqlParameterToRpcData((RpcData)rpc1, (String)"GROUP_ID", (String)groupIdClient);
                            aTable = GUIManager.getSemTable(1004, rpc1, 0, Integer.MAX_VALUE);
                            if (aTable != null && Integer.parseInt(aTable.getSemTableRow(0).getSemTableValue(0).getValue()) <= 0) {
                                onlineStatus = 1;
                            }
                        }
                    }
                }
                onlineStatus = SemClientHandler.convertOnlineStatus(onlineStatus, lastSiteId, lastServerId);
            }
            catch (ConsoleException ex) {
                if (ex.getErrorCode() == 302645248) break block11;
                throw ex;
            }
        }
        return onlineStatus;
    }

    private static int convertOnlineStatus(int statusOnline, String lastSiteId, String lastServerId) {
        if (!StringUtilities.isEmpty((String)lastSiteId) && !Manager.getCurrentSiteId().equals(lastSiteId)) {
            statusOnline = statusOnline == 1 ? 3 : 4;
        } else if (!StringUtilities.isEmpty((String)lastServerId) && !Manager.getCurrentServerId().equals(lastServerId)) {
            statusOnline = statusOnline == 1 ? 2 : 0;
        }
        return statusOnline;
    }

    public static int getCountOfDistinctRegisteredUsers(String groupId) throws ConsoleException {
        if (groupId == null || groupId.length() < 1) {
            return 0;
        }
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"GROUP_ID", (String)groupId);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN", (String)DataobjectManager.getInstance().getLoginInformation().getOptDbUpperCase().toString());
        return SemClientHandler.getCount(1002, rpc);
    }

    public static int getCountOfDistinctPhysicalComputers(String groupId) throws ConsoleException {
        boolean hasGroup = groupId != null && groupId.length() > 0;
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN", (String)String.valueOf(hasGroup));
        if (hasGroup) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"GROUP_ID", (String)groupId);
        }
        return SemClientHandler.getCount(1003, rpc);
    }

    public static boolean isSPAgent(ClientObject client) throws ConsoleException {
        if (client == null || client.getComputerId() == null) {
            return false;
        }
        ArrayList<AgentObject> listAgents = SemAgentHandler.getAgentsByClient(client, 0, Integer.MAX_VALUE);
        if (listAgents == null) {
            return false;
        }
        for (int i = 0; i < listAgents.size(); ++i) {
            int type;
            AgentObject agent = listAgents.get(i);
            if (agent == null || (type = Integer.parseInt(agent.getAgentType())) != 105) continue;
            return true;
        }
        return false;
    }

    public static Hashtable<String, ClientObject> getClientOnlineList(ArrayList<ClientObject> listClients) throws ConsoleException {
        if (listClients == null || listClients.size() < 1) {
            return null;
        }
        TimeCounter counter = new TimeCounter();
        RpcData data = new RpcData();
        NameValuePair pair = new NameValuePair();
        pair.setName("SITE_ID");
        pair.setOptValue(Manager.getCurrentSiteId());
        data.addNameValuePair(pair);
        pair = new NameValuePair();
        pair.setName("SERVER_ID");
        pair.setOptValue(Manager.getCurrentServerId());
        data.addNameValuePair(pair);
        pair = new NameValuePair();
        pair.setName("DOMAIN_ID");
        pair.setOptValue(Manager.getCurrentDomainId());
        data.addNameValuePair(pair);
        int count = 0;
        int listsize = listClients.size();
        Hashtable<String, ClientObject> table = new Hashtable<String, ClientObject>(listsize);
        for (int i = 0; i < listsize; ++i) {
            ClientObject o = listClients.get(i);
            table.put(o.getId(), o);
            if (o.getComputerId() == null || o.getComputerId().length() < 1) continue;
            String id = o.getId();
            pair = new NameValuePair();
            pair.setName(id + "_COMPUTERID");
            pair.setOptValue(o.getComputerId());
            data.addNameValuePair(pair);
            pair = new NameValuePair();
            pair.setName(id + "_USERNAME");
            pair.setOptValue(o.getUserDomainName_Same_As_In_DB());
            data.addNameValuePair(pair);
            pair = new NameValuePair();
            pair.setName(id + "_USERDOMAINNAME");
            pair.setOptValue(o.getUserDomainName_Same_As_In_DB());
            data.addNameValuePair(pair);
            pair = new NameValuePair();
            pair.setName(id + "_HARDWAREKEY");
            pair.setOptValue(o.getHardwareKey());
            data.addNameValuePair(pair);
            pair = new NameValuePair();
            pair.setName(id + "_GROUPID");
            pair.setOptValue(o.getGroupId());
            data.addNameValuePair(pair);
            pair = new NameValuePair();
            pair.setName(id + "_POLICYMODE");
            pair.setOptValue(String.valueOf(o.getPolicyMode()));
            data.addNameValuePair(pair);
            ++count;
        }
        if (count < 1) {
            ConsoleLogger.log("SemClientHandler>> getClientOnlineList: all empty clients!");
            return null;
        }
        RpcData rtData = (RpcData)GUIManager.sendCommand("GetClientOnlineList", (AbstractSchema)data);
        int retCount = rtData == null ? 0 : rtData.getNameValuePairCount();
        for (int i = 0; i < retCount; ++i) {
            pair = rtData.getNameValuePair(i);
            String id = pair.getName();
            if (id.equalsIgnoreCase("SERVER_ID") || id.equalsIgnoreCase("SITE_ID")) continue;
            String status = pair.getOptValue();
            ClientObject clo = table.get(id);
            if (clo == null) continue;
            try {
                clo.setOnlineStatusEx(Integer.parseInt(status));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ConsoleLogger.log("SemClientHandler>>getClientOnlineList>>" + counter.toString());
        return table;
    }
}

