/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.table.SemAgent;
import com.sygate.scm.common.configobject.table.SemClient;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SemClientHandler;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.ComputerObject;
import com.sygate.scm.console.logicobject.OperatingSystemObject;
import com.sygate.scm.console.logicobject.SearchClientComputerObject;
import com.sygate.scm.console.logicobject.SearchClientUserObject;
import com.sygate.scm.console.logicobject.UserObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.Vector;

public class SemClientAgentHandler {
    public static int getCountByGroupIdAndOS(String groupId, int platformFilter, boolean newClientsFilter, int policyMode, int viewType, boolean isOfflineNPVDIClient) throws ConsoleException {
        ArrayList<ClientObject> v;
        block7: {
            RpcData rpc = new RpcData();
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"DOMAIN_ID", (String)Manager.getCurrentDomainId());
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"GROUP_ID", (String)groupId);
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER_1", (String)String.valueOf(viewType));
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER_2", (String)String.valueOf(platformFilter));
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_2", (String)String.valueOf(newClientsFilter));
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(policyMode));
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_3", (String)String.valueOf(isOfflineNPVDIClient));
            v = new ArrayList<ClientObject>();
            try {
                SemTable aTable = GUIManager.getRecord(1005, rpc, "SemClient", 0, 1);
                for (int i = 0; i < aTable.getSemClientCount(); ++i) {
                    SemClient c = aTable.getSemClient(i);
                    if (c.getOptPolicyMode() == 0) {
                        v.add(new UserObject(c));
                    }
                    if (c.getOptPolicyMode() != 1) continue;
                    v.add(new ComputerObject(c));
                }
            }
            catch (ConsoleException ex) {
                if (ex.getErrorCode() == 302645248) break block7;
                throw ex;
            }
        }
        if (v == null || v.size() < 1) {
            return 0;
        }
        ClientObject client = (ClientObject)v.get(0);
        String string = client.getClientId();
        string = string == null ? "0" : string.trim();
        int nCount = 0;
        try {
            nCount = Integer.parseInt(string);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            nCount = 0;
        }
        return nCount;
    }

    public static ArrayList<ClientObject> findClients(RpcData rpc, int policyMode, int nStart, int nCount, boolean isForExport) throws ConsoleException {
        ArrayList<ClientObject> v = new ArrayList<ClientObject>();
        boolean hasPolicyMode = policyMode > -1;
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_1", (String)String.valueOf(hasPolicyMode));
        if (hasPolicyMode) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(policyMode));
        }
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)Manager.getCurrentDomainId());
        SemTable semTable = GUIManager.getSemTable(800, rpc, nStart, nCount, isForExport);
        ClientObject co = null;
        String name = "";
        String domain = "";
        String desc = "";
        String groupId = "";
        for (int i = 0; i < semTable.getSemTableRowCount(); ++i) {
            ClientObject clo = null;
            clo = SemClientHandler.getClientById(semTable.getSemTableRow(i).getSemTableValue(6).getValue());
            String englishOS = semTable.getSemTableRow(i).getSemTableValue(2).getValue();
            String i18nOSKey = semTable.getSemTableRow(i).getSemTableValue(9).getValue();
            OperatingSystemObject osObj = new OperatingSystemObject(i18nOSKey, englishOS);
            desc = semTable.getSemTableRow(i).getSemTableValue(3).getValue();
            groupId = semTable.getSemTableRow(i).getSemTableValue(7).getValue();
            if (policyMode == 0) {
                name = semTable.getSemTableRow(i).getSemTableValue(4).getValue();
                domain = semTable.getSemTableRow(i).getSemTableValue(5).getValue();
                co = new SearchClientUserObject(name, domain, osObj, desc, clo.getSemClient());
            }
            if (policyMode == 1) {
                name = semTable.getSemTableRow(i).getSemTableValue(0).getValue();
                domain = semTable.getSemTableRow(i).getSemTableValue(1).getValue();
                co = new SearchClientComputerObject(name, domain, osObj, desc, clo.getSemClient());
                ((SearchClientComputerObject)co).setClientPlatform(Integer.parseInt(semTable.getSemTableRow(i).getSemTableValue(8).getValue()));
            }
            co.setDeployStatus(Utility.parseInt((String)semTable.getSemTableRow(i).getSemTableValue(10).getValue(), (int)0));
            co.setDeployMessage(semTable.getSemTableRow(i).getSemTableValue(11).getValue());
            co.setDeployTargetVersion(semTable.getSemTableRow(i).getSemTableValue(12).getValue());
            co.setDeployRunningVersion(semTable.getSemTableRow(i).getSemTableValue(13).getValue());
            co.setDeployTimestamp(Utility.parseLong((String)semTable.getSemTableRow(i).getSemTableValue(14).getValue(), (long)0L));
            co.setInstallType(Integer.parseInt(semTable.getSemTableRow(i).getSemTableValue(18).getValue()));
            v.add(co);
            co.setGroupId(groupId);
            co.getSemClient().setOptGroupId(groupId);
            co.setOnlineStatusEx(clo.isOnline());
        }
        return v;
    }

    public static int getOnlineOrOfflineClientCount() throws ConsoleException {
        int count = 0;
        RpcData rpc = new RpcData();
        SemTable semTable = GUIManager.getRecord(680, rpc, "SemAgent", 0, 0);
        Vector semAgents = semTable.getSemAgent();
        for (SemAgent semAgent : semAgents) {
            if (semAgent == null || semAgent.getAgentId() == null) continue;
            count += Integer.parseInt(semAgent.getAgentId());
        }
        return count;
    }

    public static int getOnlineOrOfflineClientWithLUContent() throws ConsoleException {
        int count = 0;
        RpcData rpc = new RpcData();
        SemTable semTable = GUIManager.getRecord(681, rpc, "SemAgent", 0, 0);
        Vector semAgents = semTable.getSemAgent();
        for (SemAgent semAgent : semAgents) {
            if (semAgent == null || semAgent.getAgentId() == null) continue;
            count += Integer.parseInt(semAgent.getAgentId());
        }
        return count;
    }
}

