/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.table.SemAgent;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.common.configobject.table.SemTableRow;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AgentObject;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.RevisionObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SemAgentHandler
extends AbstractHandler {
    public static final String PATTERN_TYPE_WEBEXT = "WEBEXT_DEFS";

    public static ArrayList<AgentObject> getAgentsByClient(ClientObject client, int nStart, int nCount) throws ConsoleException {
        ArrayList<AgentObject> v;
        block5: {
            if (client == null || !client.isValid()) {
                return null;
            }
            String computerId = client.getComputerId();
            if (computerId == null || computerId.length() < 1) {
                return null;
            }
            v = new ArrayList<AgentObject>();
            RpcData rpc = new RpcData();
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"DOMAIN_ID", (String)Manager.getCurrentDomainId());
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"COMPUTER_ID", (String)computerId);
            try {
                SemTable aTable = GUIManager.getRecord(605, rpc, "SemAgent", nStart, nCount);
                for (int i = 0; i < aTable.getSemAgentCount(); ++i) {
                    SemAgent c = aTable.getSemAgent(i);
                    v.add(new AgentObject(c));
                }
            }
            catch (ConsoleException ex) {
                if (ex.getErrorCode() == 302645248) break block5;
                throw ex;
            }
        }
        return v;
    }

    public static void updateAgent(AgentObject agent) throws ConsoleException {
        if (agent == null || agent.getId() == null) {
            return;
        }
        SemTable aTable = new SemTable();
        SemAgent o = agent.getSemAgent();
        aTable.addSemAgent(o);
        GUIManager.updateRecord(aTable, "SemAgent");
    }

    public static String getSAVDefByAgentId(String agentId) throws ConsoleException {
        block4: {
            if (agentId == null) {
                return null;
            }
            RpcData rpc = new RpcData();
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)agentId);
            try {
                SemTable semTable = GUIManager.getSemTable(601, rpc, -1, -1);
                if (semTable.getSemTableRowCount() > 0) {
                    SemTableRow tableRow = semTable.getSemTableRow(0);
                    return tableRow.getSemTableValue(0).getValue();
                }
            }
            catch (ConsoleException ex) {
                if (ex.getErrorCode() == 302645248) break block4;
                throw ex;
            }
        }
        return null;
    }

    private static String getPatternVersionByAgentId(RpcData rpc) throws ConsoleException {
        block3: {
            try {
                SemTable semTable = GUIManager.getSemTable(600, rpc, -1, -1);
                if (semTable.getSemTableRowCount() > 0) {
                    SemTableRow tableRow = semTable.getSemTableRow(0);
                    return tableRow.getSemTableValue(0).getValue();
                }
            }
            catch (ConsoleException ex) {
                if (ex.getErrorCode() == 302645248) break block3;
                throw ex;
            }
        }
        return null;
    }

    private static Map<String, String> getPatternVersionMapByAgentId(RpcData rpc) throws ConsoleException {
        HashMap<String, String> patternMap;
        block3: {
            patternMap = new HashMap<String, String>();
            try {
                SemTable semTable = GUIManager.getSemTable(600, rpc, -1, -1);
                for (SemTableRow tableRow : semTable.getSemTableRow()) {
                    if (tableRow.getSemTableValueCount() < 2) continue;
                    patternMap.putIfAbsent(tableRow.getSemTableValue(1).getValue(), tableRow.getSemTableValue(0).getValue());
                }
            }
            catch (ConsoleException ex) {
                if (ex.getErrorCode() == 302645248) break block3;
                throw ex;
            }
        }
        return patternMap;
    }

    public static String getTruScanDefByAgentObject(AgentObject agentObj) throws ConsoleException {
        String syKnWlDef;
        String syKnCalDef;
        int ret;
        String agentId = agentObj.getAgentId();
        if (agentId == null) {
            return null;
        }
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)agentId);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"STRING_LIST", (String)"SYKNAPPS_CAL, SYKNAPPS_WHITELIST, BASH_CONTENT");
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN", (String)"true");
        Map<String, String> patternMap = SemAgentHandler.getPatternVersionMapByAgentId(rpc);
        String def = agentObj.isPostAmberClient() ? patternMap.get("BASH_CONTENT") : ((ret = RevisionObject.compareDbFormatRevision(syKnCalDef = patternMap.get("SYKNAPPS_CAL"), syKnWlDef = patternMap.get("SYKNAPPS_WHITELIST"))) == 1 ? syKnCalDef : syKnWlDef);
        return def;
    }

    public static String getDefByAgentIdPatternType(String agentId, String patternType) throws ConsoleException {
        if (agentId == null) {
            return null;
        }
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)agentId);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"STRING_LIST", (String)patternType);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN", (String)"true");
        return SemAgentHandler.getPatternVersionByAgentId(rpc);
    }

    public static String getIPSDefByAgentId(String agentId) throws ConsoleException {
        if (agentId == null) {
            return null;
        }
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)agentId);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"STRING_LIST", (String)"DEUCE_SIG");
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN", (String)"true");
        return SemAgentHandler.getPatternVersionByAgentId(rpc);
    }

    public static String getDPDefByAgentId(String agentId) throws ConsoleException {
        return SemAgentHandler.getDefByAgentIdPatternType(agentId, "SYMANTEC_WHITELIST");
    }

    public static String getEDRDefByAgentId(String agentId) throws ConsoleException {
        return SemAgentHandler.getDefByAgentIdPatternType(agentId, "EDR_DEFS");
    }

    public static String getSTICDefByAgentId(String agentId) throws ConsoleException {
        return SemAgentHandler.getDefByAgentIdPatternType(agentId, "STIC_DEFS");
    }

    public static String getSecurityPatchDefByAgentId(String agentId) throws ConsoleException {
        return SemAgentHandler.getDefByAgentIdPatternType(agentId, "SECURITY_FIX_DEFS");
    }

    public static String getAMLAVDefByAgentId(String agentId) throws ConsoleException {
        return SemAgentHandler.getDefByAgentIdPatternType(agentId, "ADVML_AV");
    }

    public static String getWtrDefByAgentId(String agentId) throws ConsoleException {
        return SemAgentHandler.getDefByAgentIdPatternType(agentId, "WTR_DEFS");
    }

    public static String getTdadDefByAgentId(String agentId) throws ConsoleException {
        return SemAgentHandler.getDefByAgentIdPatternType(agentId, "TDAD_CONTENT");
    }

    public static String getWebExtDefByAgentId(String agentId) throws ConsoleException {
        return SemAgentHandler.getDefByAgentIdPatternType(agentId, PATTERN_TYPE_WEBEXT);
    }
}

