/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ExportedPackage;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.rpc.AgentCommunicationSetting;
import com.sygate.scm.common.configobject.rpc.CommConf;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.rpc.ServerSettings;
import com.sygate.scm.common.configobject.schema.AdaptivePolicy;
import com.sygate.scm.common.configobject.schema.AdminDefinedScan;
import com.sygate.scm.common.configobject.schema.AppLearning;
import com.sygate.scm.common.configobject.schema.AppliedPolicyArray;
import com.sygate.scm.common.configobject.schema.AutoLocation;
import com.sygate.scm.common.configobject.schema.AvPolicy;
import com.sygate.scm.common.configobject.schema.AvScanPolicy;
import com.sygate.scm.common.configobject.schema.BaselineFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.CommandScan;
import com.sygate.scm.common.configobject.schema.Communication;
import com.sygate.scm.common.configobject.schema.EnforcedFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.ExcludedAppArray;
import com.sygate.scm.common.configobject.schema.Executable;
import com.sygate.scm.common.configobject.schema.FirewallRule;
import com.sygate.scm.common.configobject.schema.FirewallRuleSystem;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.FwIDS;
import com.sygate.scm.common.configobject.schema.FwIdsLibrary;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfacePool;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceTrigger;
import com.sygate.scm.common.configobject.schema.FwNetworkServicePool;
import com.sygate.scm.common.configobject.schema.FwServiceTrigger;
import com.sygate.scm.common.configobject.schema.GlobalObjectPool;
import com.sygate.scm.common.configobject.schema.HiHostIntegrityPolicy;
import com.sygate.scm.common.configobject.schema.HiIF;
import com.sygate.scm.common.configobject.schema.HiReqTemplate;
import com.sygate.scm.common.configobject.schema.HiReqTemplateGroup;
import com.sygate.scm.common.configobject.schema.HiReqTemplateLibrary;
import com.sygate.scm.common.configobject.schema.HiReqTemplateLibraryPool;
import com.sygate.scm.common.configobject.schema.HiScriptBlock;
import com.sygate.scm.common.configobject.schema.HidPolicy;
import com.sygate.scm.common.configobject.schema.IdsPolicy;
import com.sygate.scm.common.configobject.schema.Inheritance;
import com.sygate.scm.common.configobject.schema.LinuxAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.LinuxAvAutoProtect;
import com.sygate.scm.common.configobject.schema.LinuxAvGeneral;
import com.sygate.scm.common.configobject.schema.LinuxAvScanPolicy;
import com.sygate.scm.common.configobject.schema.Location;
import com.sygate.scm.common.configobject.schema.LocationArray;
import com.sygate.scm.common.configobject.schema.Log;
import com.sygate.scm.common.configobject.schema.LuContentPolicy;
import com.sygate.scm.common.configobject.schema.LuPolicy;
import com.sygate.scm.common.configobject.schema.MacAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.MacAdminDefinedScanDetails;
import com.sygate.scm.common.configobject.schema.MacAvScanPolicy;
import com.sygate.scm.common.configobject.schema.MacCommandScan;
import com.sygate.scm.common.configobject.schema.MacFwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.MemPolicy;
import com.sygate.scm.common.configobject.schema.NtrPolicy;
import com.sygate.scm.common.configobject.schema.ObjInfo;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicy;
import com.sygate.scm.common.configobject.schema.PEPPolicy;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.configobject.schema.PolicyOverride;
import com.sygate.scm.common.configobject.schema.PresharedSecret;
import com.sygate.scm.common.configobject.schema.SecuritySetting;
import com.sygate.scm.common.configobject.schema.SemAgentPolicy;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemClientGroupTree;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SemGroupPolicy;
import com.sygate.scm.common.configobject.schema.SemLocationConfig;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SemSiteArray;
import com.sygate.scm.common.configobject.schema.ServerArray;
import com.sygate.scm.common.configobject.schema.ServerCertificate;
import com.sygate.scm.common.configobject.schema.TriggerCondition;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.configobject.table.SemApplication;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.common.exception.CancelException;
import com.sygate.scm.common.exception.CommonException;
import com.sygate.scm.common.i18n.LocaleManipulationUtility;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.monitor.MonitorAgent;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.HTMLEditorPane;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.ImportConfigObjHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.ComputerInfoObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.HostIntegrityTemplateLibraryObject;
import com.sygate.scm.console.logicobject.LearnedApplicationObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.logicobject.PhysicalFileObject;
import com.sygate.scm.console.logicobject.PolicyLogEvent;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.PolicyReferenceObject;
import com.sygate.scm.console.logicobject.ServerListObject;
import com.sygate.scm.console.ui.ConsoleOptions;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyUtil;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateContentObject;
import com.sygate.scm.console.ui.policy.override.GEHStaticTypes;
import com.sygate.scm.console.ui.policy.override.logicobject.DetectedProcessUIObject;
import com.sygate.scm.console.ui.policy.override.logicobject.KnownSecurityUIObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleAssertion;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.hi.library.HiParm_EnforceAsw;
import com.sygate.scm.hi.library.HiParm_EnforceAv;
import com.sygate.scm.hi.library.HiParm_EnforceFw;
import com.sygate.scm.hi.library.HiParm_EnforcePatch;
import com.sygate.scm.hi.library.HiParm_EnforceServicePack;
import com.sygate.scm.hi.library.HiParm_Popup;
import com.sygate.scm.util.DefaultSchemaObject;
import com.sygate.scm.util.DynaCatManipulationUtility;
import com.sygate.scm.util.ExceptionPolicyUtility;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.MigHIPolicyUtils;
import com.sygate.scm.util.NTRPolicyUtility;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.SylinkExportUtil;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PolicyHandler
extends AbstractHandler {
    private static final MessageResourcesFile MSGRES_FILE = new MessageResourcesFile("com.sygate.scm.console.handler.handler");
    public static final int HPPA_VIEWTYPE_ALL = 0;
    public static final int HPPA_VIEWTYPE_WATCHEDAPP = 1;
    public static final int HPPA_VIEWTYPE_REQUESTEDAPP = 2;
    static Map<String, TopLevelObject> newObjectPool = new HashMap<String, TopLevelObject>();
    private static final Map<String, TopLevelObject> changedObjectPool = new HashMap<String, TopLevelObject>();
    private static ConsoleOptions options = ConsoleOptions.getInstance();
    private static CopitableObject copiedObject;
    private static List<?> copiedObjects;
    private static Set<String> macAddressPool;
    private static Map<String, String> serviceIdMap;
    private static Map<String, String> networkInterfaceIdMap;
    private static List<HostIntegrityTemplateLibraryObject> hiTemplibObjList;
    private static PolicyReferenceObject copiedPolicy;
    private static DefaultSchemaObject defaultSchemaObject;
    private static final String CONFIG_XML = "sylink.xml";
    static char[] zeroList;
    private static boolean isInCopy;
    static JFileChooser chooser;
    static FileFilter importFileFilter;

    public static boolean newObjectPoolContainsKey(String key) {
        return newObjectPool.containsKey(key);
    }

    public static void addToChangedObjectPool(String key, TopLevelObject tlo) {
        changedObjectPool.put(key, tlo);
    }

    public static void removeFromChangedObjectPool(String key) {
        changedObjectPool.remove(key);
    }

    public static void removeFromNewObjectPool(String key) {
        newObjectPool.remove(key);
    }

    public static Map<String, TopLevelObject> getNewObjectPool() {
        return newObjectPool;
    }

    public static Map<String, TopLevelObject> getChangedObjectPool() {
        return changedObjectPool;
    }

    public static void addToNewObjectPool(String str, TopLevelObject tlo) {
        newObjectPool.put(str, tlo);
    }

    public static GroupPolicyObject getGroupPolicyByGroupFromDB(GroupObject group) throws ConsoleException {
        return PolicyHandler.getGroupPolicyByGroupFromDB(group, false);
    }

    public static GroupPolicyObject getGroupPolicyByGroupFromDB(GroupObject group, boolean forceRefresh) throws ConsoleException {
        String grpPolicyGUID = group.getSemClientGroup().getObjReference().getTargetId();
        SemGroupPolicy semGrpPolicy = (SemGroupPolicy)PolicyHandler.getObjectFromDB("SemGroupPolicy", grpPolicyGUID, forceRefresh);
        GroupPolicyObject groupPolicyObj = new GroupPolicyObject(semGrpPolicy);
        SemAgentPolicy agentPolicy = PolicyHandler.getSemAgentPolicyByGroupFromDB(group, forceRefresh);
        groupPolicyObj.setAgentPolicyObject(agentPolicy);
        groupPolicyObj.setGroupObject(group);
        return groupPolicyObj;
    }

    public static SemAgentPolicy getSemAgentPolicyByGroupFromDB(GroupObject grpObj) throws ConsoleException {
        return PolicyHandler.getSemAgentPolicyByGroupFromDB(grpObj, false);
    }

    public static SemAgentPolicy getSemAgentPolicyByGroupFromDB(GroupObject grpObj, boolean forceRefresh) throws ConsoleException {
        String grpPolicyGUID = grpObj.getSemClientGroup().getObjReference().getTargetId();
        SemGroupPolicy semGrpPolicy = (SemGroupPolicy)PolicyHandler.getObjectFromDB("SemGroupPolicy", grpPolicyGUID);
        Inheritance inheritance = semGrpPolicy.getInheritance();
        boolean isThisInherit = inheritance.getMode().equals(Inheritance.USE_PARENT);
        if (!isThisInherit) {
            String apGUID = null;
            ObjReference objRef = PolicyHandler.getSemAgentPolicyReference(semGrpPolicy);
            if (objRef != null) {
                apGUID = objRef.getTargetId();
            }
            if (apGUID == null || apGUID.length() == 0) {
                ConsoleAssertion.runAssert(true, "No SemAgentPolicy GUID in Group Policy. Policy ID=" + semGrpPolicy.getId());
            }
            SemAgentPolicy semAgentPolicy = (SemAgentPolicy)PolicyHandler.getObjectFromDB("SemAgentPolicy", apGUID, forceRefresh);
            return semAgentPolicy;
        }
        return PolicyHandler.getSemAgentPolicyByGroupFromDB(grpObj.getParentGroup(), forceRefresh);
    }

    public static GroupPolicyObject getGroupPolicyByGroup(GroupObject group) throws ConsoleException {
        return PolicyHandler.getGroupPolicyByGroup(group, true);
    }

    public static boolean isGroupInherit(GroupObject group) {
        if (group.isInheritedSet()) {
            return group.isInherited();
        }
        DataobjectManager data = DataobjectManager.getInstance();
        String grpPolicyGUID = group.getSemClientGroup().getObjReference().getTargetId();
        SemGroupPolicy semGrpPolicy = null;
        boolean isThisInherit = false;
        try {
            semGrpPolicy = (SemGroupPolicy)data.getObjectByGUID("SemGroupPolicy", grpPolicyGUID);
            Inheritance inheritance = semGrpPolicy.getInheritance();
            isThisInherit = inheritance.getMode().equals(Inheritance.USE_PARENT);
        }
        catch (ConsoleException ex) {
            System.err.println("Error:get Group inehrit info");
            LoggerUtilities.logException((Throwable)ex);
        }
        return isThisInherit;
    }

    public static GroupPolicyObject getGroupPolicyByGroup(GroupObject group, boolean refresh) throws ConsoleException {
        SemClientGroup g = group.getSemClientGroup();
        ObjReference objRef = g.getObjReference();
        String grpPolicyGUID = objRef.getTargetId();
        SemGroupPolicy semGrpPolicy = (SemGroupPolicy)PolicyHandler.getObject("SemGroupPolicy", grpPolicyGUID);
        GroupPolicyObject groupPolicyObj = new GroupPolicyObject(semGrpPolicy);
        SemAgentPolicy agentPolicy = PolicyHandler.getSemAgentPolicyByGroup(group, refresh);
        groupPolicyObj.setAgentPolicyObject(agentPolicy);
        groupPolicyObj.setGroupObject(group);
        return groupPolicyObj;
    }

    public static SemAgentPolicy getSemAgentPolicyByGroup(GroupObject grpObj) throws ConsoleException {
        return PolicyHandler.getSemAgentPolicyByGroup(grpObj, true);
    }

    public static SemAgentPolicy getSemAgentPolicyByGroup(GroupObject grpObj, boolean refresh) throws ConsoleException {
        String grpPolicyGUID = grpObj.getSemClientGroup().getObjReference().getTargetId();
        SemGroupPolicy semGrpPolicy = (SemGroupPolicy)PolicyHandler.getObject("SemGroupPolicy", grpPolicyGUID);
        Inheritance inheritance = semGrpPolicy.getInheritance();
        boolean isThisInherit = inheritance.getMode().equals(Inheritance.USE_PARENT);
        if (!isThisInherit) {
            String apGUID = null;
            ObjReference objRef = PolicyHandler.getSemAgentPolicyReference(semGrpPolicy);
            if (objRef != null) {
                apGUID = objRef.getTargetId();
            }
            if (apGUID == null || apGUID.length() == 0) {
                ConsoleAssertion.runAssert(true, "No SemAgentPolicy GUID in Group Policy. Policy ID=" + semGrpPolicy.getId());
            }
            SemAgentPolicy semAgentPolicy = (SemAgentPolicy)PolicyHandler.getObject("SemAgentPolicy", apGUID);
            return semAgentPolicy;
        }
        return PolicyHandler.getSemAgentPolicyByGroup(grpObj.getParentGroup());
    }

    public static boolean isDefaultLocation(Location loc, String defLocId) {
        return loc.getId().equals(defLocId);
    }

    public static LocationObject getDefaultLocation(AutoLocation autoLocation) throws ConsoleException {
        LocationArray locArray = autoLocation.getLocationArray();
        String defLocId = locArray.getDefaultLocation();
        for (Location loc : locArray.getLocation()) {
            if (!PolicyHandler.isDefaultLocation(loc, defLocId)) continue;
            return new LocationObject(loc, true, false);
        }
        return null;
    }

    public static void updateGroupPolicy(GroupPolicyObject gpObj) throws ConsoleException {
        ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        PolicyHandler.addNewObject(gpObj.getNewObject().values(), gpObj.getDeletedObject(), updateList);
        SemGroupPolicy group = gpObj.getSemGroupPolicyObject();
        DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)group, 0);
        updateList.add(entry);
        changedObjectPool.remove(group.getId());
        if (!gpObj.isInherit()) {
            SemAgentPolicy agent = gpObj.getSemAgentPolicyObject();
            entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)agent, 0);
            updateList.add(entry);
            Collection<TopLevelObject> changedObj = gpObj.getChangedObject().values();
            Iterator<TopLevelObject> it = changedObj.iterator();
            while (it.hasNext()) {
                TopLevelObject obj = it.next();
                String id = obj.getId();
                if (!gpObj.getDeletedObject().containsKey(id)) {
                    entry = new DataobjectManager.UpdateObjectEntry(obj, 0);
                    updateList.add(entry);
                }
                it.remove();
                changedObjectPool.remove(obj.getId());
            }
        }
        PolicyHandler.deleteDeletedObject(gpObj.getDeletedObject().values(), updateList);
        boolean policyUpdated = false;
        Map<String, Object> resultTable = DataobjectManager.getInstance().updateObject("Merge", updateList);
        if (resultTable.size() > 0) {
            List changedIdList;
            SemAgentPolicy agent;
            SemAgentPolicy newAgent;
            SemGroupPolicy newGroup = (SemGroupPolicy)resultTable.get(group.getId());
            if (newGroup != null) {
                gpObj.setSemGroupPolicy(newGroup);
            }
            if (!gpObj.isInherit() && (newAgent = (SemAgentPolicy)resultTable.get((agent = gpObj.getSemAgentPolicyObject()).getId())) != null) {
                gpObj.setAgentPolicyObject(newAgent);
            }
            if ((changedIdList = (List)resultTable.get("KEY_CHANGED_IDSET")) != null && changedIdList.size() > 0) {
                policyUpdated = true;
            }
        }
        boolean physicalFileUpdated = PolicyHandler.updatePhysicalFiles(gpObj);
        if (policyUpdated || physicalFileUpdated) {
            PolicyHandler.updateLog(gpObj.getLogList());
            GroupObject gObj = gpObj.getGroupObject();
            if (gObj != null) {
                GroupHandler.updateGroup(gObj);
            } else {
                ConsoleLogger.log("There is no group object associated with this group policy " + gpObj.toString());
            }
        } else {
            gpObj.getLogList().clear();
        }
        PolicyHandler.clearAllObjectPool();
    }

    private static boolean updatePhysicalFiles(GroupPolicyObject grpObj) throws ConsoleException {
        PhysicalFileObject pObject = grpObj.getPhysicalFileObject();
        if (pObject != null) {
            return PolicyHandler.updatePhysicalFiles(pObject);
        }
        return false;
    }

    public static boolean updatePhysicalFiles(PhysicalFileObject pObject) throws ConsoleException {
        Hashtable<String, PhysicalFile> removeFiles;
        PhysicalFile pFile;
        if (pObject == null || !pObject.isUpdateNeeded()) {
            return false;
        }
        DataobjectManager dataManager = DataobjectManager.getInstance();
        Hashtable<String, PhysicalFile> newfiles = pObject.getNewPhysicalFileList();
        if (newfiles != null) {
            Enumeration<String> en = newfiles.keys();
            while (en.hasMoreElements()) {
                String id = en.nextElement();
                pFile = newfiles.get(id);
                GUIManager.addFile(pFile.getId(), pFile.getFileName());
                File pf = new File(pFile.getFileName());
                pFile.setFileName(pf.getName());
                dataManager.addObject((TopLevelObject)pFile);
                changedObjectPool.remove(pFile.getId());
                newObjectPool.remove(pFile.getId());
            }
        }
        if ((removeFiles = pObject.getRemovedPhysicalFileList()) != null) {
            Enumeration<String> en = removeFiles.keys();
            while (en.hasMoreElements()) {
                String id = en.nextElement();
                pFile = removeFiles.get(id);
                dataManager.deleteObject((TopLevelObject)pFile);
                GUIManager.deleteFile(pFile.getId());
            }
        }
        return true;
    }

    public static void updateLog(List<PolicyLogEvent> logList) {
        for (PolicyLogEvent event : logList) {
            ConsoleLogger.logPolicyEvent(event.getEventId(), event.getOwnerId(), event.getDescription(), null);
        }
        logList.clear();
    }

    public static void addNewObject(Collection<TopLevelObject> newObjSet, Map<String, TopLevelObject> deletedObjSet, List<DataobjectManager.UpdateObjectEntry> updateList) {
        Iterator<TopLevelObject> it = newObjSet.iterator();
        while (it.hasNext()) {
            TopLevelObject obj = it.next();
            TopLevelObject newObj = obj;
            String newId = newObj.getId();
            if (!deletedObjSet.containsKey(newId)) {
                DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry(newObj, 1);
                updateList.add(entry);
            }
            it.remove();
            newObjectPool.remove(newObj.getId());
        }
    }

    public static void deleteDeletedObject(Collection<TopLevelObject> deleteObjSet, List<DataobjectManager.UpdateObjectEntry> updateList) {
        Iterator<TopLevelObject> it = deleteObjSet.iterator();
        while (it.hasNext()) {
            TopLevelObject newObj = it.next();
            DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry(newObj, 2);
            updateList.add(entry);
            it.remove();
        }
    }

    public static void updateChangedObject(Collection<TopLevelObject> newObjSet, Map<String, TopLevelObject> deletedObjSet, List<DataobjectManager.UpdateObjectEntry> updateList) {
        Iterator<TopLevelObject> it = newObjSet.iterator();
        while (it.hasNext()) {
            TopLevelObject newObj = it.next();
            String newId = newObj.getId();
            if (!deletedObjSet.containsKey(newId)) {
                DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry(newObj, 0);
                updateList.add(entry);
            }
            it.remove();
        }
    }

    public static ConfigObject getCopyOfObj(ConfigObject oldObj) throws ConsoleException {
        if (oldObj == null) {
            return null;
        }
        try {
            MetadataAttributes mAttr;
            Document doc = oldObj.getDocument();
            ConfigObject object = (ConfigObject)AbstractSchema.readXML((Document)doc);
            if (object instanceof TopLevelObject && (mAttr = ((TopLevelObject)oldObj).getMetadataAttributes()) != null) {
                ((TopLevelObject)object).setMetadataAttributes((MetadataAttributes)mAttr.clone());
            }
            object.setParent(oldObj.getParent());
            boolean isDirty = oldObj.isDirty();
            if (isDirty) {
                object.setDirty();
            }
            return object;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void resetCopyOfAgentPolicy(GroupPolicyObject gpObj) throws ConsoleException {
        if (!gpObj.isInherit()) {
            SemAgentPolicy semAgent = gpObj.getSemAgentPolicyObject();
            Map<String, TopLevelObject> newObjSet = gpObj.getNewObject();
            WashIDHandler washer = new WashIDHandler();
            try {
                HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
                ConfigObject newSemAgent = washer.duplicateObject((ConfigObject)semAgent, createdObj);
                PolicyHandler.dumpObjects(new HashSet<TopLevelObject>(createdObj.values()), newObjSet);
                gpObj.addAgentPolicyObject((SemAgentPolicy)newSemAgent);
                SemGroupPolicy semGroup = gpObj.getSemGroupPolicyObject();
                changedObjectPool.put(semGroup.getId(), (TopLevelObject)semGroup);
            }
            catch (Exception ex) {
                throw new ConsoleException(ex);
            }
        }
        try {
            GroupObject myGroup = gpObj.getGroupObject();
            SemAgentPolicy semAgent = PolicyHandler.getSemAgentPolicyByGroup(myGroup.getParentGroup());
            gpObj.setAgentPolicyObject(semAgent);
            SemClientGroup semClientGroup = myGroup.getSemClientGroup();
            SemGroupPolicy semGrpPolicy = PolicyHandler.getSemGroupPolicy(semClientGroup);
            ObjReference objRef = PolicyHandler.getSemAgentPolicyReference(semGrpPolicy);
            if (objRef != null) {
                objRef.setTargetId(semAgent.getId());
            }
            SemGroupPolicy semGroup = gpObj.getSemGroupPolicyObject();
            changedObjectPool.put(semGroup.getId(), (TopLevelObject)semGroup);
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static boolean compareConfigObject(ConfigObject obj1, ConfigObject obj2) {
        try {
            if (obj1 == null && obj2 == null) {
                return true;
            }
            if (obj1 == null && obj2 != null) {
                return false;
            }
            if (obj1 != null && obj2 == null) {
                return false;
            }
            if (obj1 != null && obj2 != null) {
                String str1 = obj1.getString();
                String str2 = obj2.getString();
                return str1.equals(str2);
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return false;
    }

    public static void copyObject(CopitableObject object) {
        copiedObject = object;
        if (object instanceof IdsLibraryObject || object instanceof LiveUpdateContentObject || object instanceof ServerListObject) {
            PolicyHandler.popUpWarningForCopy(((PolicyObjectBase)object).getName());
        } else if (!isInCopy && object instanceof PolicyInt) {
            isInCopy = true;
            PolicyInt policy = (PolicyInt)((Object)object);
            ObjReference objRef = new ObjReference();
            objRef.setTargetId(policy.getId());
            objRef.setTargetType(policy.getTargetType());
            objRef.setName(policy.getTargetName());
            ObjReference locRef = new ObjReference();
            locRef.setTargetId(policy.getId());
            locRef.setTargetType(policy.getTargetType());
            locRef.setName(policy.getLocalReferenceName());
            PolicyHandler.copyPolicy(objRef, locRef, (PolicyInt)((Object)object));
            isInCopy = false;
        }
    }

    public static boolean copyObjects(List<?> objectList, String className) {
        isInCopy = false;
        try {
            copiedObjects = objectList.stream().filter(c -> c.getClass().getName().equals(className)).collect(Collectors.toList());
            isInCopy = true;
        }
        catch (Exception ex) {
            isInCopy = false;
            ConsoleLogger.log("copyObjects() >> ERROR COPYING Objects " + ex.getMessage());
        }
        return isInCopy;
    }

    public static boolean hasCopiedObjects(Class<?> objClass) {
        if (copiedObjects == null) {
            return false;
        }
        if (copiedObjects.stream().filter(c -> c.getClass().equals(objClass)).collect(Collectors.toList()).size() > 0) {
            ConsoleLogger.log("hasCopiedObjects >> somecopied objects exists in memory");
            return true;
        }
        ConsoleLogger.log("hasCopiedObjects >> No objects to paste. Copy list is empty");
        return false;
    }

    public static List<?> getPastedObjects(Class<?> objClass) {
        try {
            ConsoleLogger.log("getPastedObjects() >> " + objClass.getName());
            return copiedObjects.stream().filter(c -> c.getClass().getName().equals(objClass.getName())).collect(Collectors.toList());
        }
        catch (Exception ex) {
            ConsoleLogger.log("getPastedObjects() >> " + ex.getMessage());
            return null;
        }
    }

    public static boolean hasCopiedObject(Class<? extends CopitableObject> objClass) {
        if (copiedObject == null) {
            return false;
        }
        return objClass.isAssignableFrom(copiedObject.getClass());
    }

    public static boolean hasCopiedObject(List<Class<? extends PolicyObjectBase>> objClasses) {
        for (Class<? extends PolicyObjectBase> objClass : objClasses) {
            if (!PolicyHandler.hasCopiedObject(objClass)) continue;
            return true;
        }
        return false;
    }

    public static CopitableObject getPastedObject(Class<?> objClass) throws ConsoleException {
        if (copiedObject != null && copiedObject.getClass().equals(objClass)) {
            return copiedObject.getPastedObject();
        }
        return null;
    }

    public static CopitableObject getPastedObject() throws ConsoleException {
        if (copiedObject != null) {
            return copiedObject.getPastedObject();
        }
        return null;
    }

    public static void addNewOject(Collection<TopLevelObject> newObjSet) {
        for (TopLevelObject obj : newObjSet) {
            newObjectPool.put(obj.getId(), obj);
        }
    }

    public static DefaultMutableTreeNode getGroupLocationTreeFromServer() {
        return null;
    }

    public static DefaultMutableTreeNode getGroupLocationTree() throws ConsoleException {
        if (options.isGetAllGroupLocationsEnabled()) {
            return PolicyHandler.getGroupLocationTree(false);
        }
        return PolicyHandler.getGroupLocationTreeOld();
    }

    public static DefaultMutableTreeNode getGroupLocationTreeOld() throws ConsoleException {
        DefaultMutableTreeNode grpNode = GroupHandler.getGroupsRoot(false);
        if (grpNode == null) {
            return new DefaultMutableTreeNode();
        }
        ArrayList<DefaultMutableTreeNode> nodeList = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> nodeListIterator = grpNode.breadthFirstEnumeration();
        while (nodeListIterator.hasMoreElements()) {
            nodeList.add((DefaultMutableTreeNode)nodeListIterator.nextElement());
        }
        for (DefaultMutableTreeNode aNode : nodeList) {
            GroupObject grpObj = (GroupObject)aNode.getUserObject();
            String grpPolicyGUID = grpObj.getSemClientGroup().getObjReference().getTargetId();
            ArrayList<LocationObject> allLocations = new ArrayList<LocationObject>();
            boolean isThisInherit = PolicyHandler.getLocationsFromDB(grpPolicyGUID, allLocations);
            boolean hasAccess = grpObj.canDirectiveSelectable();
            grpObj.setInherited(isThisInherit);
            grpObj.setDirectiveSelectable(hasAccess && !isThisInherit);
            grpObj.setIndirectiveSelectable(PolicyUtil.getRecursiveIndirectiveSelectableForReadonlyGroups(aNode));
            if (isThisInherit || grpObj.getAccessConstraint() == 1) continue;
            boolean hasFullAccess = grpObj.getAccessConstraint() == 0;
            for (LocationObject locObj : allLocations) {
                if (!hasFullAccess) {
                    locObj.setDirectiveSelectable(false);
                    locObj.setIndirectiveSelectable(false);
                }
                aNode.add(new DefaultMutableTreeNode(locObj));
            }
        }
        PolicyHandler.setInheritedGroupsLocations(grpNode);
        return grpNode;
    }

    public static boolean getLocationsFromDB(String grpPolicyGUID, ArrayList<LocationObject> locArray) throws ConsoleException {
        HashMap<String, SemLocationConfig> idSemLocationMap = new HashMap<String, SemLocationConfig>();
        SemAgentPolicy semAgentPolicy = null;
        SemGroupPolicy semGroupPolicy = null;
        boolean isThisInherit = true;
        TopLevelObject[] topLevelObject = DataobjectManager.getInstance().getAgentPolicyLocationByGroupPolicyId(grpPolicyGUID);
        if (topLevelObject == null) {
            throw new IllegalStateException("PolicyHandler>getLocationsFromDB>>topLevelObject was null!");
        }
        for (int i = 0; i < topLevelObject.length; ++i) {
            TopLevelObject object = topLevelObject[i];
            if (object instanceof SemGroupPolicy) {
                semGroupPolicy = (SemGroupPolicy)object;
                continue;
            }
            if (object instanceof SemAgentPolicy) {
                semAgentPolicy = (SemAgentPolicy)object;
                continue;
            }
            if (!(object instanceof SemLocationConfig)) continue;
            idSemLocationMap.put(object.getId(), (SemLocationConfig)object);
        }
        if (semGroupPolicy == null) {
            return isThisInherit;
        }
        Inheritance inheritance = semGroupPolicy.getInheritance();
        isThisInherit = inheritance.getMode().equals(Inheritance.USE_PARENT);
        if (!isThisInherit && semAgentPolicy != null) {
            AutoLocation auLocation = semAgentPolicy.getAutoLocation();
            LocationArray locArrayObj = auLocation.getLocationArray();
            String defLocation = locArrayObj.getDefaultLocation();
            for (Location curLoc : locArrayObj.getLocation()) {
                boolean isDefault = PolicyHandler.isDefaultLocation(curLoc, defLocation);
                ObjReference refer = curLoc.getObjReference();
                SemLocationConfig semLocConfig = (SemLocationConfig)idSemLocationMap.get(refer.getTargetId());
                locArray.add(new LocationObject(curLoc, semLocConfig, isDefault));
            }
        }
        return isThisInherit;
    }

    public static DefaultMutableTreeNode getGroupLocationTree(boolean excludeReadonly) throws ConsoleException {
        TimeCounter tcgetGroupsRoot = new TimeCounter();
        DefaultMutableTreeNode grpNode = GroupHandler.getGroupsRoot(false, excludeReadonly);
        if (grpNode == null) {
            return new DefaultMutableTreeNode();
        }
        ConsoleLogger.log("PolicyHandler: getGroupsRoot>>" + tcgetGroupsRoot.toString());
        HashMap<String, TopLevelObject> locationMap = DataobjectManager.getInstance().getAllGroupLocations();
        TimeCounter tcList = new TimeCounter();
        ArrayList<DefaultMutableTreeNode> nodeList = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> nodeListIterator = grpNode.breadthFirstEnumeration();
        while (nodeListIterator.hasMoreElements()) {
            nodeList.add((DefaultMutableTreeNode)nodeListIterator.nextElement());
        }
        ConsoleLogger.log("PolicyHandler: Collections.list()>>" + tcList.toString());
        TimeCounter tcIterate = new TimeCounter();
        for (DefaultMutableTreeNode aNode : nodeList) {
            GroupObject grpObj = (GroupObject)aNode.getUserObject();
            String grpPolicyGUID = grpObj.getSemClientGroup().getObjReference().getTargetId();
            boolean hasAccess = grpObj.canDirectiveSelectable();
            boolean isThisInherit = PolicyHandler.getLocations(grpPolicyGUID, aNode, locationMap, grpObj);
            grpObj.setInherited(isThisInherit);
            grpObj.setDirectiveSelectable(hasAccess && !isThisInherit);
            grpObj.setIndirectiveSelectable(PolicyUtil.getRecursiveIndirectiveSelectableForReadonlyGroups(aNode));
        }
        ConsoleLogger.log("PolicyHandler: while/iteratre>>" + tcIterate.toString());
        TimeCounter tcInherite = new TimeCounter();
        PolicyHandler.setInheritedGroupsLocations(grpNode);
        ConsoleLogger.log("PolicyHandler: inherite>>" + tcInherite.toString());
        return grpNode;
    }

    public static void setInheritedGroupsLocations(DefaultMutableTreeNode currentNode) throws ConsoleException {
        if (currentNode == null) {
            return;
        }
        if (currentNode.getUserObject() instanceof LocationObject) {
            return;
        }
        GroupObject grpObj = (GroupObject)currentNode.getUserObject();
        if (grpObj.isInherited()) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentNode.getParent();
            for (int i = 0; parentNode != null && i < parentNode.getChildCount(); ++i) {
                DefaultMutableTreeNode parentChild = (DefaultMutableTreeNode)parentNode.getChildAt(i);
                if (!(parentChild.getUserObject() instanceof LocationObject)) continue;
                LocationObject parentLocation = (LocationObject)parentChild.getUserObject();
                LocationObject location = PolicyHandler.createLocationObjectForInherited(parentLocation);
                currentNode.add(new DefaultMutableTreeNode(location));
            }
        }
        for (int i = 0; i < currentNode.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)currentNode.getChildAt(i);
            if (!(childNode.getUserObject() instanceof GroupObject)) continue;
            PolicyHandler.setInheritedGroupsLocations(childNode);
        }
    }

    private static LocationObject createLocationObjectForInherited(LocationObject parentLocObject) throws ConsoleException {
        try {
            Location location = parentLocObject.getLocationObject();
            SemLocationConfig semLocConfig = parentLocObject.getSemLocationConfigObj();
            boolean isDefault = parentLocObject.isDefault();
            LocationObject newLocObj = new LocationObject(location, semLocConfig, isDefault);
            newLocObj.setDirectiveSelectable(false);
            return newLocObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    private static boolean getLocations(String grpPolicyGUID, DefaultMutableTreeNode aNode, HashMap<String, TopLevelObject> locationMap, GroupObject grpObj) throws ConsoleException {
        boolean isThisInherit = true;
        SemGroupPolicy semGroupPolicy = (SemGroupPolicy)locationMap.get(grpPolicyGUID);
        if (semGroupPolicy == null) {
            return isThisInherit;
        }
        ObjReference reference = semGroupPolicy.getObjReferenceByType("SemAgentPolicy");
        if (reference == null) {
            return isThisInherit;
        }
        Inheritance inheritance = semGroupPolicy.getInheritance();
        if (inheritance != null) {
            isThisInherit = inheritance.getMode().equals(Inheritance.USE_PARENT);
        }
        SemAgentPolicy semAgentPolicy = (SemAgentPolicy)locationMap.get(reference.getTargetId());
        if (!isThisInherit && semAgentPolicy != null) {
            AutoLocation auLocation = semAgentPolicy.getAutoLocation();
            LocationArray locArrayObj = auLocation.getLocationArray();
            String defLocation = locArrayObj.getDefaultLocation();
            boolean hasFullAccess = grpObj.getAccessConstraint() == 0;
            for (Location curLoc : locArrayObj.getLocation()) {
                boolean isDefault = PolicyHandler.isDefaultLocation(curLoc, defLocation);
                ObjReference refer = curLoc.getObjReference();
                SemLocationConfig semLocConfig = (SemLocationConfig)locationMap.get(refer.getTargetId());
                if (semLocConfig == null) {
                    ConsoleLogger.log("Missing SemLocationConfig object, ID=" + refer.getTargetId());
                    continue;
                }
                LocationObject locObj = new LocationObject(curLoc, semLocConfig, isDefault);
                if (!hasFullAccess) {
                    locObj.setDirectiveSelectable(false);
                    locObj.setIndirectiveSelectable(false);
                }
                aNode.add(new DefaultMutableTreeNode(locObj));
            }
        }
        return isThisInherit;
    }

    public static String getFullPathOfNode(DefaultMutableTreeNode node) {
        StringBuffer buffer = new StringBuffer();
        TreeNode[] allNodes = node.getPath();
        for (int i = 0; i < allNodes.length; ++i) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)allNodes[i];
            Object obj = aNode.getUserObject();
            if (obj instanceof GroupObject) {
                if (buffer.length() > 0) {
                    buffer.append("\\");
                }
                buffer.append(((GroupObject)obj).getName());
                continue;
            }
            if (!(obj instanceof LocationObject)) continue;
            buffer.append(":" + ((LocationObject)obj).getName());
        }
        return buffer.toString();
    }

    public static TopLevelObject getObjectFromDB(String objType, String objID) throws ConsoleException {
        return DataobjectManager.getInstance().getObjectByGUID(objType, objID);
    }

    public static TopLevelObject getObjectFromDB(String objType, String objID, boolean forceRefresh) throws ConsoleException {
        return DataobjectManager.getInstance().getObjectByGUID(objType, objID, forceRefresh);
    }

    public static TopLevelObject getObject(String objType, String objID) throws ConsoleException {
        TopLevelObject obj = null;
        obj = changedObjectPool.get(objID);
        if (obj == null) {
            obj = newObjectPool.get(objID);
        }
        if (obj == null) {
            obj = DataobjectManager.getInstance().getObjectByGUID(objType, objID);
        }
        return (TopLevelObject)PolicyHandler.getCopyOfObj((ConfigObject)obj);
    }

    public static TopLevelObject getObjectWithoutCopy(String objType, String objID) throws ConsoleException {
        TopLevelObject obj = null;
        obj = changedObjectPool.get(objID);
        if (obj == null) {
            obj = newObjectPool.get(objID);
        }
        if (obj == null) {
            obj = DataobjectManager.getInstance().getObjectByGUID(objType, objID);
        }
        return obj;
    }

    public static String getGroupPathFromFullPath(String fullpath) {
        int pos = fullpath.lastIndexOf(58);
        if (pos != -1) {
            return fullpath.substring(0, pos);
        }
        return fullpath;
    }

    public static String getLocationNameFromFullPath(String fullpath) {
        int pos = fullpath.lastIndexOf(58);
        if (pos != -1) {
            return fullpath.substring(pos + 1);
        }
        return "";
    }

    public static int getLearnedApplicationCount(RpcData rpc) throws ConsoleException {
        SemTable aTable = GUIManager.getRecord(750, rpc, "SemApplication", 0, Integer.MAX_VALUE);
        Vector application = aTable.getSemApplication();
        int lenComputer = application.size();
        if (lenComputer == 0) {
            return 0;
        }
        int count = 0;
        try {
            count = Integer.parseInt(((SemApplication)application.get(0)).getAppHash());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        System.err.println("Mycount: " + count);
        return count;
    }

    public static ArrayList<LearnedApplicationObject> getLearnedApplication(int sqlType, RpcData rpc, int nStart, int nCount) throws ConsoleException {
        ArrayList<LearnedApplicationObject> v = new ArrayList<LearnedApplicationObject>();
        SemTable aTable = GUIManager.getRecord(sqlType, rpc, "SemApplication", nStart, nCount);
        for (SemApplication semApplication : aTable.getSemApplication()) {
            LearnedApplicationObject computer = new LearnedApplicationObject(semApplication);
            v.add(computer);
        }
        return v;
    }

    public static ArrayList<DetectedProcessUIObject> getHPPApplication(int value, String applicationName) throws ConsoleException {
        ArrayList<DetectedProcessUIObject> v = new ArrayList<DetectedProcessUIObject>();
        String domainId = Manager.getCurrentDomainId();
        String idGroup = PolicyHandler.findDomainID().trim();
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)domainId);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID_LIST", (String)idGroup);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"NAME", (String)applicationName);
        int sqlQueryType = 1500;
        switch (value) {
            case 0: {
                break;
            }
            case 1: {
                sqlQueryType = 1501;
                break;
            }
            case 2: {
                sqlQueryType = 1502;
                break;
            }
            default: {
                sqlQueryType = 1500;
            }
        }
        SemTable semTable = GUIManager.getSemTable(sqlQueryType, rpc, -1, -1);
        try {
            int rowCount = semTable.getSemTableRowCount();
            long fileSizeLong = 0L;
            for (int i = 0; i < rowCount; ++i) {
                DetectedProcessUIObject dProcess;
                String alt_hashType;
                String filePath = semTable.getSemTableRow(i).getSemTableValue(0).getValue();
                String fileHash = semTable.getSemTableRow(i).getSemTableValue(1).getValue();
                String companyName = semTable.getSemTableRow(i).getSemTableValue(2).getValue();
                String productName = semTable.getSemTableRow(i).getSemTableValue(3).getValue();
                String fileSize = semTable.getSemTableRow(i).getSemTableValue(5).getValue();
                try {
                    fileSizeLong = Long.parseLong(fileSize);
                }
                catch (NumberFormatException e) {
                    fileSizeLong = 0L;
                    ConsoleLogger.log("Invalid file size value: [" + fileSize + "]");
                    ConsoleLogger.log(e);
                }
                String hashType = semTable.getSemTableRow(i).getSemTableValue(6).getValue();
                String alt_fileHash = semTable.getSemTableRow(i).getSemTableValue(7).getValue();
                String string = alt_hashType = "1".equals(hashType) ? "2" : "1";
                if ("1".equals(hashType)) {
                    if (alt_fileHash != null && alt_fileHash.length() > 0) {
                        dProcess = new DetectedProcessUIObject(alt_hashType + ":" + alt_fileHash, hashType + ":" + fileHash, productName, filePath, companyName, fileSizeLong);
                        v.add(dProcess);
                    } else {
                        dProcess = new DetectedProcessUIObject(hashType + ":" + fileHash, null, productName, filePath, companyName, fileSizeLong);
                        v.add(dProcess);
                    }
                }
                if (!"2".equals(hashType)) continue;
                if (alt_fileHash != null && alt_fileHash.length() > 0) {
                    dProcess = new DetectedProcessUIObject(hashType + ":" + fileHash, alt_hashType + ":" + alt_fileHash, productName, filePath, companyName, fileSizeLong);
                    v.add(dProcess);
                    continue;
                }
                dProcess = new DetectedProcessUIObject(hashType + ":" + fileHash, null, productName, filePath, companyName, fileSizeLong);
                v.add(dProcess);
            }
        }
        catch (Exception e) {
            ConsoleLogger.log(e);
            throw new ConsoleException(e);
        }
        return v;
    }

    static int getKnownSecurityUIObjectRating(int kType) {
        int rating;
        switch (kType) {
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                rating = 5;
                break;
            }
            default: {
                rating = 3;
            }
        }
        return rating;
    }

    static boolean filterKnownSecurityUIObject(SemTable semTable, int row) {
        String pvid = semTable.getSemTableRow(row).getSemTableValue(0).getValue();
        if (StringUtilities.isEmpty((String)pvid) || pvid.equals("0")) {
            return true;
        }
        String virusName = semTable.getSemTableRow(row).getSemTableValue(1).getValue().toUpperCase(Locale.ENGLISH);
        if (!ExceptionPolicyUtility.isValidKnownRisk((String)pvid, (String)virusName)) {
            return true;
        }
        String type = semTable.getSemTableRow(row).getSemTableValue(2).getValue();
        return StringUtilities.isEmpty((String)type);
    }

    static String getSubCategoryStr(String subCategory) {
        if (StringUtilities.isEmpty((String)subCategory)) {
            MessageResources msgRes = MessageResources.getInstance();
            subCategory = msgRes.getString("com.sygate.scm.console.handler.handler", "PolicyHandler.Unknown");
        }
        return subCategory;
    }

    static String getDependencyStr(String dependency) {
        if ("-1".equals(dependency)) {
            dependency = "";
        }
        return dependency;
    }

    static void processKnownSecurityUIObject(int rowCount, SemTable semTable, ArrayList<KnownSecurityUIObject> lKnownSecurityUIObject) {
        for (int i = 0; i < rowCount; ++i) {
            if (PolicyHandler.filterKnownSecurityUIObject(semTable, i)) continue;
            String pvid = semTable.getSemTableRow(i).getSemTableValue(0).getValue();
            String virusName = semTable.getSemTableRow(i).getSemTableValue(1).getValue();
            String type = semTable.getSemTableRow(i).getSemTableValue(2).getValue();
            String performance = semTable.getSemTableRow(i).getSemTableValue(5).getValue();
            String privacy = semTable.getSemTableRow(i).getSemTableValue(6).getValue();
            String overall = semTable.getSemTableRow(i).getSemTableValue(8).getValue();
            String stealth = semTable.getSemTableRow(i).getSemTableValue(3).getValue();
            String removal = semTable.getSemTableRow(i).getSemTableValue(4).getValue();
            String dependency = PolicyHandler.getDependencyStr(semTable.getSemTableRow(i).getSemTableValue(7).getValue());
            String subCategory = PolicyHandler.getSubCategoryStr(semTable.getSemTableRow(i).getSemTableValue(9).getValue());
            int kType = Utility.parseInt((String)type, (int)1);
            int rating = PolicyHandler.getKnownSecurityUIObjectRating(kType);
            int kPerformance = Utility.parseInt((String)performance, (int)0);
            int kPrivacy = Utility.parseInt((String)privacy, (int)0);
            int kOverall = Utility.parseInt((String)overall, (int)0);
            int kStealth = Utility.parseInt((String)stealth, (int)0);
            int kRemoval = Utility.parseInt((String)removal, (int)0);
            performance = PolicyHandler.getRatingStringFromValue(kPerformance, rating);
            privacy = PolicyHandler.getRatingStringFromValue(kPrivacy, rating);
            overall = PolicyHandler.getRatingStringFromValue(kOverall, rating);
            stealth = PolicyHandler.getRatingStringFromValue(kStealth, rating);
            removal = PolicyHandler.getRatingStringFromValue(kRemoval, rating);
            KnownSecurityUIObject dProcess = new KnownSecurityUIObject(pvid, virusName, subCategory, overall, privacy, performance, stealth, removal, dependency);
            lKnownSecurityUIObject.add(dProcess);
        }
    }

    public static ArrayList<KnownSecurityUIObject> getKnownSecurityRisks() throws ConsoleException {
        ArrayList<KnownSecurityUIObject> v = new ArrayList<KnownSecurityUIObject>();
        int[] aTotalRow = new int[1];
        int totalRows = Integer.MAX_VALUE;
        int rowsRecieved = 0;
        int rowCount = 0;
        int localeId = LocaleManipulationUtility.getLocaleCultureID((Locale)Locale.getDefault());
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)("" + localeId));
        int start = 0;
        while (rowsRecieved < totalRows) {
            SemTable semTable = GUIManager.getSemTable(1300, rpc, start, Integer.MAX_VALUE, aTotalRow);
            totalRows = aTotalRow[0];
            rowCount = semTable.getSemTableRowCount();
            rowsRecieved = rowCount + start;
            PolicyHandler.processKnownSecurityUIObject(rowCount, semTable, v);
            start += rowCount;
        }
        return v;
    }

    private static String getRatingStringFromValue(int ratingValue, int defaultRating) {
        String ratingStr = "";
        if (ratingValue < 0) {
            ratingValue = defaultRating;
        }
        ratingStr = ratingValue == 0 ? GEHStaticTypes.NONE : (ratingValue < 3 ? GEHStaticTypes.LOW : (ratingValue < 4 ? GEHStaticTypes.MEDIUM : GEHStaticTypes.HIGH));
        return ratingStr;
    }

    private static String findDomainID() {
        StringBuffer groupIDString = new StringBuffer();
        String domainID = Manager.getCurrentDomainId();
        DataobjectManager data = DataobjectManager.getInstance();
        try {
            SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", domainID);
            String cgtGUID = domain.getObjReference().getTargetId();
            SemClientGroupTree cgt = (SemClientGroupTree)data.getObjectByGUID("SemClientGroupTree", cgtGUID, true);
            SemClientGroup rootcg = cgt.getSemClientGroup();
            GroupObject global = new GroupObject(rootcg);
            ArrayList<String> list = new ArrayList<String>();
            PolicyHandler.retrieveAllGroups(global, list);
            for (int i = 0; i < list.size(); ++i) {
                groupIDString.append(list.get(i));
                if (i >= list.size() - 1) continue;
                groupIDString.append(", ");
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return groupIDString.toString();
    }

    private static void retrieveAllGroups(GroupObject startGroup, ArrayList<String> list) throws ConsoleException {
        Vector<SemClientGroup> groups;
        if (startGroup == null || list == null) {
            return;
        }
        AdminPrivilegeObject adminPrivilege = null;
        String domainID = Manager.getCurrentDomainId();
        DataobjectManager data = DataobjectManager.getInstance();
        if (domainID != null && data.getLoginInformation() != null) {
            AdminObject admin = AdminObject.retrieveCurrentAdminObject();
            if (admin.isSysAdmin() || admin.isDomainSysAdmin()) {
                list.add(startGroup.getId());
            } else {
                adminPrivilege = admin.getAdminPrivilege();
                if (adminPrivilege.hasAccessRightToGroup(startGroup.getId(), true)) {
                    list.add(startGroup.getId());
                }
            }
        }
        if ((groups = startGroup.getChildrenGroups()) == null) {
            return;
        }
        for (SemClientGroup group : groups) {
            PolicyHandler.retrieveAllGroups(new GroupObject(group), list);
        }
    }

    public static boolean isApplicationExisted(ExcludedAppArray array, Executable exeFile) {
        if (exeFile == null) {
            return true;
        }
        Vector allApp = array.getExecutable();
        for (int i = 0; i < allApp.size(); ++i) {
            if (!PolicyHandler.compareTwoExecutableObj((Executable)allApp.get(i), exeFile)) continue;
            return true;
        }
        return false;
    }

    public static boolean compareTwoExecutableObj(Executable obj1, Executable obj2) {
        if (PolicyHandler.compareTwoObject(obj1.getOptType(), obj2.getOptType()) != 0) {
            return false;
        }
        if (PolicyHandler.compareTwoObject(obj1.getOptFileName(), obj2.getOptFileName()) != 0) {
            return false;
        }
        if (PolicyHandler.compareTwoObject(obj1.getOptFileDescription(), obj2.getOptFileDescription()) != 0) {
            return false;
        }
        if (PolicyHandler.compareTwoObject(obj1.getOptVersion(), obj2.getOptVersion()) != 0) {
            return false;
        }
        if (PolicyHandler.compareTwoObject(obj1.getOptFileSize(), obj2.getOptFileSize()) != 0) {
            return false;
        }
        if (PolicyHandler.compareTwoObject(obj1.getOptFileLastModifiedDate(), obj2.getOptFileLastModifiedDate()) != 0) {
            return false;
        }
        if (PolicyHandler.compareTwoObject(obj1.getOptFileMd5Checksum(), obj2.getOptFileMd5Checksum()) != 0) {
            return false;
        }
        return PolicyHandler.compareTwoObject(obj1.getOptFileSHA256Checksum(), obj2.getOptFileSHA256Checksum()) == 0;
    }

    public static <T extends Comparable<T>> int compareTwoObject(T str1, T str2) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    public static ComputerInfoObject[] getAllComputerInfoForLearnedApp(String appId, ArrayList<GroupObject> groupList) throws ConsoleException {
        if (groupList == null || groupList.size() == 0) {
            return null;
        }
        String domainId = DataobjectManager.getInstance().getLoginInformation().getOptDomainGUID();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < groupList.size(); ++i) {
            buf.append("," + groupList.get(i).getId());
        }
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID", (String)appId);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"DOMAIN_ID", (String)domainId);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID_LIST", (String)buf.substring(1));
        SemTable aTable = GUIManager.getRecord(200, rpc, "SemApplication", 0, Integer.MAX_VALUE);
        Vector application = aTable.getSemApplication();
        ComputerInfoObject[] allObj = new ComputerInfoObject[application.size()];
        for (int i = 0; i < allObj.length; ++i) {
            SemApplication app = (SemApplication)application.get(i);
            String comName = app.getApplicationName();
            String gId = app.getAppHash();
            String desc = app.getOptAppDescription();
            String domain = app.getOptApplicationPath();
            String locName = app.getChecksum();
            String gName = PolicyHandler.getGroupFullPathByID(gId);
            allObj[i] = new ComputerInfoObject(comName, gName, desc, domain, locName);
        }
        return allObj;
    }

    public static String getGroupFullPathByID(String id) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", data.getLoginInformation().getOptDomainGUID());
        String cgtGUID = domain.getObjReference().getTargetId();
        SemClientGroupTree cgt = (SemClientGroupTree)data.getObjectByGUID("SemClientGroupTree", cgtGUID);
        SemClientGroup rootgroup = cgt.getSemClientGroup();
        String group = PolicyHandler.getGroupFullPathByID(rootgroup, rootgroup.getName(), id);
        return group;
    }

    public static String getGroupFullPathByID(SemClientGroup curGroup, String curPath, String id) {
        if (curGroup == null) {
            return null;
        }
        if (curGroup.getId().equals(id)) {
            return curPath;
        }
        Vector children = curGroup.getSemClientGroup();
        int len = children.size();
        if (len == 0) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            String newPath;
            SemClientGroup client = (SemClientGroup)children.get(i);
            String path = PolicyHandler.getGroupFullPathByID(client, newPath = curPath + "\\" + client.getName(), id);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    public static String[] getAllSemLocConfigId(SemAgentPolicy semAgent) {
        AutoLocation auto = semAgent.getAutoLocation();
        LocationArray locArray = auto.getLocationArray();
        Vector allLoc = locArray.getLocation();
        String[] allId = new String[allLoc.size()];
        for (int i = 0; i < allId.length; ++i) {
            ObjReference objRef = ((Location)allLoc.get(i)).getObjReference();
            allId[i] = objRef.getTargetId();
        }
        return allId;
    }

    public static ObjReference getSemAgentPolicyReference(SemGroupPolicy semGrpPolicy) {
        for (ObjReference objRef : semGrpPolicy.getObjReference()) {
            if (!objRef.getTargetType().equals("SemAgentPolicy")) continue;
            return objRef;
        }
        return null;
    }

    public static void clearAllObjectPool() {
        newObjectPool.clear();
        changedObjectPool.clear();
    }

    public static void popUpWarningForCopy(String policyName) {
        if (!AdminObject.retrieveCurrentAdminObject().isDisableCopyPolicyReminder()) {
            new CopyDialog(policyName).setVisible(true);
        }
    }

    public static void copyPolicy(ObjReference appliedPolicy, ObjReference localPolicy, PolicyInt policyObj) {
        PolicyHandler.popUpWarningForCopy(policyObj.getName());
        copiedPolicy = new PolicyReferenceObject(appliedPolicy, localPolicy);
        if (!isInCopy) {
            isInCopy = true;
            PolicyHandler.copyObject((CopitableObject)((Object)policyObj));
            isInCopy = false;
        }
    }

    public static PolicyReferenceObject getCopiedPolicy() {
        return copiedPolicy;
    }

    public static void deleteObject(TopLevelObject object, Map<String, TopLevelObject> deletedSet, Map<String, TopLevelObject> newSet, Map<String, TopLevelObject> updatedSet) {
        String key = object.getId();
        if (newSet.containsKey(key)) {
            newSet.remove(key);
        } else {
            if (updatedSet.containsKey(key)) {
                updatedSet.remove(key);
            }
            deletedSet.put(key, object);
        }
    }

    public static void updateObject(TopLevelObject object, Map<String, TopLevelObject> newSet, Map<String, TopLevelObject> updatedSet) {
        String key = object.getId();
        if (newSet.containsKey(key)) {
            newSet.put(key, object);
        } else {
            updatedSet.put(key, object);
        }
    }

    public static void dumpObjects(Map<String, TopLevelObject> from, Map<String, TopLevelObject> to) {
        for (Map.Entry<String, TopLevelObject> entry : from.entrySet()) {
            to.put(entry.getKey(), entry.getValue());
        }
    }

    public static void dumpObjects(Set<TopLevelObject> from, Map<String, TopLevelObject> to) {
        for (TopLevelObject obj : from) {
            to.put(obj.getId(), obj);
        }
    }

    public static int getRealIndexOfScriptBlock(Vector<HiScriptBlock> scriptBlock, int index) {
        int realIndex = 0;
        int indexCnt = 0;
        Iterator<HiScriptBlock> it = scriptBlock.iterator();
        while (it.hasNext() && indexCnt < index) {
            HiScriptBlock block = it.next();
            HiIF ifN = block.getOptHiIF();
            indexCnt = ifN != null ? (ifN.getOptHiELSE() != null ? (indexCnt += 4) : (indexCnt += 3)) : ++indexCnt;
            ++realIndex;
        }
        if (indexCnt < index) {
            ++realIndex;
        }
        return realIndex;
    }

    public static CopitableObject getCopiedObject() {
        return copiedObject;
    }

    public static void clearCopiedObject() {
        copiedObject = null;
        copiedPolicy = null;
    }

    public static void addMacAddress(String macAddress) {
        if (macAddress == null || macAddress.trim().length() == 0) {
            return;
        }
        macAddressPool.add(macAddress);
    }

    public static void deleteMacAddress(String macAddress) {
        macAddressPool.remove(macAddress);
    }

    public static Set<String> getMacAddresses() {
        return macAddressPool;
    }

    public static int getIndexOfValueFromList(long curValue, long[] valueList) {
        if (curValue == 0L) {
            return 0;
        }
        for (int i = valueList.length - 1; i > 0; --i) {
            if (curValue % valueList[i] != 0L) continue;
            return i;
        }
        return 0;
    }

    public static int getIndexOfValue(Integer curValue, Integer[] valueList) {
        for (int i = 0; i < valueList.length; ++i) {
            if (!curValue.equals(valueList[i])) continue;
            return i;
        }
        return -1;
    }

    public static GUID getOwnerOfObject(ConfigObject _location) {
        TopLevelObject topObj = _location.getTopLevelObject();
        MetadataAttributes topMeta = topObj.getMetadataAttributes();
        GUID owner = topMeta.getOwner();
        if (owner == null || owner.toString().length() == 0) {
            owner = new GUID(topObj.getId());
        }
        return owner;
    }

    public static void addNewObject(TopLevelObject obj) {
        String id = obj.getId();
        if (changedObjectPool.containsKey(id)) {
            changedObjectPool.put(id, obj);
        } else {
            newObjectPool.put(id, obj);
        }
    }

    public static String adjustName(String name, List<String> nameList, int maxLength) {
        Integer number;
        TreeSet<Integer> numberList = new TreeSet<Integer>();
        if (nameList != null) {
            for (int i = 0; i < nameList.size(); ++i) {
                String curName = nameList.get(i);
                if (!curName.startsWith(name)) continue;
                int pos = name.length();
                if (pos == curName.length()) {
                    numberList.add(1);
                    continue;
                }
                if (!curName.substring(pos, pos + 1).equals(" ")) continue;
                try {
                    String numStr = curName.substring(pos + 1);
                    int number2 = Integer.parseInt(numStr);
                    numberList.add(number2);
                    continue;
                }
                catch (NumberFormatException numStr) {
                    // empty catch block
                }
            }
        }
        int max = 0;
        Iterator it = numberList.iterator();
        while (it.hasNext() && max + 1 == (number = (Integer)it.next())) {
            ++max;
        }
        Object newName = name;
        if (max > 0 && ((String)(newName = name + " " + (max + 1))).length() > maxLength) {
            String append = " " + (max + 1);
            newName = name.substring(0, maxLength - append.length());
            return PolicyHandler.adjustName((String)newName, nameList, maxLength);
        }
        return newName;
    }

    public static SemLocationConfig getDefaultSemLocationConfig(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        SemLocationConfig defaultSemLocationConfig = defaultSchemaObject.getDefaultSemLocationConfig();
        if (defaultSemLocationConfig != null) {
            WashIDHandler washer = new WashIDHandler();
            SemLocationConfig newLoc = (SemLocationConfig)washer.duplicateObject((ConfigObject)defaultSemLocationConfig, newObjList);
            return newLoc;
        }
        return null;
    }

    public static FwFirewallPolicy getDefaultFirewallPolicy(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        FwFirewallPolicy defaultFirewallPolicy = defaultSchemaObject.getDefaultFirewallPolicy();
        if (defaultFirewallPolicy != null) {
            SecuritySetting securitySetting;
            FwIDS ids;
            PolicyHandler.replaceFirewallPolicyLinks(defaultFirewallPolicy);
            WashIDHandler washer = new WashIDHandler();
            FwFirewallPolicy newLoc = (FwFirewallPolicy)washer.duplicateObject((ConfigObject)defaultFirewallPolicy, newObjList);
            LicenseObject licenseObj = LicenseObject.getInstance();
            if (!licenseObj.isIntrusionPreventionEnabled() && (ids = (securitySetting = newLoc.getSecuritySetting()).getOptFwIDS()) != null) {
                ids.setOptEnable(Boolean.FALSE);
            }
            return newLoc;
        }
        return null;
    }

    public static AvPolicy getDefaultAvPolicy(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        AvPolicy defaultAvPolicy = defaultSchemaObject.getDefaultAvPolicy();
        if (defaultAvPolicy != null) {
            LinuxAvScanPolicy linuxAvScanPolicy;
            MetadataAttributes mda;
            MacAdminDefinedScan newads;
            WashIDHandler washer;
            MacAdminDefinedScan ads;
            MacAvScanPolicy macAVScanPolicy;
            AvPolicy newAvPolicy = (AvPolicy)PolicyHandler.getCopyOfObj((ConfigObject)defaultAvPolicy);
            String newID = new GUIDGenerator().getGUIDString();
            newAvPolicy.setId(newID);
            AvScanPolicy avScanPolicy = newAvPolicy.getOptAvScanPolicy();
            if (avScanPolicy != null) {
                ObjReference obj;
                for (ObjReference ref : avScanPolicy.getObjReference()) {
                    if (ref == null) continue;
                    AdminDefinedScan ads2 = (AdminDefinedScan)defaultSchemaObject.getAvAdminDefinedScanMap().get(ref.getTargetId());
                    WashIDHandler washer2 = new WashIDHandler();
                    AdminDefinedScan newads2 = (AdminDefinedScan)washer2.duplicateObject((ConfigObject)ads2, newObjList);
                    newID = new GUIDGenerator().getGUIDString();
                    newads2.setId(newID);
                    MetadataAttributes mda2 = new MetadataAttributes();
                    mda2.setOwner(new GUID(newAvPolicy.getId()));
                    newads2.setMetadataAttributes(mda2);
                    newObjList.put(newID, (TopLevelObject)newads2);
                    PolicyHandler.addNewObject((TopLevelObject)newads2);
                    ref.setTargetId(newads2.getId());
                    ref.setTargetType(newads2.getObjectTypeName());
                    ref.setName(ref.getName());
                }
                CommandScan cmdScan = avScanPolicy.getCommandScan();
                if (cmdScan != null && (obj = cmdScan.getObjReference()) != null) {
                    String name = obj.getName();
                    AdminDefinedScan ads3 = (AdminDefinedScan)defaultSchemaObject.getAvAdminDefinedScanMap().get(obj.getTargetId());
                    WashIDHandler washer3 = new WashIDHandler();
                    AdminDefinedScan newads3 = (AdminDefinedScan)washer3.duplicateObject((ConfigObject)ads3, newObjList);
                    newID = new GUIDGenerator().getGUIDString();
                    newads3.setId(newID);
                    MetadataAttributes mda3 = new MetadataAttributes();
                    mda3.setOwner(new GUID(newAvPolicy.getId()));
                    newads3.setMetadataAttributes(mda3);
                    newObjList.put(newID, (TopLevelObject)newads3);
                    PolicyHandler.addNewObject((TopLevelObject)newads3);
                    obj.setTargetId(newads3.getId());
                    obj.setTargetType(newads3.getObjectTypeName());
                    obj.setName(name);
                }
            }
            if ((macAVScanPolicy = newAvPolicy.getOptMacAvScanPolicy()) != null) {
                ObjReference obj;
                String name;
                for (ObjReference ref : macAVScanPolicy.getObjReference()) {
                    if (ref == null) continue;
                    name = ref.getName();
                    ads = (MacAdminDefinedScan)defaultSchemaObject.getAvMacintoshAdminDefinedScanMap().get(ref.getTargetId());
                    washer = new WashIDHandler();
                    newads = (MacAdminDefinedScan)washer.duplicateObject((ConfigObject)ads, newObjList);
                    newID = new GUIDGenerator().getGUIDString();
                    newads.setId(newID);
                    mda = new MetadataAttributes();
                    mda.setOwner(new GUID(newAvPolicy.getId()));
                    newads.setMetadataAttributes(mda);
                    newObjList.put(newID, (TopLevelObject)newads);
                    PolicyHandler.addNewObject((TopLevelObject)newads);
                    ref.setTargetId(newads.getId());
                    ref.setTargetType(newads.getObjectTypeName());
                    ref.setName(name);
                }
                MacCommandScan macCmdScan = macAVScanPolicy.getOptMacCommandScan();
                if (macCmdScan != null && (obj = macCmdScan.getOptObjReference()) != null) {
                    name = obj.getName();
                    ads = (MacAdminDefinedScan)defaultSchemaObject.getAvMacintoshAdminDefinedScanMap().get(obj.getTargetId());
                    washer = new WashIDHandler();
                    newads = (MacAdminDefinedScan)washer.duplicateObject((ConfigObject)ads, newObjList);
                    newID = new GUIDGenerator().getGUIDString();
                    newads.setId(newID);
                    mda = new MetadataAttributes();
                    mda.setOwner(new GUID(newAvPolicy.getId()));
                    newads.setMetadataAttributes(mda);
                    newObjList.put(newID, (TopLevelObject)newads);
                    PolicyHandler.addNewObject((TopLevelObject)newads);
                    obj.setTargetId(newads.getId());
                    obj.setTargetType(newads.getObjectTypeName());
                    obj.setName(name);
                }
            }
            if ((linuxAvScanPolicy = newAvPolicy.getOptLinuxAvScanPolicy()) != null) {
                ObjReference obj;
                for (ObjReference ref : linuxAvScanPolicy.getObjReference()) {
                    if (ref == null) continue;
                    ads = (LinuxAdminDefinedScan)defaultSchemaObject.getAvLinuxAdminDefinedScanMap().get(ref.getTargetId());
                    washer = new WashIDHandler();
                    newads = (LinuxAdminDefinedScan)washer.duplicateObject((ConfigObject)ads, newObjList);
                    newID = new GUIDGenerator().getGUIDString();
                    newads.setId(newID);
                    mda = new MetadataAttributes();
                    mda.setOwner(new GUID(newAvPolicy.getId()));
                    newads.setMetadataAttributes(mda);
                    newObjList.put(newID, (TopLevelObject)newads);
                    PolicyHandler.addNewObject((TopLevelObject)newads);
                    ref.setTargetId(newads.getId());
                    ref.setTargetType(newads.getObjectTypeName());
                    ref.setName(ref.getName());
                }
                CommandScan cmdScan = linuxAvScanPolicy.getOptCommandScan();
                if (cmdScan != null && (obj = cmdScan.getObjReference()) != null) {
                    String name = obj.getName();
                    LinuxAdminDefinedScan ads4 = (LinuxAdminDefinedScan)defaultSchemaObject.getAvLinuxAdminDefinedScanMap().get(obj.getTargetId());
                    WashIDHandler washer4 = new WashIDHandler();
                    LinuxAdminDefinedScan newads4 = (LinuxAdminDefinedScan)washer4.duplicateObject((ConfigObject)ads4, newObjList);
                    newID = new GUIDGenerator().getGUIDString();
                    newads4.setId(newID);
                    MetadataAttributes mda4 = new MetadataAttributes();
                    mda4.setOwner(new GUID(newAvPolicy.getId()));
                    newads4.setMetadataAttributes(mda4);
                    newObjList.put(newID, (TopLevelObject)newads4);
                    PolicyHandler.addNewObject((TopLevelObject)newads4);
                    obj.setTargetId(newads4.getId());
                    obj.setTargetType(newads4.getObjectTypeName());
                    obj.setName(name);
                }
            }
            return newAvPolicy;
        }
        return null;
    }

    public static AdminDefinedScan getDefaultAdminDefinedScan() throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        HashMap<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();
        Set entrySet = defaultSchemaObject.getAvAdminDefinedScanMap().entrySet();
        for (Map.Entry entry : entrySet) {
            MetadataAttributes attribute = ((AdminDefinedScan)entry.getValue()).getMetadataAttributes();
            if (attribute != null && attribute.getOwner() != null) continue;
            WashIDHandler washer = new WashIDHandler();
            AdminDefinedScan newads = (AdminDefinedScan)washer.duplicateObject((ConfigObject)entry.getValue(), newObjList);
            newads.setId(new GUIDGenerator().getGUIDString());
            return newads;
        }
        return null;
    }

    public static LinuxAdminDefinedScan getDefaultLinuxAdminDefinedScan() throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        HashMap<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();
        Set entrySet = defaultSchemaObject.getAvLinuxAdminDefinedScanMap().entrySet();
        for (Map.Entry entry : entrySet) {
            MetadataAttributes attribute = ((LinuxAdminDefinedScan)entry.getValue()).getMetadataAttributes();
            if (attribute != null && attribute.getOwner() != null) continue;
            WashIDHandler washer = new WashIDHandler();
            LinuxAdminDefinedScan newads = (LinuxAdminDefinedScan)washer.duplicateObject((ConfigObject)entry.getValue(), newObjList);
            newads.setId(new GUIDGenerator().getGUIDString());
            return newads;
        }
        return null;
    }

    public static AdminDefinedScan getDefaultCommandScan() throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        AdminDefinedScan newads = null;
        AvPolicy defaultAvPolicy = defaultSchemaObject.getDefaultAvPolicy();
        if (defaultAvPolicy != null) {
            ObjReference ref;
            HashMap<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();
            AvScanPolicy avScanPolicy = defaultAvPolicy.getOptAvScanPolicy();
            if (avScanPolicy != null && (ref = avScanPolicy.getCommandScan().getObjReference()) != null) {
                String id = ref.getTargetId();
                AdminDefinedScan ads = (AdminDefinedScan)defaultSchemaObject.getAvAdminDefinedScanMap().get(id);
                WashIDHandler washer = new WashIDHandler();
                newads = (AdminDefinedScan)washer.duplicateObject((ConfigObject)ads, newObjList);
                newads.setId(new GUIDGenerator().getGUIDString());
            }
        }
        return newads;
    }

    public static MacAdminDefinedScan getDefaultMacAdminDefinedScan() throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        HashMap<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();
        Set entrySet = defaultSchemaObject.getAvMacintoshAdminDefinedScanMap().entrySet();
        for (Map.Entry entry : entrySet) {
            MetadataAttributes attribute = ((MacAdminDefinedScan)entry.getValue()).getMetadataAttributes();
            if (attribute != null && attribute.getOwner() != null) continue;
            WashIDHandler washer = new WashIDHandler();
            MacAdminDefinedScan newads = (MacAdminDefinedScan)washer.duplicateObject((ConfigObject)entry.getValue(), newObjList);
            newads.setId(new GUIDGenerator().getGUIDString());
            return newads;
        }
        return null;
    }

    public static MacAdminDefinedScan getDefaultMacCommandScan() throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        MacAdminDefinedScan newads = null;
        AvPolicy defaultAvPolicy = defaultSchemaObject.getDefaultAvPolicy();
        if (defaultAvPolicy != null) {
            ObjReference ref;
            MacCommandScan command;
            HashMap<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();
            MacAvScanPolicy macAvScanPolicy = defaultAvPolicy.getOptMacAvScanPolicy();
            if (macAvScanPolicy != null && (command = macAvScanPolicy.getOptMacCommandScan()) != null && (ref = command.getOptObjReference()) != null) {
                MacAdminDefinedScan ads = (MacAdminDefinedScan)defaultSchemaObject.getAvMacintoshAdminDefinedScanMap().get(ref.getTargetId());
                WashIDHandler washer = new WashIDHandler();
                newads = (MacAdminDefinedScan)washer.duplicateObject((ConfigObject)ads, newObjList);
                newads.setId(new GUIDGenerator().getGUIDString());
            }
        }
        return newads;
    }

    public static LuPolicy getDefaultLiveUpdatePolicy(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        LuPolicy defaultLuPolicy = defaultSchemaObject.getDefaultLiveUpdatePolicy();
        if (defaultLuPolicy != null) {
            WashIDHandler washer = new WashIDHandler();
            LuPolicy newLoc = (LuPolicy)washer.duplicateObject((ConfigObject)defaultLuPolicy, newObjList);
            return newLoc;
        }
        return null;
    }

    public static LuContentPolicy getDefaultLiveUpdateContentPolicy(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        LuContentPolicy defaultLuPolicy = defaultSchemaObject.getDefaultLiveUpdateContentPolicy();
        if (defaultLuPolicy != null) {
            WashIDHandler washer = new WashIDHandler();
            LuContentPolicy newLoc = (LuContentPolicy)washer.duplicateObject((ConfigObject)defaultLuPolicy, newObjList);
            return newLoc;
        }
        return null;
    }

    public static PolicyOverride getDefaultPolicyOverride(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        PolicyOverride defaultPolicyOverride = defaultSchemaObject.getDefaultPolicyOverride();
        if (defaultPolicyOverride != null) {
            WashIDHandler washer = new WashIDHandler();
            PolicyOverride newLoc = (PolicyOverride)washer.duplicateObject((ConfigObject)defaultPolicyOverride, newObjList);
            return newLoc;
        }
        return null;
    }

    public static HiHostIntegrityPolicy getDefaultHostIntegrityPolicy(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        HiHostIntegrityPolicy defaultOne = defaultSchemaObject.getDefaultHostIntegrityPolicy();
        if (defaultOne != null) {
            WashIDHandler washer = new WashIDHandler();
            HiHostIntegrityPolicy newLoc = (HiHostIntegrityPolicy)washer.duplicateObject((ConfigObject)defaultOne, newObjList);
            return newLoc;
        }
        return null;
    }

    public static HiParm_EnforceAv getDefaultEnforceAv(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        HiParm_EnforceAv defaultOne = defaultSchemaObject.getEnforceAv();
        if (defaultOne != null) {
            WashIDHandler washer = new WashIDHandler();
            HiParm_EnforceAv newLoc = (HiParm_EnforceAv)washer.duplicateObject((ConfigObject)defaultOne, newObjList);
            return newLoc;
        }
        return null;
    }

    public static HiParm_EnforceServicePack getDefaultEnforceServicePack(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        HiParm_EnforceServicePack defaultOne = defaultSchemaObject.getEnforceServicePack();
        if (defaultOne != null) {
            WashIDHandler washer = new WashIDHandler();
            HiParm_EnforceServicePack newLoc = (HiParm_EnforceServicePack)washer.duplicateObject((ConfigObject)defaultOne, newObjList);
            return newLoc;
        }
        return null;
    }

    public static HiParm_EnforcePatch getDefaultEnforcePatch(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        HiParm_EnforcePatch defaultOne = defaultSchemaObject.getEnforcePatch();
        if (defaultOne != null) {
            WashIDHandler washer = new WashIDHandler();
            HiParm_EnforcePatch newLoc = (HiParm_EnforcePatch)washer.duplicateObject((ConfigObject)defaultOne, newObjList);
            return newLoc;
        }
        return null;
    }

    public static HiParm_EnforceFw getDefaultEnforceFw(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        HiParm_EnforceFw defaultOne = defaultSchemaObject.getEnforceFw();
        if (defaultOne != null) {
            WashIDHandler washer = new WashIDHandler();
            HiParm_EnforceFw newLoc = (HiParm_EnforceFw)washer.duplicateObject((ConfigObject)defaultOne, newObjList);
            return newLoc;
        }
        return null;
    }

    public static HiParm_EnforceAsw getDefaultEnforceAsw(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        HiParm_EnforceAsw defaultOne = defaultSchemaObject.getEnforceAsw();
        if (defaultOne != null) {
            WashIDHandler washer = new WashIDHandler();
            HiParm_EnforceAsw newLoc = (HiParm_EnforceAsw)washer.duplicateObject((ConfigObject)defaultOne, newObjList);
            return newLoc;
        }
        return null;
    }

    public static HiParm_Popup getDefaultPopup(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        HiParm_Popup defaultOne = defaultSchemaObject.getPopup();
        if (defaultOne != null) {
            WashIDHandler washer = new WashIDHandler();
            HiParm_Popup newLoc = (HiParm_Popup)washer.duplicateObject((ConfigObject)defaultOne, newObjList);
            return newLoc;
        }
        return null;
    }

    public static FwIdsLibrary getDefaultFwIdsLibrary(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        FwIdsLibrary defaultOne = defaultSchemaObject.getDefaultFwIdsLibrary();
        if (defaultOne != null) {
            WashIDHandler washer = new WashIDHandler();
            FwIdsLibrary newLoc = (FwIdsLibrary)washer.duplicateObject((ConfigObject)defaultOne, newObjList);
            return newLoc;
        }
        return null;
    }

    public static OpAppProtectionPolicy getDefaultOSProtectionPolicy(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        OpAppProtectionPolicy defaultOne = defaultSchemaObject.getDefaultOSProtectionPolicy();
        if (defaultOne != null) {
            WashIDHandler washer = new WashIDHandler();
            OpAppProtectionPolicy newLoc = (OpAppProtectionPolicy)washer.duplicateObject((ConfigObject)defaultOne, newObjList);
            return newLoc;
        }
        return null;
    }

    public static ConfigObject importPolicy() {
        return PolicyHandler.importPolicy((JFileChooser)null);
    }

    public static ConfigObject importPolicy(JFileChooser fileChooser) {
        chooser = fileChooser == null ? PolicyHandler.getExportFileChooser() : fileChooser;
        MessageResources msgRes = MessageResources.getInstance();
        chooser.setApproveButtonText(UIText.get(2048));
        chooser.setDialogTitle(msgRes.getString("com.sygate.scm.console.handler.handler", "PolicyHandler.title.ImportPolicy"));
        chooser.updateUI();
        int retCode = chooser.showDialog(Manager.getFrame(), null);
        if (1 == retCode) {
            return null;
        }
        File f = chooser.getSelectedFile();
        MonitorAgent.getInstance().startScenario("ImportPolicy", "SEPM_Java");
        String eventId = MonitorAgent.getInstance().startEvent("UIRequest", null);
        return PolicyHandler.importPolicy(f, eventId);
    }

    public static ConfigObject importPolicy(File file) {
        return PolicyHandler.importPolicy(file, null);
    }

    private static void addDefaultPEPPolicy(IdsPolicy idsPolicy) throws Exception {
        HashMap<String, TopLevelObject> newObjList;
        TopLevelObject defaultTopLevelPolicy;
        PEPPolicy pepPolicy = idsPolicy.getOptPEPPolicy();
        if (pepPolicy == null && (defaultTopLevelPolicy = PolicyHandler.getDefaultIdsPolicy(newObjList = new HashMap<String, TopLevelObject>())) != null && defaultTopLevelPolicy instanceof IdsPolicy) {
            IdsPolicy defaultIdsPolicy = (IdsPolicy)defaultTopLevelPolicy;
            idsPolicy.setOptPEPPolicy(defaultIdsPolicy.getOptPEPPolicy());
        }
    }

    private static void addDefaultLinuxAvPolicy(AvPolicy avPolicy, Map<String, TopLevelObject> objReferencePool) throws Exception {
        LinuxAvAutoProtect linuxAvAutoProtect = avPolicy.getOptLinuxAvAutoProtect();
        LinuxAvScanPolicy scanPolicy = avPolicy.getOptLinuxAvScanPolicy();
        LinuxAvGeneral linuxAvGeneral = avPolicy.getOptLinuxAvGeneral();
        if (linuxAvAutoProtect == null || scanPolicy == null || linuxAvGeneral == null) {
            HashMap<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();
            AvPolicy defaultAv = PolicyHandler.getDefaultAvPolicy(newObjList);
            if (linuxAvGeneral == null) {
                avPolicy.setOptLinuxAvGeneral(defaultAv.getOptLinuxAvGeneral());
            }
            if (linuxAvAutoProtect == null) {
                avPolicy.setOptLinuxAvAutoProtect(defaultAv.getOptLinuxAvAutoProtect());
            }
            if (scanPolicy == null) {
                LinuxAvScanPolicy scanPolicyDef = defaultAv.getOptLinuxAvScanPolicy();
                avPolicy.setOptLinuxAvScanPolicy(scanPolicyDef);
                Vector objRefs = scanPolicyDef.getObjReference();
                for (ObjReference ref : objRefs) {
                    objReferencePool.put(ref.getTargetId(), (TopLevelObject)newObjList.get(ref.getTargetId()));
                }
                ObjReference ref = scanPolicyDef.getOptCommandScan().getObjReference();
                objReferencePool.put(ref.getTargetId(), (TopLevelObject)newObjList.get(ref.getTargetId()));
            }
        }
    }

    private static void macIdleScanTimeFixup(AvPolicy avPolicy, Map<String, TopLevelObject> objReferencePool) {
        MacAvScanPolicy macAvScanPolicyLegacy = avPolicy.getOptMacAvScanPolicy();
        if (macAvScanPolicyLegacy != null) {
            try {
                MacAdminDefinedScanDetails macAdminDefinedScanDetails;
                MacAdminDefinedScan macAdminDefinedScanTemplate = PolicyHandler.getDefaultMacAdminDefinedScan();
                Boolean defaultIdleTimeScan = true;
                if (macAdminDefinedScanTemplate != null && (macAdminDefinedScanDetails = macAdminDefinedScanTemplate.getOptMacAdminDefinedScanDetails()) != null) {
                    defaultIdleTimeScan = macAdminDefinedScanDetails.getOptIdleTimeScan();
                }
                Vector objRefs = macAvScanPolicyLegacy.getObjReference();
                ObjReference objRefMacAdminDefinedScan = null;
                for (int count = 0; count < objRefs.size(); ++count) {
                    objRefMacAdminDefinedScan = (ObjReference)objRefs.elementAt(count);
                    if (!MacAdminDefinedScan.class.getSimpleName().equalsIgnoreCase(objRefMacAdminDefinedScan.getTargetType())) continue;
                    MacAdminDefinedScan macAdminDefinedScan = (MacAdminDefinedScan)objReferencePool.get(objRefMacAdminDefinedScan.getTargetId());
                    if (macAdminDefinedScan != null) {
                        MacAdminDefinedScanDetails macAdminDefinedScanDetails2 = macAdminDefinedScan.getOptMacAdminDefinedScanDetails();
                        if (macAdminDefinedScanDetails2 != null) {
                            if (macAdminDefinedScanDetails2.getOptIdleTimeScan() != null) continue;
                            macAdminDefinedScanDetails2.setOptIdleTimeScan(defaultIdleTimeScan);
                            continue;
                        }
                        System.out.println("PolicyHandler.macIdleScanTimeFixup()::MacAdminDefinedScanDetails is not found");
                        continue;
                    }
                    System.out.println("PolicyHandler.macIdleScanTimeFixup()::MacAdminDefinedScan is not found");
                }
            }
            catch (Exception e1) {
                System.out.println("PolicyHandler.macIdleScanTimeFixup()::Exception while importing MacAdminDefinedScan");
                LoggerUtilities.logException((Throwable)e1);
            }
        }
    }

    static void processIfNTRPolicy(ConfigObject policy) throws CancelException {
        if (!(policy instanceof NtrPolicy)) {
            return;
        }
        NtrPolicy ntrPolicy = (NtrPolicy)policy;
        boolean isPolicyEnabled = Optional.ofNullable(ntrPolicy.getOptEnableNTR()).orElse(ntrPolicy.getDefEnableNTR());
        Integer redirectionMethod = Optional.ofNullable(ntrPolicy.getOptRedirectionMethod()).orElse(ntrPolicy.getDefRedirectionMethod());
        String errMsg = null;
        if (!NtrPolicy.FULL.equals(redirectionMethod)) {
            String kbLink = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NTRPolicy.import.PacFile.NotSupported.kbLink"), ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage());
            errMsg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NTRPolicy.import.PacFile.NotSupported.message"), kbLink);
        } else if (!isPolicyEnabled && !NTRPolicyUtility.isTokenValidAndFormatCTCV2((NtrPolicy)ntrPolicy)) {
            ntrPolicy.setOptEnableCia(Boolean.valueOf(false));
            ntrPolicy.setOptCiaCustomerToken(ntrPolicy.getDefCiaCustomerToken());
            ntrPolicy.setOptCiaPsk(ntrPolicy.getDefCiaPsk());
            ntrPolicy.setOptCiaPskVersion(ntrPolicy.getDefCiaPskVersion());
        } else if (isPolicyEnabled && !NTRPolicyUtility.isValidCiaIntegrationTokenFormat((NtrPolicy)ntrPolicy)) {
            errMsg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NTRPolicy.import.FullTunnel.NotValid.message");
        }
        if (errMsg != null) {
            HTMLEditorPane paneMsg = new HTMLEditorPane(null);
            paneMsg.setText(errMsg);
            JOptionPane.showMessageDialog(Manager.getFrame(), paneMsg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NTRPolicy.import.error.Title"), 2);
            throw new CancelException(errMsg);
        }
    }

    static void processIfHIPolicy(ConfigObject policy) throws CancelException {
        if (!(policy instanceof HiHostIntegrityPolicy)) {
            return;
        }
        HiHostIntegrityPolicy hiPolicy = (HiHostIntegrityPolicy)policy;
        try {
            if (PolicyHandler.isSSEPLinuxHIPolicy(hiPolicy)) {
                String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "HostIntegrityPolicyHandler.cannotSupportLinuxHIPolicy");
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "HostIntegrityPolicyHandler.cannotSupportLinuxHIPolicyTitle"), 0);
                throw new CancelException(msg);
            }
            PolicyHandler.migrateSSEPHIPolicy(hiPolicy);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            throw new CancelException(e.getMessage());
        }
    }

    static void processIfAVPolicy(ConfigObject policy, Map<String, TopLevelObject> objReferencePool) throws Exception {
        if (policy instanceof AvPolicy) {
            RpcData rpc = new RpcData();
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER", (String)String.valueOf(LocaleManipulationUtility.getLocaleCultureID((Locale)Locale.getDefault())));
            AvPolicy avPolicy = (AvPolicy)policy;
            PolicyHandler.addDefaultLinuxAvPolicy(avPolicy, objReferencePool);
            PolicyHandler.macIdleScanTimeFixup(avPolicy, objReferencePool);
            SemTable semTable = GUIManager.getSemTable(1400, rpc, -1, -1);
            DynaCatManipulationUtility.adjustApActions((AvPolicy)avPolicy, (SemTable)semTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigObject importPolicy(File file, String eventId) {
        Hashtable<String, File> importedPhysicalFiles = new Hashtable<String, File>();
        try {
            AbstractSchema abs = PolicyHandler.readZipFile(file, importedPhysicalFiles);
            if (abs == null) {
                throw new Exception(MSGRES_FILE.getString("PolicyHandler.error.InvalidExportFile"));
            }
            Vector c = abs.getChildren();
            ConfigObject policy = (ConfigObject)c.get(0);
            LinkedHashMap<String, TopLevelObject> objReferencePool = new LinkedHashMap<String, TopLevelObject>();
            PolicyHandler.extractTopLevelObject(objReferencePool, policy, false);
            PolicyHandler.retrieveReferredTopLevelObj(c, objReferencePool);
            PolicyHandler.processIfNTRPolicy(policy);
            PolicyHandler.processIfAVPolicy(policy, objReferencePool);
            HashMap<String, TopLevelObject> newObjSet = new HashMap<String, TopLevelObject>();
            ImportConfigObjHandler washer = new ImportConfigObjHandler();
            washer.setObjReferencePool(objReferencePool);
            washer.setPhysicalFiles(importedPhysicalFiles);
            ConfigObject obj = washer.importObject(policy, newObjSet);
            PolicyHandler.processIfHIPolicy(obj);
            if (eventId != null) {
                MonitorAgent.getInstance().stopEvent(eventId);
                MonitorAgent.getInstance().stopScenario("Import Policy");
            }
            ConfigObject configObject = obj;
            return configObject;
        }
        catch (CancelException exc) {
            ConfigObject c = null;
            return c;
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            String errMsg = e.getMessage();
            if (errMsg != null) {
                System.err.println(errMsg);
                if (AjaxSwingCommonUtil.isAjaxSwingRunning() && !file.delete()) {
                    System.err.println("PolicyHandler: importPolicy: Error-> Failed to delete file:" + file.getPath());
                }
                UIUtilities.showErrorDialog(MSGRES_FILE.getString("PolicyHandler.FailedImportPolicy"));
            }
        }
        finally {
            Iterator<File> values = importedPhysicalFiles.values().iterator();
            while (values.hasNext()) {
                Utility.delete((File)values.next());
            }
        }
    }

    public static void migrateSSEPHIPolicy(HiHostIntegrityPolicy policy) throws Exception {
        if (PolicyHandler.isSSEPMacHIPolicy(policy)) {
            SemConfigRoot configRoot = DataobjectManager.getInstance().getSemConfigRoot();
            PolicyHandler.initialize(configRoot);
            Map<String, HiReqTemplate> hiLibObj = PolicyHandler.getHiTemplateLibraryObj();
            MigHIPolicyUtils.getInstance().migrateSSEPMacHIPolicy(policy, hiLibObj);
        } else if (PolicyHandler.isSSEPWinHIPolicy(policy)) {
            MigHIPolicyUtils.getInstance().migrateSSEPWinHiPolicy(policy);
        }
        MigHIPolicyUtils.getInstance().migrateHIPolicyAdvanceSetting(policy);
    }

    public static boolean isSSEPMacHIPolicy(HiHostIntegrityPolicy policy) {
        String osType = policy.getOptOsType();
        return !StringUtilities.isEmpty((String)osType) && "Mac".equalsIgnoreCase(osType);
    }

    public static boolean isSSEPWinHIPolicy(HiHostIntegrityPolicy policy) {
        String osType = policy.getOptOsType();
        return !StringUtilities.isEmpty((String)osType) && "Windows".equalsIgnoreCase(osType);
    }

    public static boolean isSSEPLinuxHIPolicy(HiHostIntegrityPolicy policy) {
        String osType = policy.getOptOsType();
        return !StringUtilities.isEmpty((String)osType) && "Linux".equalsIgnoreCase(osType);
    }

    public static ConfigObject importPolicy(AbstractSchema abs, Hashtable<String, File> importedPhysicalFiles) throws Exception {
        Vector c = abs.getChildren();
        ConfigObject policy = (ConfigObject)c.get(0);
        LinkedHashMap<String, TopLevelObject> objReferencePool = new LinkedHashMap<String, TopLevelObject>();
        PolicyHandler.extractTopLevelObject(objReferencePool, policy, false);
        PolicyHandler.retrieveReferredTopLevelObj(c, objReferencePool);
        HashMap<String, TopLevelObject> newObjSet = new HashMap<String, TopLevelObject>();
        ImportConfigObjHandler washer = new ImportConfigObjHandler();
        washer.setObjReferencePool(objReferencePool);
        washer.setPhysicalFiles(importedPhysicalFiles);
        ConfigObject obj = washer.importObject(policy, newObjSet);
        return obj;
    }

    public static void exportPolicy(ConfigObject policy, String expFileName) {
        PolicyHandler.exportPolicy(policy, expFileName, null, null);
    }

    public static boolean exportPolicy(ConfigObject policy, String expFileName, JFileChooser fileChooser) {
        return PolicyHandler.exportPolicy(policy, expFileName, null, fileChooser);
    }

    public static void exportPolicy(ConfigObject policy, String expFileName, ExportedPackage exportedPackage) {
        PolicyHandler.exportPolicy(policy, expFileName, exportedPackage, null);
    }

    private static boolean exportPolicy(ConfigObject policy, String expFileName, ExportedPackage exportedPackage, JFileChooser fileChooser) {
        chooser = fileChooser == null ? PolicyHandler.getExportFileChooser() : fileChooser;
        Hashtable<String, BufferedInputStream> physicalFileList = null;
        MessageResources msgRes = MessageResources.getInstance();
        chooser.setApproveButtonText(UIText.get(1030));
        String policyOrRule = exportedPackage != null && "sygate.spm.osp.policy".equals(exportedPackage.getType()) ? msgRes.getString("com.sygate.scm.console.handler.handler", "PolicyHandler.title.ExportRule") : msgRes.getString("com.sygate.scm.console.handler.handler", "PolicyHandler.title.ExportPolicy");
        chooser.setDialogTitle(policyOrRule);
        chooser.updateUI();
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            chooser.setDialogType(1);
        }
        chooser.setSelectedFile(new File(expFileName + ".dat"));
        if (0 == chooser.showDialog(Manager.getFrame(), null)) {
            String errMsg = null;
            try {
                File exportFile = chooser.getSelectedFile();
                if (!Utility.validateExportFilePath((JFrame)Manager.getFrame(), (File)exportFile, (String)policyOrRule, (String)".dat", (boolean)AjaxSwingCommonUtil.isAjaxSwingRunning())) {
                    return false;
                }
                ConfigObject abs = policy;
                SchemaContainer sc = new SchemaContainer();
                sc.addChild((AbstractSchema)abs);
                PolicyHandler.addExtraInformationInPolicy(sc);
                LinkedHashMap<String, TopLevelObject> objReferencePool = new LinkedHashMap<String, TopLevelObject>();
                PolicyHandler.extractTopLevelObject(objReferencePool, policy, true);
                for (Map.Entry oneEntry : objReferencePool.entrySet()) {
                    sc.addChild((AbstractSchema)oneEntry.getValue());
                    TopLevelObject obj = (TopLevelObject)oneEntry.getValue();
                    if (!(obj instanceof PhysicalFile)) continue;
                    PhysicalFile file = (PhysicalFile)obj;
                    String id = file.getId();
                    InputStream is = GUIManager.getFile(id);
                    if (physicalFileList == null) {
                        physicalFileList = new Hashtable<String, BufferedInputStream>();
                    }
                    physicalFileList.put(file.getFileName(), new BufferedInputStream(is));
                }
                ZipOutputStream zip = null;
                zip = exportFile.getName().indexOf(".dat") > 0 ? new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(exportFile))) : new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(exportFile + ".dat")));
                byte[] buff = new byte[1024];
                ZipEntry entry = new ZipEntry("main.xml");
                zip.putNextEntry(entry);
                if (exportedPackage != null) {
                    exportedPackage.writeXML(sc, (OutputStream)zip);
                } else {
                    sc.writeXML((OutputStream)zip);
                }
                zip.closeEntry();
                if (physicalFileList != null && physicalFileList.size() != 0) {
                    Enumeration en = physicalFileList.keys();
                    while (en.hasMoreElements()) {
                        int len;
                        String fileName = (String)en.nextElement();
                        InputStream fileIS = (InputStream)physicalFileList.get(fileName);
                        entry = new ZipEntry(fileName);
                        zip.putNextEntry(entry);
                        while ((len = fileIS.read(buff, 0, 1024)) > 0) {
                            zip.write(buff, 0, len);
                        }
                        IOUtilities.closeInputStream((InputStream)fileIS);
                        zip.closeEntry();
                    }
                }
                zip.close();
                return true;
            }
            catch (ConsoleException ce) {
                errMsg = ce.getMessage();
            }
            catch (ValidationException ve) {
                errMsg = ve.getMessage();
            }
            catch (IOException ioe) {
                errMsg = ioe.getMessage();
            }
            if (errMsg != null) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES_FILE.getString("PolicyHandler.error.FailedToExportPolicy") + errMsg);
                return false;
            }
        }
        return false;
    }

    public static void extractTopLevelObject(Map<String, TopLevelObject> topLevelObjPool, ConfigObject obj, boolean checkExist) throws ConsoleException {
        TopLevelObject referredObj;
        String referId;
        String targetType;
        com.sygate.scm.hi.library.ObjReference refer;
        if (obj instanceof UnknownContent) {
            UnknownContent unknown = (UnknownContent)obj;
            try {
                ConfigObject subObj = (ConfigObject)AbstractSchema.readXML((byte[])unknown.getContent());
                PolicyHandler.extractTopLevelObject(topLevelObjPool, subObj, checkExist);
                unknown.setConent(subObj.getBytes());
            }
            catch (SAXException e) {
                LoggerUtilities.logException((Throwable)e);
                throw new ConsoleException(e);
            }
            catch (IOException e) {
                LoggerUtilities.logException((Throwable)e);
                throw new ConsoleException(e);
            }
            catch (ValidationException e) {
                LoggerUtilities.logException((Throwable)e);
                throw new ConsoleException(e);
            }
        }
        if (obj instanceof com.sygate.scm.hi.library.ObjReference) {
            block12: {
                refer = (com.sygate.scm.hi.library.ObjReference)obj;
                targetType = refer.getTargetType();
                referId = refer.getTargetId();
                referredObj = null;
                try {
                    referredObj = PolicyHandler.getObject(targetType, referId);
                }
                catch (ConsoleException ce) {
                    if (!checkExist) break block12;
                    throw ce;
                }
            }
            topLevelObjPool.put(referId, referredObj);
        }
        if (obj instanceof ObjReference) {
            block13: {
                refer = (ObjReference)obj;
                targetType = refer.getTargetType();
                referId = refer.getTargetId();
                referredObj = null;
                try {
                    referredObj = PolicyHandler.getObject(targetType, referId);
                }
                catch (ConsoleException ce) {
                    if (!checkExist) break block13;
                    throw ce;
                }
            }
            topLevelObjPool.put(referId, referredObj);
        }
        for (ConfigObject subObj : obj.getChildren()) {
            PolicyHandler.extractTopLevelObject(topLevelObjPool, subObj, checkExist);
        }
    }

    public static void retrieveReferredTopLevelObj(Vector<AbstractSchema> children, Map<String, TopLevelObject> topLevelObjPool) {
        for (int i = 1; i < children.size(); ++i) {
            TopLevelObject obj = (TopLevelObject)children.get(i);
            String id = obj.getId();
            if (!topLevelObjPool.containsKey(id)) continue;
            topLevelObjPool.put(id, obj);
        }
    }

    public static String validatePolicyName(String oldName, List<String> nameList, int maxLength) {
        String newName = PolicyHandler.adjustName(oldName.trim(), nameList, maxLength);
        if (!newName.equals(oldName = oldName.trim())) {
            String msg = MSGRES_FILE.getString("PolicyHandler.error.PolicyNameExists");
            if (newName.indexOf(oldName) == -1) {
                msg = MSGRES_FILE.getString("PolicyHandler.error.PolicyNameTooLong");
            }
            String enteredName = null;
            boolean showInputDlg = true;
            do {
                if ((enteredName = JOptionPane.showInputDialog(Manager.getFrame(), MessageFormat.format(msg, oldName), newName)) == null) {
                    showInputDlg = false;
                    continue;
                }
                if (enteredName.trim().length() == 0) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.nameFieldCannotBeEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ServerListEditorDlg.error"), 0);
                    continue;
                }
                showInputDlg = false;
            } while (showInputDlg);
            if (enteredName == null) {
                return null;
            }
            return PolicyHandler.validatePolicyName(enteredName, nameList, maxLength);
        }
        return newName;
    }

    public static String validateFWPolicyRuleName(String oldName, List<String> nameList, int maxLength) {
        String newName = oldName;
        if (oldName != null) {
            if (oldName.trim().length() == 0) {
                String msg = MSGRES_FILE.getString("PolicyHandler.error.FirewallRuleNameRequired");
                newName = MSGRES_FILE.getString("PolicyHandler.BlankFirewallPolicyRuleName");
                newName = PolicyHandler.adjustName(newName.trim(), nameList, maxLength);
                String enteredName = (String)JOptionPane.showInputDialog(Manager.getFrame(), msg, MSGRES_FILE.getString("PolicyHandler.GetRuleName"), 3, null, null, newName);
                newName = PolicyHandler.validateFWPolicyRuleName(enteredName, nameList, maxLength);
            } else {
                newName = PolicyHandler.adjustName(oldName.trim(), nameList, maxLength);
                if (!newName.equals(oldName)) {
                    String msg = MSGRES_FILE.getString("PolicyHandler.error.PolicyNameExists");
                    if (newName.indexOf(oldName) == -1) {
                        msg = MSGRES_FILE.getString("PolicyHandler.error.PolicyNameTooLong");
                    }
                    String enteredName = (String)JOptionPane.showInputDialog(Manager.getFrame(), MessageFormat.format(msg, oldName), MSGRES_FILE.getString("PolicyHandler.GetRuleName"), 3, null, null, newName);
                    newName = PolicyHandler.validateFWPolicyRuleName(enteredName, nameList, maxLength);
                }
            }
        }
        return newName;
    }

    public static long getLatestT(ConfigObject cObj) {
        return PolicyHandler.getLatestT(cObj, -1L);
    }

    private static long getLatestT(ConfigObject cObj, long curT) {
        long newT = cObj.getT();
        if (curT > newT) {
            newT = curT;
        }
        if (cObj instanceof ObjReference) {
            ObjReference objRef = (ObjReference)cObj;
            String objType = objRef.getTargetType();
            String objId = objRef.getTargetId();
            if (objType.equals("DefaultServerList")) {
                return newT;
            }
            if (objType.equals("ExPhysicalFileStream")) {
                return newT;
            }
            try {
                TopLevelObject subObj = PolicyHandler.getObject(objType, objId);
                newT = PolicyHandler.getLatestT((ConfigObject)subObj, newT);
            }
            catch (ConsoleException e) {
                System.out.println(e.getMessage());
            }
        }
        if (cObj instanceof UnknownContent) {
            UnknownContent unknown = (UnknownContent)cObj;
            try {
                ConfigObject subObj = (ConfigObject)AbstractSchema.readXML((byte[])unknown.getContent());
                newT = PolicyHandler.getLatestT(subObj, newT);
            }
            catch (SAXException e) {
                LoggerUtilities.logException((Throwable)e);
            }
            catch (IOException e) {
                LoggerUtilities.logException((Throwable)e);
            }
            catch (ValidationException e) {
                LoggerUtilities.logException((Throwable)e);
            }
        } else {
            for (ConfigObject newObj : cObj.getChildren()) {
                newT = PolicyHandler.getLatestT(newObj, newT);
            }
        }
        return newT;
    }

    public static List<String> getAllAvaliableSiteId() {
        ArrayList<String> all = new ArrayList<String>();
        try {
            SemConfigRoot configRoot = DataobjectManager.getInstance().getSemConfigRoot();
            SemSiteArray siteArray = configRoot.getSemSiteArray();
            for (ObjReference objRef : siteArray.getObjReference()) {
                SemSite site = (SemSite)PolicyHandler.getObjectFromDB(objRef.getTargetType(), objRef.getTargetId());
                Boolean suspended = site.getOptSuspended();
                if (suspended == null) {
                    suspended = site.getDefSuspended();
                }
                if (suspended.booleanValue()) continue;
                all.add(site.getId());
            }
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return all;
    }

    public static int compareVersion(String version1, String version2) {
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 == null && version2 != null) {
            return -1;
        }
        if (version1 != null && version2 == null) {
            return 1;
        }
        StringTokenizer st1 = new StringTokenizer(version1, ".");
        StringTokenizer st2 = new StringTokenizer(version2, ".");
        while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
            int ret;
            int v1 = 0;
            int v2 = 0;
            try {
                v1 = Integer.parseInt(st1.nextToken());
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            try {
                v2 = Integer.parseInt(st2.nextToken());
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            if ((ret = v1 > v2 ? 1 : (v1 < v2 ? -1 : 0)) == 0) continue;
            return ret;
        }
        if (st1.hasMoreTokens()) {
            return 1;
        }
        if (st2.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }

    public static String getFileExtension(String fileName) {
        String ext = null;
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            ext = fileName.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static Document addServerSchemaAttributes(InputStream in) throws IOException, SAXException {
        Document doc = XMLHelper.parse((InputStream)in);
        Element oneElement = doc.getDocumentElement();
        PolicyHandler.addServerSchemaAttributes(oneElement);
        return doc;
    }

    private static void addServerSchemaAttributes(Element oneElement) {
        Object strId;
        String id = oneElement.getAttribute("_i");
        if (id == null || id.length() == 0) {
            oneElement.setAttribute("_i", new GUIDGenerator().getGUIDString());
        }
        if ((strId = oneElement.getAttribute("Id")) != null && ((String)strId).length() < 32) {
            strId = String.valueOf(zeroList, 0, 32 - ((String)strId).length()) + (String)strId;
            oneElement.setAttribute("Id", (String)strId);
        }
        NodeList allChildrean = oneElement.getChildNodes();
        int length = allChildrean.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = allChildrean.item(i);
            if (!(node instanceof Element)) continue;
            Element nextOne = (Element)node;
            PolicyHandler.addServerSchemaAttributes(nextOne);
        }
    }

    public static void replaceFirewallPolicyLinks(FwFirewallPolicy firewallPolicy) throws ConsoleException {
        if (serviceIdMap == null) {
            PolicyHandler.prepareServiceIdMap();
        }
        if (networkInterfaceIdMap == null) {
            PolicyHandler.prepareNetworkInterfaceIdMap();
        }
        FirewallRuleSystem ruleSystem = firewallPolicy.getOptFirewallRuleSystem();
        PolicyHandler.replaceFirewallRuleLinks(ruleSystem);
        MacFwFirewallPolicy macFwFirewallPolicy = firewallPolicy.getOptMacFwFirewallPolicy();
        if (macFwFirewallPolicy != null) {
            PolicyHandler.replaceFirewallRuleLinks(macFwFirewallPolicy.getOptFirewallRuleSystem());
        }
    }

    private static void replaceFirewallRuleLinks(Vector<FirewallRule> allRules) {
        for (FirewallRule rule : allRules) {
            FwNetworkInterfaceTrigger interfaceTrigger;
            TriggerCondition trigger = rule.getTriggerCondition();
            FwServiceTrigger serviceTrigger = trigger.getOptFwServiceTrigger();
            if (serviceTrigger != null) {
                for (ObjReference obj : serviceTrigger.getObjReference()) {
                    String name = obj.getName();
                    String id = serviceIdMap.get(name);
                    if (id == null) continue;
                    obj.setTargetId(id);
                    obj.setName("All Adapters");
                }
            }
            if ((interfaceTrigger = trigger.getOptFwNetworkInterfaceTrigger()) == null) continue;
            for (ObjReference obj : interfaceTrigger.getObjReference()) {
                String name = obj.getName();
                String id = networkInterfaceIdMap.get(name);
                if (id == null) continue;
                obj.setTargetId(id);
                obj.setName("All Adapters");
            }
        }
    }

    private static void replaceFirewallRuleLinks(FirewallRuleSystem ruleSystem) {
        if (ruleSystem != null) {
            BaselineFirewallRuleArray baselineRule;
            EnforcedFirewallRuleArray enforcedRule = ruleSystem.getOptEnforcedFirewallRuleArray();
            if (enforcedRule != null) {
                Vector allRules = enforcedRule.getFirewallRule();
                PolicyHandler.replaceFirewallRuleLinks(allRules);
            }
            if ((baselineRule = ruleSystem.getOptBaselineFirewallRuleArray()) != null) {
                Vector allRules = baselineRule.getFirewallRule();
                PolicyHandler.replaceFirewallRuleLinks(allRules);
            }
        }
    }

    private static void prepareNetworkInterfaceIdMap() throws ConsoleException {
        networkInterfaceIdMap = new HashMap<String, String>();
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", data.getLoginInformation().getOptDomainGUID());
        ObjectPool objPool = domain.getObjectPool();
        FwNetworkInterfacePool servicePool = objPool.getOptFwNetworkInterfacePool();
        if (servicePool != null) {
            ArrayList<String> allIds = new ArrayList<String>();
            for (ObjReference ref : servicePool.getObjReference()) {
                allIds.add(ref.getTargetId());
            }
            HashMap<String, ObjInfo> allInfos = data.getMutipleObjectInfo(allIds);
            for (ObjInfo objInfo : allInfos.values()) {
                networkInterfaceIdMap.put(objInfo.getOptName(), objInfo.getId());
            }
        }
    }

    private static void prepareServiceIdMap() throws ConsoleException {
        serviceIdMap = new HashMap<String, String>();
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", data.getLoginInformation().getOptDomainGUID());
        ObjectPool objPool = domain.getObjectPool();
        FwNetworkServicePool servicePool = objPool.getOptFwNetworkServicePool();
        if (servicePool != null) {
            ArrayList<String> allIds = new ArrayList<String>();
            for (ObjReference ref : servicePool.getObjReference()) {
                allIds.add(ref.getTargetId());
            }
            HashMap<String, ObjInfo> allInfos = data.getMutipleObjectInfo(allIds);
            for (ObjInfo objInfo : allInfos.values()) {
                serviceIdMap.put(objInfo.getOptName(), objInfo.getId());
            }
        }
    }

    public static String[] getAllInheritedGroupId(GroupObject curGroupObject) throws ConsoleException {
        return DataobjectManager.getInstance().getInheritedGroupsId(curGroupObject.getId());
    }

    public static SemGroupPolicy getSemGroupPolicy(SemClientGroup clientGroup) throws ConsoleException {
        String grpPolicyGUID = clientGroup.getObjReference().getTargetId();
        SemGroupPolicy semGrpPolicy = (SemGroupPolicy)PolicyHandler.getObjectFromDB("SemGroupPolicy", grpPolicyGUID);
        return semGrpPolicy;
    }

    public static JFileChooser getExportFileChooser() {
        if (AjaxSwingCommonUtil.isAjaxSwingRunning() || chooser == null) {
            chooser = new JFileChooser();
            chooser.setAcceptAllFileFilterUsed(false);
        }
        chooser.setFileFilter(PolicyHandler.getExportFileFilter());
        return chooser;
    }

    public static FileFilter getExportFileFilter() {
        if (importFileFilter == null) {
            importFileFilter = new FileFilter(){

                @Override
                public boolean accept(File fp) {
                    if (fp.isDirectory()) {
                        return true;
                    }
                    String extension = Utility.getFileExtension((File)fp);
                    return extension != null && extension.equals("dat");
                }

                @Override
                public String getDescription() {
                    return MSGRES_FILE.getString("PolicyHandler.FileFilterDescription");
                }
            };
        }
        return importFileFilter;
    }

    public static void resetStaticVariables() {
        newObjectPool.clear();
        changedObjectPool.clear();
        macAddressPool.clear();
        serviceIdMap = null;
        networkInterfaceIdMap = null;
        defaultSchemaObject = null;
    }

    public static TopLevelObject getDefaultIdsPolicy(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        IdsPolicy defaultOne = defaultSchemaObject.getIdsPolicy();
        if (defaultOne != null) {
            WashIDHandler washer = new WashIDHandler();
            IdsPolicy newLoc = (IdsPolicy)washer.duplicateObject((ConfigObject)defaultOne, newObjList);
            return newLoc;
        }
        return null;
    }

    public static HidPolicy getDefaultHidPolicy(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        HidPolicy defaultOne = defaultSchemaObject.getDefaultHidPolicy();
        if (defaultOne != null) {
            WashIDHandler washer = new WashIDHandler();
            HidPolicy newLoc = (HidPolicy)washer.duplicateObject((ConfigObject)defaultOne, newObjList);
            if (newLoc != null) {
                newLoc.setOptEnable(Boolean.FALSE);
            }
            return newLoc;
        }
        return null;
    }

    public static MemPolicy getDefaultMemPolicy(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        MemPolicy defaultOne = defaultSchemaObject.getDefaultMemPolicy();
        if (defaultOne != null) {
            WashIDHandler washer = new WashIDHandler();
            MemPolicy newLoc = (MemPolicy)washer.duplicateObject((ConfigObject)defaultOne, newObjList);
            return newLoc;
        }
        return null;
    }

    public static NtrPolicy getDefaultNtrPolicy(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        NtrPolicy defaultOne = defaultSchemaObject.getDefaultNtrPolicy();
        if (defaultOne != null) {
            WashIDHandler washer = new WashIDHandler();
            NtrPolicy newLoc = (NtrPolicy)washer.duplicateObject((ConfigObject)defaultOne, newObjList);
            return newLoc;
        }
        return null;
    }

    public static AdaptivePolicy getDefaultAdaptivePolicy(Map<String, TopLevelObject> newObjList) throws Exception {
        PolicyHandler.getDefaultSchemaObject();
        AdaptivePolicy defaultOne = defaultSchemaObject.getDefaultAdaptivePolicy();
        if (defaultOne != null) {
            WashIDHandler washer = new WashIDHandler();
            return (AdaptivePolicy)washer.duplicateObject((ConfigObject)defaultOne, newObjList);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AbstractSchema readZipFile(File zippedFile, Hashtable<String, File> physicalFiles) throws Exception {
        AbstractSchema schema;
        block14: {
            BufferedInputStream inStream = null;
            ZipInputStream zipIn = null;
            schema = null;
            BufferedOutputStream bos = null;
            try {
                byte[] data = new byte[2048];
                int count = -1;
                inStream = new BufferedInputStream(new FileInputStream(zippedFile));
                zipIn = new ZipInputStream(inStream);
                ZipEntry entry = zipIn.getNextEntry();
                while (entry != null) {
                    String entryName = entry.getName();
                    if (entryName.endsWith(".xml")) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        while ((count = zipIn.read(data, 0, 2048)) != -1) {
                            baos.write(data, 0, count);
                        }
                        schema = SchemaContainer.readXML((byte[])baos.toByteArray());
                    } else {
                        File unzippedFile = File.createTempFile(entryName, ".tmp");
                        bos = new BufferedOutputStream(new FileOutputStream(unzippedFile), 2048);
                        while ((count = zipIn.read(data, 0, 2048)) != -1) {
                            bos.write(data, 0, count);
                        }
                        physicalFiles.put(entryName, unzippedFile);
                        bos.flush();
                    }
                    entry = zipIn.getNextEntry();
                }
                IOUtilities.closeInputStream((InputStream)zipIn);
            }
            catch (RuntimeException rte) {
                throw rte;
                catch (Exception ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    AbstractSchema data = null;
                    return data;
                }
            }
            IOUtilities.closeOutputStream(bos);
            IOUtilities.closeInputStream((InputStream)inStream);
            if (schema == null) {
                ConsoleLogger.log("PolicyHandler>readZipFile>> schema was null!");
                return schema;
            }
            break block14;
            finally {
                IOUtilities.closeInputStream(zipIn);
                IOUtilities.closeOutputStream(bos);
                IOUtilities.closeInputStream(inStream);
            }
        }
        Vector c = schema.getChildren();
        int i = 0;
        while (i < c.size()) {
            if (c.get(i) != null && c.get(i) instanceof IdsPolicy) {
                IdsPolicy idsPolicy = (IdsPolicy)c.get(i);
                PolicyHandler.addDefaultPEPPolicy(idsPolicy);
            }
            ++i;
        }
        return schema;
    }

    public static void exportSylink(String path, GroupPolicyObject groupPolicy, int agentMode, boolean isFile) throws ConsoleException, IOException {
        GUID domainId = new GUID(Manager.getCurrentDomainId());
        String preferredGroup = groupPolicy.getGroupObject().getFullGroupPath();
        Communication communication = groupPolicy.getCommunicationObject().getCommunication();
        SemServerList serverList = groupPolicy.getCommunicationObject().getServerList().getSemServerList();
        Log log = groupPolicy.getAgentLogObject().getLog();
        ServerCertificate cert = groupPolicy.getSemAgentPolicyObject().getOptServerCertificate();
        ArrayList<SemSite> siteList = new ArrayList<SemSite>();
        SemConfigRoot configRoot = DataobjectManager.getInstance().getSemConfigRoot();
        SemSiteArray siteArray = configRoot.getSemSiteArray();
        int objCount = siteArray.getObjReferenceCount();
        for (int objIndex = 0; objIndex < objCount; ++objIndex) {
            ObjReference objRef = siteArray.getObjReference(objIndex);
            SemSite site = objRef.getTargetType().equals("SemSite") ? DataobjectManager.getInstance().getSemSite(objRef.getTargetId()) : null;
            if (site == null || !Boolean.FALSE.equals(Utility.getBooleanValue((Boolean)site.getOptSuspended(), (Boolean)site.getDefSuspended()))) continue;
            siteList.add(site);
        }
        String kcs = null;
        PresharedSecret ps = DataobjectManager.getInstance().getSemConfigRoot().getOptPresharedSecret();
        if (ps != null) {
            kcs = ps.getSecretHash();
        }
        Integer defaultHttpPort = ScmProperties.getWebServerPort();
        Integer defaultHttpsPort = ScmProperties.getWebServerPortHttps();
        ServerSettings outServerSetting = SylinkExportUtil.exportSylink((GUID)domainId, (Communication)communication, (SemServerList)serverList, siteList, (Log)log, (ServerCertificate)cert, (String)kcs, (String)preferredGroup, (int)agentMode, (boolean)PolicyHandler.getSiteAppUpload(), (Integer)defaultHttpPort, (Integer)defaultHttpsPort);
        CommConf outCommConf = outServerSetting.getCommConf();
        if (outCommConf == null) {
            throw new IllegalStateException("outCommConf was null!");
        }
        AgentCommunicationSetting outAgentCommuSetting = outCommConf.getAgentCommunicationSetting();
        if (outAgentCommuSetting == null) {
            throw new IllegalStateException("outAgentCommuSetting was null!");
        }
        outAgentCommuSetting.setOptRememberCurrentGroup(Boolean.valueOf(false));
        BufferedOutputStream os = null;
        try {
            os = isFile ? new BufferedOutputStream(new FileOutputStream(path)) : new BufferedOutputStream(new FileOutputStream(path + File.separator + CONFIG_XML));
            outServerSetting.writeXML((OutputStream)os);
            ((OutputStream)os).flush();
        }
        catch (ValidationException ex) {
            try {
                throw new ConsoleException(ex);
            }
            catch (Throwable throwable) {
                IOUtilities.closeOutputStream(os);
                throw throwable;
            }
        }
        IOUtilities.closeOutputStream((OutputStream)os);
    }

    private static boolean getSiteAppUpload() {
        try {
            SemSite site = DataobjectManager.getInstance().getLocalSite();
            if (site == null) {
                return true;
            }
            AppLearning appLearning = site.getOptAppLearning();
            if (appLearning == null) {
                return true;
            }
            return Utility.getBooleanValue((Boolean)appLearning.getOptEnable(), (Boolean)appLearning.getDefEnable());
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return true;
        }
    }

    public static ObjReference getSemALocationReference(Location semLocation) {
        Vector objRefers = semLocation.getChildren();
        for (int i = 0; i < objRefers.size(); ++i) {
            ObjReference objRef = (ObjReference)objRefers.get(i);
            if (!objRef.getTargetType().equals("SemLocationConfig")) continue;
            return objRef;
        }
        return null;
    }

    public static boolean isHIPolicyAppliedOnSelectedGroup(GroupObject selectedGroup) throws Exception {
        SemAgentPolicy agentPolicy = PolicyHandler.getSemAgentPolicyByGroupFromDB(selectedGroup);
        AutoLocation autoLocation = agentPolicy.getAutoLocation();
        LocationArray locationArray = autoLocation.getLocationArray();
        for (Location loc : locationArray.getLocation()) {
            SemLocationConfig locConfig = DataobjectManager.getInstance().getSemLocationConfig(loc.getObjReference().getTargetId());
            AppliedPolicyArray appliedPolicyArray = locConfig.getOptAppliedPolicyArray();
            if (appliedPolicyArray == null) continue;
            for (ObjReference ref : appliedPolicyArray.getObjReference()) {
                if (!"HiHostIntegrityPolicy".equals(ref.getTargetType()) || !"HostIntegrityApplied".equalsIgnoreCase(ref.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static void updateClientGroupPasswordSettings(String clientGroupId, String askPwdExit, String askPwdOpenGui, String askPwdProfile, String askPwdUninstall, String askPwdCleanwipe, String passwordHash, String password2Hash, String password3Hash, String applyToSubGroups) throws ConsoleException {
        DataobjectManager.getInstance().updateClientGroupPasswordSettings(clientGroupId, askPwdExit, askPwdOpenGui, askPwdProfile, askPwdUninstall, askPwdCleanwipe, passwordHash, password2Hash, password3Hash, applyToSubGroups);
    }

    private static List<HostIntegrityTemplateLibraryObject> initialize(SemConfigRoot configRoot) throws ConsoleException {
        HiReqTemplateLibraryPool hiPool;
        GlobalObjectPool globalObjPool = configRoot.getOptGlobalObjectPool();
        if (globalObjPool == null) {
            globalObjPool = new GlobalObjectPool();
            configRoot.setOptGlobalObjectPool(globalObjPool);
        }
        if ((hiPool = globalObjPool.getOptHiReqTemplateLibraryPool()) == null) {
            hiPool = new HiReqTemplateLibraryPool();
            globalObjPool.setOptHiReqTemplateLibraryPool(hiPool);
        }
        for (ObjReference obj : hiPool.getObjReference()) {
            HiReqTemplateLibrary lib = DataobjectManager.getInstance().getHiReqTemplateLibrary(obj.getTargetId());
            hiTemplibObjList.add(new HostIntegrityTemplateLibraryObject((TopLevelObject)lib));
        }
        return hiTemplibObjList;
    }

    private static Map<String, HiReqTemplate> getHiTemplateLibraryObj() {
        HashMap<String, HiReqTemplate> map = new HashMap<String, HiReqTemplate>();
        for (HostIntegrityTemplateLibraryObject tempObj : hiTemplibObjList) {
            HiReqTemplateLibrary templateLib;
            if (!tempObj.getPlatform().equalsIgnoreCase("Mac") || (templateLib = (HiReqTemplateLibrary)tempObj.getSchemaObj()).getOptHiReqTemplateGroupArray() == null) continue;
            Vector templateGroups = templateLib.getOptHiReqTemplateGroupArray().getHiReqTemplateGroup();
            for (HiReqTemplateGroup templateGroup : templateGroups) {
                for (HiReqTemplate template : templateGroup.getHiReqTemplate()) {
                    map.put(template.getName(), template);
                }
            }
        }
        return map;
    }

    public static void addExtraInformationInPolicy(SchemaContainer sc) {
        if (sc == null) {
            return;
        }
        try {
            SemDomain localDomain;
            ServerArray serverArray;
            SemSite localSite = DataobjectManager.getInstance().getLocalSite();
            if (localSite != null && !StringUtilities.isEmpty((String)localSite.getName())) {
                ObjInfo objInfo = new ObjInfo();
                objInfo.setId("LocalSiteName");
                objInfo.setOptName(localSite.getName());
                sc.addChild((AbstractSchema)objInfo);
            }
            ServerArray serverArray2 = serverArray = localSite == null ? null : localSite.getServerArray();
            if (serverArray != null) {
                for (SemServer server : serverArray.getSemServer()) {
                    if (!Manager.isLocalServer(server.getId())) continue;
                    if (StringUtilities.isEmpty((String)server.getName())) break;
                    ObjInfo objInfo = new ObjInfo();
                    objInfo.setId("LocalServerName");
                    objInfo.setOptName(server.getName());
                    sc.addChild((AbstractSchema)objInfo);
                    break;
                }
            }
            if ((localDomain = DataobjectManager.getInstance().getSemDomain(Manager.getCurrentDomainId())) != null && !StringUtilities.isEmpty((String)localDomain.getName())) {
                ObjInfo objInfo = new ObjInfo();
                objInfo.setId("LocalDomainName");
                objInfo.setOptName(localDomain.getName());
                sc.addChild((AbstractSchema)objInfo);
            }
        }
        catch (Exception ex) {
            ConsoleLogger.logError("PolicyHandler>exportPolicy>> Exception while trying to include LocalServerName,LocalSiteName and LocalDomainName in exported policy file.");
            ConsoleLogger.log(ex);
        }
    }

    static synchronized DefaultSchemaObject getDefaultSchemaObject() throws CommonException {
        if (defaultSchemaObject == null) {
            defaultSchemaObject = new DefaultSchemaObject(DataobjectManager.getInstance().getCurrentAdministrator().getName());
        }
        return defaultSchemaObject;
    }

    static {
        macAddressPool = new HashSet<String>();
        serviceIdMap = null;
        networkInterfaceIdMap = null;
        hiTemplibObjList = new ArrayList<HostIntegrityTemplateLibraryObject>();
        defaultSchemaObject = null;
        zeroList = new char[32];
        Arrays.fill(zeroList, '0');
        chooser = null;
        importFileFilter = null;
    }

    private static class CopyDialog
    extends DialogBase {
        private static final long serialVersionUID = 460043527312428151L;

        public CopyDialog(String policyName) {
            super(Manager.getFrame(), MSGRES_FILE.getString("PolicyHandler.CopyPolicyDialogTitle"), true);
            this.initialize(policyName);
            UiUtilities.centerComponent((Component)this);
        }

        @Override
        protected boolean isCancelButtonShown() {
            return false;
        }

        @Override
        protected boolean isHelpButtonShown() {
            return false;
        }

        private void initialize(String policyName) {
            final JCheckBox jCbxNoShow = new JCheckBox(MSGRES_FILE.getString("PolicyHandler.CopyPolicyDialogNoShow"));
            jCbxNoShow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        AdminObject admin = AdminObject.retrieveCurrentAdminObject();
                        admin.setDisableCopyPolicyReminder(jCbxNoShow.isSelected());
                        AdminHandler.updateAdmin(admin);
                    }
                    catch (ConsoleException e1) {
                        ConsoleLogger.log(e1);
                    }
                }
            });
            Object[] args = new Object[]{policyName};
            String copyMsg = MessageFormat.format(MSGRES_FILE.getString("PolicyHandler.CopyPolicyDialogCopyMsg"), args);
            JLabel pasteLabel = new JLabel(MSGRES_FILE.getString("PolicyHandler.CopyPolicyDialogPasteMsg"));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 30, 20));
            panel.add((Component)new DescriptionTextArea(copyMsg), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)pasteLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)jCbxNoShow, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)panel, "Center");
            this.getContentPane().add((Component)this.getButtonPanel(0, 0, true), "South");
            this.pack();
        }
    }
}

