/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.PartnerInformation;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.text.MessageFormat;
import javax.swing.JOptionPane;

public class PartnerInformationHandler
extends AbstractHandler {
    private static MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.handler.handler");

    public static PartnerInformation getPartnerInformation() {
        PartnerInformation partnerInfo;
        block2: {
            DataobjectManager data = DataobjectManager.getInstance();
            partnerInfo = null;
            try {
                SemConfigRoot semConfigRoot = data.getSemConfigRoot();
                partnerInfo = semConfigRoot.getOptPartnerInformation();
            }
            catch (ConsoleException ex) {
                Object[] obj = new Object[]{ex.getMessage()};
                String str = MSGRES.getString("PartnerInformationHandler.dataCannotBeUpdated");
                String fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MSGRES.getString("PartnerInformationHandler.errorTitle"), 0);
                if (!ex.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
        return partnerInfo;
    }

    public static void updatePartnerInformation(PartnerInformation partnerInfo) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        try {
            SemConfigRoot semConfigRoot = data.getSemConfigRoot();
            semConfigRoot.setOptPartnerInformation(partnerInfo);
            data.updateObject("Merge", (TopLevelObject)semConfigRoot);
        }
        catch (ConsoleException ce) {
            throw ce;
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }
}

