/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.rpc.SemLoginInfo;
import com.sygate.scm.common.configobject.schema.Inheritance;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.util.AdminUtils;
import com.sygate.scm.console.logicobject.AdminStateObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.MainFrame;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.Utility;
import java.util.Arrays;
import java.util.Optional;
import java.util.Vector;
import javax.smartcardio.CardTerminal;

public class Manager {
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.console");
    public static MainFrame frame = null;

    public static MainFrame getFrame() {
        return frame;
    }

    public static void setFrame(MainFrame frame) {
        Manager.frame = frame;
    }

    public static boolean keepAlive() {
        try {
            GUIManager.keepAlive();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return false;
        }
        return true;
    }

    public static void doLogin(String adminName, char[] pwd, String domainName) throws ConsoleException {
        String encryptedPwd = null;
        try {
            encryptedPwd = Utility.encryptLatest((char[])pwd);
        }
        catch (Exception e1) {
            LoggerUtilities.logException((Throwable)e1);
            throw new ConsoleException(e1);
        }
        Arrays.fill(pwd, '0');
        Manager.doLogin(adminName, encryptedPwd, null, domainName, false, false);
    }

    public static void doLogin(String adminName, String pwd, String newPassword, String domainName) throws ConsoleException {
        Manager.doLogin(adminName, pwd, newPassword, domainName, false, false);
    }

    private static void doLogin(String adminName, String password, String newPassword, String domainName, boolean isPasswordHashed, boolean switchToDomain) throws ConsoleException {
        try {
            SemLoginInfo loginInfo = DataobjectManager.getInstance().login(adminName, password, newPassword, domainName, switchToDomain);
            DataobjectManager.getInstance().init(loginInfo);
            Env.setSemVersion(loginInfo.getOptServerVersion());
            Env.setSemCedVersion(ServerVersion.CURRENT_CED_VERSION);
            Env.setDbVersion(loginInfo.getOptDbVersion());
            LicenseObject.getInstance().updateLicenseState();
        }
        catch (ConsoleException e1) {
            throw e1;
        }
        catch (Exception e1) {
            throw new ConsoleException(e1);
        }
    }

    public static boolean isConsoleLogout() {
        return frame == null || DataobjectManager.getInstance().isUnInitializedStatus() || frame.isInLoginPanel();
    }

    public static void doResetPassword(String userName, String domainName, boolean switchToDoamin, boolean forAutomation) throws ConsoleException {
        try {
            GUIManager.resetPassword(userName, domainName, switchToDoamin, forAutomation);
        }
        catch (ConsoleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public static void switchDomain(String domainId, boolean isIsSmartCardAuth, CardTerminal cardTerminal) throws ConsoleException {
        try {
            String curAdminId = Manager.isLoginAsSysAdmin() ? Manager.getCurrentAdminId() : "";
            SemLoginInfo loginInfo = GUIManager.switchDomain(curAdminId, domainId, isIsSmartCardAuth, cardTerminal);
            DataobjectManager.getInstance().init(loginInfo);
        }
        catch (ConsoleException e1) {
            throw e1;
        }
        catch (Exception e1) {
            throw new ConsoleException(e1);
        }
    }

    public static boolean isSystemAdmin(SemAdministrator admin) {
        return AdminUtils.isSysAdmin((SemAdministrator)admin);
    }

    public static boolean isLocalSite(String siteId) {
        return DataobjectManager.getInstance().getLoginInformation().getSiteGUID().equals(siteId);
    }

    public static boolean isLocalServer(String serverId) {
        return DataobjectManager.getInstance().getLoginInformation().getServerGUID().equals(serverId);
    }

    public static boolean isCurrentAdmin(String adminId) {
        return Optional.ofNullable(DataobjectManager.getInstance().getLoginInformation()).map(SemLoginInfo::getOptAdminGUID).orElse("").equals(adminId);
    }

    public static boolean isBuildInAdmin(String adminId) {
        return adminId.equals("AF3C39A10A320801000000DBF200C60A");
    }

    public static boolean isCurrentDomain(String domainId) {
        return domainId.equals(DataobjectManager.getInstance().getLoginInformation().getOptDomainGUID());
    }

    public static boolean isOnlineSubscriptionLicenseExpired() throws ConsoleException {
        LicenseObject license = LicenseObject.getInstance();
        return license.getOnlineSubscriptionExpirationDateStatus() < 1;
    }

    public static boolean isCurrentAdminPasswordExpired() throws ConsoleException {
        SemAdministrator admin = DataobjectManager.getInstance().getCurrentAdministrator();
        if (admin.getOptAuthenticationMethod() != null && (admin.getOptAuthenticationMethod().equals(SemAdministrator.SECURID) || admin.getOptAuthenticationMethod().equals(SemAdministrator.DIRECTORY) || admin.getOptAuthenticationMethod().equals(SemAdministrator.SMARTCARD))) {
            return false;
        }
        AdminStateObject adminState = AdminStateObject.retrieveAdminStateObject(admin);
        if (adminState == null) {
            return false;
        }
        return adminState.isPasswordExpired() || !adminState.hasLastPasswordChangeTime();
    }

    public static boolean isParentInheritance(int inheritanceMode) {
        return Inheritance.USE_PARENT == inheritanceMode;
    }

    public static boolean hasNoInheritance(int inheritanceMode) {
        return !Manager.isParentInheritance(inheritanceMode);
    }

    public static void doLogout(boolean cleanupCache) {
        ConsoleLogger.log("Manager> doLogout>> Begin...");
        DataobjectManager data = DataobjectManager.getInstance();
        if (data.getLoginInformation() != null) {
            try {
                ConsoleLogger.log("Manager> doLogout>> logAdminEventThrows...");
                ConsoleLogger.logAdminEventThrows(4099, MSGRES.getString("Manager.Administratorlogout"));
            }
            catch (ConsoleException ex) {
                if (ex.getErrorCode() == 0x11010000) {
                    ConsoleLogger.log("Manager> doLogout>> Session is invalid, logAdminEvent is not needed!");
                }
                ConsoleLogger.log(ex);
            }
            try {
                ConsoleLogger.log("Manager> doLogout>> GUIManager.logoff...");
                GUIManager.logoff(cleanupCache);
            }
            catch (ConsoleException ex) {
                if (ex.getErrorCode() == 0x11010000) {
                    ConsoleLogger.log("Manager> doLogout>> Session is invalid, logoff is not needed!");
                }
                ConsoleLogger.log(ex);
            }
        }
        data.reset();
        ConsoleLogger.log("Manager> doLogout>> Done!");
    }

    public static ObjReference getObjReferenceByTargetId(ObjReference[] objRefs, String targetId) {
        if (objRefs == null || objRefs.length < 1 || targetId == null || targetId.length() < 1) {
            return null;
        }
        for (ObjReference objRef : objRefs) {
            if (!objRef.getTargetId().equals(targetId)) continue;
            return objRef;
        }
        return null;
    }

    public static ObjReference getFirstObjReferenceByTargetType(Vector<ObjReference> objRefs, String targetType) {
        if (objRefs == null || objRefs.size() < 1 || targetType == null || targetType.length() < 1) {
            return null;
        }
        for (int i = 0; i < objRefs.size(); ++i) {
            if (!objRefs.get(i).getTargetType().equals(targetType)) continue;
            return objRefs.get(i);
        }
        return null;
    }

    public static String getCurrentDomainId() {
        return DataobjectManager.getInstance().getLoginInformation().getOptDomainGUID();
    }

    public static String getCurrentAdminId() {
        return DataobjectManager.getInstance().getLoginInformation().getOptAdminGUID();
    }

    public static boolean isLoginAsSysAdmin() {
        return Manager.isSystemAdmin(DataobjectManager.getInstance().getCurrentAdministrator());
    }

    public static String getCurrentSiteId() {
        return DataobjectManager.getInstance().getLoginInformation().getSiteGUID();
    }

    public static String getCurrentServerId() {
        return DataobjectManager.getInstance().getLoginInformation().getServerGUID();
    }
}

