/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.rpc.IPLRequest;
import com.sygate.scm.common.configobject.rpc.IPLResponse;
import com.sygate.scm.common.configobject.rpc.LicenseStatusInfo;
import com.sygate.scm.common.configobject.schema.CompanyInformation;
import com.sygate.scm.common.configobject.schema.ElsLicense;
import com.sygate.scm.common.configobject.schema.IPLCompanyContactInfo;
import com.sygate.scm.common.configobject.schema.IPLTechContactInfo;
import com.sygate.scm.common.configobject.schema.License;
import com.sygate.scm.common.configobject.schema.LicenseChain;
import com.sygate.scm.common.configobject.schema.OverdeployedLicense;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.license.LicenseUtils;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.logicobject.LicenseChainObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.logicobject.TrialwareLicenseObject;
import com.sygate.scm.console.logicobject.UpgradeLicenseObject;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationHandler;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.symantec.slic.ipl.CompanyInfo;
import com.symantec.slic.ipl.TechnicalContactInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class LicenseHandler
extends AbstractHandler {
    public static String getPurchaseDynamicLink() {
        String url = null;
        try {
            DataobjectManager manager = DataobjectManager.getInstance();
            SemConfigRoot root = manager.getSemConfigRoot(false);
            License lic = root.getLicense();
            OverdeployedLicense odl = lic.getOptOverdeployedLicense();
            url = odl.getOptRenewalURL().trim();
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
            ConsoleLogger.log("LicenseHandler >> Unable to get dynamic renewal url. Exception thrown while retrieving SemConfigRoot from DataobjectManager");
            LoggerUtilities.logException((Throwable)ex);
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
            ConsoleLogger.log("LicenseHandler >> Unable to get dynamic renewal url");
            LoggerUtilities.logException((Throwable)ex);
        }
        if (url != null && !url.isEmpty()) {
            return url;
        }
        try {
            url = LicenseUtils.getGenericPurchaseURL((String)Env.getNEW_PRODUCT_TYPE()).trim();
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
            ConsoleLogger.log("LicenseHandler >> Unable to get generic dynamic renewal url");
            LoggerUtilities.logException((Throwable)ex);
        }
        if (url != null && !url.isEmpty()) {
            return url;
        }
        return "";
    }

    public static ArrayList<LicenseChainObject> getLicenseChains() throws ConsoleException {
        return LicenseHandler.getLicenseChains(true);
    }

    public static ArrayList<LicenseChainObject> getLicenseChains(boolean refresh) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        SemConfigRoot root = data.getSemConfigRoot(refresh);
        ArrayList<LicenseChainObject> result = new ArrayList<LicenseChainObject>();
        Integer licenseState = root.getLicense().getOptLicenseState();
        if (licenseState.equals(License.SEPE_PAID) || licenseState.equals(License.SEPSB_PAID)) {
            ArrayList chains = LicenseUtils.getLicenseChains((SemConfigRoot)root);
            for (LicenseChain chain : chains) {
                result.add(new LicenseChainObject(chain));
            }
        }
        return result;
    }

    public static TrialwareLicenseObject getTrialwareLicense(boolean refresh) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        SemConfigRoot root = data.getSemConfigRoot(refresh);
        if (root.getLicense() == null) {
            return null;
        }
        Integer licenseState = root.getLicense().getOptLicenseState();
        if (licenseState == null) {
            return null;
        }
        if (!licenseState.equals(License.SEPE_TRIAL) && !licenseState.equals(License.SEPSB_TRIAL)) {
            return null;
        }
        if (root.getLicense().getOptTrialwareLicense() == null) {
            return null;
        }
        Boolean suspended = root.getLicense().getOptTrialwareLicense().getOptSuspended();
        if (suspended == null) {
            suspended = root.getLicense().getOptTrialwareLicense().getDefSuspended();
        }
        if (suspended == null || suspended.booleanValue()) {
            return null;
        }
        return new TrialwareLicenseObject(root.getLicense().getOptTrialwareLicense());
    }

    public static UpgradeLicenseObject getUpgradeLicense(boolean refresh) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        SemConfigRoot root = data.getSemConfigRoot(refresh);
        if (root.getLicense() == null) {
            return null;
        }
        Integer licenseState = root.getLicense().getOptLicenseState();
        if (licenseState == null) {
            return null;
        }
        if (!licenseState.equals(License.SEPE_UPGRADE)) {
            return null;
        }
        if (root.getLicense().getOptUpgradeLicense() == null || root.getLicense().getOptUpgradeLicense().getOptSuspended() == null || root.getLicense().getOptUpgradeLicense().getOptSuspended().booleanValue()) {
            return null;
        }
        return new UpgradeLicenseObject(root.getLicense().getOptUpgradeLicense());
    }

    public static String getProductType() throws ConsoleException {
        String type = null;
        ArrayList<LicenseChainObject> chains = LicenseHandler.getLicenseChains();
        for (LicenseChainObject chain : chains) {
            ElsLicenseObject lastLicense = chain.getLastLicense();
            if (lastLicense == null || (type = lastLicense.getProductType()) == null || "UNKNOWN".equals(type)) continue;
            return type;
        }
        TrialwareLicenseObject twLicense = LicenseHandler.getTrialwareLicense(true);
        if (twLicense != null) {
            type = twLicense.getProductType();
        }
        if (type != null && !"UNKNOWN".equals(type)) {
            return type;
        }
        return "UNKNOWN";
    }

    public static int getIndexOfLicense(String id, List<? extends TreeItem> objects) {
        int it = -1;
        for (TreeItem treeItem : objects) {
            ++it;
            if (!id.equals(treeItem.getId())) continue;
            return it;
        }
        return -1;
    }

    public static LicenseChainObject newLicenseChain(ElsLicenseObject license) {
        LicenseChain chain = new LicenseChain();
        chain.setId(new GUIDGenerator().getGUIDString());
        chain.addChild((AbstractSchema)license.getElsLicense());
        chain.setOptClientProductType(license.getElsLicense().getOptClientProductType());
        chain.setDirty();
        LicenseUtils.updateChainProperties((LicenseChain)chain);
        LicenseChainObject chainObj = new LicenseChainObject(chain);
        return chainObj;
    }

    public static boolean licenseExists(ElsLicenseObject license) throws ConsoleException {
        if (license == null) {
            return false;
        }
        for (LicenseChainObject chain : LicenseHandler.getLicenseChains()) {
            for (ElsLicenseObject chainLicense : chain.getLicenses()) {
                if (!LicenseUtils.licensesIdentical((ElsLicense)license.getElsLicense(), (ElsLicense)chainLicense.getElsLicense())) continue;
                return true;
            }
        }
        return false;
    }

    public static LicenseChain addLicenseChainToSystem(LicenseChainObject chain, LicenseActivationHandler.LICENSE_FLOW licenseFlow) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        return data.importLicense(chain.getLicenseChain(), licenseFlow);
    }

    public static void removeLicenseChainFromSystem(LicenseChainObject chain) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        data.deleteLicense(chain.getLicenseChain());
    }

    public static void addLicenseRenewalToSystem(LicenseChainObject chain) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        data.renewLicense(chain.getLicenseChain());
    }

    public static void addTrialwareLicenseToSystem(TrialwareLicenseObject license) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        data.importLicense(license.getTrialwareLicense());
    }

    public static LicenseStatusInfo getLicenseStatusForSAV() throws ConsoleException {
        if (LicenseObject.getInstance().isSAVOnlyProduct() || LicenseObject.getInstance().isALLProduct()) {
            return GUIManager.getLicenseStatusForSAV();
        }
        return null;
    }

    public static LicenseStatusInfo getLicenseStatusForSNAC() throws ConsoleException {
        if (LicenseObject.getInstance().isSNACOnlyProduct() || LicenseObject.getInstance().isALLProduct()) {
            return GUIManager.getLicenseStatusForSNAC();
        }
        return null;
    }

    public static boolean hasValidLicense() throws ConsoleException {
        long now = new Date().getTime();
        ArrayList<LicenseChainObject> chains = LicenseHandler.getLicenseChains();
        for (LicenseChainObject chain : chains) {
            ArrayList<ElsLicenseObject> licenses = chain.getLicenses();
            for (ElsLicenseObject license : licenses) {
                if (license.getEndDate() <= now) continue;
                return true;
            }
        }
        TrialwareLicenseObject twLic = LicenseHandler.getTrialwareLicense(true);
        if (twLic != null && twLic.getEndDate() > now) {
            return true;
        }
        UpgradeLicenseObject upLic = LicenseHandler.getUpgradeLicense(true);
        return upLic != null && upLic.getEndDate() > now;
    }

    public static boolean isPEPActivated() {
        return ScmProperties.isPepActivated() || LicenseObject.getInstance().isPEPActivated();
    }

    public static Integer getLicenseState() {
        Integer retVal = License.UNKNOWN;
        try {
            SemConfigRoot root = DataobjectManager.getInstance().getSemConfigRoot(true);
            if (root.getLicense() != null && root.getLicense().getOptLicenseState() != null) {
                License lic = root.getLicense();
                retVal = lic.getOptLicenseState();
            }
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
        }
        return retVal;
    }

    public static IPLResponse getEntitlementsFromIPL(IPLRequest iPLRequest) throws ConsoleException {
        return GUIManager.getEntitlementsFromIPL((AbstractSchema)iPLRequest);
    }

    public static IPLTechContactInfo prepopulateTechContactInfo() {
        DataobjectManager data = DataobjectManager.getInstance();
        try {
            SemConfigRoot root = data.getSemConfigRoot(true);
            if (root.getLicense() == null || root.getLicense().getOptIPLTechContactInfo() == null) {
                return null;
            }
            return root.getLicense().getOptIPLTechContactInfo();
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
            return null;
        }
    }

    public static IPLCompanyContactInfo prepopulateCompanyContactInfo(HashMap<String, String> countryMap) {
        DataobjectManager data = DataobjectManager.getInstance();
        try {
            SemConfigRoot root = data.getSemConfigRoot(true);
            if (root.getLicense() == null || root.getLicense().getOptIPLCompanyContactInfo() == null) {
                return null;
            }
            return root.getLicense().getOptIPLCompanyContactInfo();
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
            return null;
        }
    }

    public static CompanyInformation getCompanyInformation(boolean refresh) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        SemConfigRoot root = data.getSemConfigRoot(refresh);
        if (root.getOptCompanyInformation() == null) {
            return null;
        }
        return root.getOptCompanyInformation();
    }

    public static String getCompanyName() {
        try {
            CompanyInformation partnerCompanyInformation = LicenseHandler.getCompanyInformation(true);
            if (partnerCompanyInformation != null && partnerCompanyInformation.getOptCompanyName() != null) {
                return partnerCompanyInformation.getOptCompanyName();
            }
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
        }
        return null;
    }

    public static void saveTechContactInfo(TechnicalContactInfo technicalContactInfo) {
        DataobjectManager data = DataobjectManager.getInstance();
        License schemaLicense = null;
        IPLTechContactInfo schemaTechContactInfo = null;
        try {
            SemConfigRoot root = data.getSemConfigRoot(true);
            if (root.getLicense() == null) {
                return;
            }
            schemaLicense = root.getLicense();
            if (schemaLicense.getOptIPLTechContactInfo() == null) {
                schemaTechContactInfo = new IPLTechContactInfo();
                schemaLicense.setOptIPLTechContactInfo(schemaTechContactInfo);
                schemaLicense.setDirty();
            } else {
                schemaTechContactInfo = schemaLicense.getOptIPLTechContactInfo();
            }
            if (technicalContactInfo != null && schemaTechContactInfo != null) {
                schemaTechContactInfo.setOptTechContactFirstName(technicalContactInfo.getContactName().getFirstName());
                schemaTechContactInfo.setOptTechContactLastName(technicalContactInfo.getContactName().getLastName());
                schemaTechContactInfo.setOptTechContactPhoneNumber(technicalContactInfo.getPhoneNumber());
                schemaTechContactInfo.setOptTechContactEmailAddress(technicalContactInfo.getEmailAddress());
                schemaTechContactInfo.setDirty();
            }
            data.updateSemConfigRoot("Merge", root);
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
        }
    }

    public static void saveCompanyContactInfo(CompanyInfo companyInfo, HashMap<String, String> countryMap) {
        DataobjectManager data = DataobjectManager.getInstance();
        License schemaLicense = null;
        IPLCompanyContactInfo schemaCompanyContactInfo = null;
        try {
            SemConfigRoot root = data.getSemConfigRoot(true);
            if (root.getLicense() == null) {
                return;
            }
            schemaLicense = root.getLicense();
            schemaCompanyContactInfo = schemaLicense.getOptIPLCompanyContactInfo();
            if (schemaCompanyContactInfo == null) {
                schemaCompanyContactInfo = new IPLCompanyContactInfo();
                schemaLicense.setOptIPLCompanyContactInfo(schemaCompanyContactInfo);
                schemaLicense.setDirty();
            }
            if (companyInfo != null) {
                schemaCompanyContactInfo.setOptContactFirstName(companyInfo.getContactName().getFirstName());
                schemaCompanyContactInfo.setOptContactLastName(companyInfo.getContactName().getLastName());
                schemaCompanyContactInfo.setOptContactPhoneNumber(companyInfo.getPhoneNumber());
                schemaCompanyContactInfo.setOptContactEmailAddress(companyInfo.getEmailAddress());
                schemaCompanyContactInfo.setOptCompanyName(companyInfo.getCompanyName());
                schemaCompanyContactInfo.setOptCompanyInfoAddress1(companyInfo.getMailingAddress().getStreetAddress().getFirstLine());
                schemaCompanyContactInfo.setOptCompanyInfoAddress2(companyInfo.getMailingAddress().getStreetAddress().getSecondLine());
                schemaCompanyContactInfo.setOptCompanyInfoAddress3(companyInfo.getMailingAddress().getStreetAddress().getThirdLine());
                if (countryMap.containsKey(companyInfo.getMailingAddress().getCountry())) {
                    schemaCompanyContactInfo.setOptCompanyInfoCountry(companyInfo.getMailingAddress().getCountry());
                } else {
                    schemaCompanyContactInfo.setOptCompanyInfoCountry("US");
                }
                schemaCompanyContactInfo.setOptCompanyInfoState(companyInfo.getMailingAddress().getStateOrProvince());
                schemaCompanyContactInfo.setOptCompanyInfoCity(companyInfo.getMailingAddress().getCity());
                schemaCompanyContactInfo.setOptCompanyInfoPostalCode(companyInfo.getMailingAddress().getPostalCode());
                schemaCompanyContactInfo.setDirty();
            }
            data.updateSemConfigRoot("Merge", root);
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
        }
    }
}

