/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.RpcDataAdapter;
import com.sygate.scm.common.configobject.rpc.LdapSetting;
import com.sygate.scm.common.configobject.rpc.NameValuePair;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.ImportUserResultSet;
import com.sygate.scm.console.handler.SemClientHandler;
import com.sygate.scm.console.handler.UserSaxHandler;
import com.sygate.scm.console.logicobject.UserObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.TimeCounter;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;

public class ImportLDAPHandler
extends AbstractHandler {
    private static RpcData generateRpcDataForUserList(LdapSetting ls, boolean all, String id, boolean refresh, int start, int end) {
        return ImportLDAPHandler.generateRpcDataForUserList(ls, all, id, null, refresh, start, end, "START_QUERY_LDAPUSERS");
    }

    private static RpcData generateRpcDataForAddAll(LdapSetting ls, boolean all, String queryId, String clientGroupId, boolean refresh) {
        return ImportLDAPHandler.generateRpcDataForUserList(ls, all, queryId, clientGroupId, refresh, -1, -1, "START_IMPORT_LDAPUSERS");
    }

    private static RpcData generateRpcDataForUserList(LdapSetting ls, boolean all, String queryId, String clientGroupId, boolean refresh, int start, int end, String command) {
        if (ls == null) {
            return null;
        }
        RpcDataAdapter data = new RpcDataAdapter();
        data.put("LDAP_SERVER", ls.getLdapServer());
        data.put("LDAP_PORT_NUMBER", (Object)ls.getOptPortNumber());
        boolean ssl = ls.getOptUseSSL() != null ? ls.getOptUseSSL() : ls.getDefUseSSL();
        data.put("LDAP_SSL", ssl);
        data.put("LDAP_SEARCH_BASE", ls.getOptSearchBase());
        data.put("LDAP_USER_NAME", ls.getOptAuthAccount());
        data.put("LDAP_PASSWORD", ls.getOptPassword());
        data.put("LDAP_FILTER", ls.getOptFilter());
        data.put("LIST_ALL", String.valueOf(all));
        data.put("LDAP_QUERY_ID", queryId);
        data.put("COMMAND", command);
        data.put("REFRESH", Boolean.toString(refresh));
        if (start > -1) {
            data.put("LDAP_RESULT_SET_START", start);
        }
        if (end > -1) {
            data.put("LDAP_RESULT_SET_END", end);
        }
        if (clientGroupId != null) {
            data.put("ClientGroupId", clientGroupId);
        }
        return data;
    }

    public static ImportUserResultSet getUserList(LdapSetting ls, boolean all, String id, boolean refresh, int start, int end) {
        RpcData data = ImportLDAPHandler.generateRpcDataForUserList(ls, all, id, refresh, start, end);
        if (data == null) {
            return null;
        }
        return ImportLDAPHandler.getLdapUsers(data, all);
    }

    public static ImportUserResultSet addAllUsers(LdapSetting ls, boolean all, String queryId, String clientGroupId, boolean refresh) {
        RpcData data = ImportLDAPHandler.generateRpcDataForAddAll(ls, all, queryId, clientGroupId, refresh);
        if (data == null) {
            return null;
        }
        return ImportLDAPHandler.getLdapUsers(data, all);
    }

    public static void stopQueryLdapUsers(String id) {
        RpcData data = new RpcData();
        NameValuePair pair = new NameValuePair();
        pair.setName("LDAP_QUERY_ID");
        pair.setOptValue(id);
        data.addNameValuePair(pair);
        pair = new NameValuePair();
        pair.setName("COMMAND");
        pair.setOptValue("STOP_QUERY_LDAPUSERS");
        data.addNameValuePair(pair);
        try {
            GUIManager.sendCommand("ImportLDAP", (AbstractSchema)data);
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public static void addUser(UserObject user, String groupId) throws ConsoleException {
        if (user == null) {
            return;
        }
        user.setGroupId(groupId);
        SemClientHandler.addClient(user);
        ConsoleLogger.logAdminEvent(8212, null, user.getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImportUserResultSet getLdapUsers(RpcData data, boolean all) {
        TimeCounter counter = new TimeCounter();
        counter.start();
        System.out.println("ImportLDAPHandler>> getLdapUsers: Begin... " + counter.getStartTime());
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(GUIManager.getLdapUsers((AbstractSchema)data));
            System.out.println("<<< before IMPORT LDAP: " + ImportLDAPHandler.getMemString());
            UserSaxHandler handler = new UserSaxHandler(all, true);
            List<UserObject> list = handler.parse(is);
            ImportUserResultSet retValue = new ImportUserResultSet(list, handler.getTotalResultSetCount());
            int size = list == null ? 0 : list.size();
            System.out.println("<<< after IMPORT LDAP: " + ImportLDAPHandler.getMemString() + ", size=" + size);
            ImportUserResultSet importUserResultSet = retValue;
            return importUserResultSet;
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            ImportUserResultSet importUserResultSet = new ImportUserResultSet(ex);
            return importUserResultSet;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable) {}
            }
            System.out.println("ImportLDAPHandler>> getLdapUsers: Done. " + counter.toString());
        }
    }

    private static String getMemString() {
        Runtime rt = Runtime.getRuntime();
        long total = rt.totalMemory();
        long max = rt.maxMemory();
        long free = rt.freeMemory();
        return "Total mem: " + total + " Max mem: " + max + " Free mem: " + free;
    }
}

