/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroupPool;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfacePool;
import com.sygate.scm.common.configobject.schema.FwNetworkServicePool;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SymantecMessageDigest;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import org.xml.sax.SAXException;

public class ImportConfigObjHandler
extends AbstractHandler {
    private final Map<String, String> washedIdPool = new HashMap<String, String>();
    private final Map<String, String> washedIdReversePool = new HashMap<String, String>();
    private final Set<ConfigObject> washedObjPool = new HashSet<ConfigObject>();
    private final Set<ConfigObject> washedItemPool = new HashSet<ConfigObject>();
    private Map<String, TopLevelObject> objReferencePool;
    private Hashtable<String, File> importedPhysicalFiles;
    private boolean isCanceled = false;
    private String ownerId = "";
    private final Map<String, String> importedPoolObjectMap = new HashMap<String, String>();

    public ConfigObject importObject(ConfigObject obj, Map<String, TopLevelObject> newObjSet) throws Exception {
        if (this.isCanceled) {
            return null;
        }
        this.washedIdPool.clear();
        this.washedObjPool.clear();
        this.washedItemPool.clear();
        ConfigObject newObj = this.importObject(obj);
        newObj = this.replaceReferenceId(newObj, newObjSet);
        return newObj;
    }

    private ConfigObject importObject(ConfigObject obj) throws ConsoleException {
        if (this.isCanceled) {
            return null;
        }
        ConfigObject newObj = PolicyHandler.getCopyOfObj(obj);
        this.reinitializeObject(newObj);
        if (this.isCanceled) {
            return null;
        }
        this.washedObjPool.add(newObj);
        return newObj;
    }

    private void reinitializeObject(ConfigObject obj) throws ConsoleException {
        com.sygate.scm.hi.library.ObjReference refer;
        if (this.isCanceled) {
            return;
        }
        if (this.washedItemPool.contains(obj)) {
            return;
        }
        this.washedItemPool.add(obj);
        obj.init();
        try {
            try {
                Method method = obj.getClass().getMethod("getId", new Class[0]);
                String oldID = (String)method.invoke((Object)obj, new Object[0]);
                String newID = this.washedIdPool.get(oldID);
                if (newID != null) {
                    return;
                }
                method = obj.getClass().getMethod("setId", String.class);
                newID = new GUIDGenerator().getGUIDString();
                method.invoke((Object)obj, newID);
                if (obj.getObjectTypeName().equalsIgnoreCase("AvPolicy")) {
                    this.ownerId = newID;
                }
                this.washedIdPool.put(oldID, newID);
                this.washedIdReversePool.put(newID, oldID);
            }
            catch (NoSuchMethodException method) {}
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        if (obj instanceof UnknownContent) {
            UnknownContent unknown = (UnknownContent)obj;
            try {
                ConfigObject subObj = (ConfigObject)AbstractSchema.readXML((byte[])unknown.getContent());
                this.reinitializeObject(subObj);
                unknown.setConent(subObj.getBytes());
            }
            catch (SAXException e) {
                LoggerUtilities.logException((Throwable)e);
                throw new ConsoleException(e);
            }
            catch (IOException e) {
                LoggerUtilities.logException((Throwable)e);
                throw new ConsoleException(e);
            }
            catch (ValidationException e) {
                LoggerUtilities.logException((Throwable)e);
                throw new ConsoleException(e);
            }
        }
        if (obj instanceof com.sygate.scm.hi.library.ObjReference) {
            PhysicalFile pFile;
            boolean isSamePhysicalFileID;
            DataobjectManager dataManager;
            String referredFileName;
            String referId;
            block35: {
                refer = (com.sygate.scm.hi.library.ObjReference)obj;
                referId = refer.getTargetId();
                PhysicalFile referredObj = null;
                if (this.objReferencePool.containsKey(referId)) {
                    referredObj = (PhysicalFile)this.objReferencePool.get(referId);
                }
                if (referredObj == null) {
                    throw new ConsoleException(0x16010000);
                }
                referredFileName = referredObj.getFileName();
                dataManager = DataobjectManager.getInstance();
                isSamePhysicalFileID = false;
                try {
                    pFile = dataManager.getPhysicalFile(referId);
                    if (pFile != null) {
                        isSamePhysicalFileID = true;
                    }
                }
                catch (ConsoleException ce) {
                    if (ce.getErrorCode() == 0x16010000) break block35;
                    throw ce;
                }
            }
            if (!isSamePhysicalFileID) {
                File importedFile = this.importedPhysicalFiles.get(referredFileName);
                pFile = this.createNewPhysicalFile(importedFile);
                pFile.setId(referId);
                pFile.setName(referId);
                dataManager.addObject((TopLevelObject)pFile);
                ObjReference ref = pFile.getObjReference();
                GUIManager.addFile(ref.getTargetId(), pFile.getFileName());
            }
        }
        if (obj instanceof ObjReference) {
            refer = (ObjReference)obj;
            String targetType = refer.getTargetType();
            String referId = refer.getTargetId();
            TopLevelObject referredObj = null;
            if (this.objReferencePool.containsKey(referId)) {
                referredObj = this.objReferencePool.get(referId);
            }
            if (referredObj == null) {
                throw new ConsoleException(0x16010000);
            }
            if ("AdminDefinedScan".equalsIgnoreCase(targetType) || "MacAdminDefinedScan".equalsIgnoreCase(targetType) || "LinuxAdminDefinedScan".equalsIgnoreCase(targetType)) {
                MetadataAttributes mAttr = referredObj.getMetadataAttributes();
                mAttr.setOwner(new GUID(this.ownerId));
                referredObj.setMetadataAttributes(mAttr);
            }
            try {
                String newId;
                Method method = referredObj.getClass().getMethod("getName", new Class[0]);
                String referredObjName = (String)method.invoke((Object)referredObj, new Object[0]);
                if (referredObj.isPrivateObject()) {
                    newId = this.getNewReferenceId(true, targetType, referredObj, referredObjName);
                    refer.setTargetId(newId);
                } else {
                    newId = this.importedPoolObjectMap.get(referId);
                    if (newId != null) {
                        refer.setTargetId(newId);
                    } else {
                        newId = this.getNewReferenceId(false, targetType, referredObj, referredObjName);
                        if (newId == null) {
                            System.out.println("has error");
                        } else {
                            refer.setTargetId(newId);
                            this.importedPoolObjectMap.put(referId, newId);
                        }
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        for (AbstractSchema child : obj.getChildren()) {
            this.reinitializeObject((ConfigObject)child);
        }
    }

    private String getNewReferenceId(boolean isPrivate, String targetType, TopLevelObject referredObj, String referredObjName) throws ConsoleException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int i;
        SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
        if (isPrivate) {
            return this.createNewStandaloneTopLevelObj(currentDomain, referredObj, referredObjName, targetType);
        }
        String newId = null;
        ObjectPool objectPool = currentDomain.getObjectPool();
        Vector<ObjReference> allObjRefs = new Vector<ObjReference>();
        FwNetworkServicePool pool = null;
        if (targetType.equals("FwNetworkServiceGroup")) {
            FwNetworkServicePool srvGrpPool;
            pool = srvGrpPool = objectPool.getOptFwNetworkServicePool();
            for (i = 0; i < srvGrpPool.getObjReferenceCount(); ++i) {
                allObjRefs.add(srvGrpPool.getObjReference(i));
            }
        } else if (targetType.equals("FwNetworkInterfaceGroup")) {
            FwNetworkInterfacePool intfGrpPool = objectPool.getOptFwNetworkInterfacePool();
            if (intfGrpPool != null) {
                pool = intfGrpPool;
                for (i = 0; i < intfGrpPool.getObjReferenceCount(); ++i) {
                    allObjRefs.add(intfGrpPool.getObjReference(i));
                }
            }
        } else if (targetType.equals("FwNetworkHostGroup")) {
            FwNetworkHostGroupPool hostGrpPool = objectPool.getOptFwNetworkHostGroupPool();
            if (hostGrpPool == null) {
                hostGrpPool = new FwNetworkHostGroupPool();
                objectPool.setOptFwNetworkHostGroupPool(hostGrpPool);
            }
            pool = hostGrpPool;
            for (i = 0; i < hostGrpPool.getObjReferenceCount(); ++i) {
                allObjRefs.add(hostGrpPool.getObjReference(i));
            }
        }
        if (pool == null) {
            // empty if block
        }
        boolean found = false;
        for (i = 0; i < allObjRefs.size(); ++i) {
            ObjReference ref = (ObjReference)allObjRefs.get(i);
            TopLevelObject topObj = DataobjectManager.getInstance().getObjectByGUID(targetType, ref.getTargetId());
            Method method = topObj.getClass().getMethod("getName", new Class[0]);
            String topObjName = (String)method.invoke((Object)topObj, new Object[0]);
            if (!referredObjName.equals(topObjName)) continue;
            found = true;
            method = topObj.getClass().getMethod("getOptObjAttributes", new Class[0]);
            Long objAttribute = (Long)method.invoke((Object)referredObj, new Object[0]);
            boolean isSystem = true;
            if (objAttribute == null || objAttribute != 1L) {
                isSystem = false;
            }
            if (isSystem) {
                newId = topObj.getId();
                break;
            }
            Object rferedObjectName = "";
            rferedObjectName = targetType.equals("FwNetworkServiceGroup") ? MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ImportConfigObjHandler.ImportingDlg.fwNetworkServiceGroupDesc") + " " + referredObjName : (targetType.equals("FwNetworkInterfaceGroup") ? MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ImportConfigObjHandler.ImportingDlg.fwNetworkInterfaceGroupDesc") + " " + referredObjName : (targetType.equals("FwNetworkHostGroup") ? MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ImportConfigObjHandler.ImportingDlg.fwNetworkHostGroupDesc") + " " + referredObjName : referredObjName));
            ImportingDlg dlg = new ImportingDlg(MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ImportConfigObjHandler.ImportingDlg.title"), (String)rferedObjectName);
            dlg.setVisible(true);
            if (!dlg.isCanceled()) {
                switch (dlg.getChoice()) {
                    case 0: {
                        newId = topObj.getId();
                        break;
                    }
                    case 1: {
                        newId = this.overwriteOldObj(currentDomain, (ConfigObject)pool, topObj, referredObj, referredObjName, targetType);
                        break;
                    }
                    case 2: {
                        newId = this.createNewObj(currentDomain, (ConfigObject)pool, referredObj, dlg.getNewName(), targetType);
                        break;
                    }
                }
                continue;
            }
            this.isCanceled = true;
            return null;
        }
        if (!found) {
            if (pool != null) {
                newId = this.createNewObj(currentDomain, (ConfigObject)pool, referredObj, referredObjName, targetType);
            } else {
                ConsoleLogger.log("ImportConfigObjHandler> getNewReferenceId>> pool was null!");
            }
        }
        return newId;
    }

    private String overwriteOldObj(SemDomain currentDomain, ConfigObject pool, TopLevelObject oldObj, TopLevelObject newObj, String newName, String targetType) throws ConsoleException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String newId = oldObj.getId();
        oldObj = newObj;
        Method method = oldObj.getClass().getMethod("setId", String.class);
        method.invoke((Object)oldObj, newId);
        DataobjectManager.getInstance().updateObject("Merge", oldObj);
        return newId;
    }

    private String createNewStandaloneTopLevelObj(SemDomain currentDomain, TopLevelObject newObj, String newName, String targetType) throws ConsoleException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String newId = new GUIDGenerator().getGUIDString();
        Method method = newObj.getClass().getMethod("setId", String.class);
        method.invoke((Object)newObj, newId);
        method = newObj.getClass().getMethod("setName", String.class);
        method.invoke((Object)newObj, newName);
        ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry(newObj, 1);
        updateList.add(entry);
        entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)currentDomain, 0);
        updateList.add(entry);
        DataobjectManager.getInstance().updateObject("Merge", updateList);
        return newId;
    }

    private String createNewObj(SemDomain currentDomain, ConfigObject pool, TopLevelObject newObj, String newName, String targetType) throws ConsoleException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String newId = new GUIDGenerator().getGUIDString();
        Method method = newObj.getClass().getMethod("setId", String.class);
        method.invoke((Object)newObj, newId);
        method = newObj.getClass().getMethod("setName", String.class);
        method.invoke((Object)newObj, newName);
        method = pool.getClass().getMethod("addObjReference", ObjReference.class);
        ObjReference ref = new ObjReference();
        ref.setTargetId(newId);
        ref.setTargetType(targetType);
        ref.setName(newName);
        method.invoke((Object)pool, ref);
        ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry(newObj, 1);
        updateList.add(entry);
        entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)currentDomain, 0);
        updateList.add(entry);
        DataobjectManager.getInstance().updateObject("Merge", updateList);
        return newId;
    }

    private ConfigObject replaceReferenceId(ConfigObject curObj, Map<String, TopLevelObject> newObjSet) throws Exception {
        ConfigObject newObj = null;
        for (ConfigObject oneObj : this.washedObjPool) {
            String xmlString = oneObj.getString();
            for (Map.Entry<String, String> oneEntry : this.washedIdPool.entrySet()) {
                String oldId = oneEntry.getKey();
                String newId = oneEntry.getValue();
                xmlString = xmlString.replaceAll(oldId, newId);
            }
            if (curObj == oneObj) {
                newObj = (ConfigObject)AbstractSchema.readXML((String)xmlString);
                if (!(oneObj instanceof TopLevelObject)) continue;
                MetadataAttributes mAttr = ((TopLevelObject)oneObj).getMetadataAttributes();
                ((TopLevelObject)newObj).setMetadataAttributes(mAttr);
                continue;
            }
            TopLevelObject addedObj = (TopLevelObject)AbstractSchema.readXML((String)xmlString);
            MetadataAttributes mAttr = ((TopLevelObject)oneObj).getMetadataAttributes();
            addedObj.setMetadataAttributes(mAttr);
            String oldID = this.washedIdReversePool.get(addedObj.getId());
            newObjSet.put(oldID, addedObj);
            PolicyHandler.newObjectPool.put(addedObj.getId(), addedObj);
        }
        return newObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getFileCheckSum(File file) {
        String string;
        MessageDigest digest = null;
        try {
            digest = SymantecMessageDigest.getInstance();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LoggerUtilities.logException((Throwable)e);
            return "";
        }
        DigestInputStream dis = null;
        try {
            dis = new DigestInputStream(new FileInputStream(file), digest);
            byte[] b = new byte[2048];
            while (dis.read(b) != -1) {
            }
            string = Utility.toHexString((byte[])digest.digest());
        }
        catch (FileNotFoundException e) {
            LoggerUtilities.logException((Throwable)e);
            String string2 = "";
            IOUtilities.closeInputStream((InputStream)dis);
            return string2;
        }
        catch (IOException ioe) {
            LoggerUtilities.logException((Throwable)ioe);
            String string3 = "";
            {
                catch (Throwable throwable) {
                    IOUtilities.closeInputStream(dis);
                    throw throwable;
                }
            }
            IOUtilities.closeInputStream((InputStream)dis);
            return string3;
        }
        IOUtilities.closeInputStream((InputStream)dis);
        return string;
    }

    private PhysicalFile createNewPhysicalFile(File f) {
        PhysicalFile pFile = new PhysicalFile();
        pFile.setCreationTime(Long.valueOf(f.lastModified()));
        pFile.setFileChecksum(this.getFileCheckSum(f));
        pFile.setFileLastModifiedTime(Long.valueOf(f.lastModified()));
        pFile.setFileName(f.getPath());
        pFile.setFileSize(Long.valueOf(f.length()));
        ObjReference objRef = new ObjReference();
        objRef.setName("LinkToFileContent");
        objRef.setTargetType("ExPhysicalFileStream");
        String physicalFileId = new GUIDGenerator().getGUIDString();
        objRef.setTargetId(physicalFileId);
        pFile.setObjReference(objRef);
        return pFile;
    }

    public void setPhysicalFiles(Hashtable<String, File> fileList) {
        Hashtable tempPhysicalFiles;
        this.importedPhysicalFiles = tempPhysicalFiles = (Hashtable)(fileList == null ? null : fileList.clone());
    }

    public void setObjReferencePool(Map<String, TopLevelObject> pool) {
        this.objReferencePool = pool;
    }

    public static class ImportingDlg
    extends JDialog {
        private static final long serialVersionUID = 3151716405685573753L;
        public static final int USEEXISTING = 0;
        public static final int OVERWRITE = 1;
        public static final int CREATENEW = 2;
        private final JRadioButton useRdBtn = new JRadioButton();
        private final JRadioButton overwriteRdBtn = new JRadioButton();
        private final JRadioButton createNewRdBtn = new JRadioButton();
        private final JTextField newNameTxtField = new JTextField();
        private final JButton okBtn = new JButton();
        private final JLabel nameLabel = new JLabel();
        private final DescriptionTextArea infoLabel = new DescriptionTextArea();
        private final JButton cancelBtn = new JButton();
        private final String existingName;
        private boolean isCanceled = true;
        private int choice = -1;

        public ImportingDlg(String title, String existingName) {
            super(Manager.getFrame(), title, true);
            this.existingName = existingName;
            try {
                this.jbInit();
            }
            catch (Exception e) {
                LoggerUtilities.logException((Throwable)e);
            }
        }

        private void jbInit() throws Exception {
            this.setSize(new Dimension(380, 240));
            JPanel panel = new JPanel();
            GridBagLayout gridBagLayout1 = new GridBagLayout();
            panel.setLayout(gridBagLayout1);
            this.useRdBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ImportConfigObjHandler.ImportingDlg.checkbox.use"));
            this.useRdBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (useRdBtn.isSelected()) {
                        choice = 0;
                        newNameTxtField.setEnabled(false);
                    }
                }
            });
            this.overwriteRdBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ImportConfigObjHandler.ImportingDlg.checkbox.overwrite"));
            this.overwriteRdBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (overwriteRdBtn.isSelected()) {
                        choice = 1;
                        newNameTxtField.setEnabled(false);
                    }
                }
            });
            this.createNewRdBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ImportConfigObjHandler.ImportingDlg.checkbox.create"));
            this.createNewRdBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (createNewRdBtn.isSelected()) {
                        choice = 2;
                        newNameTxtField.setEnabled(true);
                    }
                }
            });
            this.okBtn.setText(UIText.get(3584));
            this.okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.okBtn_actionPerformed();
                }
            });
            this.nameLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ImportConfigObjHandler.ImportingDlg.lable.nameLabel"));
            this.cancelBtn.setText(UIText.get(512));
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    isCanceled = true;
                    this.dispose();
                }
            });
            this.infoLabel.setText(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ImportConfigObjHandler.ImportingDlg.lable.infoLabelDescription"), this.existingName));
            ButtonGroup group = new ButtonGroup();
            group.add(this.useRdBtn);
            group.add(this.overwriteRdBtn);
            group.add(this.createNewRdBtn);
            this.useRdBtn.setSelected(true);
            this.choice = 0;
            this.newNameTxtField.setEnabled(false);
            panel.add((Component)this.infoLabel, new GridBagConstraints(0, 0, 8, 1, 0.0, 0.0, 17, 0, new Insets(20, 25, 0, 64), 9, 1));
            panel.add((Component)this.cancelBtn, new GridBagConstraints(3, 6, 3, 1, 0.0, 0.0, 10, 0, new Insets(15, 0, 18, 70), 8, 2));
            panel.add((Component)this.nameLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 65, 0, 0), 9, 1));
            panel.add((Component)this.okBtn, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 0, new Insets(15, 95, 18, 0), 26, 2));
            panel.add((Component)this.newNameTxtField, new GridBagConstraints(1, 4, 5, 2, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 111), 20, 0));
            panel.add((Component)this.createNewRdBtn, new GridBagConstraints(0, 3, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 40, 0, 0), 0, 2));
            PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
            if (!AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
                panel.add((Component)this.overwriteRdBtn, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 40, 0, 0), 2, 2));
            }
            panel.add((Component)this.useRdBtn, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 40, 0, 0), 27, 2));
            this.getContentPane().add(panel);
            UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.okBtn);
            UiUtilities.centerComponent((Component)this);
        }

        private void okBtn_actionPerformed() {
            if (this.createNewRdBtn.isSelected() && (this.newNameTxtField.getText() == null || this.newNameTxtField.getText().trim().length() == 0)) {
                JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "ImportConfigObjHandler.ImportingDlg.ConfirmMessage"));
                this.newNameTxtField.requestFocusInWindow();
                return;
            }
            this.isCanceled = false;
            this.dispose();
        }

        public void setUseRdBtnVisible(boolean enabled) {
            this.useRdBtn.setVisible(enabled);
        }

        public void setOverwriteRdBtnSelected(boolean selected) {
            this.overwriteRdBtn.setSelected(true);
            this.choice = 1;
        }

        public void setCreateRdBtnText(String text) {
            this.createNewRdBtn.setText(text);
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public int getChoice() {
            return this.choice;
        }

        public String getNewName() {
            return this.newNameTxtField.getText();
        }
    }
}

