/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.RpcDataAdapter;
import com.sygate.scm.common.configobject.rpc.OrganizationalUnit;
import com.sygate.scm.common.configobject.schema.DirectoryServer;
import com.sygate.scm.common.configobject.schema.DirectoryServerIntegration;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemClientGroupTree;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.ServerArray;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.OrganizationalUnitObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ldap.LdapPath;
import com.sygate.scm.util.ldap.LdapUtilsLegacy;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class ImportADSIHandler
extends AbstractHandler {
    private static final int FIND_EXACT_MATCH = 0;
    private static final int FIND_FIRST_AD_CHILD = 1;
    private static final int FIND_FIRST_AD_PARENT = 2;
    private static final int FIND_EXACT_MATCH_CHILD_OR_PARENT = 3;
    private static final int FIND_EXACT_MATCH_DN_IGNORE_SERVER_PART = 4;
    public static final int FIND_EXACT_MATCH_OR_CHILD_OR_PARENT_DN_PART_IGNORE_SERVER_PART = 5;

    public static OrganizationalUnit getOrganizationalUnit(String directoryServerId, int actionType, String filterString, String queryId) throws ConsoleException {
        RpcDataAdapter data = new RpcDataAdapter();
        data.put("ACTION_TYPE", actionType);
        data.put("LDAP_FILTER", filterString);
        data.put("LDAP_DIRECTORY_SERVER_ID", directoryServerId);
        data.put("LDAP_QUERY_ID", queryId);
        try {
            OrganizationalUnit ou = (OrganizationalUnit)GUIManager.sendCommand("ImportADSI", (AbstractSchema)data, true);
            return ou;
        }
        catch (ConsoleException ce) {
            throw ce;
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }

    private static OrganizationalUnit getOrganizationalUnit(String ldapPath, int actionType, int ldapType, String userName, String passWord, String filterString, boolean ssl, boolean disableCertValidation, String queryId) throws ConsoleException {
        RpcDataAdapter data = new RpcDataAdapter();
        data.put("LDAP_PATH", ldapPath);
        data.put("LDAP_TYPE", ldapType);
        data.put("ACTION_TYPE", actionType);
        data.put("LDAP_USERNAME", userName);
        data.put("LDAP_PASSWORD", passWord);
        data.put("LDAP_FILTER", filterString);
        data.put("SSL", ssl ? "true" : "false");
        data.put("DISABLE_CERT_VALIDATION", disableCertValidation ? "true" : "false");
        data.put("LDAP_QUERY_ID", queryId);
        try {
            OrganizationalUnit ou = (OrganizationalUnit)GUIManager.sendCommand("ImportADSI", (AbstractSchema)data, true);
            return ou;
        }
        catch (ConsoleException ce) {
            throw ce;
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }

    public static ArrayList<DirectoryServer> getDirectoryServer() throws ConsoleException {
        ArrayList<DirectoryServer> list = new ArrayList<DirectoryServer>();
        DataobjectManager data = DataobjectManager.getInstance();
        SemConfigRoot root = data.getSemConfigRoot();
        Vector siteArray = root.getSemSiteArray().getChildren();
        for (AbstractSchema semSiteObjRef : siteArray) {
            SemSite semSite = (SemSite)data.getObjectByGUID("SemSite", ((ObjReference)semSiteObjRef).getTargetId());
            Boolean isSuspended = semSite.getOptSuspended();
            if (isSuspended != null && isSuspended.booleanValue()) {
                System.out.println("Site " + semSite.getName() + " is suspended. So, ignoring the directory servers from its SEPMs");
                continue;
            }
            ServerArray serverArray = semSite.getServerArray();
            Vector semServers = null;
            if (serverArray != null) {
                semServers = serverArray.getSemServer();
            }
            int len = semServers == null ? 0 : semServers.size();
            for (int i = 0; i < len; ++i) {
                Vector dss;
                DirectoryServerIntegration dsi = ((SemServer)semServers.get(i)).getOptDirectoryServerIntegration();
                if (dsi == null || (dss = dsi.getDirectoryServer()).size() == 0) continue;
                for (int j = 0; j < dss.size(); ++j) {
                    DirectoryServer ds = (DirectoryServer)dss.get(j);
                    list.add(ds);
                }
            }
        }
        return list;
    }

    public static DirectoryServer getDirectoryServerForGroup(GroupObject group) throws ConsoleException {
        ArrayList<DirectoryServer> list = ImportADSIHandler.getDirectoryServer();
        return LdapUtilsLegacy.retrieveDirectoryServerForGroupAdTree((SemClientGroup)group.getSemClientGroup(), list);
    }

    public static DirectoryServer getDirectoryServerForOU(OrganizationalUnitObject ou) throws ConsoleException {
        ArrayList<DirectoryServer> list = ImportADSIHandler.getDirectoryServer();
        return LdapUtilsLegacy.searchDirectoryServerByAdPath((String)(ou == null ? null : ou.getADsPath()), list);
    }

    public static TreeModel getOUTree(String ldapPath, int ldapType, String userName, String passWord, String filterString, boolean ssl, boolean disableCertValidation, String queryId) throws ConsoleException {
        OrganizationalUnit ou = ImportADSIHandler.getOrganizationalUnit(ldapPath, 0, ldapType, userName, passWord, filterString, ssl, disableCertValidation, queryId);
        return ImportADSIHandler.createTreeModel(ou);
    }

    public static TreeModel getOUTree(String directoryServerId, String filterString, String queryId) throws ConsoleException {
        OrganizationalUnit ou = ImportADSIHandler.getOrganizationalUnit(directoryServerId, 0, filterString, queryId);
        return ImportADSIHandler.createTreeModel(ou);
    }

    private static TreeModel createTreeModel(OrganizationalUnit ou) {
        if (ou == null) {
            return new DefaultTreeModel(null);
        }
        if (ou.getOptName() == null || ou.getOptName().length() < 1) {
            System.out.println("ImportADSIHandler>> getOUTree: Warning-> ou is invalid!");
            return null;
        }
        OrganizationalUnitObject global = new OrganizationalUnitObject(ou);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(global);
        ImportADSIHandler.getChildOUTree(global, root);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        return treeModel;
    }

    private static boolean getChildOUTree(OrganizationalUnitObject parentOU, DefaultMutableTreeNode parentTreeNode) {
        if (parentOU == null) {
            return false;
        }
        OrganizationalUnit rootcg = parentOU.getOrganizationalUnit();
        Vector childOUs = rootcg.getOrganizationalUnit();
        int len = childOUs.size();
        for (int i = 0; i < len; ++i) {
            OrganizationalUnit ou = (OrganizationalUnit)childOUs.get(i);
            OrganizationalUnitObject go = new OrganizationalUnitObject(ou);
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(go, true);
            parentTreeNode.add(treeNode);
            ImportADSIHandler.getChildOUTree(new OrganizationalUnitObject(ou), treeNode);
        }
        return true;
    }

    public static SemClientGroup findGroupByAdPath(String adPath, int search_mode) throws ConsoleException {
        GroupObject root = GroupHandler.getRootGroupObject();
        SemClientGroup groupRoot = root.getSemClientGroup();
        return ImportADSIHandler.findGroupByAdPath(groupRoot, adPath, search_mode);
    }

    private static SemClientGroup findGroupByAdPath(SemClientGroup groupParent, String adPath, int search_mode) throws ConsoleException {
        if (groupParent == null || adPath == null || adPath.length() < 1) {
            return null;
        }
        Vector groupChildren = groupParent.getSemClientGroup();
        if (groupChildren == null || groupChildren.size() < 1) {
            return null;
        }
        for (int i = 0; i < groupChildren.size(); ++i) {
            SemClientGroup groupChild = (SemClientGroup)groupChildren.get(i);
            Integer type = groupChild.getOptType();
            if (type == null) {
                type = groupChild.getDefType();
            }
            if (type.equals(SemClientGroup.ADNODE) || type.equals(SemClientGroup.ADTREE)) {
                String groupPath = groupChild.getOptADsPath();
                if (groupPath == null || groupPath.length() < 1) continue;
                adPath = adPath.toUpperCase();
                groupPath = groupPath.toUpperCase();
                switch (search_mode) {
                    case 0: {
                        if (!adPath.equals(groupPath)) break;
                        return groupChild;
                    }
                    case 1: {
                        if (!groupPath.startsWith(adPath) || groupPath.equals(adPath)) break;
                        return groupChild;
                    }
                    case 2: {
                        if (!adPath.startsWith(groupPath) || groupPath.equals(adPath)) break;
                        return groupChild;
                    }
                    case 3: {
                        if (!adPath.equals(groupPath) && !groupPath.startsWith(adPath) && !adPath.startsWith(groupPath)) break;
                        return groupChild;
                    }
                    case 4: {
                        LdapPath path = new LdapPath();
                        path.setPath(groupPath);
                        path.parse();
                        String dnOfGroupPath = path.getPartDN();
                        path.setPath(adPath);
                        path.parse();
                        String dnOfAdPath = path.getPartDN();
                        if (!dnOfAdPath.equals(dnOfGroupPath)) break;
                        return groupChild;
                    }
                    case 5: {
                        LdapPath path0 = new LdapPath();
                        path0.setPath(groupPath);
                        path0.parse();
                        String dnOfGroupPath0 = path0.getPartDN();
                        path0.setPath(adPath);
                        path0.parse();
                        String dnOfAdPath0 = path0.getPartDN();
                        if (!dnOfAdPath0.equals(dnOfGroupPath0) && !dnOfAdPath0.endsWith(dnOfGroupPath0) && !dnOfGroupPath0.endsWith(dnOfAdPath0)) break;
                        return groupChild;
                    }
                }
            }
            if ((groupChild = ImportADSIHandler.findGroupByAdPath(groupChild, adPath, search_mode)) == null) continue;
            return groupChild;
        }
        return null;
    }

    public static GroupObject mapGroupToOU(GroupObject go, OrganizationalUnitObject ouo) throws ConsoleException {
        AbstractSchema parent;
        if (go == null || ouo == null) {
            return null;
        }
        if (go.isTypeAdNode()) {
            return null;
        }
        if (go.isFixed()) {
            return null;
        }
        OrganizationalUnit ou = ouo.getOrganizationalUnit();
        SemClientGroup group = go.getSemClientGroup();
        group.setOptType(SemClientGroup.ADTREE);
        group.setOptADsPath(ou.getOptADsPath());
        group.setOptDistinguishedName(ou.getOptDistinguishedName());
        group.setOptDirectoryServerRefId(ou.getOptADsGuid());
        group.setOptExtReferenceId(ou.getOptGuid());
        GroupObject goUpdated = GroupHandler.updateGroup(go);
        group = goUpdated.getSemClientGroup();
        RpcDataAdapter data = new RpcDataAdapter();
        data.put("MAP_GROUP_TO_OU", group.getId());
        data.put("LDAP_EXTERNAL_REFERENCE_ID", group.getOptExtReferenceId());
        GUIManager.sendCommand("ImportADSI", (AbstractSchema)data, true);
        SemClientGroupTree topParent = null;
        if (parent instanceof SemClientGroup) {
            for (parent = group.getParent(); parent != null && parent instanceof SemClientGroup; parent = parent.getParent()) {
            }
            topParent = (SemClientGroupTree)parent;
        } else {
            topParent = (SemClientGroupTree)parent;
        }
        if (topParent == null) {
            return null;
        }
        SemClientGroupTree tree = (SemClientGroupTree)DataobjectManager.getInstance().getObjectByGUID("SemClientGroupTree", topParent.getId());
        goUpdated = GroupHandler.getGroupById(tree, goUpdated.getId());
        return goUpdated;
    }

    public static boolean syncOuNow(GroupObject go) throws ConsoleException {
        if (go == null) {
            return false;
        }
        if (!go.isTypeAdTree() && !go.isTypeAdNode()) {
            return false;
        }
        SemClientGroup group = go.getSemClientGroup();
        RpcDataAdapter data = new RpcDataAdapter();
        data.put("MAP_GROUP_TO_OU", group.getId());
        data.put("LDAP_EXTERNAL_REFERENCE_ID", group.getOptExtReferenceId());
        GUIManager.sendCommand("ImportADSI", (AbstractSchema)data, true);
        String treeId = group.getTopLevelObject().getId();
        SemClientGroupTree tree = DataobjectManager.getInstance().getSemClientGroupTree(treeId);
        GroupObject goUpdated = GroupHandler.getGroupById(tree, go.getId());
        return goUpdated == null || goUpdated.getSemClientGroup() != null;
    }

    public static void stopLdapSync() {
        ImportADSIHandler.stopLdapQuery("ADSITask");
    }

    public static void stopLdapQuery(String id) {
        RpcDataAdapter data = new RpcDataAdapter();
        data.put("COMMAND", "STOP_LDAP_QUERY");
        data.put("LDAP_QUERY_ID", id);
        try {
            GUIManager.sendCommand("ImportADSI", (AbstractSchema)data, true);
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }
}

