/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.BaselineFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.DestinationHostTrigger;
import com.sygate.scm.common.configobject.schema.EnforcedFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.FirewallRule;
import com.sygate.scm.common.configobject.schema.FirewallRuleSystem;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicyPool;
import com.sygate.scm.common.configobject.schema.FwHostTrigger;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroup;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroupPool;
import com.sygate.scm.common.configobject.schema.LocalHostTrigger;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.RecycleBin;
import com.sygate.scm.common.configobject.schema.RemoteHostTrigger;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SourceHostTrigger;
import com.sygate.scm.common.configobject.schema.SuspendedItem;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.util.ConfigObjectUtils;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyApplyHelper;
import com.sygate.scm.console.ui.policy.explorer.hosts.HostGroupPanel;
import com.sygate.scm.console.ui.policy.hostgroup.HostGroupDialog;
import com.sygate.scm.console.ui.policy.hostgroup.HostGroupObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class HostGroupHandler {
    private static HostGroupHandler instance = null;
    private static MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.handler.handler");
    private HostGroupPanel hostGroupPanel = null;

    private HostGroupHandler() {
    }

    public Object importHostGroup() {
        Object hostGroup = null;
        try {
            hostGroup = PolicyHandler.importPolicy();
            if (!(hostGroup instanceof FwNetworkHostGroup)) {
                return null;
            }
            SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
            ObjectPool objectPool = currentDomain.getObjectPool();
            FwNetworkHostGroupPool hostGroupPool = objectPool.getOptFwNetworkHostGroupPool();
            if (hostGroupPool == null) {
                hostGroupPool = new FwNetworkHostGroupPool();
                objectPool.setOptFwNetworkHostGroupPool(hostGroupPool);
            }
            ArrayList<String> allNames = new ArrayList<String>();
            this.getAllNames(hostGroupPool, allNames);
            String newName = PolicyHandler.validatePolicyName(((FwNetworkHostGroup)hostGroup).getName(), allNames, 255);
            if (newName == null) {
                return null;
            }
            ((FwNetworkHostGroup)hostGroup).setName(newName);
            hostGroup = this.addHostGroup((FwNetworkHostGroup)hostGroup);
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(Manager.getFrame(), exc.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hostgroup.hostgroup", "HostGroupDialog.title.ConsoleError"), 0);
            System.err.println("ERROR in HostGroupHandler.addHostGroup():");
            LoggerUtilities.logException((Throwable)exc);
        }
        return hostGroup;
    }

    private final void getAllNames(FwNetworkHostGroupPool hostGroupPool, List<String> allNames) throws Exception {
        int nn = hostGroupPool.getObjReferenceCount();
        for (int i = 0; i < nn; ++i) {
            String type;
            ObjReference ref = hostGroupPool.getObjReference(i);
            if (ref == null || !"FwNetworkHostGroup".equals(type = ref.getTargetType())) continue;
            String targetId = ref.getTargetId();
            TopLevelObject hostGroupObj = DataobjectManager.getInstance().getObjectByGUID(type, targetId);
            if (hostGroupObj == null) continue;
            String name = ((FwNetworkHostGroup)hostGroupObj).getName();
            allNames.add(name);
        }
    }

    public Object addHostGroup(JTable table) {
        Object newTableData = null;
        try {
            HostGroupDialog dialog = new HostGroupDialog();
            if (dialog.isOk()) {
                FwNetworkHostGroup hostGroup = dialog.getFwNetworkHostGroup();
                hostGroup.setId(new GUIDGenerator().getGUIDString());
                newTableData = this.addHostGroup(hostGroup);
            }
            dialog.dispose();
        }
        catch (Exception exc) {
            System.err.println("ERROR in HostGroupHandler.addHostGroup():");
            LoggerUtilities.logException((Throwable)exc);
        }
        return newTableData;
    }

    public void editHostGroup(HostGroupObject selectedHostGroupObj) {
        if (selectedHostGroupObj == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), res.getString("HostGroupHandler.error.SelectRowBeforeEdit"));
            return;
        }
        try {
            FwNetworkHostGroup origHostGroup;
            FwNetworkHostGroup updatedHostGroup;
            HostGroupDialog dialog = new HostGroupDialog(selectedHostGroupObj.getClone().getHostGroup());
            if (dialog.isOk() && !ConfigObjectUtils.isEqualObj((Object)(updatedHostGroup = dialog.getFwNetworkHostGroup()), (Object)(origHostGroup = selectedHostGroupObj.getHostGroup()))) {
                origHostGroup.setName(updatedHostGroup.getName());
                origHostGroup.setFwHostContainer(updatedHostGroup.getFwHostContainer());
                DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)origHostGroup);
                String desc = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "HostGroupHandler.Edit.Description");
                Object[] obj = new Object[]{origHostGroup.getName()};
                desc = MessageFormat.format(desc, obj);
                ConsoleLogger.logPolicyEvent(2, origHostGroup.getId(), desc, null);
            }
            dialog.dispose();
        }
        catch (Exception exc) {
            System.err.println("ERROR in HostGroupHandler.addHostGroup():");
            LoggerUtilities.logException((Throwable)exc);
        }
    }

    public void deleteHostGroup(HostGroupObject selectedHostGroupObj) {
        if (selectedHostGroupObj == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), res.getString("HostGroupHandler.error.SelectRowBeforeDelete"));
            return;
        }
        String message = res.getString("HostGroupHandler.ConfirmDeleteHostGroup");
        int result = UIUtilities.confirmYesNoOptionDialog(message, res.getString("HostGroupHandler.title.DeleteHostGroup"));
        if (result == 0) {
            if (PolicyApplyHelper.isHostGroupInUse(selectedHostGroupObj)) {
                return;
            }
            try {
                this.deleteObjRefinFirewallHost(selectedHostGroupObj);
                this.deleteHostGroup(selectedHostGroupObj.getHostGroup());
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), res.getString("HostGroupHandler.title.DeleteHostGroup"), 0);
                if (ex.needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                }
            }
            catch (Exception exc) {
                System.err.println("ERROR in HostGroupHandler.addHostGroup():");
                LoggerUtilities.logException((Throwable)exc);
            }
        }
    }

    private void deleteObjRefinFirewallHost(HostGroupObject selectedHostGroupObj) {
        String hostGroupID = selectedHostGroupObj.getHostGroup().getId();
        try {
            SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
            ObjectPool objectPool = currentDomain.getObjectPool();
            FwFirewallPolicyPool firewallPolicyPool = objectPool.getOptFwFirewallPolicyPool();
            if (firewallPolicyPool != null) {
                Vector objReferences = firewallPolicyPool.getObjReference();
                int referenceCount = objReferences.size();
                for (int i = 0; i < referenceCount; ++i) {
                    String id;
                    ObjReference groupReference = (ObjReference)objReferences.get(i);
                    String type = groupReference.getTargetType();
                    FwFirewallPolicy firewallPolicy = (FwFirewallPolicy)PolicyHandler.getObject(type, id = groupReference.getTargetId());
                    FirewallRuleSystem ruleSystem = firewallPolicy.getOptFirewallRuleSystem();
                    if (ruleSystem != null) {
                        EnforcedFirewallRuleArray enforcedRule;
                        BaselineFirewallRuleArray baseRule = ruleSystem.getOptBaselineFirewallRuleArray();
                        if (baseRule != null) {
                            Vector baseV = baseRule.getFirewallRule();
                            for (int j = 0; j < baseV.size(); ++j) {
                                FirewallRule rule = (FirewallRule)baseV.get(j);
                                this.modifyFirewallRule(rule, hostGroupID);
                            }
                        }
                        if ((enforcedRule = ruleSystem.getOptEnforcedFirewallRuleArray()) != null) {
                            Vector enforceV = enforcedRule.getFirewallRule();
                            for (int j = 0; j < enforceV.size(); ++j) {
                                FirewallRule rule = (FirewallRule)enforceV.get(j);
                                this.modifyFirewallRule(rule, hostGroupID);
                            }
                        }
                    }
                    ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
                    updateList.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)firewallPolicy, 0));
                    updateList.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)currentDomain, 0));
                    DataobjectManager.getInstance().updateObject("Merge", updateList);
                }
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            System.err.println("Error in removing objReference from FirewallHost");
        }
    }

    private void modifyFirewallRule(FirewallRule rule, String hostGroupID) {
        DestinationHostTrigger destinationTrigger;
        SourceHostTrigger sourceTrigger;
        RemoteHostTrigger remoteTrigger;
        FwHostTrigger hostTrigger = rule.getTriggerCondition().getOptFwHostTrigger();
        if (hostTrigger == null) {
            return;
        }
        LocalHostTrigger localTrigger = hostTrigger.getOptLocalHostTrigger();
        if (localTrigger != null) {
            Vector objRefV = localTrigger.getObjReference();
            for (int j = 0; j < objRefV.size(); ++j) {
                ObjReference objR = (ObjReference)objRefV.get(j);
                if (!objR.getTargetId().equals(hostGroupID)) continue;
                localTrigger.removeObjReference(objR);
                break;
            }
        }
        if ((remoteTrigger = hostTrigger.getOptRemoteHostTrigger()) != null) {
            Vector objRefV = remoteTrigger.getObjReference();
            for (int j = 0; j < objRefV.size(); ++j) {
                ObjReference objR = (ObjReference)objRefV.get(j);
                if (!objR.getTargetId().equals(hostGroupID)) continue;
                remoteTrigger.removeObjReference(objR);
                break;
            }
        }
        if ((sourceTrigger = hostTrigger.getOptSourceHostTrigger()) != null) {
            Vector objRefV = sourceTrigger.getObjReference();
            for (int j = 0; j < objRefV.size(); ++j) {
                ObjReference objR = (ObjReference)objRefV.get(j);
                if (!objR.getTargetId().equals(hostGroupID)) continue;
                sourceTrigger.removeObjReference(objR);
                break;
            }
        }
        if ((destinationTrigger = hostTrigger.getOptDestinationHostTrigger()) != null) {
            Vector objRefV = destinationTrigger.getObjReference();
            for (int j = 0; j < objRefV.size(); ++j) {
                ObjReference objR = (ObjReference)objRefV.get(j);
                if (!objR.getTargetId().equals(hostGroupID)) continue;
                destinationTrigger.removeObjReference(objR);
                break;
            }
        }
    }

    private Object addHostGroup(FwNetworkHostGroup hostGroup) throws ConsoleException {
        SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
        ObjectPool objectPool = currentDomain.getObjectPool();
        FwNetworkHostGroupPool hostGroupPool = objectPool.getOptFwNetworkHostGroupPool();
        if (hostGroupPool == null) {
            hostGroupPool = new FwNetworkHostGroupPool();
            objectPool.setOptFwNetworkHostGroupPool(hostGroupPool);
        }
        ObjReference ref = new ObjReference();
        ref.setName(hostGroup.getName());
        ref.setTargetId(hostGroup.getId());
        ref.setTargetType(hostGroup.getObjectTypeName());
        hostGroupPool.addObjReference(ref);
        ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        updateList.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)hostGroup, 1));
        updateList.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)currentDomain, 0));
        Map<String, Object> resultTable = DataobjectManager.getInstance().updateObject("Merge", updateList);
        FwNetworkHostGroup newHostGroup = (FwNetworkHostGroup)resultTable.get(hostGroup.getId());
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "HostGroupHandler.Add.Description");
        Object[] obj = new Object[]{newHostGroup.getName()};
        desc = MessageFormat.format(desc, obj);
        ConsoleLogger.logPolicyEvent(0, newHostGroup.getId(), desc, null);
        return newHostGroup;
    }

    private void deleteHostGroup(FwNetworkHostGroup hostGroupToDelete) throws ConsoleException {
        SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
        ObjectPool objectPool = currentDomain.getObjectPool();
        FwNetworkHostGroupPool hostGroupPool = objectPool.getOptFwNetworkHostGroupPool();
        FwNetworkHostGroup hostGroup = hostGroupToDelete;
        if (hostGroupPool != null) {
            ObjReference poolRef = HostGroupHandler.getHostGroupRef(hostGroupPool, hostGroup.getId());
            hostGroupPool.removeObjReference(poolRef);
            ObjReference objRef = new ObjReference();
            objRef.setTargetId(poolRef.getTargetId());
            objRef.setTargetType(hostGroup.getObjectTypeName());
            objRef.setName("Suspended" + hostGroup.getObjectTypeName() + "Link");
            SuspendedItem suspended = new SuspendedItem();
            suspended.setDeletedTime(Long.valueOf(new Date().getTime()));
            suspended.setOptWhoDeletedIt(DataobjectManager.getInstance().getCurrentAdministrator().getId());
            suspended.setObjReference(objRef);
            RecycleBin recycleBin = objectPool.getRecycleBin();
            recycleBin.addSuspendedItem(suspended);
            ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
            updateList.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)hostGroup, 2));
            updateList.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)currentDomain, 0));
            DataobjectManager.getInstance().updateObject("Merge", updateList);
            String desc = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "HostGroupHandler.Delete.Description");
            Object[] obj = new Object[]{hostGroup.getName()};
            desc = MessageFormat.format(desc, obj);
            ConsoleLogger.logPolicyEvent(1, hostGroup.getId(), desc, null);
        }
    }

    private static ObjReference getHostGroupRef(FwNetworkHostGroupPool pool, String id) throws ConsoleException {
        if (pool == null || id == null) {
            return null;
        }
        Vector objRefs = pool.getObjReference();
        for (int i = 0; i < objRefs.size(); ++i) {
            ObjReference objRef = (ObjReference)objRefs.get(i);
            if (!objRef.getTargetType().equals("FwNetworkHostGroup") || !objRef.getTargetId().equals(id)) continue;
            return objRef;
        }
        return null;
    }

    public static HostGroupHandler getInstance() {
        if (null == instance) {
            instance = new HostGroupHandler();
        }
        return instance;
    }

    public HostGroupPanel getHostGroupPanel() {
        if (this.hostGroupPanel == null) {
            this.hostGroupPanel = new HostGroupPanel();
        }
        this.hostGroupPanel.refresh();
        return this.hostGroupPanel;
    }

    public ArrayList<HostGroupObject> getHostGroupsFromDB() throws ConsoleException {
        ArrayList<HostGroupObject> hostGroups = new ArrayList<HostGroupObject>();
        SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
        ObjectPool objectPool = currentDomain.getObjectPool();
        FwNetworkHostGroupPool hostGroupPool = objectPool.getOptFwNetworkHostGroupPool();
        if (hostGroupPool != null) {
            Vector objReferences = hostGroupPool.getObjReference();
            int referenceCount = objReferences.size();
            for (int i = 0; i < referenceCount; ++i) {
                ObjReference groupReference = (ObjReference)objReferences.get(i);
                String type = groupReference.getTargetType();
                String id = groupReference.getTargetId();
                FwNetworkHostGroup hostGroup = (FwNetworkHostGroup)PolicyHandler.getObject(type, id);
                HostGroupObject hostGroupObj = new HostGroupObject(hostGroup);
                hostGroups.add(hostGroupObj);
            }
        }
        Collections.sort(hostGroups);
        return hostGroups;
    }
}

