/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler.HTMLTemp;

import com.sygate.scm.common.configobject.EnabledObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.HidPolicy;
import com.sygate.scm.common.configobject.schema.MemPolicy;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PolicyOverride;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.TdadPolicy;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.CloudPolicyHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.AlSignatureObject;
import com.sygate.scm.console.logicobject.AlSignatureOrObject;
import com.sygate.scm.console.logicobject.AppAuthenticationObject;
import com.sygate.scm.console.logicobject.AppliedPolicyObject;
import com.sygate.scm.console.logicobject.ComputerLockdownProtectionObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.IDSObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.OverflowObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.TimeCounter;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class PolicyTemp {
    private static final String LIVE_UPDATE_POLICY = "LiveUpdatePolicy";
    private static final String IDS_POLICY = "IdsPolicy";
    private static final String AV_POLICY = "AvPolicy";
    private static final String OS_PROTECTION_POLICY = "OSProtectionPolicy";
    private static final String OVERRIDE_POLICY = "OverridePolicy";
    private static final String CLOUD_OVERRIDE_POLICY_WHITE_LIST = "CloudOverridePolicyWhiteList";
    private static final String CLOUD_OVERRIDE_POLICY_BLACK_LIST = "CloudOverridePolicyBlackList";
    private static final String CLOUD_POLICY_MEM = "CloudPolicyMEM";
    private static final String HOST_INTEGRITY_POLICY = "HostIntegrityPolicy";
    private static final String FIREWALL_POLICY = "FirewallPolicy";
    private static final String HID_POLICY = "HidPolicy";
    private static final String MEM_POLICY = "MemPolicy";
    private static final String NTR_POLICY = "NtrPolicy";
    private static final String TDAD_POLICY = "TdadPolicy";
    private static final String UPGRADE_POLICY = "UpgradePolicy";
    private static final String QUARANTINE_UPGRADE_POLICY = "QuarantineUpgradePolicy";
    private static final String ADAPTIVE_POLICY = "AdaptivePolicy";
    private static final String QUARANTINE_ADAPTIVE_POLICY = "QuarantineAdaptivePolicy";
    private static Transformer transformer;
    private static boolean initialized;
    private Source xmlSource;
    private byte[] byteSource;
    private MessageResourcesFile msgRes = new MessageResourcesFile("com.sygate.scm.console.handler.handler");
    private static String[] keys;
    private static String[] values;

    private void init() throws IOException, TransformerConfigurationException {
        if (initialized) {
            return;
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("jdk.xml.xpathExprGrpLimit", "11");
        URL fu = ConsoleMain.class.getResource("policysummtemp.xsl");
        StreamSource source = new StreamSource(fu.openStream());
        Templates template = factory.newTemplates(source);
        transformer = template.newTransformer();
        transformer.setParameter("fontName", UIFontUtilities.STANDARD_FONT_NAME);
        transformer.setParameter("fontSize", UIFontUtilities.STANDARD_FONT_SIZE_WITH_UNITS);
        transformer.setParameter("enabledColor", UIColorUtilities.colorToString((Color)UIColorUtilities.DEFAULT_FOREGROUND));
        transformer.setParameter("disabledColor", UIColorUtilities.colorToString((Color)UIColorUtilities.CONTROL_DISABLED_FOREGROUND));
        transformer.setParameter("expandRowBackground", UIColorUtilities.colorToString((Color)UIColorUtilities.TABLE_STRIPE));
        transformer.setParameter("hyperlinkColor", UIColorUtilities.colorToString((Color)UIColorUtilities.LINK_FOREGROUND));
        transformer.setParameter("hyperlinkHoverColor", UIColorUtilities.colorToString((Color)UIColorUtilities.LINK_HOVER_FOREGROUND));
        transformer.setParameter("onColor", UIColorUtilities.colorToString((Color)UIColorUtilities.ON_FOREGROUND_COLOR));
        transformer.setParameter("upArrow", CustomLookAndFeel.UP_ARROW_URL.toString());
        transformer.setParameter("downArrow", CustomLookAndFeel.DOWN_ARROW_URL.toString());
        transformer.setParameter("cloud", CustomLookAndFeel.CLOUD_URL.toString());
        transformer.setParameter("cloud_inherited", CustomLookAndFeel.CLOUD_INHERITED_URL.toString());
        for (int i = 0; i < keys.length; ++i) {
            PolicyTemp.values[i] = this.msgRes.getString("PolicyTemp." + keys[i]);
        }
        initialized = true;
    }

    public String getHTMLText(GroupPolicyObject groupObj, Map<String, ExpandStatus> expandStatusMap) throws ConsoleException {
        TimeCounter timeCounter = new TimeCounter();
        try {
            if (!initialized) {
                this.init();
            }
            groupObj.calculateLastestT();
            Document sourceDoc = this.getSourceDoc(groupObj, expandStatusMap);
            ConsoleLogger.log("PolicyTemp> getHTMLText>> Source document generated in: " + timeCounter.toStringEx2(true));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLHelper.serialize((Document)sourceDoc, (OutputStream)out);
            out.close();
            this.byteSource = out.toByteArray();
            this.xmlSource = new StreamSource(new ByteArrayInputStream(this.byteSource));
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outStream);
            transformer.transform(this.xmlSource, result);
            String data = UIUtilities.takeOutMeta(outStream.toString("UTF-8"));
            ConsoleLogger.log("PolicyTemp> getHTMLText>> HTML document geranated in: " + timeCounter.toStringEx2(true));
            return data;
        }
        catch (TransformerConfigurationException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
        catch (IOException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
        catch (TransformerException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }

    private Document getSourceDoc(GroupPolicyObject groupObj, Map<String, ExpandStatus> expandStatusMap) throws ConsoleException {
        ComputerLockdownProtectionObject lockdownObj;
        OverflowObject overflow;
        boolean showOverflow;
        Document doc = XMLHelper.newDocument();
        Element root = doc.createElement("GroupPolicy");
        doc.appendChild(root);
        if (groupObj.getGroupName().length() > 23) {
            root.setAttribute("Name", groupObj.getGroupName().substring(0, 20) + "...");
        } else {
            root.setAttribute("Name", groupObj.getGroupName());
        }
        LicenseObject licenseObj = LicenseObject.getInstance();
        root.setAttribute("IsGlobal", "" + groupObj.getGroupObject().isGlobal());
        root.setAttribute("Inherit", groupObj.isInherit() ? "true" : "false");
        root.setAttribute("ParentGroup", groupObj.getGroupObject().isGlobal() ? "" : groupObj.getGroupObject().getParentGroup().getDisplayName());
        String productName = licenseObj.getProductName();
        root.setAttribute("ProductName", productName);
        IDSObject idsObj = groupObj.getIDSObject();
        boolean showIds = idsObj.isShowIds();
        AppAuthenticationObject appObj = groupObj.getAppAuthenticationObject();
        if (appObj.isShowAppAuthentication() && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x23")) {
            root.setAttribute("EnableAppAuthentication", appObj.getEnabled() ? "true" : "false");
        }
        if (showOverflow = (overflow = groupObj.getOverflowObject()).showBufferOverflow()) {
            root.setAttribute("EnableBufferOverrun", overflow.getEnabled() ? "true" : "false");
        }
        if (showIds && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x24")) {
            root.setAttribute("EnableIDS", idsObj.getEnabled() ? "true" : "false");
        }
        if ((lockdownObj = groupObj.getComputerLockdownProtectionObject()).isShowLockdown() && AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x25")) {
            root.setAttribute("EnableLockdown", lockdownObj != null && lockdownObj.isEnabled() ? "true" : "false");
        }
        if (AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x26")) {
            root.setAttribute("EnableLiveupdateContentPolicySettings", "true");
        }
        this.createLocations(doc, root, groupObj, expandStatusMap, licenseObj);
        this.createTableInfo(doc, root);
        return doc;
    }

    private void createTableInfo(Document doc, Element parent) throws ConsoleException {
        try {
            Element tabElem = doc.createElement("TableInfo");
            parent.appendChild(tabElem);
            for (int i = 0; i < keys.length; ++i) {
                Element infoElem = doc.createElement(keys[i]);
                infoElem.setAttribute("Info", values[i]);
                tabElem.appendChild(infoElem);
            }
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }

    private void createLocations(Document doc, Element parent, GroupPolicyObject groupObj, Map<String, ExpandStatus> expandStatusMap, LicenseObject myLicenseObj) throws ConsoleException {
        ObjReference objrefPolicyoverridewhitelist = null;
        ObjReference objrefPolicyoverrideblacklist = null;
        ObjReference objrefPolicymem = null;
        ObjReference objrefHid = null;
        ObjReference objrefTdad = null;
        boolean showCloudoverridepolicywhitelist = false;
        boolean showCloudoverridepolicyblacklist = false;
        boolean showCloudpolicymem = false;
        boolean showHidPolicy = false;
        boolean showTdadPolicy = false;
        boolean isCloudParentMemPolicy = true;
        boolean isCloudParentHidPolicy = true;
        boolean isCloudParentWhiteListPolicy = true;
        boolean isCloudParentBlackListPolicy = true;
        boolean isExternalParentTdadPolicy = true;
        String domainId = Manager.getCurrentDomainId();
        ObjReference ownPolicy = null;
        GUID domainIdguid = new GUID(domainId);
        SemClientGroup semClientGroupObj = groupObj.getClientGroup();
        CloudPolicyHandler cloudPolicyHandler = CloudPolicyHandler.getInstance();
        if (CloudUtil.isCloudEnrolled(domainId)) {
            objrefPolicyoverridewhitelist = cloudPolicyHandler.getPolicyFromCloudAppliedPolicyArray(semClientGroupObj, domainIdguid, "PolicyOverride", "WhiteList");
            if (objrefPolicyoverridewhitelist != null) {
                showCloudoverridepolicywhitelist = true;
                ownPolicy = CloudPolicyHandler.getInstance().getPolicyFromCloudAppliedPolicyArray(semClientGroupObj, domainIdguid, "PolicyOverride", "WhiteList", false);
                if (ownPolicy != null && ownPolicy.getTargetId().equals(objrefPolicyoverridewhitelist.getTargetId())) {
                    isCloudParentWhiteListPolicy = false;
                }
            }
            if ((objrefPolicyoverrideblacklist = cloudPolicyHandler.getPolicyFromCloudAppliedPolicyArray(semClientGroupObj, domainIdguid, "PolicyOverride", "BlackList")) != null) {
                showCloudoverridepolicyblacklist = true;
                ownPolicy = CloudPolicyHandler.getInstance().getPolicyFromCloudAppliedPolicyArray(semClientGroupObj, domainIdguid, "PolicyOverride", "BlackList", false);
                if (ownPolicy != null && ownPolicy.getTargetId().equals(objrefPolicyoverrideblacklist.getTargetId())) {
                    isCloudParentBlackListPolicy = false;
                }
            }
            if ((objrefPolicymem = cloudPolicyHandler.getPolicyFromCloudAppliedPolicyArray(semClientGroupObj, domainIdguid, MEM_POLICY, ConstantValue.CLOUD_POLICY_NO_SUB_TYPE)) != null) {
                showCloudpolicymem = true;
                ownPolicy = CloudPolicyHandler.getInstance().getPolicyFromCloudAppliedPolicyArray(semClientGroupObj, domainIdguid, MEM_POLICY, ConstantValue.CLOUD_POLICY_NO_SUB_TYPE, false);
                if (ownPolicy != null && ownPolicy.getTargetId().equals(objrefPolicymem.getTargetId())) {
                    isCloudParentMemPolicy = false;
                }
            }
            if ((objrefHid = cloudPolicyHandler.getPolicyFromCloudAppliedPolicyArray(semClientGroupObj, domainIdguid, HID_POLICY, ConstantValue.CLOUD_POLICY_NO_SUB_TYPE)) == null) {
                showHidPolicy = false;
            } else {
                showHidPolicy = this.getIsHidPolicyEnabled(objrefHid);
                ownPolicy = CloudPolicyHandler.getInstance().getPolicyFromCloudAppliedPolicyArray(semClientGroupObj, domainIdguid, HID_POLICY, ConstantValue.CLOUD_POLICY_NO_SUB_TYPE, false);
                if (ownPolicy != null && ownPolicy.getTargetId().equals(objrefHid.getTargetId())) {
                    isCloudParentHidPolicy = false;
                }
            }
        }
        if ((objrefTdad = cloudPolicyHandler.getPolicyFromCloudAppliedPolicyArray(semClientGroupObj, domainIdguid, TDAD_POLICY, ConstantValue.CLOUD_POLICY_NO_SUB_TYPE)) == null) {
            showTdadPolicy = false;
        } else {
            showTdadPolicy = this.getIsTdadPolicyEnabled(objrefTdad);
            ownPolicy = CloudPolicyHandler.getInstance().getPolicyFromCloudAppliedPolicyArray(semClientGroupObj, domainIdguid, TDAD_POLICY, ConstantValue.CLOUD_POLICY_NO_SUB_TYPE, false);
            if (ownPolicy != null && ownPolicy.getTargetId().equals(objrefTdad.getTargetId())) {
                isExternalParentTdadPolicy = false;
            }
        }
        ConsoleLogger.log("PolicyTemp> createLocations>> showCloudoverridepolicywhitelist, showCloudoverridepolicyblacklist, showMEMPolicy, showHidPolicy, showTdadPolicy: " + showCloudoverridepolicywhitelist + ", " + showCloudoverridepolicyblacklist + ", " + showCloudpolicymem + ", " + showHidPolicy + ", " + showTdadPolicy);
        List<LocationObject> allLocations = groupObj.getLocationsFromDB();
        for (LocationObject locObj : allLocations) {
            ExpandStatus status;
            Element locElem = doc.createElement("Location");
            parent.appendChild(locElem);
            Object locName = locObj.getName();
            if (((String)locName).length() > 30) {
                locName = ((String)locName).substring(0, 27) + "...";
            }
            locElem.setAttribute("Name", (String)locName);
            locElem.setAttribute("Id", locObj.getId());
            locElem.setAttribute("Enabled", locObj.isEnabled() ? "true" : "false");
            if (showHidPolicy) {
                locElem.setAttribute("ShowHidPolicy", "true");
            } else {
                locElem.setAttribute("ShowHidPolicy", "false");
            }
            if (showTdadPolicy) {
                locElem.setAttribute("ShowTdadPolicy", "true");
            } else {
                locElem.setAttribute("ShowTdadPolicy", "false");
            }
            locElem.setAttribute("showCloudOverridePolicyWhitelist", Boolean.toString(showCloudoverridepolicywhitelist));
            locElem.setAttribute("showCloudOverridePolicyBlacklist", Boolean.toString(showCloudoverridepolicyblacklist));
            locElem.setAttribute("ShowMEMPolicy", Boolean.toString(showCloudpolicymem));
            if (showCloudpolicymem && isCloudParentMemPolicy) {
                locElem.setAttribute("isMemInherited", "true");
            }
            if (showCloudoverridepolicyblacklist && isCloudParentBlackListPolicy) {
                locElem.setAttribute("isBlacklistInherited", "true");
            }
            if (showCloudoverridepolicywhitelist && isCloudParentWhiteListPolicy) {
                locElem.setAttribute("isWhiteListInherited", "true");
            }
            if (showHidPolicy && isCloudParentHidPolicy) {
                locElem.setAttribute("isHidInherited", "true");
            }
            if (showTdadPolicy && isExternalParentTdadPolicy) {
                locElem.setAttribute("isTdadInherited", "true");
            }
            if (null == (status = expandStatusMap.get(locObj.getId()))) {
                status = new ExpandStatus();
            }
            locElem.setAttribute("ExpandLoc", "" + status.wholeLocation);
            locElem.setAttribute("ExpandLocCondition", "" + status.locationCondition);
            locElem.setAttribute("ExpandPolicy", "" + status.policies);
            locElem.setAttribute("ExpandQuaratinePolicy", "" + status.quarantinePolicies);
            locElem.setAttribute("ExpandAdvancedSetting", "" + status.advancedSetting);
            locElem.setAttribute("SharedCloud", this.msgRes.getString("PolicyTemp.SharedCloud"));
            locElem.setAttribute("SharedExternal", this.msgRes.getString("PolicyTemp.SharedExternal"));
            locElem.setAttribute("CloudTooltip", "CloudTooltipI18n");
            this.createAlSignature(doc, locElem, locObj);
            int mode = locObj.getControlMode();
            String strMode = this.msgRes.getString("PolicyTemp.ServerControl");
            if (mode == 0) {
                strMode = this.msgRes.getString("PolicyTemp.ClientControl");
            } else if (mode == 2) {
                strMode = this.msgRes.getString("PolicyTemp.PowerUser");
            }
            locElem.setAttribute("Mode", strMode);
            boolean isComGlobal = locObj.isComGlobal();
            boolean isExternalComGlobal = locObj.isExternalCommunicationGlobal();
            locElem.setAttribute("CommunicationSetting", isComGlobal ? "true" : "false");
            locElem.setAttribute("ExternalCommunicationSetting", isExternalComGlobal ? "true" : "false");
            String comMode = "";
            try {
                if (locObj.getCommunicationObject().getCommunication() == null) {
                    comMode = groupObj.getCommunicationObject().getCommunication().getModeValue();
                } else {
                    boolean isEnabled = false;
                    isEnabled = locObj.getCommunicationObject().getCommunication().getOptEnable() == null ? locObj.getCommunicationObject().getCommunication().getDefEnable().booleanValue() : locObj.getCommunicationObject().getCommunication().getOptEnable().booleanValue();
                    comMode = isEnabled ? locObj.getCommunicationObject().getCommunication().getModeValue() : "NO_COM";
                }
            }
            catch (ValidationException ex) {
                comMode = "UNKNOWN";
            }
            locElem.setAttribute("mode", comMode);
            AppliedPolicyObject appliedObj = locObj.getAppliedPolicyObject();
            List<ObjInfoObject> objInfoObjs = appliedObj.getAllAppliedPolicyObjInfo();
            boolean isSnacOnly = myLicenseObj.isSNACOnlyProduct();
            boolean isSBProduct = myLicenseObj.isSBProduct();
            for (int i = 0; i < objInfoObjs.size(); ++i) {
                ObjInfoObject objInfoObj = objInfoObjs.get(i);
                if (CloudUtil.isCloudMemPolicyInUse() && objInfoObj.getTargetName().equals("QuarantineMemPolicyApplied")) continue;
                Element one = null;
                ConsoleLogger.log("PolicyTemp> createLocations>> policyTargetName @(" + i + ") " + objInfoObj.getTargetName());
                if (objInfoObj.getTargetName().equals("QuarantineAvPolicyApplied") && !isSnacOnly) {
                    one = doc.createElement("QuarantineAvPolicy");
                } else if (objInfoObj.getTargetName().equals("QuarantineFWPolicyApplied") && !isSnacOnly) {
                    one = doc.createElement("QuarantineFirewallPolicy");
                } else if (objInfoObj.getTargetName().equals("QuarantineOSPPolicyApplied") && !isSnacOnly) {
                    one = doc.createElement("QuarantineOSPPolicy");
                } else if (objInfoObj.getTargetName().equals("QuarantineCePolicyApplied") && !isSnacOnly) {
                    one = doc.createElement("QuarantineCePolicy");
                } else if (objInfoObj.getTargetName().equals("QuarantineLuPolicyApplied")) {
                    one = doc.createElement("QuarantineLuPolicy");
                } else if (objInfoObj.getTargetName().equals("QuarantineIdsPolicyApplied") && !isSnacOnly) {
                    one = doc.createElement("QuarantineIdsPolicy");
                } else if (objInfoObj.getTargetName().equals("QuarantineMemPolicyApplied") && !isSnacOnly) {
                    one = doc.createElement("QuarantineMemPolicy");
                } else if (objInfoObj.getTargetName().equals("QuarantineNtrPolicyApplied") && !isSnacOnly) {
                    one = doc.createElement("QuarantineNtrPolicy");
                } else if (objInfoObj.getTargetName().equals("AvPolicyApplied") && !isSnacOnly) {
                    one = doc.createElement(AV_POLICY);
                } else if (objInfoObj.getTargetName().equals("FirewallPolicyApplied") && !isSnacOnly) {
                    one = doc.createElement(FIREWALL_POLICY);
                } else if (objInfoObj.getTargetName().equals("IdsPolicyApplied") && !isSnacOnly) {
                    one = doc.createElement(IDS_POLICY);
                } else if (objInfoObj.getTargetName().equals("OpAppProtectionPolicyApplied") && !isSnacOnly) {
                    one = doc.createElement(OS_PROTECTION_POLICY);
                } else if (objInfoObj.getTargetName().equals("HostIntegrityApplied") && !isSBProduct) {
                    one = doc.createElement(HOST_INTEGRITY_POLICY);
                } else if (objInfoObj.getTargetName().equals("PolicyOverrideApplied") && !isSnacOnly) {
                    one = doc.createElement(OVERRIDE_POLICY);
                } else if (objInfoObj.getTargetName().equals("LuPolicyApplied")) {
                    one = doc.createElement(LIVE_UPDATE_POLICY);
                } else if (objInfoObj.getTargetName().equals("MemPolicyApplied")) {
                    one = doc.createElement(MEM_POLICY);
                } else if (objInfoObj.getTargetName().equals("NtrPolicyApplied")) {
                    one = doc.createElement(NTR_POLICY);
                } else if (objInfoObj.getTargetName().equals("UpgradePolicyApplied")) {
                    one = doc.createElement(UPGRADE_POLICY);
                } else if (objInfoObj.getTargetName().equals("QuarantineUpgradePolicyApplied")) {
                    one = doc.createElement(QUARANTINE_UPGRADE_POLICY);
                } else if (objInfoObj.getTargetName().equals("AdaptivePolicyApplied")) {
                    one = doc.createElement(ADAPTIVE_POLICY);
                } else if (objInfoObj.getTargetName().equals("QuarantineAdaptivePolicyApplied")) {
                    one = doc.createElement(QUARANTINE_ADAPTIVE_POLICY);
                }
                if (PolicyTemp.isCurrentAdminDisallowedPrivilege(objInfoObj.getTargetName())) {
                    one = null;
                }
                if (one == null) continue;
                locElem.appendChild(one);
                boolean enabled = objInfoObj.isEnabled();
                Object name = objInfoObj.getName();
                if (((String)name).length() > 100) {
                    name = ((String)name).substring(0, 97) + "...";
                }
                one.setAttribute("Disabled", !enabled ? "true" : "false");
                one.setAttribute("Description", (String)name);
                one.setAttribute("Id", objInfoObj.getId());
                one.setAttribute("IsLocalPolicy", objInfoObj.isLocal() ? "true" : "false");
            }
            this.appendCloudPolicies(doc, locElem, objrefPolicyoverridewhitelist, objrefPolicyoverrideblacklist, objrefPolicymem, objrefHid, objrefTdad);
            locElem.setAttribute("HasQuarantine", myLicenseObj.isQuarantinePolicy() ? "true" : "false");
        }
    }

    private boolean getIsHidPolicyEnabled(ObjReference objRef) {
        boolean isHidpolicyenabled = false;
        if (objRef != null) {
            DataobjectManager dataObjManager = DataobjectManager.getInstance();
            String policyId = objRef.getTargetId();
            try {
                HidPolicy hidPolicy = dataObjManager.getHidPolicy(policyId);
                if (hidPolicy != null) {
                    isHidpolicyenabled = hidPolicy.getOptEnable();
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return isHidpolicyenabled;
    }

    private boolean getIsTdadPolicyEnabled(ObjReference objRef) {
        boolean isPolicyEnabled = false;
        if (objRef != null) {
            DataobjectManager dataObjManager = DataobjectManager.getInstance();
            String policyId = objRef.getTargetId();
            try {
                TdadPolicy policy = dataObjManager.getTdadPolicy(policyId);
                if (policy != null) {
                    isPolicyEnabled = policy.getOptEnable();
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return isPolicyEnabled;
    }

    public void appendCloudPolicies(Document doc, Element locElem, ObjReference objrefPolicyoverridewhitelist, ObjReference objrefPolicyoverrideblacklist, ObjReference objrefPolicymem, ObjReference objrefHid, ObjReference objrefTdad) {
        DataobjectManager dataObjManager = DataobjectManager.getInstance();
        if (objrefHid != null) {
            try {
                HidPolicy hidPolicy = dataObjManager.getHidPolicy(objrefHid.getTargetId());
                if (hidPolicy != null) {
                    this.appendCloudPolicyElement(doc, locElem, HID_POLICY, hidPolicy.getName(), hidPolicy.getId(), this.getEnabledstring((EnabledObject)hidPolicy), "false", locElem.getAttribute("isHidInherited"));
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        if (objrefTdad != null) {
            try {
                TdadPolicy tdadPolicy = dataObjManager.getTdadPolicy(objrefTdad.getTargetId());
                if (tdadPolicy != null) {
                    this.appendCloudPolicyElement(doc, locElem, TDAD_POLICY, tdadPolicy.getName(), tdadPolicy.getId(), this.getEnabledstring((EnabledObject)tdadPolicy), "false", locElem.getAttribute("isTdadInherited"));
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        if (objrefPolicymem != null) {
            try {
                MemPolicy memPolicy = dataObjManager.getMemPolicy(objrefPolicymem.getTargetId());
                if (memPolicy != null) {
                    this.appendCloudPolicyElement(doc, locElem, CLOUD_POLICY_MEM, memPolicy.getName(), memPolicy.getId(), this.getEnabledstring((EnabledObject)memPolicy), "false", locElem.getAttribute("isMemInherited"));
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        if (objrefPolicyoverridewhitelist != null) {
            try {
                PolicyOverride policyOverridewhitelist = dataObjManager.getPolicyOverride(objrefPolicyoverridewhitelist.getTargetId());
                if (policyOverridewhitelist != null) {
                    locElem.setAttribute("WhiteList", this.msgRes.getString("PolicyTemp.AllowList"));
                    this.appendCloudPolicyElement(doc, locElem, CLOUD_OVERRIDE_POLICY_WHITE_LIST, policyOverridewhitelist.getName(), policyOverridewhitelist.getId(), this.getEnabledstring((EnabledObject)policyOverridewhitelist), "false", locElem.getAttribute("isWhiteListInherited"));
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        if (objrefPolicyoverrideblacklist != null) {
            try {
                PolicyOverride policyOverrideblacklist = dataObjManager.getPolicyOverride(objrefPolicyoverrideblacklist.getTargetId());
                if (policyOverrideblacklist != null) {
                    locElem.setAttribute("BlackList", this.msgRes.getString("PolicyTemp.DenyList"));
                    this.appendCloudPolicyElement(doc, locElem, CLOUD_OVERRIDE_POLICY_BLACK_LIST, policyOverrideblacklist.getName(), policyOverrideblacklist.getId(), this.getEnabledstring((EnabledObject)policyOverrideblacklist), "false", locElem.getAttribute("isBlacklistInherited"));
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
    }

    private String getEnabledstring(EnabledObject obj) {
        Boolean enabled;
        String strDisabled = "false";
        if (obj != null && (enabled = obj.getOptEnable()) != null) {
            strDisabled = enabled == false ? "true" : "false";
        }
        return strDisabled;
    }

    private void appendCloudPolicyElement(Document doc, Element locElem, String elementName, String name, String id, String strDisabled, String islocalPolicy, String isInherited) {
        Element one = doc.createElement(elementName);
        if (one != null) {
            locElem.appendChild(one);
            one.setAttribute("Description", name);
            one.setAttribute("Id", id);
            one.setAttribute("Disabled", strDisabled);
            one.setAttribute("IsLocalPolicy", islocalPolicy);
            one.setAttribute("isWhiteListPolicy", elementName.equalsIgnoreCase(CLOUD_OVERRIDE_POLICY_WHITE_LIST) ? "true" : "false");
            one.setAttribute("isBlackListPolicy", elementName.equalsIgnoreCase(CLOUD_OVERRIDE_POLICY_BLACK_LIST) ? "true" : "false");
            if (isInherited.equals("true")) {
                one.setAttribute("isInherited", "true");
            } else {
                one.setAttribute("isInherited", "false");
            }
        }
    }

    public static boolean isCurrentAdminDisallowedPrivilege(String targetName) {
        if ("QuarantineAvPolicyApplied".equals(targetName) || "AvPolicyApplied".equals(targetName)) {
            return !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x22");
        }
        if ("QuarantineFWPolicyApplied".equals(targetName) || "FirewallPolicyApplied".equals(targetName)) {
            return !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x23");
        }
        if ("QuarantineOSPPolicyApplied".equals(targetName) || "OpAppProtectionPolicyApplied".equals(targetName)) {
            return !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x25");
        }
        if ("QuarantineCePolicyApplied".equals(targetName) || "PolicyOverrideApplied".equals(targetName)) {
            return !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x27");
        }
        if ("QuarantineLuPolicyApplied".equals(targetName) || "LuPolicyApplied".equals(targetName)) {
            return !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x26");
        }
        if ("QuarantineIdsPolicyApplied".equals(targetName) || "IdsPolicyApplied".equals(targetName)) {
            return !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x24");
        }
        if ("HostIntegrityApplied".equals(targetName)) {
            return !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x28");
        }
        if ("QuarantineMemPolicyApplied".equals(targetName) || "MemPolicyApplied".equals(targetName)) {
            return !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x29");
        }
        if ("QuarantineNtrPolicyApplied".equals(targetName) || "NtrPolicyApplied".equals(targetName)) {
            return !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x30");
        }
        if ("QuarantineUpgradePolicyApplied".equals(targetName) || "UpgradePolicyApplied".equals(targetName)) {
            return !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x31");
        }
        if ("QuarantineAdaptivePolicyApplied".equals(targetName) || "AdaptivePolicyApplied".equals(targetName)) {
            return !AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x32");
        }
        return false;
    }

    private void createAlSignature(Document doc, Element locElem, LocationObject locObj) {
        AlSignatureObject[] allSigs = locObj.getSignatures();
        for (int i = 0; i < allSigs.length; ++i) {
            Element sigElemt = doc.createElement("AlSignature");
            locElem.appendChild(sigElemt);
            AlSignatureOrObject[] localHostObjs = allSigs[i].getLocalHostAddress();
            this.createAddressElement(doc, sigElemt, localHostObjs);
            AlSignatureOrObject[] addressObj = allSigs[i].getGatewayAddress();
            this.createAddressElement(doc, sigElemt, addressObj);
            addressObj = allSigs[i].getWinsAddress();
            this.createAddressElement(doc, sigElemt, addressObj);
            addressObj = allSigs[i].getDhcpAddress();
            this.createAddressElement(doc, sigElemt, addressObj);
            addressObj = allSigs[i].getDnsAddress();
            this.createAddressElement(doc, sigElemt, addressObj);
            addressObj = allSigs[i].getNetworkCondition();
            this.createAddressElement(doc, sigElemt, addressObj);
            AlSignatureOrObject oneObj = allSigs[i].getCmsCondition();
            if (oneObj != null) {
                AlSignatureOrObject[] oneAddressObj = new AlSignatureOrObject[]{oneObj};
                this.createAddressElement(doc, sigElemt, oneAddressObj);
            }
            addressObj = allSigs[i].getTpmDevice();
            this.createAddressElement(doc, sigElemt, addressObj);
            addressObj = allSigs[i].getDnsResolve();
            this.createAddressElement(doc, sigElemt, addressObj);
            addressObj = allSigs[i].getAlRegistry();
            this.createAddressElement(doc, sigElemt, addressObj);
            addressObj = allSigs[i].getWirelessSSID();
            this.createAddressElement(doc, sigElemt, addressObj);
            addressObj = allSigs[i].getNICDescription();
            this.createAddressElement(doc, sigElemt, addressObj);
            addressObj = allSigs[i].getRemoteDeviceComm();
            this.createAddressElement(doc, sigElemt, addressObj);
            addressObj = allSigs[i].getDomainName();
            this.createAddressElement(doc, sigElemt, addressObj);
            addressObj = allSigs[i].getLocalHostName();
            this.createAddressElement(doc, sigElemt, addressObj);
            addressObj = allSigs[i].getUserName();
            this.createAddressElement(doc, sigElemt, addressObj);
            addressObj = allSigs[i].getFileExists();
            this.createAddressElement(doc, sigElemt, addressObj);
            addressObj = allSigs[i].getOSVersion();
            this.createAddressElement(doc, sigElemt, addressObj);
        }
    }

    private void createAddressElement(Document doc, Element sigElemt, AlSignatureOrObject[] addressObjs) {
        for (int j = 0; j < addressObjs.length; ++j) {
            Element addressElem = doc.createElement("Address");
            sigElemt.appendChild(addressElem);
            String data = addressObjs[j].toString();
            data = data.substring("<html>".length());
            data = data.substring(0, data.length() - "</html>".length());
            data = data.replaceAll("<b>", "");
            data = data.replaceAll("</b>", "");
            Text textNode = doc.createTextNode(data);
            addressElem.appendChild(textNode);
        }
    }

    static {
        initialized = false;
        keys = new String[]{"AgentPolicyAt", "PolicySerialNo", "PolicySize", "PolicyDate", "IPSSerialNo", "UseSamePolicyAsParentGroup", "LocationOverview", "Location", "ExpandLoc", "SwitchToThisLocationWhen", "Edit", "EditSettings", "ExpandLocCondition", "NoConditionSpecifiedForThisLocation", "QuarantinePoliciesWhenHostIntegrityFails", "AND", "OR", "Policies", "Add", "ExpandPolicy", "SharedCloud", "SharedExternal", "NoPolicyAppliedToThisLocation", "AdvancedSettings", "ExpandAdvancedSetting", "CustomizedAgentUserInterface", "CommunicatewithPolicyManager", "ExternalCommunicationwithPolicyManager", "ExternalCommunication", "Group", "Local", "Pull", "Push", "Standalone", "ProtectionSettings", "ApplicationAuthentication", "ON", "Off", "BufferOverflowProtection", "SystemLockdown", "HowItWorks", "OtherSettings", "IPSLibraries", "LogSettings", "Communication", "GeneralSettings", "PasswordSettings", "LuContentPolicy", "InheritanceIs", "GroupPoliciesAndSettings", "GroupSettings", "LocationSpecific", "Shared", "View", "More", "AddPolicy", "LocSpecificPolicies", "TamperProtectionwithSubmissions", "TamperProtectionPolicy", "OtherPolicy", IDS_POLICY, AV_POLICY, HID_POLICY, "FwFirewallPolicy", "HiHostIntegrityPolicy", "LuPolicy", "PolicyOverride", "OpAppProtectionPolicy", MEM_POLICY, NTR_POLICY, TDAD_POLICY, UPGRADE_POLICY, ADAPTIVE_POLICY};
        values = new String[keys.length];
    }

    public static class ExpandStatus {
        boolean wholeLocation = true;
        boolean locationCondition = true;
        boolean policies = true;
        boolean quarantinePolicies = true;
        boolean advancedSetting = false;

        public void setWholeLocation(boolean newStatus) {
            this.wholeLocation = newStatus;
        }

        public void setLocationCondition(boolean newStatus) {
            this.locationCondition = newStatus;
        }

        public void setPolicies(boolean newStatus) {
            this.policies = newStatus;
        }

        public void setQuarantinePolicies(boolean newStatus) {
            this.quarantinePolicies = newStatus;
        }

        public void setAdvandedSetting(boolean newStatus) {
            this.advancedSetting = newStatus;
        }
    }
}

