/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.rpc.AgentCommand;
import com.sygate.scm.common.configobject.rpc.GroupArray;
import com.sygate.scm.common.configobject.rpc.HardwareKeyArray;
import com.sygate.scm.common.configobject.rpc.NameValuePair;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.schema.Command;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemClientGroupTree;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SemGroupPolicy;
import com.sygate.scm.common.configobject.schema.SoftwareDeploymentEntity;
import com.sygate.scm.common.configobject.schema.SoftwareDeploymentPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.BundledGroupNamesObject;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SemComputerHandler;
import com.sygate.scm.console.handler.SemUserHandler;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.util.SortableTreeNode;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.TimeCounter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.CRC32;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class GroupHandler
extends AbstractHandler {
    private static BundledGroupNamesObject bundledGroupNames = null;

    public static ArrayList<GroupObject> getAllowedChildGroups(GroupObject parent, boolean includeSubgroups) {
        return GroupHandler.getAllowedChildGroups(parent, includeSubgroups, 2);
    }

    public static ArrayList<GroupObject> getAllowedChildGroups(GroupObject parent, boolean includeSubgroups, int accessFilter) {
        AdminObject admin;
        ArrayList<GroupObject> list = new ArrayList<GroupObject>();
        String domainID = Manager.getCurrentDomainId();
        DataobjectManager data = DataobjectManager.getInstance();
        SemClientGroup gParent = parent.getParent();
        AdminPrivilegeObject adminPrivilege = null;
        if (domainID != null && data.getLoginInformation() != null && !(admin = AdminObject.retrieveCurrentAdminObject()).isSysAdmin() && !admin.isDomainSysAdmin()) {
            adminPrivilege = admin.getAdminPrivilege();
            parent.setAccessible(adminPrivilege.hasAccessRightToGroup(parent.getId(), true));
            if (gParent != null) {
                GroupObject gParentObject = new GroupObject(gParent);
                parent.setAccessConstraint(adminPrivilege.getGroupConstraint(parent.getId(), gParentObject.getAccessConstraint(true)));
            } else {
                parent.setAccessConstraint(adminPrivilege.getGroupConstraint(parent.getId(), 0));
            }
            ConsoleLogger.log("GroupHandler>> getGroupsRoot: groupAccess=" + parent.getName() + ", " + parent.isAccessible() + ", " + parent.getAccessConstraint());
        }
        if (parent.isAccessible() && GroupHandler.clearAccess(parent, accessFilter)) {
            list.add(parent);
        }
        if (includeSubgroups) {
            GroupHandler.getAllowedChildGroups(list, parent, adminPrivilege, accessFilter);
        }
        return list;
    }

    private static void getAllowedChildGroups(ArrayList<GroupObject> list, GroupObject parent, AdminPrivilegeObject privilege, int accessFilter) {
        SemClientGroup rootcg = parent.getSemClientGroup();
        Vector groups = rootcg.getSemClientGroup();
        for (SemClientGroup group : groups) {
            GroupObject go = new GroupObject(group);
            if (privilege != null) {
                go.setAccessible(privilege.hasAccessRightToGroup(group.getId(), parent.isAccessible()));
                go.setAccessConstraint(privilege.getGroupConstraint(group.getId(), parent.getAccessConstraint()));
                ConsoleLogger.log("GroupHandler>> getChildGroups: groupAccess = " + go.getName() + "," + go.isAccessible() + "," + go.getAccessConstraint());
            }
            if (go.isAccessible() && GroupHandler.clearAccess(go, accessFilter)) {
                list.add(go);
            }
            GroupHandler.getAllowedChildGroups(list, go, privilege, accessFilter);
        }
    }

    private static boolean clearAccess(GroupObject group, int accessFilter) {
        boolean isValid = false;
        switch (accessFilter) {
            case 1: {
                isValid = true;
                break;
            }
            case 2: {
                if (group.getAccessConstraint() == 1) break;
                isValid = true;
                break;
            }
            case 0: {
                if (group.getAccessConstraint() != 0) break;
                isValid = true;
                break;
            }
        }
        return isValid;
    }

    public static Map<String, GroupObject> getAccessibleGroupMap() throws ConsoleException {
        HashMap<String, GroupObject> groupMap = new HashMap<String, GroupObject>();
        DefaultMutableTreeNode groups = GroupHandler.getGroups();
        if (groups != null) {
            Enumeration<TreeNode> e = groups.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                GroupObject groupChild = (GroupObject)((DefaultMutableTreeNode)e.nextElement()).getUserObject();
                if (!groupChild.isAccessible()) continue;
                groupMap.put(groupChild.getId(), groupChild);
            }
        }
        return groupMap;
    }

    public static List<String> getGroupPathsByPackageId(String packageId) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        Map<String, String> groups = data.getGroupPathsMapByPackageId(packageId);
        ArrayList<String> groupPathList = null;
        if (groups != null) {
            try {
                AdminObject admin = AdminObject.retrieveCurrentAdminObject();
                if (!admin.isSysAdmin() && !admin.isDomainSysAdmin()) {
                    AdminPrivilegeObject adminPrivilege = admin.getAdminPrivilege();
                    if (null != adminPrivilege) {
                        Map<String, GroupObject> accessibleGroups = GroupHandler.getAccessibleGroupMap();
                        groupPathList = new ArrayList();
                        for (Map.Entry<String, String> group : groups.entrySet()) {
                            if (!accessibleGroups.containsKey(group.getKey())) continue;
                            groupPathList.add(group.getValue());
                        }
                    }
                } else {
                    groupPathList = new ArrayList<String>(groups.values());
                }
            }
            catch (Exception ex) {
                throw new ConsoleException(ex);
            }
        }
        return groupPathList;
    }

    public static ArrayList<GroupObject> getChildGroups(GroupObject parent) {
        ArrayList<GroupObject> list = new ArrayList<GroupObject>();
        GroupHandler.getChildGroups(list, parent.getSemClientGroup());
        return list;
    }

    private static void getChildGroups(ArrayList<GroupObject> list, SemClientGroup parent) {
        Vector groups = parent.getSemClientGroup();
        int len = groups.size();
        if (len == 0) {
            return;
        }
        for (SemClientGroup group : groups) {
            list.add(new GroupObject(group));
            GroupHandler.getChildGroups(list, group);
        }
    }

    public static GroupObject getChildGroup(GroupObject parent, String childName) {
        if (parent == null) {
            return null;
        }
        if (childName == null) {
            return null;
        }
        childName = childName.trim();
        Vector children = parent.getSemClientGroup().getSemClientGroup();
        int len = children.size();
        if (len == 0) {
            return null;
        }
        for (SemClientGroup group : children) {
            if (!group.getName().trim().equals(childName)) continue;
            return new GroupObject(group);
        }
        return null;
    }

    public static void delGroupMembers(String groupId) throws ConsoleException {
        if (groupId == null) {
            return;
        }
        RpcData data = new RpcData();
        NameValuePair pair = new NameValuePair();
        pair.setName("DELETE_GROUP_MEMBERS");
        pair.setOptValue(groupId);
        data.addNameValuePair(pair);
        NameValuePair pair2 = new NameValuePair();
        pair2.setName("DELETE_GROUP");
        pair2.setOptValue(groupId);
        data.addNameValuePair(pair2);
        GUIManager.sendCommand("DriveAgent", (AbstractSchema)data);
    }

    public static boolean isGroupCanbeDeleted(GroupObject gobj) throws ConsoleException {
        SoftwareDeploymentPolicy policy;
        SemClientGroup group = gobj.getSemClientGroup();
        if (group == null) {
            return false;
        }
        if (gobj.isTypeAdNode()) {
            return false;
        }
        if (gobj.isFixed()) {
            return false;
        }
        if (gobj.isTypeNative()) {
            int lenComputer;
            int lenGroup = group.getSemClientGroupCount();
            int lenUser = lenGroup > 0 ? 0 : SemUserHandler.getGroupUserCount(group.getId());
            int n = lenComputer = lenGroup + lenUser > 0 ? 0 : SemComputerHandler.getGroupComputerCount(group.getId());
            if (lenUser + lenComputer + lenGroup > 0) {
                int errorMsg = 61;
                if (LicenseObject.getInstance().isSBProduct()) {
                    errorMsg = 62;
                }
                throw new ConsoleException(-2096955392, errorMsg);
            }
        }
        if ((policy = SoftwarePackageHandler.getSoftwareDeploymentPolicy(gobj)) != null) {
            while (policy.getSoftwareDeploymentEntityCount() > 0) {
                SoftwareDeploymentEntity entity = policy.getSoftwareDeploymentEntity(0);
                SoftwarePackageHandler.deleteSoftwareDeploymentEntity(policy, entity);
            }
        }
        if (gobj.isTypeAdTree()) {
            ArrayList<GroupObject> list = new ArrayList<GroupObject>();
            GroupHandler.getChildGroups(list, group);
            list.add(new GroupObject(group));
            for (int i = 0; i < list.size(); ++i) {
                GroupObject aGroup = list.get(i);
                GroupHandler.delGroupMembers(aGroup.getId());
            }
        }
        if (group.getParent() instanceof SemClientGroupTree) {
            throw new ConsoleException(-2097020928, 60);
        }
        return true;
    }

    public static boolean delGroup(GroupObject gobj) throws ConsoleException {
        if (GroupHandler.isGroupCanbeDeleted(gobj)) {
            SemClientGroup group = gobj.getSemClientGroup();
            AbstractSchema parent = group.getParent();
            ((SemClientGroup)parent).removeSemClientGroup(group);
            ((SemClientGroup)parent).setModifiedTime(Long.valueOf(TimeUtil.getServerTime()));
            SemClientGroupTree topParent = (SemClientGroupTree)group.getTopLevelObject();
            DataobjectManager.getInstance().deleteClientGroup(topParent, group.getId());
            ConsoleLogger.logAdminEvent(8194);
            return true;
        }
        return false;
    }

    public static GroupObject addGroup(GroupObject gobj) throws ConsoleException {
        AbstractSchema parent;
        SemClientGroup group = gobj.getSemClientGroup();
        group.setModifiedTime(Long.valueOf(TimeUtil.getServerTime()));
        SemClientGroupTree topParent = null;
        if (parent instanceof SemClientGroup) {
            for (parent = group.getParent(); parent != null && parent instanceof SemClientGroup; parent = parent.getParent()) {
            }
            topParent = (SemClientGroupTree)parent;
        } else {
            topParent = (SemClientGroupTree)parent;
        }
        ArrayList<DataobjectManager.UpdateObjectEntry> list = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)topParent, 0);
        list.add(entry);
        Iterator<SemGroupPolicy> it = gobj.getNewObject().iterator();
        while (it.hasNext()) {
            TopLevelObject newObj = (TopLevelObject)it.next();
            entry = new DataobjectManager.UpdateObjectEntry(newObj, 1);
            list.add(entry);
            it.remove();
        }
        DataobjectManager dbManager = DataobjectManager.getInstance();
        dbManager.updateObject("Merge", list);
        String groupName = group.getName();
        MessageResources msgRes = MessageResources.getInstance();
        String description = MessageFormat.format(msgRes.getString("com.sygate.scm.console.handler.handler", "GroupHandler.GroupAdded"), groupName);
        ConsoleLogger.logAdminEvent(8193, description);
        return GroupHandler.getGroupById(gobj.getId());
    }

    public static GroupObject updateGroup(GroupObject gobj) throws ConsoleException {
        AbstractSchema parent;
        SemClientGroup group = gobj.getSemClientGroup();
        group.setModifiedTime(Long.valueOf(TimeUtil.getServerTime()));
        SemClientGroupTree topParent = null;
        if (parent instanceof SemClientGroup) {
            for (parent = group.getParent(); parent != null && parent instanceof SemClientGroup; parent = parent.getParent()) {
            }
            topParent = (SemClientGroupTree)parent;
        } else {
            topParent = (SemClientGroupTree)parent;
        }
        SemClientGroupTree tree = (SemClientGroupTree)DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)topParent);
        return GroupHandler.getGroupById(tree, gobj.getId());
    }

    public static boolean moveGroup(String currentGroupId, String newParentGroupId) throws ConsoleException {
        if (currentGroupId.equals(newParentGroupId)) {
            throw new ConsoleException(-2046492672, 97);
        }
        GroupObject gobj = GroupHandler.getGroupByIdLocally(currentGroupId);
        if (gobj != null) {
            AbstractSchema parent;
            SemClientGroup group = gobj.getSemClientGroup();
            if (group == null) {
                return false;
            }
            if (gobj.isTypeAdNode()) {
                throw new ConsoleException(-2046754816, 77);
            }
            if (gobj.isFixed()) {
                throw new ConsoleException(-2046689280, 78);
            }
            SemClientGroupTree groupRootTree = null;
            for (parent = group.getParent(); parent != null && parent instanceof SemClientGroup; parent = parent.getParent()) {
            }
            groupRootTree = (SemClientGroupTree)parent;
            GroupObject newParent = GroupHandler.getGroupById(groupRootTree, newParentGroupId);
            if (newParent == null) {
                return false;
            }
            if (newParent.getSemClientGroup() == null) {
                return false;
            }
            if (!newParent.isTypeNative() && !newParent.isTemp()) {
                throw new ConsoleException(-2046623744, 79);
            }
            if (newParent.isTemp()) {
                throw new ConsoleException(-2046558208, 80);
            }
            for (parent = newParent.getSemClientGroup().getParent(); parent != null && parent instanceof SemClientGroup; parent = parent.getParent()) {
                if (!((SemClientGroup)parent).getId().equals(group.getId())) continue;
                return false;
            }
            SemClientGroupTree topParent = null;
            parent = group.getParent();
            if (!(parent instanceof SemClientGroup)) {
                return false;
            }
            if (newParent.getSemClientGroup().getId().equals(group.getId())) {
                return false;
            }
            if (newParent.getSemClientGroup().getId().equals(((SemClientGroup)parent).getId())) {
                return false;
            }
            group.setModifiedTime(Long.valueOf(TimeUtil.getServerTime()));
            ((SemClientGroup)parent).removeSemClientGroup(group);
            newParent.getSemClientGroup().addSemClientGroup(group);
            newParent.getSemClientGroup().setModifiedTime(Long.valueOf(TimeUtil.getServerTime()));
            for (parent = group.getParent(); parent != null && parent instanceof SemClientGroup; parent = parent.getParent()) {
            }
            topParent = (SemClientGroupTree)parent;
            DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)topParent);
            ConsoleLogger.logAdminEvent(8196);
            return true;
        }
        return false;
    }

    public static boolean isNewGroupNameValidForChildGroups(GroupObject group, GroupObject newParentGroup) {
        if (group == null || group.getSemClientGroup() == null || newParentGroup == null) {
            return true;
        }
        String newFullPath = GroupHandler.getGroupFullPath(newParentGroup, group.getName());
        if (newFullPath.length() > 1000) {
            System.out.println("GroupHandler>> isNewGroupNameValidForChildGroups: Too long-> newFullPath=" + newFullPath);
            return false;
        }
        return GroupHandler.isNewGroupNameValidForChildGroupsAux(group, newFullPath);
    }

    public static boolean isNewGroupNameValidForChildGroups(GroupObject group, String newGroupName) {
        if (group == null || group.getSemClientGroup() == null || newGroupName == null || newGroupName.length() < 1) {
            return true;
        }
        String newFullPath = GroupHandler.getGroupFullPath(group.getParentGroup(), newGroupName);
        return GroupHandler.isNewGroupNameValidForChildGroupsAux(group, newFullPath);
    }

    private static boolean isNewGroupNameValidForChildGroupsAux(GroupObject currentGroup, String currentGroupNewFullName) {
        Vector groups = currentGroup.getSemClientGroup().getSemClientGroup();
        int len = groups.size();
        if (len == 0) {
            return true;
        }
        for (SemClientGroup group : groups) {
            if (group == null) continue;
            String newFullPath = GroupHandler.generateGroupFullPath(currentGroupNewFullName, currentGroup.getName());
            if (newFullPath.length() > 1000) {
                System.out.println("GroupHandler>> isNewGroupNameValidForChildGroupsAux: Too long-> newFullPath=" + newFullPath);
                return false;
            }
            if (GroupHandler.isNewGroupNameValidForChildGroupsAux(new GroupObject(group), newFullPath)) continue;
            return false;
        }
        return true;
    }

    public static String getGroupFullPath(GroupObject parentGroup, String childName) {
        String parentFullPath = GroupHandler.getGroupFullPath(parentGroup);
        if (parentFullPath == null || parentFullPath.length() < 1) {
            return childName;
        }
        return parentFullPath + "\\" + childName;
    }

    public static String generateGroupFullPath(String parentFullPath, String groupName) {
        return parentFullPath + "\\" + groupName;
    }

    public static String getGroupFullPath(String groupId) throws ConsoleException {
        GroupObject group = GroupHandler.getGroupById(groupId);
        if (group == null) {
            return "";
        }
        return GroupHandler.getGroupFullPath(group);
    }

    public static String getGroupFullPath(GroupObject gobj) {
        if (gobj == null) {
            return "";
        }
        SemClientGroup group = gobj.getSemClientGroup();
        Object path = group.getName();
        SemClientGroup parent = group;
        while ((parent = parent.getParent()) != null && parent instanceof SemClientGroup) {
            path = parent.getName() + "\\" + (String)path;
        }
        return path;
    }

    public static GroupObject getGroupByFullPathForDomain(String fullPath, String domainId) throws ConsoleException {
        SemDomain domain;
        String cgtGUID;
        if (fullPath == null) {
            return null;
        }
        if (StringUtilities.isEmpty((String)domainId)) {
            domainId = Manager.getCurrentDomainId();
        }
        fullPath = fullPath.trim();
        DataobjectManager data = DataobjectManager.getInstance();
        SemClientGroupTree cgt = (SemClientGroupTree)data.getObjectByGUID("SemClientGroupTree", cgtGUID = (domain = (SemDomain)data.getObjectByGUID("SemDomain", domainId)).getObjReference().getTargetId());
        SemClientGroup rootgroup = cgt.getSemClientGroup();
        SemClientGroup group = GroupHandler.getChildGroupWithFullPath(rootgroup, rootgroup.getName(), fullPath);
        if (group == null) {
            System.out.println("** Grouphandler-->getGroupByFullPath(String fullPath) group got is null** ->" + fullPath);
        }
        return group == null ? null : new GroupObject(group);
    }

    public static GroupObject getGroupByFullPath(String fullPath) throws ConsoleException {
        return GroupHandler.getGroupByFullPathForDomain(fullPath, null);
    }

    private static SemClientGroup getChildGroupWithFullPath(SemClientGroup parent, String parentPath, String fullPath) {
        if (parentPath == null || fullPath == null) {
            return null;
        }
        if (fullPath.indexOf(parentPath) < 0) {
            return null;
        }
        if (parent == null) {
            return null;
        }
        if (parentPath.equals(fullPath)) {
            return parent;
        }
        Vector children = parent.getSemClientGroup();
        int len = children.size();
        if (len == 0) {
            return null;
        }
        for (SemClientGroup group : children) {
            String path = parentPath + "\\" + group.getName();
            if (path.equals(fullPath)) {
                return group;
            }
            if ((group = GroupHandler.getChildGroupWithFullPath(group, path, fullPath)) == null) continue;
            return group;
        }
        return null;
    }

    public static DefaultMutableTreeNode getGroups() throws ConsoleException {
        return GroupHandler.getGroups(false);
    }

    public static DefaultMutableTreeNode getGroups(boolean bRefresh) throws ConsoleException {
        return GroupHandler.getGroups(bRefresh, false);
    }

    public static DefaultMutableTreeNode getGroups(boolean bRefresh, boolean excludeReadonly) throws ConsoleException {
        DataobjectManager d = DataobjectManager.getInstance();
        if (d.getLoginInformation() == null) {
            return GroupHandler.getGroups(bRefresh, null, false, excludeReadonly);
        }
        return GroupHandler.getGroups(bRefresh, Manager.getCurrentDomainId(), true, excludeReadonly);
    }

    public static DefaultMutableTreeNode getGroups(boolean bRefresh, String domainID, boolean checkCurrentAdminPrivilege, boolean excludeReadonly) throws ConsoleException {
        return GroupHandler.getGroupsRoot(bRefresh, domainID, checkCurrentAdminPrivilege, excludeReadonly);
    }

    public static DefaultMutableTreeNode getGroupsRoot(boolean bRefresh) throws ConsoleException {
        return GroupHandler.getGroupsRoot(bRefresh, Manager.getCurrentDomainId(), true, false);
    }

    public static DefaultMutableTreeNode getGroupsRoot(boolean bRefresh, boolean excludeReadonly) throws ConsoleException {
        return GroupHandler.getGroupsRoot(bRefresh, Manager.getCurrentDomainId(), true, excludeReadonly);
    }

    public static DefaultMutableTreeNode getGroupsRoot(boolean bRefresh, String domainID, boolean checkCurrentAdminPrivilege, boolean excludeReadonly) throws ConsoleException {
        return GroupHandler.getGroupsRoot(bRefresh, domainID, checkCurrentAdminPrivilege, excludeReadonly, false);
    }

    public static DefaultMutableTreeNode getGroupsRoot(boolean bRefreshGroup, String domainID, boolean checkCurrentAdminPrivilege, boolean excludeReadonly, boolean refreshAdminWithDB) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", domainID, bRefreshGroup);
        String cgtGUID = domain.getObjReference().getTargetId();
        SemClientGroupTree cgt = (SemClientGroupTree)data.getObjectByGUID("SemClientGroupTree", cgtGUID, bRefreshGroup);
        SemClientGroup rootcg = cgt.getSemClientGroup();
        GroupObject global = new GroupObject(rootcg);
        SortableTreeNode root = new SortableTreeNode(global);
        AdminPrivilegeObject adminPrivilege = GroupHandler.checkGroupPermission(domainID, checkCurrentAdminPrivilege, excludeReadonly, data, global, refreshAdminWithDB);
        GroupHandler.setGroupTreeRefreshChecksum(cgt, adminPrivilege);
        boolean hasComputerUserPrivilege = AdminPrivilegeObject.isCurrentAdminHasComputerUserPrivilege();
        boolean isChildrenAccessible = GroupHandler.getChildGroups(global, root, adminPrivilege, excludeReadonly, hasComputerUserPrivilege);
        if (!isChildrenAccessible && !global.isAccessible()) {
            return null;
        }
        return root;
    }

    private static AdminPrivilegeObject checkGroupPermission(String domainID, boolean checkCurrentAdminPrivilege, boolean excludeReadonly, DataobjectManager data, GroupObject global, boolean refreshAdminWithDB) {
        AdminObject admin;
        AdminPrivilegeObject adminPrivilege = null;
        if (domainID != null && domainID.equals(Manager.getCurrentDomainId()) && checkCurrentAdminPrivilege && data.getLoginInformation() != null && !(admin = AdminObject.retrieveCurrentAdminObject(refreshAdminWithDB)).isSysAdmin() && !admin.isDomainSysAdmin()) {
            adminPrivilege = admin.getAdminPrivilege();
            if (!AdminPrivilegeObject.isCurrentAdminHasComputerUserPrivilege()) {
                global.setAccessible(false);
                global.setAccessConstraint(1);
            } else {
                global.setAccessible(adminPrivilege.hasAccessRightToGroup(global.getId(), true, excludeReadonly));
                global.setAccessConstraint(adminPrivilege.getGroupConstraint(global.getId(), 0));
            }
            System.out.println("GroupHandler>> getGroupsRoot: groupAccess=" + global.getName() + ", " + global.isAccessible() + ", " + global.getAccessConstraint());
        }
        return adminPrivilege;
    }

    public static boolean isGroupTreeRefreshChecksumChanged(String oldGroupTreeRefreshChecksum) throws ConsoleException {
        AdminObject admin;
        if (oldGroupTreeRefreshChecksum == null || oldGroupTreeRefreshChecksum.length() < 1) {
            return true;
        }
        TimeCounter counter = new TimeCounter();
        counter.start();
        String currentDomainId = Manager.getCurrentDomainId();
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = data.getSemDomain(currentDomainId);
        String groupTreeGUID = domain.getObjReference().getTargetId();
        SemClientGroupTree groupTree = data.getSemClientGroupTree(groupTreeGUID);
        AdminPrivilegeObject adminPrivilege = null;
        if (data.getLoginInformation() != null && !(admin = AdminObject.retrieveCurrentAdminObject()).isSysAdmin() && !admin.isDomainSysAdmin()) {
            adminPrivilege = admin.getAdminPrivilege();
        }
        String newGroupTreeRefreshChecksum = GroupHandler.generateGroupTreeRefreshChecksum(groupTree, adminPrivilege);
        counter.stop();
        System.out.println("GroupHandler>> isGroupTreeRefreshChecksumChanged: old=" + oldGroupTreeRefreshChecksum + ", new=" + newGroupTreeRefreshChecksum + ", time=" + counter.toString());
        return !newGroupTreeRefreshChecksum.equals(oldGroupTreeRefreshChecksum);
    }

    public static String getGroupTreeRefreshChecksum() {
        String checksum = System.getProperty("GroupTree.Refresh.Checksum");
        System.out.println("GroupHandler>> getGroupTreeRefreshChecksum: GroupTree.Refresh.Checksum=" + (checksum == null ? "" : checksum));
        return checksum == null ? "" : checksum;
    }

    private static void setGroupTreeRefreshChecksum(SemClientGroupTree groupTree, AdminPrivilegeObject adminPrivilege) {
        String checksum = GroupHandler.generateGroupTreeRefreshChecksum(groupTree, adminPrivilege);
        System.setProperty("GroupTree.Refresh.Checksum", checksum);
    }

    private static String generateGroupTreeRefreshChecksum(SemClientGroupTree groupTree, AdminPrivilegeObject adminPrivilege) {
        if (groupTree == null) {
            System.out.println("GroupHandler>> generateGroupTreeRefreshChecksum: groupTree is null!! checksum=-1");
            return "-1";
        }
        TimeCounter counter = new TimeCounter();
        counter.start();
        CRC32 crc32 = new CRC32();
        String checksumGroupTree = groupTree.getMetadataAttributes().getChecksum();
        try {
            crc32.update(checksumGroupTree.getBytes(Charset.defaultCharset()));
            if (adminPrivilege != null) {
                int i;
                ArrayList<String> listAllowed = adminPrivilege.getAllowedClientGroupList();
                ArrayList<String> listDisallowed = adminPrivilege.getDisallowedClientGroupList();
                ArrayList<String> listReadOnly = adminPrivilege.getReadOnlyClientGroupList();
                if (listAllowed != null) {
                    for (i = 0; i < listAllowed.size(); ++i) {
                        crc32.update(listAllowed.get(i).getBytes(Charset.defaultCharset()));
                    }
                }
                crc32.update(0);
                if (listDisallowed != null) {
                    for (i = 0; i < listDisallowed.size(); ++i) {
                        crc32.update(listDisallowed.get(i).getBytes(Charset.defaultCharset()));
                    }
                }
                crc32.update(1);
                if (listReadOnly != null) {
                    for (i = 0; i < listReadOnly.size(); ++i) {
                        crc32.update(listReadOnly.get(i).getBytes(Charset.defaultCharset()));
                    }
                }
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        String str = Long.toString(crc32.getValue());
        counter.stop();
        System.out.println("GroupHandler>> generateGroupTreeRefreshChecksum: checksum=" + str + ", time=" + counter.toString());
        return str;
    }

    public static GroupObject getRootGroupObject() throws ConsoleException {
        String domainID = Manager.getCurrentDomainId();
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", domainID);
        return GroupHandler.getRootGroupObject(domain);
    }

    public static GroupObject getRootGroupObject(SemDomain domain) throws ConsoleException {
        String cgtGUID = domain.getObjReference().getTargetId();
        return GroupHandler.getRootGroupObject(cgtGUID);
    }

    public static GroupObject getRootGroupObject(String groupTreeId) throws ConsoleException {
        SemClientGroupTree tree = (SemClientGroupTree)DataobjectManager.getInstance().getObjectByGUID("SemClientGroupTree", groupTreeId);
        SemClientGroup group = tree.getSemClientGroup();
        GroupObject gobj = new GroupObject(group);
        return gobj;
    }

    public static boolean isGroupTreeChanged() throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        if (data.getLoginInformation() == null) {
            return true;
        }
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", Manager.getCurrentDomainId());
        String cgtGUID = domain.getObjReference().getTargetId();
        return data.isObjectChanged("SemClientGroupTree", cgtGUID);
    }

    private static boolean getChildGroups(GroupObject parentGroup, DefaultMutableTreeNode parentTreeNode, AdminPrivilegeObject adminPrivilege, boolean excludeReadonly, boolean hasComputerUserPrivilege) {
        DefaultMutableTreeNode grandParentNode;
        if (parentGroup == null) {
            return false;
        }
        SemClientGroup rootcg = parentGroup.getSemClientGroup();
        Vector childGroups = rootcg.getSemClientGroup();
        boolean isChildAccessible = false;
        for (SemClientGroup group : childGroups) {
            GroupObject go = new GroupObject(group);
            if (adminPrivilege != null) {
                if (!hasComputerUserPrivilege) {
                    go.setAccessible(false);
                    go.setAccessConstraint(1);
                } else {
                    go.setAccessible(adminPrivilege.hasAccessRightToGroup(group.getId(), parentGroup.isAccessible(), excludeReadonly));
                    go.setAccessConstraint(adminPrivilege.getGroupConstraint(group.getId(), parentGroup.getAccessConstraint()));
                }
                System.out.println("GroupHandler>> getChildGroups: groupAccess=" + go.getName() + ", " + go.isAccessible() + ", " + go.getAccessConstraint());
            }
            if (go.isAccessible()) {
                isChildAccessible = true;
            }
            SortableTreeNode treeNode = new SortableTreeNode(go, true);
            parentTreeNode.add(treeNode);
            if (!GroupHandler.getChildGroups(go, treeNode, adminPrivilege, excludeReadonly, hasComputerUserPrivilege)) continue;
            isChildAccessible = true;
        }
        if (!isChildAccessible && !parentGroup.isAccessible() && (grandParentNode = (DefaultMutableTreeNode)parentTreeNode.getParent()) != null) {
            System.out.println("GroupHandler>> getChildGroups: remove group=" + parentGroup.getName());
            grandParentNode.remove(parentTreeNode);
        }
        return isChildAccessible;
    }

    public static GroupObject getGroupById(String groupId) throws ConsoleException {
        if (groupId == null || groupId.length() < 1) {
            return null;
        }
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", Manager.getCurrentDomainId());
        String groupTreeId = domain.getObjReference().getTargetId();
        SemClientGroupTree tree = (SemClientGroupTree)DataobjectManager.getInstance().getObjectByGUID("SemClientGroupTree", groupTreeId);
        return GroupHandler.getGroupById(tree, groupId);
    }

    public static GroupObject getGroupByIdLocally(String groupId) throws ConsoleException {
        if (groupId == null || groupId.length() < 1) {
            return null;
        }
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", Manager.getCurrentDomainId(), false);
        String groupTreeId = domain.getObjReference().getTargetId();
        SemClientGroupTree tree = (SemClientGroupTree)DataobjectManager.getInstance().getObjectByGUID("SemClientGroupTree", groupTreeId, false);
        return GroupHandler.getGroupById(tree, groupId);
    }

    public static GroupObject getGroupById(SemClientGroupTree tree, String groupId) throws ConsoleException {
        if (tree == null || groupId == null || groupId.length() < 1) {
            return null;
        }
        SemClientGroup group = tree.getSemClientGroup();
        if (group.getId().equals(groupId)) {
            return new GroupObject(group);
        }
        return GroupHandler.getGroupById(group, groupId);
    }

    public static GroupObject getGroupById(SemClientGroup parentGroup, String groupId) throws ConsoleException {
        if (parentGroup == null || groupId == null || groupId.length() < 1) {
            return null;
        }
        int count = parentGroup.getSemClientGroupCount();
        if (count < 1) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            SemClientGroup group = parentGroup.getSemClientGroup(i);
            if (group != null && groupId.equals(group.getId())) {
                return new GroupObject(group);
            }
            GroupObject result = GroupHandler.getGroupById(group, groupId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static boolean hasChildGroup(GroupObject parentGroupObj, GroupObject groupObj) {
        SemClientGroup group = groupObj.getSemClientGroup();
        if (group == null) {
            return false;
        }
        String parentId = parentGroupObj.getId();
        if (parentId == null || parentId.length() < 1) {
            return false;
        }
        for (AbstractSchema parent = group.getParent(); parent != null && parent instanceof SemClientGroup; parent = parent.getParent()) {
            if (!((SemClientGroup)parent).getId().equals(parentId)) continue;
            return true;
        }
        return false;
    }

    public static com.sygate.scm.common.configobject.rpc.RebootOptions transferRebootOptions(RebootOptions serverRebootOptions) {
        com.sygate.scm.common.configobject.rpc.RebootOptions agentRebootOptions = new com.sygate.scm.common.configobject.rpc.RebootOptions();
        agentRebootOptions.setOptRebootMethod(serverRebootOptions.getOptRebootMethod());
        agentRebootOptions.setOptRebootSchedule(serverRebootOptions.getOptRebootSchedule());
        agentRebootOptions.setOptRebootDay(serverRebootOptions.getOptRebootDay());
        agentRebootOptions.setOptRebootMinutes(serverRebootOptions.getOptRebootMinutes());
        agentRebootOptions.setOptRandomize(serverRebootOptions.getOptRandomize());
        agentRebootOptions.setOptRandomizeHours(serverRebootOptions.getOptRandomizeHours());
        agentRebootOptions.setOptPromptUser(serverRebootOptions.getOptPromptUser());
        agentRebootOptions.setOptPromptType(serverRebootOptions.getOptPromptType());
        agentRebootOptions.setOptPromptMessage(serverRebootOptions.getOptPromptMessage());
        agentRebootOptions.setOptDisplayTimeout(serverRebootOptions.getOptDisplayTimeout());
        agentRebootOptions.setOptCountdown(serverRebootOptions.getOptCountdown());
        agentRebootOptions.setOptMaxSnoozeCount(serverRebootOptions.getOptMaxSnoozeCount());
        agentRebootOptions.setOptSnoozeInterval(serverRebootOptions.getOptSnoozeInterval());
        agentRebootOptions.setOptHardReboot(serverRebootOptions.getOptHardReboot());
        agentRebootOptions.setOptAutoReboot(serverRebootOptions.getOptAutoReboot());
        return agentRebootOptions;
    }

    public static void executeCommand(GroupArray groupArray, HardwareKeyArray hwKeyArray, Command cmd) throws ConsoleException {
        if (groupArray == null && hwKeyArray == null) {
            return;
        }
        DataobjectManager dataManager = DataobjectManager.getInstance();
        dataManager.addCommand(cmd);
        AgentCommand agentCommand = new AgentCommand();
        agentCommand.setAdminId(Manager.getCurrentAdminId());
        agentCommand.setCommandId(cmd.getId());
        agentCommand.setOptDescription(cmd.getOptDescription());
        agentCommand.setCommandName(cmd.getName());
        agentCommand.setOptGroupArray(groupArray);
        agentCommand.setOptHardwareKeyArray(hwKeyArray);
        if (cmd.getOptRebootOptions() != null) {
            com.sygate.scm.common.configobject.rpc.RebootOptions agentRebootOptions = GroupHandler.transferRebootOptions(cmd.getOptRebootOptions());
            agentCommand.setOptRebootOptions(agentRebootOptions);
        }
        String paramStr = "&ObjectType=Command";
        GUIManager.sendCommand("AgentCommand", (AbstractSchema)agentCommand, false, paramStr);
    }

    public static GroupObject getDefaultGroupObject() {
        block3: {
            try {
                DataobjectManager data = DataobjectManager.getInstance();
                SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", Manager.getCurrentDomainId(), false);
                SemClientGroupTree scgt = (SemClientGroupTree)data.getObjectByGUID("SemClientGroupTree", domain.getObjReference().getTargetId(), false);
                String defaultGrpId = scgt.getOptDefaultGroupId();
                for (SemClientGroup semClientGroup : scgt.getSemClientGroup().getSemClientGroup()) {
                    Integer type;
                    if (!(defaultGrpId != null ? defaultGrpId.equals(semClientGroup.getId()) : (type = semClientGroup.getOptType()) != null && type.intValue() == SemClientGroup.TEMPORARY.intValue())) continue;
                    return new GroupObject(semClientGroup);
                }
            }
            catch (ConsoleException ex) {
                ConsoleLogger.log(ex);
                if (!ex.needRelogin()) break block3;
                Manager.getFrame().showLoginPanel();
            }
        }
        return null;
    }

    public static synchronized String getGlobalGroupName() {
        if (bundledGroupNames == null) {
            GroupHandler.loadBundledGroupNamesObject();
        }
        return bundledGroupNames.getGlobalGroupName();
    }

    public static synchronized void resetGlobalGroupNames() {
        bundledGroupNames = null;
    }

    private static void loadBundledGroupNamesObject() {
        block4: {
            try {
                DataobjectManager data = DataobjectManager.getInstance();
                SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", Manager.getCurrentDomainId(), false);
                SemClientGroupTree scgt = (SemClientGroupTree)data.getObjectByGUID("SemClientGroupTree", domain.getObjReference().getTargetId(), false);
                bundledGroupNames = BundledGroupNamesObject.getInstance((SemClientGroupTree)scgt);
                if (bundledGroupNames.getDefaultGroupName() == null) {
                    ConsoleLogger.log("GroupHandler>> loadBundledGroupNamesObject: Default group is missing!");
                }
                if (bundledGroupNames.getTemporaryGroupNames() == null || bundledGroupNames.getTemporaryGroupNames().length == 0) {
                    ConsoleLogger.log("GroupHandler>> loadBundledGroupNamesObject: Temporary group is missing!");
                }
                ConsoleLogger.log("GroupHandler>> loadBundledGroupNamesObject: global group name=" + bundledGroupNames.getGlobalGroupName() + ",default group name=" + bundledGroupNames.getDefaultGroupName() + ", temporary group name=" + Arrays.toString(bundledGroupNames.getTemporaryGroupNames()));
            }
            catch (ConsoleException ex) {
                ConsoleLogger.log(ex);
                if (!ex.needRelogin()) break block4;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public static GroupObject getFirstFullAccessGroup() {
        DefaultMutableTreeNode node;
        block5: {
            node = null;
            try {
                node = GroupHandler.getGroupsRoot(false, true);
            }
            catch (ConsoleException ex) {
                ConsoleLogger.log(ex);
                if (!ex.needRelogin()) break block5;
                Manager.getFrame().showLoginPanel();
            }
        }
        if (node == null) {
            return null;
        }
        GroupObject obj = (GroupObject)node.getUserObject();
        if (obj.isAccessible()) {
            return obj;
        }
        if (node.getChildCount() > 0) {
            return GroupHandler.getFirstFullAccessChildGroup(node);
        }
        return null;
    }

    private static GroupObject getFirstFullAccessChildGroup(DefaultMutableTreeNode node) {
        GroupObject obj = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            obj = (GroupObject)child.getUserObject();
            if (obj.isAccessible()) {
                return obj;
            }
            if (child.getChildCount() <= 0 || (obj = GroupHandler.getFirstFullAccessChildGroup(child)) == null) continue;
            return obj;
        }
        return null;
    }
}

