/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.schema.EpmpCloudEnrollment;
import com.sygate.scm.common.configobject.schema.EpmpCloudEnrollmentId;
import com.sygate.scm.common.configobject.schema.EpmpCloudEnrollmentIdArray;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.LoggerUtilities;

public class EpmpCloudEnrollmentHandler {
    private static EpmpCloudEnrollmentHandler singleton = null;
    public static final String EPMP_CLOUD_ENROLLMENT_ID_ARRAY_GUID = "D5553837A7CF449F82E8EC4174209BD2";

    public static synchronized EpmpCloudEnrollmentHandler getInstance() {
        if (singleton == null) {
            singleton = new EpmpCloudEnrollmentHandler();
        }
        return singleton;
    }

    public static String getSaepLoginUrl(String accessToken, String domainId) {
        String epmpDomainId;
        String epmpCustomerId;
        String saepLoginUrl;
        block5: {
            saepLoginUrl = ScmProperties.getSaepLoginWithAccessTokenUrl();
            ConsoleLogger.log("getSaepLoginUrl>> saepLoginUrl: " + saepLoginUrl);
            epmpCustomerId = null;
            epmpDomainId = null;
            try {
                DataobjectManager dataMgr = DataobjectManager.getInstance();
                EpmpCloudEnrollmentIdArray enrollmentIds = (EpmpCloudEnrollmentIdArray)dataMgr.getObjectByGUID("EpmpCloudEnrollmentIdArray", EPMP_CLOUD_ENROLLMENT_ID_ARRAY_GUID);
                if (enrollmentIds == null) break block5;
                for (int i = 0; i < enrollmentIds.getEpmpCloudEnrollmentIdCount(); ++i) {
                    EpmpCloudEnrollmentId enrollmentIdObject = enrollmentIds.getEpmpCloudEnrollmentId(i);
                    String epmpEnrollmentId = enrollmentIdObject.getId();
                    EpmpCloudEnrollment enrollmentObj = (EpmpCloudEnrollment)dataMgr.getObjectByGUID("EpmpCloudEnrollment", epmpEnrollmentId, domainId, false, false);
                    if (enrollmentObj == null || enrollmentObj.getEpmpCustomerId() == null || !enrollmentIdObject.getSepmDomainId().equals(domainId.toString())) continue;
                    epmpCustomerId = enrollmentObj.getEpmpCustomerId();
                    epmpDomainId = enrollmentObj.getEpmpDomainId();
                    break;
                }
            }
            catch (Exception e1) {
                ConsoleLogger.logError("getSaepLoginUrl>> Exception: " + e1.getMessage());
                LoggerUtilities.logException((Throwable)e1);
            }
        }
        if (accessToken != null && epmpCustomerId != null && epmpDomainId != null) {
            saepLoginUrl = saepLoginUrl.replaceFirst("%", accessToken);
            saepLoginUrl = saepLoginUrl.replaceFirst("%", epmpCustomerId);
            saepLoginUrl = saepLoginUrl.replaceFirst("%", epmpDomainId);
        } else {
            ConsoleLogger.log("getSaepLoginUrl>> Domain id is not enrolled, not found valid epmpCustomerId and epmpDomainId for sepm domain id:" + domainId + " or accessToken is empty");
        }
        return saepLoginUrl;
    }
}

