/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.CompanyInformation;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.text.MessageFormat;
import javax.swing.JOptionPane;

public class CompanyInformationHandler
extends AbstractHandler {
    public static String getCompanyName() {
        String companyName = "";
        DataobjectManager data = DataobjectManager.getInstance();
        CompanyInformation companyInfo = null;
        try {
            SemConfigRoot semConfigRoot = data.getSemConfigRoot();
            companyInfo = semConfigRoot.getOptCompanyInformation();
            if (companyInfo == null) {
                return "";
            }
            companyName = companyInfo.getOptCompanyName();
        }
        catch (ConsoleException ex) {
            Object[] obj = new Object[]{ex.getMessage()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "CompanyInformationHandler.dataCannotBeRetrieved");
            String fm = MessageFormat.format(str, obj);
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "CompanyInformationHandler.errorTitle");
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, title, 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
            return "";
        }
        return companyName == null ? "" : companyName.trim();
    }

    public static CompanyInformation getCompanyInformation() {
        CompanyInformation companyInfo;
        block2: {
            DataobjectManager data = DataobjectManager.getInstance();
            companyInfo = null;
            try {
                SemConfigRoot semConfigRoot = data.getSemConfigRoot();
                companyInfo = semConfigRoot.getOptCompanyInformation();
            }
            catch (ConsoleException ex) {
                Object[] obj = new Object[]{ex.getMessage()};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "CompanyInformationHandler.dataCannotBeRetrieved");
                String fm = MessageFormat.format(str, obj);
                String title = MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "CompanyInformationHandler.errorTitle");
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, title, 0);
                if (!ex.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
        return companyInfo;
    }

    public static void updateCompanyInformation(CompanyInformation companyInfo) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        try {
            SemConfigRoot semConfigRoot = data.getSemConfigRoot();
            semConfigRoot.setOptCompanyInformation(companyInfo);
            data.updateObject("Merge", (TopLevelObject)semConfigRoot);
        }
        catch (ConsoleException ce) {
            throw ce;
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
    }
}

