/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.AmlLowBandwidth;
import com.sygate.scm.common.configobject.schema.CloudAppliedPolicyArray;
import com.sygate.scm.common.configobject.schema.ExternalCommunication;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemGroupPolicy;
import com.sygate.scm.console.handler.ClientGroupCloudAppliedPolicy;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.LoggerUtilities;

public class CloudPolicyHandler {
    private static CloudPolicyHandler singleton = null;

    public static synchronized CloudPolicyHandler getInstance() {
        if (singleton == null) {
            singleton = new CloudPolicyHandler();
        }
        return singleton;
    }

    public ClientGroupCloudAppliedPolicy getClientGroupCloudAppliedPolicy(SemClientGroup group, GUID domainId, boolean fromParentGroup) {
        if (group != null) {
            SemGroupPolicy semGroupPolicy = null;
            CloudAppliedPolicyArray cloudArray = null;
            DataobjectManager objectManager = DataobjectManager.getInstance();
            ObjReference objRef = group.getObjReference();
            if (objRef != null) {
                String targetId = objRef.getTargetId();
                try {
                    semGroupPolicy = objectManager.getSemGroupPolicy(targetId);
                    ConsoleLogger.log("CloudPolicyHandler > getClientGroupCloudAppliedPolicy >> Target Id for policy : " + targetId);
                    if (semGroupPolicy != null) {
                        AbstractSchema parent;
                        cloudArray = semGroupPolicy.getOptCloudAppliedPolicyArray();
                        if (cloudArray != null) {
                            ConsoleLogger.log("CloudPolicyHandler > getClientGroupCloudAppliedPolicy >> group id :" + group.getId());
                            return new ClientGroupCloudAppliedPolicy(group, cloudArray);
                        }
                        if (fromParentGroup && (parent = group.getParent()) != null && parent instanceof SemClientGroup) {
                            return this.getClientGroupCloudAppliedPolicy((SemClientGroup)parent, domainId);
                        }
                        return null;
                    }
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
        }
        return null;
    }

    public ClientGroupCloudAppliedPolicy getClientGroupCloudAppliedPolicy(SemClientGroup group, GUID domainId) {
        return this.getClientGroupCloudAppliedPolicy(group, domainId, true);
    }

    public ObjReference getPolicyFromCloudAppliedPolicyArray(SemClientGroup group, GUID domainId, String policyType, String subType, boolean fromParentGroup) {
        ObjReference policyRef = null;
        ClientGroupCloudAppliedPolicy grpAppliedPolicy = this.getClientGroupCloudAppliedPolicy(group, domainId, fromParentGroup);
        CloudAppliedPolicyArray cloudAppliedPolicyArray = grpAppliedPolicy != null ? grpAppliedPolicy.getCloudAppliedPolicyArray() : null;
        SemClientGroup semClientGroup = group = grpAppliedPolicy != null ? grpAppliedPolicy.getClientGroup() : null;
        if (cloudAppliedPolicyArray != null) {
            if (policyType.equals("MemPolicy")) {
                policyRef = cloudAppliedPolicyArray.getObjReferenceByTypeAndName("MemPolicy", "CloudMemPolicyApplied");
            } else if (policyType.equals("HidPolicy")) {
                policyRef = cloudAppliedPolicyArray.getObjReferenceByTypeAndName("HidPolicy", "CloudHidPolicyApplied");
            } else if (policyType.equals("TdadPolicy")) {
                policyRef = cloudAppliedPolicyArray.getObjReferenceByTypeAndName("TdadPolicy", "ExternalTdadPolicyApplied");
            } else if (policyType.equals("PolicyOverride")) {
                if (subType == null) {
                    ConsoleLogger.logError("getPolicyFromCloudAppliedPolicyArray >> Policy Sub Type is null");
                    return null;
                }
                if (subType.equals("WhiteList")) {
                    policyRef = cloudAppliedPolicyArray.getObjReferenceByTypeAndName("PolicyOverride", "CloudWhiteListPolicyOverrideApplied");
                } else if (subType.equals("BlackList")) {
                    policyRef = cloudAppliedPolicyArray.getObjReferenceByTypeAndName("PolicyOverride", "CloudBlackListPolicyOverrideApplied");
                } else {
                    ConsoleLogger.logError("getPolicyFromCloudAppliedPolicyArray >> Policy Sub Type is not matching with expected value: " + subType);
                    return null;
                }
            }
            if (policyRef != null) {
                ConsoleLogger.log("Policy " + policyType + " found in groupId " + (group != null ? group.getId() : null));
                return policyRef;
            }
            if (fromParentGroup) {
                AbstractSchema parent;
                AbstractSchema abstractSchema = parent = group != null ? group.getParent() : null;
                if (parent != null && parent instanceof SemClientGroup) {
                    return this.getPolicyFromCloudAppliedPolicyArray((SemClientGroup)parent, domainId, policyType, subType);
                }
            }
        }
        return policyRef;
    }

    public ObjReference getPolicyFromCloudAppliedPolicyArray(SemClientGroup group, GUID domainId, String policyType, String subType) {
        return this.getPolicyFromCloudAppliedPolicyArray(group, domainId, policyType, subType, true);
    }

    public boolean isCloudPolicy(SemClientGroup group, GUID domainId, String policyType, String subType, String policyId) {
        String cloudPolicyId;
        boolean isCloudPolicy = false;
        ObjReference cloudPolicy = this.getPolicyFromCloudAppliedPolicyArray(group, domainId, policyType, subType);
        if (cloudPolicy != null && policyId.equals(cloudPolicyId = cloudPolicy.getTargetId())) {
            isCloudPolicy = true;
        }
        return isCloudPolicy;
    }

    public AmlLowBandwidth getLowBandwidthFromCloudAppliedPolicyArray(SemClientGroup group, GUID domainId) {
        AmlLowBandwidth amlLowbandwidthObj = null;
        if (group != null) {
            ClientGroupCloudAppliedPolicy grpAppliedPolicy = this.getClientGroupCloudAppliedPolicy(group, domainId);
            CloudAppliedPolicyArray cloudAppliedPolicyArray = grpAppliedPolicy != null ? grpAppliedPolicy.getCloudAppliedPolicyArray() : null;
            SemClientGroup semClientGroup = group = grpAppliedPolicy != null ? grpAppliedPolicy.getClientGroup() : null;
            if (cloudAppliedPolicyArray != null) {
                AbstractSchema parent;
                ExternalCommunication extCommunication = cloudAppliedPolicyArray.getOptExternalCommunication();
                if (extCommunication != null) {
                    amlLowbandwidthObj = extCommunication.getOptAmlLowBandwidth();
                }
                if (amlLowbandwidthObj != null) {
                    ConsoleLogger.log("Low bandwidth settings found in groupId " + (group != null ? group.getId() : null));
                    return amlLowbandwidthObj;
                }
                AbstractSchema abstractSchema = parent = group != null ? group.getParent() : null;
                if (parent != null && parent instanceof SemClientGroup) {
                    return this.getLowBandwidthFromCloudAppliedPolicyArray((SemClientGroup)parent, domainId);
                }
            }
        }
        return amlLowbandwidthObj;
    }

    public Boolean isEnableLowBandwidth(SemClientGroup group, GUID domainId) {
        Boolean isLowBandwidthEnabled = null;
        AmlLowBandwidth lbObject = this.getLowBandwidthFromCloudAppliedPolicyArray(group, domainId);
        if (lbObject != null) {
            isLowBandwidthEnabled = lbObject.getOptEnableLowBandwidth();
        }
        ConsoleLogger.log("Low Bandwidth settings " + isLowBandwidthEnabled);
        return isLowBandwidthEnabled;
    }
}

