/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.handler;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AdminContext;
import com.sygate.scm.common.configobject.schema.AdministratorState;
import com.sygate.scm.common.configobject.schema.DisplayFilter;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PrivilegeValue;
import com.sygate.scm.common.configobject.schema.SemAdminPrivilege;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SemDomainArray;
import com.sygate.scm.common.configobject.schema.SemDomainState;
import com.sygate.scm.common.configobject.schema.SemSiteArray;
import com.sygate.scm.common.configobject.schema.SitePrivilege;
import com.sygate.scm.common.configobject.schema.SitePrivilegeSet;
import com.sygate.scm.common.configobject.schema.SysAdministratorArray;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.admin.AbstractAdminHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.AdminStateObject;
import com.sygate.scm.console.logicobject.DomainObject;
import com.sygate.scm.console.logicobject.DomainStateObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.KeepAlive;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.smartcardio.CardTerminal;

public class AdminHandler
extends AbstractHandler {
    private static final String HIDDEN_BRIDGE_ADMIN_PREFIX = "bridge_v1_";
    private static Comparator<AdminObject> adminComparator = null;
    private static Comparator<DomainObject> domainComparator = null;
    private static Collator myCollator = Collator.getInstance();
    public static final int DOMAIN_INFO_OK = 0;
    public static final int DOMAIN_ID_EMPTY = -1;
    public static final int DOMAIN_NAME_EMPTY = -2;
    public static final int DOMAIN_ID_IN_USE = -3;
    public static final int DOMAIN_NAME_IN_USE = -4;

    public static List<DomainObject> getDomainList() throws ConsoleException {
        ArrayList<DomainObject> domainList = new ArrayList<DomainObject>();
        DataobjectManager data = DataobjectManager.getInstance();
        SemConfigRoot semConfigRoot = data.getSemConfigRoot();
        SemDomainArray domainArray = semConfigRoot.getSemDomainArray();
        for (int i = 0; i < domainArray.getObjReferenceCount(); ++i) {
            SemDomain semDomain;
            ObjReference reference = domainArray.getObjReference(i);
            if (reference == null || (semDomain = (SemDomain)data.getObjectByGUID("SemDomain", reference.getTargetId())) == null) continue;
            DomainObject domain = new DomainObject(semDomain);
            domainList.add(domain);
        }
        Collections.sort(domainList, AdminHandler.getDomainObjectComparator());
        return domainList;
    }

    private static Comparator<DomainObject> getDomainObjectComparator() {
        if (domainComparator == null) {
            domainComparator = new Comparator<DomainObject>(){

                @Override
                public int compare(DomainObject o1, DomainObject o2) {
                    if (o1 == null) {
                        if (o2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return myCollator.compare(o1.getName(), o2.getName());
                }
            };
        }
        return domainComparator;
    }

    public static List<AdminObject> getAdminList() throws ConsoleException {
        ArrayList<AdminObject> adminList = new ArrayList<AdminObject>();
        SemAdministrator currentAdmin = DataobjectManager.getInstance().getCurrentAdministrator();
        AdminObject curAdminObj = new AdminObject(currentAdmin);
        if (curAdminObj.isSysAdmin()) {
            adminList.addAll(AdminHandler.getAllSystemAdmin());
            adminList.addAll(AdminHandler.getAllCurrentDomainAdmin());
        } else if (curAdminObj.isDomainSysAdmin()) {
            adminList.addAll(AdminHandler.getAllCurrentDomainAdmin());
        } else {
            adminList.add(curAdminObj);
        }
        Collections.sort(adminList, AdminHandler.getAdminObjectComparator());
        return adminList;
    }

    private static Comparator<AdminObject> getAdminObjectComparator() {
        if (adminComparator == null) {
            adminComparator = new Comparator<AdminObject>(){

                @Override
                public int compare(AdminObject o1, AdminObject o2) {
                    int type2;
                    if (o1 == null) {
                        if (o2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    int type1 = o1.isSysAdmin() ? 1 : (o1.isDomainSysAdmin() ? 2 : 3);
                    if (type1 == (type2 = o2.isSysAdmin() ? 1 : (o2.isDomainSysAdmin() ? 2 : 3))) {
                        return myCollator.compare(o1.getName(), o2.getName());
                    }
                    return type1 - type2;
                }
            };
        }
        return adminComparator;
    }

    private static List<AdminObject> getAllSystemAdmin() throws ConsoleException {
        ArrayList<AdminObject> adminList = new ArrayList<AdminObject>();
        DataobjectManager data = DataobjectManager.getInstance();
        SysAdministratorArray rootAdminArray = data.getSysAdministratorArray();
        for (int i = 0; i < rootAdminArray.getSemAdministratorCount(); ++i) {
            AdminObject admin = new AdminObject(rootAdminArray.getSemAdministrator(i));
            if (admin.getName().toLowerCase().startsWith(HIDDEN_BRIDGE_ADMIN_PREFIX.toLowerCase())) continue;
            adminList.add(admin);
        }
        return adminList;
    }

    private static List<AdminObject> getAllCurrentDomainAdmin() throws ConsoleException {
        ArrayList<AdminObject> adminList = new ArrayList<AdminObject>();
        DataobjectManager dataobjectManager = DataobjectManager.getInstance();
        List<AdminContext> allAdmins = dataobjectManager.getAdminContexts();
        if (allAdmins != null) {
            int count = allAdmins.size();
            for (int index = 0; index < count; ++index) {
                AdminContext admin = allAdmins.get(index);
                adminList.add(new AdminObject(admin));
            }
        }
        return adminList;
    }

    public static void addAdministrator(AdminObject adminObj, AdminPrivilegeObject adminPrivilege) throws ConsoleException {
        AbstractAdminHandler handler = AbstractAdminHandler.getInstance(adminObj);
        handler.addAdministrator(adminObj, adminPrivilege);
    }

    public static void updateAdministratorPassword(String adminContextID, String passwordHash) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        try {
            data.updateAdministratorPassword(adminContextID, passwordHash);
        }
        catch (ConsoleException ex) {
            if (!ex.needRelogin()) {
                AdminHandler.refreshCurrentAdmin();
            }
            throw ex;
        }
    }

    public static void delSysAdmin(String adminGUID) throws ConsoleException {
        try {
            MessageResources msgRes = MessageResources.getInstance();
            DataobjectManager data = DataobjectManager.getInstance();
            SysAdministratorArray adminArray = data.getSysAdministratorArray();
            for (int i = 0; i < adminArray.getSemAdministratorCount(); ++i) {
                SemAdministrator adm = adminArray.getSemAdministrator(i);
                String adminId = adm.getId();
                if (!adminGUID.equals(adminId)) continue;
                AdministratorState state = AdminStateObject.retrieveAdministratorState(adminGUID);
                adm.getParent().removeChild((AbstractSchema)adm);
                data.updateObject("Merge", (TopLevelObject)adminArray);
                String description = MessageFormat.format(msgRes.getString("com.sygate.scm.console.handler.handler", "AdminHandler.SysAdminDeleted"), adm.getName());
                ConsoleLogger.logAdminEvent(4105, description);
                if (state != null) {
                    data.deleteAdministratorState(state);
                } else {
                    ConsoleLogger.log("AdminHandler>> delSysAmdin: Warning-> no sate for sys admin " + adm.getName());
                }
                AdminHandler.deleteAccessToken(adminId);
                break;
            }
        }
        catch (ConsoleException ex) {
            if (!ex.needRelogin()) {
                AdminHandler.refreshConfigRoot();
            }
            throw ex;
        }
    }

    public static void deleteAccessToken(String adminId) throws ConsoleException {
        try {
            ConsoleLogger.log("AdminHandler>> deleteAccessToken: Begin ... admin id=" + adminId);
            DataobjectManager.getInstance().deleteAccessToken(adminId);
            ConsoleLogger.log("AdminHandler>> deleteAccessToken: Done!");
        }
        catch (ConsoleException ex) {
            System.out.println("AdminHandler>> deleteAccessToken: Error-> ConsoleException for deleting access token id=" + adminId);
            throw ex;
        }
    }

    public static void delAdmin(AdminObject admin) throws Throwable {
        ConsoleLogger.log("AdminHandler>> delAdmin: Begin ... domain admin id=" + admin.getId() + ", name=" + admin.getName());
        AdministratorState state = AdminStateObject.retrieveAdministratorState(admin.getId());
        MessageResources msgRes = MessageResources.getInstance();
        DataobjectManager data = DataobjectManager.getInstance();
        try {
            String adminName = admin.getName();
            ConsoleLogger.log("AdminHandler>> delAdmin: name=" + adminName);
            data.deleteAdminContext(admin.getAdminContext());
            if (admin.isDomainSysAdmin()) {
                String description = MessageFormat.format(msgRes.getString("com.sygate.scm.console.handler.handler", "AdminHandler.DomainAdminDeleted"), adminName);
                ConsoleLogger.logAdminEvent(4105, description);
            } else if (admin.isLimitedAdmin()) {
                String description = MessageFormat.format(msgRes.getString("com.sygate.scm.console.handler.handler", "AdminHandler.LimitedAdminDeleted"), adminName);
                ConsoleLogger.logAdminEvent(4105, description);
            }
            if (state != null) {
                ConsoleLogger.log("AdminHandler>> delAdmin: deleting AdministratorState for admin " + adminName);
                data.deleteAdministratorState(state);
            } else {
                System.out.println("AdminHandler>> delAmdin: Warning-> no sate for admin " + adminName);
            }
            ConsoleLogger.log("AdminHandler>> delAdmin: Done!");
        }
        catch (ConsoleException ex) {
            System.out.println("AdminHandler>> delAdmin: Error-> ConsoleException for deleting Domain administrator id=" + admin.getId() + ", name=" + admin.getName() + ", msg=" + ex.getMessage());
            if (!ex.needRelogin()) {
                AdminHandler.refreshCurrentAdmin();
            }
            throw ex;
        }
        catch (Throwable ex) {
            System.out.println("AdminHandler>> delAdmin: Error-> throwable for deleting Domain administrator id=" + admin.getId() + ", name=" + admin.getName() + ", msg=" + ex.getMessage());
            throw ex;
        }
    }

    public static SemAdministrator updateAdmin(AdminObject adminObj) throws ConsoleException {
        return AdminHandler.updateAdmin(adminObj, false);
    }

    public static SemAdministrator updateAdmin(AdminObject adminObj, boolean deleteAccessToken) throws ConsoleException {
        if (adminObj == null) {
            ConsoleLogger.log("AdminHandler>>updateAdmin adminObj==null.");
            return null;
        }
        try {
            AbstractAdminHandler handler = AbstractAdminHandler.getInstance(adminObj);
            handler.updateAdministrator(adminObj, deleteAccessToken);
            if (Manager.isCurrentAdmin(adminObj.getAdminId())) {
                AdminHandler.refreshCurrentAdmin();
            }
            return handler.retrieveAdmin(adminObj.getAdminId(), null);
        }
        catch (ConsoleException ex) {
            if (!ex.needRelogin()) {
                AdminHandler.refreshCurrentAdmin();
            }
            throw ex;
        }
    }

    public static void checkIfSysAdminIsInUse(String sysAdminName) throws ConsoleException {
        if (AbstractAdminHandler.getSystemAdminHandler().checkExistence(sysAdminName)) {
            throw new ConsoleException(-2097086464, 12);
        }
    }

    public static void checkIfAdminIsInUse(String adminName) throws ConsoleException {
        if (AbstractAdminHandler.getDomainAdminHandler().checkExistence(adminName)) {
            throw new ConsoleException(-2097086464, 12);
        }
    }

    public static boolean isDomainNameExisting(String domainName) {
        if (domainName == null || domainName.length() == 0) {
            return false;
        }
        try {
            DataobjectManager data = DataobjectManager.getInstance();
            SemConfigRoot semConfigRoot = data.getSemConfigRoot();
            SemDomainArray domainArray = semConfigRoot.getSemDomainArray();
            for (int i = 0; i < domainArray.getObjReferenceCount(); ++i) {
                ObjReference reference = domainArray.getObjReference(i);
                SemDomain semDomain = (SemDomain)data.getObjectByGUID("SemDomain", reference.getTargetId());
                if (!semDomain.getName().equals(domainName)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            ConsoleLogger.log("AdminHandler>> isDomainNameExisting: Exception...");
            LoggerUtilities.logException((Throwable)ex);
        }
        return false;
    }

    public static int validateDomainInfo(String domainId, String domainName) {
        if (StringUtilities.isEmpty((String)domainName)) {
            return -2;
        }
        try {
            DataobjectManager data = DataobjectManager.getInstance();
            SemConfigRoot semConfigRoot = data.getSemConfigRoot();
            SemDomainArray domainArray = semConfigRoot.getSemDomainArray();
            for (int i = 0; i < domainArray.getObjReferenceCount(); ++i) {
                ObjReference reference = domainArray.getObjReference(i);
                SemDomain semDomain = (SemDomain)data.getObjectByGUID("SemDomain", reference.getTargetId());
                if (!StringUtilities.isEmpty((String)domainId) && semDomain.getId().equals(domainId)) {
                    return -3;
                }
                if (!semDomain.getName().equals(domainName)) continue;
                return -4;
            }
        }
        catch (Exception ex) {
            ConsoleLogger.log("AdminHandler>> validateDomainInfo: Exception...");
            LoggerUtilities.logException((Throwable)ex);
        }
        return 0;
    }

    public static void checkIfDomaininIsInUse(String domainName) throws ConsoleException {
        if (AdminHandler.isDomainNameExisting(domainName)) {
            throw new ConsoleException(-2096889856, 112);
        }
    }

    public static void updateDomain(DomainObject domain) throws ConsoleException {
        AdminHandler.updateDomain(domain.getSemDomain());
    }

    public static void updateDomain(SemDomain semDomain) throws ConsoleException {
        try {
            DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)semDomain);
            try {
                if (DataobjectManager.getInstance().isCurrentDomain(semDomain)) {
                    Boolean isRememberPassword = semDomain.getOptRememberPassword() == null ? semDomain.getDefRememberPassword() : semDomain.getOptRememberPassword();
                    GUIManager.updatePasswordRecovryFile("rememberPassword", isRememberPassword.toString());
                    if (!Utility.getBooleanValue((Boolean)isRememberPassword, (Boolean)Boolean.FALSE)) {
                        GUIManager.updatePasswordRecovryFileAllowEmpty("password", "");
                    }
                }
            }
            catch (Exception e) {
                ConsoleLogger.log("Failed to update cache password config file");
            }
        }
        catch (ConsoleException ex) {
            if (!ex.needRelogin()) {
                AdminHandler.refreshDomain(semDomain.getId());
            }
            throw ex;
        }
    }

    public static DomainObject addDomain(String domainID, String domainName, String companyName, String contactList) throws ConsoleException {
        return AdminHandler.addDomain(domainID, domainName, companyName, contactList, true, 2592000, false, 604800, false);
    }

    public static DomainObject addDomain(String domainID, String domainName, String companyName, String contactList, boolean autoDeleteClient, int maxClientIdleDuration, boolean autoDeleteNPVDIClient, int maxNPVDIClientIdleDuration, boolean isCQEnabled) throws ConsoleException {
        AdminHandler.checkIfDomaininIsInUse(domainName);
        SemDomain semDomain = null;
        try {
            semDomain = GUIManager.createDomain(domainID, domainName, companyName, contactList, autoDeleteClient, maxClientIdleDuration, autoDeleteNPVDIClient, maxNPVDIClientIdleDuration, isCQEnabled);
            MessageResources msgRes = MessageResources.getInstance();
            String description = MessageFormat.format(msgRes.getString("com.sygate.scm.console.handler.handler", "AdminHandler.DomainAdded"), domainName);
            ConsoleLogger.logAdminEvent(4109, description);
            SemDomainState state = DomainStateObject.createDomainState(semDomain);
            DataobjectManager manager = DataobjectManager.getInstance();
            manager.addSemDomainState(state);
            manager.getObjectByGUID("SemConfigRoot", "B655E64D0A320801000000E164041B79", true);
        }
        catch (ConsoleException ex) {
            if (!ex.needRelogin()) {
                AdminHandler.refreshConfigRoot();
            }
            throw ex;
        }
        System.out.println("AdminHandler>> addDomain: OK-> name=" + semDomain.getName() + ", ID=" + semDomain.getId());
        return new DomainObject(semDomain);
    }

    public static void delDomain(DomainObject domainObj) throws ConsoleException {
        String domainId = domainObj.getId();
        boolean isCurrentDomain = AdminHandler.isCurrentDomain(domainObj);
        try {
            GUIManager.deleteDomain(domainId);
            if (!isCurrentDomain) {
                DataobjectManager.getInstance().getSemConfigRoot(true);
            }
        }
        catch (ConsoleException ex) {
            if (!ex.needRelogin()) {
                AdminHandler.refreshDomain(domainId);
            }
            throw ex;
        }
    }

    public static SemDomain retrieveDomain(String domainID) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        return data.getSemDomain(domainID);
    }

    public static void refreshCurrentAdmin() throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        SemAdministrator admin = data.getCurrentAdministrator();
        try {
            if (Manager.isSystemAdmin(admin)) {
                admin = AdminHandler.retrieveSysAdmin(admin.getId());
            } else {
                AdminContext adminContext = data.getAdminContext();
                if (adminContext != null) {
                    admin = adminContext.getSemAdministrator();
                }
            }
            data.setCurrentAdministrator(admin);
        }
        catch (ConsoleException ex) {
            data.setCurrentAdministrator(admin);
            throw ex;
        }
    }

    public static SemAdministrator retrieveSysAdmin(String adminId) throws ConsoleException {
        if (adminId == null) {
            return null;
        }
        SysAdministratorArray sysAdminArray = DataobjectManager.getInstance().getSysAdministratorArray(true);
        return AdminHandler.retrieveSysAdmin(sysAdminArray, adminId);
    }

    public static SemAdministrator retrieveSysAdmin(SysAdministratorArray sysAdminArray, String adminId) {
        if (adminId == null || sysAdminArray == null) {
            return null;
        }
        for (int i = 0; i < sysAdminArray.getSemAdministratorCount(); ++i) {
            SemAdministrator admin = sysAdminArray.getSemAdministrator(i);
            if (!adminId.equals(admin.getId())) continue;
            return admin;
        }
        return null;
    }

    public static void refreshDomain(String domainID) throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        data.getSemConfigRoot();
        data.getSemDomain(domainID);
        if (Manager.isLoginAsSysAdmin()) {
            AdminHandler.refreshCurrentAdmin();
        } else if (Manager.isCurrentDomain(domainID)) {
            AdminHandler.refreshCurrentAdmin();
        }
    }

    public static void refreshConfigRoot() throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        data.getSemConfigRoot();
        if (Manager.isLoginAsSysAdmin()) {
            AdminHandler.refreshCurrentAdmin();
        }
    }

    public static void switchToDomain(String domainId) throws ConsoleException {
        block2: {
            try {
                boolean isIsSmartCardAuth = KeepAlive.isSmartCardAuth();
                CardTerminal cardTerminal = KeepAlive.getCardTerminal();
                GUIManager.stopAllBackgroupThreads();
                PolicyHandler.clearCopiedObject();
                PolicyHandler.resetStaticVariables();
                Manager.getFrame().closeOwnedWindows();
                Manager.switchDomain(domainId, isIsSmartCardAuth, cardTerminal);
            }
            catch (Exception ex) {
                ConsoleLogger.log("AdminHandler>> switchToDomain: Exception...");
                LoggerUtilities.logException((Throwable)ex);
                if (!(ex instanceof ConsoleException)) break block2;
                throw (ConsoleException)ex;
            }
        }
    }

    public static void setAdminLastPasswordChangeTime(SemAdministrator admin) throws ConsoleException {
        if (admin == null) {
            ConsoleLogger.log("AdminHandler>> setAdminLastPasswordChangeTime: Error-> admin is invalid! ");
            return;
        }
        AdminHandler.setAdminLastPasswordChangeTime(new AdminObject(admin));
    }

    public static void setAdminLastPasswordChangeTime(AdminObject admin) throws ConsoleException {
        if (admin == null) {
            ConsoleLogger.log("AdminHandler>> setAdminLastPasswordChangeTime: Error-> admin is invalid! ");
            return;
        }
        AdminStateObject state = admin.retrieveState();
        if (!state.isValid()) {
            ConsoleLogger.log("AdminHandler>> setAdminLastPasswordChangeTime: Error-> failed to retrieve state!  admin=" + admin.getName() + ", id=" + admin.getId());
            return;
        }
        state.setLastPasswordChangeTime();
        state.setLocked(false);
        state.setRandomPasswordStatus(AdministratorState.INACTIVE);
        state.setPasswordStatus(AdministratorState.ACTIVE);
        AdminHandler.updateAdminState(state, 4093);
    }

    public static void setAdminAcknowledgeLatestNewsStatus(AdminObject admin, Integer acknowledgeState) throws ConsoleException {
        if (admin == null) {
            ConsoleLogger.log("AdminHandler>> setAdminAcknowledgeLatestNewsStatus: Error-> admin is invalid! ");
            return;
        }
        AdminStateObject state = admin.retrieveState();
        if (!state.isValid()) {
            ConsoleLogger.log("AdminHandler>> setAdminAcknowledgeLatestNewsStatus: Error-> failed to retrieve state!  admin=" + admin.getName() + ", id=" + admin.getId());
            return;
        }
        if (acknowledgeState == null) {
            ConsoleLogger.log("AdminHandler>> setAdminAcknowledgeLatestNewsStatus: Error-> Latest Sep News Status is null");
            throw new ConsoleException("Error-> Latest Sep News Status is null for admin =" + admin.getName() + ", id=" + admin.getId());
        }
        if (acknowledgeState.equals(AdministratorState.READ)) {
            state.setNotifyLatestSepNews(acknowledgeState);
            AdminHandler.updateAdminState(state, 4094);
        } else if (acknowledgeState.equals(AdministratorState.DISMISSED)) {
            state.setNotifyLatestSepNews(acknowledgeState);
            AdminHandler.updateAdminState(state, 4095);
        } else {
            ConsoleLogger.log("AdminHandler>> setAdminAcknowledgeLatestNewsStatus: Error-> Invalid Latest Sep News Status!  admin=" + admin.getName() + ", id=" + admin.getId() + ", state=" + acknowledgeState);
            throw new ConsoleException("Error-> Invalid Latest Sep News Status!  admin=" + admin.getName() + ", id=" + admin.getId() + ", state=" + acknowledgeState);
        }
    }

    public static boolean isAdminLocked(AdminObject admin) {
        boolean locked = false;
        AdminStateObject state = null;
        if (admin != null) {
            try {
                state = admin.retrieveState();
                if (state.isValid()) {
                    locked = state.isLocked();
                }
            }
            catch (Exception e) {
                ConsoleLogger.log("AdminHandler>> isAdminLocked: Error-> failed to retrieve state!  admin=" + admin.getName() + ", id=" + admin.getId());
            }
        }
        return locked;
    }

    public static void setAdminLocked(AdminObject admin, boolean locked) throws ConsoleException {
        if (admin == null) {
            ConsoleLogger.log("AdminHandler>> setAdminLocked: Error-> admin is invalid! ");
            return;
        }
        AdminStateObject state = admin.retrieveState();
        if (!state.isValid()) {
            ConsoleLogger.log("AdminHandler>> setAdminLocked: Error-> failed to retrieve state!  admin=" + admin.getName() + ", id=" + admin.getId());
            return;
        }
        state.setLocked(locked);
        int options = 0;
        if (locked) {
            state.setLockTime();
            options = 4092;
        } else {
            state.resetLockTime(true);
            options = 4080;
        }
        AdminHandler.updateAdminState(state, options);
        MessageResources msgRes = MessageResources.getInstance();
        String description = "";
        description = admin.isSysAdmin() ? (locked ? MessageFormat.format(msgRes.getString("com.sygate.scm.console.handler.handler", "AdminHandler.SysAdminLocked"), admin.getName()) : MessageFormat.format(msgRes.getString("com.sygate.scm.console.handler.handler", "AdminHandler.SysAdminUnlocked"), admin.getName())) : (locked ? MessageFormat.format(msgRes.getString("com.sygate.scm.console.handler.handler", "AdminHandler.DomainAdminLocked"), admin.getName()) : MessageFormat.format(msgRes.getString("com.sygate.scm.console.handler.handler", "AdminHandler.DomainAdminUnlocked"), admin.getName()));
        ConsoleLogger.logAdminEvent(locked ? 4100 : 4101, description);
    }

    public static boolean isCurrentDomain(DomainObject domain) {
        boolean isCurrentDomain = false;
        String currentDomainId = Manager.getCurrentDomainId();
        if (domain != null && domain.getId().equals(currentDomainId)) {
            isCurrentDomain = true;
        }
        return isCurrentDomain;
    }

    public static void updateAdminState(AdminStateObject state, int options) throws ConsoleException {
        if (state == null || !state.isValid()) {
            System.out.println("updateAdminState>> setAdminLastPasswordChangeTime: Error-> state is invalid!");
            return;
        }
        try {
            DataobjectManager.getInstance().updateAdministratorState(state.getAdministratorState(), options);
        }
        catch (ConsoleException ex) {
            System.out.println("updateAdminState>> setAdminLastPasswordChangeTime: Exception... state id=" + state.getId() + ", owner id=" + state.getOwnerId());
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
    }

    public static int getDomainCount() {
        try {
            DataobjectManager data = DataobjectManager.getInstance();
            SemConfigRoot semConfigRoot = data.getSemConfigRoot();
            SemDomainArray domainArray = semConfigRoot.getSemDomainArray();
            return domainArray.getObjReferenceCount();
        }
        catch (Exception ex) {
            ConsoleLogger.log("AdminHandler>> getDomainCount: Exception...");
            LoggerUtilities.logException((Throwable)ex);
            return 0;
        }
    }

    public static int getEnabledDomainCount() {
        int count = 0;
        try {
            DataobjectManager data = DataobjectManager.getInstance();
            SemConfigRoot semConfigRoot = data.getSemConfigRoot();
            SemDomainArray domainArray = semConfigRoot.getSemDomainArray();
            for (int i = 0; i < domainArray.getObjReferenceCount(); ++i) {
                SemDomain semDomain;
                ObjReference reference = domainArray.getObjReference(i);
                if (reference == null || (semDomain = (SemDomain)data.getObjectByGUID("SemDomain", reference.getTargetId())) == null || semDomain.getOptEnable() != null && !semDomain.getOptEnable().booleanValue()) continue;
                ++count;
            }
        }
        catch (Exception ex) {
            ConsoleLogger.log("AdminHandler>> getDomainCount: Exception...");
            LoggerUtilities.logException((Throwable)ex);
        }
        return count;
    }

    public static int getAdministratorCount(String domainId) throws ConsoleException {
        SemAdministrator currentAdmin = DataobjectManager.getInstance().getCurrentAdministrator();
        AdminObject curAdminObj = new AdminObject(currentAdmin);
        int totalCount = 0;
        if (curAdminObj.isSysAdmin()) {
            DataobjectManager data = DataobjectManager.getInstance();
            SysAdministratorArray rootAdminArray = data.getSysAdministratorArray();
            int count = rootAdminArray.getSemAdministratorCount();
            boolean bridgeAdminPresent = false;
            Vector admins = rootAdminArray.getSemAdministrator();
            for (int i = 0; i < count; ++i) {
                SemAdministrator sa = (SemAdministrator)admins.get(i);
                if (!sa.getName().toLowerCase().startsWith(HIDDEN_BRIDGE_ADMIN_PREFIX.toLowerCase())) continue;
                bridgeAdminPresent = true;
                break;
            }
            totalCount = count + data.getAdministratorCount(domainId);
            if (bridgeAdminPresent) {
                --totalCount;
            }
        }
        return totalCount;
    }

    public static SemAdministrator retrieveAdmin(String adminId) throws ConsoleException {
        List<AdminContext> adminContexts;
        if (adminId == null) {
            return null;
        }
        SemAdministrator currentAdmin = DataobjectManager.getInstance().getCurrentAdministrator();
        AdminObject curAdminObj = new AdminObject(currentAdmin);
        if (curAdminObj.isSysAdmin()) {
            DataobjectManager data = DataobjectManager.getInstance();
            SysAdministratorArray rootAdminArray = data.getSysAdministratorArray();
            for (int i = 0; i < rootAdminArray.getSemAdministratorCount(); ++i) {
                SemAdministrator admin = rootAdminArray.getSemAdministrator(i);
                if (admin == null || !adminId.equals(admin.getId())) continue;
                return admin;
            }
        }
        if ((adminContexts = DataobjectManager.getInstance().getAdminContexts()) != null) {
            int count = adminContexts.size();
            for (int index = 0; index < count; ++index) {
                AdminContext adminContext = adminContexts.get(index);
                SemAdministrator admin = adminContext.getSemAdministrator();
                if (!adminId.equals(admin.getId())) continue;
                return admin;
            }
        }
        return null;
    }

    public static SemDomain retrieveCurrentDomain(boolean locally) throws ConsoleException {
        String domainId = Manager.getCurrentDomainId();
        return (SemDomain)DataobjectManager.getInstance().getObjectByGUID("SemDomain", domainId, !locally);
    }

    public static void validateAdminName(String name) throws ConsoleException {
        if (name == null) {
            throw new ConsoleException(-2063532032, 74, new String[]{Integer.toString(1), Integer.toString(64)});
        }
        int lenAdminName = name.length();
        if (lenAdminName < 1 || lenAdminName > 64) {
            throw new ConsoleException(-2063532032, 74, new String[]{Integer.toString(1), Integer.toString(64)});
        }
        StringTokenizer tk = new StringTokenizer(name, "/\\\\[]:;|=,+*?<>");
        if (tk.countTokens() != 1) {
            throw new ConsoleException(-2063466496, 75, new String[]{"/\\\\[]:;|=,+*?<>"});
        }
        if (tk.nextToken().length() != lenAdminName) {
            throw new ConsoleException(-2063466496, 75, new String[]{"/\\\\[]:;|=,+*?<>"});
        }
        boolean isAllDots = true;
        for (int i = 0; i < lenAdminName; ++i) {
            if (name.charAt(i) == '.') continue;
            isAllDots = false;
            break;
        }
        if (isAllDots) {
            throw new ConsoleException(-2063400884);
        }
        boolean isAllSpaces = true;
        for (int i = 0; i < lenAdminName; ++i) {
            if (name.charAt(i) == ' ') continue;
            isAllSpaces = false;
            break;
        }
        if (isAllSpaces) {
            throw new ConsoleException(-2063400884);
        }
    }

    public static DomainObject getDomainObjByName(String domainName, boolean refresh) throws ConsoleException {
        if (domainName == null || domainName.length() < 1) {
            return null;
        }
        DataobjectManager data = DataobjectManager.getInstance();
        SemConfigRoot semConfigRoot = data.getSemConfigRoot(refresh);
        SemDomainArray domainArray = semConfigRoot.getSemDomainArray();
        for (int i = 0; i < domainArray.getObjReferenceCount(); ++i) {
            ObjReference reference = domainArray.getObjReference(i);
            String id = reference.getTargetId();
            try {
                SemDomain semDomain = (SemDomain)data.getObjectByGUID("SemDomain", id);
                if (semDomain == null || !semDomain.getName().equals(domainName)) continue;
                return new DomainObject(semDomain);
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
                System.out.println("AdminHandler>> getDomainObjByName: Exception while getting domain by id=" + id + ", keep going!");
            }
        }
        return null;
    }

    public static DomainObject getDomainObjByName(String domainName) throws ConsoleException {
        return AdminHandler.getDomainObjByName(domainName, false);
    }

    public static int getIndexOfAdmin(String curId, List<?> adminList) {
        ArrayList<String> idList = new ArrayList<String>();
        for (AdminObject aObj : adminList) {
            idList.add(aObj.getId());
        }
        return idList.indexOf(curId);
    }

    public static int getIndexOfDomain(String curId, List<?> domainList) {
        ArrayList<String> idList = new ArrayList<String>();
        for (DomainObject aObj : domainList) {
            idList.add(aObj.getId());
        }
        return idList.indexOf(curId);
    }

    public static AdminObject getCopyOfAdminObject(AdminObject oldObj) throws ConsoleException {
        if (oldObj.isSysAdmin()) {
            SemAdministrator admin = (SemAdministrator)PolicyHandler.getCopyOfObj((ConfigObject)oldObj.getSemAdmin());
            return new AdminObject(admin);
        }
        AdminContext adminContext = (AdminContext)PolicyHandler.getCopyOfObj((ConfigObject)oldObj.getAdminContext());
        return new AdminObject(adminContext);
    }

    public static void updateAdminObject(AdminObject oldObj, AdminObject newObj) {
        oldObj.setSemAdmin(newObj.getSemAdmin());
        if (!oldObj.isSysAdmin()) {
            oldObj.setAdminPrivilege(newObj.getAdminPrivilege().getSemAdminPrivilege());
        }
    }

    public static List<String> preparePrivilegeFromAdmin(AdminObject admin, boolean sync) {
        ArrayList<String> siteIDs;
        block10: {
            siteIDs = new ArrayList<String>();
            if (admin == null) {
                return siteIDs;
            }
            DataobjectManager manager = DataobjectManager.getInstance();
            try {
                if (admin.isSysAdmin()) {
                    SemConfigRoot configRoot = manager.getSemConfigRoot();
                    SemSiteArray siteArray = configRoot.getSemSiteArray();
                    int size = siteArray.getObjReferenceCount();
                    if (size < 1) {
                        return siteIDs;
                    }
                    for (int i = 0; i < size; ++i) {
                        ObjReference objReference = siteArray.getObjReference(i);
                        String siteId = objReference.getTargetId();
                        if (sync) {
                            SiteObject siteObject = new SiteObject(manager.getSemSite(siteId));
                            if (siteObject.isSuspended()) continue;
                            siteIDs.add(siteId);
                            continue;
                        }
                        siteIDs.add(siteId);
                    }
                } else {
                    SitePrivilegeSet sitePrivilegeSet = admin.getAdminPrivilege().getSemAdminPrivilege().getOptSitePrivilegeSet();
                    if (sitePrivilegeSet != null) {
                        for (SitePrivilege site : sitePrivilegeSet.getSitePrivilege()) {
                            PrivilegeValue privilege;
                            SiteObject siteObject;
                            String siteId = site.getRefSiteId();
                            if (sync && (siteObject = new SiteObject(manager.getSemSite(siteId))).isSuspended() || (privilege = site.getOptPrivilegeValue()) == null || privilege.getOptPrivilege() == 1) continue;
                            siteIDs.add(site.getRefSiteId());
                        }
                    }
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                if (!ex.needRelogin()) break block10;
                Manager.getFrame().showLoginPanel();
            }
        }
        return siteIDs;
    }

    public static HashMap<String, SitePrivilege> preparePrivilegeFromAuthorizedAdmin(AdminObject adminObj, HashMap<String, SitePrivilege> authorizedPrivilegeMap) {
        if (authorizedPrivilegeMap == null) {
            authorizedPrivilegeMap = new HashMap();
        } else {
            authorizedPrivilegeMap.clear();
        }
        if (adminObj == null) {
            return authorizedPrivilegeMap;
        }
        SemAdminPrivilege adminPrivilege = adminObj.getAdminPrivilege().getSemAdminPrivilege();
        if (adminPrivilege == null) {
            return authorizedPrivilegeMap;
        }
        SitePrivilegeSet sitePrivilegeSet = adminPrivilege.getOptSitePrivilegeSet();
        if (sitePrivilegeSet == null) {
            return authorizedPrivilegeMap;
        }
        for (SitePrivilege privilege : sitePrivilegeSet.getSitePrivilege()) {
            authorizedPrivilegeMap.put(privilege.getRefSiteId(), privilege);
        }
        return authorizedPrivilegeMap;
    }

    public static SitePrivilegeSet promotePrivilegeSetForAuthorizedAdmin(AdminObject adminObj) {
        AdminPrivilegeObject privilegeObject = adminObj.getAdminPrivilege();
        SemAdminPrivilege adminPrivilege = privilegeObject.getSemAdminPrivilege();
        if (adminPrivilege == null) {
            return null;
        }
        SitePrivilegeSet sitePrivilegeSet = adminPrivilege.getOptSitePrivilegeSet();
        if (sitePrivilegeSet == null) {
            return null;
        }
        for (SitePrivilege site : sitePrivilegeSet.getSitePrivilege()) {
            PrivilegeValue privilege = site.getOptPrivilegeValue();
            if (privilege == null || privilege.getOptPrivilege() == null || privilege.getOptPrivilege() == 1) continue;
            privilege.setOptPrivilege(Integer.valueOf(0));
        }
        return sitePrivilegeSet;
    }

    public static boolean isDemoteOrPromoteAllowed(AdminObject currentAdmin, AdminObject adminObj, boolean sync) {
        boolean value = true;
        if (currentAdmin.isSysAdmin()) {
            return value;
        }
        if (!currentAdmin.isSysAdmin() && !currentAdmin.isDomainSysAdmin()) {
            return false;
        }
        List<String> siteIDs = AdminHandler.preparePrivilegeFromAdmin(currentAdmin, sync);
        HashMap<String, SitePrivilege> authorizedPrivilegeMap = new HashMap<String, SitePrivilege>();
        AdminHandler.preparePrivilegeFromAuthorizedAdmin(adminObj, authorizedPrivilegeMap);
        for (Map.Entry<String, SitePrivilege> entry : authorizedPrivilegeMap.entrySet()) {
            Integer privilege;
            PrivilegeValue privilegeValue;
            SitePrivilege sitePrivilege = entry.getValue();
            if (sitePrivilege == null || (privilegeValue = sitePrivilege.getOptPrivilegeValue()) == null || (privilege = privilegeValue.getOptPrivilege()) == null || privilege == 1 || siteIDs.contains(entry.getKey())) continue;
            value = false;
            break;
        }
        return value;
    }

    public static SitePrivilegeSet getDisplaySitePrivilegeSet(AdminObject currentAdmin, AdminObject authorizedAdmin, HashMap<String, SitePrivilege> authorizedPrivilegeMap, SitePrivilegeSet displayPrivilegeSet, boolean sync) {
        List<String> siteIDs = AdminHandler.preparePrivilegeFromAdmin(currentAdmin, sync);
        if (displayPrivilegeSet != null) {
            if (sync) {
                Iterator iterator = displayPrivilegeSet.getSitePrivilege().iterator();
                while (iterator.hasNext()) {
                    SitePrivilege sitePrivilege = (SitePrivilege)iterator.next();
                    if (siteIDs.contains(sitePrivilege.getRefSiteId())) continue;
                    displayPrivilegeSet.removeSitePrivilege(sitePrivilege);
                    iterator = displayPrivilegeSet.getSitePrivilege().iterator();
                }
            }
            return displayPrivilegeSet;
        }
        displayPrivilegeSet = new SitePrivilegeSet();
        AdminHandler.preparePrivilegeFromAuthorizedAdmin(authorizedAdmin, authorizedPrivilegeMap);
        int size = siteIDs.size();
        if (size < 1) {
            return displayPrivilegeSet;
        }
        for (int i = 0; i < size; ++i) {
            String siteId = siteIDs.get(i);
            SitePrivilege sitePrivilege = authorizedPrivilegeMap.get(siteId);
            if (sitePrivilege == null) {
                sitePrivilege = AdminHandler.makeDefaultPrivilegeForASite(siteId);
            }
            displayPrivilegeSet.addSitePrivilege(sitePrivilege);
        }
        return displayPrivilegeSet;
    }

    public static SitePrivilege makeDefaultPrivilegeForASite(String siteId) {
        SitePrivilege sitePrivilege = new SitePrivilege();
        PrivilegeValue value = new PrivilegeValue();
        value.setOptPrivilege(Integer.valueOf(1));
        sitePrivilege.setOptPrivilegeValue(value);
        sitePrivilege.setRefSiteId(siteId);
        return sitePrivilege;
    }

    public static void mergeAdminPrivilege(AdminObject adminObj, SitePrivilegeSet newPrivilegeSet) {
        SitePrivilegeSet oldPriviegeSet;
        if (adminObj == null || newPrivilegeSet == null) {
            return;
        }
        if (adminObj.isSysAdmin()) {
            return;
        }
        AdminPrivilegeObject privObject = adminObj.getAdminPrivilege();
        if (privObject == null || privObject.getSemAdminPrivilege() == null) {
            privObject = adminObj.isDomainSysAdmin() ? AdminPrivilegeObject.newInstanceForDomainAdmin() : AdminPrivilegeObject.newInstanceForLimitedAdmin();
            adminObj.setAdminPrivilege(privObject.getSemAdminPrivilege());
        }
        if ((oldPriviegeSet = privObject.getSitePrivilegeSet()) == null) {
            privObject.getSemAdminPrivilege().setOptSitePrivilegeSet(newPrivilegeSet);
        } else {
            int newSize = newPrivilegeSet.getSitePrivilegeCount();
            for (int i = 0; i < newSize; ++i) {
                boolean exist = false;
                SitePrivilege newPrivilege = newPrivilegeSet.getSitePrivilege(i);
                int oldSize = oldPriviegeSet.getSitePrivilegeCount();
                for (int j = 0; j < oldSize; ++j) {
                    SitePrivilege oldPrivilege = oldPriviegeSet.getSitePrivilege(j);
                    if (!newPrivilege.getRefSiteId().equals(oldPrivilege.getRefSiteId())) continue;
                    oldPriviegeSet.setSitePrivilege(j, newPrivilege);
                    exist = true;
                    break;
                }
                if (exist) continue;
                oldPriviegeSet.addSitePrivilege(newPrivilege);
            }
        }
    }

    public static boolean isValidPassword(String adminName, String password) {
        try {
            String domainName = "";
            SemDomain domain = DataobjectManager.getInstance().getCurrentSemDomain();
            if (domain != null) {
                domainName = domain.getName();
            }
            return GUIManager.validatePassword(adminName, password, domainName);
        }
        catch (ConsoleException ce) {
            return false;
        }
    }

    public static boolean isValidPasswordForCurrentAdmin(String password) {
        return AdminHandler.isValidPassword(DataobjectManager.getInstance().getCurrentAdministrator().getName(), password);
    }

    public static void logEventForAdminRenaming(AdminObject admin, String oldAdminName) {
        Object[] obj = new Object[]{AdminHandler.getAdminTypeDescription(admin), oldAdminName, admin.getName()};
        String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel._admin_wasRenamedTo_");
        ConsoleLogger.logAdminEvent(4106, MessageFormat.format(msg, obj));
    }

    public static void logEventForAdminChangingPwd(AdminObject admin) {
        Object[] obj = new Object[]{AdminHandler.getAdminTypeDescription(admin), admin.getName()};
        String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.thePassword_admin_wasChanged");
        ConsoleLogger.logAdminEvent(4107, MessageFormat.format(msg, obj));
    }

    public static void logEventForAdminChangingProperties(AdminObject admin) {
        Object[] obj = new Object[]{AdminHandler.getAdminTypeDescription(admin), admin.getName()};
        String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.thePropertiesOfAdmin_wasChanged");
        ConsoleLogger.logAdminEvent(4108, MessageFormat.format(msg, obj));
    }

    private static String getAdminTypeDescription(AdminObject admin) {
        MessageResources msgRes = MessageResources.getInstance();
        if (admin.isSysAdmin()) {
            return msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.system");
        }
        if (admin.isDomainSysAdmin()) {
            return msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.domain");
        }
        return msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.limited");
    }

    public static void updateCurrentSemAdminFilter(boolean platformFilterAll, boolean platformFilterWin, boolean platformFilterMac, boolean platformFilterLinux, int modeFilter, Boolean unknownOSFilter, Boolean isOnline, int displayMax, Boolean oDCHosted, Boolean offlineNPVDIClient) throws ConsoleException {
        AdminObject adminObj = AdminObject.retrieveCurrentAdminObject();
        SemAdministrator currentAdmin = adminObj.getSemAdmin();
        DisplayFilter df = currentAdmin.getOptDisplayFilter();
        if (df == null) {
            df = new DisplayFilter();
            currentAdmin.setOptDisplayFilter(df);
        }
        int showPlatform = 0;
        if (platformFilterAll) {
            showPlatform = 2;
        }
        df.setOptShowPlatform(Integer.valueOf(showPlatform));
        df.setOptShowPlatformWin(Boolean.valueOf(platformFilterWin));
        df.setOptShowPlatformMac(Boolean.valueOf(platformFilterMac));
        df.setOptShowPlatformLinux(Boolean.valueOf(platformFilterLinux));
        df.setOptMode(Integer.valueOf(modeFilter));
        df.setOptNewClient(unknownOSFilter);
        df.setOptShowOnlineStatus(isOnline);
        df.setOptPageSize(Integer.valueOf(displayMax));
        df.setOptODCHosted(oDCHosted);
        df.setOptExcludeOfflineNPVDIClients(offlineNPVDIClient);
        AdminHandler.updateAdmin(adminObj);
    }

    public static DisplayFilter getCurrentSemAdminFilter() {
        DisplayFilter filter = null;
        SemAdministrator currentAdmin = null;
        try {
            AdminHandler.refreshCurrentAdmin();
            currentAdmin = DataobjectManager.getInstance().getCurrentAdministrator();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            System.out.println("AdminHandler>> getCurrentSemAdminFilter: Exception while getting current SemAdministrator's Filter; admin id= " + DataobjectManager.getInstance().getCurrentAdministrator().getId());
        }
        if (currentAdmin != null) {
            filter = currentAdmin.getOptDisplayFilter();
        }
        return filter;
    }

    public static int getCurrentSemAdminFilterShowPlatform(DisplayFilter df) {
        int value = 2;
        if (df != null && df.getOptShowPlatform() != null) {
            value = df.getOptShowPlatform();
        }
        return value;
    }

    public static boolean getCurrentSemAdminFilterShowPlatformWin() {
        boolean value = false;
        DisplayFilter df = AdminHandler.getCurrentSemAdminFilter();
        if (df != null) {
            int platformType = AdminHandler.getCurrentSemAdminFilterShowPlatform(df);
            if (df.getOptShowPlatformWin() != null) {
                value = df.getOptShowPlatformWin();
            } else if (platformType == 1 || platformType == 2) {
                value = true;
            }
        }
        return value;
    }

    public static boolean getCurrentSemAdminFilterShowPlatformMac() {
        boolean value = false;
        DisplayFilter df = AdminHandler.getCurrentSemAdminFilter();
        if (df != null) {
            int platformType = AdminHandler.getCurrentSemAdminFilterShowPlatform(df);
            if (df.getOptShowPlatformMac() != null) {
                value = df.getOptShowPlatformMac();
            } else if (platformType == 0 || platformType == 2) {
                value = true;
            }
        }
        return value;
    }

    public static boolean getCurrentSemAdminFilterShowPlatformLinux() {
        boolean value = false;
        DisplayFilter df = AdminHandler.getCurrentSemAdminFilter();
        if (df != null) {
            int platformType = AdminHandler.getCurrentSemAdminFilterShowPlatform(df);
            if (df.getOptShowPlatformLinux() != null) {
                value = df.getOptShowPlatformLinux();
            } else if (platformType == 2) {
                value = true;
            }
        }
        return value;
    }

    public static int getCurrentSemAdminFilterMode(DisplayFilter df) {
        int value = 2;
        if (df != null && df.getOptMode() != null) {
            value = df.getOptMode();
        }
        return value;
    }

    public static int getCurrentSemAdminFilterPageSize(DisplayFilter df) {
        int value = 30;
        if (df != null && df.getOptPageSize() != null && (value = df.getOptPageSize().intValue()) > 1000) {
            value = 1000;
        }
        return value;
    }

    public static boolean getCurrentSemAdminFilterNewClient(DisplayFilter df) {
        boolean value = true;
        if (df != null && df.getOptNewClient() != null) {
            value = df.getOptNewClient();
        }
        return value;
    }

    public static boolean getCurrentSemAdminFilterODCHosted(DisplayFilter df) {
        boolean value = true;
        if (df != null && df.getOptODCHosted() != null) {
            value = df.getOptODCHosted() == false ? df.getDefODCHosted().booleanValue() : df.getOptODCHosted().booleanValue();
        }
        return value;
    }

    public static boolean getCurrentSemAdminFilterOnlineStatus(DisplayFilter df) {
        boolean value = true;
        if (df != null && df.getOptShowOnlineStatus() != null) {
            value = df.getOptShowOnlineStatus();
        }
        return value;
    }

    public static boolean getCurrentSemAdminFilterOfflineStatusForNPVDIClients(DisplayFilter df) {
        if (!LicenseObject.getInstance().isSBProduct()) {
            boolean value = true;
            if (df != null && df.getOptExcludeOfflineNPVDIClients() != null) {
                value = df.getOptExcludeOfflineNPVDIClients();
            }
            return value;
        }
        return false;
    }

    public static boolean isNeverExpiringPwdAllowedForCurrentDomain() {
        boolean allowNeverExpiringPassword = false;
        try {
            SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
            if (currentDomain != null) {
                allowNeverExpiringPassword = currentDomain.getDefAllowNeverExpiringPassword();
                if (currentDomain.getOptAllowNeverExpiringPassword() != null) {
                    allowNeverExpiringPassword = currentDomain.getOptAllowNeverExpiringPassword();
                }
            }
        }
        catch (ConsoleException e1) {
            LoggerUtilities.logException((Throwable)e1);
        }
        return allowNeverExpiringPassword;
    }
}

