/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.v4.render;

import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.rendering.html.HTMLPage;
import com.creamtec.ajaxswing.v4.ComponentGraphics;
import com.creamtec.ajaxswing.v4.render.ComponentRenderer;
import com.creamtec.ajaxswing.v4.utils.ImageUtils;
import com.creamtec.core.TraceMgr;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class SnapshotRenderer
implements Observer,
ComponentRenderer {
    private static final SnapshotRenderer instance = new SnapshotRenderer();

    public static SnapshotRenderer getInstance() {
        return instance;
    }

    public void initialize() {
    }

    public void renderComponent(ComponentGraphics g, Component comp) throws Exception {
        if (comp.getWidth() == 0 || comp.getHeight() == 0) {
            return;
        }
        BufferedImage image = this.generateImage(g.getPage(), comp);
        g.append("<img src=\"");
        g.append(g.getImageUrl(image));
        g.append("\" class=\"SnapshotRenderer\" />");
    }

    public BufferedImage generateIconImage(HTMLPage page, Component comp, Icon icon) throws AjaxSwingException {
        Component bufferComponent;
        int width = icon.getIconWidth();
        String key = "component.";
        key = key + icon.getClass().getName();
        key = key + ".width";
        width = page.getClientAgent().getProps().getIntProperty(key, width);
        int height = icon.getIconHeight();
        BufferedImage offscreenImage = new BufferedImage(width, height, 2);
        if (comp instanceof JCheckBox) {
            bufferComponent = comp;
        } else {
            bufferComponent = new JPanel();
            bufferComponent.setBounds(0, 0, width, height);
            bufferComponent.setForeground(comp.getForeground());
        }
        Graphics2D graphics2D = (Graphics2D)offscreenImage.getGraphics();
        graphics2D.setClip(0, 0, width, height);
        graphics2D.setBackground(new Color(0, 0, 0, 0));
        graphics2D.setColor(new Color(0, 0, 0, 0));
        bufferComponent.setBackground(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, width, height);
        try {
            icon.paintIcon(bufferComponent, graphics2D, 0, 0);
        }
        catch (ClassCastException ex) {
            icon.paintIcon(comp, graphics2D, 0, 0);
        }
        return offscreenImage;
    }

    public String generateIconImageFile(HTMLPage page, BufferedImage image, boolean keepUntilRestart) {
        try {
            String imageName = this.generateIconImageName(page);
            String fileName = this.generateFileName(page, imageName);
            this.writePNGImage(page, fileName, image);
            if (!keepUntilRestart) {
                this.storeAndObserveFile(page, fileName);
            }
            return imageName;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public BufferedImage generateImage(HTMLPage page, Component comp) throws AjaxSwingException {
        BufferedImage offscreenImage = null;
        String format = page.getClientAgent().getWindowProperty(page.getTitle(), "snapshotRenderer.format");
        if (format == null) {
            format = "png";
        }
        if (format != null) {
            offscreenImage = "png".equalsIgnoreCase(format) ? new BufferedImage(comp.getWidth(), comp.getHeight(), 2) : new BufferedImage(comp.getWidth(), comp.getHeight(), 13);
        }
        Graphics2D graphics2D = (Graphics2D)offscreenImage.getGraphics();
        graphics2D.setClip(0, 0, comp.getWidth(), comp.getHeight());
        Color bgColor = this.getBackgroundColor(page, comp);
        if (bgColor != null) {
            graphics2D.setBackground(bgColor);
            graphics2D.clearRect(0, 0, comp.getWidth(), comp.getHeight());
        }
        comp.paint(graphics2D);
        return offscreenImage;
    }

    @Override
    public void update(Observable o, Object arg) {
        TraceMgr.trace((Object)this, (String)"Deleting temporary image files...", (int)6);
        HTMLPage page = (HTMLPage)((Object)o);
        page.deleteObserver(this);
        List fileNames = (List)page.getProps().get("snapshotRenderer.fileNames");
        if (fileNames != null) {
            Iterator i = fileNames.iterator();
            while (i.hasNext()) {
                String fileName = (String)i.next();
                try {
                    File file = new File(fileName);
                    if (!ImageUtils.canDelete(file.getName())) continue;
                    TraceMgr.trace((Object)this, (String)("Deleting file " + fileName), (int)6);
                    file.delete();
                    i.remove();
                }
                catch (Exception x) {
                    TraceMgr.trace((Object)this, (String)("Failed to delete temp file " + fileName), (Throwable)x);
                }
            }
            TraceMgr.trace((Object)this, (String)"Deleted files", (int)6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePNGImage(HTMLPage page, String fileName, BufferedImage image) throws Exception {
        try (FileOutputStream fileStream = null;){
            TraceMgr.trace((Object)this, (String)("Writing component image to file " + fileName), (int)6);
            fileStream = new FileOutputStream(fileName);
            ImageIO.write((RenderedImage)image, "PNG", fileStream);
            TraceMgr.trace((Object)this, (String)"Wrote successfully", (int)6);
        }
    }

    protected String generateFileName(HTMLPage page, String imageName) {
        return page.getClientAgent().getInitData().getTempDirPath() + imageName;
    }

    protected String generateIconImageName(HTMLPage page) throws Exception {
        String suffix = String.valueOf(System.currentTimeMillis());
        suffix = suffix.substring(suffix.length() - 6);
        StringBuffer name = new StringBuffer(100);
        name.append("i");
        name.append(page.getClientAgent().getAppName());
        name.append('_');
        name.append(suffix);
        name.append('_');
        name.append(page.getSnapshotImageIndex());
        page.incSnapshotIndex();
        name.append(".png");
        return name.toString();
    }

    protected Color getBackgroundColor(HTMLPage page, Component comp) {
        String backgroundColor;
        Color bgColor = comp.getBackground();
        if (bgColor == null && (backgroundColor = page.getClientAgent().getWindowProperty(page.getTitle(), "snapshotRenderer.backgroundColor")) != null) {
            if (backgroundColor.length() != 6) {
                throw new AjaxSwingException("Configuration error, color format is RRGGBB in hexdecimal form");
            }
            int r = Integer.parseInt(backgroundColor.substring(0, 2), 16);
            int g = Integer.parseInt(backgroundColor.substring(2, 4), 16);
            int b = Integer.parseInt(backgroundColor.substring(4, 6), 16);
            bgColor = new Color(r, g, b);
        }
        if (bgColor == null) {
            bgColor = Color.WHITE;
        }
        return bgColor;
    }

    private void storeAndObserveFile(HTMLPage page, String fileName) {
        ArrayList<String> fileNames = (ArrayList<String>)page.getProps().get("snapshotRenderer.fileNames");
        if (fileNames == null) {
            fileNames = new ArrayList<String>();
            page.getProps().put("snapshotRenderer.fileNames", fileNames);
            page.addObserver(this);
        }
        fileNames.add(fileName);
    }
}

