/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.v4;

import com.creamtec.ajaxswing.rendering.html.HTMLPage;
import com.creamtec.ajaxswing.v4.utils.FontUtils;
import com.creamtec.ajaxswing.v4.utils.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.IOException;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class HtmlGraphics
extends Graphics2D {
    public static final Font defaultFont = new Font("Dialog", 0, 12);
    protected static final Composite defaultComposite = AlphaComposite.SrcOver;
    protected static final Stroke defaultStroke = new BasicStroke();
    private ImageUtils imageExtractor;
    private boolean outputEnabled = true;
    private final HTMLPage page;

    public HtmlGraphics(HtmlGraphics g) throws IOException {
        this(g.page);
        this.imageExtractor = new ImageUtils(g.page);
    }

    public HtmlGraphics(HTMLPage page) {
        this.page = page;
        this.imageExtractor = new ImageUtils(page);
    }

    public void append(char ch) {
        if (!this.outputEnabled) {
            return;
        }
        this.page.getBody().append(ch);
    }

    public void append(int i) {
        if (!this.outputEnabled) {
            return;
        }
        this.page.getBody().append(i);
    }

    public void append(String s) {
        if (!this.outputEnabled) {
            return;
        }
        this.page.getBody().append(s);
    }

    public void appendFontStyle(Font font) {
        if (!this.outputEnabled || font == null) {
            return;
        }
        this.append(FontUtils.generateFontStyleString(font));
    }

    public void appendHexColor(Color color) {
        if (!this.outputEnabled) {
            return;
        }
        if (color == null) {
            color = Color.BLACK;
        }
        this.appendHexValue(color.getRed());
        this.appendHexValue(color.getGreen());
        this.appendHexValue(color.getBlue());
    }

    public void appendHexValue(int i) {
        if (!this.outputEnabled) {
            return;
        }
        String value = Integer.toHexString(i);
        if (value.length() == 1) {
            this.append("0");
        }
        this.append(value);
    }

    public void appendText(String text) {
        if (!this.outputEnabled) {
            return;
        }
        String html = StringEscapeUtils.escapeHtml(text);
        html = html.replace(" ", "&nbsp;");
        html = html.replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        this.append(html);
    }

    @Override
    public Graphics create() {
        try {
            HtmlGraphics g = (HtmlGraphics)this.getClass().getConstructor(HTMLPage.class).newInstance(new Object[]{this.page});
            g.cloneFrom(this);
            return g;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create graphics", e);
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public Image getImagePart(Image img, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.imageExtractor.getImagePart(img, sx1, sy1, sx2, sy2, observer);
    }

    public String getImageUrl(Image image, boolean keepUntilRestart) {
        return this.imageExtractor.getImageUrl(image, keepUntilRestart);
    }

    public String getImageUrl(Image image) {
        return this.imageExtractor.getImageUrl(image, false);
    }

    public HTMLPage getPage() {
        return this.page;
    }

    protected void cloneFrom(HtmlGraphics g) {
        this.outputEnabled = g.outputEnabled;
    }

    protected boolean isOutputEnabled() {
        return this.outputEnabled;
    }

    protected void setOutputEnabled(boolean outputEnabled) {
        this.outputEnabled = outputEnabled;
    }
}

